/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#ifndef _GNOME_SCAN_JOB_H_
#define _GNOME_SCAN_JOB_H_

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "gnome-scan-settings.h"
#include "gnome-scanner.h"
#include "gnome-scan-sink.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_JOB             (gnome_scan_job_get_type ())
#define GNOME_SCAN_JOB(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_JOB, GnomeScanJob))
#define GNOME_SCAN_JOB_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_JOB, GnomeScanJobClass))
#define GNOME_IS_SCAN_JOB(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_JOB))
#define GNOME_IS_SCAN_JOB_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_JOB))
#define GNOME_SCAN_JOB_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_JOB, GnomeScanJobClass))

typedef struct _GnomeScanJobClass GnomeScanJobClass;
typedef struct _GnomeScanJob GnomeScanJob;

struct _GnomeScanJobClass
{
	GObjectClass parent_class;
};

/**
 * GnomeScanJob:
 * @progress: a fraction indicating the progress of the execution
 * (from 0 to 1)
 * @stage:	a description of the current stage being executed.
 *
 *
 * A #GnomeScanJob object handle the acquisition, processing and
 * outputing of images. Use gnome_scan_job_run() to execute the
 * job. During its execution, the job will fill @progress and @stage
 * in order you to know what he is doing. This way, the main thread
 * can know what the worker thread is doing.
 **/
struct _GnomeScanJob
{
	/*< private >*/
	GObject parent_instance;
	
	gboolean	stop;
	/*< public >*/
	gdouble		progress;
	gchar*		stage;
	gboolean	done;
};

GType		gnome_scan_job_get_type (void) G_GNUC_CONST;
GnomeScanJob*
gnome_scan_job_new (GnomeScanSettings *settings,
					GnomeScanSink *sink);

void		gnome_scan_job_set_settings (GnomeScanJob *job,
										 GnomeScanSettings *settings);
GnomeScanSettings*
			gnome_scan_job_get_settings (GnomeScanJob *job);

void		gnome_scan_job_set_scanner (GnomeScanJob *job,
										GnomeScanner *scanner);
GnomeScanner*
			gnome_scan_job_get_scanner (GnomeScanJob *job);

void		gnome_scan_job_add_processor (GnomeScanJob *job,
										  GnomeScanPlugin *processor);

GSList* 	gnome_scan_job_get_processors (GnomeScanJob *job);

void		gnome_scan_job_set_sink (GnomeScanJob *job,
									 GnomeScanSink *sink);
GnomeScanSink*
			gnome_scan_job_get_sink (GnomeScanJob *job);

void		gnome_scan_job_configure	(GnomeScanJob *job);
void		gnome_scan_job_run			(GnomeScanJob *job);
gboolean	gnome_scan_job_run_once		(GnomeScanJob *job);
void		gnome_scan_job_cancel		(GnomeScanJob *job);

G_END_DECLS

#endif /* _GNOME_SCAN_JOB_H_ */
