# -*- coding: UTF-8 -*-
#
# generated by wxGlade
#

import wx

# begin wxGlade: dependencies
import gettext
# end wxGlade

# begin wxGlade: extracode
from Gnumed.wxpython.gmListWidgets import cReportListCtrl
# end wxGlade


class wxgExportAreaExportToMediaDlg(wx.Dialog):
	def __init__(self, *args, **kwds):
		# begin wxGlade: wxgExportAreaExportToMediaDlg.__init__
		kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE | wx.MAXIMIZE_BOX | wx.MINIMIZE_BOX | wx.RESIZE_BORDER
		wx.Dialog.__init__(self, *args, **kwds)
		self.SetSize((700, 500))
		self._LBL_header = wx.StaticText(self, wx.ID_ANY, _("\nDescribe the intended action.\n"))
		self._BTN_reload_media_list = wx.Button(self, wx.ID_REFRESH, "", style=wx.BU_EXACTFIT)
		self._LCTRL_removable_media = cReportListCtrl(self, wx.ID_ANY, style=wx.BORDER_NONE | wx.LC_HRULES | wx.LC_REPORT | wx.LC_VRULES)
		self._LBL_directory = wx.StaticText(self, wx.ID_ANY, _("<shows default path computed at runtime>"), style=wx.ST_ELLIPSIZE_START)
		self._LBL_dir_is_empty = wx.StaticText(self, wx.ID_ANY, _("this path is/is not empty"))
		self._BTN_open_directory = wx.Button(self, wx.ID_ANY, _("Open"), style=wx.BU_EXACTFIT)
		self._BTN_clear_directory = wx.Button(self, wx.ID_ANY, _("Clear"), style=wx.BU_EXACTFIT)
		self._CHBOX_encrypt = wx.CheckBox(self, wx.ID_ANY, _("en&crypt"), style=wx.CHK_2STATE)
		self._CHBOX_use_subdirectory = wx.CheckBox(self, wx.ID_ANY, _("use subdirectory"), style=wx.CHK_2STATE)
		self._BTN_save2media = wx.Button(self, wx.ID_SAVE, "")
		self._BTN_cancel = wx.Button(self, wx.ID_CANCEL, "")

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_BUTTON, self._on_reload_media_list_button_pressed, self._BTN_reload_media_list)
		self.Bind(wx.EVT_BUTTON, self._on_open_directory_button_pressed, self._BTN_open_directory)
		self.Bind(wx.EVT_BUTTON, self._on_clear_directory_button_pressed, self._BTN_clear_directory)
		self.Bind(wx.EVT_CHECKBOX, self._on_save_as_encrypted_toggled, self._CHBOX_encrypt)
		self.Bind(wx.EVT_CHECKBOX, self._on_use_subdirectory_toggled, self._CHBOX_use_subdirectory)
		self.Bind(wx.EVT_BUTTON, self._on_save2media_button_pressed, self._BTN_save2media)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: wxgExportAreaExportToMediaDlg.__set_properties
		self.SetTitle(_("Creating Patient Media"))
		self.SetSize((700, 500))
		self._BTN_reload_media_list.SetToolTip(_("Reload the list of removable media."))
		self._LBL_directory.SetFont(wx.Font(9, wx.DEFAULT, wx.SLANT, wx.NORMAL, 0, ""))
		self._LBL_dir_is_empty.SetForegroundColour(wx.Colour(255, 127, 0))
		self._LBL_dir_is_empty.SetFont(wx.Font(9, wx.DEFAULT, wx.SLANT, wx.NORMAL, 0, ""))
		self._BTN_open_directory.SetToolTip(_("Open selected target directory in file browser."))
		self._BTN_clear_directory.SetToolTip(_("Clear selected target directory from any existing data."))
		self._BTN_clear_directory.Enable(False)
		self._CHBOX_encrypt.SetToolTip(_("Use encryption ?\n\nYou need to arrange for safely passing any encryption key to receivers of the patient data excerpt yourself.\n\nNote that the *content* of each file will be encrypted - some hints about the patient might potentially still be derivable from the names of files. If you need a completely anonymous patient data excerpt you should use the [Save as] functionality of the export area and create an encrypted archive."))
		self._CHBOX_encrypt.SetValue(1)
		self._CHBOX_use_subdirectory.SetToolTip(_("Use patient specific subdirectory ?\n\nDO NOT USE unless you really know why.\n\nIf checked GNUmed will create a suitable subdirectory on the removable media and save to that."))
		self._BTN_save2media.SetToolTip(_("Save patient data excerpt to the removable media selected above."))
		self._BTN_save2media.Enable(False)
		self._BTN_cancel.SetToolTip(_("Abort saving entries."))
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: wxgExportAreaExportToMediaDlg.__do_layout
		__szr_main = wx.BoxSizer(wx.VERTICAL)
		__szr_buttons = wx.BoxSizer(wx.HORIZONTAL)
		_grszr_options = wx.FlexGridSizer(0, 2, 2, 5)
		__szr_save_as = wx.BoxSizer(wx.HORIZONTAL)
		__szr_dir_state = wx.BoxSizer(wx.HORIZONTAL)
		__szr_removable_media = wx.BoxSizer(wx.HORIZONTAL)
		__szr_main.Add(self._LBL_header, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		__lbl_removable_media = wx.StaticText(self, wx.ID_ANY, _("Removable media"))
		__szr_removable_media.Add(__lbl_removable_media, 0, wx.ALIGN_CENTER_VERTICAL, 3)
		__szr_removable_media.Add((20, 20), 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_removable_media.Add(self._BTN_reload_media_list, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_main.Add(__szr_removable_media, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		__szr_main.Add(self._LCTRL_removable_media, 1, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		__lbl_path = wx.StaticText(self, wx.ID_ANY, _("Path:"))
		_grszr_options.Add(__lbl_path, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		_grszr_options.Add(self._LBL_directory, 1, wx.ALIGN_CENTER_VERTICAL, 5)
		_grszr_options.Add((20, 20), 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_dir_state.Add(self._LBL_dir_is_empty, 0, wx.ALIGN_CENTER | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		__szr_dir_state.Add((20, 20), 2, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_dir_state.Add(self._BTN_open_directory, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		__szr_dir_state.Add(self._BTN_clear_directory, 0, wx.ALIGN_CENTER_VERTICAL, 5)
		_grszr_options.Add(__szr_dir_state, 0, wx.EXPAND, 3)
		__lbl_save_as = wx.StaticText(self, wx.ID_ANY, _("Options:"))
		_grszr_options.Add(__lbl_save_as, 0, wx.ALIGN_CENTER_VERTICAL, 5)
		__szr_save_as.Add(self._CHBOX_encrypt, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		__szr_save_as.Add(self._CHBOX_use_subdirectory, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 10)
		_grszr_options.Add(__szr_save_as, 0, wx.EXPAND, 3)
		_grszr_options.AddGrowableCol(1)
		__szr_main.Add(_grszr_options, 1, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		__hline_bottom = wx.StaticLine(self, wx.ID_ANY)
		__szr_main.Add(__hline_bottom, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		__szr_buttons.Add((20, 20), 2, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_buttons.Add(self._BTN_save2media, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 3)
		__szr_buttons.Add((20, 20), 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_buttons.Add(self._BTN_cancel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_buttons.Add((20, 20), 2, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_main.Add(__szr_buttons, 0, wx.ALL | wx.EXPAND, 3)
		self.SetSizer(__szr_main)
		self.Layout()
		# end wxGlade

	def _on_reload_media_list_button_pressed(self, event):  # wxGlade: wxgExportAreaExportToMediaDlg.<event_handler>
		print("Event handler '_on_reload_media_list_button_pressed' not implemented!")
		event.Skip()

	def _on_open_directory_button_pressed(self, event):  # wxGlade: wxgExportAreaExportToMediaDlg.<event_handler>
		print("Event handler '_on_open_directory_button_pressed' not implemented!")
		event.Skip()

	def _on_clear_directory_button_pressed(self, event):  # wxGlade: wxgExportAreaExportToMediaDlg.<event_handler>
		print("Event handler '_on_clear_directory_button_pressed' not implemented!")
		event.Skip()

	def _on_save_as_encrypted_toggled(self, event):  # wxGlade: wxgExportAreaExportToMediaDlg.<event_handler>
		print("Event handler '_on_save_as_encrypted_toggled' not implemented!")
		event.Skip()

	def _on_use_subdirectory_toggled(self, event):  # wxGlade: wxgExportAreaExportToMediaDlg.<event_handler>
		print("Event handler '_on_use_subdirectory_toggled' not implemented!")
		event.Skip()

	def _on_save2media_button_pressed(self, event):  # wxGlade: wxgExportAreaExportToMediaDlg.<event_handler>
		print("Event handler '_on_save2media_button_pressed' not implemented!")
		event.Skip()

# end of class wxgExportAreaExportToMediaDlg
