// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: runner/v1/services.proto

package runnerv1connect

import (
	v1 "code.gitea.io/actions-proto-go/runner/v1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// RunnerServiceName is the fully-qualified name of the RunnerService service.
	RunnerServiceName = "runner.v1.RunnerService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// RunnerServiceRegisterProcedure is the fully-qualified name of the RunnerService's Register RPC.
	RunnerServiceRegisterProcedure = "/runner.v1.RunnerService/Register"
	// RunnerServiceDeclareProcedure is the fully-qualified name of the RunnerService's Declare RPC.
	RunnerServiceDeclareProcedure = "/runner.v1.RunnerService/Declare"
	// RunnerServiceFetchTaskProcedure is the fully-qualified name of the RunnerService's FetchTask RPC.
	RunnerServiceFetchTaskProcedure = "/runner.v1.RunnerService/FetchTask"
	// RunnerServiceUpdateTaskProcedure is the fully-qualified name of the RunnerService's UpdateTask
	// RPC.
	RunnerServiceUpdateTaskProcedure = "/runner.v1.RunnerService/UpdateTask"
	// RunnerServiceUpdateLogProcedure is the fully-qualified name of the RunnerService's UpdateLog RPC.
	RunnerServiceUpdateLogProcedure = "/runner.v1.RunnerService/UpdateLog"
)

// These variables are the protoreflect.Descriptor objects for the RPCs defined in this package.
var (
	runnerServiceServiceDescriptor          = v1.File_runner_v1_services_proto.Services().ByName("RunnerService")
	runnerServiceRegisterMethodDescriptor   = runnerServiceServiceDescriptor.Methods().ByName("Register")
	runnerServiceDeclareMethodDescriptor    = runnerServiceServiceDescriptor.Methods().ByName("Declare")
	runnerServiceFetchTaskMethodDescriptor  = runnerServiceServiceDescriptor.Methods().ByName("FetchTask")
	runnerServiceUpdateTaskMethodDescriptor = runnerServiceServiceDescriptor.Methods().ByName("UpdateTask")
	runnerServiceUpdateLogMethodDescriptor  = runnerServiceServiceDescriptor.Methods().ByName("UpdateLog")
)

// RunnerServiceClient is a client for the runner.v1.RunnerService service.
type RunnerServiceClient interface {
	// Register register a new runner in server.
	Register(context.Context, *connect.Request[v1.RegisterRequest]) (*connect.Response[v1.RegisterResponse], error)
	// Declare declare runner's version and labels to Gitea before starting fetching task.
	Declare(context.Context, *connect.Request[v1.DeclareRequest]) (*connect.Response[v1.DeclareResponse], error)
	// FetchTask requests the next available task for execution.
	FetchTask(context.Context, *connect.Request[v1.FetchTaskRequest]) (*connect.Response[v1.FetchTaskResponse], error)
	// UpdateTask updates the task status.
	UpdateTask(context.Context, *connect.Request[v1.UpdateTaskRequest]) (*connect.Response[v1.UpdateTaskResponse], error)
	// UpdateLog uploads log of the task.
	UpdateLog(context.Context, *connect.Request[v1.UpdateLogRequest]) (*connect.Response[v1.UpdateLogResponse], error)
}

// NewRunnerServiceClient constructs a client for the runner.v1.RunnerService service. By default,
// it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses, and
// sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC()
// or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewRunnerServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) RunnerServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &runnerServiceClient{
		register: connect.NewClient[v1.RegisterRequest, v1.RegisterResponse](
			httpClient,
			baseURL+RunnerServiceRegisterProcedure,
			connect.WithSchema(runnerServiceRegisterMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
		declare: connect.NewClient[v1.DeclareRequest, v1.DeclareResponse](
			httpClient,
			baseURL+RunnerServiceDeclareProcedure,
			connect.WithSchema(runnerServiceDeclareMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
		fetchTask: connect.NewClient[v1.FetchTaskRequest, v1.FetchTaskResponse](
			httpClient,
			baseURL+RunnerServiceFetchTaskProcedure,
			connect.WithSchema(runnerServiceFetchTaskMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
		updateTask: connect.NewClient[v1.UpdateTaskRequest, v1.UpdateTaskResponse](
			httpClient,
			baseURL+RunnerServiceUpdateTaskProcedure,
			connect.WithSchema(runnerServiceUpdateTaskMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
		updateLog: connect.NewClient[v1.UpdateLogRequest, v1.UpdateLogResponse](
			httpClient,
			baseURL+RunnerServiceUpdateLogProcedure,
			connect.WithSchema(runnerServiceUpdateLogMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
	}
}

// runnerServiceClient implements RunnerServiceClient.
type runnerServiceClient struct {
	register   *connect.Client[v1.RegisterRequest, v1.RegisterResponse]
	declare    *connect.Client[v1.DeclareRequest, v1.DeclareResponse]
	fetchTask  *connect.Client[v1.FetchTaskRequest, v1.FetchTaskResponse]
	updateTask *connect.Client[v1.UpdateTaskRequest, v1.UpdateTaskResponse]
	updateLog  *connect.Client[v1.UpdateLogRequest, v1.UpdateLogResponse]
}

// Register calls runner.v1.RunnerService.Register.
func (c *runnerServiceClient) Register(ctx context.Context, req *connect.Request[v1.RegisterRequest]) (*connect.Response[v1.RegisterResponse], error) {
	return c.register.CallUnary(ctx, req)
}

// Declare calls runner.v1.RunnerService.Declare.
func (c *runnerServiceClient) Declare(ctx context.Context, req *connect.Request[v1.DeclareRequest]) (*connect.Response[v1.DeclareResponse], error) {
	return c.declare.CallUnary(ctx, req)
}

// FetchTask calls runner.v1.RunnerService.FetchTask.
func (c *runnerServiceClient) FetchTask(ctx context.Context, req *connect.Request[v1.FetchTaskRequest]) (*connect.Response[v1.FetchTaskResponse], error) {
	return c.fetchTask.CallUnary(ctx, req)
}

// UpdateTask calls runner.v1.RunnerService.UpdateTask.
func (c *runnerServiceClient) UpdateTask(ctx context.Context, req *connect.Request[v1.UpdateTaskRequest]) (*connect.Response[v1.UpdateTaskResponse], error) {
	return c.updateTask.CallUnary(ctx, req)
}

// UpdateLog calls runner.v1.RunnerService.UpdateLog.
func (c *runnerServiceClient) UpdateLog(ctx context.Context, req *connect.Request[v1.UpdateLogRequest]) (*connect.Response[v1.UpdateLogResponse], error) {
	return c.updateLog.CallUnary(ctx, req)
}

// RunnerServiceHandler is an implementation of the runner.v1.RunnerService service.
type RunnerServiceHandler interface {
	// Register register a new runner in server.
	Register(context.Context, *connect.Request[v1.RegisterRequest]) (*connect.Response[v1.RegisterResponse], error)
	// Declare declare runner's version and labels to Gitea before starting fetching task.
	Declare(context.Context, *connect.Request[v1.DeclareRequest]) (*connect.Response[v1.DeclareResponse], error)
	// FetchTask requests the next available task for execution.
	FetchTask(context.Context, *connect.Request[v1.FetchTaskRequest]) (*connect.Response[v1.FetchTaskResponse], error)
	// UpdateTask updates the task status.
	UpdateTask(context.Context, *connect.Request[v1.UpdateTaskRequest]) (*connect.Response[v1.UpdateTaskResponse], error)
	// UpdateLog uploads log of the task.
	UpdateLog(context.Context, *connect.Request[v1.UpdateLogRequest]) (*connect.Response[v1.UpdateLogResponse], error)
}

// NewRunnerServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewRunnerServiceHandler(svc RunnerServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	runnerServiceRegisterHandler := connect.NewUnaryHandler(
		RunnerServiceRegisterProcedure,
		svc.Register,
		connect.WithSchema(runnerServiceRegisterMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	runnerServiceDeclareHandler := connect.NewUnaryHandler(
		RunnerServiceDeclareProcedure,
		svc.Declare,
		connect.WithSchema(runnerServiceDeclareMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	runnerServiceFetchTaskHandler := connect.NewUnaryHandler(
		RunnerServiceFetchTaskProcedure,
		svc.FetchTask,
		connect.WithSchema(runnerServiceFetchTaskMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	runnerServiceUpdateTaskHandler := connect.NewUnaryHandler(
		RunnerServiceUpdateTaskProcedure,
		svc.UpdateTask,
		connect.WithSchema(runnerServiceUpdateTaskMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	runnerServiceUpdateLogHandler := connect.NewUnaryHandler(
		RunnerServiceUpdateLogProcedure,
		svc.UpdateLog,
		connect.WithSchema(runnerServiceUpdateLogMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	return "/runner.v1.RunnerService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case RunnerServiceRegisterProcedure:
			runnerServiceRegisterHandler.ServeHTTP(w, r)
		case RunnerServiceDeclareProcedure:
			runnerServiceDeclareHandler.ServeHTTP(w, r)
		case RunnerServiceFetchTaskProcedure:
			runnerServiceFetchTaskHandler.ServeHTTP(w, r)
		case RunnerServiceUpdateTaskProcedure:
			runnerServiceUpdateTaskHandler.ServeHTTP(w, r)
		case RunnerServiceUpdateLogProcedure:
			runnerServiceUpdateLogHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedRunnerServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedRunnerServiceHandler struct{}

func (UnimplementedRunnerServiceHandler) Register(context.Context, *connect.Request[v1.RegisterRequest]) (*connect.Response[v1.RegisterResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("runner.v1.RunnerService.Register is not implemented"))
}

func (UnimplementedRunnerServiceHandler) Declare(context.Context, *connect.Request[v1.DeclareRequest]) (*connect.Response[v1.DeclareResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("runner.v1.RunnerService.Declare is not implemented"))
}

func (UnimplementedRunnerServiceHandler) FetchTask(context.Context, *connect.Request[v1.FetchTaskRequest]) (*connect.Response[v1.FetchTaskResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("runner.v1.RunnerService.FetchTask is not implemented"))
}

func (UnimplementedRunnerServiceHandler) UpdateTask(context.Context, *connect.Request[v1.UpdateTaskRequest]) (*connect.Response[v1.UpdateTaskResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("runner.v1.RunnerService.UpdateTask is not implemented"))
}

func (UnimplementedRunnerServiceHandler) UpdateLog(context.Context, *connect.Request[v1.UpdateLogRequest]) (*connect.Response[v1.UpdateLogResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("runner.v1.RunnerService.UpdateLog is not implemented"))
}
