// Code generated by gocc; DO NOT EDIT.

package token

import (
	"fmt"
)

type Token struct {
	Type
	Lit []byte
	Pos
}

type Type int

const (
	INVALID Type = iota
	EOF
)

type Pos struct {
	Offset int
	Line   int
	Column int
}

func (p Pos) String() string {
	return fmt.Sprintf("Pos(offset=%d, line=%d, column=%d)", p.Offset, p.Line, p.Column)
}

type TokenMap struct {
	typeMap []string
	idMap   map[string]Type
}

func (m TokenMap) Id(tok Type) string {
	if int(tok) < len(m.typeMap) {
		return m.typeMap[tok]
	}
	return "unknown"
}

func (m TokenMap) Type(tok string) Type {
	if typ, exist := m.idMap[tok]; exist {
		return typ
	}
	return INVALID
}

func (m TokenMap) TokenString(tok *Token) string {
	//TODO: refactor to print pos & token string properly
	return fmt.Sprintf("%s(%d,%s)", m.Id(tok.Type), tok.Type, tok.Lit)
}

func (m TokenMap) StringType(typ Type) string {
	return fmt.Sprintf("%s(%d)", m.Id(typ), typ)
}

var TokMap = TokenMap{
	typeMap: []string{
		"INVALID",
		"$",
		"graphx",
		"{",
		"}",
		"strict",
		"digraph",
		";",
		"=",
		"node",
		"edge",
		"[",
		"]",
		",",
		":",
		"subgraph",
		"->",
		"--",
		"id",
	},

	idMap: map[string]Type{
		"INVALID":  0,
		"$":        1,
		"graphx":   2,
		"{":        3,
		"}":        4,
		"strict":   5,
		"digraph":  6,
		";":        7,
		"=":        8,
		"node":     9,
		"edge":     10,
		"[":        11,
		"]":        12,
		",":        13,
		":":        14,
		"subgraph": 15,
		"->":       16,
		"--":       17,
		"id":       18,
	},
}
