// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package networkmanageriface provides an interface to enable mocking the AWS Network Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package networkmanageriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/networkmanager"
)

// NetworkManagerAPI provides an interface to enable mocking the
// networkmanager.NetworkManager service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Network Manager.
//    func myFunc(svc networkmanageriface.NetworkManagerAPI) bool {
//        // Make svc.AssociateCustomerGateway request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := networkmanager.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockNetworkManagerClient struct {
//        networkmanageriface.NetworkManagerAPI
//    }
//    func (m *mockNetworkManagerClient) AssociateCustomerGateway(input *networkmanager.AssociateCustomerGatewayInput) (*networkmanager.AssociateCustomerGatewayOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockNetworkManagerClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type NetworkManagerAPI interface {
	AssociateCustomerGateway(*networkmanager.AssociateCustomerGatewayInput) (*networkmanager.AssociateCustomerGatewayOutput, error)
	AssociateCustomerGatewayWithContext(aws.Context, *networkmanager.AssociateCustomerGatewayInput, ...request.Option) (*networkmanager.AssociateCustomerGatewayOutput, error)
	AssociateCustomerGatewayRequest(*networkmanager.AssociateCustomerGatewayInput) (*request.Request, *networkmanager.AssociateCustomerGatewayOutput)

	AssociateLink(*networkmanager.AssociateLinkInput) (*networkmanager.AssociateLinkOutput, error)
	AssociateLinkWithContext(aws.Context, *networkmanager.AssociateLinkInput, ...request.Option) (*networkmanager.AssociateLinkOutput, error)
	AssociateLinkRequest(*networkmanager.AssociateLinkInput) (*request.Request, *networkmanager.AssociateLinkOutput)

	CreateDevice(*networkmanager.CreateDeviceInput) (*networkmanager.CreateDeviceOutput, error)
	CreateDeviceWithContext(aws.Context, *networkmanager.CreateDeviceInput, ...request.Option) (*networkmanager.CreateDeviceOutput, error)
	CreateDeviceRequest(*networkmanager.CreateDeviceInput) (*request.Request, *networkmanager.CreateDeviceOutput)

	CreateGlobalNetwork(*networkmanager.CreateGlobalNetworkInput) (*networkmanager.CreateGlobalNetworkOutput, error)
	CreateGlobalNetworkWithContext(aws.Context, *networkmanager.CreateGlobalNetworkInput, ...request.Option) (*networkmanager.CreateGlobalNetworkOutput, error)
	CreateGlobalNetworkRequest(*networkmanager.CreateGlobalNetworkInput) (*request.Request, *networkmanager.CreateGlobalNetworkOutput)

	CreateLink(*networkmanager.CreateLinkInput) (*networkmanager.CreateLinkOutput, error)
	CreateLinkWithContext(aws.Context, *networkmanager.CreateLinkInput, ...request.Option) (*networkmanager.CreateLinkOutput, error)
	CreateLinkRequest(*networkmanager.CreateLinkInput) (*request.Request, *networkmanager.CreateLinkOutput)

	CreateSite(*networkmanager.CreateSiteInput) (*networkmanager.CreateSiteOutput, error)
	CreateSiteWithContext(aws.Context, *networkmanager.CreateSiteInput, ...request.Option) (*networkmanager.CreateSiteOutput, error)
	CreateSiteRequest(*networkmanager.CreateSiteInput) (*request.Request, *networkmanager.CreateSiteOutput)

	DeleteDevice(*networkmanager.DeleteDeviceInput) (*networkmanager.DeleteDeviceOutput, error)
	DeleteDeviceWithContext(aws.Context, *networkmanager.DeleteDeviceInput, ...request.Option) (*networkmanager.DeleteDeviceOutput, error)
	DeleteDeviceRequest(*networkmanager.DeleteDeviceInput) (*request.Request, *networkmanager.DeleteDeviceOutput)

	DeleteGlobalNetwork(*networkmanager.DeleteGlobalNetworkInput) (*networkmanager.DeleteGlobalNetworkOutput, error)
	DeleteGlobalNetworkWithContext(aws.Context, *networkmanager.DeleteGlobalNetworkInput, ...request.Option) (*networkmanager.DeleteGlobalNetworkOutput, error)
	DeleteGlobalNetworkRequest(*networkmanager.DeleteGlobalNetworkInput) (*request.Request, *networkmanager.DeleteGlobalNetworkOutput)

	DeleteLink(*networkmanager.DeleteLinkInput) (*networkmanager.DeleteLinkOutput, error)
	DeleteLinkWithContext(aws.Context, *networkmanager.DeleteLinkInput, ...request.Option) (*networkmanager.DeleteLinkOutput, error)
	DeleteLinkRequest(*networkmanager.DeleteLinkInput) (*request.Request, *networkmanager.DeleteLinkOutput)

	DeleteSite(*networkmanager.DeleteSiteInput) (*networkmanager.DeleteSiteOutput, error)
	DeleteSiteWithContext(aws.Context, *networkmanager.DeleteSiteInput, ...request.Option) (*networkmanager.DeleteSiteOutput, error)
	DeleteSiteRequest(*networkmanager.DeleteSiteInput) (*request.Request, *networkmanager.DeleteSiteOutput)

	DeregisterTransitGateway(*networkmanager.DeregisterTransitGatewayInput) (*networkmanager.DeregisterTransitGatewayOutput, error)
	DeregisterTransitGatewayWithContext(aws.Context, *networkmanager.DeregisterTransitGatewayInput, ...request.Option) (*networkmanager.DeregisterTransitGatewayOutput, error)
	DeregisterTransitGatewayRequest(*networkmanager.DeregisterTransitGatewayInput) (*request.Request, *networkmanager.DeregisterTransitGatewayOutput)

	DescribeGlobalNetworks(*networkmanager.DescribeGlobalNetworksInput) (*networkmanager.DescribeGlobalNetworksOutput, error)
	DescribeGlobalNetworksWithContext(aws.Context, *networkmanager.DescribeGlobalNetworksInput, ...request.Option) (*networkmanager.DescribeGlobalNetworksOutput, error)
	DescribeGlobalNetworksRequest(*networkmanager.DescribeGlobalNetworksInput) (*request.Request, *networkmanager.DescribeGlobalNetworksOutput)

	DescribeGlobalNetworksPages(*networkmanager.DescribeGlobalNetworksInput, func(*networkmanager.DescribeGlobalNetworksOutput, bool) bool) error
	DescribeGlobalNetworksPagesWithContext(aws.Context, *networkmanager.DescribeGlobalNetworksInput, func(*networkmanager.DescribeGlobalNetworksOutput, bool) bool, ...request.Option) error

	DisassociateCustomerGateway(*networkmanager.DisassociateCustomerGatewayInput) (*networkmanager.DisassociateCustomerGatewayOutput, error)
	DisassociateCustomerGatewayWithContext(aws.Context, *networkmanager.DisassociateCustomerGatewayInput, ...request.Option) (*networkmanager.DisassociateCustomerGatewayOutput, error)
	DisassociateCustomerGatewayRequest(*networkmanager.DisassociateCustomerGatewayInput) (*request.Request, *networkmanager.DisassociateCustomerGatewayOutput)

	DisassociateLink(*networkmanager.DisassociateLinkInput) (*networkmanager.DisassociateLinkOutput, error)
	DisassociateLinkWithContext(aws.Context, *networkmanager.DisassociateLinkInput, ...request.Option) (*networkmanager.DisassociateLinkOutput, error)
	DisassociateLinkRequest(*networkmanager.DisassociateLinkInput) (*request.Request, *networkmanager.DisassociateLinkOutput)

	GetCustomerGatewayAssociations(*networkmanager.GetCustomerGatewayAssociationsInput) (*networkmanager.GetCustomerGatewayAssociationsOutput, error)
	GetCustomerGatewayAssociationsWithContext(aws.Context, *networkmanager.GetCustomerGatewayAssociationsInput, ...request.Option) (*networkmanager.GetCustomerGatewayAssociationsOutput, error)
	GetCustomerGatewayAssociationsRequest(*networkmanager.GetCustomerGatewayAssociationsInput) (*request.Request, *networkmanager.GetCustomerGatewayAssociationsOutput)

	GetCustomerGatewayAssociationsPages(*networkmanager.GetCustomerGatewayAssociationsInput, func(*networkmanager.GetCustomerGatewayAssociationsOutput, bool) bool) error
	GetCustomerGatewayAssociationsPagesWithContext(aws.Context, *networkmanager.GetCustomerGatewayAssociationsInput, func(*networkmanager.GetCustomerGatewayAssociationsOutput, bool) bool, ...request.Option) error

	GetDevices(*networkmanager.GetDevicesInput) (*networkmanager.GetDevicesOutput, error)
	GetDevicesWithContext(aws.Context, *networkmanager.GetDevicesInput, ...request.Option) (*networkmanager.GetDevicesOutput, error)
	GetDevicesRequest(*networkmanager.GetDevicesInput) (*request.Request, *networkmanager.GetDevicesOutput)

	GetDevicesPages(*networkmanager.GetDevicesInput, func(*networkmanager.GetDevicesOutput, bool) bool) error
	GetDevicesPagesWithContext(aws.Context, *networkmanager.GetDevicesInput, func(*networkmanager.GetDevicesOutput, bool) bool, ...request.Option) error

	GetLinkAssociations(*networkmanager.GetLinkAssociationsInput) (*networkmanager.GetLinkAssociationsOutput, error)
	GetLinkAssociationsWithContext(aws.Context, *networkmanager.GetLinkAssociationsInput, ...request.Option) (*networkmanager.GetLinkAssociationsOutput, error)
	GetLinkAssociationsRequest(*networkmanager.GetLinkAssociationsInput) (*request.Request, *networkmanager.GetLinkAssociationsOutput)

	GetLinkAssociationsPages(*networkmanager.GetLinkAssociationsInput, func(*networkmanager.GetLinkAssociationsOutput, bool) bool) error
	GetLinkAssociationsPagesWithContext(aws.Context, *networkmanager.GetLinkAssociationsInput, func(*networkmanager.GetLinkAssociationsOutput, bool) bool, ...request.Option) error

	GetLinks(*networkmanager.GetLinksInput) (*networkmanager.GetLinksOutput, error)
	GetLinksWithContext(aws.Context, *networkmanager.GetLinksInput, ...request.Option) (*networkmanager.GetLinksOutput, error)
	GetLinksRequest(*networkmanager.GetLinksInput) (*request.Request, *networkmanager.GetLinksOutput)

	GetLinksPages(*networkmanager.GetLinksInput, func(*networkmanager.GetLinksOutput, bool) bool) error
	GetLinksPagesWithContext(aws.Context, *networkmanager.GetLinksInput, func(*networkmanager.GetLinksOutput, bool) bool, ...request.Option) error

	GetSites(*networkmanager.GetSitesInput) (*networkmanager.GetSitesOutput, error)
	GetSitesWithContext(aws.Context, *networkmanager.GetSitesInput, ...request.Option) (*networkmanager.GetSitesOutput, error)
	GetSitesRequest(*networkmanager.GetSitesInput) (*request.Request, *networkmanager.GetSitesOutput)

	GetSitesPages(*networkmanager.GetSitesInput, func(*networkmanager.GetSitesOutput, bool) bool) error
	GetSitesPagesWithContext(aws.Context, *networkmanager.GetSitesInput, func(*networkmanager.GetSitesOutput, bool) bool, ...request.Option) error

	GetTransitGatewayRegistrations(*networkmanager.GetTransitGatewayRegistrationsInput) (*networkmanager.GetTransitGatewayRegistrationsOutput, error)
	GetTransitGatewayRegistrationsWithContext(aws.Context, *networkmanager.GetTransitGatewayRegistrationsInput, ...request.Option) (*networkmanager.GetTransitGatewayRegistrationsOutput, error)
	GetTransitGatewayRegistrationsRequest(*networkmanager.GetTransitGatewayRegistrationsInput) (*request.Request, *networkmanager.GetTransitGatewayRegistrationsOutput)

	GetTransitGatewayRegistrationsPages(*networkmanager.GetTransitGatewayRegistrationsInput, func(*networkmanager.GetTransitGatewayRegistrationsOutput, bool) bool) error
	GetTransitGatewayRegistrationsPagesWithContext(aws.Context, *networkmanager.GetTransitGatewayRegistrationsInput, func(*networkmanager.GetTransitGatewayRegistrationsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*networkmanager.ListTagsForResourceInput) (*networkmanager.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *networkmanager.ListTagsForResourceInput, ...request.Option) (*networkmanager.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*networkmanager.ListTagsForResourceInput) (*request.Request, *networkmanager.ListTagsForResourceOutput)

	RegisterTransitGateway(*networkmanager.RegisterTransitGatewayInput) (*networkmanager.RegisterTransitGatewayOutput, error)
	RegisterTransitGatewayWithContext(aws.Context, *networkmanager.RegisterTransitGatewayInput, ...request.Option) (*networkmanager.RegisterTransitGatewayOutput, error)
	RegisterTransitGatewayRequest(*networkmanager.RegisterTransitGatewayInput) (*request.Request, *networkmanager.RegisterTransitGatewayOutput)

	TagResource(*networkmanager.TagResourceInput) (*networkmanager.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *networkmanager.TagResourceInput, ...request.Option) (*networkmanager.TagResourceOutput, error)
	TagResourceRequest(*networkmanager.TagResourceInput) (*request.Request, *networkmanager.TagResourceOutput)

	UntagResource(*networkmanager.UntagResourceInput) (*networkmanager.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *networkmanager.UntagResourceInput, ...request.Option) (*networkmanager.UntagResourceOutput, error)
	UntagResourceRequest(*networkmanager.UntagResourceInput) (*request.Request, *networkmanager.UntagResourceOutput)

	UpdateDevice(*networkmanager.UpdateDeviceInput) (*networkmanager.UpdateDeviceOutput, error)
	UpdateDeviceWithContext(aws.Context, *networkmanager.UpdateDeviceInput, ...request.Option) (*networkmanager.UpdateDeviceOutput, error)
	UpdateDeviceRequest(*networkmanager.UpdateDeviceInput) (*request.Request, *networkmanager.UpdateDeviceOutput)

	UpdateGlobalNetwork(*networkmanager.UpdateGlobalNetworkInput) (*networkmanager.UpdateGlobalNetworkOutput, error)
	UpdateGlobalNetworkWithContext(aws.Context, *networkmanager.UpdateGlobalNetworkInput, ...request.Option) (*networkmanager.UpdateGlobalNetworkOutput, error)
	UpdateGlobalNetworkRequest(*networkmanager.UpdateGlobalNetworkInput) (*request.Request, *networkmanager.UpdateGlobalNetworkOutput)

	UpdateLink(*networkmanager.UpdateLinkInput) (*networkmanager.UpdateLinkOutput, error)
	UpdateLinkWithContext(aws.Context, *networkmanager.UpdateLinkInput, ...request.Option) (*networkmanager.UpdateLinkOutput, error)
	UpdateLinkRequest(*networkmanager.UpdateLinkInput) (*request.Request, *networkmanager.UpdateLinkOutput)

	UpdateSite(*networkmanager.UpdateSiteInput) (*networkmanager.UpdateSiteOutput, error)
	UpdateSiteWithContext(aws.Context, *networkmanager.UpdateSiteInput, ...request.Option) (*networkmanager.UpdateSiteOutput, error)
	UpdateSiteRequest(*networkmanager.UpdateSiteInput) (*request.Request, *networkmanager.UpdateSiteOutput)
}

var _ NetworkManagerAPI = (*networkmanager.NetworkManager)(nil)
