// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudfrontkeyvaluestoreiface provides an interface to enable mocking the Amazon CloudFront KeyValueStore service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudfrontkeyvaluestoreiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/cloudfrontkeyvaluestore"
)

// CloudFrontKeyValueStoreAPI provides an interface to enable mocking the
// cloudfrontkeyvaluestore.CloudFrontKeyValueStore service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon CloudFront KeyValueStore.
//	func myFunc(svc cloudfrontkeyvaluestoreiface.CloudFrontKeyValueStoreAPI) bool {
//	    // Make svc.DeleteKey request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := cloudfrontkeyvaluestore.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockCloudFrontKeyValueStoreClient struct {
//	    cloudfrontkeyvaluestoreiface.CloudFrontKeyValueStoreAPI
//	}
//	func (m *mockCloudFrontKeyValueStoreClient) DeleteKey(input *cloudfrontkeyvaluestore.DeleteKeyInput) (*cloudfrontkeyvaluestore.DeleteKeyOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockCloudFrontKeyValueStoreClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CloudFrontKeyValueStoreAPI interface {
	DeleteKey(*cloudfrontkeyvaluestore.DeleteKeyInput) (*cloudfrontkeyvaluestore.DeleteKeyOutput, error)
	DeleteKeyWithContext(aws.Context, *cloudfrontkeyvaluestore.DeleteKeyInput, ...request.Option) (*cloudfrontkeyvaluestore.DeleteKeyOutput, error)
	DeleteKeyRequest(*cloudfrontkeyvaluestore.DeleteKeyInput) (*request.Request, *cloudfrontkeyvaluestore.DeleteKeyOutput)

	DescribeKeyValueStore(*cloudfrontkeyvaluestore.DescribeKeyValueStoreInput) (*cloudfrontkeyvaluestore.DescribeKeyValueStoreOutput, error)
	DescribeKeyValueStoreWithContext(aws.Context, *cloudfrontkeyvaluestore.DescribeKeyValueStoreInput, ...request.Option) (*cloudfrontkeyvaluestore.DescribeKeyValueStoreOutput, error)
	DescribeKeyValueStoreRequest(*cloudfrontkeyvaluestore.DescribeKeyValueStoreInput) (*request.Request, *cloudfrontkeyvaluestore.DescribeKeyValueStoreOutput)

	GetKey(*cloudfrontkeyvaluestore.GetKeyInput) (*cloudfrontkeyvaluestore.GetKeyOutput, error)
	GetKeyWithContext(aws.Context, *cloudfrontkeyvaluestore.GetKeyInput, ...request.Option) (*cloudfrontkeyvaluestore.GetKeyOutput, error)
	GetKeyRequest(*cloudfrontkeyvaluestore.GetKeyInput) (*request.Request, *cloudfrontkeyvaluestore.GetKeyOutput)

	ListKeys(*cloudfrontkeyvaluestore.ListKeysInput) (*cloudfrontkeyvaluestore.ListKeysOutput, error)
	ListKeysWithContext(aws.Context, *cloudfrontkeyvaluestore.ListKeysInput, ...request.Option) (*cloudfrontkeyvaluestore.ListKeysOutput, error)
	ListKeysRequest(*cloudfrontkeyvaluestore.ListKeysInput) (*request.Request, *cloudfrontkeyvaluestore.ListKeysOutput)

	ListKeysPages(*cloudfrontkeyvaluestore.ListKeysInput, func(*cloudfrontkeyvaluestore.ListKeysOutput, bool) bool) error
	ListKeysPagesWithContext(aws.Context, *cloudfrontkeyvaluestore.ListKeysInput, func(*cloudfrontkeyvaluestore.ListKeysOutput, bool) bool, ...request.Option) error

	PutKey(*cloudfrontkeyvaluestore.PutKeyInput) (*cloudfrontkeyvaluestore.PutKeyOutput, error)
	PutKeyWithContext(aws.Context, *cloudfrontkeyvaluestore.PutKeyInput, ...request.Option) (*cloudfrontkeyvaluestore.PutKeyOutput, error)
	PutKeyRequest(*cloudfrontkeyvaluestore.PutKeyInput) (*request.Request, *cloudfrontkeyvaluestore.PutKeyOutput)

	UpdateKeys(*cloudfrontkeyvaluestore.UpdateKeysInput) (*cloudfrontkeyvaluestore.UpdateKeysOutput, error)
	UpdateKeysWithContext(aws.Context, *cloudfrontkeyvaluestore.UpdateKeysInput, ...request.Option) (*cloudfrontkeyvaluestore.UpdateKeysOutput, error)
	UpdateKeysRequest(*cloudfrontkeyvaluestore.UpdateKeysInput) (*request.Request, *cloudfrontkeyvaluestore.UpdateKeysOutput)
}

var _ CloudFrontKeyValueStoreAPI = (*cloudfrontkeyvaluestore.CloudFrontKeyValueStore)(nil)
