// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package computervision

import original "github.com/Azure/azure-sdk-for-go/services/preview/cognitiveservices/v3.0-preview/computervision"

type OcrDetectionLanguage = original.OcrDetectionLanguage

const (
	En OcrDetectionLanguage = original.En
	Es OcrDetectionLanguage = original.Es
)

type OperationStatusCodes = original.OperationStatusCodes

const (
	Failed     OperationStatusCodes = original.Failed
	NotStarted OperationStatusCodes = original.NotStarted
	Running    OperationStatusCodes = original.Running
	Succeeded  OperationStatusCodes = original.Succeeded
)

type TextRecognitionResultDimensionUnit = original.TextRecognitionResultDimensionUnit

const (
	Inch  TextRecognitionResultDimensionUnit = original.Inch
	Pixel TextRecognitionResultDimensionUnit = original.Pixel
)

type AnalyzeResults = original.AnalyzeResults
type BaseClient = original.BaseClient
type Error = original.Error
type ImageURL = original.ImageURL
type Line = original.Line
type ReadOperationResult = original.ReadOperationResult
type ReadResult = original.ReadResult
type Word = original.Word

func New(endpoint string) BaseClient {
	return original.New(endpoint)
}
func NewWithoutDefaults(endpoint string) BaseClient {
	return original.NewWithoutDefaults(endpoint)
}
func PossibleOcrDetectionLanguageValues() []OcrDetectionLanguage {
	return original.PossibleOcrDetectionLanguageValues()
}
func PossibleOperationStatusCodesValues() []OperationStatusCodes {
	return original.PossibleOperationStatusCodesValues()
}
func PossibleTextRecognitionResultDimensionUnitValues() []TextRecognitionResultDimensionUnit {
	return original.PossibleTextRecognitionResultDimensionUnitValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
