package logicapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/logic/mgmt/2015-08-01-preview/logic"
	"github.com/Azure/go-autorest/autorest"
)

// IntegrationAccountsClientAPI contains the set of methods on the IntegrationAccountsClient type.
type IntegrationAccountsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, integrationAccountName string, integrationAccount logic.IntegrationAccount) (result logic.IntegrationAccount, err error)
	Delete(ctx context.Context, resourceGroupName string, integrationAccountName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, integrationAccountName string) (result logic.IntegrationAccount, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, top *int32) (result logic.IntegrationAccountListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, top *int32) (result logic.IntegrationAccountListResultIterator, err error)
	ListBySubscription(ctx context.Context, top *int32) (result logic.IntegrationAccountListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context, top *int32) (result logic.IntegrationAccountListResultIterator, err error)
	ListCallbackURL(ctx context.Context, resourceGroupName string, integrationAccountName string, parameters logic.ListCallbackURLParameters) (result logic.CallbackURL, err error)
	Update(ctx context.Context, resourceGroupName string, integrationAccountName string, integrationAccount logic.IntegrationAccount) (result logic.IntegrationAccount, err error)
}

var _ IntegrationAccountsClientAPI = (*logic.IntegrationAccountsClient)(nil)

// IntegrationAccountSchemasClientAPI contains the set of methods on the IntegrationAccountSchemasClient type.
type IntegrationAccountSchemasClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, integrationAccountName string, schemaName string, schema logic.IntegrationAccountSchema) (result logic.IntegrationAccountSchema, err error)
	Delete(ctx context.Context, resourceGroupName string, integrationAccountName string, schemaName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, integrationAccountName string, schemaName string) (result logic.IntegrationAccountSchema, err error)
	List(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result logic.IntegrationAccountSchemaListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result logic.IntegrationAccountSchemaListResultIterator, err error)
}

var _ IntegrationAccountSchemasClientAPI = (*logic.IntegrationAccountSchemasClient)(nil)

// IntegrationAccountMapsClientAPI contains the set of methods on the IntegrationAccountMapsClient type.
type IntegrationAccountMapsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, integrationAccountName string, mapName string, mapParameter logic.IntegrationAccountMap) (result logic.IntegrationAccountMap, err error)
	Delete(ctx context.Context, resourceGroupName string, integrationAccountName string, mapName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, integrationAccountName string, mapName string) (result logic.IntegrationAccountMap, err error)
	List(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result logic.IntegrationAccountMapListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result logic.IntegrationAccountMapListResultIterator, err error)
}

var _ IntegrationAccountMapsClientAPI = (*logic.IntegrationAccountMapsClient)(nil)

// IntegrationAccountPartnersClientAPI contains the set of methods on the IntegrationAccountPartnersClient type.
type IntegrationAccountPartnersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, integrationAccountName string, partnerName string, partner logic.IntegrationAccountPartner) (result logic.IntegrationAccountPartner, err error)
	Delete(ctx context.Context, resourceGroupName string, integrationAccountName string, partnerName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, integrationAccountName string, partnerName string) (result logic.IntegrationAccountPartner, err error)
	List(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result logic.IntegrationAccountPartnerListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result logic.IntegrationAccountPartnerListResultIterator, err error)
}

var _ IntegrationAccountPartnersClientAPI = (*logic.IntegrationAccountPartnersClient)(nil)

// IntegrationAccountAgreementsClientAPI contains the set of methods on the IntegrationAccountAgreementsClient type.
type IntegrationAccountAgreementsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string, agreement logic.IntegrationAccountAgreement) (result logic.IntegrationAccountAgreement, err error)
	Delete(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string) (result logic.IntegrationAccountAgreement, err error)
	List(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result logic.IntegrationAccountAgreementListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result logic.IntegrationAccountAgreementListResultIterator, err error)
}

var _ IntegrationAccountAgreementsClientAPI = (*logic.IntegrationAccountAgreementsClient)(nil)

// IntegrationAccountCertificatesClientAPI contains the set of methods on the IntegrationAccountCertificatesClient type.
type IntegrationAccountCertificatesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, integrationAccountName string, certificateName string, certificate logic.IntegrationAccountCertificate) (result logic.IntegrationAccountCertificate, err error)
	Delete(ctx context.Context, resourceGroupName string, integrationAccountName string, certificateName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, integrationAccountName string, certificateName string) (result logic.IntegrationAccountCertificate, err error)
	List(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32) (result logic.IntegrationAccountCertificateListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32) (result logic.IntegrationAccountCertificateListResultIterator, err error)
}

var _ IntegrationAccountCertificatesClientAPI = (*logic.IntegrationAccountCertificatesClient)(nil)
