// Package localsearch implements the Azure ARM Localsearch service API version 1.0.
//
// The Local Search client lets you send a search query to Bing and get back search results that include local
// businesses such as restaurants, hotels, retail stores, or other local businesses. The query can specify the name of
// the local business or it can ask for a list (for example, restaurants near me).
package localsearch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultBaseURI is the default URI used for the service Localsearch
	DefaultBaseURI = "https://api.cognitive.microsoft.com/bing"
)

// BaseClient is the base client for Localsearch.
type BaseClient struct {
	autorest.Client
	BaseURI string
}

// New creates an instance of the BaseClient client.
func New() BaseClient {
	return NewWithBaseURI(DefaultBaseURI)
}

// NewWithBaseURI creates an instance of the BaseClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWithBaseURI(baseURI string) BaseClient {
	return BaseClient{
		Client:  autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI: baseURI,
	}
}
