package resourceconnector

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/resourceconnector/mgmt/2021-10-31-preview/resourceconnector"

// Appliance appliances definition.
type Appliance struct {
	autorest.Response `json:"-"`
	// Identity - Identity for the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ApplianceProperties - The set of properties specific to an Appliance
	*ApplianceProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Appliance.
func (a Appliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.ApplianceProperties != nil {
		objectMap["properties"] = a.ApplianceProperties
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Appliance struct.
func (a *Appliance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "properties":
			if v != nil {
				var applianceProperties ApplianceProperties
				err = json.Unmarshal(*v, &applianceProperties)
				if err != nil {
					return err
				}
				a.ApplianceProperties = &applianceProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				a.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// ApplianceCredentialKubeconfig cluster User Credential appliance.
type ApplianceCredentialKubeconfig struct {
	// Name - READ-ONLY; Name which contains the role of the kubeconfig. Possible values include: 'AccessProfileTypeClusterUser'
	Name AccessProfileType `json:"name,omitempty"`
	// Value - READ-ONLY; Contains the kubeconfig value.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplianceCredentialKubeconfig.
func (ack ApplianceCredentialKubeconfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplianceListCredentialResults the List Cluster User Credential appliance.
type ApplianceListCredentialResults struct {
	autorest.Response `json:"-"`
	// HybridConnectionConfig - READ-ONLY; Contains the REP (rendezvous endpoint) and “Listener” access token from notification service (NS).
	HybridConnectionConfig *HybridConnectionConfig `json:"hybridConnectionConfig,omitempty"`
	// Kubeconfigs - READ-ONLY; The list of appliance kubeconfigs.
	Kubeconfigs *[]ApplianceCredentialKubeconfig `json:"kubeconfigs,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplianceListCredentialResults.
func (alcr ApplianceListCredentialResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplianceListResult the List Appliances operation response.
type ApplianceListResult struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; The list of Appliances.
	Value *[]Appliance `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplianceListResult.
func (alr ApplianceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplianceListResultIterator provides access to a complete listing of Appliance values.
type ApplianceListResultIterator struct {
	i    int
	page ApplianceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplianceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplianceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplianceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplianceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplianceListResultIterator) Response() ApplianceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplianceListResultIterator) Value() Appliance {
	if !iter.page.NotDone() {
		return Appliance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplianceListResultIterator type.
func NewApplianceListResultIterator(page ApplianceListResultPage) ApplianceListResultIterator {
	return ApplianceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplianceListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr ApplianceListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// applianceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplianceListResult) applianceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// ApplianceListResultPage contains a page of Appliance values.
type ApplianceListResultPage struct {
	fn  func(context.Context, ApplianceListResult) (ApplianceListResult, error)
	alr ApplianceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplianceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplianceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplianceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplianceListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplianceListResultPage) Response() ApplianceListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplianceListResultPage) Values() []Appliance {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ApplianceListResultPage type.
func NewApplianceListResultPage(cur ApplianceListResult, getNextPage func(context.Context, ApplianceListResult) (ApplianceListResult, error)) ApplianceListResultPage {
	return ApplianceListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// ApplianceOperation appliances operation.
type ApplianceOperation struct {
	// ApplianceOperationValueDisplay - Describes the properties of an Appliances Operation Value Display.
	*ApplianceOperationValueDisplay `json:"display,omitempty"`
	// IsDataAction - READ-ONLY; Is this Operation a data plane operation
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Name - READ-ONLY; The name of the compute operation.
	Name *string `json:"name,omitempty"`
	// Origin - READ-ONLY; The origin of the compute operation.
	Origin *string `json:"origin,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplianceOperation.
func (ao ApplianceOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ao.ApplianceOperationValueDisplay != nil {
		objectMap["display"] = ao.ApplianceOperationValueDisplay
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplianceOperation struct.
func (ao *ApplianceOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "display":
			if v != nil {
				var applianceOperationValueDisplay ApplianceOperationValueDisplay
				err = json.Unmarshal(*v, &applianceOperationValueDisplay)
				if err != nil {
					return err
				}
				ao.ApplianceOperationValueDisplay = &applianceOperationValueDisplay
			}
		case "isDataAction":
			if v != nil {
				var isDataAction bool
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				ao.IsDataAction = &isDataAction
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ao.Name = &name
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				ao.Origin = &origin
			}
		}
	}

	return nil
}

// ApplianceOperationsList lists of Appliances operations.
type ApplianceOperationsList struct {
	autorest.Response `json:"-"`
	// NextLink - Next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of applianceOperation
	Value *[]ApplianceOperation `json:"value,omitempty"`
}

// ApplianceOperationsListIterator provides access to a complete listing of ApplianceOperation values.
type ApplianceOperationsListIterator struct {
	i    int
	page ApplianceOperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplianceOperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplianceOperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplianceOperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplianceOperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplianceOperationsListIterator) Response() ApplianceOperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplianceOperationsListIterator) Value() ApplianceOperation {
	if !iter.page.NotDone() {
		return ApplianceOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplianceOperationsListIterator type.
func NewApplianceOperationsListIterator(page ApplianceOperationsListPage) ApplianceOperationsListIterator {
	return ApplianceOperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aol ApplianceOperationsList) IsEmpty() bool {
	return aol.Value == nil || len(*aol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aol ApplianceOperationsList) hasNextLink() bool {
	return aol.NextLink != nil && len(*aol.NextLink) != 0
}

// applianceOperationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aol ApplianceOperationsList) applianceOperationsListPreparer(ctx context.Context) (*http.Request, error) {
	if !aol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aol.NextLink)))
}

// ApplianceOperationsListPage contains a page of ApplianceOperation values.
type ApplianceOperationsListPage struct {
	fn  func(context.Context, ApplianceOperationsList) (ApplianceOperationsList, error)
	aol ApplianceOperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplianceOperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplianceOperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aol)
		if err != nil {
			return err
		}
		page.aol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplianceOperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplianceOperationsListPage) NotDone() bool {
	return !page.aol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplianceOperationsListPage) Response() ApplianceOperationsList {
	return page.aol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplianceOperationsListPage) Values() []ApplianceOperation {
	if page.aol.IsEmpty() {
		return nil
	}
	return *page.aol.Value
}

// Creates a new instance of the ApplianceOperationsListPage type.
func NewApplianceOperationsListPage(cur ApplianceOperationsList, getNextPage func(context.Context, ApplianceOperationsList) (ApplianceOperationsList, error)) ApplianceOperationsListPage {
	return ApplianceOperationsListPage{
		fn:  getNextPage,
		aol: cur,
	}
}

// ApplianceOperationValueDisplay describes the properties of an Appliances Operation Value Display.
type ApplianceOperationValueDisplay struct {
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
	// Operation - READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty"`
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplianceOperationValueDisplay.
func (aovd ApplianceOperationValueDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplianceProperties properties for an appliance.
type ApplianceProperties struct {
	// Distro - Represents a supported Fabric/Infra. (AKSEdge etc...). Possible values include: 'DistroAKSEdge'
	Distro Distro `json:"distro,omitempty"`
	// InfrastructureConfig - Contains infrastructure information about the Appliance
	InfrastructureConfig *AppliancePropertiesInfrastructureConfig `json:"infrastructureConfig,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PublicKey - Certificates pair used to download MSI certificate from HIS
	PublicKey *string `json:"publicKey,omitempty"`
	// Status - READ-ONLY; Appliance’s health and state of connection to on-prem. Possible values include: 'StatusWaitingForHeartbeat', 'StatusValidating', 'StatusConnected', 'StatusRunning'
	Status Status `json:"status,omitempty"`
	// Version - READ-ONLY; Version of the Appliance
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplianceProperties.
func (ap ApplianceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Distro != "" {
		objectMap["distro"] = ap.Distro
	}
	if ap.InfrastructureConfig != nil {
		objectMap["infrastructureConfig"] = ap.InfrastructureConfig
	}
	if ap.PublicKey != nil {
		objectMap["publicKey"] = ap.PublicKey
	}
	return json.Marshal(objectMap)
}

// AppliancePropertiesInfrastructureConfig contains infrastructure information about the Appliance
type AppliancePropertiesInfrastructureConfig struct {
	// Provider - Information about the connected appliance. Possible values include: 'ProviderVMWare', 'ProviderHCI', 'ProviderSCVMM'
	Provider Provider `json:"provider,omitempty"`
}

// AppliancesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppliancesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppliancesClient) (Appliance, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppliancesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppliancesCreateOrUpdateFuture.Result.
func (future *AppliancesCreateOrUpdateFuture) result(client AppliancesClient) (a Appliance, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourceconnector.AppliancesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resourceconnector.AppliancesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourceconnector.AppliancesCreateOrUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppliancesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppliancesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppliancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppliancesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppliancesDeleteFuture.Result.
func (future *AppliancesDeleteFuture) result(client AppliancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourceconnector.AppliancesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resourceconnector.AppliancesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// HybridConnectionConfig contains the REP (rendezvous endpoint) and “Listener” access token from
// notification service (NS).
type HybridConnectionConfig struct {
	// ExpirationTime - READ-ONLY; Timestamp when this token will be expired.
	ExpirationTime *int64 `json:"expirationTime,omitempty"`
	// HybridConnectionName - READ-ONLY; Name of the connection
	HybridConnectionName *string `json:"hybridConnectionName,omitempty"`
	// Relay - READ-ONLY; Name of the notification service.
	Relay *string `json:"relay,omitempty"`
	// Token - READ-ONLY; Listener access token
	Token *string `json:"token,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionConfig.
func (hcc HybridConnectionConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// PatchableAppliance the Appliances patchable resource definition.
type PatchableAppliance struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PatchableAppliance.
func (pa PatchableAppliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pa.Tags != nil {
		objectMap["tags"] = pa.Tags
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}
