package synapse

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// KustoPoolsClient is the azure Synapse Analytics Management Client
type KustoPoolsClient struct {
	BaseClient
}

// NewKustoPoolsClient creates an instance of the KustoPoolsClient client.
func NewKustoPoolsClient(subscriptionID string) KustoPoolsClient {
	return NewKustoPoolsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewKustoPoolsClientWithBaseURI creates an instance of the KustoPoolsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewKustoPoolsClientWithBaseURI(baseURI string, subscriptionID string) KustoPoolsClient {
	return KustoPoolsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// AddLanguageExtensions add a list of language extensions that can run within KQL queries.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// languageExtensionsToAdd - the language extensions to add.
func (client KustoPoolsClient) AddLanguageExtensions(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToAdd LanguageExtensionsList) (result KustoPoolsAddLanguageExtensionsFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.AddLanguageExtensions")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "AddLanguageExtensions", err.Error())
	}

	req, err := client.AddLanguageExtensionsPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName, languageExtensionsToAdd)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "AddLanguageExtensions", nil, "Failure preparing request")
		return
	}

	result, err = client.AddLanguageExtensionsSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "AddLanguageExtensions", result.Response(), "Failure sending request")
		return
	}

	return
}

// AddLanguageExtensionsPreparer prepares the AddLanguageExtensions request.
func (client KustoPoolsClient) AddLanguageExtensionsPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToAdd LanguageExtensionsList) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/addLanguageExtensions", pathParameters),
		autorest.WithJSON(languageExtensionsToAdd),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddLanguageExtensionsSender sends the AddLanguageExtensions request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) AddLanguageExtensionsSender(req *http.Request) (future KustoPoolsAddLanguageExtensionsFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// AddLanguageExtensionsResponder handles the response to the AddLanguageExtensions request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) AddLanguageExtensionsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CheckNameAvailability checks that the kusto pool name is valid and is not already in use.
// Parameters:
// location - the name of Azure region.
// kustoPoolName - the name of the cluster.
func (client KustoPoolsClient) CheckNameAvailability(ctx context.Context, location string, kustoPoolName KustoPoolCheckNameRequest) (result CheckNameResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.CheckNameAvailability")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: location,
			Constraints: []validation.Constraint{{Target: "location", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: kustoPoolName,
			Constraints: []validation.Constraint{{Target: "kustoPoolName.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "kustoPoolName.Type", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "CheckNameAvailability", err.Error())
	}

	req, err := client.CheckNameAvailabilityPreparer(ctx, location, kustoPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "CheckNameAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "CheckNameAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "CheckNameAvailability", resp, "Failure responding to request")
		return
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client KustoPoolsClient) CheckNameAvailabilityPreparer(ctx context.Context, location string, kustoPoolName KustoPoolCheckNameRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/locations/{location}/kustoPoolCheckNameAvailability", pathParameters),
		autorest.WithJSON(kustoPoolName),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) CheckNameAvailabilityResponder(resp *http.Response) (result CheckNameResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate create or update a Kusto pool.
// Parameters:
// workspaceName - the name of the workspace.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// kustoPoolName - the name of the Kusto pool.
// parameters - the Kusto pool parameters supplied to the CreateOrUpdate operation.
// ifMatch - the ETag of the Kusto Pool. Omit this value to always overwrite the current Kusto Pool. Specify
// the last-seen ETag value to prevent accidentally overwriting concurrent changes.
// ifNoneMatch - set to '*' to allow a new Kusto Pool to be created, but to prevent updating an existing Kusto
// Pool. Other values will result in a 412 Pre-condition Failed response.
func (client KustoPoolsClient) CreateOrUpdate(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPool, ifMatch string, ifNoneMatch string) (result KustoPoolsCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Sku", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.KustoPoolProperties", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.KustoPoolProperties.OptimizedAutoscale", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.KustoPoolProperties.OptimizedAutoscale.Version", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "parameters.KustoPoolProperties.OptimizedAutoscale.IsEnabled", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "parameters.KustoPoolProperties.OptimizedAutoscale.Minimum", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "parameters.KustoPoolProperties.OptimizedAutoscale.Maximum", Name: validation.Null, Rule: true, Chain: nil},
						}},
					}}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, workspaceName, resourceGroupName, kustoPoolName, parameters, ifMatch, ifNoneMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client KustoPoolsClient) CreateOrUpdatePreparer(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPool, ifMatch string, ifNoneMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.Etag = nil
	parameters.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) CreateOrUpdateSender(req *http.Request) (future KustoPoolsCreateOrUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) CreateOrUpdateResponder(resp *http.Response) (result KustoPool, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a Kusto pool.
// Parameters:
// workspaceName - the name of the workspace.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// kustoPoolName - the name of the Kusto pool.
func (client KustoPoolsClient) Delete(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string) (result KustoPoolsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, workspaceName, resourceGroupName, kustoPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client KustoPoolsClient) DeletePreparer(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) DeleteSender(req *http.Request) (future KustoPoolsDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DetachFollowerDatabases detaches all followers of a database owned by this Kusto Pool.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// followerDatabaseToRemove - the follower databases properties to remove.
func (client KustoPoolsClient) DetachFollowerDatabases(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, followerDatabaseToRemove FollowerDatabaseDefinition) (result KustoPoolsDetachFollowerDatabasesFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.DetachFollowerDatabases")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: followerDatabaseToRemove,
			Constraints: []validation.Constraint{{Target: "followerDatabaseToRemove.KustoPoolResourceID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "followerDatabaseToRemove.AttachedDatabaseConfigurationName", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "DetachFollowerDatabases", err.Error())
	}

	req, err := client.DetachFollowerDatabasesPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName, followerDatabaseToRemove)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "DetachFollowerDatabases", nil, "Failure preparing request")
		return
	}

	result, err = client.DetachFollowerDatabasesSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "DetachFollowerDatabases", result.Response(), "Failure sending request")
		return
	}

	return
}

// DetachFollowerDatabasesPreparer prepares the DetachFollowerDatabases request.
func (client KustoPoolsClient) DetachFollowerDatabasesPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, followerDatabaseToRemove FollowerDatabaseDefinition) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	followerDatabaseToRemove.DatabaseName = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/detachFollowerDatabases", pathParameters),
		autorest.WithJSON(followerDatabaseToRemove),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DetachFollowerDatabasesSender sends the DetachFollowerDatabases request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) DetachFollowerDatabasesSender(req *http.Request) (future KustoPoolsDetachFollowerDatabasesFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DetachFollowerDatabasesResponder handles the response to the DetachFollowerDatabases request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) DetachFollowerDatabasesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a Kusto pool.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolsClient) Get(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (result KustoPool, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client KustoPoolsClient) GetPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) GetResponder(resp *http.Response) (result KustoPool, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByWorkspace list all Kusto pools
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// workspaceName - the name of the workspace.
func (client KustoPoolsClient) ListByWorkspace(ctx context.Context, resourceGroupName string, workspaceName string) (result KustoPoolListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.ListByWorkspace")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "ListByWorkspace", err.Error())
	}

	req, err := client.ListByWorkspacePreparer(ctx, resourceGroupName, workspaceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListByWorkspace", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByWorkspaceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListByWorkspace", resp, "Failure sending request")
		return
	}

	result, err = client.ListByWorkspaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListByWorkspace", resp, "Failure responding to request")
		return
	}

	return
}

// ListByWorkspacePreparer prepares the ListByWorkspace request.
func (client KustoPoolsClient) ListByWorkspacePreparer(ctx context.Context, resourceGroupName string, workspaceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByWorkspaceSender sends the ListByWorkspace request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) ListByWorkspaceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByWorkspaceResponder handles the response to the ListByWorkspace request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) ListByWorkspaceResponder(resp *http.Response) (result KustoPoolListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFollowerDatabases returns a list of databases that are owned by this Kusto Pool and were followed by another
// Kusto Pool.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolsClient) ListFollowerDatabases(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (result FollowerDatabaseListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.ListFollowerDatabases")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "ListFollowerDatabases", err.Error())
	}

	req, err := client.ListFollowerDatabasesPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListFollowerDatabases", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFollowerDatabasesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListFollowerDatabases", resp, "Failure sending request")
		return
	}

	result, err = client.ListFollowerDatabasesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListFollowerDatabases", resp, "Failure responding to request")
		return
	}

	return
}

// ListFollowerDatabasesPreparer prepares the ListFollowerDatabases request.
func (client KustoPoolsClient) ListFollowerDatabasesPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/listFollowerDatabases", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListFollowerDatabasesSender sends the ListFollowerDatabases request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) ListFollowerDatabasesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListFollowerDatabasesResponder handles the response to the ListFollowerDatabases request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) ListFollowerDatabasesResponder(resp *http.Response) (result FollowerDatabaseListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListLanguageExtensions returns a list of language extensions that can run within KQL queries.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolsClient) ListLanguageExtensions(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (result LanguageExtensionsList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.ListLanguageExtensions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "ListLanguageExtensions", err.Error())
	}

	req, err := client.ListLanguageExtensionsPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListLanguageExtensions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListLanguageExtensionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListLanguageExtensions", resp, "Failure sending request")
		return
	}

	result, err = client.ListLanguageExtensionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListLanguageExtensions", resp, "Failure responding to request")
		return
	}

	return
}

// ListLanguageExtensionsPreparer prepares the ListLanguageExtensions request.
func (client KustoPoolsClient) ListLanguageExtensionsPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/listLanguageExtensions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListLanguageExtensionsSender sends the ListLanguageExtensions request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) ListLanguageExtensionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListLanguageExtensionsResponder handles the response to the ListLanguageExtensions request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) ListLanguageExtensionsResponder(resp *http.Response) (result LanguageExtensionsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSkus lists eligible SKUs for Kusto Pool resource.
func (client KustoPoolsClient) ListSkus(ctx context.Context) (result SkuDescriptionList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.ListSkus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "ListSkus", err.Error())
	}

	req, err := client.ListSkusPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListSkus", resp, "Failure sending request")
		return
	}

	result, err = client.ListSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListSkus", resp, "Failure responding to request")
		return
	}

	return
}

// ListSkusPreparer prepares the ListSkus request.
func (client KustoPoolsClient) ListSkusPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Synapse/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSkusSender sends the ListSkus request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) ListSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSkusResponder handles the response to the ListSkus request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) ListSkusResponder(resp *http.Response) (result SkuDescriptionList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSkusByResource returns the SKUs available for the provided resource.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolsClient) ListSkusByResource(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (result ListResourceSkusResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.ListSkusByResource")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "ListSkusByResource", err.Error())
	}

	req, err := client.ListSkusByResourcePreparer(ctx, workspaceName, kustoPoolName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListSkusByResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSkusByResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListSkusByResource", resp, "Failure sending request")
		return
	}

	result, err = client.ListSkusByResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "ListSkusByResource", resp, "Failure responding to request")
		return
	}

	return
}

// ListSkusByResourcePreparer prepares the ListSkusByResource request.
func (client KustoPoolsClient) ListSkusByResourcePreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSkusByResourceSender sends the ListSkusByResource request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) ListSkusByResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSkusByResourceResponder handles the response to the ListSkusByResource request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) ListSkusByResourceResponder(resp *http.Response) (result ListResourceSkusResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RemoveLanguageExtensions remove a list of language extensions that can run within KQL queries.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// languageExtensionsToRemove - the language extensions to remove.
func (client KustoPoolsClient) RemoveLanguageExtensions(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToRemove LanguageExtensionsList) (result KustoPoolsRemoveLanguageExtensionsFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.RemoveLanguageExtensions")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "RemoveLanguageExtensions", err.Error())
	}

	req, err := client.RemoveLanguageExtensionsPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName, languageExtensionsToRemove)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "RemoveLanguageExtensions", nil, "Failure preparing request")
		return
	}

	result, err = client.RemoveLanguageExtensionsSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "RemoveLanguageExtensions", result.Response(), "Failure sending request")
		return
	}

	return
}

// RemoveLanguageExtensionsPreparer prepares the RemoveLanguageExtensions request.
func (client KustoPoolsClient) RemoveLanguageExtensionsPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToRemove LanguageExtensionsList) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/removeLanguageExtensions", pathParameters),
		autorest.WithJSON(languageExtensionsToRemove),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RemoveLanguageExtensionsSender sends the RemoveLanguageExtensions request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) RemoveLanguageExtensionsSender(req *http.Request) (future KustoPoolsRemoveLanguageExtensionsFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// RemoveLanguageExtensionsResponder handles the response to the RemoveLanguageExtensions request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) RemoveLanguageExtensionsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Start starts a Kusto pool.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolsClient) Start(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (result KustoPoolsStartFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.Start")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "Start", err.Error())
	}

	req, err := client.StartPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Start", nil, "Failure preparing request")
		return
	}

	result, err = client.StartSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Start", result.Response(), "Failure sending request")
		return
	}

	return
}

// StartPreparer prepares the Start request.
func (client KustoPoolsClient) StartPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StartSender sends the Start request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) StartSender(req *http.Request) (future KustoPoolsStartFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// StartResponder handles the response to the Start request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) StartResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Stop stops a Kusto pool.
// Parameters:
// workspaceName - the name of the workspace.
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolsClient) Stop(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (result KustoPoolsStopFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.Stop")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "Stop", err.Error())
	}

	req, err := client.StopPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Stop", nil, "Failure preparing request")
		return
	}

	result, err = client.StopSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Stop", result.Response(), "Failure sending request")
		return
	}

	return
}

// StopPreparer prepares the Stop request.
func (client KustoPoolsClient) StopPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StopSender sends the Stop request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) StopSender(req *http.Request) (future KustoPoolsStopFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// StopResponder handles the response to the Stop request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) StopResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Update update a Kusto Kusto Pool.
// Parameters:
// workspaceName - the name of the workspace.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// kustoPoolName - the name of the Kusto pool.
// parameters - the Kusto pool parameters supplied to the Update operation.
// ifMatch - the ETag of the Kusto Pool. Omit this value to always overwrite the current Kusto Pool. Specify
// the last-seen ETag value to prevent accidentally overwriting concurrent changes.
func (client KustoPoolsClient) Update(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPoolUpdate, ifMatch string) (result KustoPoolsUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolsClient.Update")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolsClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, workspaceName, resourceGroupName, kustoPoolName, parameters, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolsClient", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client KustoPoolsClient) UpdatePreparer(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters KustoPoolUpdate, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolsClient) UpdateSender(req *http.Request) (future KustoPoolsUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client KustoPoolsClient) UpdateResponder(resp *http.Response) (result KustoPool, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
