package web

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessControlEntryAction enumerates the values for access control entry action.
type AccessControlEntryAction string

const (
	// Deny ...
	Deny AccessControlEntryAction = "Deny"
	// Permit ...
	Permit AccessControlEntryAction = "Permit"
)

// PossibleAccessControlEntryActionValues returns an array of possible values for the AccessControlEntryAction const type.
func PossibleAccessControlEntryActionValues() []AccessControlEntryAction {
	return []AccessControlEntryAction{Deny, Permit}
}

// AutoHealActionType enumerates the values for auto heal action type.
type AutoHealActionType string

const (
	// CustomAction ...
	CustomAction AutoHealActionType = "CustomAction"
	// LogEvent ...
	LogEvent AutoHealActionType = "LogEvent"
	// Recycle ...
	Recycle AutoHealActionType = "Recycle"
)

// PossibleAutoHealActionTypeValues returns an array of possible values for the AutoHealActionType const type.
func PossibleAutoHealActionTypeValues() []AutoHealActionType {
	return []AutoHealActionType{CustomAction, LogEvent, Recycle}
}

// AzureResourceType enumerates the values for azure resource type.
type AzureResourceType string

const (
	// TrafficManager ...
	TrafficManager AzureResourceType = "TrafficManager"
	// Website ...
	Website AzureResourceType = "Website"
)

// PossibleAzureResourceTypeValues returns an array of possible values for the AzureResourceType const type.
func PossibleAzureResourceTypeValues() []AzureResourceType {
	return []AzureResourceType{TrafficManager, Website}
}

// BackupItemStatus enumerates the values for backup item status.
type BackupItemStatus string

const (
	// Created ...
	Created BackupItemStatus = "Created"
	// Deleted ...
	Deleted BackupItemStatus = "Deleted"
	// DeleteFailed ...
	DeleteFailed BackupItemStatus = "DeleteFailed"
	// DeleteInProgress ...
	DeleteInProgress BackupItemStatus = "DeleteInProgress"
	// Failed ...
	Failed BackupItemStatus = "Failed"
	// InProgress ...
	InProgress BackupItemStatus = "InProgress"
	// PartiallySucceeded ...
	PartiallySucceeded BackupItemStatus = "PartiallySucceeded"
	// Skipped ...
	Skipped BackupItemStatus = "Skipped"
	// Succeeded ...
	Succeeded BackupItemStatus = "Succeeded"
	// TimedOut ...
	TimedOut BackupItemStatus = "TimedOut"
)

// PossibleBackupItemStatusValues returns an array of possible values for the BackupItemStatus const type.
func PossibleBackupItemStatusValues() []BackupItemStatus {
	return []BackupItemStatus{Created, Deleted, DeleteFailed, DeleteInProgress, Failed, InProgress, PartiallySucceeded, Skipped, Succeeded, TimedOut}
}

// BackupRestoreOperationType enumerates the values for backup restore operation type.
type BackupRestoreOperationType string

const (
	// Clone ...
	Clone BackupRestoreOperationType = "Clone"
	// Default ...
	Default BackupRestoreOperationType = "Default"
	// Relocation ...
	Relocation BackupRestoreOperationType = "Relocation"
)

// PossibleBackupRestoreOperationTypeValues returns an array of possible values for the BackupRestoreOperationType const type.
func PossibleBackupRestoreOperationTypeValues() []BackupRestoreOperationType {
	return []BackupRestoreOperationType{Clone, Default, Relocation}
}

// BuiltInAuthenticationProvider enumerates the values for built in authentication provider.
type BuiltInAuthenticationProvider string

const (
	// AzureActiveDirectory ...
	AzureActiveDirectory BuiltInAuthenticationProvider = "AzureActiveDirectory"
	// Facebook ...
	Facebook BuiltInAuthenticationProvider = "Facebook"
	// Google ...
	Google BuiltInAuthenticationProvider = "Google"
	// MicrosoftAccount ...
	MicrosoftAccount BuiltInAuthenticationProvider = "MicrosoftAccount"
	// Twitter ...
	Twitter BuiltInAuthenticationProvider = "Twitter"
)

// PossibleBuiltInAuthenticationProviderValues returns an array of possible values for the BuiltInAuthenticationProvider const type.
func PossibleBuiltInAuthenticationProviderValues() []BuiltInAuthenticationProvider {
	return []BuiltInAuthenticationProvider{AzureActiveDirectory, Facebook, Google, MicrosoftAccount, Twitter}
}

// CertificateOrderActionType enumerates the values for certificate order action type.
type CertificateOrderActionType string

const (
	// CertificateIssued ...
	CertificateIssued CertificateOrderActionType = "CertificateIssued"
	// CertificateOrderCanceled ...
	CertificateOrderCanceled CertificateOrderActionType = "CertificateOrderCanceled"
	// CertificateOrderCreated ...
	CertificateOrderCreated CertificateOrderActionType = "CertificateOrderCreated"
	// CertificateRevoked ...
	CertificateRevoked CertificateOrderActionType = "CertificateRevoked"
	// DomainValidationComplete ...
	DomainValidationComplete CertificateOrderActionType = "DomainValidationComplete"
	// FraudDetected ...
	FraudDetected CertificateOrderActionType = "FraudDetected"
	// OrgNameChange ...
	OrgNameChange CertificateOrderActionType = "OrgNameChange"
	// OrgValidationComplete ...
	OrgValidationComplete CertificateOrderActionType = "OrgValidationComplete"
	// SanDrop ...
	SanDrop CertificateOrderActionType = "SanDrop"
)

// PossibleCertificateOrderActionTypeValues returns an array of possible values for the CertificateOrderActionType const type.
func PossibleCertificateOrderActionTypeValues() []CertificateOrderActionType {
	return []CertificateOrderActionType{CertificateIssued, CertificateOrderCanceled, CertificateOrderCreated, CertificateRevoked, DomainValidationComplete, FraudDetected, OrgNameChange, OrgValidationComplete, SanDrop}
}

// CertificateOrderStatus enumerates the values for certificate order status.
type CertificateOrderStatus string

const (
	// Canceled ...
	Canceled CertificateOrderStatus = "Canceled"
	// Denied ...
	Denied CertificateOrderStatus = "Denied"
	// Expired ...
	Expired CertificateOrderStatus = "Expired"
	// Issued ...
	Issued CertificateOrderStatus = "Issued"
	// NotSubmitted ...
	NotSubmitted CertificateOrderStatus = "NotSubmitted"
	// Pendingissuance ...
	Pendingissuance CertificateOrderStatus = "Pendingissuance"
	// PendingRekey ...
	PendingRekey CertificateOrderStatus = "PendingRekey"
	// Pendingrevocation ...
	Pendingrevocation CertificateOrderStatus = "Pendingrevocation"
	// Revoked ...
	Revoked CertificateOrderStatus = "Revoked"
	// Unused ...
	Unused CertificateOrderStatus = "Unused"
)

// PossibleCertificateOrderStatusValues returns an array of possible values for the CertificateOrderStatus const type.
func PossibleCertificateOrderStatusValues() []CertificateOrderStatus {
	return []CertificateOrderStatus{Canceled, Denied, Expired, Issued, NotSubmitted, Pendingissuance, PendingRekey, Pendingrevocation, Revoked, Unused}
}

// CertificateProductType enumerates the values for certificate product type.
type CertificateProductType string

const (
	// StandardDomainValidatedSsl ...
	StandardDomainValidatedSsl CertificateProductType = "StandardDomainValidatedSsl"
	// StandardDomainValidatedWildCardSsl ...
	StandardDomainValidatedWildCardSsl CertificateProductType = "StandardDomainValidatedWildCardSsl"
)

// PossibleCertificateProductTypeValues returns an array of possible values for the CertificateProductType const type.
func PossibleCertificateProductTypeValues() []CertificateProductType {
	return []CertificateProductType{StandardDomainValidatedSsl, StandardDomainValidatedWildCardSsl}
}

// Channels enumerates the values for channels.
type Channels string

const (
	// All ...
	All Channels = "All"
	// API ...
	API Channels = "Api"
	// Email ...
	Email Channels = "Email"
	// Notification ...
	Notification Channels = "Notification"
)

// PossibleChannelsValues returns an array of possible values for the Channels const type.
func PossibleChannelsValues() []Channels {
	return []Channels{All, API, Email, Notification}
}

// CloneAbilityResult enumerates the values for clone ability result.
type CloneAbilityResult string

const (
	// Cloneable ...
	Cloneable CloneAbilityResult = "Cloneable"
	// NotCloneable ...
	NotCloneable CloneAbilityResult = "NotCloneable"
	// PartiallyCloneable ...
	PartiallyCloneable CloneAbilityResult = "PartiallyCloneable"
)

// PossibleCloneAbilityResultValues returns an array of possible values for the CloneAbilityResult const type.
func PossibleCloneAbilityResultValues() []CloneAbilityResult {
	return []CloneAbilityResult{Cloneable, NotCloneable, PartiallyCloneable}
}

// ComputeModeOptions enumerates the values for compute mode options.
type ComputeModeOptions string

const (
	// Dedicated ...
	Dedicated ComputeModeOptions = "Dedicated"
	// Dynamic ...
	Dynamic ComputeModeOptions = "Dynamic"
	// Shared ...
	Shared ComputeModeOptions = "Shared"
)

// PossibleComputeModeOptionsValues returns an array of possible values for the ComputeModeOptions const type.
func PossibleComputeModeOptionsValues() []ComputeModeOptions {
	return []ComputeModeOptions{Dedicated, Dynamic, Shared}
}

// ConnectionParameterType enumerates the values for connection parameter type.
type ConnectionParameterType string

const (
	// ConnectionParameterTypeArray ...
	ConnectionParameterTypeArray ConnectionParameterType = "array"
	// ConnectionParameterTypeBool ...
	ConnectionParameterTypeBool ConnectionParameterType = "bool"
	// ConnectionParameterTypeConnection ...
	ConnectionParameterTypeConnection ConnectionParameterType = "connection"
	// ConnectionParameterTypeInt ...
	ConnectionParameterTypeInt ConnectionParameterType = "int"
	// ConnectionParameterTypeOauthSetting ...
	ConnectionParameterTypeOauthSetting ConnectionParameterType = "oauthSetting"
	// ConnectionParameterTypeObject ...
	ConnectionParameterTypeObject ConnectionParameterType = "object"
	// ConnectionParameterTypeSecureobject ...
	ConnectionParameterTypeSecureobject ConnectionParameterType = "secureobject"
	// ConnectionParameterTypeSecurestring ...
	ConnectionParameterTypeSecurestring ConnectionParameterType = "securestring"
	// ConnectionParameterTypeString ...
	ConnectionParameterTypeString ConnectionParameterType = "string"
)

// PossibleConnectionParameterTypeValues returns an array of possible values for the ConnectionParameterType const type.
func PossibleConnectionParameterTypeValues() []ConnectionParameterType {
	return []ConnectionParameterType{ConnectionParameterTypeArray, ConnectionParameterTypeBool, ConnectionParameterTypeConnection, ConnectionParameterTypeInt, ConnectionParameterTypeOauthSetting, ConnectionParameterTypeObject, ConnectionParameterTypeSecureobject, ConnectionParameterTypeSecurestring, ConnectionParameterTypeString}
}

// CustomHostNameDNSRecordType enumerates the values for custom host name dns record type.
type CustomHostNameDNSRecordType string

const (
	// A ...
	A CustomHostNameDNSRecordType = "A"
	// CName ...
	CName CustomHostNameDNSRecordType = "CName"
)

// PossibleCustomHostNameDNSRecordTypeValues returns an array of possible values for the CustomHostNameDNSRecordType const type.
func PossibleCustomHostNameDNSRecordTypeValues() []CustomHostNameDNSRecordType {
	return []CustomHostNameDNSRecordType{A, CName}
}

// DatabaseServerType enumerates the values for database server type.
type DatabaseServerType string

const (
	// Custom ...
	Custom DatabaseServerType = "Custom"
	// MySQL ...
	MySQL DatabaseServerType = "MySql"
	// SQLAzure ...
	SQLAzure DatabaseServerType = "SQLAzure"
	// SQLServer ...
	SQLServer DatabaseServerType = "SQLServer"
)

// PossibleDatabaseServerTypeValues returns an array of possible values for the DatabaseServerType const type.
func PossibleDatabaseServerTypeValues() []DatabaseServerType {
	return []DatabaseServerType{Custom, MySQL, SQLAzure, SQLServer}
}

// DomainStatus enumerates the values for domain status.
type DomainStatus string

const (
	// DomainStatusActive ...
	DomainStatusActive DomainStatus = "Active"
	// DomainStatusAwaiting ...
	DomainStatusAwaiting DomainStatus = "Awaiting"
	// DomainStatusCancelled ...
	DomainStatusCancelled DomainStatus = "Cancelled"
	// DomainStatusConfiscated ...
	DomainStatusConfiscated DomainStatus = "Confiscated"
	// DomainStatusDisabled ...
	DomainStatusDisabled DomainStatus = "Disabled"
	// DomainStatusExcluded ...
	DomainStatusExcluded DomainStatus = "Excluded"
	// DomainStatusExpired ...
	DomainStatusExpired DomainStatus = "Expired"
	// DomainStatusFailed ...
	DomainStatusFailed DomainStatus = "Failed"
	// DomainStatusHeld ...
	DomainStatusHeld DomainStatus = "Held"
	// DomainStatusJSONConverterFailed ...
	DomainStatusJSONConverterFailed DomainStatus = "JsonConverterFailed"
	// DomainStatusLocked ...
	DomainStatusLocked DomainStatus = "Locked"
	// DomainStatusParked ...
	DomainStatusParked DomainStatus = "Parked"
	// DomainStatusPending ...
	DomainStatusPending DomainStatus = "Pending"
	// DomainStatusReserved ...
	DomainStatusReserved DomainStatus = "Reserved"
	// DomainStatusReverted ...
	DomainStatusReverted DomainStatus = "Reverted"
	// DomainStatusSuspended ...
	DomainStatusSuspended DomainStatus = "Suspended"
	// DomainStatusTransferred ...
	DomainStatusTransferred DomainStatus = "Transferred"
	// DomainStatusUnknown ...
	DomainStatusUnknown DomainStatus = "Unknown"
	// DomainStatusUnlocked ...
	DomainStatusUnlocked DomainStatus = "Unlocked"
	// DomainStatusUnparked ...
	DomainStatusUnparked DomainStatus = "Unparked"
	// DomainStatusUpdated ...
	DomainStatusUpdated DomainStatus = "Updated"
)

// PossibleDomainStatusValues returns an array of possible values for the DomainStatus const type.
func PossibleDomainStatusValues() []DomainStatus {
	return []DomainStatus{DomainStatusActive, DomainStatusAwaiting, DomainStatusCancelled, DomainStatusConfiscated, DomainStatusDisabled, DomainStatusExcluded, DomainStatusExpired, DomainStatusFailed, DomainStatusHeld, DomainStatusJSONConverterFailed, DomainStatusLocked, DomainStatusParked, DomainStatusPending, DomainStatusReserved, DomainStatusReverted, DomainStatusSuspended, DomainStatusTransferred, DomainStatusUnknown, DomainStatusUnlocked, DomainStatusUnparked, DomainStatusUpdated}
}

// DomainType enumerates the values for domain type.
type DomainType string

const (
	// Regular ...
	Regular DomainType = "Regular"
	// SoftDeleted ...
	SoftDeleted DomainType = "SoftDeleted"
)

// PossibleDomainTypeValues returns an array of possible values for the DomainType const type.
func PossibleDomainTypeValues() []DomainType {
	return []DomainType{Regular, SoftDeleted}
}

// FrequencyUnit enumerates the values for frequency unit.
type FrequencyUnit string

const (
	// Day ...
	Day FrequencyUnit = "Day"
	// Hour ...
	Hour FrequencyUnit = "Hour"
)

// PossibleFrequencyUnitValues returns an array of possible values for the FrequencyUnit const type.
func PossibleFrequencyUnitValues() []FrequencyUnit {
	return []FrequencyUnit{Day, Hour}
}

// HostingEnvironmentStatus enumerates the values for hosting environment status.
type HostingEnvironmentStatus string

const (
	// Deleting ...
	Deleting HostingEnvironmentStatus = "Deleting"
	// Preparing ...
	Preparing HostingEnvironmentStatus = "Preparing"
	// Ready ...
	Ready HostingEnvironmentStatus = "Ready"
	// Scaling ...
	Scaling HostingEnvironmentStatus = "Scaling"
)

// PossibleHostingEnvironmentStatusValues returns an array of possible values for the HostingEnvironmentStatus const type.
func PossibleHostingEnvironmentStatusValues() []HostingEnvironmentStatus {
	return []HostingEnvironmentStatus{Deleting, Preparing, Ready, Scaling}
}

// HostNameType enumerates the values for host name type.
type HostNameType string

const (
	// Managed ...
	Managed HostNameType = "Managed"
	// Verified ...
	Verified HostNameType = "Verified"
)

// PossibleHostNameTypeValues returns an array of possible values for the HostNameType const type.
func PossibleHostNameTypeValues() []HostNameType {
	return []HostNameType{Managed, Verified}
}

// InternalLoadBalancingMode enumerates the values for internal load balancing mode.
type InternalLoadBalancingMode string

const (
	// None ...
	None InternalLoadBalancingMode = "None"
	// Publishing ...
	Publishing InternalLoadBalancingMode = "Publishing"
	// Web ...
	Web InternalLoadBalancingMode = "Web"
)

// PossibleInternalLoadBalancingModeValues returns an array of possible values for the InternalLoadBalancingMode const type.
func PossibleInternalLoadBalancingModeValues() []InternalLoadBalancingMode {
	return []InternalLoadBalancingMode{None, Publishing, Web}
}

// KeyVaultSecretStatus enumerates the values for key vault secret status.
type KeyVaultSecretStatus string

const (
	// KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault ...
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = "AzureServiceUnauthorizedToAccessKeyVault"
	// KeyVaultSecretStatusCertificateOrderFailed ...
	KeyVaultSecretStatusCertificateOrderFailed KeyVaultSecretStatus = "CertificateOrderFailed"
	// KeyVaultSecretStatusInitialized ...
	KeyVaultSecretStatusInitialized KeyVaultSecretStatus = "Initialized"
	// KeyVaultSecretStatusKeyVaultDoesNotExist ...
	KeyVaultSecretStatusKeyVaultDoesNotExist KeyVaultSecretStatus = "KeyVaultDoesNotExist"
	// KeyVaultSecretStatusKeyVaultSecretDoesNotExist ...
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist KeyVaultSecretStatus = "KeyVaultSecretDoesNotExist"
	// KeyVaultSecretStatusOperationNotPermittedOnKeyVault ...
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault KeyVaultSecretStatus = "OperationNotPermittedOnKeyVault"
	// KeyVaultSecretStatusSucceeded ...
	KeyVaultSecretStatusSucceeded KeyVaultSecretStatus = "Succeeded"
	// KeyVaultSecretStatusUnknown ...
	KeyVaultSecretStatusUnknown KeyVaultSecretStatus = "Unknown"
	// KeyVaultSecretStatusUnknownError ...
	KeyVaultSecretStatusUnknownError KeyVaultSecretStatus = "UnknownError"
	// KeyVaultSecretStatusWaitingOnCertificateOrder ...
	KeyVaultSecretStatusWaitingOnCertificateOrder KeyVaultSecretStatus = "WaitingOnCertificateOrder"
)

// PossibleKeyVaultSecretStatusValues returns an array of possible values for the KeyVaultSecretStatus const type.
func PossibleKeyVaultSecretStatusValues() []KeyVaultSecretStatus {
	return []KeyVaultSecretStatus{KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault, KeyVaultSecretStatusCertificateOrderFailed, KeyVaultSecretStatusInitialized, KeyVaultSecretStatusKeyVaultDoesNotExist, KeyVaultSecretStatusKeyVaultSecretDoesNotExist, KeyVaultSecretStatusOperationNotPermittedOnKeyVault, KeyVaultSecretStatusSucceeded, KeyVaultSecretStatusUnknown, KeyVaultSecretStatusUnknownError, KeyVaultSecretStatusWaitingOnCertificateOrder}
}

// LinkState enumerates the values for link state.
type LinkState string

const (
	// Authenticated ...
	Authenticated LinkState = "Authenticated"
	// Error ...
	Error LinkState = "Error"
	// Unauthenticated ...
	Unauthenticated LinkState = "Unauthenticated"
)

// PossibleLinkStateValues returns an array of possible values for the LinkState const type.
func PossibleLinkStateValues() []LinkState {
	return []LinkState{Authenticated, Error, Unauthenticated}
}

// LogLevel enumerates the values for log level.
type LogLevel string

const (
	// LogLevelError ...
	LogLevelError LogLevel = "Error"
	// LogLevelInformation ...
	LogLevelInformation LogLevel = "Information"
	// LogLevelOff ...
	LogLevelOff LogLevel = "Off"
	// LogLevelVerbose ...
	LogLevelVerbose LogLevel = "Verbose"
	// LogLevelWarning ...
	LogLevelWarning LogLevel = "Warning"
)

// PossibleLogLevelValues returns an array of possible values for the LogLevel const type.
func PossibleLogLevelValues() []LogLevel {
	return []LogLevel{LogLevelError, LogLevelInformation, LogLevelOff, LogLevelVerbose, LogLevelWarning}
}

// ManagedHostingEnvironmentStatus enumerates the values for managed hosting environment status.
type ManagedHostingEnvironmentStatus string

const (
	// ManagedHostingEnvironmentStatusDeleting ...
	ManagedHostingEnvironmentStatusDeleting ManagedHostingEnvironmentStatus = "Deleting"
	// ManagedHostingEnvironmentStatusPreparing ...
	ManagedHostingEnvironmentStatusPreparing ManagedHostingEnvironmentStatus = "Preparing"
	// ManagedHostingEnvironmentStatusReady ...
	ManagedHostingEnvironmentStatusReady ManagedHostingEnvironmentStatus = "Ready"
)

// PossibleManagedHostingEnvironmentStatusValues returns an array of possible values for the ManagedHostingEnvironmentStatus const type.
func PossibleManagedHostingEnvironmentStatusValues() []ManagedHostingEnvironmentStatus {
	return []ManagedHostingEnvironmentStatus{ManagedHostingEnvironmentStatusDeleting, ManagedHostingEnvironmentStatusPreparing, ManagedHostingEnvironmentStatusReady}
}

// ManagedPipelineMode enumerates the values for managed pipeline mode.
type ManagedPipelineMode string

const (
	// Classic ...
	Classic ManagedPipelineMode = "Classic"
	// Integrated ...
	Integrated ManagedPipelineMode = "Integrated"
)

// PossibleManagedPipelineModeValues returns an array of possible values for the ManagedPipelineMode const type.
func PossibleManagedPipelineModeValues() []ManagedPipelineMode {
	return []ManagedPipelineMode{Classic, Integrated}
}

// NotificationLevel enumerates the values for notification level.
type NotificationLevel string

const (
	// Critical ...
	Critical NotificationLevel = "Critical"
	// Information ...
	Information NotificationLevel = "Information"
	// NonUrgentSuggestion ...
	NonUrgentSuggestion NotificationLevel = "NonUrgentSuggestion"
	// Warning ...
	Warning NotificationLevel = "Warning"
)

// PossibleNotificationLevelValues returns an array of possible values for the NotificationLevel const type.
func PossibleNotificationLevelValues() []NotificationLevel {
	return []NotificationLevel{Critical, Information, NonUrgentSuggestion, Warning}
}

// PrincipalType enumerates the values for principal type.
type PrincipalType string

const (
	// PrincipalTypeActiveDirectory ...
	PrincipalTypeActiveDirectory PrincipalType = "ActiveDirectory"
	// PrincipalTypeConnection ...
	PrincipalTypeConnection PrincipalType = "Connection"
	// PrincipalTypeMicrosoftAccount ...
	PrincipalTypeMicrosoftAccount PrincipalType = "MicrosoftAccount"
)

// PossiblePrincipalTypeValues returns an array of possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{PrincipalTypeActiveDirectory, PrincipalTypeConnection, PrincipalTypeMicrosoftAccount}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress ...
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateInProgress, ProvisioningStateSucceeded}
}

// SiteAvailabilityState enumerates the values for site availability state.
type SiteAvailabilityState string

const (
	// DisasterRecoveryMode ...
	DisasterRecoveryMode SiteAvailabilityState = "DisasterRecoveryMode"
	// Limited ...
	Limited SiteAvailabilityState = "Limited"
	// Normal ...
	Normal SiteAvailabilityState = "Normal"
)

// PossibleSiteAvailabilityStateValues returns an array of possible values for the SiteAvailabilityState const type.
func PossibleSiteAvailabilityStateValues() []SiteAvailabilityState {
	return []SiteAvailabilityState{DisasterRecoveryMode, Limited, Normal}
}

// SiteLoadBalancing enumerates the values for site load balancing.
type SiteLoadBalancing string

const (
	// LeastRequests ...
	LeastRequests SiteLoadBalancing = "LeastRequests"
	// LeastResponseTime ...
	LeastResponseTime SiteLoadBalancing = "LeastResponseTime"
	// RequestHash ...
	RequestHash SiteLoadBalancing = "RequestHash"
	// WeightedRoundRobin ...
	WeightedRoundRobin SiteLoadBalancing = "WeightedRoundRobin"
	// WeightedTotalTraffic ...
	WeightedTotalTraffic SiteLoadBalancing = "WeightedTotalTraffic"
)

// PossibleSiteLoadBalancingValues returns an array of possible values for the SiteLoadBalancing const type.
func PossibleSiteLoadBalancingValues() []SiteLoadBalancing {
	return []SiteLoadBalancing{LeastRequests, LeastResponseTime, RequestHash, WeightedRoundRobin, WeightedTotalTraffic}
}

// SslState enumerates the values for ssl state.
type SslState string

const (
	// Disabled ...
	Disabled SslState = "Disabled"
	// IPBasedEnabled ...
	IPBasedEnabled SslState = "IpBasedEnabled"
	// SniEnabled ...
	SniEnabled SslState = "SniEnabled"
)

// PossibleSslStateValues returns an array of possible values for the SslState const type.
func PossibleSslStateValues() []SslState {
	return []SslState{Disabled, IPBasedEnabled, SniEnabled}
}

// StatusOptions enumerates the values for status options.
type StatusOptions string

const (
	// StatusOptionsPending ...
	StatusOptionsPending StatusOptions = "Pending"
	// StatusOptionsReady ...
	StatusOptionsReady StatusOptions = "Ready"
)

// PossibleStatusOptionsValues returns an array of possible values for the StatusOptions const type.
func PossibleStatusOptionsValues() []StatusOptions {
	return []StatusOptions{StatusOptionsPending, StatusOptionsReady}
}

// UnauthenticatedClientAction enumerates the values for unauthenticated client action.
type UnauthenticatedClientAction string

const (
	// AllowAnonymous ...
	AllowAnonymous UnauthenticatedClientAction = "AllowAnonymous"
	// RedirectToLoginPage ...
	RedirectToLoginPage UnauthenticatedClientAction = "RedirectToLoginPage"
)

// PossibleUnauthenticatedClientActionValues returns an array of possible values for the UnauthenticatedClientAction const type.
func PossibleUnauthenticatedClientActionValues() []UnauthenticatedClientAction {
	return []UnauthenticatedClientAction{AllowAnonymous, RedirectToLoginPage}
}

// UsageState enumerates the values for usage state.
type UsageState string

const (
	// UsageStateExceeded ...
	UsageStateExceeded UsageState = "Exceeded"
	// UsageStateNormal ...
	UsageStateNormal UsageState = "Normal"
)

// PossibleUsageStateValues returns an array of possible values for the UsageState const type.
func PossibleUsageStateValues() []UsageState {
	return []UsageState{UsageStateExceeded, UsageStateNormal}
}

// WorkerSizeOptions enumerates the values for worker size options.
type WorkerSizeOptions string

const (
	// WorkerSizeOptionsDefault ...
	WorkerSizeOptionsDefault WorkerSizeOptions = "Default"
	// WorkerSizeOptionsLarge ...
	WorkerSizeOptionsLarge WorkerSizeOptions = "Large"
	// WorkerSizeOptionsMedium ...
	WorkerSizeOptionsMedium WorkerSizeOptions = "Medium"
	// WorkerSizeOptionsSmall ...
	WorkerSizeOptionsSmall WorkerSizeOptions = "Small"
)

// PossibleWorkerSizeOptionsValues returns an array of possible values for the WorkerSizeOptions const type.
func PossibleWorkerSizeOptionsValues() []WorkerSizeOptions {
	return []WorkerSizeOptions{WorkerSizeOptionsDefault, WorkerSizeOptionsLarge, WorkerSizeOptionsMedium, WorkerSizeOptionsSmall}
}
