// Copyright 2022 The etcd Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package code

import (
	"bytes"
	"testing"
	
	"github.com/stretchr/testify/assert"
)

func TestBindingWrite(t *testing.T) {
	pkg := "testing"
	comment := "// gofail: var Test int\n"
	expected := "// GENERATED BY GOFAIL. DO NOT EDIT.\n\npackage testing\n\nimport \"go.etcd.io/gofail/runtime\"\n\nvar __fp_Test *runtime.Failpoint = runtime.NewFailpoint(\"Test\")\n"

	fp, err := newFailpoint(comment)
	assert.Nilf(t, err, "failed to create failpoint from comment: %s", comment)

	b := NewBinding(pkg, []*Failpoint{fp})

	var buf bytes.Buffer
	err = b.Write(&buf)
	assert.Nil(t, err)

	got := buf.String()
	assert.Equal(t, expected, got)
}
