// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.21.12
// source: third_party/tink/proto/jwt_rsa_ssa_pkcs1.proto

package rsa_ssa_pkcs1_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// See https://datatracker.ietf.org/doc/html/rfc7518#section-3.3
type JwtRsaSsaPkcs1Algorithm int32

const (
	JwtRsaSsaPkcs1Algorithm_RS_UNKNOWN JwtRsaSsaPkcs1Algorithm = 0
	JwtRsaSsaPkcs1Algorithm_RS256      JwtRsaSsaPkcs1Algorithm = 1 // RSASSA-PKCS1-v1_5 using SHA-256
	JwtRsaSsaPkcs1Algorithm_RS384      JwtRsaSsaPkcs1Algorithm = 2 // RSASSA-PKCS1-v1_5 using SHA-384
	JwtRsaSsaPkcs1Algorithm_RS512      JwtRsaSsaPkcs1Algorithm = 3 // RSASSA-PKCS1-v1_5 using SHA-512
)

// Enum value maps for JwtRsaSsaPkcs1Algorithm.
var (
	JwtRsaSsaPkcs1Algorithm_name = map[int32]string{
		0: "RS_UNKNOWN",
		1: "RS256",
		2: "RS384",
		3: "RS512",
	}
	JwtRsaSsaPkcs1Algorithm_value = map[string]int32{
		"RS_UNKNOWN": 0,
		"RS256":      1,
		"RS384":      2,
		"RS512":      3,
	}
)

func (x JwtRsaSsaPkcs1Algorithm) Enum() *JwtRsaSsaPkcs1Algorithm {
	p := new(JwtRsaSsaPkcs1Algorithm)
	*p = x
	return p
}

func (x JwtRsaSsaPkcs1Algorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JwtRsaSsaPkcs1Algorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_enumTypes[0].Descriptor()
}

func (JwtRsaSsaPkcs1Algorithm) Type() protoreflect.EnumType {
	return &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_enumTypes[0]
}

func (x JwtRsaSsaPkcs1Algorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JwtRsaSsaPkcs1Algorithm.Descriptor instead.
func (JwtRsaSsaPkcs1Algorithm) EnumDescriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{0}
}

// key_type: type.googleapis.com/google.crypto.tink.JwtRsaSsaPkcs1PublicKey
type JwtRsaSsaPkcs1PublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version   uint32                  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm JwtRsaSsaPkcs1Algorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtRsaSsaPkcs1Algorithm" json:"algorithm,omitempty"`
	// Modulus.
	// Unsigned big integer in big-endian representation.
	N []byte `protobuf:"bytes,3,opt,name=n,proto3" json:"n,omitempty"`
	// Public exponent.
	// Unsigned big integer in big-endian representation.
	E         []byte                             `protobuf:"bytes,4,opt,name=e,proto3" json:"e,omitempty"`
	CustomKid *JwtRsaSsaPkcs1PublicKey_CustomKid `protobuf:"bytes,5,opt,name=custom_kid,json=customKid,proto3" json:"custom_kid,omitempty"`
}

func (x *JwtRsaSsaPkcs1PublicKey) Reset() {
	*x = JwtRsaSsaPkcs1PublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtRsaSsaPkcs1PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRsaSsaPkcs1PublicKey) ProtoMessage() {}

func (x *JwtRsaSsaPkcs1PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRsaSsaPkcs1PublicKey.ProtoReflect.Descriptor instead.
func (*JwtRsaSsaPkcs1PublicKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{0}
}

func (x *JwtRsaSsaPkcs1PublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtRsaSsaPkcs1PublicKey) GetAlgorithm() JwtRsaSsaPkcs1Algorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtRsaSsaPkcs1Algorithm_RS_UNKNOWN
}

func (x *JwtRsaSsaPkcs1PublicKey) GetN() []byte {
	if x != nil {
		return x.N
	}
	return nil
}

func (x *JwtRsaSsaPkcs1PublicKey) GetE() []byte {
	if x != nil {
		return x.E
	}
	return nil
}

func (x *JwtRsaSsaPkcs1PublicKey) GetCustomKid() *JwtRsaSsaPkcs1PublicKey_CustomKid {
	if x != nil {
		return x.CustomKid
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPkcs1PrivateKey
type JwtRsaSsaPkcs1PrivateKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version   uint32                   `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	PublicKey *JwtRsaSsaPkcs1PublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Private exponent.
	// Unsigned big integer in big-endian representation.
	D []byte `protobuf:"bytes,3,opt,name=d,proto3" json:"d,omitempty"`
	// The following parameters are used to optimize RSA signature computation.
	// The prime factor p of n.
	// Unsigned big integer in big-endian representation.
	P []byte `protobuf:"bytes,4,opt,name=p,proto3" json:"p,omitempty"`
	// The prime factor q of n.
	// Unsigned big integer in big-endian representation.
	Q []byte `protobuf:"bytes,5,opt,name=q,proto3" json:"q,omitempty"`
	// d mod (p - 1).
	// Unsigned big integer in big-endian representation.
	Dp []byte `protobuf:"bytes,6,opt,name=dp,proto3" json:"dp,omitempty"`
	// d mod (q - 1).
	// Unsigned big integer in big-endian representation.
	Dq []byte `protobuf:"bytes,7,opt,name=dq,proto3" json:"dq,omitempty"`
	// Chinese Remainder Theorem coefficient q^(-1) mod p.
	// Unsigned big integer in big-endian representation.
	Crt []byte `protobuf:"bytes,8,opt,name=crt,proto3" json:"crt,omitempty"`
}

func (x *JwtRsaSsaPkcs1PrivateKey) Reset() {
	*x = JwtRsaSsaPkcs1PrivateKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtRsaSsaPkcs1PrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRsaSsaPkcs1PrivateKey) ProtoMessage() {}

func (x *JwtRsaSsaPkcs1PrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRsaSsaPkcs1PrivateKey.ProtoReflect.Descriptor instead.
func (*JwtRsaSsaPkcs1PrivateKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{1}
}

func (x *JwtRsaSsaPkcs1PrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtRsaSsaPkcs1PrivateKey) GetPublicKey() *JwtRsaSsaPkcs1PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *JwtRsaSsaPkcs1PrivateKey) GetD() []byte {
	if x != nil {
		return x.D
	}
	return nil
}

func (x *JwtRsaSsaPkcs1PrivateKey) GetP() []byte {
	if x != nil {
		return x.P
	}
	return nil
}

func (x *JwtRsaSsaPkcs1PrivateKey) GetQ() []byte {
	if x != nil {
		return x.Q
	}
	return nil
}

func (x *JwtRsaSsaPkcs1PrivateKey) GetDp() []byte {
	if x != nil {
		return x.Dp
	}
	return nil
}

func (x *JwtRsaSsaPkcs1PrivateKey) GetDq() []byte {
	if x != nil {
		return x.Dq
	}
	return nil
}

func (x *JwtRsaSsaPkcs1PrivateKey) GetCrt() []byte {
	if x != nil {
		return x.Crt
	}
	return nil
}

type JwtRsaSsaPkcs1KeyFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version           uint32                  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm         JwtRsaSsaPkcs1Algorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtRsaSsaPkcs1Algorithm" json:"algorithm,omitempty"`
	ModulusSizeInBits uint32                  `protobuf:"varint,3,opt,name=modulus_size_in_bits,json=modulusSizeInBits,proto3" json:"modulus_size_in_bits,omitempty"`
	PublicExponent    []byte                  `protobuf:"bytes,4,opt,name=public_exponent,json=publicExponent,proto3" json:"public_exponent,omitempty"`
}

func (x *JwtRsaSsaPkcs1KeyFormat) Reset() {
	*x = JwtRsaSsaPkcs1KeyFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtRsaSsaPkcs1KeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRsaSsaPkcs1KeyFormat) ProtoMessage() {}

func (x *JwtRsaSsaPkcs1KeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRsaSsaPkcs1KeyFormat.ProtoReflect.Descriptor instead.
func (*JwtRsaSsaPkcs1KeyFormat) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{2}
}

func (x *JwtRsaSsaPkcs1KeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtRsaSsaPkcs1KeyFormat) GetAlgorithm() JwtRsaSsaPkcs1Algorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtRsaSsaPkcs1Algorithm_RS_UNKNOWN
}

func (x *JwtRsaSsaPkcs1KeyFormat) GetModulusSizeInBits() uint32 {
	if x != nil {
		return x.ModulusSizeInBits
	}
	return 0
}

func (x *JwtRsaSsaPkcs1KeyFormat) GetPublicExponent() []byte {
	if x != nil {
		return x.PublicExponent
	}
	return nil
}

// Optional, custom kid header value to be used with "RAW" keys.
// "TINK" keys with this value set will be rejected.
type JwtRsaSsaPkcs1PublicKey_CustomKid struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *JwtRsaSsaPkcs1PublicKey_CustomKid) Reset() {
	*x = JwtRsaSsaPkcs1PublicKey_CustomKid{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtRsaSsaPkcs1PublicKey_CustomKid) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtRsaSsaPkcs1PublicKey_CustomKid) ProtoMessage() {}

func (x *JwtRsaSsaPkcs1PublicKey_CustomKid) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtRsaSsaPkcs1PublicKey_CustomKid.ProtoReflect.Descriptor instead.
func (*JwtRsaSsaPkcs1PublicKey_CustomKid) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{0, 0}
}

func (x *JwtRsaSsaPkcs1PublicKey_CustomKid) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto protoreflect.FileDescriptor

var file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69,
	0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x6a, 0x77, 0x74, 0x5f, 0x72, 0x73, 0x61,
	0x5f, 0x73, 0x73, 0x61, 0x5f, 0x70, 0x6b, 0x63, 0x73, 0x31, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e,
	0x74, 0x69, 0x6e, 0x6b, 0x22, 0x93, 0x02, 0x0a, 0x17, 0x4a, 0x77, 0x74, 0x52, 0x73, 0x61, 0x53,
	0x73, 0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x09, 0x61, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69,
	0x6e, 0x6b, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x6b, 0x63, 0x73,
	0x31, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x0c, 0x0a, 0x01, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x01, 0x6e, 0x12, 0x0c, 0x0a, 0x01, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01,
	0x65, 0x12, 0x54, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6b, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x73,
	0x61, 0x53, 0x73, 0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4b, 0x69, 0x64, 0x52, 0x09, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4b, 0x69, 0x64, 0x1a, 0x21, 0x0a, 0x09, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4b, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xdc, 0x01, 0x0a, 0x18, 0x4a,
	0x77, 0x74, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x4a, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x73,
	0x61, 0x53, 0x73, 0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x0c, 0x0a,
	0x01, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x64, 0x12, 0x0c, 0x0a, 0x01, 0x70,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x70, 0x12, 0x0c, 0x0a, 0x01, 0x71, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x71, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x70, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x02, 0x64, 0x70, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x71, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x02, 0x64, 0x71, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x72, 0x74, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x63, 0x72, 0x74, 0x22, 0xd8, 0x01, 0x0a, 0x17, 0x4a, 0x77,
	0x74, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x4b, 0x65, 0x79, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x49, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x4a, 0x77, 0x74, 0x52, 0x73, 0x61, 0x53, 0x73,
	0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52,
	0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x2f, 0x0a, 0x14, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x75, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x69,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x75,
	0x73, 0x53, 0x69, 0x7a, 0x65, 0x49, 0x6e, 0x42, 0x69, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x45, 0x78, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x2a, 0x4a, 0x0a, 0x17, 0x4a, 0x77, 0x74, 0x52, 0x73, 0x61, 0x53, 0x73,
	0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12,
	0x0e, 0x0a, 0x0a, 0x52, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x52, 0x53, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x53,
	0x33, 0x38, 0x34, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x53, 0x35, 0x31, 0x32, 0x10, 0x03,
	0x42, 0x58, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x36, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x69, 0x6e, 0x6b, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x72, 0x73, 0x61, 0x5f, 0x73, 0x73, 0x61, 0x5f, 0x70, 0x6b, 0x63, 0x73,
	0x31, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescOnce sync.Once
	file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescData = file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDesc
)

func file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescGZIP() []byte {
	file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescOnce.Do(func() {
		file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescData = protoimpl.X.CompressGZIP(file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescData)
	})
	return file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDescData
}

var file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_goTypes = []interface{}{
	(JwtRsaSsaPkcs1Algorithm)(0),              // 0: google.crypto.tink.JwtRsaSsaPkcs1Algorithm
	(*JwtRsaSsaPkcs1PublicKey)(nil),           // 1: google.crypto.tink.JwtRsaSsaPkcs1PublicKey
	(*JwtRsaSsaPkcs1PrivateKey)(nil),          // 2: google.crypto.tink.JwtRsaSsaPkcs1PrivateKey
	(*JwtRsaSsaPkcs1KeyFormat)(nil),           // 3: google.crypto.tink.JwtRsaSsaPkcs1KeyFormat
	(*JwtRsaSsaPkcs1PublicKey_CustomKid)(nil), // 4: google.crypto.tink.JwtRsaSsaPkcs1PublicKey.CustomKid
}
var file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.JwtRsaSsaPkcs1PublicKey.algorithm:type_name -> google.crypto.tink.JwtRsaSsaPkcs1Algorithm
	4, // 1: google.crypto.tink.JwtRsaSsaPkcs1PublicKey.custom_kid:type_name -> google.crypto.tink.JwtRsaSsaPkcs1PublicKey.CustomKid
	1, // 2: google.crypto.tink.JwtRsaSsaPkcs1PrivateKey.public_key:type_name -> google.crypto.tink.JwtRsaSsaPkcs1PublicKey
	0, // 3: google.crypto.tink.JwtRsaSsaPkcs1KeyFormat.algorithm:type_name -> google.crypto.tink.JwtRsaSsaPkcs1Algorithm
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_init() }
func file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_init() {
	if File_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtRsaSsaPkcs1PublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtRsaSsaPkcs1PrivateKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtRsaSsaPkcs1KeyFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtRsaSsaPkcs1PublicKey_CustomKid); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_goTypes,
		DependencyIndexes: file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_depIdxs,
		EnumInfos:         file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_enumTypes,
		MessageInfos:      file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_msgTypes,
	}.Build()
	File_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto = out.File
	file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_rawDesc = nil
	file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_goTypes = nil
	file_third_party_tink_proto_jwt_rsa_ssa_pkcs1_proto_depIdxs = nil
}
