// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/ad.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad.
type Ad struct {
	// The resource name of the ad.
	// Ad resource names have the form:
	//
	// `customers/{customer_id}/ads/{ad_id}`
	ResourceName string `protobuf:"bytes,37,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the ad.
	Id *wrappers.Int64Value `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The list of possible final URLs after all cross-domain redirects for the
	// ad.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,2,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of final app URLs that will be used on mobile if the user has the
	// specific app installed.
	FinalAppUrls []*common.FinalAppUrl `protobuf:"bytes,35,rep,name=final_app_urls,json=finalAppUrls,proto3" json:"final_app_urls,omitempty"`
	// The list of possible final mobile URLs after all cross-domain redirects
	// for the ad.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,16,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,12,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The suffix to use when constructing a final URL.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,38,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// The list of mappings that can be used to substitute custom parameter tags
	// in a `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,10,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The URL that appears in the ad description for some ad formats.
	DisplayUrl *wrappers.StringValue `protobuf:"bytes,4,opt,name=display_url,json=displayUrl,proto3" json:"display_url,omitempty"`
	// The type of ad.
	Type enums.AdTypeEnum_AdType `protobuf:"varint,5,opt,name=type,proto3,enum=google.ads.googleads.v2.enums.AdTypeEnum_AdType" json:"type,omitempty"`
	// Indicates if this ad was automatically added by Google Ads and not by a
	// user. For example, this could happen when ads are automatically created as
	// suggestions for new ads based on knowledge of how existing ads are
	// performing.
	AddedByGoogleAds *wrappers.BoolValue `protobuf:"bytes,19,opt,name=added_by_google_ads,json=addedByGoogleAds,proto3" json:"added_by_google_ads,omitempty"`
	// The device preference for the ad. You can only specify a preference for
	// mobile devices. When this preference is set the ad will be preferred over
	// other ads when being displayed on a mobile device. The ad can still be
	// displayed on other device types, e.g. if no other ads are available.
	// If unspecified (no device preference), all devices are targeted.
	// This is only supported by some ad types.
	DevicePreference enums.DeviceEnum_Device `protobuf:"varint,20,opt,name=device_preference,json=devicePreference,proto3,enum=google.ads.googleads.v2.enums.DeviceEnum_Device" json:"device_preference,omitempty"`
	// Additional URLs for the ad that are tagged with a unique identifier that
	// can be referenced from other fields in the ad.
	UrlCollections []*common.UrlCollection `protobuf:"bytes,26,rep,name=url_collections,json=urlCollections,proto3" json:"url_collections,omitempty"`
	// The name of the ad. This is only used to be able to identify the ad. It
	// does not need to be unique and does not affect the served ad.
	Name *wrappers.StringValue `protobuf:"bytes,23,opt,name=name,proto3" json:"name,omitempty"`
	// If this ad is system managed, then this field will indicate the source.
	// This field is read-only.
	SystemManagedResourceSource enums.SystemManagedResourceSourceEnum_SystemManagedResourceSource `protobuf:"varint,27,opt,name=system_managed_resource_source,json=systemManagedResourceSource,proto3,enum=google.ads.googleads.v2.enums.SystemManagedResourceSourceEnum_SystemManagedResourceSource" json:"system_managed_resource_source,omitempty"`
	// Details pertinent to the ad type. Exactly one value must be set.
	//
	// Types that are valid to be assigned to AdData:
	//	*Ad_TextAd
	//	*Ad_ExpandedTextAd
	//	*Ad_CallOnlyAd
	//	*Ad_ExpandedDynamicSearchAd
	//	*Ad_HotelAd
	//	*Ad_ShoppingSmartAd
	//	*Ad_ShoppingProductAd
	//	*Ad_GmailAd
	//	*Ad_ImageAd
	//	*Ad_VideoAd
	//	*Ad_ResponsiveSearchAd
	//	*Ad_LegacyResponsiveDisplayAd
	//	*Ad_AppAd
	//	*Ad_LegacyAppInstallAd
	//	*Ad_ResponsiveDisplayAd
	//	*Ad_DisplayUploadAd
	//	*Ad_AppEngagementAd
	//	*Ad_ShoppingComparisonListingAd
	AdData               isAd_AdData `protobuf_oneof:"ad_data"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Ad) Reset()         { *m = Ad{} }
func (m *Ad) String() string { return proto.CompactTextString(m) }
func (*Ad) ProtoMessage()    {}
func (*Ad) Descriptor() ([]byte, []int) {
	return fileDescriptor_f86c36d18f064a67, []int{0}
}

func (m *Ad) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ad.Unmarshal(m, b)
}
func (m *Ad) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ad.Marshal(b, m, deterministic)
}
func (m *Ad) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ad.Merge(m, src)
}
func (m *Ad) XXX_Size() int {
	return xxx_messageInfo_Ad.Size(m)
}
func (m *Ad) XXX_DiscardUnknown() {
	xxx_messageInfo_Ad.DiscardUnknown(m)
}

var xxx_messageInfo_Ad proto.InternalMessageInfo

func (m *Ad) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Ad) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Ad) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *Ad) GetFinalAppUrls() []*common.FinalAppUrl {
	if m != nil {
		return m.FinalAppUrls
	}
	return nil
}

func (m *Ad) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *Ad) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *Ad) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *Ad) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *Ad) GetDisplayUrl() *wrappers.StringValue {
	if m != nil {
		return m.DisplayUrl
	}
	return nil
}

func (m *Ad) GetType() enums.AdTypeEnum_AdType {
	if m != nil {
		return m.Type
	}
	return enums.AdTypeEnum_UNSPECIFIED
}

func (m *Ad) GetAddedByGoogleAds() *wrappers.BoolValue {
	if m != nil {
		return m.AddedByGoogleAds
	}
	return nil
}

func (m *Ad) GetDevicePreference() enums.DeviceEnum_Device {
	if m != nil {
		return m.DevicePreference
	}
	return enums.DeviceEnum_UNSPECIFIED
}

func (m *Ad) GetUrlCollections() []*common.UrlCollection {
	if m != nil {
		return m.UrlCollections
	}
	return nil
}

func (m *Ad) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Ad) GetSystemManagedResourceSource() enums.SystemManagedResourceSourceEnum_SystemManagedResourceSource {
	if m != nil {
		return m.SystemManagedResourceSource
	}
	return enums.SystemManagedResourceSourceEnum_UNSPECIFIED
}

type isAd_AdData interface {
	isAd_AdData()
}

type Ad_TextAd struct {
	TextAd *common.TextAdInfo `protobuf:"bytes,6,opt,name=text_ad,json=textAd,proto3,oneof"`
}

type Ad_ExpandedTextAd struct {
	ExpandedTextAd *common.ExpandedTextAdInfo `protobuf:"bytes,7,opt,name=expanded_text_ad,json=expandedTextAd,proto3,oneof"`
}

type Ad_CallOnlyAd struct {
	CallOnlyAd *common.CallOnlyAdInfo `protobuf:"bytes,13,opt,name=call_only_ad,json=callOnlyAd,proto3,oneof"`
}

type Ad_ExpandedDynamicSearchAd struct {
	ExpandedDynamicSearchAd *common.ExpandedDynamicSearchAdInfo `protobuf:"bytes,14,opt,name=expanded_dynamic_search_ad,json=expandedDynamicSearchAd,proto3,oneof"`
}

type Ad_HotelAd struct {
	HotelAd *common.HotelAdInfo `protobuf:"bytes,15,opt,name=hotel_ad,json=hotelAd,proto3,oneof"`
}

type Ad_ShoppingSmartAd struct {
	ShoppingSmartAd *common.ShoppingSmartAdInfo `protobuf:"bytes,17,opt,name=shopping_smart_ad,json=shoppingSmartAd,proto3,oneof"`
}

type Ad_ShoppingProductAd struct {
	ShoppingProductAd *common.ShoppingProductAdInfo `protobuf:"bytes,18,opt,name=shopping_product_ad,json=shoppingProductAd,proto3,oneof"`
}

type Ad_GmailAd struct {
	GmailAd *common.GmailAdInfo `protobuf:"bytes,21,opt,name=gmail_ad,json=gmailAd,proto3,oneof"`
}

type Ad_ImageAd struct {
	ImageAd *common.ImageAdInfo `protobuf:"bytes,22,opt,name=image_ad,json=imageAd,proto3,oneof"`
}

type Ad_VideoAd struct {
	VideoAd *common.VideoAdInfo `protobuf:"bytes,24,opt,name=video_ad,json=videoAd,proto3,oneof"`
}

type Ad_ResponsiveSearchAd struct {
	ResponsiveSearchAd *common.ResponsiveSearchAdInfo `protobuf:"bytes,25,opt,name=responsive_search_ad,json=responsiveSearchAd,proto3,oneof"`
}

type Ad_LegacyResponsiveDisplayAd struct {
	LegacyResponsiveDisplayAd *common.LegacyResponsiveDisplayAdInfo `protobuf:"bytes,28,opt,name=legacy_responsive_display_ad,json=legacyResponsiveDisplayAd,proto3,oneof"`
}

type Ad_AppAd struct {
	AppAd *common.AppAdInfo `protobuf:"bytes,29,opt,name=app_ad,json=appAd,proto3,oneof"`
}

type Ad_LegacyAppInstallAd struct {
	LegacyAppInstallAd *common.LegacyAppInstallAdInfo `protobuf:"bytes,30,opt,name=legacy_app_install_ad,json=legacyAppInstallAd,proto3,oneof"`
}

type Ad_ResponsiveDisplayAd struct {
	ResponsiveDisplayAd *common.ResponsiveDisplayAdInfo `protobuf:"bytes,31,opt,name=responsive_display_ad,json=responsiveDisplayAd,proto3,oneof"`
}

type Ad_DisplayUploadAd struct {
	DisplayUploadAd *common.DisplayUploadAdInfo `protobuf:"bytes,33,opt,name=display_upload_ad,json=displayUploadAd,proto3,oneof"`
}

type Ad_AppEngagementAd struct {
	AppEngagementAd *common.AppEngagementAdInfo `protobuf:"bytes,34,opt,name=app_engagement_ad,json=appEngagementAd,proto3,oneof"`
}

type Ad_ShoppingComparisonListingAd struct {
	ShoppingComparisonListingAd *common.ShoppingComparisonListingAdInfo `protobuf:"bytes,36,opt,name=shopping_comparison_listing_ad,json=shoppingComparisonListingAd,proto3,oneof"`
}

func (*Ad_TextAd) isAd_AdData() {}

func (*Ad_ExpandedTextAd) isAd_AdData() {}

func (*Ad_CallOnlyAd) isAd_AdData() {}

func (*Ad_ExpandedDynamicSearchAd) isAd_AdData() {}

func (*Ad_HotelAd) isAd_AdData() {}

func (*Ad_ShoppingSmartAd) isAd_AdData() {}

func (*Ad_ShoppingProductAd) isAd_AdData() {}

func (*Ad_GmailAd) isAd_AdData() {}

func (*Ad_ImageAd) isAd_AdData() {}

func (*Ad_VideoAd) isAd_AdData() {}

func (*Ad_ResponsiveSearchAd) isAd_AdData() {}

func (*Ad_LegacyResponsiveDisplayAd) isAd_AdData() {}

func (*Ad_AppAd) isAd_AdData() {}

func (*Ad_LegacyAppInstallAd) isAd_AdData() {}

func (*Ad_ResponsiveDisplayAd) isAd_AdData() {}

func (*Ad_DisplayUploadAd) isAd_AdData() {}

func (*Ad_AppEngagementAd) isAd_AdData() {}

func (*Ad_ShoppingComparisonListingAd) isAd_AdData() {}

func (m *Ad) GetAdData() isAd_AdData {
	if m != nil {
		return m.AdData
	}
	return nil
}

func (m *Ad) GetTextAd() *common.TextAdInfo {
	if x, ok := m.GetAdData().(*Ad_TextAd); ok {
		return x.TextAd
	}
	return nil
}

func (m *Ad) GetExpandedTextAd() *common.ExpandedTextAdInfo {
	if x, ok := m.GetAdData().(*Ad_ExpandedTextAd); ok {
		return x.ExpandedTextAd
	}
	return nil
}

func (m *Ad) GetCallOnlyAd() *common.CallOnlyAdInfo {
	if x, ok := m.GetAdData().(*Ad_CallOnlyAd); ok {
		return x.CallOnlyAd
	}
	return nil
}

func (m *Ad) GetExpandedDynamicSearchAd() *common.ExpandedDynamicSearchAdInfo {
	if x, ok := m.GetAdData().(*Ad_ExpandedDynamicSearchAd); ok {
		return x.ExpandedDynamicSearchAd
	}
	return nil
}

func (m *Ad) GetHotelAd() *common.HotelAdInfo {
	if x, ok := m.GetAdData().(*Ad_HotelAd); ok {
		return x.HotelAd
	}
	return nil
}

func (m *Ad) GetShoppingSmartAd() *common.ShoppingSmartAdInfo {
	if x, ok := m.GetAdData().(*Ad_ShoppingSmartAd); ok {
		return x.ShoppingSmartAd
	}
	return nil
}

func (m *Ad) GetShoppingProductAd() *common.ShoppingProductAdInfo {
	if x, ok := m.GetAdData().(*Ad_ShoppingProductAd); ok {
		return x.ShoppingProductAd
	}
	return nil
}

func (m *Ad) GetGmailAd() *common.GmailAdInfo {
	if x, ok := m.GetAdData().(*Ad_GmailAd); ok {
		return x.GmailAd
	}
	return nil
}

func (m *Ad) GetImageAd() *common.ImageAdInfo {
	if x, ok := m.GetAdData().(*Ad_ImageAd); ok {
		return x.ImageAd
	}
	return nil
}

func (m *Ad) GetVideoAd() *common.VideoAdInfo {
	if x, ok := m.GetAdData().(*Ad_VideoAd); ok {
		return x.VideoAd
	}
	return nil
}

func (m *Ad) GetResponsiveSearchAd() *common.ResponsiveSearchAdInfo {
	if x, ok := m.GetAdData().(*Ad_ResponsiveSearchAd); ok {
		return x.ResponsiveSearchAd
	}
	return nil
}

func (m *Ad) GetLegacyResponsiveDisplayAd() *common.LegacyResponsiveDisplayAdInfo {
	if x, ok := m.GetAdData().(*Ad_LegacyResponsiveDisplayAd); ok {
		return x.LegacyResponsiveDisplayAd
	}
	return nil
}

func (m *Ad) GetAppAd() *common.AppAdInfo {
	if x, ok := m.GetAdData().(*Ad_AppAd); ok {
		return x.AppAd
	}
	return nil
}

func (m *Ad) GetLegacyAppInstallAd() *common.LegacyAppInstallAdInfo {
	if x, ok := m.GetAdData().(*Ad_LegacyAppInstallAd); ok {
		return x.LegacyAppInstallAd
	}
	return nil
}

func (m *Ad) GetResponsiveDisplayAd() *common.ResponsiveDisplayAdInfo {
	if x, ok := m.GetAdData().(*Ad_ResponsiveDisplayAd); ok {
		return x.ResponsiveDisplayAd
	}
	return nil
}

func (m *Ad) GetDisplayUploadAd() *common.DisplayUploadAdInfo {
	if x, ok := m.GetAdData().(*Ad_DisplayUploadAd); ok {
		return x.DisplayUploadAd
	}
	return nil
}

func (m *Ad) GetAppEngagementAd() *common.AppEngagementAdInfo {
	if x, ok := m.GetAdData().(*Ad_AppEngagementAd); ok {
		return x.AppEngagementAd
	}
	return nil
}

func (m *Ad) GetShoppingComparisonListingAd() *common.ShoppingComparisonListingAdInfo {
	if x, ok := m.GetAdData().(*Ad_ShoppingComparisonListingAd); ok {
		return x.ShoppingComparisonListingAd
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Ad) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Ad_TextAd)(nil),
		(*Ad_ExpandedTextAd)(nil),
		(*Ad_CallOnlyAd)(nil),
		(*Ad_ExpandedDynamicSearchAd)(nil),
		(*Ad_HotelAd)(nil),
		(*Ad_ShoppingSmartAd)(nil),
		(*Ad_ShoppingProductAd)(nil),
		(*Ad_GmailAd)(nil),
		(*Ad_ImageAd)(nil),
		(*Ad_VideoAd)(nil),
		(*Ad_ResponsiveSearchAd)(nil),
		(*Ad_LegacyResponsiveDisplayAd)(nil),
		(*Ad_AppAd)(nil),
		(*Ad_LegacyAppInstallAd)(nil),
		(*Ad_ResponsiveDisplayAd)(nil),
		(*Ad_DisplayUploadAd)(nil),
		(*Ad_AppEngagementAd)(nil),
		(*Ad_ShoppingComparisonListingAd)(nil),
	}
}

func init() {
	proto.RegisterType((*Ad)(nil), "google.ads.googleads.v2.resources.Ad")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/ad.proto", fileDescriptor_f86c36d18f064a67)
}

var fileDescriptor_f86c36d18f064a67 = []byte{
	// 1257 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x97, 0xdf, 0x72, 0xd4, 0x36,
	0x1b, 0xc6, 0xbf, 0x5d, 0x20, 0xf9, 0x10, 0x21, 0x7f, 0x14, 0x02, 0x26, 0x49, 0x69, 0x80, 0xd2,
	0x49, 0x61, 0xea, 0x65, 0x96, 0x42, 0x67, 0x96, 0x61, 0x5a, 0x87, 0x04, 0x92, 0x0e, 0xb4, 0xa9,
	0x97, 0xe4, 0x80, 0x49, 0xeb, 0x51, 0x2c, 0xad, 0xe3, 0x22, 0x4b, 0x1a, 0xc9, 0x4e, 0xb3, 0x3d,
	0xea, 0x51, 0x6f, 0xa3, 0x33, 0x3d, 0xec, 0xa5, 0xf4, 0x22, 0x7a, 0x01, 0x3d, 0xee, 0x05, 0x74,
	0x24, 0xd9, 0x5a, 0x36, 0x61, 0x63, 0x9f, 0x24, 0x96, 0xf4, 0x3e, 0xbf, 0xe7, 0xd5, 0x2b, 0x4b,
	0x5a, 0x83, 0xfb, 0x09, 0xe7, 0x09, 0x25, 0x1d, 0x84, 0x55, 0xc7, 0x3e, 0xea, 0xa7, 0xe3, 0x6e,
	0x47, 0x12, 0xc5, 0x0b, 0x19, 0x13, 0xd5, 0x41, 0xd8, 0x17, 0x92, 0xe7, 0x1c, 0xde, 0xb6, 0x01,
	0x3e, 0xc2, 0xca, 0x77, 0xb1, 0xfe, 0x71, 0xd7, 0x77, 0xb1, 0xcb, 0xdd, 0x49, 0xb8, 0x98, 0x67,
	0x19, 0x67, 0x1d, 0x84, 0xa3, 0x7c, 0x28, 0x48, 0x94, 0xb2, 0x01, 0x57, 0x16, 0xbb, 0xfc, 0xb8,
	0x46, 0x13, 0x17, 0x2a, 0xe7, 0x59, 0x24, 0x90, 0x44, 0x19, 0xc9, 0x89, 0x2c, 0x65, 0x75, 0x56,
	0x83, 0x94, 0x21, 0x1a, 0x21, 0x21, 0xa2, 0x42, 0xd2, 0x52, 0xf3, 0xa8, 0x46, 0x53, 0x48, 0x1a,
	0xc5, 0x9c, 0x52, 0x12, 0xe7, 0x29, 0x67, 0xa5, 0xe8, 0xc1, 0x24, 0x11, 0x61, 0x45, 0xa6, 0xaa,
	0x29, 0x95, 0xc1, 0xf7, 0xcf, 0x0f, 0xc6, 0xe4, 0x38, 0x8d, 0xab, 0xd8, 0xaf, 0xcf, 0x8f, 0x55,
	0x43, 0x95, 0x93, 0x2c, 0xca, 0x10, 0x43, 0x09, 0xc1, 0x11, 0x61, 0x79, 0x9a, 0x0f, 0x23, 0x5b,
	0xe9, 0x92, 0x70, 0xab, 0x24, 0x98, 0xd6, 0x61, 0x31, 0xe8, 0xfc, 0x2c, 0x91, 0x10, 0x44, 0x56,
	0xa5, 0x5d, 0xad, 0x1c, 0x44, 0xda, 0x41, 0x8c, 0xf1, 0x1c, 0xe9, 0x79, 0x95, 0xa3, 0x77, 0xfe,
	0xbe, 0x0e, 0xda, 0x01, 0x86, 0x77, 0xc1, 0xd5, 0x6a, 0x01, 0x23, 0x86, 0x32, 0xe2, 0xdd, 0x5b,
	0x6b, 0xad, 0x5f, 0x0e, 0x67, 0xaa, 0xce, 0x6f, 0x51, 0x46, 0xe0, 0x03, 0xd0, 0x4e, 0xb1, 0xd7,
	0x5a, 0x6b, 0xad, 0x5f, 0xe9, 0xae, 0x94, 0xab, 0xef, 0x57, 0xb6, 0xfe, 0x0e, 0xcb, 0x9f, 0x7c,
	0xb1, 0x8f, 0x68, 0x41, 0xc2, 0x76, 0x8a, 0xe1, 0x53, 0x00, 0x6c, 0xf5, 0x0b, 0x49, 0x95, 0xd7,
	0x5e, 0xbb, 0xb0, 0x7e, 0xa5, 0xbb, 0x7a, 0x46, 0xd4, 0xcf, 0x65, 0xca, 0x12, 0xab, 0xba, 0x6c,
	0xe2, 0xf7, 0x24, 0x55, 0xf0, 0x7b, 0x30, 0x3b, 0xb6, 0x74, 0xca, 0xbb, 0x6b, 0x00, 0x0f, 0xfc,
	0x49, 0xaf, 0x9f, 0x5d, 0x3c, 0xff, 0x85, 0x56, 0x05, 0x42, 0xec, 0x49, 0x1a, 0xce, 0x0c, 0x46,
	0x0d, 0x05, 0xb7, 0xc1, 0x82, 0x45, 0x66, 0xfc, 0x30, 0xa5, 0xc4, 0x52, 0xe7, 0x1b, 0xa4, 0x35,
	0x67, 0x64, 0xaf, 0x8d, 0xca, 0x90, 0x76, 0xc1, 0x52, 0x2e, 0x51, 0xfc, 0x2e, 0x65, 0x89, 0xa6,
	0x44, 0x39, 0xc9, 0x04, 0x45, 0x39, 0xf1, 0x66, 0x4c, 0x65, 0xce, 0xa7, 0x2d, 0x56, 0xd2, 0x3d,
	0x49, 0xdf, 0x94, 0x42, 0xf8, 0x02, 0xcc, 0xbb, 0x5a, 0x45, 0xaa, 0x18, 0x0c, 0xd2, 0x13, 0xef,
	0xd3, 0x06, 0xb0, 0xd9, 0xaa, 0x62, 0x7d, 0xa3, 0x81, 0x31, 0x58, 0x32, 0x6f, 0xef, 0xa9, 0xcd,
	0xa2, 0x3c, 0x60, 0xe6, 0xd9, 0xa9, 0xab, 0xde, 0x73, 0x23, 0xdc, 0xad, 0x74, 0xe1, 0x62, 0x21,
	0xe9, 0xa9, 0x3e, 0x05, 0x9f, 0x81, 0x2b, 0x38, 0x55, 0x82, 0xa2, 0xa1, 0x4e, 0xd7, 0xbb, 0xd8,
	0x20, 0x4f, 0x50, 0x0a, 0xf6, 0x24, 0x85, 0x9b, 0xe0, 0xa2, 0xde, 0x2a, 0xde, 0xa5, 0xb5, 0xd6,
	0xfa, 0x6c, 0xf7, 0xe1, 0xc4, 0x94, 0xcc, 0xfb, 0xef, 0x07, 0xf8, 0xcd, 0x50, 0x90, 0x2d, 0x56,
	0x64, 0xe5, 0x63, 0x68, 0xd4, 0x70, 0x07, 0x2c, 0x22, 0x8c, 0x09, 0x8e, 0x0e, 0x87, 0x91, 0x95,
	0x45, 0x08, 0x2b, 0x6f, 0xd1, 0x24, 0xb3, 0x7c, 0x26, 0x99, 0x0d, 0xce, 0xa9, 0x4d, 0x65, 0xde,
	0xc8, 0x36, 0x86, 0x2f, 0x4d, 0x44, 0x80, 0x15, 0xfc, 0x01, 0x2c, 0xd8, 0x1d, 0x19, 0x09, 0x49,
	0x06, 0x44, 0x12, 0x16, 0x13, 0xef, 0x5a, 0xa3, 0xec, 0x36, 0x8d, 0xce, 0x64, 0x67, 0x1f, 0xc3,
	0x79, 0x8b, 0xda, 0x75, 0x24, 0xb8, 0x0f, 0xe6, 0xc6, 0x4f, 0x14, 0xe5, 0x2d, 0x9b, 0xd5, 0xf8,
	0xbc, 0x6e, 0x35, 0xf6, 0x24, 0x7d, 0xee, 0x54, 0xe1, 0x6c, 0xf1, 0x7e, 0x53, 0xc1, 0x87, 0xe0,
	0xa2, 0xd9, 0xa8, 0x37, 0x1a, 0xd4, 0xdf, 0x44, 0xc2, 0xdf, 0x5b, 0xe0, 0xd6, 0xa9, 0xf3, 0xc4,
	0xed, 0x79, 0xfb, 0xcf, 0x5b, 0x31, 0xd3, 0x7e, 0x5b, 0x33, 0xed, 0xbe, 0x81, 0xbc, 0xb6, 0x8c,
	0xb0, 0x44, 0xf4, 0xcd, 0x5f, 0x53, 0x8b, 0x73, 0xc6, 0xc3, 0x15, 0x35, 0x79, 0x10, 0x6e, 0x81,
	0xe9, 0x9c, 0x9c, 0xe4, 0x11, 0xc2, 0xde, 0x94, 0x99, 0xd6, 0xfd, 0xba, 0x1a, 0xbd, 0x21, 0x27,
	0x79, 0x80, 0x77, 0xd8, 0x80, 0x6f, 0xff, 0x2f, 0x9c, 0xca, 0x4d, 0x0b, 0xfe, 0x08, 0xe6, 0xc9,
	0x89, 0x40, 0x4c, 0xbf, 0x1f, 0x15, 0x6f, 0xda, 0xf0, 0xba, 0x75, 0xbc, 0xad, 0x52, 0x37, 0xc6,
	0x9d, 0x25, 0x63, 0xbd, 0x30, 0x04, 0x33, 0x31, 0xa2, 0x34, 0xe2, 0x8c, 0x0e, 0x35, 0xfb, 0xaa,
	0x61, 0xfb, 0xb5, 0xbb, 0x0b, 0x51, 0xfa, 0x1d, 0xa3, 0x43, 0xc7, 0x05, 0xb1, 0xeb, 0x81, 0xbf,
	0x80, 0x65, 0x97, 0x33, 0x1e, 0x32, 0x94, 0xa5, 0x71, 0xa4, 0x08, 0x92, 0xf1, 0x91, 0x76, 0x98,
	0x35, 0x0e, 0x4f, 0x9b, 0x66, 0xbf, 0x69, 0x01, 0x7d, 0xa3, 0x77, 0x76, 0x37, 0xc8, 0x87, 0x87,
	0xe1, 0x36, 0xf8, 0xff, 0x11, 0xcf, 0x09, 0xd5, 0x4e, 0x73, 0xc6, 0xa9, 0xf6, 0x9c, 0xdd, 0xd6,
	0xf1, 0x8e, 0x3c, 0x7d, 0x64, 0x9b, 0x10, 0x81, 0x05, 0x75, 0xc4, 0x85, 0xd0, 0x47, 0xa3, 0xca,
	0x90, 0x34, 0xa5, 0x5f, 0x30, 0xc8, 0x47, 0x75, 0xc8, 0x7e, 0x29, 0xec, 0x6b, 0x9d, 0x43, 0xcf,
	0xa9, 0xf1, 0x6e, 0x98, 0x80, 0x45, 0x67, 0x21, 0x24, 0xc7, 0x45, 0x6c, 0x4c, 0xa0, 0x31, 0x79,
	0xdc, 0xd4, 0x64, 0xd7, 0x2a, 0x9d, 0x8d, 0x4b, 0xdb, 0x0d, 0xe8, 0xaa, 0x24, 0x19, 0x4a, 0x4d,
	0x55, 0x96, 0x9a, 0x55, 0xe5, 0xa5, 0x8e, 0x1f, 0x55, 0x25, 0xb1, 0x4d, 0x4d, 0x4a, 0x33, 0x94,
	0xe8, 0x23, 0xca, 0xbb, 0xde, 0x8c, 0xb4, 0xa3, 0xe3, 0x47, 0xa4, 0xd4, 0x36, 0x35, 0xe9, 0x38,
	0xc5, 0x84, 0x6b, 0x92, 0xd7, 0x8c, 0xb4, 0xaf, 0xe3, 0x47, 0xa4, 0x63, 0xdb, 0x84, 0x3f, 0x81,
	0x6b, 0x92, 0x28, 0xc1, 0x99, 0x4a, 0x8f, 0xc9, 0x7b, 0x6f, 0xda, 0x4d, 0x43, 0x7d, 0x52, 0x47,
	0x0d, 0x9d, 0xf6, 0xd4, 0x4b, 0x06, 0xe5, 0x99, 0x11, 0xf8, 0x6b, 0x0b, 0xac, 0x52, 0x92, 0xa0,
	0x78, 0x18, 0xbd, 0xe7, 0x59, 0x5d, 0x22, 0x08, 0x7b, 0xab, 0xc6, 0xf4, 0x59, 0x9d, 0xe9, 0x2b,
	0xc3, 0x18, 0x59, 0x6f, 0x5a, 0x82, 0xf3, 0xbe, 0x49, 0x27, 0x05, 0xc0, 0x0d, 0x30, 0xa5, 0x7f,
	0x4a, 0x20, 0xec, 0x7d, 0x64, 0xbc, 0x3e, 0xab, 0xf3, 0x0a, 0x84, 0x70, 0xdc, 0x4b, 0x48, 0x37,
	0xe0, 0x3b, 0xb0, 0x54, 0xce, 0x42, 0xa3, 0x52, 0xa6, 0x72, 0x7d, 0x08, 0x20, 0xec, 0xdd, 0x6a,
	0x56, 0x33, 0x9b, 0x7e, 0x20, 0xc4, 0x8e, 0x95, 0x8e, 0x6a, 0x46, 0xcf, 0x8c, 0xc0, 0x0c, 0x2c,
	0x7d, 0xb8, 0x56, 0x1f, 0x1b, 0xb3, 0x2f, 0x9b, 0x2f, 0xd0, 0xe9, 0x2a, 0x2d, 0xca, 0x0f, 0xd4,
	0x07, 0x81, 0x05, 0x77, 0xa9, 0x0b, 0xca, 0x11, 0xd6, 0x56, 0xb7, 0x9b, 0x6d, 0xdc, 0x92, 0xb2,
	0x67, 0x74, 0xa3, 0x8d, 0x8b, 0xc7, 0xbb, 0xb5, 0x85, 0xae, 0x1b, 0x61, 0x09, 0x4a, 0x48, 0x46,
	0x98, 0xd9, 0xb6, 0x77, 0x9a, 0x59, 0x04, 0x42, 0x6c, 0x39, 0xdd, 0xc8, 0x02, 0x8d, 0x77, 0xc3,
	0xdf, 0xf4, 0x0d, 0x57, 0x1d, 0x0e, 0x31, 0xcf, 0x04, 0x92, 0xa9, 0xe2, 0x2c, 0xa2, 0xa9, 0xca,
	0x75, 0x17, 0xc2, 0xde, 0x27, 0xc6, 0xf0, 0xab, 0xa6, 0xe7, 0xc4, 0x73, 0x07, 0x79, 0x65, 0x19,
	0xce, 0x7c, 0x45, 0x4d, 0x0e, 0xd9, 0xb8, 0x0c, 0xa6, 0x11, 0x8e, 0x30, 0xca, 0xd1, 0xc6, 0xbf,
	0x2d, 0x70, 0x2f, 0xe6, 0x99, 0x5f, 0xfb, 0xdd, 0xb4, 0x31, 0x1d, 0xe0, 0x5d, 0x7d, 0x7b, 0xef,
	0xb6, 0xde, 0x7e, 0x53, 0x46, 0x27, 0x9c, 0x22, 0x96, 0xf8, 0x5c, 0x26, 0x9d, 0x84, 0x30, 0x73,
	0xb7, 0x57, 0x5f, 0x09, 0x22, 0x55, 0xe7, 0x7c, 0xb0, 0x3d, 0x75, 0x4f, 0x7f, 0xb4, 0x2f, 0xbc,
	0x0c, 0x82, 0x3f, 0xdb, 0xb7, 0xed, 0x2f, 0x1e, 0x3f, 0xc0, 0xca, 0x77, 0x3f, 0x7e, 0xfc, 0xfd,
	0xae, 0x5f, 0xdd, 0xc1, 0xea, 0xaf, 0x2a, 0xe6, 0x20, 0xc0, 0xea, 0xc0, 0xc5, 0x1c, 0xec, 0x77,
	0x0f, 0x5c, 0xcc, 0x3f, 0xed, 0x7b, 0x76, 0xa0, 0xd7, 0x0b, 0xb0, 0xea, 0xf5, 0x5c, 0x54, 0xaf,
	0xb7, 0xdf, 0xed, 0xf5, 0x5c, 0xdc, 0xe1, 0x94, 0x49, 0xf6, 0xd1, 0x7f, 0x01, 0x00, 0x00, 0xff,
	0xff, 0x4f, 0xfc, 0x6d, 0xac, 0x5c, 0x0e, 0x00, 0x00,
}
