// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/expr/v1alpha1/syntax.proto

package expr

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An expression together with source information as returned by the parser.
type ParsedExpr struct {
	// The parsed expression.
	Expr *Expr `protobuf:"bytes,2,opt,name=expr,proto3" json:"expr,omitempty"`
	// The source info derived from input that generated the parsed `expr`.
	SourceInfo           *SourceInfo `protobuf:"bytes,3,opt,name=source_info,json=sourceInfo,proto3" json:"source_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ParsedExpr) Reset()         { *m = ParsedExpr{} }
func (m *ParsedExpr) String() string { return proto.CompactTextString(m) }
func (*ParsedExpr) ProtoMessage()    {}
func (*ParsedExpr) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{0}
}

func (m *ParsedExpr) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParsedExpr.Unmarshal(m, b)
}
func (m *ParsedExpr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParsedExpr.Marshal(b, m, deterministic)
}
func (m *ParsedExpr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParsedExpr.Merge(m, src)
}
func (m *ParsedExpr) XXX_Size() int {
	return xxx_messageInfo_ParsedExpr.Size(m)
}
func (m *ParsedExpr) XXX_DiscardUnknown() {
	xxx_messageInfo_ParsedExpr.DiscardUnknown(m)
}

var xxx_messageInfo_ParsedExpr proto.InternalMessageInfo

func (m *ParsedExpr) GetExpr() *Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (m *ParsedExpr) GetSourceInfo() *SourceInfo {
	if m != nil {
		return m.SourceInfo
	}
	return nil
}

// An abstract representation of a common expression.
//
// Expressions are abstractly represented as a collection of identifiers,
// select statements, function calls, literals, and comprehensions. All
// operators with the exception of the '.' operator are modelled as function
// calls. This makes it easy to represent new operators into the existing AST.
//
// All references within expressions must resolve to a [Decl][google.api.expr.v1alpha1.Decl] provided at
// type-check for an expression to be valid. A reference may either be a bare
// identifier `name` or a qualified identifier `google.api.name`. References
// may either refer to a value or a function declaration.
//
// For example, the expression `google.api.name.startsWith('expr')` references
// the declaration `google.api.name` within a [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and
// the function declaration `startsWith`.
type Expr struct {
	// Required. An id assigned to this node by the parser which is unique in a
	// given expression tree. This is used to associate type information and other
	// attributes to a node in the parse tree.
	Id int64 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// Required. Variants of expressions.
	//
	// Types that are valid to be assigned to ExprKind:
	//	*Expr_ConstExpr
	//	*Expr_IdentExpr
	//	*Expr_SelectExpr
	//	*Expr_CallExpr
	//	*Expr_ListExpr
	//	*Expr_StructExpr
	//	*Expr_ComprehensionExpr
	ExprKind             isExpr_ExprKind `protobuf_oneof:"expr_kind"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Expr) Reset()         { *m = Expr{} }
func (m *Expr) String() string { return proto.CompactTextString(m) }
func (*Expr) ProtoMessage()    {}
func (*Expr) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1}
}

func (m *Expr) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr.Unmarshal(m, b)
}
func (m *Expr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr.Marshal(b, m, deterministic)
}
func (m *Expr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr.Merge(m, src)
}
func (m *Expr) XXX_Size() int {
	return xxx_messageInfo_Expr.Size(m)
}
func (m *Expr) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr.DiscardUnknown(m)
}

var xxx_messageInfo_Expr proto.InternalMessageInfo

func (m *Expr) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type isExpr_ExprKind interface {
	isExpr_ExprKind()
}

type Expr_ConstExpr struct {
	ConstExpr *Constant `protobuf:"bytes,3,opt,name=const_expr,json=constExpr,proto3,oneof"`
}

type Expr_IdentExpr struct {
	IdentExpr *Expr_Ident `protobuf:"bytes,4,opt,name=ident_expr,json=identExpr,proto3,oneof"`
}

type Expr_SelectExpr struct {
	SelectExpr *Expr_Select `protobuf:"bytes,5,opt,name=select_expr,json=selectExpr,proto3,oneof"`
}

type Expr_CallExpr struct {
	CallExpr *Expr_Call `protobuf:"bytes,6,opt,name=call_expr,json=callExpr,proto3,oneof"`
}

type Expr_ListExpr struct {
	ListExpr *Expr_CreateList `protobuf:"bytes,7,opt,name=list_expr,json=listExpr,proto3,oneof"`
}

type Expr_StructExpr struct {
	StructExpr *Expr_CreateStruct `protobuf:"bytes,8,opt,name=struct_expr,json=structExpr,proto3,oneof"`
}

type Expr_ComprehensionExpr struct {
	ComprehensionExpr *Expr_Comprehension `protobuf:"bytes,9,opt,name=comprehension_expr,json=comprehensionExpr,proto3,oneof"`
}

func (*Expr_ConstExpr) isExpr_ExprKind() {}

func (*Expr_IdentExpr) isExpr_ExprKind() {}

func (*Expr_SelectExpr) isExpr_ExprKind() {}

func (*Expr_CallExpr) isExpr_ExprKind() {}

func (*Expr_ListExpr) isExpr_ExprKind() {}

func (*Expr_StructExpr) isExpr_ExprKind() {}

func (*Expr_ComprehensionExpr) isExpr_ExprKind() {}

func (m *Expr) GetExprKind() isExpr_ExprKind {
	if m != nil {
		return m.ExprKind
	}
	return nil
}

func (m *Expr) GetConstExpr() *Constant {
	if x, ok := m.GetExprKind().(*Expr_ConstExpr); ok {
		return x.ConstExpr
	}
	return nil
}

func (m *Expr) GetIdentExpr() *Expr_Ident {
	if x, ok := m.GetExprKind().(*Expr_IdentExpr); ok {
		return x.IdentExpr
	}
	return nil
}

func (m *Expr) GetSelectExpr() *Expr_Select {
	if x, ok := m.GetExprKind().(*Expr_SelectExpr); ok {
		return x.SelectExpr
	}
	return nil
}

func (m *Expr) GetCallExpr() *Expr_Call {
	if x, ok := m.GetExprKind().(*Expr_CallExpr); ok {
		return x.CallExpr
	}
	return nil
}

func (m *Expr) GetListExpr() *Expr_CreateList {
	if x, ok := m.GetExprKind().(*Expr_ListExpr); ok {
		return x.ListExpr
	}
	return nil
}

func (m *Expr) GetStructExpr() *Expr_CreateStruct {
	if x, ok := m.GetExprKind().(*Expr_StructExpr); ok {
		return x.StructExpr
	}
	return nil
}

func (m *Expr) GetComprehensionExpr() *Expr_Comprehension {
	if x, ok := m.GetExprKind().(*Expr_ComprehensionExpr); ok {
		return x.ComprehensionExpr
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Expr) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Expr_ConstExpr)(nil),
		(*Expr_IdentExpr)(nil),
		(*Expr_SelectExpr)(nil),
		(*Expr_CallExpr)(nil),
		(*Expr_ListExpr)(nil),
		(*Expr_StructExpr)(nil),
		(*Expr_ComprehensionExpr)(nil),
	}
}

// An identifier expression. e.g. `request`.
type Expr_Ident struct {
	// Required. Holds a single, unqualified identifier, possibly preceded by a
	// '.'.
	//
	// Qualified names are represented by the [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_Ident) Reset()         { *m = Expr_Ident{} }
func (m *Expr_Ident) String() string { return proto.CompactTextString(m) }
func (*Expr_Ident) ProtoMessage()    {}
func (*Expr_Ident) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 0}
}

func (m *Expr_Ident) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_Ident.Unmarshal(m, b)
}
func (m *Expr_Ident) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_Ident.Marshal(b, m, deterministic)
}
func (m *Expr_Ident) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Ident.Merge(m, src)
}
func (m *Expr_Ident) XXX_Size() int {
	return xxx_messageInfo_Expr_Ident.Size(m)
}
func (m *Expr_Ident) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Ident.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Ident proto.InternalMessageInfo

func (m *Expr_Ident) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A field selection expression. e.g. `request.auth`.
type Expr_Select struct {
	// Required. The target of the selection expression.
	//
	// For example, in the select expression `request.auth`, the `request`
	// portion of the expression is the `operand`.
	Operand *Expr `protobuf:"bytes,1,opt,name=operand,proto3" json:"operand,omitempty"`
	// Required. The name of the field to select.
	//
	// For example, in the select expression `request.auth`, the `auth` portion
	// of the expression would be the `field`.
	Field string `protobuf:"bytes,2,opt,name=field,proto3" json:"field,omitempty"`
	// Whether the select is to be interpreted as a field presence test.
	//
	// This results from the macro `has(request.auth)`.
	TestOnly             bool     `protobuf:"varint,3,opt,name=test_only,json=testOnly,proto3" json:"test_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_Select) Reset()         { *m = Expr_Select{} }
func (m *Expr_Select) String() string { return proto.CompactTextString(m) }
func (*Expr_Select) ProtoMessage()    {}
func (*Expr_Select) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 1}
}

func (m *Expr_Select) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_Select.Unmarshal(m, b)
}
func (m *Expr_Select) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_Select.Marshal(b, m, deterministic)
}
func (m *Expr_Select) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Select.Merge(m, src)
}
func (m *Expr_Select) XXX_Size() int {
	return xxx_messageInfo_Expr_Select.Size(m)
}
func (m *Expr_Select) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Select.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Select proto.InternalMessageInfo

func (m *Expr_Select) GetOperand() *Expr {
	if m != nil {
		return m.Operand
	}
	return nil
}

func (m *Expr_Select) GetField() string {
	if m != nil {
		return m.Field
	}
	return ""
}

func (m *Expr_Select) GetTestOnly() bool {
	if m != nil {
		return m.TestOnly
	}
	return false
}

// A call expression, including calls to predefined functions and operators.
//
// For example, `value == 10`, `size(map_value)`.
type Expr_Call struct {
	// The target of an method call-style expression. For example, `x` in
	// `x.f()`.
	Target *Expr `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// Required. The name of the function or method being called.
	Function string `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
	// The arguments.
	Args                 []*Expr  `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_Call) Reset()         { *m = Expr_Call{} }
func (m *Expr_Call) String() string { return proto.CompactTextString(m) }
func (*Expr_Call) ProtoMessage()    {}
func (*Expr_Call) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 2}
}

func (m *Expr_Call) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_Call.Unmarshal(m, b)
}
func (m *Expr_Call) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_Call.Marshal(b, m, deterministic)
}
func (m *Expr_Call) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Call.Merge(m, src)
}
func (m *Expr_Call) XXX_Size() int {
	return xxx_messageInfo_Expr_Call.Size(m)
}
func (m *Expr_Call) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Call.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Call proto.InternalMessageInfo

func (m *Expr_Call) GetTarget() *Expr {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *Expr_Call) GetFunction() string {
	if m != nil {
		return m.Function
	}
	return ""
}

func (m *Expr_Call) GetArgs() []*Expr {
	if m != nil {
		return m.Args
	}
	return nil
}

// A list creation expression.
//
// Lists may either be homogenous, e.g. `[1, 2, 3]`, or heterogenous, e.g.
// `dyn([1, 'hello', 2.0])`
type Expr_CreateList struct {
	// The elements part of the list.
	Elements             []*Expr  `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_CreateList) Reset()         { *m = Expr_CreateList{} }
func (m *Expr_CreateList) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateList) ProtoMessage()    {}
func (*Expr_CreateList) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 3}
}

func (m *Expr_CreateList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_CreateList.Unmarshal(m, b)
}
func (m *Expr_CreateList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_CreateList.Marshal(b, m, deterministic)
}
func (m *Expr_CreateList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateList.Merge(m, src)
}
func (m *Expr_CreateList) XXX_Size() int {
	return xxx_messageInfo_Expr_CreateList.Size(m)
}
func (m *Expr_CreateList) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateList.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateList proto.InternalMessageInfo

func (m *Expr_CreateList) GetElements() []*Expr {
	if m != nil {
		return m.Elements
	}
	return nil
}

// A map or message creation expression.
//
// Maps are constructed as `{'key_name': 'value'}`. Message construction is
// similar, but prefixed with a type name and composed of field ids:
// `types.MyType{field_id: 'value'}`.
type Expr_CreateStruct struct {
	// The type name of the message to be created, empty when creating map
	// literals.
	MessageName string `protobuf:"bytes,1,opt,name=message_name,json=messageName,proto3" json:"message_name,omitempty"`
	// The entries in the creation expression.
	Entries              []*Expr_CreateStruct_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *Expr_CreateStruct) Reset()         { *m = Expr_CreateStruct{} }
func (m *Expr_CreateStruct) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateStruct) ProtoMessage()    {}
func (*Expr_CreateStruct) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 4}
}

func (m *Expr_CreateStruct) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_CreateStruct.Unmarshal(m, b)
}
func (m *Expr_CreateStruct) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_CreateStruct.Marshal(b, m, deterministic)
}
func (m *Expr_CreateStruct) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateStruct.Merge(m, src)
}
func (m *Expr_CreateStruct) XXX_Size() int {
	return xxx_messageInfo_Expr_CreateStruct.Size(m)
}
func (m *Expr_CreateStruct) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateStruct.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateStruct proto.InternalMessageInfo

func (m *Expr_CreateStruct) GetMessageName() string {
	if m != nil {
		return m.MessageName
	}
	return ""
}

func (m *Expr_CreateStruct) GetEntries() []*Expr_CreateStruct_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// Represents an entry.
type Expr_CreateStruct_Entry struct {
	// Required. An id assigned to this node by the parser which is unique
	// in a given expression tree. This is used to associate type
	// information and other attributes to the node.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The `Entry` key kinds.
	//
	// Types that are valid to be assigned to KeyKind:
	//	*Expr_CreateStruct_Entry_FieldKey
	//	*Expr_CreateStruct_Entry_MapKey
	KeyKind isExpr_CreateStruct_Entry_KeyKind `protobuf_oneof:"key_kind"`
	// Required. The value assigned to the key.
	Value                *Expr    `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_CreateStruct_Entry) Reset()         { *m = Expr_CreateStruct_Entry{} }
func (m *Expr_CreateStruct_Entry) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateStruct_Entry) ProtoMessage()    {}
func (*Expr_CreateStruct_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 4, 0}
}

func (m *Expr_CreateStruct_Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_CreateStruct_Entry.Unmarshal(m, b)
}
func (m *Expr_CreateStruct_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_CreateStruct_Entry.Marshal(b, m, deterministic)
}
func (m *Expr_CreateStruct_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateStruct_Entry.Merge(m, src)
}
func (m *Expr_CreateStruct_Entry) XXX_Size() int {
	return xxx_messageInfo_Expr_CreateStruct_Entry.Size(m)
}
func (m *Expr_CreateStruct_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateStruct_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateStruct_Entry proto.InternalMessageInfo

func (m *Expr_CreateStruct_Entry) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type isExpr_CreateStruct_Entry_KeyKind interface {
	isExpr_CreateStruct_Entry_KeyKind()
}

type Expr_CreateStruct_Entry_FieldKey struct {
	FieldKey string `protobuf:"bytes,2,opt,name=field_key,json=fieldKey,proto3,oneof"`
}

type Expr_CreateStruct_Entry_MapKey struct {
	MapKey *Expr `protobuf:"bytes,3,opt,name=map_key,json=mapKey,proto3,oneof"`
}

func (*Expr_CreateStruct_Entry_FieldKey) isExpr_CreateStruct_Entry_KeyKind() {}

func (*Expr_CreateStruct_Entry_MapKey) isExpr_CreateStruct_Entry_KeyKind() {}

func (m *Expr_CreateStruct_Entry) GetKeyKind() isExpr_CreateStruct_Entry_KeyKind {
	if m != nil {
		return m.KeyKind
	}
	return nil
}

func (m *Expr_CreateStruct_Entry) GetFieldKey() string {
	if x, ok := m.GetKeyKind().(*Expr_CreateStruct_Entry_FieldKey); ok {
		return x.FieldKey
	}
	return ""
}

func (m *Expr_CreateStruct_Entry) GetMapKey() *Expr {
	if x, ok := m.GetKeyKind().(*Expr_CreateStruct_Entry_MapKey); ok {
		return x.MapKey
	}
	return nil
}

func (m *Expr_CreateStruct_Entry) GetValue() *Expr {
	if m != nil {
		return m.Value
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Expr_CreateStruct_Entry) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Expr_CreateStruct_Entry_FieldKey)(nil),
		(*Expr_CreateStruct_Entry_MapKey)(nil),
	}
}

// A comprehension expression applied to a list or map.
//
// Comprehensions are not part of the core syntax, but enabled with macros.
// A macro matches a specific call signature within a parsed AST and replaces
// the call with an alternate AST block. Macro expansion happens at parse
// time.
//
// The following macros are supported within CEL:
//
// Aggregate type macros may be applied to all elements in a list or all keys
// in a map:
//
// *  `all`, `exists`, `exists_one` -  test a predicate expression against
//    the inputs and return `true` if the predicate is satisfied for all,
//    any, or only one value `list.all(x, x < 10)`.
// *  `filter` - test a predicate expression against the inputs and return
//    the subset of elements which satisfy the predicate:
//    `payments.filter(p, p > 1000)`.
// *  `map` - apply an expression to all elements in the input and return the
//    output aggregate type: `[1, 2, 3].map(i, i * i)`.
//
// The `has(m.x)` macro tests whether the property `x` is present in struct
// `m`. The semantics of this macro depend on the type of `m`. For proto2
// messages `has(m.x)` is defined as 'defined, but not set`. For proto3, the
// macro tests whether the property is set to its default. For map and struct
// types, the macro tests whether the property `x` is defined on `m`.
type Expr_Comprehension struct {
	// The name of the iteration variable.
	IterVar string `protobuf:"bytes,1,opt,name=iter_var,json=iterVar,proto3" json:"iter_var,omitempty"`
	// The range over which var iterates.
	IterRange *Expr `protobuf:"bytes,2,opt,name=iter_range,json=iterRange,proto3" json:"iter_range,omitempty"`
	// The name of the variable used for accumulation of the result.
	AccuVar string `protobuf:"bytes,3,opt,name=accu_var,json=accuVar,proto3" json:"accu_var,omitempty"`
	// The initial value of the accumulator.
	AccuInit *Expr `protobuf:"bytes,4,opt,name=accu_init,json=accuInit,proto3" json:"accu_init,omitempty"`
	// An expression which can contain iter_var and accu_var.
	//
	// Returns false when the result has been computed and may be used as
	// a hint to short-circuit the remainder of the comprehension.
	LoopCondition *Expr `protobuf:"bytes,5,opt,name=loop_condition,json=loopCondition,proto3" json:"loop_condition,omitempty"`
	// An expression which can contain iter_var and accu_var.
	//
	// Computes the next value of accu_var.
	LoopStep *Expr `protobuf:"bytes,6,opt,name=loop_step,json=loopStep,proto3" json:"loop_step,omitempty"`
	// An expression which can contain accu_var.
	//
	// Computes the result.
	Result               *Expr    `protobuf:"bytes,7,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_Comprehension) Reset()         { *m = Expr_Comprehension{} }
func (m *Expr_Comprehension) String() string { return proto.CompactTextString(m) }
func (*Expr_Comprehension) ProtoMessage()    {}
func (*Expr_Comprehension) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{1, 5}
}

func (m *Expr_Comprehension) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_Comprehension.Unmarshal(m, b)
}
func (m *Expr_Comprehension) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_Comprehension.Marshal(b, m, deterministic)
}
func (m *Expr_Comprehension) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Comprehension.Merge(m, src)
}
func (m *Expr_Comprehension) XXX_Size() int {
	return xxx_messageInfo_Expr_Comprehension.Size(m)
}
func (m *Expr_Comprehension) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Comprehension.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Comprehension proto.InternalMessageInfo

func (m *Expr_Comprehension) GetIterVar() string {
	if m != nil {
		return m.IterVar
	}
	return ""
}

func (m *Expr_Comprehension) GetIterRange() *Expr {
	if m != nil {
		return m.IterRange
	}
	return nil
}

func (m *Expr_Comprehension) GetAccuVar() string {
	if m != nil {
		return m.AccuVar
	}
	return ""
}

func (m *Expr_Comprehension) GetAccuInit() *Expr {
	if m != nil {
		return m.AccuInit
	}
	return nil
}

func (m *Expr_Comprehension) GetLoopCondition() *Expr {
	if m != nil {
		return m.LoopCondition
	}
	return nil
}

func (m *Expr_Comprehension) GetLoopStep() *Expr {
	if m != nil {
		return m.LoopStep
	}
	return nil
}

func (m *Expr_Comprehension) GetResult() *Expr {
	if m != nil {
		return m.Result
	}
	return nil
}

// Represents a primitive literal.
//
// Named 'Constant' here for backwards compatibility.
//
// This is similar as the primitives supported in the well-known type
// `google.protobuf.Value`, but richer so it can represent CEL's full range of
// primitives.
//
// Lists and structs are not included as constants as these aggregate types may
// contain [Expr][google.api.expr.v1alpha1.Expr] elements which require evaluation and are thus not constant.
//
// Examples of literals include: `"hello"`, `b'bytes'`, `1u`, `4.2`, `-2`,
// `true`, `null`.
type Constant struct {
	// Required. The valid constant kinds.
	//
	// Types that are valid to be assigned to ConstantKind:
	//	*Constant_NullValue
	//	*Constant_BoolValue
	//	*Constant_Int64Value
	//	*Constant_Uint64Value
	//	*Constant_DoubleValue
	//	*Constant_StringValue
	//	*Constant_BytesValue
	//	*Constant_DurationValue
	//	*Constant_TimestampValue
	ConstantKind         isConstant_ConstantKind `protobuf_oneof:"constant_kind"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Constant) Reset()         { *m = Constant{} }
func (m *Constant) String() string { return proto.CompactTextString(m) }
func (*Constant) ProtoMessage()    {}
func (*Constant) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{2}
}

func (m *Constant) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Constant.Unmarshal(m, b)
}
func (m *Constant) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Constant.Marshal(b, m, deterministic)
}
func (m *Constant) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Constant.Merge(m, src)
}
func (m *Constant) XXX_Size() int {
	return xxx_messageInfo_Constant.Size(m)
}
func (m *Constant) XXX_DiscardUnknown() {
	xxx_messageInfo_Constant.DiscardUnknown(m)
}

var xxx_messageInfo_Constant proto.InternalMessageInfo

type isConstant_ConstantKind interface {
	isConstant_ConstantKind()
}

type Constant_NullValue struct {
	NullValue _struct.NullValue `protobuf:"varint,1,opt,name=null_value,json=nullValue,proto3,enum=google.protobuf.NullValue,oneof"`
}

type Constant_BoolValue struct {
	BoolValue bool `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type Constant_Int64Value struct {
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type Constant_Uint64Value struct {
	Uint64Value uint64 `protobuf:"varint,4,opt,name=uint64_value,json=uint64Value,proto3,oneof"`
}

type Constant_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,5,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type Constant_StringValue struct {
	StringValue string `protobuf:"bytes,6,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Constant_BytesValue struct {
	BytesValue []byte `protobuf:"bytes,7,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}

type Constant_DurationValue struct {
	DurationValue *duration.Duration `protobuf:"bytes,8,opt,name=duration_value,json=durationValue,proto3,oneof"`
}

type Constant_TimestampValue struct {
	TimestampValue *timestamp.Timestamp `protobuf:"bytes,9,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

func (*Constant_NullValue) isConstant_ConstantKind() {}

func (*Constant_BoolValue) isConstant_ConstantKind() {}

func (*Constant_Int64Value) isConstant_ConstantKind() {}

func (*Constant_Uint64Value) isConstant_ConstantKind() {}

func (*Constant_DoubleValue) isConstant_ConstantKind() {}

func (*Constant_StringValue) isConstant_ConstantKind() {}

func (*Constant_BytesValue) isConstant_ConstantKind() {}

func (*Constant_DurationValue) isConstant_ConstantKind() {}

func (*Constant_TimestampValue) isConstant_ConstantKind() {}

func (m *Constant) GetConstantKind() isConstant_ConstantKind {
	if m != nil {
		return m.ConstantKind
	}
	return nil
}

func (m *Constant) GetNullValue() _struct.NullValue {
	if x, ok := m.GetConstantKind().(*Constant_NullValue); ok {
		return x.NullValue
	}
	return _struct.NullValue_NULL_VALUE
}

func (m *Constant) GetBoolValue() bool {
	if x, ok := m.GetConstantKind().(*Constant_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *Constant) GetInt64Value() int64 {
	if x, ok := m.GetConstantKind().(*Constant_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *Constant) GetUint64Value() uint64 {
	if x, ok := m.GetConstantKind().(*Constant_Uint64Value); ok {
		return x.Uint64Value
	}
	return 0
}

func (m *Constant) GetDoubleValue() float64 {
	if x, ok := m.GetConstantKind().(*Constant_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Constant) GetStringValue() string {
	if x, ok := m.GetConstantKind().(*Constant_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Constant) GetBytesValue() []byte {
	if x, ok := m.GetConstantKind().(*Constant_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

// Deprecated: Do not use.
func (m *Constant) GetDurationValue() *duration.Duration {
	if x, ok := m.GetConstantKind().(*Constant_DurationValue); ok {
		return x.DurationValue
	}
	return nil
}

// Deprecated: Do not use.
func (m *Constant) GetTimestampValue() *timestamp.Timestamp {
	if x, ok := m.GetConstantKind().(*Constant_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Constant) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Constant_NullValue)(nil),
		(*Constant_BoolValue)(nil),
		(*Constant_Int64Value)(nil),
		(*Constant_Uint64Value)(nil),
		(*Constant_DoubleValue)(nil),
		(*Constant_StringValue)(nil),
		(*Constant_BytesValue)(nil),
		(*Constant_DurationValue)(nil),
		(*Constant_TimestampValue)(nil),
	}
}

// Source information collected at parse time.
type SourceInfo struct {
	// The syntax version of the source, e.g. `cel1`.
	SyntaxVersion string `protobuf:"bytes,1,opt,name=syntax_version,json=syntaxVersion,proto3" json:"syntax_version,omitempty"`
	// The location name. All position information attached to an expression is
	// relative to this location.
	//
	// The location could be a file, UI element, or similar. For example,
	// `acme/app/AnvilPolicy.cel`.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Monotonically increasing list of character offsets where newlines appear.
	//
	// The line number of a given position is the index `i` where for a given
	// `id` the `line_offsets[i] < id_positions[id] < line_offsets[i+1]`. The
	// column may be derivd from `id_positions[id] - line_offsets[i]`.
	LineOffsets []int32 `protobuf:"varint,3,rep,packed,name=line_offsets,json=lineOffsets,proto3" json:"line_offsets,omitempty"`
	// A map from the parse node id (e.g. `Expr.id`) to the character offset
	// within source.
	Positions map[int64]int32 `protobuf:"bytes,4,rep,name=positions,proto3" json:"positions,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// A map from the parse node id where a macro replacement was made to the
	// call `Expr` that resulted in a macro expansion.
	//
	// For example, `has(value.field)` is a function call that is replaced by a
	// `test_only` field selection in the AST. Likewise, the call
	// `list.exists(e, e > 10)` translates to a comprehension expression. The key
	// in the map corresponds to the expression id of the expanded macro, and the
	// value is the call `Expr` that was replaced.
	MacroCalls           map[int64]*Expr `protobuf:"bytes,5,rep,name=macro_calls,json=macroCalls,proto3" json:"macro_calls,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SourceInfo) Reset()         { *m = SourceInfo{} }
func (m *SourceInfo) String() string { return proto.CompactTextString(m) }
func (*SourceInfo) ProtoMessage()    {}
func (*SourceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{3}
}

func (m *SourceInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceInfo.Unmarshal(m, b)
}
func (m *SourceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceInfo.Marshal(b, m, deterministic)
}
func (m *SourceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceInfo.Merge(m, src)
}
func (m *SourceInfo) XXX_Size() int {
	return xxx_messageInfo_SourceInfo.Size(m)
}
func (m *SourceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SourceInfo proto.InternalMessageInfo

func (m *SourceInfo) GetSyntaxVersion() string {
	if m != nil {
		return m.SyntaxVersion
	}
	return ""
}

func (m *SourceInfo) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *SourceInfo) GetLineOffsets() []int32 {
	if m != nil {
		return m.LineOffsets
	}
	return nil
}

func (m *SourceInfo) GetPositions() map[int64]int32 {
	if m != nil {
		return m.Positions
	}
	return nil
}

func (m *SourceInfo) GetMacroCalls() map[int64]*Expr {
	if m != nil {
		return m.MacroCalls
	}
	return nil
}

// A specific position in source.
type SourcePosition struct {
	// The soucre location name (e.g. file name).
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The character offset.
	Offset int32 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// The 1-based index of the starting line in the source text
	// where the issue occurs, or 0 if unknown.
	Line int32 `protobuf:"varint,3,opt,name=line,proto3" json:"line,omitempty"`
	// The 0-based index of the starting position within the line of source text
	// where the issue occurs.  Only meaningful if line is nonzero.
	Column               int32    `protobuf:"varint,4,opt,name=column,proto3" json:"column,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SourcePosition) Reset()         { *m = SourcePosition{} }
func (m *SourcePosition) String() string { return proto.CompactTextString(m) }
func (*SourcePosition) ProtoMessage()    {}
func (*SourcePosition) Descriptor() ([]byte, []int) {
	return fileDescriptor_d4e2be48009c83cb, []int{4}
}

func (m *SourcePosition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourcePosition.Unmarshal(m, b)
}
func (m *SourcePosition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourcePosition.Marshal(b, m, deterministic)
}
func (m *SourcePosition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourcePosition.Merge(m, src)
}
func (m *SourcePosition) XXX_Size() int {
	return xxx_messageInfo_SourcePosition.Size(m)
}
func (m *SourcePosition) XXX_DiscardUnknown() {
	xxx_messageInfo_SourcePosition.DiscardUnknown(m)
}

var xxx_messageInfo_SourcePosition proto.InternalMessageInfo

func (m *SourcePosition) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *SourcePosition) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *SourcePosition) GetLine() int32 {
	if m != nil {
		return m.Line
	}
	return 0
}

func (m *SourcePosition) GetColumn() int32 {
	if m != nil {
		return m.Column
	}
	return 0
}

func init() {
	proto.RegisterType((*ParsedExpr)(nil), "google.api.expr.v1alpha1.ParsedExpr")
	proto.RegisterType((*Expr)(nil), "google.api.expr.v1alpha1.Expr")
	proto.RegisterType((*Expr_Ident)(nil), "google.api.expr.v1alpha1.Expr.Ident")
	proto.RegisterType((*Expr_Select)(nil), "google.api.expr.v1alpha1.Expr.Select")
	proto.RegisterType((*Expr_Call)(nil), "google.api.expr.v1alpha1.Expr.Call")
	proto.RegisterType((*Expr_CreateList)(nil), "google.api.expr.v1alpha1.Expr.CreateList")
	proto.RegisterType((*Expr_CreateStruct)(nil), "google.api.expr.v1alpha1.Expr.CreateStruct")
	proto.RegisterType((*Expr_CreateStruct_Entry)(nil), "google.api.expr.v1alpha1.Expr.CreateStruct.Entry")
	proto.RegisterType((*Expr_Comprehension)(nil), "google.api.expr.v1alpha1.Expr.Comprehension")
	proto.RegisterType((*Constant)(nil), "google.api.expr.v1alpha1.Constant")
	proto.RegisterType((*SourceInfo)(nil), "google.api.expr.v1alpha1.SourceInfo")
	proto.RegisterMapType((map[int64]*Expr)(nil), "google.api.expr.v1alpha1.SourceInfo.MacroCallsEntry")
	proto.RegisterMapType((map[int64]int32)(nil), "google.api.expr.v1alpha1.SourceInfo.PositionsEntry")
	proto.RegisterType((*SourcePosition)(nil), "google.api.expr.v1alpha1.SourcePosition")
}

func init() {
	proto.RegisterFile("google/api/expr/v1alpha1/syntax.proto", fileDescriptor_d4e2be48009c83cb)
}

var fileDescriptor_d4e2be48009c83cb = []byte{
	// 1179 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x96, 0x5d, 0x6f, 0xdb, 0x36,
	0x17, 0xc7, 0x23, 0xbf, 0xc5, 0x3e, 0x4a, 0xdc, 0xe7, 0x21, 0x86, 0xc1, 0x55, 0xbb, 0xbe, 0xa4,
	0x2b, 0xd0, 0x61, 0x83, 0x8d, 0xb6, 0x41, 0xd1, 0xb5, 0xdd, 0x8d, 0xb3, 0x0c, 0x0e, 0xba, 0xb5,
	0x99, 0xb2, 0xf5, 0x62, 0x40, 0x21, 0x30, 0x32, 0xed, 0x0a, 0xa5, 0x48, 0x41, 0xa4, 0x82, 0xfa,
	0x13, 0xec, 0x6e, 0x5f, 0x66, 0xbb, 0xd9, 0xe5, 0xbe, 0xc7, 0x3e, 0xc8, 0x6e, 0x06, 0x0c, 0xe7,
	0x90, 0x72, 0xde, 0x16, 0xd8, 0xbb, 0x13, 0x0f, 0xff, 0xff, 0x9f, 0x8e, 0x78, 0xc8, 0x43, 0xc1,
	0xfd, 0xb9, 0xd6, 0x73, 0x29, 0x46, 0xbc, 0xc8, 0x46, 0xe2, 0x43, 0x51, 0x8e, 0x4e, 0x1e, 0x72,
	0x59, 0xbc, 0xe3, 0x0f, 0x47, 0x66, 0xa1, 0x2c, 0xff, 0x30, 0x2c, 0x4a, 0x6d, 0x35, 0x1b, 0x38,
	0xd9, 0x90, 0x17, 0xd9, 0x10, 0x65, 0xc3, 0x5a, 0x16, 0xdd, 0xf2, 0x00, 0xd2, 0x1d, 0x57, 0xb3,
	0xd1, 0xb4, 0x2a, 0xb9, 0xcd, 0xb4, 0x72, 0xce, 0xe8, 0xe6, 0xc5, 0x79, 0x63, 0xcb, 0x2a, 0xb5,
	0x7e, 0xf6, 0xf6, 0xc5, 0x59, 0x9b, 0xe5, 0xc2, 0x58, 0x9e, 0x17, 0x4e, 0xb0, 0xf3, 0x73, 0x00,
	0x70, 0xc8, 0x4b, 0x23, 0xa6, 0xfb, 0x1f, 0x8a, 0x92, 0x3d, 0x82, 0x16, 0xbe, 0x7e, 0xd0, 0xb8,
	0x13, 0x3c, 0x08, 0x1f, 0xdd, 0x1a, 0x5e, 0x95, 0xd6, 0x10, 0xd5, 0x31, 0x69, 0xd9, 0x3e, 0x84,
	0x46, 0x57, 0x65, 0x2a, 0x92, 0x4c, 0xcd, 0xf4, 0xa0, 0x49, 0xd6, 0x4f, 0xaf, 0xb6, 0x1e, 0x91,
	0xf8, 0x40, 0xcd, 0x74, 0x0c, 0x66, 0xf9, 0xbc, 0xf3, 0xe7, 0x16, 0xb4, 0x28, 0x87, 0x3e, 0x34,
	0xb2, 0x29, 0x65, 0xd0, 0x8c, 0x1b, 0xd9, 0x94, 0xed, 0x01, 0xa4, 0x5a, 0x19, 0x9b, 0x50, 0x66,
	0x0e, 0xbf, 0x73, 0x35, 0x7e, 0x0f, 0xb5, 0x5c, 0xd9, 0xc9, 0x46, 0xdc, 0x23, 0xdf, 0xbe, 0x4b,
	0x12, 0xb2, 0xa9, 0x50, 0x1e, 0xd2, 0x5a, 0x95, 0x23, 0x7a, 0x86, 0x07, 0x68, 0x40, 0x0c, 0x39,
	0x09, 0x33, 0x81, 0xd0, 0x08, 0x29, 0x52, 0xcf, 0x69, 0x13, 0xe7, 0xfe, 0x0a, 0xce, 0x11, 0x39,
	0x26, 0x1b, 0x31, 0x38, 0x2f, 0x91, 0xc6, 0xd0, 0x4b, 0xb9, 0x94, 0x8e, 0xd3, 0x21, 0xce, 0xbd,
	0x15, 0x9c, 0x3d, 0x2e, 0xe5, 0x64, 0x23, 0xee, 0xa2, 0xcf, 0x67, 0xd3, 0x93, 0x59, 0xbd, 0x30,
	0x9b, 0xc4, 0xf8, 0x6c, 0x15, 0xa3, 0x14, 0xdc, 0x8a, 0x6f, 0x33, 0x83, 0xf9, 0x74, 0xd1, 0x4d,
	0xa4, 0x57, 0x10, 0xba, 0x7d, 0xe3, 0x58, 0x5d, 0x62, 0x7d, 0xbe, 0x16, 0xeb, 0x88, 0x7c, 0xf4,
	0x75, 0xf4, 0x44, 0xbc, 0xb7, 0xc0, 0x52, 0x9d, 0x17, 0xa5, 0x78, 0x27, 0x94, 0xc9, 0xb4, 0x72,
	0xd8, 0x1e, 0x61, 0xbf, 0x58, 0x85, 0x3d, 0x6b, 0x9c, 0x6c, 0xc4, 0xff, 0x3f, 0x47, 0x42, 0x49,
	0x74, 0x03, 0xda, 0x54, 0x1c, 0xc6, 0xa0, 0xa5, 0x78, 0x2e, 0x06, 0xc1, 0x9d, 0xe0, 0x41, 0x2f,
	0xa6, 0xe7, 0xa8, 0x82, 0x8e, 0x5b, 0x71, 0xf6, 0x14, 0x36, 0x75, 0x21, 0x4a, 0xae, 0xa6, 0x24,
	0x58, 0xbd, 0xa1, 0x6b, 0x39, 0xfb, 0x08, 0xda, 0xb3, 0x4c, 0x48, 0xb7, 0x0d, 0x7b, 0xb1, 0x1b,
	0xb0, 0x1b, 0xd0, 0xb3, 0xc2, 0xd8, 0x44, 0x2b, 0xb9, 0xa0, 0x8d, 0xd8, 0x8d, 0xbb, 0x18, 0x78,
	0xad, 0xe4, 0x22, 0xfa, 0x25, 0x80, 0x16, 0x56, 0x88, 0x3d, 0x81, 0x8e, 0xe5, 0xe5, 0x5c, 0xd8,
	0x35, 0x5f, 0xea, 0xd5, 0x2c, 0x82, 0xee, 0xac, 0x52, 0x29, 0x9e, 0x6d, 0xff, 0xda, 0xe5, 0x18,
	0xcf, 0x25, 0x2f, 0xe7, 0x66, 0xd0, 0xbc, 0xd3, 0x5c, 0xe7, 0x5c, 0xa2, 0x36, 0x9a, 0x00, 0x9c,
	0x56, 0x9b, 0x3d, 0x83, 0xae, 0x90, 0x22, 0x17, 0xca, 0x9a, 0x41, 0xb0, 0x16, 0x65, 0xa9, 0x8f,
	0x7e, 0x6b, 0xc0, 0xd6, 0xd9, 0x62, 0xb3, 0xbb, 0xb0, 0x95, 0x0b, 0x63, 0xf8, 0x5c, 0x24, 0x67,
	0x96, 0x3f, 0xf4, 0xb1, 0x57, 0x3c, 0x17, 0xec, 0x25, 0x6c, 0x0a, 0x65, 0xcb, 0x4c, 0x98, 0x41,
	0x83, 0x5e, 0xf7, 0xf0, 0x3f, 0xec, 0xa6, 0xe1, 0xbe, 0xb2, 0xe5, 0x22, 0xae, 0x09, 0xd1, 0xaf,
	0x01, 0xb4, 0x29, 0xe4, 0x9b, 0x43, 0xb0, 0x6c, 0x0e, 0x9f, 0x40, 0x8f, 0x6a, 0x93, 0xbc, 0x17,
	0x0b, 0xb7, 0x6a, 0xb8, 0xaf, 0x29, 0xf4, 0x52, 0x2c, 0xd8, 0x97, 0xb0, 0x99, 0xf3, 0x82, 0x26,
	0x9b, 0xeb, 0x14, 0x63, 0xb2, 0x11, 0x77, 0x72, 0x5e, 0xa0, 0x75, 0x17, 0xda, 0x27, 0x5c, 0x56,
	0xc2, 0x37, 0x8b, 0x55, 0xab, 0xe5, 0xc4, 0x63, 0x80, 0xee, 0x7b, 0xb1, 0x48, 0xde, 0x67, 0x6a,
	0x1a, 0xfd, 0xdd, 0x80, 0xed, 0x73, 0x9b, 0x99, 0x5d, 0x87, 0x6e, 0x66, 0x45, 0x99, 0x9c, 0xf0,
	0xd2, 0xaf, 0xd9, 0x26, 0x8e, 0xdf, 0xf0, 0x92, 0x7d, 0x05, 0x40, 0x53, 0x25, 0x57, 0x73, 0xb1,
	0x66, 0xff, 0xed, 0xa1, 0x23, 0x46, 0x03, 0x92, 0x79, 0x9a, 0x56, 0x44, 0x6e, 0x3a, 0x32, 0x8e,
	0x91, 0xfc, 0x1c, 0x7a, 0x34, 0x95, 0xa9, 0xcc, 0xae, 0xf9, 0x31, 0xc4, 0x3a, 0x50, 0x99, 0x65,
	0xfb, 0xd0, 0x97, 0x5a, 0x17, 0x49, 0xaa, 0xd5, 0x34, 0xa3, 0xad, 0xd9, 0x5e, 0x8b, 0xb0, 0x8d,
	0xae, 0xbd, 0xda, 0x84, 0x39, 0x10, 0xc6, 0x58, 0x51, 0xf8, 0x6e, 0xb7, 0x32, 0x07, 0x34, 0x1c,
	0x59, 0x51, 0xe0, 0x81, 0x2a, 0x85, 0xa9, 0xa4, 0xf5, 0x3d, 0x6e, 0xe5, 0x81, 0x72, 0xea, 0x71,
	0x08, 0x3d, 0x9c, 0xa5, 0x62, 0xec, 0xfc, 0xd1, 0x84, 0x6e, 0x7d, 0x35, 0xb0, 0xe7, 0x00, 0xaa,
	0x92, 0x32, 0x71, 0x05, 0xc6, 0x4a, 0xf4, 0x1f, 0x45, 0x35, 0xb5, 0xbe, 0x2b, 0x87, 0xaf, 0x2a,
	0x29, 0xdf, 0xa0, 0x02, 0xef, 0x00, 0x55, 0x0f, 0xd8, 0x6d, 0x80, 0x63, 0xad, 0x6b, 0x33, 0x56,
	0xaa, 0x8b, 0x02, 0x8c, 0x39, 0xc1, 0x5d, 0x08, 0x33, 0x65, 0x9f, 0xec, 0x7a, 0x05, 0x96, 0xa3,
	0x89, 0xfd, 0x91, 0x82, 0x4e, 0x72, 0x0f, 0xb6, 0xaa, 0xb3, 0x1a, 0x2c, 0x4b, 0x6b, 0xb2, 0x11,
	0x87, 0xd5, 0x79, 0xd1, 0x54, 0x57, 0xc7, 0x52, 0x78, 0x11, 0xae, 0x7c, 0x80, 0x22, 0x17, 0x5d,
	0x8a, 0x8c, 0x2d, 0x33, 0x35, 0xf7, 0xa2, 0x8e, 0x3f, 0x03, 0xa1, 0x8b, 0x2e, 0x33, 0x3a, 0x5e,
	0x58, 0x61, 0xbc, 0x06, 0x97, 0x71, 0x0b, 0x33, 0xa2, 0xa0, 0x93, 0x7c, 0x03, 0xfd, 0xfa, 0xcf,
	0xc2, 0xab, 0xdc, 0x25, 0x70, 0xfd, 0xd2, 0xb2, 0x7c, 0xed, 0x65, 0xe3, 0xc6, 0x00, 0xb3, 0xd9,
	0xae, 0x6d, 0x8e, 0x73, 0x00, 0xd7, 0x96, 0xff, 0x18, 0x1e, 0xe4, 0xda, 0xfe, 0xe5, 0xf5, 0xfd,
	0xa1, 0xd6, 0x79, 0x52, 0x7f, 0x69, 0x24, 0xd4, 0xf8, 0x1a, 0x6c, 0xa7, 0xbe, 0x62, 0xae, 0x86,
	0xbf, 0x37, 0x01, 0x4e, 0xff, 0x1e, 0xd8, 0x7d, 0xe8, 0xbb, 0x9f, 0xa8, 0xe4, 0x44, 0x94, 0x78,
	0xbe, 0xfc, 0x99, 0xda, 0x76, 0xd1, 0x37, 0x2e, 0x88, 0x7d, 0x55, 0xea, 0x94, 0x9f, 0xed, 0xab,
	0xf5, 0x18, 0x1b, 0x99, 0xcc, 0x94, 0x48, 0xf4, 0x6c, 0x66, 0x84, 0x75, 0xfd, 0xb5, 0x1d, 0x87,
	0x18, 0x7b, 0xed, 0x42, 0xec, 0x7b, 0xe8, 0x15, 0xda, 0xd0, 0x36, 0x36, 0x83, 0x16, 0xb5, 0xb2,
	0xc7, 0xeb, 0xfc, 0xdc, 0x0c, 0x0f, 0x6b, 0x97, 0x6b, 0x66, 0xa7, 0x14, 0xf6, 0x23, 0x84, 0x39,
	0x4f, 0x4b, 0x9d, 0xe0, 0x4d, 0x6e, 0x06, 0x6d, 0x82, 0xee, 0xae, 0x05, 0xfd, 0x0e, 0x7d, 0x78,
	0xcd, 0x78, 0x2a, 0xe4, 0xcb, 0x40, 0xf4, 0x02, 0xfa, 0xe7, 0xdf, 0xc9, 0xfe, 0x07, 0x4d, 0x6c,
	0x7d, 0xae, 0x5d, 0xe2, 0x23, 0x5e, 0x6c, 0xa7, 0xfb, 0xb6, 0xed, 0xbb, 0xd6, 0xb3, 0xc6, 0xd3,
	0x20, 0x7a, 0x0b, 0xd7, 0x2e, 0xc0, 0xff, 0xc5, 0xbe, 0x7b, 0xd6, 0xbe, 0x6e, 0x53, 0x44, 0xfc,
	0x4e, 0x01, 0x7d, 0xf7, 0x19, 0x75, 0x8a, 0xe7, 0xea, 0x12, 0x5c, 0xa8, 0xcb, 0xc7, 0xd0, 0x71,
	0x25, 0xf1, 0x79, 0xfa, 0x11, 0xde, 0xf7, 0x58, 0x1b, 0x3a, 0x53, 0xed, 0x98, 0x9e, 0x51, 0x9b,
	0x6a, 0x59, 0xe5, 0x8a, 0x4e, 0x51, 0x3b, 0xf6, 0xa3, 0xb1, 0x82, 0x9b, 0xa9, 0xce, 0xaf, 0xcc,
	0x70, 0x1c, 0x1e, 0xd1, 0x36, 0x39, 0xc4, 0xed, 0x78, 0x18, 0xfc, 0xf4, 0xc2, 0x0b, 0xe7, 0x5a,
	0x72, 0x35, 0x1f, 0xea, 0x72, 0x3e, 0x9a, 0x0b, 0x45, 0x9b, 0x75, 0xe4, 0xa6, 0x78, 0x91, 0x99,
	0xcb, 0x3f, 0xf2, 0xcf, 0x71, 0xf4, 0x57, 0x10, 0x1c, 0x77, 0x48, 0xfb, 0xf8, 0x9f, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x7d, 0x35, 0x8f, 0xd7, 0xf3, 0x0b, 0x00, 0x00,
}
