// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/asset/v1p1beta1/asset_service.proto

package asset

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Search resource request.
type SearchResourcesRequest struct {
	// Required. The relative name of an asset. The search is limited to the resources
	// within the `scope`. The allowed value must be:
	// * Organization number (such as "organizations/123")
	// * Folder number(such as "folders/1234")
	// * Project number (such as "projects/12345")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. A list of asset types that this request searches for. If empty, it will
	// search all the supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Optional. The page size for search result pagination. Returned results may be fewer
	// than requested. The value of this field is capped at 2000.  If set to the
	// zero value, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the preceding call
	// to this method.  `page_token` must be the value of `next_page_token` from
	// the previous response. The values of all other method parameters, must be
	// identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchResourcesRequest) Reset()         { *m = SearchResourcesRequest{} }
func (m *SearchResourcesRequest) String() string { return proto.CompactTextString(m) }
func (*SearchResourcesRequest) ProtoMessage()    {}
func (*SearchResourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3ebba5b73acb095, []int{0}
}

func (m *SearchResourcesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchResourcesRequest.Unmarshal(m, b)
}
func (m *SearchResourcesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchResourcesRequest.Marshal(b, m, deterministic)
}
func (m *SearchResourcesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchResourcesRequest.Merge(m, src)
}
func (m *SearchResourcesRequest) XXX_Size() int {
	return xxx_messageInfo_SearchResourcesRequest.Size(m)
}
func (m *SearchResourcesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchResourcesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchResourcesRequest proto.InternalMessageInfo

func (m *SearchResourcesRequest) GetScope() string {
	if m != nil {
		return m.Scope
	}
	return ""
}

func (m *SearchResourcesRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchResourcesRequest) GetAssetTypes() []string {
	if m != nil {
		return m.AssetTypes
	}
	return nil
}

func (m *SearchResourcesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchResourcesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Search resource response.
type SearchResourcesResponse struct {
	// A list of resource that match the search query.
	Results []*StandardResourceMetadata `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// If there are more results than those appearing in this response, then
	// `next_page_token` is included.  To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchResourcesResponse) Reset()         { *m = SearchResourcesResponse{} }
func (m *SearchResourcesResponse) String() string { return proto.CompactTextString(m) }
func (*SearchResourcesResponse) ProtoMessage()    {}
func (*SearchResourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3ebba5b73acb095, []int{1}
}

func (m *SearchResourcesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchResourcesResponse.Unmarshal(m, b)
}
func (m *SearchResourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchResourcesResponse.Marshal(b, m, deterministic)
}
func (m *SearchResourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchResourcesResponse.Merge(m, src)
}
func (m *SearchResourcesResponse) XXX_Size() int {
	return xxx_messageInfo_SearchResourcesResponse.Size(m)
}
func (m *SearchResourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchResourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchResourcesResponse proto.InternalMessageInfo

func (m *SearchResourcesResponse) GetResults() []*StandardResourceMetadata {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchResourcesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Search IAM policies request.
type SearchIamPoliciesRequest struct {
	// Required. The relative name of an asset. The search is limited to the resources
	// within the `scope`. The allowed value must be:
	// * Organization number (such as "organizations/123")
	// * Folder number(such as "folders/1234")
	// * Project number (such as "projects/12345")
	Scope string `protobuf:"bytes,4,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement.
	// Examples:
	// * "policy:myuser@mydomain.com"
	// * "policy:(myuser@mydomain.com viewer)"
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The page size for search result pagination. Returned results may be fewer
	// than requested. The maximum is 2000. If set to the zero value, the server
	// will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, retrieve the next batch of results from the preceding call to
	// this method. `page_token` must be the value of `next_page_token` from the
	// previous response. The values of all other method parameters must be
	// identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchIamPoliciesRequest) Reset()         { *m = SearchIamPoliciesRequest{} }
func (m *SearchIamPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*SearchIamPoliciesRequest) ProtoMessage()    {}
func (*SearchIamPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3ebba5b73acb095, []int{2}
}

func (m *SearchIamPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchIamPoliciesRequest.Unmarshal(m, b)
}
func (m *SearchIamPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchIamPoliciesRequest.Marshal(b, m, deterministic)
}
func (m *SearchIamPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchIamPoliciesRequest.Merge(m, src)
}
func (m *SearchIamPoliciesRequest) XXX_Size() int {
	return xxx_messageInfo_SearchIamPoliciesRequest.Size(m)
}
func (m *SearchIamPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchIamPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchIamPoliciesRequest proto.InternalMessageInfo

func (m *SearchIamPoliciesRequest) GetScope() string {
	if m != nil {
		return m.Scope
	}
	return ""
}

func (m *SearchIamPoliciesRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchIamPoliciesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchIamPoliciesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Search IAM policies response.
type SearchIamPoliciesResponse struct {
	// A list of IamPolicy that match the search query. Related information such
	// as the associated resource is returned along with the policy.
	Results []*IamPolicySearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Set if there are more results than those appearing in this response; to get
	// the next set of results, call this method again, using this value as the
	// `page_token`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchIamPoliciesResponse) Reset()         { *m = SearchIamPoliciesResponse{} }
func (m *SearchIamPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*SearchIamPoliciesResponse) ProtoMessage()    {}
func (*SearchIamPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3ebba5b73acb095, []int{3}
}

func (m *SearchIamPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchIamPoliciesResponse.Unmarshal(m, b)
}
func (m *SearchIamPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchIamPoliciesResponse.Marshal(b, m, deterministic)
}
func (m *SearchIamPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchIamPoliciesResponse.Merge(m, src)
}
func (m *SearchIamPoliciesResponse) XXX_Size() int {
	return xxx_messageInfo_SearchIamPoliciesResponse.Size(m)
}
func (m *SearchIamPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchIamPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchIamPoliciesResponse proto.InternalMessageInfo

func (m *SearchIamPoliciesResponse) GetResults() []*IamPolicySearchResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchIamPoliciesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Search all resources request.
type SearchAllResourcesRequest struct {
	// Required. The relative name of an asset. The search is limited to the resources
	// within the `scope`. The allowed value must be:
	// * Organization number (such as "organizations/123")
	// * Folder number(such as "folders/1234")
	// * Project number (such as "projects/12345")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. A list of asset types that this request searches for. If empty, it will
	// search all the supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Optional. The page size for search result pagination. Returned results may be fewer
	// than requested. The value of this field is capped at 2000.  If set to the
	// zero value, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the preceding call
	// to this method.  `page_token` must be the value of `next_page_token` from
	// the previous response. The values of all other method parameters, must be
	// identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAllResourcesRequest) Reset()         { *m = SearchAllResourcesRequest{} }
func (m *SearchAllResourcesRequest) String() string { return proto.CompactTextString(m) }
func (*SearchAllResourcesRequest) ProtoMessage()    {}
func (*SearchAllResourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3ebba5b73acb095, []int{4}
}

func (m *SearchAllResourcesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAllResourcesRequest.Unmarshal(m, b)
}
func (m *SearchAllResourcesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAllResourcesRequest.Marshal(b, m, deterministic)
}
func (m *SearchAllResourcesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAllResourcesRequest.Merge(m, src)
}
func (m *SearchAllResourcesRequest) XXX_Size() int {
	return xxx_messageInfo_SearchAllResourcesRequest.Size(m)
}
func (m *SearchAllResourcesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAllResourcesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAllResourcesRequest proto.InternalMessageInfo

func (m *SearchAllResourcesRequest) GetScope() string {
	if m != nil {
		return m.Scope
	}
	return ""
}

func (m *SearchAllResourcesRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchAllResourcesRequest) GetAssetTypes() []string {
	if m != nil {
		return m.AssetTypes
	}
	return nil
}

func (m *SearchAllResourcesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchAllResourcesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Search all resources response.
type SearchAllResourcesResponse struct {
	// A list of resource that match the search query.
	Results []*StandardResourceMetadata `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// If there are more results than those appearing in this response, then
	// `next_page_token` is included.  To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAllResourcesResponse) Reset()         { *m = SearchAllResourcesResponse{} }
func (m *SearchAllResourcesResponse) String() string { return proto.CompactTextString(m) }
func (*SearchAllResourcesResponse) ProtoMessage()    {}
func (*SearchAllResourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3ebba5b73acb095, []int{5}
}

func (m *SearchAllResourcesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAllResourcesResponse.Unmarshal(m, b)
}
func (m *SearchAllResourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAllResourcesResponse.Marshal(b, m, deterministic)
}
func (m *SearchAllResourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAllResourcesResponse.Merge(m, src)
}
func (m *SearchAllResourcesResponse) XXX_Size() int {
	return xxx_messageInfo_SearchAllResourcesResponse.Size(m)
}
func (m *SearchAllResourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAllResourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAllResourcesResponse proto.InternalMessageInfo

func (m *SearchAllResourcesResponse) GetResults() []*StandardResourceMetadata {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchAllResourcesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Search all IAM policies request.
type SearchAllIamPoliciesRequest struct {
	// Required. The relative name of an asset. The search is limited to the resources
	// within the `scope`. The allowed value must be:
	// * Organization number (such as "organizations/123")
	// * Folder number(such as "folders/1234")
	// * Project number (such as "projects/12345")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement.
	// Examples:
	// * "policy:myuser@mydomain.com"
	// * "policy:(myuser@mydomain.com viewer)"
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The page size for search result pagination. Returned results may be fewer
	// than requested. The maximum is 2000. If set to the zero value, the server
	// will pick an appropriate default.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, retrieve the next batch of results from the preceding call to
	// this method. `page_token` must be the value of `next_page_token` from the
	// previous response. The values of all other method parameters must be
	// identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAllIamPoliciesRequest) Reset()         { *m = SearchAllIamPoliciesRequest{} }
func (m *SearchAllIamPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*SearchAllIamPoliciesRequest) ProtoMessage()    {}
func (*SearchAllIamPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3ebba5b73acb095, []int{6}
}

func (m *SearchAllIamPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAllIamPoliciesRequest.Unmarshal(m, b)
}
func (m *SearchAllIamPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAllIamPoliciesRequest.Marshal(b, m, deterministic)
}
func (m *SearchAllIamPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAllIamPoliciesRequest.Merge(m, src)
}
func (m *SearchAllIamPoliciesRequest) XXX_Size() int {
	return xxx_messageInfo_SearchAllIamPoliciesRequest.Size(m)
}
func (m *SearchAllIamPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAllIamPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAllIamPoliciesRequest proto.InternalMessageInfo

func (m *SearchAllIamPoliciesRequest) GetScope() string {
	if m != nil {
		return m.Scope
	}
	return ""
}

func (m *SearchAllIamPoliciesRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchAllIamPoliciesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchAllIamPoliciesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Search all IAM policies response.
type SearchAllIamPoliciesResponse struct {
	// A list of IamPolicy that match the search query. Related information such
	// as the associated resource is returned along with the policy.
	Results []*IamPolicySearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Set if there are more results than those appearing in this response; to get
	// the next set of results, call this method again, using this value as the
	// `page_token`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAllIamPoliciesResponse) Reset()         { *m = SearchAllIamPoliciesResponse{} }
func (m *SearchAllIamPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*SearchAllIamPoliciesResponse) ProtoMessage()    {}
func (*SearchAllIamPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3ebba5b73acb095, []int{7}
}

func (m *SearchAllIamPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAllIamPoliciesResponse.Unmarshal(m, b)
}
func (m *SearchAllIamPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAllIamPoliciesResponse.Marshal(b, m, deterministic)
}
func (m *SearchAllIamPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAllIamPoliciesResponse.Merge(m, src)
}
func (m *SearchAllIamPoliciesResponse) XXX_Size() int {
	return xxx_messageInfo_SearchAllIamPoliciesResponse.Size(m)
}
func (m *SearchAllIamPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAllIamPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAllIamPoliciesResponse proto.InternalMessageInfo

func (m *SearchAllIamPoliciesResponse) GetResults() []*IamPolicySearchResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchAllIamPoliciesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*SearchResourcesRequest)(nil), "google.cloud.asset.v1p1beta1.SearchResourcesRequest")
	proto.RegisterType((*SearchResourcesResponse)(nil), "google.cloud.asset.v1p1beta1.SearchResourcesResponse")
	proto.RegisterType((*SearchIamPoliciesRequest)(nil), "google.cloud.asset.v1p1beta1.SearchIamPoliciesRequest")
	proto.RegisterType((*SearchIamPoliciesResponse)(nil), "google.cloud.asset.v1p1beta1.SearchIamPoliciesResponse")
	proto.RegisterType((*SearchAllResourcesRequest)(nil), "google.cloud.asset.v1p1beta1.SearchAllResourcesRequest")
	proto.RegisterType((*SearchAllResourcesResponse)(nil), "google.cloud.asset.v1p1beta1.SearchAllResourcesResponse")
	proto.RegisterType((*SearchAllIamPoliciesRequest)(nil), "google.cloud.asset.v1p1beta1.SearchAllIamPoliciesRequest")
	proto.RegisterType((*SearchAllIamPoliciesResponse)(nil), "google.cloud.asset.v1p1beta1.SearchAllIamPoliciesResponse")
}

func init() {
	proto.RegisterFile("google/cloud/asset/v1p1beta1/asset_service.proto", fileDescriptor_a3ebba5b73acb095)
}

var fileDescriptor_a3ebba5b73acb095 = []byte{
	// 738 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x56, 0x4f, 0x4f, 0x13, 0x4f,
	0x18, 0xce, 0xb4, 0xc0, 0xef, 0xc7, 0xa0, 0x21, 0x4c, 0x8c, 0x94, 0x05, 0x42, 0x53, 0xff, 0x04,
	0x09, 0xee, 0x5a, 0x40, 0x54, 0x8c, 0x87, 0xad, 0x07, 0xe3, 0x81, 0xa4, 0x69, 0x09, 0x07, 0x43,
	0xd2, 0x0c, 0xdb, 0x61, 0xbb, 0x71, 0xba, 0xb3, 0xec, 0xcc, 0x82, 0x60, 0xbc, 0xf8, 0x11, 0x24,
	0x92, 0x78, 0xf6, 0xa6, 0x67, 0x13, 0xa3, 0xf1, 0xe4, 0x8d, 0xa3, 0x7e, 0x01, 0x0f, 0x7e, 0x10,
	0xb3, 0x33, 0xbb, 0x65, 0x61, 0x97, 0x96, 0x7a, 0x21, 0x1e, 0xe7, 0x7d, 0xdf, 0xe7, 0x7d, 0x9e,
	0x79, 0xe6, 0x9d, 0xc9, 0xc0, 0x3b, 0x36, 0x63, 0x36, 0x25, 0x86, 0x45, 0x59, 0xd0, 0x34, 0x30,
	0xe7, 0x44, 0x18, 0x3b, 0x65, 0xaf, 0xbc, 0x49, 0x04, 0x2e, 0xab, 0x75, 0x83, 0x13, 0x7f, 0xc7,
	0xb1, 0x88, 0xee, 0xf9, 0x4c, 0x30, 0x34, 0xa5, 0x10, 0xba, 0x44, 0xe8, 0xb2, 0x42, 0xef, 0x20,
	0xb4, 0x28, 0x6b, 0x60, 0xcf, 0x31, 0xb0, 0xeb, 0x32, 0x81, 0x85, 0xc3, 0x5c, 0xae, 0xb0, 0xda,
	0x4c, 0x22, 0xbb, 0xe5, 0x10, 0xda, 0x6c, 0x6c, 0x92, 0x16, 0xde, 0x71, 0x98, 0x1f, 0x15, 0xdc,
	0xea, 0x2d, 0x27, 0xee, 0x35, 0x9e, 0xe8, 0x65, 0x51, 0x87, 0xb8, 0x42, 0x25, 0x4a, 0x5f, 0x00,
	0xbc, 0x5a, 0x27, 0xd8, 0xb7, 0x5a, 0x35, 0xc2, 0x59, 0xe0, 0x5b, 0x84, 0xd7, 0xc8, 0x76, 0x40,
	0xb8, 0x40, 0x13, 0x70, 0x90, 0x5b, 0xcc, 0x23, 0x05, 0x50, 0x04, 0xb3, 0xc3, 0x95, 0xfc, 0x2f,
	0x33, 0x57, 0x53, 0x91, 0x30, 0xb5, 0x1d, 0x10, 0x7f, 0xaf, 0x90, 0x8b, 0x53, 0xa0, 0xa6, 0x22,
	0xe8, 0x3a, 0x1c, 0x51, 0x46, 0x88, 0x3d, 0x8f, 0xf0, 0x42, 0xbe, 0x98, 0x8f, 0x0b, 0xa0, 0x8c,
	0xaf, 0x85, 0x61, 0x54, 0x84, 0xc3, 0x1e, 0xb6, 0x49, 0x83, 0x3b, 0xfb, 0xa4, 0x30, 0x50, 0x04,
	0xb3, 0x83, 0xaa, 0xe6, 0xff, 0x30, 0x5a, 0x77, 0xf6, 0x09, 0x2a, 0x41, 0x28, 0x2b, 0x04, 0x7b,
	0x4e, 0xdc, 0xc2, 0xe0, 0x31, 0x8f, 0x04, 0xae, 0x85, 0xd1, 0xd2, 0x01, 0x80, 0xe3, 0x29, 0xf1,
	0xdc, 0x63, 0x2e, 0x27, 0xa8, 0x0a, 0xff, 0xf3, 0x09, 0x0f, 0xa8, 0xe0, 0x05, 0x50, 0xcc, 0xcf,
	0x8e, 0x2c, 0x2c, 0xeb, 0xdd, 0xce, 0x42, 0xaf, 0x0b, 0xec, 0x36, 0xb1, 0xdf, 0x8c, 0x3b, 0xad,
	0x12, 0x81, 0x9b, 0x58, 0xe0, 0x5a, 0xdc, 0x06, 0xdd, 0x84, 0xa3, 0x2e, 0x79, 0x21, 0x1a, 0x09,
	0x59, 0x72, 0xfb, 0xb5, 0xcb, 0x61, 0xb8, 0xda, 0x51, 0x75, 0x08, 0x60, 0x41, 0xa9, 0x7a, 0x8a,
	0xdb, 0x55, 0x46, 0x1d, 0xcb, 0xc9, 0x30, 0x75, 0xe0, 0x6c, 0x53, 0x41, 0xca, 0xd4, 0x13, 0x76,
	0xe5, 0x7a, 0xdb, 0x95, 0xcf, 0xb4, 0xeb, 0x0d, 0x80, 0x13, 0x19, 0xc2, 0x22, 0xc3, 0x56, 0x4f,
	0x1b, 0xb6, 0xd8, 0xdd, 0xb0, 0xb8, 0xc7, 0x5e, 0xe7, 0x04, 0x02, 0x2a, 0xfa, 0x77, 0xeb, 0x5b,
	0x47, 0x94, 0x49, 0xe9, 0x3f, 0x38, 0x83, 0x87, 0x00, 0x6a, 0x59, 0xfa, 0x2f, 0x7c, 0x0c, 0xdf,
	0x01, 0x38, 0xd9, 0x11, 0xd6, 0x6d, 0x12, 0xfb, 0xb2, 0xf6, 0x84, 0x69, 0xf9, 0xde, 0xa6, 0x0d,
	0x64, 0x9a, 0xf6, 0x16, 0xc0, 0xa9, 0x6c, 0x6d, 0x17, 0x3a, 0x8c, 0x0b, 0x9f, 0x86, 0xe0, 0x25,
	0x33, 0x6c, 0x5d, 0x57, 0xaf, 0x38, 0x7a, 0x0f, 0xe0, 0xe8, 0xa9, 0x17, 0x06, 0x2d, 0xf5, 0x38,
	0xc1, 0xcc, 0xd7, 0x54, 0xbb, 0xdb, 0x27, 0x4a, 0x19, 0x51, 0xba, 0xf6, 0xfa, 0xe7, 0xef, 0x83,
	0xdc, 0x34, 0x9a, 0x4c, 0xbc, 0xec, 0x7e, 0x5c, 0xb5, 0xc2, 0x25, 0x0a, 0x7d, 0x04, 0x70, 0x2c,
	0x75, 0xb1, 0xd1, 0xf2, 0x79, 0x18, 0xd3, 0x83, 0xa1, 0xdd, 0xeb, 0x1b, 0x17, 0x69, 0xbd, 0x21,
	0xb5, 0xce, 0xa0, 0xe9, 0x84, 0x56, 0xe7, 0xb8, 0x2e, 0x56, 0xfb, 0x15, 0x40, 0x94, 0xbe, 0x31,
	0xe8, 0x5c, 0xb4, 0x19, 0x6f, 0x84, 0x76, 0xbf, 0x7f, 0x60, 0x24, 0x78, 0x41, 0x0a, 0x9e, 0x47,
	0x73, 0x09, 0xc1, 0x2f, 0xe5, 0x15, 0x78, 0x34, 0x67, 0xcc, 0xbd, 0x4a, 0x19, 0x6d, 0x52, 0x8a,
	0xbe, 0x03, 0x78, 0x25, 0x6b, 0x74, 0xd1, 0x83, 0x73, 0xca, 0xc8, 0x70, 0x7c, 0xe5, 0x6f, 0xa0,
	0xd1, 0x1e, 0x96, 0xe4, 0x1e, 0x74, 0x34, 0x7f, 0xc6, 0x1e, 0xd2, 0x07, 0x60, 0x52, 0xaa, 0xad,
	0x1e, 0x99, 0x13, 0x92, 0x4c, 0x71, 0x29, 0x7a, 0xec, 0x39, 0x5c, 0xb7, 0x58, 0xfb, 0x87, 0xa9,
	0xb7, 0x84, 0xf0, 0xf8, 0x8a, 0x61, 0xec, 0xee, 0xee, 0x9e, 0x4a, 0x1a, 0x38, 0x10, 0x2d, 0xf5,
	0xe5, 0xb8, 0xed, 0x51, 0x2c, 0xb6, 0x98, 0xdf, 0xae, 0x7c, 0x06, 0xb0, 0x68, 0xb1, 0x76, 0xd7,
	0x6d, 0x54, 0xc6, 0x92, 0x37, 0xab, 0x1a, 0xfe, 0x3e, 0xaa, 0xe0, 0x99, 0x19, 0x41, 0x6c, 0x46,
	0xb1, 0x6b, 0xeb, 0xcc, 0xb7, 0x0d, 0x9b, 0xb8, 0xf2, 0x6f, 0x62, 0x1c, 0x13, 0x67, 0x7f, 0x71,
	0x1e, 0xca, 0xf5, 0x87, 0xdc, 0xd4, 0x13, 0xd5, 0xe3, 0xb1, 0xa4, 0x95, 0x2c, 0xfa, 0x7a, 0xb9,
	0x5a, 0xae, 0x84, 0x45, 0x47, 0x71, 0x7a, 0x43, 0xa6, 0x37, 0x64, 0x7a, 0x63, 0x3d, 0xee, 0xb1,
	0x39, 0x24, 0xb9, 0x16, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0x89, 0xa0, 0x26, 0xf3, 0xdc, 0x09,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Searches resources which are accessible with .get permission.
	SearchResources(ctx context.Context, in *SearchResourcesRequest, opts ...grpc.CallOption) (*SearchResourcesResponse, error)
	// Searches IAM policies which are accessible with .getIamPolicy permission.
	SearchIamPolicies(ctx context.Context, in *SearchIamPoliciesRequest, opts ...grpc.CallOption) (*SearchIamPoliciesResponse, error)
	// Searches all the resources under a given accessible CRM scope
	// (project/folder/organization). This RPC gives callers
	// especially admins the ability to search all the resources under a scope,
	// even if they don't have .get permission of all the resources. Callers
	// should have cloud.assets.SearchAllResources permission on the requested
	// scope, otherwise it will be rejected.
	SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error)
	// Searches all the IAM policies under a given accessible CRM scope
	// (project/folder/organization). This RPC gives callers
	// especially admins the ability to search all the IAM policies under a scope,
	// even if they don't have .getIamPolicy permission of all the IAM policies.
	// Callers should have cloud.assets.SearchAllIamPolicies permission on the
	// requested scope, otherwise it will be rejected.
	SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error)
}

type assetServiceClient struct {
	cc *grpc.ClientConn
}

func NewAssetServiceClient(cc *grpc.ClientConn) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) SearchResources(ctx context.Context, in *SearchResourcesRequest, opts ...grpc.CallOption) (*SearchResourcesResponse, error) {
	out := new(SearchResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p1beta1.AssetService/SearchResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchIamPolicies(ctx context.Context, in *SearchIamPoliciesRequest, opts ...grpc.CallOption) (*SearchIamPoliciesResponse, error) {
	out := new(SearchIamPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p1beta1.AssetService/SearchIamPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error) {
	out := new(SearchAllResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p1beta1.AssetService/SearchAllResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error) {
	out := new(SearchAllIamPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p1beta1.AssetService/SearchAllIamPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Searches resources which are accessible with .get permission.
	SearchResources(context.Context, *SearchResourcesRequest) (*SearchResourcesResponse, error)
	// Searches IAM policies which are accessible with .getIamPolicy permission.
	SearchIamPolicies(context.Context, *SearchIamPoliciesRequest) (*SearchIamPoliciesResponse, error)
	// Searches all the resources under a given accessible CRM scope
	// (project/folder/organization). This RPC gives callers
	// especially admins the ability to search all the resources under a scope,
	// even if they don't have .get permission of all the resources. Callers
	// should have cloud.assets.SearchAllResources permission on the requested
	// scope, otherwise it will be rejected.
	SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error)
	// Searches all the IAM policies under a given accessible CRM scope
	// (project/folder/organization). This RPC gives callers
	// especially admins the ability to search all the IAM policies under a scope,
	// even if they don't have .getIamPolicy permission of all the IAM policies.
	// Callers should have cloud.assets.SearchAllIamPolicies permission on the
	// requested scope, otherwise it will be rejected.
	SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) SearchResources(ctx context.Context, req *SearchResourcesRequest) (*SearchResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchResources not implemented")
}
func (*UnimplementedAssetServiceServer) SearchIamPolicies(ctx context.Context, req *SearchIamPoliciesRequest) (*SearchIamPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchIamPolicies not implemented")
}
func (*UnimplementedAssetServiceServer) SearchAllResources(ctx context.Context, req *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAllResources not implemented")
}
func (*UnimplementedAssetServiceServer) SearchAllIamPolicies(ctx context.Context, req *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAllIamPolicies not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_SearchResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p1beta1.AssetService/SearchResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchResources(ctx, req.(*SearchResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p1beta1.AssetService/SearchIamPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchIamPolicies(ctx, req.(*SearchIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p1beta1.AssetService/SearchAllResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllResources(ctx, req.(*SearchAllResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p1beta1.AssetService/SearchAllIamPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, req.(*SearchAllIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1p1beta1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchResources",
			Handler:    _AssetService_SearchResources_Handler,
		},
		{
			MethodName: "SearchIamPolicies",
			Handler:    _AssetService_SearchIamPolicies_Handler,
		},
		{
			MethodName: "SearchAllResources",
			Handler:    _AssetService_SearchAllResources_Handler,
		},
		{
			MethodName: "SearchAllIamPolicies",
			Handler:    _AssetService_SearchAllIamPolicies_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1p1beta1/asset_service.proto",
}
