// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/longrunning/operations.proto

package longrunning

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	descriptor "github.com/golang/protobuf/protoc-gen-go/descriptor"
	any "github.com/golang/protobuf/ptypes/any"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// This resource represents a long-running operation that is the result of a
// network API call.
type Operation struct {
	// The server-assigned name, which is only unique within the same service that
	// originally returns it. If you use the default HTTP mapping, the
	// `name` should be a resource name ending with `operations/{unique_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Service-specific metadata associated with the operation.  It typically
	// contains progress information and common metadata such as create time.
	// Some services might not provide such metadata.  Any method that returns a
	// long-running operation should document the metadata type, if any.
	Metadata *any.Any `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `protobuf:"varint,3,opt,name=done,proto3" json:"done,omitempty"`
	// The operation result, which can be either an `error` or a valid `response`.
	// If `done` == `false`, neither `error` nor `response` is set.
	// If `done` == `true`, exactly one of `error` or `response` is set.
	//
	// Types that are valid to be assigned to Result:
	//	*Operation_Error
	//	*Operation_Response
	Result               isOperation_Result `protobuf_oneof:"result"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff5d3ff9032d7eb, []int{0}
}

func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Operation) GetMetadata() *any.Any {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Operation) GetDone() bool {
	if m != nil {
		return m.Done
	}
	return false
}

type isOperation_Result interface {
	isOperation_Result()
}

type Operation_Error struct {
	Error *status.Status `protobuf:"bytes,4,opt,name=error,proto3,oneof"`
}

type Operation_Response struct {
	Response *any.Any `protobuf:"bytes,5,opt,name=response,proto3,oneof"`
}

func (*Operation_Error) isOperation_Result() {}

func (*Operation_Response) isOperation_Result() {}

func (m *Operation) GetResult() isOperation_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *Operation) GetError() *status.Status {
	if x, ok := m.GetResult().(*Operation_Error); ok {
		return x.Error
	}
	return nil
}

func (m *Operation) GetResponse() *any.Any {
	if x, ok := m.GetResult().(*Operation_Response); ok {
		return x.Response
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Operation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Operation_Error)(nil),
		(*Operation_Response)(nil),
	}
}

// The request message for [Operations.GetOperation][google.longrunning.Operations.GetOperation].
type GetOperationRequest struct {
	// The name of the operation resource.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOperationRequest) Reset()         { *m = GetOperationRequest{} }
func (m *GetOperationRequest) String() string { return proto.CompactTextString(m) }
func (*GetOperationRequest) ProtoMessage()    {}
func (*GetOperationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff5d3ff9032d7eb, []int{1}
}

func (m *GetOperationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOperationRequest.Unmarshal(m, b)
}
func (m *GetOperationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOperationRequest.Marshal(b, m, deterministic)
}
func (m *GetOperationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOperationRequest.Merge(m, src)
}
func (m *GetOperationRequest) XXX_Size() int {
	return xxx_messageInfo_GetOperationRequest.Size(m)
}
func (m *GetOperationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOperationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOperationRequest proto.InternalMessageInfo

func (m *GetOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Operations.ListOperations][google.longrunning.Operations.ListOperations].
type ListOperationsRequest struct {
	// The name of the operation's parent resource.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOperationsRequest) Reset()         { *m = ListOperationsRequest{} }
func (m *ListOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListOperationsRequest) ProtoMessage()    {}
func (*ListOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff5d3ff9032d7eb, []int{2}
}

func (m *ListOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOperationsRequest.Unmarshal(m, b)
}
func (m *ListOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOperationsRequest.Merge(m, src)
}
func (m *ListOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListOperationsRequest.Size(m)
}
func (m *ListOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListOperationsRequest proto.InternalMessageInfo

func (m *ListOperationsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListOperationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListOperationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Operations.ListOperations][google.longrunning.Operations.ListOperations].
type ListOperationsResponse struct {
	// A list of operations that matches the specified filter in the request.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// The standard List next-page token.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOperationsResponse) Reset()         { *m = ListOperationsResponse{} }
func (m *ListOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListOperationsResponse) ProtoMessage()    {}
func (*ListOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff5d3ff9032d7eb, []int{3}
}

func (m *ListOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOperationsResponse.Unmarshal(m, b)
}
func (m *ListOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOperationsResponse.Merge(m, src)
}
func (m *ListOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListOperationsResponse.Size(m)
}
func (m *ListOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListOperationsResponse proto.InternalMessageInfo

func (m *ListOperationsResponse) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [Operations.CancelOperation][google.longrunning.Operations.CancelOperation].
type CancelOperationRequest struct {
	// The name of the operation resource to be cancelled.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelOperationRequest) Reset()         { *m = CancelOperationRequest{} }
func (m *CancelOperationRequest) String() string { return proto.CompactTextString(m) }
func (*CancelOperationRequest) ProtoMessage()    {}
func (*CancelOperationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff5d3ff9032d7eb, []int{4}
}

func (m *CancelOperationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelOperationRequest.Unmarshal(m, b)
}
func (m *CancelOperationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelOperationRequest.Marshal(b, m, deterministic)
}
func (m *CancelOperationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelOperationRequest.Merge(m, src)
}
func (m *CancelOperationRequest) XXX_Size() int {
	return xxx_messageInfo_CancelOperationRequest.Size(m)
}
func (m *CancelOperationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelOperationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelOperationRequest proto.InternalMessageInfo

func (m *CancelOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Operations.DeleteOperation][google.longrunning.Operations.DeleteOperation].
type DeleteOperationRequest struct {
	// The name of the operation resource to be deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteOperationRequest) Reset()         { *m = DeleteOperationRequest{} }
func (m *DeleteOperationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteOperationRequest) ProtoMessage()    {}
func (*DeleteOperationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff5d3ff9032d7eb, []int{5}
}

func (m *DeleteOperationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteOperationRequest.Unmarshal(m, b)
}
func (m *DeleteOperationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteOperationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteOperationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteOperationRequest.Merge(m, src)
}
func (m *DeleteOperationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteOperationRequest.Size(m)
}
func (m *DeleteOperationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteOperationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteOperationRequest proto.InternalMessageInfo

func (m *DeleteOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Operations.WaitOperation][google.longrunning.Operations.WaitOperation].
type WaitOperationRequest struct {
	// The name of the operation resource to wait on.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum duration to wait before timing out. If left blank, the wait
	// will be at most the time permitted by the underlying HTTP/RPC protocol.
	// If RPC context deadline is also specified, the shorter one will be used.
	Timeout              *duration.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *WaitOperationRequest) Reset()         { *m = WaitOperationRequest{} }
func (m *WaitOperationRequest) String() string { return proto.CompactTextString(m) }
func (*WaitOperationRequest) ProtoMessage()    {}
func (*WaitOperationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff5d3ff9032d7eb, []int{6}
}

func (m *WaitOperationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WaitOperationRequest.Unmarshal(m, b)
}
func (m *WaitOperationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WaitOperationRequest.Marshal(b, m, deterministic)
}
func (m *WaitOperationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WaitOperationRequest.Merge(m, src)
}
func (m *WaitOperationRequest) XXX_Size() int {
	return xxx_messageInfo_WaitOperationRequest.Size(m)
}
func (m *WaitOperationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WaitOperationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WaitOperationRequest proto.InternalMessageInfo

func (m *WaitOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WaitOperationRequest) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

// A message representing the message types used by a long-running operation.
//
// Example:
//
//   rpc LongRunningRecognize(LongRunningRecognizeRequest)
//       returns (google.longrunning.Operation) {
//     option (google.longrunning.operation_info) = {
//       response_type: "LongRunningRecognizeResponse"
//       metadata_type: "LongRunningRecognizeMetadata"
//     };
//   }
type OperationInfo struct {
	// Required. The message name of the primary return type for this
	// long-running operation.
	// This type will be used to deserialize the LRO's response.
	//
	// If the response is in a different package from the rpc, a fully-qualified
	// message name must be used (e.g. `google.protobuf.Struct`).
	//
	// Note: Altering this value constitutes a breaking change.
	ResponseType string `protobuf:"bytes,1,opt,name=response_type,json=responseType,proto3" json:"response_type,omitempty"`
	// Required. The message name of the metadata type for this long-running
	// operation.
	//
	// If the response is in a different package from the rpc, a fully-qualified
	// message name must be used (e.g. `google.protobuf.Struct`).
	//
	// Note: Altering this value constitutes a breaking change.
	MetadataType         string   `protobuf:"bytes,2,opt,name=metadata_type,json=metadataType,proto3" json:"metadata_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationInfo) Reset()         { *m = OperationInfo{} }
func (m *OperationInfo) String() string { return proto.CompactTextString(m) }
func (*OperationInfo) ProtoMessage()    {}
func (*OperationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_bff5d3ff9032d7eb, []int{7}
}

func (m *OperationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationInfo.Unmarshal(m, b)
}
func (m *OperationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationInfo.Marshal(b, m, deterministic)
}
func (m *OperationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationInfo.Merge(m, src)
}
func (m *OperationInfo) XXX_Size() int {
	return xxx_messageInfo_OperationInfo.Size(m)
}
func (m *OperationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_OperationInfo proto.InternalMessageInfo

func (m *OperationInfo) GetResponseType() string {
	if m != nil {
		return m.ResponseType
	}
	return ""
}

func (m *OperationInfo) GetMetadataType() string {
	if m != nil {
		return m.MetadataType
	}
	return ""
}

var E_OperationInfo = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.MethodOptions)(nil),
	ExtensionType: (*OperationInfo)(nil),
	Field:         1049,
	Name:          "google.longrunning.operation_info",
	Tag:           "bytes,1049,opt,name=operation_info",
	Filename:      "google/longrunning/operations.proto",
}

func init() {
	proto.RegisterType((*Operation)(nil), "google.longrunning.Operation")
	proto.RegisterType((*GetOperationRequest)(nil), "google.longrunning.GetOperationRequest")
	proto.RegisterType((*ListOperationsRequest)(nil), "google.longrunning.ListOperationsRequest")
	proto.RegisterType((*ListOperationsResponse)(nil), "google.longrunning.ListOperationsResponse")
	proto.RegisterType((*CancelOperationRequest)(nil), "google.longrunning.CancelOperationRequest")
	proto.RegisterType((*DeleteOperationRequest)(nil), "google.longrunning.DeleteOperationRequest")
	proto.RegisterType((*WaitOperationRequest)(nil), "google.longrunning.WaitOperationRequest")
	proto.RegisterType((*OperationInfo)(nil), "google.longrunning.OperationInfo")
	proto.RegisterExtension(E_OperationInfo)
}

func init() {
	proto.RegisterFile("google/longrunning/operations.proto", fileDescriptor_bff5d3ff9032d7eb)
}

var fileDescriptor_bff5d3ff9032d7eb = []byte{
	// 774 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0x51, 0x4f, 0xd3, 0x50,
	0x14, 0xa6, 0x83, 0xe1, 0x76, 0x60, 0x2c, 0xb9, 0xc2, 0x18, 0x45, 0x70, 0x16, 0x23, 0x63, 0x92,
	0x56, 0xc6, 0x1b, 0x86, 0x87, 0x21, 0x06, 0x4c, 0x30, 0x90, 0x42, 0x62, 0x24, 0x26, 0x4b, 0xe9,
	0x2e, 0xb5, 0xb1, 0xbb, 0xb7, 0xb6, 0x77, 0xc6, 0x61, 0x90, 0xc4, 0x27, 0xdf, 0x35, 0x31, 0xfe,
	0x05, 0x7e, 0x0a, 0x2f, 0x3e, 0xf8, 0xc6, 0xb3, 0x3f, 0xc2, 0x47, 0xd3, 0xdb, 0x76, 0x2d, 0x5d,
	0x87, 0x7b, 0xeb, 0x3d, 0xe7, 0xbb, 0xe7, 0xfb, 0xce, 0x39, 0xdf, 0xdd, 0x60, 0xc9, 0xa0, 0xd4,
	0xb0, 0xb0, 0x62, 0x51, 0x62, 0x38, 0x1d, 0x42, 0x4c, 0x62, 0x28, 0xd4, 0xc6, 0x8e, 0xc6, 0x4c,
	0x4a, 0x5c, 0xd9, 0x76, 0x28, 0xa3, 0x08, 0xf9, 0x20, 0x39, 0x06, 0x12, 0xef, 0x05, 0x17, 0x35,
	0xdb, 0x54, 0x34, 0x42, 0x28, 0x8b, 0xdf, 0x10, 0x67, 0x63, 0x59, 0xdd, 0x32, 0x31, 0x61, 0x41,
	0x62, 0x2e, 0x48, 0xf0, 0xd3, 0x49, 0xe7, 0x54, 0xd1, 0x48, 0x37, 0x48, 0x2d, 0x26, 0x53, 0xad,
	0x8e, 0x2f, 0x23, 0xc8, 0xcf, 0x27, 0xf3, 0xb8, 0x6d, 0xb3, 0x6e, 0x82, 0xd0, 0xb1, 0x75, 0xc5,
	0x65, 0x1a, 0xeb, 0x84, 0x4a, 0x2a, 0x7d, 0x55, 0xb1, 0xab, 0x3b, 0xa6, 0xcd, 0xa8, 0xe3, 0x23,
	0xa4, 0x5f, 0x02, 0xe4, 0xf7, 0xc3, 0x96, 0x11, 0x82, 0x31, 0xa2, 0xb5, 0x71, 0x59, 0xa8, 0x08,
	0xd5, 0xbc, 0xca, 0xbf, 0xd1, 0x13, 0xc8, 0xb5, 0x31, 0xd3, 0x5a, 0x1a, 0xd3, 0xca, 0x99, 0x8a,
	0x50, 0x9d, 0xa8, 0x4f, 0xcb, 0xc1, 0x48, 0xc2, 0xb2, 0x72, 0x83, 0x74, 0xd5, 0x1e, 0xca, 0xab,
	0xd2, 0xa2, 0x04, 0x97, 0x47, 0x2b, 0x42, 0x35, 0xa7, 0xf2, 0x6f, 0x54, 0x83, 0x2c, 0x76, 0x1c,
	0xea, 0x94, 0xc7, 0x78, 0x09, 0x14, 0x96, 0x70, 0x6c, 0x5d, 0x3e, 0xe4, 0x92, 0x77, 0x47, 0x54,
	0x1f, 0x82, 0xea, 0x90, 0x73, 0xb0, 0x6b, 0x53, 0xe2, 0xe2, 0x72, 0x76, 0x30, 0xe3, 0xee, 0x88,
	0xda, 0xc3, 0x6d, 0xe5, 0x60, 0xdc, 0xc1, 0x6e, 0xc7, 0x62, 0xd2, 0x0a, 0xdc, 0xdd, 0xc1, 0xac,
	0xd7, 0x93, 0x8a, 0xdf, 0x77, 0xb0, 0xcb, 0xd2, 0x5a, 0x93, 0x2e, 0x60, 0x66, 0xcf, 0x74, 0x23,
	0xac, 0x9b, 0x04, 0x8f, 0xc5, 0xe6, 0x50, 0x82, 0xf1, 0x53, 0xd3, 0x62, 0xd8, 0x09, 0x4a, 0x04,
	0x27, 0x34, 0x0f, 0x79, 0x5b, 0x33, 0x70, 0xd3, 0x35, 0xcf, 0x30, 0x1f, 0x50, 0x56, 0xcd, 0x79,
	0x81, 0x43, 0xf3, 0x0c, 0xa3, 0x05, 0x00, 0x9e, 0x64, 0xf4, 0x1d, 0x26, 0x7c, 0x20, 0x79, 0x95,
	0xc3, 0x8f, 0xbc, 0x80, 0x74, 0x01, 0xa5, 0xa4, 0x00, 0xbf, 0x1f, 0xb4, 0x09, 0x10, 0x39, 0xb1,
	0x2c, 0x54, 0x46, 0xab, 0x13, 0xf5, 0x05, 0xb9, 0xdf, 0x8a, 0x72, 0xd4, 0x68, 0xec, 0x02, 0x7a,
	0x04, 0x45, 0x82, 0x3f, 0xb2, 0x66, 0x8c, 0x3c, 0xc3, 0xc9, 0x0b, 0x5e, 0xf8, 0xa0, 0x27, 0x60,
	0x15, 0x4a, 0xcf, 0x34, 0xa2, 0x63, 0x6b, 0xa8, 0x79, 0xad, 0x42, 0x69, 0x1b, 0x5b, 0x98, 0xe1,
	0xa1, 0xd0, 0x4d, 0x98, 0x7e, 0xa5, 0x99, 0x43, 0x6d, 0x02, 0xad, 0xc3, 0x1d, 0x66, 0xb6, 0x31,
	0xed, 0xb0, 0xc0, 0x63, 0x73, 0x7d, 0x1b, 0xdf, 0x0e, 0x1e, 0x84, 0x1a, 0x22, 0xa5, 0xd7, 0x50,
	0xe8, 0x15, 0x7f, 0x41, 0x4e, 0x29, 0x5a, 0x82, 0x42, 0x68, 0x88, 0x26, 0xeb, 0xda, 0x21, 0xc5,
	0x64, 0x18, 0x3c, 0xea, 0xda, 0xd8, 0x03, 0x85, 0x4e, 0xf5, 0x41, 0xfe, 0x60, 0x26, 0xc3, 0xa0,
	0x07, 0xaa, 0x5f, 0x66, 0x01, 0xa2, 0xad, 0xa0, 0xef, 0x02, 0x4c, 0xdd, 0x5c, 0x14, 0x5a, 0x49,
	0x5b, 0x46, 0xaa, 0x9b, 0xc4, 0xda, 0x30, 0x50, 0x5f, 0xa1, 0xf4, 0xf8, 0xba, 0x31, 0xe1, 0x4d,
	0x64, 0xd5, 0x77, 0xd7, 0x97, 0xdf, 0x7f, 0xbe, 0x65, 0x66, 0xd1, 0x8c, 0xf2, 0x61, 0x4d, 0xf9,
	0xe4, 0xc5, 0x37, 0xa3, 0x25, 0x9f, 0xa3, 0x0b, 0x98, 0x8c, 0x5b, 0x1d, 0x2d, 0xa7, 0x11, 0xa5,
	0x3c, 0x06, 0xf1, 0x76, 0x27, 0x49, 0xcb, 0xd7, 0x0d, 0xbe, 0x16, 0xce, 0x2e, 0xa2, 0x72, 0x1a,
	0xbb, 0x52, 0xab, 0x9d, 0xa3, 0xcf, 0x50, 0x4c, 0x18, 0x02, 0xa5, 0x36, 0x9b, 0xee, 0x1a, 0xb1,
	0xd4, 0xb7, 0xe4, 0xe7, 0xde, 0xaf, 0x5a, 0x82, 0xbf, 0x36, 0x98, 0xff, 0xab, 0x00, 0xc5, 0x84,
	0x7f, 0xd3, 0x05, 0xa4, 0x9b, 0x7c, 0xa0, 0x80, 0xb5, 0xb8, 0x80, 0x87, 0xd2, 0xfd, 0x41, 0x02,
	0x36, 0x74, 0x5e, 0x77, 0x43, 0xa8, 0xa1, 0x63, 0x28, 0xdc, 0x70, 0x3b, 0xaa, 0xa6, 0xe9, 0x48,
	0x7b, 0x10, 0xff, 0xdb, 0xc6, 0x88, 0xb8, 0x70, 0xd5, 0x10, 0xe3, 0x39, 0x1f, 0xae, 0xd9, 0xa6,
	0x2b, 0xeb, 0xb4, 0xbd, 0x61, 0xc2, 0x54, 0x4f, 0x56, 0xd3, 0xf4, 0x1e, 0xc2, 0x62, 0x5f, 0x5f,
	0x2f, 0x31, 0x7b, 0x4b, 0x5b, 0xfb, 0xb6, 0xff, 0x7b, 0xf2, 0x33, 0xc7, 0x1f, 0xd9, 0x83, 0x5b,
	0x89, 0xbd, 0x27, 0xa5, 0x16, 0x68, 0xfc, 0xb8, 0xf5, 0x43, 0x80, 0x92, 0x4e, 0xdb, 0x29, 0xf7,
	0xb6, 0x8a, 0x91, 0x9b, 0x0f, 0x3c, 0xd6, 0x03, 0xe1, 0x78, 0x33, 0x80, 0x19, 0xd4, 0xd2, 0x88,
	0x21, 0x53, 0xc7, 0x50, 0x0c, 0x4c, 0xb8, 0x26, 0x25, 0xea, 0x21, 0xfe, 0xf7, 0xfb, 0x34, 0xf6,
	0xfd, 0x57, 0x10, 0x2e, 0x33, 0x68, 0xc7, 0x2f, 0xb1, 0x47, 0x89, 0xa1, 0xfa, 0xf1, 0xab, 0x30,
	0xf8, 0x26, 0x16, 0x3c, 0x19, 0xe7, 0x65, 0xd7, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x1d, 0x6d,
	0xe6, 0x13, 0xd4, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// OperationsClient is the client API for Operations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type OperationsClient interface {
	// Lists operations that match the specified filter in the request. If the
	// server doesn't support this method, it returns `UNIMPLEMENTED`.
	//
	// NOTE: the `name` binding allows API services to override the binding
	// to use different resource name schemes, such as `users/*/operations`. To
	// override the binding, API services can add a binding such as
	// `"/v1/{name=users/*}/operations"` to their service configuration.
	// For backwards compatibility, the default name includes the operations
	// collection id, however overriding users must ensure the name binding
	// is the parent resource, without the operations collection id.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
	// Gets the latest state of a long-running operation.  Clients can use this
	// method to poll the operation result at intervals as recommended by the API
	// service.
	GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a long-running operation. This method indicates that the client is
	// no longer interested in the operation result. It does not cancel the
	// operation. If the server doesn't support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.
	DeleteOperation(ctx context.Context, in *DeleteOperationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Starts asynchronous cancellation on a long-running operation.  The server
	// makes a best effort to cancel the operation, but success is not
	// guaranteed.  If the server doesn't support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
	// other methods to check whether the cancellation succeeded or whether the
	// operation completed despite cancellation. On successful cancellation,
	// the operation is not deleted; instead, it becomes an operation with
	// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Waits for the specified long-running operation until it is done or reaches
	// at most a specified timeout, returning the latest state.  If the operation
	// is already done, the latest state is immediately returned.  If the timeout
	// specified is greater than the default HTTP/RPC timeout, the HTTP/RPC
	// timeout is used.  If the server does not support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.
	// Note that this method is on a best-effort basis.  It may return the latest
	// state before the specified timeout (including immediately), meaning even an
	// immediate response is no guarantee that the operation is done.
	WaitOperation(ctx context.Context, in *WaitOperationRequest, opts ...grpc.CallOption) (*Operation, error)
}

type operationsClient struct {
	cc *grpc.ClientConn
}

func NewOperationsClient(cc *grpc.ClientConn) OperationsClient {
	return &operationsClient{cc}
}

func (c *operationsClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	out := new(ListOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.longrunning.Operations/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationsClient) GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.longrunning.Operations/GetOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationsClient) DeleteOperation(ctx context.Context, in *DeleteOperationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.longrunning.Operations/DeleteOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationsClient) CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.longrunning.Operations/CancelOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationsClient) WaitOperation(ctx context.Context, in *WaitOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.longrunning.Operations/WaitOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OperationsServer is the server API for Operations service.
type OperationsServer interface {
	// Lists operations that match the specified filter in the request. If the
	// server doesn't support this method, it returns `UNIMPLEMENTED`.
	//
	// NOTE: the `name` binding allows API services to override the binding
	// to use different resource name schemes, such as `users/*/operations`. To
	// override the binding, API services can add a binding such as
	// `"/v1/{name=users/*}/operations"` to their service configuration.
	// For backwards compatibility, the default name includes the operations
	// collection id, however overriding users must ensure the name binding
	// is the parent resource, without the operations collection id.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
	// Gets the latest state of a long-running operation.  Clients can use this
	// method to poll the operation result at intervals as recommended by the API
	// service.
	GetOperation(context.Context, *GetOperationRequest) (*Operation, error)
	// Deletes a long-running operation. This method indicates that the client is
	// no longer interested in the operation result. It does not cancel the
	// operation. If the server doesn't support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.
	DeleteOperation(context.Context, *DeleteOperationRequest) (*empty.Empty, error)
	// Starts asynchronous cancellation on a long-running operation.  The server
	// makes a best effort to cancel the operation, but success is not
	// guaranteed.  If the server doesn't support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
	// other methods to check whether the cancellation succeeded or whether the
	// operation completed despite cancellation. On successful cancellation,
	// the operation is not deleted; instead, it becomes an operation with
	// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelOperation(context.Context, *CancelOperationRequest) (*empty.Empty, error)
	// Waits for the specified long-running operation until it is done or reaches
	// at most a specified timeout, returning the latest state.  If the operation
	// is already done, the latest state is immediately returned.  If the timeout
	// specified is greater than the default HTTP/RPC timeout, the HTTP/RPC
	// timeout is used.  If the server does not support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.
	// Note that this method is on a best-effort basis.  It may return the latest
	// state before the specified timeout (including immediately), meaning even an
	// immediate response is no guarantee that the operation is done.
	WaitOperation(context.Context, *WaitOperationRequest) (*Operation, error)
}

// UnimplementedOperationsServer can be embedded to have forward compatible implementations.
type UnimplementedOperationsServer struct {
}

func (*UnimplementedOperationsServer) ListOperations(ctx context.Context, req *ListOperationsRequest) (*ListOperationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedOperationsServer) GetOperation(ctx context.Context, req *GetOperationRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetOperation not implemented")
}
func (*UnimplementedOperationsServer) DeleteOperation(ctx context.Context, req *DeleteOperationRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteOperation not implemented")
}
func (*UnimplementedOperationsServer) CancelOperation(ctx context.Context, req *CancelOperationRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CancelOperation not implemented")
}
func (*UnimplementedOperationsServer) WaitOperation(ctx context.Context, req *WaitOperationRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method WaitOperation not implemented")
}

func RegisterOperationsServer(s *grpc.Server, srv OperationsServer) {
	s.RegisterService(&_Operations_serviceDesc, srv)
}

func _Operations_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operations_GetOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).GetOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/GetOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).GetOperation(ctx, req.(*GetOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operations_DeleteOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).DeleteOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/DeleteOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).DeleteOperation(ctx, req.(*DeleteOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operations_CancelOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).CancelOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/CancelOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).CancelOperation(ctx, req.(*CancelOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operations_WaitOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WaitOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).WaitOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/WaitOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).WaitOperation(ctx, req.(*WaitOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Operations_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.longrunning.Operations",
	HandlerType: (*OperationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListOperations",
			Handler:    _Operations_ListOperations_Handler,
		},
		{
			MethodName: "GetOperation",
			Handler:    _Operations_GetOperation_Handler,
		},
		{
			MethodName: "DeleteOperation",
			Handler:    _Operations_DeleteOperation_Handler,
		},
		{
			MethodName: "CancelOperation",
			Handler:    _Operations_CancelOperation_Handler,
		},
		{
			MethodName: "WaitOperation",
			Handler:    _Operations_WaitOperation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/longrunning/operations.proto",
}
