// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/recommendation.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A recommendation.
type Recommendation struct {
	// The resource name of the recommendation.
	//
	// `customers/{customer_id}/recommendations/{recommendation_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The type of recommendation.
	Type enums.RecommendationTypeEnum_RecommendationType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v2.enums.RecommendationTypeEnum_RecommendationType" json:"type,omitempty"`
	// The impact on account performance as a result of applying the
	// recommendation.
	Impact *Recommendation_RecommendationImpact `protobuf:"bytes,3,opt,name=impact,proto3" json:"impact,omitempty"`
	// The budget targeted by this recommendation. This will be set only when
	// the recommendation affects a single campaign budget.
	//
	// This field will be set for the following recommendation types:
	// CAMPAIGN_BUDGET, MOVE_UNUSED_BUDGET
	CampaignBudget *wrappers.StringValue `protobuf:"bytes,5,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// The campaign targeted by this recommendation. This will be set only when
	// the recommendation affects a single campaign.
	//
	// This field will be set for the following recommendation types:
	// CALL_EXTENSION, CALLOUT_EXTENSION, ENHANCED_CPC_OPT_IN, KEYWORD,
	// KEYWORD_MATCH_TYPE, MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
	// OPTIMIZE_AD_ROTATION, SEARCH_PARTNERS_OPT_IN, SITELINK_EXTENSION,
	// TARGET_CPA_OPT_IN, TEXT_AD
	Campaign *wrappers.StringValue `protobuf:"bytes,6,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The ad group targeted by this recommendation. This will be set only when
	// the recommendation affects a single ad group.
	//
	// This field will be set for the following recommendation types:
	// KEYWORD, OPTIMIZE_AD_ROTATION, TEXT_AD
	AdGroup *wrappers.StringValue `protobuf:"bytes,7,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// Whether the recommendation is dismissed or not.
	Dismissed *wrappers.BoolValue `protobuf:"bytes,13,opt,name=dismissed,proto3" json:"dismissed,omitempty"`
	// The details of recommendation.
	//
	// Types that are valid to be assigned to Recommendation:
	//	*Recommendation_CampaignBudgetRecommendation_
	//	*Recommendation_KeywordRecommendation_
	//	*Recommendation_TextAdRecommendation_
	//	*Recommendation_TargetCpaOptInRecommendation_
	//	*Recommendation_MaximizeConversionsOptInRecommendation_
	//	*Recommendation_EnhancedCpcOptInRecommendation_
	//	*Recommendation_SearchPartnersOptInRecommendation_
	//	*Recommendation_MaximizeClicksOptInRecommendation_
	//	*Recommendation_OptimizeAdRotationRecommendation_
	//	*Recommendation_CalloutExtensionRecommendation_
	//	*Recommendation_SitelinkExtensionRecommendation_
	//	*Recommendation_CallExtensionRecommendation_
	//	*Recommendation_KeywordMatchTypeRecommendation_
	//	*Recommendation_MoveUnusedBudgetRecommendation_
	Recommendation       isRecommendation_Recommendation `protobuf_oneof:"recommendation"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Recommendation) Reset()         { *m = Recommendation{} }
func (m *Recommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation) ProtoMessage()    {}
func (*Recommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0}
}

func (m *Recommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation.Unmarshal(m, b)
}
func (m *Recommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation.Merge(m, src)
}
func (m *Recommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation.Size(m)
}
func (m *Recommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation proto.InternalMessageInfo

func (m *Recommendation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Recommendation) GetType() enums.RecommendationTypeEnum_RecommendationType {
	if m != nil {
		return m.Type
	}
	return enums.RecommendationTypeEnum_UNSPECIFIED
}

func (m *Recommendation) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

func (m *Recommendation) GetCampaignBudget() *wrappers.StringValue {
	if m != nil {
		return m.CampaignBudget
	}
	return nil
}

func (m *Recommendation) GetCampaign() *wrappers.StringValue {
	if m != nil {
		return m.Campaign
	}
	return nil
}

func (m *Recommendation) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *Recommendation) GetDismissed() *wrappers.BoolValue {
	if m != nil {
		return m.Dismissed
	}
	return nil
}

type isRecommendation_Recommendation interface {
	isRecommendation_Recommendation()
}

type Recommendation_CampaignBudgetRecommendation_ struct {
	CampaignBudgetRecommendation *Recommendation_CampaignBudgetRecommendation `protobuf:"bytes,4,opt,name=campaign_budget_recommendation,json=campaignBudgetRecommendation,proto3,oneof"`
}

type Recommendation_KeywordRecommendation_ struct {
	KeywordRecommendation *Recommendation_KeywordRecommendation `protobuf:"bytes,8,opt,name=keyword_recommendation,json=keywordRecommendation,proto3,oneof"`
}

type Recommendation_TextAdRecommendation_ struct {
	TextAdRecommendation *Recommendation_TextAdRecommendation `protobuf:"bytes,9,opt,name=text_ad_recommendation,json=textAdRecommendation,proto3,oneof"`
}

type Recommendation_TargetCpaOptInRecommendation_ struct {
	TargetCpaOptInRecommendation *Recommendation_TargetCpaOptInRecommendation `protobuf:"bytes,10,opt,name=target_cpa_opt_in_recommendation,json=targetCpaOptInRecommendation,proto3,oneof"`
}

type Recommendation_MaximizeConversionsOptInRecommendation_ struct {
	MaximizeConversionsOptInRecommendation *Recommendation_MaximizeConversionsOptInRecommendation `protobuf:"bytes,11,opt,name=maximize_conversions_opt_in_recommendation,json=maximizeConversionsOptInRecommendation,proto3,oneof"`
}

type Recommendation_EnhancedCpcOptInRecommendation_ struct {
	EnhancedCpcOptInRecommendation *Recommendation_EnhancedCpcOptInRecommendation `protobuf:"bytes,12,opt,name=enhanced_cpc_opt_in_recommendation,json=enhancedCpcOptInRecommendation,proto3,oneof"`
}

type Recommendation_SearchPartnersOptInRecommendation_ struct {
	SearchPartnersOptInRecommendation *Recommendation_SearchPartnersOptInRecommendation `protobuf:"bytes,14,opt,name=search_partners_opt_in_recommendation,json=searchPartnersOptInRecommendation,proto3,oneof"`
}

type Recommendation_MaximizeClicksOptInRecommendation_ struct {
	MaximizeClicksOptInRecommendation *Recommendation_MaximizeClicksOptInRecommendation `protobuf:"bytes,15,opt,name=maximize_clicks_opt_in_recommendation,json=maximizeClicksOptInRecommendation,proto3,oneof"`
}

type Recommendation_OptimizeAdRotationRecommendation_ struct {
	OptimizeAdRotationRecommendation *Recommendation_OptimizeAdRotationRecommendation `protobuf:"bytes,16,opt,name=optimize_ad_rotation_recommendation,json=optimizeAdRotationRecommendation,proto3,oneof"`
}

type Recommendation_CalloutExtensionRecommendation_ struct {
	CalloutExtensionRecommendation *Recommendation_CalloutExtensionRecommendation `protobuf:"bytes,17,opt,name=callout_extension_recommendation,json=calloutExtensionRecommendation,proto3,oneof"`
}

type Recommendation_SitelinkExtensionRecommendation_ struct {
	SitelinkExtensionRecommendation *Recommendation_SitelinkExtensionRecommendation `protobuf:"bytes,18,opt,name=sitelink_extension_recommendation,json=sitelinkExtensionRecommendation,proto3,oneof"`
}

type Recommendation_CallExtensionRecommendation_ struct {
	CallExtensionRecommendation *Recommendation_CallExtensionRecommendation `protobuf:"bytes,19,opt,name=call_extension_recommendation,json=callExtensionRecommendation,proto3,oneof"`
}

type Recommendation_KeywordMatchTypeRecommendation_ struct {
	KeywordMatchTypeRecommendation *Recommendation_KeywordMatchTypeRecommendation `protobuf:"bytes,20,opt,name=keyword_match_type_recommendation,json=keywordMatchTypeRecommendation,proto3,oneof"`
}

type Recommendation_MoveUnusedBudgetRecommendation_ struct {
	MoveUnusedBudgetRecommendation *Recommendation_MoveUnusedBudgetRecommendation `protobuf:"bytes,21,opt,name=move_unused_budget_recommendation,json=moveUnusedBudgetRecommendation,proto3,oneof"`
}

func (*Recommendation_CampaignBudgetRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_KeywordRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_TextAdRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_TargetCpaOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MaximizeConversionsOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_EnhancedCpcOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_SearchPartnersOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MaximizeClicksOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_OptimizeAdRotationRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_CalloutExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_SitelinkExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_CallExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_KeywordMatchTypeRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MoveUnusedBudgetRecommendation_) isRecommendation_Recommendation() {}

func (m *Recommendation) GetRecommendation() isRecommendation_Recommendation {
	if m != nil {
		return m.Recommendation
	}
	return nil
}

func (m *Recommendation) GetCampaignBudgetRecommendation() *Recommendation_CampaignBudgetRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_CampaignBudgetRecommendation_); ok {
		return x.CampaignBudgetRecommendation
	}
	return nil
}

func (m *Recommendation) GetKeywordRecommendation() *Recommendation_KeywordRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_KeywordRecommendation_); ok {
		return x.KeywordRecommendation
	}
	return nil
}

func (m *Recommendation) GetTextAdRecommendation() *Recommendation_TextAdRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_TextAdRecommendation_); ok {
		return x.TextAdRecommendation
	}
	return nil
}

func (m *Recommendation) GetTargetCpaOptInRecommendation() *Recommendation_TargetCpaOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_TargetCpaOptInRecommendation_); ok {
		return x.TargetCpaOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetMaximizeConversionsOptInRecommendation() *Recommendation_MaximizeConversionsOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_MaximizeConversionsOptInRecommendation_); ok {
		return x.MaximizeConversionsOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetEnhancedCpcOptInRecommendation() *Recommendation_EnhancedCpcOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_EnhancedCpcOptInRecommendation_); ok {
		return x.EnhancedCpcOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetSearchPartnersOptInRecommendation() *Recommendation_SearchPartnersOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_SearchPartnersOptInRecommendation_); ok {
		return x.SearchPartnersOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetMaximizeClicksOptInRecommendation() *Recommendation_MaximizeClicksOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_MaximizeClicksOptInRecommendation_); ok {
		return x.MaximizeClicksOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetOptimizeAdRotationRecommendation() *Recommendation_OptimizeAdRotationRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_OptimizeAdRotationRecommendation_); ok {
		return x.OptimizeAdRotationRecommendation
	}
	return nil
}

func (m *Recommendation) GetCalloutExtensionRecommendation() *Recommendation_CalloutExtensionRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_CalloutExtensionRecommendation_); ok {
		return x.CalloutExtensionRecommendation
	}
	return nil
}

func (m *Recommendation) GetSitelinkExtensionRecommendation() *Recommendation_SitelinkExtensionRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_SitelinkExtensionRecommendation_); ok {
		return x.SitelinkExtensionRecommendation
	}
	return nil
}

func (m *Recommendation) GetCallExtensionRecommendation() *Recommendation_CallExtensionRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_CallExtensionRecommendation_); ok {
		return x.CallExtensionRecommendation
	}
	return nil
}

func (m *Recommendation) GetKeywordMatchTypeRecommendation() *Recommendation_KeywordMatchTypeRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_KeywordMatchTypeRecommendation_); ok {
		return x.KeywordMatchTypeRecommendation
	}
	return nil
}

func (m *Recommendation) GetMoveUnusedBudgetRecommendation() *Recommendation_MoveUnusedBudgetRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_MoveUnusedBudgetRecommendation_); ok {
		return x.MoveUnusedBudgetRecommendation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Recommendation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Recommendation_CampaignBudgetRecommendation_)(nil),
		(*Recommendation_KeywordRecommendation_)(nil),
		(*Recommendation_TextAdRecommendation_)(nil),
		(*Recommendation_TargetCpaOptInRecommendation_)(nil),
		(*Recommendation_MaximizeConversionsOptInRecommendation_)(nil),
		(*Recommendation_EnhancedCpcOptInRecommendation_)(nil),
		(*Recommendation_SearchPartnersOptInRecommendation_)(nil),
		(*Recommendation_MaximizeClicksOptInRecommendation_)(nil),
		(*Recommendation_OptimizeAdRotationRecommendation_)(nil),
		(*Recommendation_CalloutExtensionRecommendation_)(nil),
		(*Recommendation_SitelinkExtensionRecommendation_)(nil),
		(*Recommendation_CallExtensionRecommendation_)(nil),
		(*Recommendation_KeywordMatchTypeRecommendation_)(nil),
		(*Recommendation_MoveUnusedBudgetRecommendation_)(nil),
	}
}

// The impact of making the change as described in the recommendation.
// Some types of recommendations may not have impact information.
type Recommendation_RecommendationImpact struct {
	// Base metrics at the time the recommendation was generated.
	BaseMetrics *Recommendation_RecommendationMetrics `protobuf:"bytes,1,opt,name=base_metrics,json=baseMetrics,proto3" json:"base_metrics,omitempty"`
	// Estimated metrics if the recommendation is applied.
	PotentialMetrics     *Recommendation_RecommendationMetrics `protobuf:"bytes,2,opt,name=potential_metrics,json=potentialMetrics,proto3" json:"potential_metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *Recommendation_RecommendationImpact) Reset()         { *m = Recommendation_RecommendationImpact{} }
func (m *Recommendation_RecommendationImpact) String() string { return proto.CompactTextString(m) }
func (*Recommendation_RecommendationImpact) ProtoMessage()    {}
func (*Recommendation_RecommendationImpact) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 0}
}

func (m *Recommendation_RecommendationImpact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Unmarshal(m, b)
}
func (m *Recommendation_RecommendationImpact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Marshal(b, m, deterministic)
}
func (m *Recommendation_RecommendationImpact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_RecommendationImpact.Merge(m, src)
}
func (m *Recommendation_RecommendationImpact) XXX_Size() int {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Size(m)
}
func (m *Recommendation_RecommendationImpact) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_RecommendationImpact.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_RecommendationImpact proto.InternalMessageInfo

func (m *Recommendation_RecommendationImpact) GetBaseMetrics() *Recommendation_RecommendationMetrics {
	if m != nil {
		return m.BaseMetrics
	}
	return nil
}

func (m *Recommendation_RecommendationImpact) GetPotentialMetrics() *Recommendation_RecommendationMetrics {
	if m != nil {
		return m.PotentialMetrics
	}
	return nil
}

// Weekly account performance metrics. For some recommendation types, these
// are averaged over the past 90-day period and hence can be fractional.
type Recommendation_RecommendationMetrics struct {
	// Number of ad impressions.
	Impressions *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Number of ad clicks.
	Clicks *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Cost (in micros) for advertising, in the local currency for the account.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Number of conversions.
	Conversions *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=conversions,proto3" json:"conversions,omitempty"`
	// Number of video views for a video ad campaign.
	VideoViews           *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=video_views,json=videoViews,proto3" json:"video_views,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Recommendation_RecommendationMetrics) Reset()         { *m = Recommendation_RecommendationMetrics{} }
func (m *Recommendation_RecommendationMetrics) String() string { return proto.CompactTextString(m) }
func (*Recommendation_RecommendationMetrics) ProtoMessage()    {}
func (*Recommendation_RecommendationMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 1}
}

func (m *Recommendation_RecommendationMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Unmarshal(m, b)
}
func (m *Recommendation_RecommendationMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Marshal(b, m, deterministic)
}
func (m *Recommendation_RecommendationMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_RecommendationMetrics.Merge(m, src)
}
func (m *Recommendation_RecommendationMetrics) XXX_Size() int {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Size(m)
}
func (m *Recommendation_RecommendationMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_RecommendationMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_RecommendationMetrics proto.InternalMessageInfo

func (m *Recommendation_RecommendationMetrics) GetImpressions() *wrappers.DoubleValue {
	if m != nil {
		return m.Impressions
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetClicks() *wrappers.DoubleValue {
	if m != nil {
		return m.Clicks
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.Conversions
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetVideoViews() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoViews
	}
	return nil
}

// The budget recommendation for budget constrained campaigns.
type Recommendation_CampaignBudgetRecommendation struct {
	// The current budget amount in micros.
	CurrentBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=current_budget_amount_micros,json=currentBudgetAmountMicros,proto3" json:"current_budget_amount_micros,omitempty"`
	// The recommended budget amount in micros.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	// The budget amounts and associated impact estimates for some values of
	// possible budget amounts.
	BudgetOptions        []*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption `protobuf:"bytes,3,rep,name=budget_options,json=budgetOptions,proto3" json:"budget_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                                          `json:"-"`
	XXX_unrecognized     []byte                                                                            `json:"-"`
	XXX_sizecache        int32                                                                             `json:"-"`
}

func (m *Recommendation_CampaignBudgetRecommendation) Reset() {
	*m = Recommendation_CampaignBudgetRecommendation{}
}
func (m *Recommendation_CampaignBudgetRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CampaignBudgetRecommendation) ProtoMessage() {}
func (*Recommendation_CampaignBudgetRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 2}
}

func (m *Recommendation_CampaignBudgetRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Merge(m, src)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Size(m)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CampaignBudgetRecommendation proto.InternalMessageInfo

func (m *Recommendation_CampaignBudgetRecommendation) GetCurrentBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CurrentBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation) GetBudgetOptions() []*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption {
	if m != nil {
		return m.BudgetOptions
	}
	return nil
}

// The impact estimates for a given budget amount.
type Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption struct {
	// The budget amount for this option.
	BudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=budget_amount_micros,json=budgetAmountMicros,proto3" json:"budget_amount_micros,omitempty"`
	// The impact estimate if budget is changed to amount specified in this
	// option.
	Impact               *Recommendation_RecommendationImpact `protobuf:"bytes,2,opt,name=impact,proto3" json:"impact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) Reset() {
	*m = Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption{}
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) ProtoMessage() {
}
func (*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 2, 0}
}

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Unmarshal(m, b)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Marshal(b, m, deterministic)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Merge(m, src)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Size(m)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption proto.InternalMessageInfo

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) GetBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

// The keyword recommendation.
type Recommendation_KeywordRecommendation struct {
	// The recommended keyword.
	Keyword *common.KeywordInfo `protobuf:"bytes,1,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// The recommended CPC (cost-per-click) bid.
	RecommendedCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_cpc_bid_micros,json=recommendedCpcBidMicros,proto3" json:"recommended_cpc_bid_micros,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}             `json:"-"`
	XXX_unrecognized        []byte               `json:"-"`
	XXX_sizecache           int32                `json:"-"`
}

func (m *Recommendation_KeywordRecommendation) Reset()         { *m = Recommendation_KeywordRecommendation{} }
func (m *Recommendation_KeywordRecommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation_KeywordRecommendation) ProtoMessage()    {}
func (*Recommendation_KeywordRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 3}
}

func (m *Recommendation_KeywordRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_KeywordRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_KeywordRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_KeywordRecommendation.Merge(m, src)
}
func (m *Recommendation_KeywordRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Size(m)
}
func (m *Recommendation_KeywordRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_KeywordRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_KeywordRecommendation proto.InternalMessageInfo

func (m *Recommendation_KeywordRecommendation) GetKeyword() *common.KeywordInfo {
	if m != nil {
		return m.Keyword
	}
	return nil
}

func (m *Recommendation_KeywordRecommendation) GetRecommendedCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedCpcBidMicros
	}
	return nil
}

// The Target CPA opt-in recommendation.
type Recommendation_TargetCpaOptInRecommendation struct {
	// The available goals and corresponding options for Target CPA strategy.
	Options []*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
	// The recommended average CPA target. See required budget amount and impact
	// of using this recommendation in options list.
	RecommendedTargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_target_cpa_micros,json=recommendedTargetCpaMicros,proto3" json:"recommended_target_cpa_micros,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}             `json:"-"`
	XXX_unrecognized           []byte               `json:"-"`
	XXX_sizecache              int32                `json:"-"`
}

func (m *Recommendation_TargetCpaOptInRecommendation) Reset() {
	*m = Recommendation_TargetCpaOptInRecommendation{}
}
func (m *Recommendation_TargetCpaOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_TargetCpaOptInRecommendation) ProtoMessage() {}
func (*Recommendation_TargetCpaOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 4}
}

func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Merge(m, src)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Size(m)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_TargetCpaOptInRecommendation) GetOptions() []*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation) GetRecommendedTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedTargetCpaMicros
	}
	return nil
}

// The Target CPA opt-in option with impact estimate.
type Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption struct {
	// The goal achieved by this option.
	Goal enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal `protobuf:"varint,1,opt,name=goal,proto3,enum=google.ads.googleads.v2.enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal" json:"goal,omitempty"`
	// Average CPA target.
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// The minimum campaign budget, in local currency for the account,
	// required to achieve the target CPA.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	RequiredCampaignBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=required_campaign_budget_amount_micros,json=requiredCampaignBudgetAmountMicros,proto3" json:"required_campaign_budget_amount_micros,omitempty"`
	// The impact estimate if this option is selected.
	Impact               *Recommendation_RecommendationImpact `protobuf:"bytes,4,opt,name=impact,proto3" json:"impact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) Reset() {
	*m = Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption{}
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) ProtoMessage() {
}
func (*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 4, 0}
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Unmarshal(m, b)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Marshal(b, m, deterministic)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Merge(m, src)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Size(m)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption proto.InternalMessageInfo

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetGoal() enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal {
	if m != nil {
		return m.Goal
	}
	return enums.TargetCpaOptInRecommendationGoalEnum_UNSPECIFIED
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpaMicros
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetRequiredCampaignBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RequiredCampaignBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

// The text ad recommendation.
type Recommendation_TextAdRecommendation struct {
	// Recommended ad.
	Ad *Ad `protobuf:"bytes,1,opt,name=ad,proto3" json:"ad,omitempty"`
	// Creation date of the recommended ad.
	// YYYY-MM-DD format, e.g., 2018-04-17.
	CreationDate *wrappers.StringValue `protobuf:"bytes,2,opt,name=creation_date,json=creationDate,proto3" json:"creation_date,omitempty"`
	// Date, if present, is the earliest when the recommendation will be auto
	// applied.
	// YYYY-MM-DD format, e.g., 2018-04-17.
	AutoApplyDate        *wrappers.StringValue `protobuf:"bytes,3,opt,name=auto_apply_date,json=autoApplyDate,proto3" json:"auto_apply_date,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Recommendation_TextAdRecommendation) Reset()         { *m = Recommendation_TextAdRecommendation{} }
func (m *Recommendation_TextAdRecommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation_TextAdRecommendation) ProtoMessage()    {}
func (*Recommendation_TextAdRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 5}
}

func (m *Recommendation_TextAdRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_TextAdRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_TextAdRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TextAdRecommendation.Merge(m, src)
}
func (m *Recommendation_TextAdRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Size(m)
}
func (m *Recommendation_TextAdRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TextAdRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TextAdRecommendation proto.InternalMessageInfo

func (m *Recommendation_TextAdRecommendation) GetAd() *Ad {
	if m != nil {
		return m.Ad
	}
	return nil
}

func (m *Recommendation_TextAdRecommendation) GetCreationDate() *wrappers.StringValue {
	if m != nil {
		return m.CreationDate
	}
	return nil
}

func (m *Recommendation_TextAdRecommendation) GetAutoApplyDate() *wrappers.StringValue {
	if m != nil {
		return m.AutoApplyDate
	}
	return nil
}

// The Sitelink extension recommendation.
type Recommendation_SitelinkExtensionRecommendation struct {
	// Sitelink extensions recommended to be added.
	RecommendedExtensions []*common.SitelinkFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                   `json:"-"`
	XXX_unrecognized      []byte                     `json:"-"`
	XXX_sizecache         int32                      `json:"-"`
}

func (m *Recommendation_SitelinkExtensionRecommendation) Reset() {
	*m = Recommendation_SitelinkExtensionRecommendation{}
}
func (m *Recommendation_SitelinkExtensionRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_SitelinkExtensionRecommendation) ProtoMessage() {}
func (*Recommendation_SitelinkExtensionRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 6}
}

func (m *Recommendation_SitelinkExtensionRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_SitelinkExtensionRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_SitelinkExtensionRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.Merge(m, src)
}
func (m *Recommendation_SitelinkExtensionRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.Size(m)
}
func (m *Recommendation_SitelinkExtensionRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation proto.InternalMessageInfo

func (m *Recommendation_SitelinkExtensionRecommendation) GetRecommendedExtensions() []*common.SitelinkFeedItem {
	if m != nil {
		return m.RecommendedExtensions
	}
	return nil
}

// The move unused budget recommendation.
type Recommendation_MoveUnusedBudgetRecommendation struct {
	// The excess budget's resource_name.
	ExcessCampaignBudget *wrappers.StringValue `protobuf:"bytes,1,opt,name=excess_campaign_budget,json=excessCampaignBudget,proto3" json:"excess_campaign_budget,omitempty"`
	// The recommendation for the constrained budget to increase.
	BudgetRecommendation *Recommendation_CampaignBudgetRecommendation `protobuf:"bytes,2,opt,name=budget_recommendation,json=budgetRecommendation,proto3" json:"budget_recommendation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *Recommendation_MoveUnusedBudgetRecommendation) Reset() {
	*m = Recommendation_MoveUnusedBudgetRecommendation{}
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_MoveUnusedBudgetRecommendation) ProtoMessage() {}
func (*Recommendation_MoveUnusedBudgetRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 7}
}

func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.Merge(m, src)
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.Size(m)
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation proto.InternalMessageInfo

func (m *Recommendation_MoveUnusedBudgetRecommendation) GetExcessCampaignBudget() *wrappers.StringValue {
	if m != nil {
		return m.ExcessCampaignBudget
	}
	return nil
}

func (m *Recommendation_MoveUnusedBudgetRecommendation) GetBudgetRecommendation() *Recommendation_CampaignBudgetRecommendation {
	if m != nil {
		return m.BudgetRecommendation
	}
	return nil
}

// The Maximize Conversions Opt-In recommendation.
type Recommendation_MaximizeConversionsOptInRecommendation struct {
	// The recommended new budget amount.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *Recommendation_MaximizeConversionsOptInRecommendation) Reset() {
	*m = Recommendation_MaximizeConversionsOptInRecommendation{}
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_MaximizeConversionsOptInRecommendation) ProtoMessage() {}
func (*Recommendation_MaximizeConversionsOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 8}
}

func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Merge(m, src)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Size(m)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_MaximizeConversionsOptInRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

// The Enhanced Cost-Per-Click Opt-In recommendation.
type Recommendation_EnhancedCpcOptInRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_EnhancedCpcOptInRecommendation) Reset() {
	*m = Recommendation_EnhancedCpcOptInRecommendation{}
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_EnhancedCpcOptInRecommendation) ProtoMessage() {}
func (*Recommendation_EnhancedCpcOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 9}
}

func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Merge(m, src)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Size(m)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation proto.InternalMessageInfo

// The keyword match type recommendation.
type Recommendation_KeywordMatchTypeRecommendation struct {
	// The existing keyword where the match type should be more broad.
	Keyword *common.KeywordInfo `protobuf:"bytes,1,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// The recommended new match type.
	RecommendedMatchType enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=recommended_match_type,json=recommendedMatchType,proto3,enum=google.ads.googleads.v2.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"recommended_match_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *Recommendation_KeywordMatchTypeRecommendation) Reset() {
	*m = Recommendation_KeywordMatchTypeRecommendation{}
}
func (m *Recommendation_KeywordMatchTypeRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_KeywordMatchTypeRecommendation) ProtoMessage() {}
func (*Recommendation_KeywordMatchTypeRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 10}
}

func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.Merge(m, src)
}
func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.Size(m)
}
func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation proto.InternalMessageInfo

func (m *Recommendation_KeywordMatchTypeRecommendation) GetKeyword() *common.KeywordInfo {
	if m != nil {
		return m.Keyword
	}
	return nil
}

func (m *Recommendation_KeywordMatchTypeRecommendation) GetRecommendedMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if m != nil {
		return m.RecommendedMatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

// The Search Partners Opt-In recommendation.
type Recommendation_SearchPartnersOptInRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_SearchPartnersOptInRecommendation) Reset() {
	*m = Recommendation_SearchPartnersOptInRecommendation{}
}
func (m *Recommendation_SearchPartnersOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_SearchPartnersOptInRecommendation) ProtoMessage() {}
func (*Recommendation_SearchPartnersOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 11}
}

func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Merge(m, src)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Size(m)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation proto.InternalMessageInfo

// The Maximize Clicks opt-in recommendation.
type Recommendation_MaximizeClicksOptInRecommendation struct {
	// The recommended new budget amount.
	// Only set if the current budget is too high.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *Recommendation_MaximizeClicksOptInRecommendation) Reset() {
	*m = Recommendation_MaximizeClicksOptInRecommendation{}
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_MaximizeClicksOptInRecommendation) ProtoMessage() {}
func (*Recommendation_MaximizeClicksOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 12}
}

func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Merge(m, src)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Size(m)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_MaximizeClicksOptInRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

// The Optimize Ad Rotation recommendation.
type Recommendation_OptimizeAdRotationRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_OptimizeAdRotationRecommendation) Reset() {
	*m = Recommendation_OptimizeAdRotationRecommendation{}
}
func (m *Recommendation_OptimizeAdRotationRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_OptimizeAdRotationRecommendation) ProtoMessage() {}
func (*Recommendation_OptimizeAdRotationRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 13}
}

func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Merge(m, src)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Size(m)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation proto.InternalMessageInfo

// The Callout extension recommendation.
type Recommendation_CalloutExtensionRecommendation struct {
	// Callout extensions recommended to be added.
	RecommendedExtensions []*common.CalloutFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                  `json:"-"`
	XXX_unrecognized      []byte                    `json:"-"`
	XXX_sizecache         int32                     `json:"-"`
}

func (m *Recommendation_CalloutExtensionRecommendation) Reset() {
	*m = Recommendation_CalloutExtensionRecommendation{}
}
func (m *Recommendation_CalloutExtensionRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CalloutExtensionRecommendation) ProtoMessage() {}
func (*Recommendation_CalloutExtensionRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 14}
}

func (m *Recommendation_CalloutExtensionRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_CalloutExtensionRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_CalloutExtensionRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.Merge(m, src)
}
func (m *Recommendation_CalloutExtensionRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.Size(m)
}
func (m *Recommendation_CalloutExtensionRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CalloutExtensionRecommendation proto.InternalMessageInfo

func (m *Recommendation_CalloutExtensionRecommendation) GetRecommendedExtensions() []*common.CalloutFeedItem {
	if m != nil {
		return m.RecommendedExtensions
	}
	return nil
}

// The Call extension recommendation.
type Recommendation_CallExtensionRecommendation struct {
	// Call extensions recommended to be added.
	RecommendedExtensions []*common.CallFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}               `json:"-"`
	XXX_unrecognized      []byte                 `json:"-"`
	XXX_sizecache         int32                  `json:"-"`
}

func (m *Recommendation_CallExtensionRecommendation) Reset() {
	*m = Recommendation_CallExtensionRecommendation{}
}
func (m *Recommendation_CallExtensionRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CallExtensionRecommendation) ProtoMessage() {}
func (*Recommendation_CallExtensionRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0f6630579339be78, []int{0, 15}
}

func (m *Recommendation_CallExtensionRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CallExtensionRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_CallExtensionRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CallExtensionRecommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation_CallExtensionRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CallExtensionRecommendation.Merge(m, src)
}
func (m *Recommendation_CallExtensionRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CallExtensionRecommendation.Size(m)
}
func (m *Recommendation_CallExtensionRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CallExtensionRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CallExtensionRecommendation proto.InternalMessageInfo

func (m *Recommendation_CallExtensionRecommendation) GetRecommendedExtensions() []*common.CallFeedItem {
	if m != nil {
		return m.RecommendedExtensions
	}
	return nil
}

func init() {
	proto.RegisterType((*Recommendation)(nil), "google.ads.googleads.v2.resources.Recommendation")
	proto.RegisterType((*Recommendation_RecommendationImpact)(nil), "google.ads.googleads.v2.resources.Recommendation.RecommendationImpact")
	proto.RegisterType((*Recommendation_RecommendationMetrics)(nil), "google.ads.googleads.v2.resources.Recommendation.RecommendationMetrics")
	proto.RegisterType((*Recommendation_CampaignBudgetRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.CampaignBudgetRecommendation")
	proto.RegisterType((*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption)(nil), "google.ads.googleads.v2.resources.Recommendation.CampaignBudgetRecommendation.CampaignBudgetRecommendationOption")
	proto.RegisterType((*Recommendation_KeywordRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.KeywordRecommendation")
	proto.RegisterType((*Recommendation_TargetCpaOptInRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.TargetCpaOptInRecommendation")
	proto.RegisterType((*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption)(nil), "google.ads.googleads.v2.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption")
	proto.RegisterType((*Recommendation_TextAdRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.TextAdRecommendation")
	proto.RegisterType((*Recommendation_SitelinkExtensionRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.SitelinkExtensionRecommendation")
	proto.RegisterType((*Recommendation_MoveUnusedBudgetRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.MoveUnusedBudgetRecommendation")
	proto.RegisterType((*Recommendation_MaximizeConversionsOptInRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.MaximizeConversionsOptInRecommendation")
	proto.RegisterType((*Recommendation_EnhancedCpcOptInRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.EnhancedCpcOptInRecommendation")
	proto.RegisterType((*Recommendation_KeywordMatchTypeRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.KeywordMatchTypeRecommendation")
	proto.RegisterType((*Recommendation_SearchPartnersOptInRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.SearchPartnersOptInRecommendation")
	proto.RegisterType((*Recommendation_MaximizeClicksOptInRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.MaximizeClicksOptInRecommendation")
	proto.RegisterType((*Recommendation_OptimizeAdRotationRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.OptimizeAdRotationRecommendation")
	proto.RegisterType((*Recommendation_CalloutExtensionRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.CalloutExtensionRecommendation")
	proto.RegisterType((*Recommendation_CallExtensionRecommendation)(nil), "google.ads.googleads.v2.resources.Recommendation.CallExtensionRecommendation")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/recommendation.proto", fileDescriptor_0f6630579339be78)
}

var fileDescriptor_0f6630579339be78 = []byte{
	// 1666 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x5b, 0x6f, 0xdc, 0xc4,
	0x17, 0xff, 0xcf, 0x26, 0x4d, 0xda, 0x93, 0x5b, 0x3b, 0x4d, 0xf2, 0x5f, 0xdc, 0x74, 0xbb, 0x49,
	0x95, 0x2a, 0x2a, 0xb0, 0x0b, 0x4b, 0x69, 0xab, 0xe5, 0x22, 0x6d, 0x2e, 0x4d, 0x03, 0x4a, 0x1b,
	0xdc, 0x12, 0x55, 0x28, 0xaa, 0x35, 0xb1, 0xa7, 0x5b, 0x93, 0xb5, 0xc7, 0xb5, 0x67, 0xd3, 0xa4,
	0x0f, 0xa8, 0x82, 0x17, 0x2e, 0x12, 0x2f, 0x48, 0xa8, 0x0f, 0x40, 0x25, 0x78, 0x40, 0xe2, 0x03,
	0xa0, 0x7e, 0x03, 0xa4, 0xbe, 0x56, 0xe2, 0x0b, 0xf0, 0xc6, 0x27, 0x40, 0x3c, 0x21, 0x8f, 0xc7,
	0x8e, 0xf7, 0x62, 0x7b, 0xb3, 0xb4, 0xbc, 0xd9, 0x9e, 0xf3, 0xfb, 0x9d, 0xdf, 0xcc, 0x9c, 0x33,
	0x73, 0x66, 0x0c, 0x17, 0xeb, 0x8c, 0xd5, 0x1b, 0xb4, 0x4c, 0x0c, 0xaf, 0x1c, 0x3c, 0xfa, 0x4f,
	0xbb, 0x95, 0xb2, 0x4b, 0x3d, 0xd6, 0x74, 0x75, 0xea, 0x95, 0x5d, 0xaa, 0x33, 0xcb, 0xa2, 0xb6,
	0x41, 0xb8, 0xc9, 0xec, 0x92, 0xe3, 0x32, 0xce, 0xf0, 0x6c, 0x60, 0x5c, 0x22, 0x86, 0x57, 0x8a,
	0x70, 0xa5, 0xdd, 0x4a, 0x29, 0xc2, 0x29, 0xaf, 0x26, 0x51, 0xfb, 0x74, 0xcc, 0x2e, 0xeb, 0xae,
	0xc9, 0xa9, 0x6b, 0x92, 0x80, 0x51, 0x29, 0x67, 0x98, 0xd3, 0x3d, 0x4e, 0x6d, 0xcf, 0x64, 0xb6,
	0x27, 0x01, 0x89, 0xd2, 0xa9, 0xdd, 0xb4, 0xbc, 0xf2, 0x0e, 0xdd, 0xbf, 0xcf, 0x5c, 0x43, 0xb3,
	0x08, 0xd7, 0xef, 0x6a, 0x7c, 0xdf, 0xa1, 0x12, 0x77, 0x29, 0x1d, 0xd7, 0xda, 0xdd, 0x38, 0x70,
	0x2d, 0x1d, 0xc8, 0x89, 0x5b, 0xa7, 0x5c, 0xd3, 0x1d, 0xa2, 0x31, 0x87, 0x6b, 0xa6, 0xad, 0xb5,
	0x51, 0xd5, 0x19, 0x69, 0x48, 0xaa, 0xf3, 0xd9, 0xc3, 0x4e, 0x0c, 0x69, 0x5b, 0x90, 0xb6, 0xe2,
	0x6d, 0xbb, 0x79, 0xa7, 0x7c, 0xdf, 0x25, 0x8e, 0x43, 0xdd, 0x70, 0x1c, 0x66, 0x42, 0x2e, 0xc7,
	0x2c, 0x13, 0xdb, 0x66, 0x5c, 0x78, 0x93, 0xad, 0x73, 0x8f, 0x5f, 0x87, 0x71, 0xb5, 0x45, 0x07,
	0x3e, 0x0b, 0x63, 0xa1, 0x1b, 0xcd, 0x26, 0x16, 0xcd, 0xa3, 0x22, 0x5a, 0x38, 0xa6, 0x8e, 0x86,
	0x1f, 0xaf, 0x11, 0x8b, 0xe2, 0x2d, 0x18, 0xf4, 0xbb, 0x9e, 0xcf, 0x15, 0xd1, 0xc2, 0x78, 0xe5,
	0x6a, 0x29, 0x69, 0xbe, 0x45, 0xdf, 0x4b, 0xad, 0x1e, 0x6e, 0xee, 0x3b, 0x74, 0xc5, 0x6e, 0x5a,
	0x5d, 0x3e, 0xab, 0x82, 0x15, 0xdf, 0x86, 0x21, 0xd3, 0x72, 0x88, 0xce, 0xf3, 0x03, 0x45, 0xb4,
	0x30, 0x52, 0xb9, 0x52, 0xca, 0x8c, 0xa7, 0x36, 0xb2, 0xb6, 0xd7, 0x35, 0xc1, 0xa6, 0x4a, 0x56,
	0xbc, 0x02, 0x13, 0x3a, 0xb1, 0x1c, 0x62, 0xd6, 0x6d, 0x6d, 0xbb, 0x69, 0xd4, 0x29, 0xcf, 0x1f,
	0x11, 0x8e, 0x66, 0x42, 0x47, 0xe1, 0x68, 0x96, 0x6e, 0x70, 0xd7, 0xb4, 0xeb, 0x9b, 0xa4, 0xd1,
	0xa4, 0xea, 0x78, 0x08, 0x5a, 0x14, 0x18, 0x7c, 0x19, 0x8e, 0x86, 0x5f, 0xf2, 0x43, 0x3d, 0xe0,
	0x23, 0x6b, 0x7c, 0x09, 0x8e, 0x12, 0x43, 0xab, 0xbb, 0xac, 0xe9, 0xe4, 0x87, 0x7b, 0x40, 0x0e,
	0x13, 0x63, 0xd5, 0x37, 0xc6, 0x97, 0xe1, 0x98, 0x61, 0x7a, 0x96, 0xe9, 0x79, 0xd4, 0xc8, 0x8f,
	0x09, 0xa4, 0xd2, 0x81, 0x5c, 0x64, 0xac, 0x11, 0xe0, 0x0e, 0x8c, 0xf1, 0xb7, 0x08, 0x0a, 0x6d,
	0x9d, 0x6e, 0x8b, 0xc0, 0xfc, 0xa0, 0xe0, 0xbb, 0x76, 0xf8, 0xc1, 0x5e, 0x6a, 0x19, 0x97, 0xd6,
	0xc6, 0xab, 0xff, 0x53, 0x67, 0xf4, 0x94, 0x76, 0xfc, 0x10, 0xc1, 0x74, 0x98, 0x8d, 0x6d, 0x82,
	0x8e, 0x0a, 0x41, 0xab, 0x87, 0x17, 0xf4, 0x7e, 0xc0, 0xd7, 0xa1, 0x64, 0x6a, 0xa7, 0x5b, 0x03,
	0xfe, 0x04, 0xa6, 0x39, 0xdd, 0xe3, 0x1a, 0xe9, 0x50, 0x70, 0xac, 0xdf, 0xf8, 0xbb, 0x49, 0xf7,
	0x78, 0xad, 0x53, 0xc0, 0x24, 0xef, 0xf2, 0x1d, 0x3f, 0x42, 0x50, 0xcc, 0x5a, 0x1f, 0xf2, 0xd0,
	0xef, 0xec, 0xdc, 0x14, 0xcc, 0x4b, 0x0e, 0xb9, 0xee, 0xf0, 0x35, 0xbb, 0x73, 0x76, 0x78, 0x4a,
	0x3b, 0xfe, 0x15, 0xc1, 0x79, 0x8b, 0xec, 0x99, 0x96, 0xf9, 0x80, 0x6a, 0x3a, 0xb3, 0x77, 0xa9,
	0x2b, 0x56, 0xd9, 0x04, 0x91, 0x23, 0x42, 0xe4, 0xad, 0xc3, 0x8b, 0x5c, 0x97, 0x3e, 0x96, 0x0e,
	0x5c, 0x74, 0x97, 0x7b, 0xce, 0xea, 0xc9, 0x12, 0xff, 0x80, 0x60, 0x8e, 0xda, 0x77, 0x89, 0xad,
	0x53, 0x43, 0xd3, 0x1d, 0x3d, 0x41, 0xf0, 0xa8, 0x10, 0xbc, 0x71, 0x78, 0xc1, 0x2b, 0x92, 0x7b,
	0xc9, 0xd1, 0xbb, 0x0b, 0x2d, 0xd0, 0x54, 0x0b, 0xfc, 0x33, 0x82, 0x79, 0x8f, 0x12, 0x57, 0xbf,
	0xab, 0x39, 0xc4, 0xe5, 0x36, 0x75, 0x93, 0x06, 0x75, 0x5c, 0x68, 0xbc, 0x71, 0x78, 0x8d, 0x37,
	0x04, 0xfd, 0x86, 0x64, 0xef, 0x2e, 0x73, 0xd6, 0xcb, 0x32, 0x12, 0x4a, 0x0f, 0x62, 0xa0, 0x61,
	0xea, 0x3b, 0x49, 0x4a, 0x27, 0xfa, 0x55, 0x1a, 0x4d, 0xbf, 0x60, 0x4f, 0x50, 0x6a, 0x65, 0x19,
	0xe1, 0x9f, 0x10, 0x9c, 0x65, 0x0e, 0x0f, 0x94, 0xfa, 0xd9, 0x2c, 0xb7, 0xbb, 0x76, 0x9d, 0xc7,
	0x85, 0x4e, 0xf5, 0xf0, 0x3a, 0xaf, 0x4b, 0xf2, 0x9a, 0xa1, 0x4a, 0xea, 0x0e, 0x99, 0x45, 0x96,
	0x61, 0x83, 0xbf, 0x43, 0x50, 0xd4, 0x49, 0xa3, 0xc1, 0x9a, 0x5c, 0x8b, 0xea, 0x96, 0x76, 0x89,
	0x27, 0xfa, 0x0d, 0xcc, 0xa5, 0x80, 0x79, 0x25, 0x24, 0xee, 0x0c, 0x4c, 0x3d, 0xd5, 0x02, 0x3f,
	0x46, 0x30, 0xeb, 0x99, 0x9c, 0x36, 0x4c, 0x7b, 0x27, 0x59, 0x1f, 0x16, 0xfa, 0x3e, 0xe8, 0x23,
	0x28, 0x25, 0x75, 0xb2, 0xc0, 0x33, 0x5e, 0xba, 0x09, 0xfe, 0x06, 0xc1, 0x69, 0xbf, 0x13, 0xc9,
	0xea, 0x4e, 0x0a, 0x75, 0xeb, 0xfd, 0x8d, 0x5e, 0xb2, 0xb2, 0x53, 0x7a, 0x72, 0x33, 0xfe, 0x1e,
	0xc1, 0x6c, 0x67, 0x59, 0xd9, 0xae, 0x6c, 0xb2, 0xdf, 0x79, 0x95, 0x7b, 0xda, 0xba, 0xcf, 0x2c,
	0x6a, 0xa5, 0x8e, 0x79, 0xdd, 0x49, 0xb5, 0x10, 0xfa, 0x2c, 0xb6, 0x4b, 0xb5, 0xa6, 0xdd, 0xf4,
	0xa8, 0x91, 0x50, 0x04, 0x4c, 0xf5, 0xab, 0x6f, 0x9d, 0xed, 0xd2, 0x0f, 0x05, 0x73, 0x42, 0x19,
	0x50, 0xb0, 0x52, 0x2d, 0x94, 0xbf, 0x10, 0x4c, 0x76, 0x2b, 0xdb, 0xf0, 0xc7, 0x30, 0xba, 0x4d,
	0x3c, 0xaa, 0x59, 0x94, 0xbb, 0xa6, 0xee, 0x89, 0x82, 0xb4, 0xaf, 0xb2, 0xa0, 0xf5, 0x75, 0x3d,
	0xa0, 0x53, 0x47, 0x7c, 0x72, 0xf9, 0x82, 0x39, 0x9c, 0x70, 0x18, 0xa7, 0x36, 0x37, 0x49, 0x23,
	0x72, 0x98, 0x7b, 0xbe, 0x0e, 0x8f, 0x47, 0x1e, 0xe4, 0x17, 0xe5, 0x69, 0x0e, 0xa6, 0xba, 0xda,
	0xe2, 0x77, 0x61, 0xc4, 0xb4, 0x1c, 0x97, 0x7a, 0x62, 0xa3, 0x93, 0x5d, 0xef, 0x2c, 0x16, 0x97,
	0x59, 0x73, 0xbb, 0x41, 0x83, 0xa2, 0x2f, 0x0e, 0xc0, 0x17, 0x60, 0x28, 0x58, 0xb1, 0x65, 0x27,
	0xd2, 0xa1, 0xd2, 0x16, 0xbf, 0x0d, 0x23, 0x3a, 0xf3, 0xb8, 0x66, 0x99, 0xba, 0xcb, 0x3c, 0x59,
	0x85, 0x9f, 0xea, 0x80, 0xae, 0xd9, 0xfc, 0xe2, 0x85, 0x00, 0x09, 0xbe, 0xfd, 0xba, 0x30, 0xf7,
	0x35, 0xc7, 0x2a, 0x05, 0x59, 0x56, 0x66, 0x68, 0x8e, 0x01, 0xf0, 0x3b, 0x30, 0xb2, 0x6b, 0x1a,
	0x94, 0x69, 0xbb, 0x26, 0xbd, 0xef, 0x25, 0x96, 0xe6, 0x71, 0x3c, 0x08, 0xc0, 0xa6, 0x6f, 0xaf,
	0x3c, 0x1b, 0x84, 0x99, 0xb4, 0x8a, 0x14, 0x6f, 0xc1, 0x8c, 0xde, 0x74, 0x5d, 0x6a, 0xf3, 0x30,
	0x07, 0x88, 0xc5, 0x9a, 0x76, 0xd4, 0x5d, 0x94, 0xdd, 0xdd, 0x97, 0x24, 0x41, 0xc0, 0x5f, 0x13,
	0x70, 0xd9, 0x7b, 0x03, 0x8a, 0x51, 0x4a, 0x1d, 0x64, 0x59, 0xab, 0x87, 0x5c, 0xb6, 0x87, 0xd3,
	0x31, 0x92, 0x2e, 0x5e, 0x1e, 0x21, 0x18, 0x97, 0xd4, 0xfe, 0x7e, 0xe3, 0x8f, 0xf3, 0x40, 0x71,
	0x60, 0x61, 0xa4, 0x72, 0xef, 0xf9, 0x96, 0xef, 0xa9, 0x8d, 0xd7, 0x85, 0x67, 0x75, 0x2c, 0x10,
	0x12, 0xbc, 0x79, 0xca, 0x33, 0x04, 0x73, 0xd9, 0x28, 0xbc, 0x0e, 0x93, 0xfd, 0x8e, 0x3e, 0xde,
	0xee, 0x1c, 0x90, 0x83, 0x33, 0x63, 0xee, 0x45, 0x9c, 0x19, 0x95, 0x27, 0x08, 0xa6, 0xba, 0x1e,
	0x2b, 0xf0, 0x0a, 0x0c, 0xcb, 0x95, 0x57, 0x6a, 0x7f, 0x39, 0xd1, 0x75, 0x70, 0x59, 0x11, 0x2e,
	0xe5, 0x6b, 0xf6, 0x1d, 0xa6, 0x86, 0x58, 0x7c, 0x0b, 0x94, 0x78, 0xdc, 0xf8, 0x25, 0xeb, 0xb6,
	0x69, 0x1c, 0x22, 0x62, 0xfe, 0x1f, 0x83, 0x2f, 0x39, 0xfa, 0xa2, 0x69, 0x04, 0x43, 0xa3, 0xfc,
	0x76, 0x04, 0x66, 0xd2, 0x0e, 0x01, 0xf8, 0x2b, 0x04, 0xc3, 0x61, 0x14, 0xa1, 0x7e, 0xa3, 0x28,
	0xcd, 0x43, 0x6a, 0xa3, 0x8c, 0xa2, 0x50, 0x01, 0xbe, 0x0d, 0xf1, 0xd8, 0xd7, 0x62, 0x07, 0xa3,
	0xde, 0xc7, 0x22, 0x3e, 0x94, 0x91, 0x6f, 0x39, 0x1c, 0x4f, 0x06, 0x60, 0x2e, 0x5b, 0x0f, 0xde,
	0x83, 0xc1, 0x3a, 0x23, 0x0d, 0x31, 0xa7, 0xe3, 0x15, 0x23, 0xe3, 0x8a, 0x23, 0x8d, 0x70, 0x95,
	0x91, 0x86, 0xb8, 0xf0, 0xc8, 0x32, 0x52, 0x85, 0x47, 0xbc, 0x0a, 0x27, 0xfa, 0xea, 0xf4, 0x04,
	0x6f, 0xed, 0x29, 0x66, 0x70, 0xce, 0xa5, 0xf7, 0x9a, 0xa6, 0xeb, 0xc7, 0x53, 0xdb, 0xd9, 0xbf,
	0x35, 0xe9, 0x7a, 0x58, 0xe1, 0xe7, 0x42, 0xaa, 0xd6, 0xdc, 0x4e, 0x48, 0xc2, 0xc1, 0x17, 0x92,
	0x84, 0xbf, 0x23, 0x98, 0xec, 0x76, 0xb2, 0xc6, 0x6f, 0x42, 0x8e, 0x84, 0xe9, 0x37, 0xdf, 0x83,
	0xd3, 0x9a, 0xa1, 0xe6, 0x88, 0x81, 0x6b, 0x30, 0xa6, 0xbb, 0x34, 0x38, 0x22, 0x18, 0x84, 0xd3,
	0xc4, 0x4d, 0x32, 0x7e, 0x19, 0x33, 0x1a, 0x42, 0x96, 0x09, 0xa7, 0x78, 0x19, 0x26, 0x48, 0x93,
	0x33, 0x8d, 0x38, 0x4e, 0x63, 0x3f, 0x20, 0x19, 0xe8, 0x81, 0x64, 0xcc, 0x07, 0xd5, 0x7c, 0x8c,
	0xcf, 0xa2, 0x7c, 0x89, 0xe0, 0x4c, 0x46, 0x61, 0x8c, 0xeb, 0x30, 0x1d, 0xcf, 0x8b, 0x83, 0x1b,
	0x4f, 0x99, 0xb3, 0xaf, 0x65, 0x2d, 0x3b, 0xa1, 0x83, 0x2b, 0x94, 0x1a, 0x6b, 0x9c, 0x5a, 0xea,
	0x54, 0x8c, 0x2f, 0xf2, 0xea, 0x29, 0x7f, 0x23, 0x28, 0xa4, 0x57, 0x73, 0x58, 0x85, 0x69, 0xba,
	0xa7, 0x53, 0xcf, 0x6b, 0x8f, 0xab, 0xc4, 0x0a, 0x25, 0xde, 0xf9, 0xc9, 0x00, 0xdb, 0x1a, 0x48,
	0xf8, 0x33, 0x04, 0x53, 0xdd, 0x6b, 0xd2, 0xdc, 0x8b, 0xb8, 0x98, 0x52, 0xe5, 0xf6, 0xd3, 0x56,
	0x85, 0x7e, 0x8d, 0xe0, 0x5c, 0x6f, 0x97, 0x11, 0x3d, 0xed, 0xf4, 0xe8, 0xdf, 0xee, 0xf4, 0x4a,
	0x11, 0x0a, 0xe9, 0x77, 0x0d, 0xca, 0x1f, 0x08, 0x0a, 0xe9, 0xa7, 0x83, 0xe7, 0xb5, 0x47, 0x3d,
	0x68, 0x0d, 0xc1, 0x83, 0x53, 0x8e, 0xbc, 0x08, 0x5e, 0xce, 0x58, 0x25, 0xdb, 0x55, 0x8a, 0x55,
	0xb1, 0x43, 0xfa, 0x64, 0xcc, 0x47, 0xf4, 0x55, 0x39, 0x0b, 0xb3, 0x99, 0xf7, 0x19, 0xca, 0x17,
	0x08, 0x66, 0x33, 0xef, 0x12, 0xfe, 0xa3, 0x89, 0x9b, 0x83, 0x62, 0xd6, 0x75, 0x81, 0xf2, 0x39,
	0x82, 0x42, 0xfa, 0x81, 0x1d, 0xdf, 0xc9, 0x48, 0xfb, 0x72, 0xd6, 0x4c, 0x4a, 0xfe, 0xac, 0xac,
	0xff, 0x14, 0xc1, 0xa9, 0x94, 0xd3, 0x2f, 0xd6, 0x33, 0x74, 0xbc, 0xd2, 0x8b, 0x8e, 0x0c, 0x11,
	0x8b, 0xc7, 0x61, 0xbc, 0x35, 0xf7, 0x17, 0x1f, 0xe6, 0x60, 0x5e, 0x67, 0x56, 0x76, 0xee, 0x2f,
	0x9e, 0x6c, 0x15, 0xbc, 0xe1, 0xcf, 0xd8, 0x06, 0xfa, 0xe8, 0x3d, 0x89, 0xac, 0xb3, 0x06, 0xb1,
	0xeb, 0x25, 0xe6, 0xd6, 0xcb, 0x75, 0x6a, 0x8b, 0xf9, 0x0c, 0x7f, 0xae, 0x38, 0xa6, 0x97, 0xf2,
	0xaf, 0xe5, 0xad, 0xe8, 0xe9, 0xc7, 0xdc, 0xc0, 0x6a, 0xad, 0xf6, 0x4b, 0x6e, 0x76, 0x35, 0xa0,
	0xac, 0x19, 0x5e, 0x29, 0x78, 0xf4, 0x9f, 0x36, 0x2b, 0x25, 0x35, 0xb4, 0x7c, 0x1a, 0xda, 0x6c,
	0xd5, 0x0c, 0x6f, 0x2b, 0xb2, 0xd9, 0xda, 0xac, 0x6c, 0x45, 0x36, 0x7f, 0xe6, 0xe6, 0x83, 0x86,
	0x6a, 0xb5, 0x66, 0x78, 0xd5, 0x6a, 0x64, 0x55, 0xad, 0x6e, 0x56, 0xaa, 0xd5, 0xc8, 0x6e, 0x7b,
	0x48, 0x88, 0x7d, 0xe3, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x7f, 0x81, 0x9c, 0x8e, 0x1b,
	0x00, 0x00,
}
