/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 2 "parse.yy" /* yacc.c:339  */

/* Parser for gpsim
   Copyright (C) 1999 Scott Dattalo

This file is part of gpsim.

gpsim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpsim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpsim; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <iostream>
#include <iomanip>
#include <string>
#include <list>
#include <vector>
#include <typeinfo>
#include <unistd.h>
#include <glib.h>
using namespace std;

#include "misc.h"
#include "command.h"

#include "cmd_attach.h"
#include "cmd_break.h"
#include "cmd_bus.h"
#include "cmd_clear.h"
#include "cmd_disasm.h"
#include "cmd_dump.h"
#include "cmd_frequency.h"
#include "cmd_help.h"
#include "cmd_list.h"
#include "cmd_load.h"
#include "cmd_log.h"
#include "cmd_node.h"
#include "cmd_macro.h"
#include "cmd_module.h"
#include "cmd_processor.h"
#include "cmd_quit.h"
#include "cmd_reset.h"
#include "cmd_run.h"
#include "cmd_set.h"
#include "cmd_step.h"
#include "cmd_shell.h"
#include "cmd_stimulus.h"
#include "cmd_symbol.h"
#include "cmd_trace.h"
#include "cmd_version.h"
#include "cmd_x.h"
#include "cmd_icd.h"
#include "../src/expr.h"
#include "../src/operator.h"

#include "../src/symbol.h"
#include "../src/stimuli.h"
#include "../src/processor.h"

extern void lexer_setMacroBodyMode();
extern void lexer_InvokeMacro(Macro *m);
extern void lexer_setDeclarationMode();

#define YYERROR_VERBOSE

extern char *yytext; 
int quit_parse=0;
int abort_gpsim=0;
int parser_warnings;
int parser_spanning_lines=0;
int gAbortParserOnSyntaxError=0;
extern int use_gui;
extern int quit_state;

extern command *getLastKnownCommand();
extern void init_cmd_state();
extern const char * GetLastFullCommand();
// From scan.ll
void FlushLexerBuffer();

void yyerror(const char *message)
{
  const char *last = GetLastFullCommand();
  if (last)
  {
     int n = strlen(last);
     char *pt = strdup(last);
     if (n > 0 && *(pt+n-1) == '\n')
	*(pt+n-1) = 0;
     printf("***ERROR: %s while parsing:\n\t'%s'\n",message, pt);
     free(pt);
  }
  else
      printf("***ERROR: %s \n",message);
  init_cmd_state();
  // JRH - I added this hoping that it is an appropriate
  //       place to clear the lexer buffer. An example of
  //       failed command where this is needed is to index
  //       into an undefined symbol. (i.e. undefinedsymbol[0])
  FlushLexerBuffer();
}


int toInt(Expression *expr)
{

  try {
    if(expr) {

      Value *v = expr->evaluate();
      if (v) {
	int i;
	v->get(i);
        delete v;
	return i;
      }
    }

  }

  catch (Error *err) {
    if(err)
      cout << "ERROR:" << err->toString() << endl;
    delete err;
  }

  return -1;
}


#line 207 "parse.cc" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSE_H_INCLUDED
# define YY_YY_PARSE_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    ABORT = 258,
    ATTACH = 259,
    BREAK = 260,
    BUS = 261,
    CLEAR = 262,
    DISASSEMBLE = 263,
    DUMP = 264,
    ENDM = 265,
    FREQUENCY = 266,
    HELP = 267,
    LOAD = 268,
    LOG = 269,
    LIST = 270,
    NODE = 271,
    MACRO = 272,
    MODULE = 273,
    PROCESSOR = 274,
    QUIT = 275,
    RESET = 276,
    RUN = 277,
    SET = 278,
    SHELL = 279,
    STEP = 280,
    STIMULUS = 281,
    SYMBOL = 282,
    TRACE = 283,
    gpsim_VERSION = 284,
    X = 285,
    ICD = 286,
    END_OF_COMMAND = 287,
    MACROBODY_T = 288,
    MACROINVOCATION_T = 289,
    INDIRECT = 290,
    END_OF_INPUT = 291,
    BIT_FLAG = 292,
    EXPRESSION_OPTION = 293,
    NUMERIC_OPTION = 294,
    STRING_OPTION = 295,
    CMD_SUBTYPE = 296,
    SYMBOL_OPTION = 297,
    LITERAL_INT_T = 298,
    LITERAL_BOOL_T = 299,
    LITERAL_FLOAT_T = 300,
    LITERAL_STRING_T = 301,
    LITERAL_ARRAY_T = 302,
    SYMBOL_T = 303,
    GPSIMOBJECT_T = 304,
    PORT_T = 305,
    EQU_T = 306,
    AND_T = 307,
    COLON_T = 308,
    COMMENT_T = 309,
    DIV_T = 310,
    EOLN_T = 311,
    MINUS_T = 312,
    MPY_T = 313,
    OR_T = 314,
    PLUS_T = 315,
    SHL_T = 316,
    SHR_T = 317,
    XOR_T = 318,
    INDEXERLEFT_T = 319,
    INDEXERRIGHT_T = 320,
    DECLARE_TYPE = 321,
    DECLARE_INT_T = 322,
    DECLARE_FLOAT_T = 323,
    DECLARE_BOOL_T = 324,
    DECLARE_CHAR_T = 325,
    LOR_T = 326,
    LAND_T = 327,
    EQ_T = 328,
    NE_T = 329,
    LT_T = 330,
    LE_T = 331,
    GT_T = 332,
    GE_T = 333,
    MIN_T = 334,
    MAX_T = 335,
    ABS_T = 336,
    IND_T = 337,
    BIT_T = 338,
    BITS_T = 339,
    LOW_T = 340,
    HIGH_T = 341,
    LADDR_T = 342,
    WORD_T = 343,
    INDEXED_T = 344,
    LNOT_T = 345,
    ONESCOMP_T = 346,
    UNARYOP_PREC = 347,
    POW_T = 348,
    REG_T = 349
  };
#endif
/* Tokens.  */
#define ABORT 258
#define ATTACH 259
#define BREAK 260
#define BUS 261
#define CLEAR 262
#define DISASSEMBLE 263
#define DUMP 264
#define ENDM 265
#define FREQUENCY 266
#define HELP 267
#define LOAD 268
#define LOG 269
#define LIST 270
#define NODE 271
#define MACRO 272
#define MODULE 273
#define PROCESSOR 274
#define QUIT 275
#define RESET 276
#define RUN 277
#define SET 278
#define SHELL 279
#define STEP 280
#define STIMULUS 281
#define SYMBOL 282
#define TRACE 283
#define gpsim_VERSION 284
#define X 285
#define ICD 286
#define END_OF_COMMAND 287
#define MACROBODY_T 288
#define MACROINVOCATION_T 289
#define INDIRECT 290
#define END_OF_INPUT 291
#define BIT_FLAG 292
#define EXPRESSION_OPTION 293
#define NUMERIC_OPTION 294
#define STRING_OPTION 295
#define CMD_SUBTYPE 296
#define SYMBOL_OPTION 297
#define LITERAL_INT_T 298
#define LITERAL_BOOL_T 299
#define LITERAL_FLOAT_T 300
#define LITERAL_STRING_T 301
#define LITERAL_ARRAY_T 302
#define SYMBOL_T 303
#define GPSIMOBJECT_T 304
#define PORT_T 305
#define EQU_T 306
#define AND_T 307
#define COLON_T 308
#define COMMENT_T 309
#define DIV_T 310
#define EOLN_T 311
#define MINUS_T 312
#define MPY_T 313
#define OR_T 314
#define PLUS_T 315
#define SHL_T 316
#define SHR_T 317
#define XOR_T 318
#define INDEXERLEFT_T 319
#define INDEXERRIGHT_T 320
#define DECLARE_TYPE 321
#define DECLARE_INT_T 322
#define DECLARE_FLOAT_T 323
#define DECLARE_BOOL_T 324
#define DECLARE_CHAR_T 325
#define LOR_T 326
#define LAND_T 327
#define EQ_T 328
#define NE_T 329
#define LT_T 330
#define LE_T 331
#define GT_T 332
#define GE_T 333
#define MIN_T 334
#define MAX_T 335
#define ABS_T 336
#define IND_T 337
#define BIT_T 338
#define BITS_T 339
#define LOW_T 340
#define HIGH_T 341
#define LADDR_T 342
#define WORD_T 343
#define INDEXED_T 344
#define LNOT_T 345
#define ONESCOMP_T 346
#define UNARYOP_PREC 347
#define POW_T 348
#define REG_T 349

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 148 "parse.yy" /* yacc.c:355  */

  guint32              i;
  guint64             li;
  float                f;
  char                *s;
  cmd_options        *co;
  cmd_options_num   *con;
  cmd_options_str   *cos;
  cmd_options_expr  *coe;

  BinaryOperator*           BinaryOperator_P;
  Boolean*                  Boolean_P;
  Expression*               Expression_P;
  Float*                    Float_P;
  Integer*                  Integer_P;
  String*                   String_P;
  gpsimObject*              Symbol_P;
  gpsimObject*              gpsimObject_P;

  StringList_t             *StringList_P;
  ExprList_t               *ExprList_P;
  gpsimObjectList_t        *gpsimObjectList_P;

  Macro                    *Macro_P;

#line 461 "parse.cc" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif



int yyparse (void);

#endif /* !YY_YY_PARSE_H_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 176 "parse.yy" /* yacc.c:358  */

/* Define the interface to the lexer */
extern int yylex(YYSTYPE* lvalP);

#line 481 "parse.cc" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  137
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   486

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  101
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  62
/* YYNRULES -- Number of rules.  */
#define YYNRULES  200
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  269

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   349

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      95,    96,     2,     2,    97,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,    98,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    99,     2,   100,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   321,   321,   325,   331,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   374,   391,   395,
     397,   401,   410,   417,   418,   419,   429,   430,   431,   436,
     437,   438,   442,   443,   446,   453,   457,   458,   462,   463,
     464,   470,   484,   492,   496,   511,   517,   524,   531,   541,
     542,   546,   547,   548,   552,   553,   556,   567,   578,   592,
     605,   619,   639,   640,   644,   645,   646,   651,   661,   665,
     669,   674,   682,   687,   696,   700,   704,   705,   706,   710,
     711,   722,   726,   729,   733,   737,   741,   751,   757,   763,
     769,   779,   780,   786,   787,   792,   793,   794,   795,   796,
     797,   800,   804,   805,   809,   810,   831,   832,   833,   839,
     841,   838,   846,   848,   853,   861,   863,   867,   868,   872,
     873,   894,   899,   893,   910,   911,   912,   913,   914,   938,
     944,   950,   953,   962,   970,   991,   992,   998,   999,  1000,
    1004,  1007,  1023,  1029,  1050,  1051,  1055,  1056,  1060,  1061,
    1062,  1063,  1064,  1065,  1066,  1067,  1068,  1069,  1070,  1071,
    1072,  1073,  1074,  1075,  1076,  1077,  1081,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1091,  1092,  1093,  1094,  1095,  1109,
    1110
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT", "ATTACH", "BREAK", "BUS",
  "CLEAR", "DISASSEMBLE", "DUMP", "ENDM", "FREQUENCY", "HELP", "LOAD",
  "LOG", "LIST", "NODE", "MACRO", "MODULE", "PROCESSOR", "QUIT", "RESET",
  "RUN", "SET", "SHELL", "STEP", "STIMULUS", "SYMBOL", "TRACE",
  "gpsim_VERSION", "X", "ICD", "END_OF_COMMAND", "MACROBODY_T",
  "MACROINVOCATION_T", "INDIRECT", "END_OF_INPUT", "BIT_FLAG",
  "EXPRESSION_OPTION", "NUMERIC_OPTION", "STRING_OPTION", "CMD_SUBTYPE",
  "SYMBOL_OPTION", "LITERAL_INT_T", "LITERAL_BOOL_T", "LITERAL_FLOAT_T",
  "LITERAL_STRING_T", "LITERAL_ARRAY_T", "SYMBOL_T", "GPSIMOBJECT_T",
  "PORT_T", "EQU_T", "AND_T", "COLON_T", "COMMENT_T", "DIV_T", "EOLN_T",
  "MINUS_T", "MPY_T", "OR_T", "PLUS_T", "SHL_T", "SHR_T", "XOR_T",
  "INDEXERLEFT_T", "INDEXERRIGHT_T", "DECLARE_TYPE", "DECLARE_INT_T",
  "DECLARE_FLOAT_T", "DECLARE_BOOL_T", "DECLARE_CHAR_T", "LOR_T", "LAND_T",
  "EQ_T", "NE_T", "LT_T", "LE_T", "GT_T", "GE_T", "MIN_T", "MAX_T",
  "ABS_T", "IND_T", "BIT_T", "BITS_T", "LOW_T", "HIGH_T", "LADDR_T",
  "WORD_T", "INDEXED_T", "LNOT_T", "ONESCOMP_T", "UNARYOP_PREC", "POW_T",
  "REG_T", "'('", "')'", "','", "'\\\\'", "'{'", "'}'", "$accept",
  "list_of_commands", "cmd", "rol", "opt_comment", "aborting",
  "attach_cmd", "break_cmd", "log_cmd", "break_set", "bus_cmd", "call_cmd",
  "clear_cmd", "disassemble_cmd", "dump_cmd", "eval_cmd", "frequency_cmd",
  "help_cmd", "list_cmd", "load_cmd", "node_cmd", "module_cmd",
  "processor_cmd", "quit_cmd", "reset_cmd", "run_cmd", "set_cmd",
  "step_cmd", "shell_cmd", "stimulus_cmd", "stimulus_opt", "symbol_cmd",
  "trace_cmd", "version_cmd", "x_cmd", "icd_cmd", "macro_cmd",
  "macrodef_directive", "$@1", "$@2", "opt_mdef_arglist", "mdef_body",
  "mdef_body_", "mdef_end", "declaration_cmd", "$@3", "$@4",
  "opt_declaration_type", "bit_flag", "cmd_subtype", "expression_option",
  "numeric_option", "string_option", "string_list", "expr", "array",
  "gpsimObject", "gpsimObject_list", "expr_list", "binary_expr",
  "unary_expr", "literal", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,    40,    41,    44,    92,   123,
     125
};
# endif

#define YYPACT_NINF -132

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-132)))

#define YYTABLE_NINF -5

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-5)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     173,  -132,  -132,   -40,   -10,    -7,   168,   168,    75,   168,
     -30,   -12,    75,    75,    -7,  -132,    73,    -9,   168,  -132,
    -132,    75,  -132,    36,    80,    72,   195,  -132,   168,    84,
    -132,  -132,   112,   -21,    39,   168,  -132,    41,    83,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,    60,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,   169,  -132,  -132,  -132,   168,  -132,   105,  -132,
    -132,  -132,  -132,  -132,    90,   235,   235,   235,   235,   235,
     235,    78,   168,   357,  -132,  -132,  -132,   357,   127,   357,
    -132,  -132,   137,   157,    92,   168,  -132,   105,   104,  -132,
      -7,   162,  -132,   357,   168,  -132,   357,  -132,  -132,   159,
    -132,   168,   168,  -132,  -132,  -132,  -132,   357,   357,  -132,
    -132,   168,   168,   168,   168,   244,   181,  -132,    83,  -132,
    -132,   174,  -132,   -14,  -132,  -132,   129,  -132,   169,   357,
     134,  -132,   168,  -132,  -132,  -132,  -132,  -132,  -132,   168,
     276,   168,   168,   168,   168,   168,   168,   168,   168,   168,
     168,   168,   168,   168,   168,   168,   168,   168,   168,   190,
    -132,  -132,  -132,   191,   134,  -132,  -132,   105,  -132,   357,
      56,   357,   357,   198,   357,    25,   126,   303,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,   168,  -132,  -132,  -132,
      63,  -132,   168,    26,   330,  -132,   408,   384,    71,   408,
      71,   408,   408,   400,   400,   408,   236,   199,   292,   292,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,   -19,   203,
    -132,   205,   211,    17,   164,   165,   357,  -132,  -132,   218,
    -132,   168,   168,  -132,  -132,  -132,  -132,  -132,   232,   357,
     357,  -132,    30,   233,  -132,   259,  -132,  -132,  -132
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,    37,    41,     0,    43,    52,     0,    56,    58,    69,
      71,     0,    46,    74,    82,   126,    84,    88,    92,    94,
      95,    96,   102,    99,   103,   111,   115,   121,   122,   124,
     128,    36,     0,    62,     0,     0,   141,     0,    39,     5,
       6,     7,    18,    45,     8,     9,    10,    12,    13,    14,
      15,    16,    17,    19,    20,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    21,
     127,    11,     0,   149,    44,    51,    50,   155,    53,   194,
     195,   197,   196,   200,   198,     0,     0,     0,     0,     0,
       0,     0,     0,    55,   157,   158,   186,    57,    59,    70,
      72,    73,    78,    79,     0,    47,    75,    83,     0,    85,
      86,    90,    89,    93,    97,   101,   100,   150,   104,   113,
     114,     0,     0,   119,   120,   117,   118,   116,   123,   125,
     129,     0,     0,     0,     0,     0,   144,     1,    39,    40,
       2,     0,   106,   105,   107,   163,     0,   164,    42,   166,
      49,   156,     0,   192,   188,   191,   187,   190,   189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    60,
      81,    80,    76,     0,    48,   153,   154,    87,    91,    98,
       0,   151,   152,   132,    64,     0,     0,     0,    63,   145,
     146,   147,   148,   142,     3,    38,     0,   108,   109,   110,
       0,   165,     0,     0,     0,   193,   172,   185,   171,   169,
     170,   173,   168,   175,   176,   174,   184,   183,   177,   178,
     179,   181,   180,   182,    61,    77,   112,   133,    39,    65,
      54,    67,     0,     0,     0,     0,   167,   199,   159,     0,
     130,     0,     0,   143,   160,   162,   161,   134,   135,    66,
      68,   137,     0,   136,   139,     0,   131,   138,   140
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -132,  -132,   247,  -131,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,    -2,  -132,
     207,  -132,   -24,    -1,    -6,  -132,   140,  -132,  -101,  -132,
     256,   101
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    37,    38,   140,   141,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
     143,    64,    65,    66,    67,    68,    69,    70,   193,   258,
     238,   262,   263,   266,    71,   136,   242,   203,    76,   118,
     124,   125,   110,    78,   149,   209,   147,   148,   150,    94,
      95,    96
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      93,    97,   126,    99,   184,   129,    98,   204,    72,   104,
     105,   106,   113,   107,   109,   112,   100,   116,   101,   114,
     127,   115,   128,    73,   123,    73,   108,    73,    73,   135,
     131,   195,   196,    74,   102,   139,   103,   111,    75,    77,
     264,   137,     1,   132,     2,     3,     4,     5,     6,     7,
       8,   213,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    73,   133,    30,   265,    31,   249,    79,
      80,    81,    82,    83,    84,   206,   160,    32,    85,    33,
     239,   247,   142,    86,    87,    -4,    88,    -4,   121,    79,
      80,    81,    82,    83,    84,   243,   244,   250,   189,   187,
      73,   245,    73,   108,   212,   191,   192,   254,   119,   208,
     120,   117,   212,   212,   108,   194,    89,    90,   197,   130,
      91,    92,   168,   169,   134,    34,    35,   139,   182,    36,
     183,   207,   171,   172,   173,   174,   175,   176,   177,   178,
     185,   151,   186,   214,   152,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   159,     1,   179,     2,     3,     4,     5,
       6,     7,     8,   180,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,   181,   246,    30,   188,    31,
     190,    79,    80,    81,    82,    83,    84,   145,   146,    32,
      85,    33,   240,   212,   210,    86,    87,    -4,    88,    -4,
     205,   212,    73,   121,   122,   108,   234,   235,    79,    80,
      81,    82,    83,    84,   237,   259,   260,    85,   199,   200,
     201,   202,    86,    87,   251,    88,   252,   253,    89,    90,
     255,   256,    91,    92,   257,   261,   267,    34,    35,   268,
     144,    36,   173,   174,   175,   176,   177,   178,    79,    80,
      81,    82,    83,    84,   138,    89,    90,    85,   211,    91,
      92,   236,    86,    87,     0,    88,   161,   162,     0,   163,
       0,   164,   165,   166,   167,   168,   169,   170,   172,   173,
     174,   175,   176,   177,   178,   171,   172,   173,   174,   175,
     176,   177,   178,     0,     0,    89,    90,     0,   161,   162,
      92,   163,     0,   164,   165,   166,   167,   168,   169,   170,
     198,   153,   154,   155,   156,   157,   158,   171,   172,   173,
     174,   175,   176,   177,   178,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,   169,   170,   175,   176,   177,
     178,     0,   215,     0,   171,   172,   173,   174,   175,   176,
     177,   178,   161,   162,     0,   163,     0,   164,   165,   166,
     167,   168,   169,   170,     0,     0,     0,     0,     0,   241,
       0,   171,   172,   173,   174,   175,   176,   177,   178,   161,
     162,     0,   163,     0,   164,   165,   166,   167,   168,   169,
     170,     0,     0,     0,     0,     0,   248,     0,   171,   172,
     173,   174,   175,   176,   177,   178,   161,    -5,     0,   163,
       0,   164,   165,   166,   167,   168,   169,   170,     0,     0,
       0,     0,     0,     0,     0,   171,   172,   173,   174,   175,
     176,   177,   178,   163,     0,     0,   165,     0,     0,   168,
     169,   171,   172,   173,   174,   175,   176,   177,   178,   171,
     172,   173,   174,   175,   176,   177,   178
};

static const yytype_int16 yycheck[] =
{
       6,     7,    26,     9,   105,    29,     8,   138,    48,    11,
      12,    13,    18,    14,    16,    17,    46,    23,    48,    21,
      26,    23,    28,    37,    26,    37,    40,    37,    37,    35,
      51,   132,   133,    43,    46,    54,    48,    46,    48,    46,
      10,     0,     1,    64,     3,     4,     5,     6,     7,     8,
       9,   152,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    37,    95,    34,    46,    36,    97,    43,
      44,    45,    46,    47,    48,    99,    92,    46,    52,    48,
      65,    65,    32,    57,    58,    54,    60,    56,    38,    43,
      44,    45,    46,    47,    48,   206,    43,   238,   114,   110,
      37,    48,    37,    40,    97,   121,   122,   100,    46,   143,
      48,    41,    97,    97,    40,   131,    90,    91,   134,    17,
      94,    95,    61,    62,    95,    94,    95,    54,    46,    98,
      48,   143,    71,    72,    73,    74,    75,    76,    77,    78,
      46,    46,    48,   159,    64,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,    95,     1,    48,     3,     4,     5,     6,
       7,     8,     9,    46,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    48,   212,    34,    46,    36,
      51,    43,    44,    45,    46,    47,    48,    48,    49,    46,
      52,    48,    96,    97,    95,    57,    58,    54,    60,    56,
      56,    97,    37,    38,    39,    40,    46,    46,    43,    44,
      45,    46,    47,    48,    46,   251,   252,    52,    67,    68,
      69,    70,    57,    58,    51,    60,    51,    46,    90,    91,
      96,    96,    94,    95,    46,    33,    33,    94,    95,    10,
      63,    98,    73,    74,    75,    76,    77,    78,    43,    44,
      45,    46,    47,    48,    37,    90,    91,    52,   148,    94,
      95,   190,    57,    58,    -1,    60,    52,    53,    -1,    55,
      -1,    57,    58,    59,    60,    61,    62,    63,    72,    73,
      74,    75,    76,    77,    78,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    -1,    90,    91,    -1,    52,    53,
      95,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      96,    85,    86,    87,    88,    89,    90,    71,    72,    73,
      74,    75,    76,    77,    78,    52,    53,    -1,    55,    -1,
      57,    58,    59,    60,    61,    62,    63,    75,    76,    77,
      78,    -1,    96,    -1,    71,    72,    73,    74,    75,    76,
      77,    78,    52,    53,    -1,    55,    -1,    57,    58,    59,
      60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,    96,
      -1,    71,    72,    73,    74,    75,    76,    77,    78,    52,
      53,    -1,    55,    -1,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    96,    -1,    71,    72,
      73,    74,    75,    76,    77,    78,    52,    53,    -1,    55,
      -1,    57,    58,    59,    60,    61,    62,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    72,    73,    74,    75,
      76,    77,    78,    55,    -1,    -1,    58,    -1,    -1,    61,
      62,    71,    72,    73,    74,    75,    76,    77,    78,    71,
      72,    73,    74,    75,    76,    77,    78
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     4,     5,     6,     7,     8,     9,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      34,    36,    46,    48,    94,    95,    98,   102,   103,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   132,   133,   134,   135,   136,   137,
     138,   145,    48,    37,    43,    48,   149,    46,   154,    43,
      44,    45,    46,    47,    48,    52,    57,    58,    60,    90,
      91,    94,    95,   155,   160,   161,   162,   155,   149,   155,
      46,    48,    46,    48,   149,   149,   149,   154,    40,   149,
     153,    46,   149,   155,   149,   149,   155,    41,   150,    46,
      48,    38,    39,   149,   151,   152,   153,   155,   155,   153,
      17,    51,    64,    95,    95,   155,   146,     0,   103,    54,
     104,   105,    32,   131,   151,    48,    49,   157,   158,   155,
     159,    46,    64,   161,   161,   161,   161,   161,   161,    95,
     155,    52,    53,    55,    57,    58,    59,    60,    61,    62,
      63,    71,    72,    73,    74,    75,    76,    77,    78,    48,
      46,    48,    46,    48,   159,    46,    48,   154,    46,   155,
      51,   155,   155,   139,   155,   159,   159,   155,    96,    67,
      68,    69,    70,   148,   104,    56,    99,   149,   153,   156,
      95,   157,    97,   159,   155,    96,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,    46,    46,   162,    46,   141,    65,
      96,    96,   147,   159,    43,    48,   155,    65,    96,    97,
     104,    51,    51,    46,   100,    96,    96,    46,   140,   155,
     155,    33,   142,   143,    10,    46,   144,    33,    10
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   101,   102,   102,   103,   103,   103,   103,   103,   103,
     103,   103,   103,   103,   103,   103,   103,   103,   103,   103,
     103,   103,   103,   103,   103,   103,   103,   103,   103,   103,
     103,   103,   103,   103,   103,   103,   103,   103,   104,   105,
     105,   106,   107,   108,   108,   108,   109,   109,   109,   110,
     110,   110,   111,   111,   112,   113,   114,   114,   115,   115,
     115,   115,   116,   116,   116,   116,   116,   116,   116,   117,
     117,   118,   118,   118,   119,   119,   120,   120,   120,   120,
     120,   120,   121,   121,   122,   122,   122,   122,   123,   123,
     123,   123,   124,   124,   125,   126,   127,   127,   127,   128,
     128,   128,   129,   130,   130,   130,   130,   131,   131,   131,
     131,   132,   132,   132,   132,   133,   133,   133,   133,   133,
     133,   134,   135,   135,   136,   136,   137,   137,   137,   139,
     140,   138,   141,   141,   141,   142,   142,   143,   143,   144,
     144,   146,   147,   145,   148,   148,   148,   148,   148,   149,
     150,   151,   152,   153,   153,   154,   154,   155,   155,   155,
     156,   157,   157,   157,   158,   158,   159,   159,   160,   160,
     160,   160,   160,   160,   160,   160,   160,   160,   160,   160,
     160,   160,   160,   160,   160,   160,   161,   161,   161,   161,
     161,   161,   161,   161,   162,   162,   162,   162,   162,   162,
     162
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     2,     3,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     3,     1,     2,     1,     1,     2,     3,     3,
       2,     2,     1,     2,     4,     2,     1,     2,     1,     2,
       3,     4,     1,     3,     3,     4,     6,     4,     6,     1,
       2,     1,     2,     2,     1,     2,     3,     4,     2,     2,
       3,     3,     1,     2,     1,     2,     2,     3,     1,     2,
       2,     3,     1,     2,     1,     1,     1,     2,     3,     1,
       2,     2,     1,     1,     2,     2,     2,     1,     2,     2,
       2,     1,     4,     2,     2,     1,     2,     2,     2,     2,
       2,     1,     1,     2,     1,     2,     1,     1,     1,     0,
       0,     8,     0,     1,     3,     0,     1,     1,     2,     1,
       2,     0,     0,     5,     0,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     1,     2,     1,     1,     4,
       3,     4,     4,     1,     1,     2,     1,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     1,     2,     2,     2,
       2,     2,     2,     3,     1,     1,     1,     1,     1,     4,
       1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 321 "parse.yy" /* yacc.c:1646  */
    { 
        init_cmd_state();

      }
#line 1846 "parse.cc" /* yacc.c:1646  */
    break;

  case 3:
#line 326 "parse.yy" /* yacc.c:1646  */
    { 
        init_cmd_state();
      }
#line 1854 "parse.cc" /* yacc.c:1646  */
    break;

  case 36:
#line 365 "parse.yy" /* yacc.c:1646  */
    {
       //if(verbose&2)
         cout << "got an END_OF_INPUT\n";
        /* If we're processing a command file then quit parsing 
         * when we run out of input */
	 //if(Gcmd_file_ref_count)
       	 //quit_parse = 1;
       YYABORT;
     }
#line 1868 "parse.cc" /* yacc.c:1646  */
    break;

  case 37:
#line 374 "parse.yy" /* yacc.c:1646  */
    {

       init_cmd_state();
       yyclearin;
       // FIXME
       // In some cases we may wish to abort parsing while in others not.
       if (gAbortParserOnSyntaxError) {
         YYABORT;
       }
     }
#line 1883 "parse.cc" /* yacc.c:1646  */
    break;

  case 41:
#line 402 "parse.yy" /* yacc.c:1646  */
    {
       	  abort_gpsim = 1;
          quit_parse = 1;
          YYABORT;
          }
#line 1893 "parse.cc" /* yacc.c:1646  */
    break;

  case 42:
#line 411 "parse.yy" /* yacc.c:1646  */
    {
            attach.attach((yyvsp[-1].Symbol_P),(yyvsp[0].gpsimObjectList_P));
          }
#line 1901 "parse.cc" /* yacc.c:1646  */
    break;

  case 43:
#line 417 "parse.yy" /* yacc.c:1646  */
    {c_break.list();}
#line 1907 "parse.cc" /* yacc.c:1646  */
    break;

  case 44:
#line 418 "parse.yy" /* yacc.c:1646  */
    {c_break.list((yyvsp[0].Integer_P)->getVal());delete (yyvsp[0].Integer_P);}
#line 1913 "parse.cc" /* yacc.c:1646  */
    break;

  case 45:
#line 419 "parse.yy" /* yacc.c:1646  */
    {  
					  int n = (yyvsp[0].i);
					  if (n < 0)
					  {
					     yyerror("Breakpoint not set");
					  }
				       }
#line 1925 "parse.cc" /* yacc.c:1646  */
    break;

  case 46:
#line 429 "parse.yy" /* yacc.c:1646  */
    {c_log.log();}
#line 1931 "parse.cc" /* yacc.c:1646  */
    break;

  case 47:
#line 430 "parse.yy" /* yacc.c:1646  */
    {c_log.log((yyvsp[0].co));}
#line 1937 "parse.cc" /* yacc.c:1646  */
    break;

  case 48:
#line 431 "parse.yy" /* yacc.c:1646  */
    {c_log.log((yyvsp[-1].co),(yyvsp[0].ExprList_P));}
#line 1943 "parse.cc" /* yacc.c:1646  */
    break;

  case 49:
#line 436 "parse.yy" /* yacc.c:1646  */
    { (yyval.i)=c_break.set_break((yyvsp[-1].co),(yyvsp[0].ExprList_P));}
#line 1949 "parse.cc" /* yacc.c:1646  */
    break;

  case 50:
#line 437 "parse.yy" /* yacc.c:1646  */
    {(yyval.i)=c_break.set_break((yyvsp[0].co));}
#line 1955 "parse.cc" /* yacc.c:1646  */
    break;

  case 51:
#line 438 "parse.yy" /* yacc.c:1646  */
    {(yyval.i)=c_break.set_break((yyvsp[0].Symbol_P));}
#line 1961 "parse.cc" /* yacc.c:1646  */
    break;

  case 52:
#line 442 "parse.yy" /* yacc.c:1646  */
    {c_bus.list_busses();}
#line 1967 "parse.cc" /* yacc.c:1646  */
    break;

  case 53:
#line 443 "parse.yy" /* yacc.c:1646  */
    {c_bus.add_busses((yyvsp[0].StringList_P)); delete (yyvsp[0].StringList_P);}
#line 1973 "parse.cc" /* yacc.c:1646  */
    break;

  case 54:
#line 447 "parse.yy" /* yacc.c:1646  */
    {
          cout << " call\n"; 
          //$$ = $3;
        }
#line 1982 "parse.cc" /* yacc.c:1646  */
    break;

  case 55:
#line 453 "parse.yy" /* yacc.c:1646  */
    {clear.clear((yyvsp[0].Expression_P));}
#line 1988 "parse.cc" /* yacc.c:1646  */
    break;

  case 56:
#line 457 "parse.yy" /* yacc.c:1646  */
    {disassemble.disassemble(0);}
#line 1994 "parse.cc" /* yacc.c:1646  */
    break;

  case 57:
#line 458 "parse.yy" /* yacc.c:1646  */
    {disassemble.disassemble((yyvsp[0].Expression_P));}
#line 2000 "parse.cc" /* yacc.c:1646  */
    break;

  case 58:
#line 462 "parse.yy" /* yacc.c:1646  */
    {dump.dump(2);}
#line 2006 "parse.cc" /* yacc.c:1646  */
    break;

  case 59:
#line 463 "parse.yy" /* yacc.c:1646  */
    {dump.dump((yyvsp[0].co)->value);}
#line 2012 "parse.cc" /* yacc.c:1646  */
    break;

  case 60:
#line 466 "parse.yy" /* yacc.c:1646  */
    {
            //                   key,  module_name
            quit_parse = dump.dump((yyvsp[-1].co)->value, (yyvsp[0].Symbol_P), NULL) == 0;
          }
#line 2021 "parse.cc" /* yacc.c:1646  */
    break;

  case 61:
#line 472 "parse.yy" /* yacc.c:1646  */
    {
            //                   key,  module_name, filename
            //quit_parse = dump.dump($2->value, $3, $4->getVal()) == 0;
            if (dump.dump((yyvsp[-2].co)->value, (yyvsp[-1].Symbol_P), (yyvsp[0].String_P)->getVal()) == 0) 
              cout << "dump to file failed\n";
            delete (yyvsp[0].String_P);

          }
#line 2034 "parse.cc" /* yacc.c:1646  */
    break;

  case 62:
#line 484 "parse.yy" /* yacc.c:1646  */
    {c_symbol.dump_one((yyvsp[0].Symbol_P));}
#line 2040 "parse.cc" /* yacc.c:1646  */
    break;

  case 63:
#line 492 "parse.yy" /* yacc.c:1646  */
    {
                                          c_symbol.EvaluateAndDisplay((yyvsp[-1].Expression_P));
                                          delete (yyvsp[-1].Expression_P);
                                        }
#line 2049 "parse.cc" /* yacc.c:1646  */
    break;

  case 64:
#line 496 "parse.yy" /* yacc.c:1646  */
    {

            Value *pValue = dynamic_cast<Value *>((yyvsp[-2].Symbol_P));
            if (pValue) {
              try {
                pValue->set((yyvsp[0].Expression_P));
              }
              catch(Error Message)  {
                GetUserInterface().DisplayMessage("%s (maybe missing quotes?)\n", Message.toString().c_str());
              }
              pValue->update();
            }
            delete (yyvsp[0].Expression_P);
          }
#line 2068 "parse.cc" /* yacc.c:1646  */
    break;

  case 65:
#line 512 "parse.yy" /* yacc.c:1646  */
    {
                                          c_symbol.dump((yyvsp[-3].Symbol_P),(yyvsp[-1].ExprList_P));
                                          (yyvsp[-1].ExprList_P)->clear();
                                          delete (yyvsp[-1].ExprList_P);
                                        }
#line 2078 "parse.cc" /* yacc.c:1646  */
    break;

  case 66:
#line 518 "parse.yy" /* yacc.c:1646  */
    {
                                          c_symbol.Set((yyvsp[-5].Symbol_P), (yyvsp[-3].ExprList_P), (yyvsp[0].Expression_P));
                                          (yyvsp[-3].ExprList_P)->clear();
                                          delete (yyvsp[-3].ExprList_P);
                                          delete (yyvsp[0].Expression_P);
                                        }
#line 2089 "parse.cc" /* yacc.c:1646  */
    break;

  case 67:
#line 525 "parse.yy" /* yacc.c:1646  */
    {
					  int i=toInt((yyvsp[-1].Expression_P));
					  if (i>=0)
					    c_x.x(toInt((yyvsp[-1].Expression_P)));
                                          delete (yyvsp[-1].Expression_P);
                                        }
#line 2100 "parse.cc" /* yacc.c:1646  */
    break;

  case 68:
#line 532 "parse.yy" /* yacc.c:1646  */
    {
					  int i=toInt((yyvsp[-3].Expression_P));
					  if (i>=0)
					    c_x.x(toInt((yyvsp[-3].Expression_P)), (yyvsp[0].Expression_P));
                                          delete (yyvsp[-3].Expression_P);
                                        }
#line 2111 "parse.cc" /* yacc.c:1646  */
    break;

  case 69:
#line 541 "parse.yy" /* yacc.c:1646  */
    {frequency.print();}
#line 2117 "parse.cc" /* yacc.c:1646  */
    break;

  case 70:
#line 542 "parse.yy" /* yacc.c:1646  */
    {frequency.set((yyvsp[0].Expression_P));}
#line 2123 "parse.cc" /* yacc.c:1646  */
    break;

  case 71:
#line 546 "parse.yy" /* yacc.c:1646  */
    {help.help(); }
#line 2129 "parse.cc" /* yacc.c:1646  */
    break;

  case 72:
#line 547 "parse.yy" /* yacc.c:1646  */
    {help.help((yyvsp[0].String_P)->getVal()); delete (yyvsp[0].String_P);}
#line 2135 "parse.cc" /* yacc.c:1646  */
    break;

  case 73:
#line 548 "parse.yy" /* yacc.c:1646  */
    {help.help((yyvsp[0].Symbol_P));}
#line 2141 "parse.cc" /* yacc.c:1646  */
    break;

  case 74:
#line 552 "parse.yy" /* yacc.c:1646  */
    {c_list.list();}
#line 2147 "parse.cc" /* yacc.c:1646  */
    break;

  case 75:
#line 553 "parse.yy" /* yacc.c:1646  */
    {c_list.list((yyvsp[0].co));}
#line 2153 "parse.cc" /* yacc.c:1646  */
    break;

  case 76:
#line 557 "parse.yy" /* yacc.c:1646  */
    {
            quit_parse = c_load.load((yyvsp[-1].co)->value,(yyvsp[0].String_P)->getVal()) == 0;
            delete (yyvsp[0].String_P);

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }
          }
#line 2168 "parse.cc" /* yacc.c:1646  */
    break;

  case 77:
#line 568 "parse.yy" /* yacc.c:1646  */
    {
            quit_parse = c_load.load((yyvsp[-2].co)->value, (yyvsp[-1].Symbol_P), (yyvsp[0].String_P)->getVal()) == 0;
            delete (yyvsp[0].String_P);

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }
	  }
#line 2183 "parse.cc" /* yacc.c:1646  */
    break;

  case 78:
#line 580 "parse.yy" /* yacc.c:1646  */
    {
            quit_parse = c_load.load((yyvsp[0].String_P)->getVal(), (const char *)NULL) == 0;
            delete (yyvsp[0].String_P);
            quit_parse =0;

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }

          }
#line 2200 "parse.cc" /* yacc.c:1646  */
    break;

  case 79:
#line 594 "parse.yy" /* yacc.c:1646  */
    {
            quit_parse = c_load.load((yyvsp[0].Symbol_P)) == 0;
            quit_parse =0;

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }

          }
#line 2216 "parse.cc" /* yacc.c:1646  */
    break;

  case 80:
#line 607 "parse.yy" /* yacc.c:1646  */
    {
            //                        filename,   processor
            quit_parse = c_load.load((yyvsp[0].Symbol_P), (yyvsp[-1].Symbol_P)) == 0;
            delete (yyvsp[-1].Symbol_P);
            delete (yyvsp[0].Symbol_P);

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }
          }
#line 2233 "parse.cc" /* yacc.c:1646  */
    break;

  case 81:
#line 623 "parse.yy" /* yacc.c:1646  */
    {
            //                        filename,   processor
            quit_parse = c_load.load((yyvsp[0].String_P), (yyvsp[-1].String_P)) == 0;
            delete (yyvsp[-1].String_P);
            delete (yyvsp[0].String_P);

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }
          }
#line 2250 "parse.cc" /* yacc.c:1646  */
    break;

  case 82:
#line 639 "parse.yy" /* yacc.c:1646  */
    {c_node.list_nodes();}
#line 2256 "parse.cc" /* yacc.c:1646  */
    break;

  case 83:
#line 640 "parse.yy" /* yacc.c:1646  */
    {c_node.add_nodes((yyvsp[0].StringList_P));  delete (yyvsp[0].StringList_P);}
#line 2262 "parse.cc" /* yacc.c:1646  */
    break;

  case 84:
#line 644 "parse.yy" /* yacc.c:1646  */
    {c_module.module();}
#line 2268 "parse.cc" /* yacc.c:1646  */
    break;

  case 85:
#line 645 "parse.yy" /* yacc.c:1646  */
    {c_module.module((yyvsp[0].co));}
#line 2274 "parse.cc" /* yacc.c:1646  */
    break;

  case 86:
#line 647 "parse.yy" /* yacc.c:1646  */
    { 
            c_module.module((yyvsp[0].cos),(list <string> *)0);
            delete (yyvsp[0].cos);
          }
#line 2283 "parse.cc" /* yacc.c:1646  */
    break;

  case 87:
#line 652 "parse.yy" /* yacc.c:1646  */
    {
	    if ((yyvsp[-1].cos) != NULL && (yyvsp[0].StringList_P) != NULL)
                c_module.module((yyvsp[-1].cos), (yyvsp[0].StringList_P)); 
            if ((yyvsp[-1].cos) != NULL) delete (yyvsp[-1].cos); 
            if ((yyvsp[0].StringList_P) != NULL) delete (yyvsp[0].StringList_P);
          }
#line 2294 "parse.cc" /* yacc.c:1646  */
    break;

  case 88:
#line 662 "parse.yy" /* yacc.c:1646  */
    {
            c_processor.processor();
          }
#line 2302 "parse.cc" /* yacc.c:1646  */
    break;

  case 89:
#line 666 "parse.yy" /* yacc.c:1646  */
    {
            c_processor.processor((yyvsp[0].co)->value);
          }
#line 2310 "parse.cc" /* yacc.c:1646  */
    break;

  case 90:
#line 670 "parse.yy" /* yacc.c:1646  */
    {
            c_processor.processor((yyvsp[0].String_P)->getVal(),0);
            delete (yyvsp[0].String_P);
          }
#line 2319 "parse.cc" /* yacc.c:1646  */
    break;

  case 91:
#line 675 "parse.yy" /* yacc.c:1646  */
    { 
            c_processor.processor((yyvsp[-1].String_P)->getVal(),(yyvsp[0].String_P)->getVal());
            delete (yyvsp[-1].String_P);
            delete (yyvsp[0].String_P);
          }
#line 2329 "parse.cc" /* yacc.c:1646  */
    break;

  case 92:
#line 683 "parse.yy" /* yacc.c:1646  */
    { 
            quit_parse = 1;
	    YYABORT;
          }
#line 2338 "parse.cc" /* yacc.c:1646  */
    break;

  case 93:
#line 688 "parse.yy" /* yacc.c:1646  */
    {
            quit_parse = 1;
	    //quit_state = $2;  // FIXME need to evaluate expr
	    YYABORT;
	  }
#line 2348 "parse.cc" /* yacc.c:1646  */
    break;

  case 94:
#line 696 "parse.yy" /* yacc.c:1646  */
    { reset.reset(); }
#line 2354 "parse.cc" /* yacc.c:1646  */
    break;

  case 95:
#line 700 "parse.yy" /* yacc.c:1646  */
    { c_run.run();}
#line 2360 "parse.cc" /* yacc.c:1646  */
    break;

  case 96:
#line 704 "parse.yy" /* yacc.c:1646  */
    {c_set.set();}
#line 2366 "parse.cc" /* yacc.c:1646  */
    break;

  case 97:
#line 705 "parse.yy" /* yacc.c:1646  */
    {c_set.set((yyvsp[0].co)->value,0);}
#line 2372 "parse.cc" /* yacc.c:1646  */
    break;

  case 98:
#line 706 "parse.yy" /* yacc.c:1646  */
    {c_set.set((yyvsp[-1].co)->value,(yyvsp[0].Expression_P));}
#line 2378 "parse.cc" /* yacc.c:1646  */
    break;

  case 99:
#line 710 "parse.yy" /* yacc.c:1646  */
    {step.step(1);}
#line 2384 "parse.cc" /* yacc.c:1646  */
    break;

  case 100:
#line 711 "parse.yy" /* yacc.c:1646  */
    {
					    if ((yyvsp[0].Expression_P))
					    {
					    int i=toInt((yyvsp[0].Expression_P));
					    delete (yyvsp[0].Expression_P); 
				            if (i >=1)
						step.step(i);
					    else
						yyerror("Invalid value");
					    }
					}
#line 2400 "parse.cc" /* yacc.c:1646  */
    break;

  case 101:
#line 722 "parse.yy" /* yacc.c:1646  */
    {step.over();}
#line 2406 "parse.cc" /* yacc.c:1646  */
    break;

  case 102:
#line 726 "parse.yy" /* yacc.c:1646  */
    {c_shell.shell((yyvsp[0].String_P)); delete (yyvsp[0].String_P);}
#line 2412 "parse.cc" /* yacc.c:1646  */
    break;

  case 103:
#line 730 "parse.yy" /* yacc.c:1646  */
    {
          c_stimulus.stimulus();
          }
#line 2420 "parse.cc" /* yacc.c:1646  */
    break;

  case 104:
#line 734 "parse.yy" /* yacc.c:1646  */
    {
          c_stimulus.stimulus((yyvsp[0].co)->value);
          }
#line 2428 "parse.cc" /* yacc.c:1646  */
    break;

  case 105:
#line 738 "parse.yy" /* yacc.c:1646  */
    {
          /* do nothing */
          }
#line 2436 "parse.cc" /* yacc.c:1646  */
    break;

  case 106:
#line 742 "parse.yy" /* yacc.c:1646  */
    { 
            if(verbose)
              cout << " end of stimulus command\n";
            c_stimulus.end();
          }
#line 2446 "parse.cc" /* yacc.c:1646  */
    break;

  case 107:
#line 752 "parse.yy" /* yacc.c:1646  */
    {
            if(verbose)
              cout << "parser sees stimulus with numeric option\n";
            c_stimulus.stimulus((yyvsp[0].coe));
          }
#line 2456 "parse.cc" /* yacc.c:1646  */
    break;

  case 108:
#line 758 "parse.yy" /* yacc.c:1646  */
    {
            if(verbose)
              cout << "parser sees stimulus with bit flag: " << (yyvsp[0].co)->value << '\n';
            c_stimulus.stimulus((yyvsp[0].co)->value);
          }
#line 2466 "parse.cc" /* yacc.c:1646  */
    break;

  case 109:
#line 764 "parse.yy" /* yacc.c:1646  */
    {
            if(verbose)
              cout << "parser sees stimulus with string option\n";
            c_stimulus.stimulus((yyvsp[0].cos));
          }
#line 2476 "parse.cc" /* yacc.c:1646  */
    break;

  case 110:
#line 770 "parse.yy" /* yacc.c:1646  */
    { 
            if(verbose)
              cout << "parser sees stimulus with an array\n";
            c_stimulus.stimulus((yyvsp[0].ExprList_P));
          }
#line 2486 "parse.cc" /* yacc.c:1646  */
    break;

  case 111:
#line 779 "parse.yy" /* yacc.c:1646  */
    {c_symbol.dump_all();}
#line 2492 "parse.cc" /* yacc.c:1646  */
    break;

  case 112:
#line 781 "parse.yy" /* yacc.c:1646  */
    {
            c_symbol.add_one((yyvsp[-2].String_P)->getVal(), (yyvsp[0].Expression_P)); 
            delete (yyvsp[-2].String_P); 
            delete (yyvsp[0].Expression_P);
          }
#line 2502 "parse.cc" /* yacc.c:1646  */
    break;

  case 113:
#line 786 "parse.yy" /* yacc.c:1646  */
    {c_symbol.dump_one((yyvsp[0].String_P)->getVal()); delete (yyvsp[0].String_P);}
#line 2508 "parse.cc" /* yacc.c:1646  */
    break;

  case 114:
#line 787 "parse.yy" /* yacc.c:1646  */
    {c_symbol.dump_one((yyvsp[0].Symbol_P));}
#line 2514 "parse.cc" /* yacc.c:1646  */
    break;

  case 115:
#line 792 "parse.yy" /* yacc.c:1646  */
    { c_trace.trace(); }
#line 2520 "parse.cc" /* yacc.c:1646  */
    break;

  case 116:
#line 793 "parse.yy" /* yacc.c:1646  */
    { c_trace.trace((yyvsp[0].Expression_P)); }
#line 2526 "parse.cc" /* yacc.c:1646  */
    break;

  case 117:
#line 794 "parse.yy" /* yacc.c:1646  */
    { c_trace.trace((yyvsp[0].con)); }
#line 2532 "parse.cc" /* yacc.c:1646  */
    break;

  case 118:
#line 795 "parse.yy" /* yacc.c:1646  */
    { c_trace.trace((yyvsp[0].cos)); }
#line 2538 "parse.cc" /* yacc.c:1646  */
    break;

  case 119:
#line 796 "parse.yy" /* yacc.c:1646  */
    { c_trace.trace((yyvsp[0].co)); }
#line 2544 "parse.cc" /* yacc.c:1646  */
    break;

  case 120:
#line 797 "parse.yy" /* yacc.c:1646  */
    { c_trace.trace((yyvsp[0].coe)); }
#line 2550 "parse.cc" /* yacc.c:1646  */
    break;

  case 121:
#line 800 "parse.yy" /* yacc.c:1646  */
    {version.version();}
#line 2556 "parse.cc" /* yacc.c:1646  */
    break;

  case 122:
#line 804 "parse.yy" /* yacc.c:1646  */
    { c_x.x();}
#line 2562 "parse.cc" /* yacc.c:1646  */
    break;

  case 123:
#line 805 "parse.yy" /* yacc.c:1646  */
    { c_x.x((yyvsp[0].Expression_P)); }
#line 2568 "parse.cc" /* yacc.c:1646  */
    break;

  case 124:
#line 809 "parse.yy" /* yacc.c:1646  */
    { c_icd.icd(); }
#line 2574 "parse.cc" /* yacc.c:1646  */
    break;

  case 125:
#line 810 "parse.yy" /* yacc.c:1646  */
    { c_icd.icd((yyvsp[0].cos)); }
#line 2580 "parse.cc" /* yacc.c:1646  */
    break;

  case 126:
#line 831 "parse.yy" /* yacc.c:1646  */
    { c_macro.list();}
#line 2586 "parse.cc" /* yacc.c:1646  */
    break;

  case 127:
#line 832 "parse.yy" /* yacc.c:1646  */
    { }
#line 2592 "parse.cc" /* yacc.c:1646  */
    break;

  case 128:
#line 833 "parse.yy" /* yacc.c:1646  */
    { lexer_InvokeMacro((yyvsp[0].Macro_P)); }
#line 2598 "parse.cc" /* yacc.c:1646  */
    break;

  case 129:
#line 839 "parse.yy" /* yacc.c:1646  */
    {c_macro.define((yyvsp[-1].String_P)->getVal()); delete (yyvsp[-1].String_P);}
#line 2604 "parse.cc" /* yacc.c:1646  */
    break;

  case 130:
#line 841 "parse.yy" /* yacc.c:1646  */
    {lexer_setMacroBodyMode();}
#line 2610 "parse.cc" /* yacc.c:1646  */
    break;

  case 133:
#line 849 "parse.yy" /* yacc.c:1646  */
    {
            c_macro.add_parameter((yyvsp[0].String_P)->getVal());
	    delete (yyvsp[0].String_P);
	  }
#line 2619 "parse.cc" /* yacc.c:1646  */
    break;

  case 134:
#line 854 "parse.yy" /* yacc.c:1646  */
    {
	    c_macro.add_parameter((yyvsp[0].String_P)->getVal());
	    delete (yyvsp[0].String_P);
	  }
#line 2628 "parse.cc" /* yacc.c:1646  */
    break;

  case 136:
#line 863 "parse.yy" /* yacc.c:1646  */
    {; }
#line 2634 "parse.cc" /* yacc.c:1646  */
    break;

  case 137:
#line 867 "parse.yy" /* yacc.c:1646  */
    {c_macro.add_body((yyvsp[0].s));}
#line 2640 "parse.cc" /* yacc.c:1646  */
    break;

  case 138:
#line 868 "parse.yy" /* yacc.c:1646  */
    {c_macro.add_body((yyvsp[0].s));}
#line 2646 "parse.cc" /* yacc.c:1646  */
    break;

  case 139:
#line 872 "parse.yy" /* yacc.c:1646  */
    {c_macro.end_define();}
#line 2652 "parse.cc" /* yacc.c:1646  */
    break;

  case 140:
#line 873 "parse.yy" /* yacc.c:1646  */
    {c_macro.end_define((yyvsp[-1].String_P)->getVal()); delete (yyvsp[-1].String_P); }
#line 2658 "parse.cc" /* yacc.c:1646  */
    break;

  case 141:
#line 894 "parse.yy" /* yacc.c:1646  */
    {
		       cout << "declaration\n";
		       lexer_setDeclarationMode();
		     }
#line 2667 "parse.cc" /* yacc.c:1646  */
    break;

  case 142:
#line 899 "parse.yy" /* yacc.c:1646  */
    {
		       cout << " type:" << (yyvsp[0].i) << endl;
		     }
#line 2675 "parse.cc" /* yacc.c:1646  */
    break;

  case 143:
#line 903 "parse.yy" /* yacc.c:1646  */
    {
		       cout << "identifier: " << (yyvsp[0].String_P)->getVal() << endl;  delete (yyvsp[0].String_P);
		     }
#line 2683 "parse.cc" /* yacc.c:1646  */
    break;

  case 144:
#line 910 "parse.yy" /* yacc.c:1646  */
    { (yyval.i)=0; }
#line 2689 "parse.cc" /* yacc.c:1646  */
    break;

  case 145:
#line 911 "parse.yy" /* yacc.c:1646  */
    { (yyval.i) = 1; cout <<"int type\n";}
#line 2695 "parse.cc" /* yacc.c:1646  */
    break;

  case 146:
#line 912 "parse.yy" /* yacc.c:1646  */
    { (yyval.i) = 2; cout <<"float type\n";}
#line 2701 "parse.cc" /* yacc.c:1646  */
    break;

  case 147:
#line 913 "parse.yy" /* yacc.c:1646  */
    { (yyval.i) = 3; cout <<"bool type\n";}
#line 2707 "parse.cc" /* yacc.c:1646  */
    break;

  case 148:
#line 914 "parse.yy" /* yacc.c:1646  */
    { (yyval.i) = 4; cout <<"char type\n";}
#line 2713 "parse.cc" /* yacc.c:1646  */
    break;

  case 149:
#line 939 "parse.yy" /* yacc.c:1646  */
    {
	 (yyval.co) = (yyvsp[0].co);
      }
#line 2721 "parse.cc" /* yacc.c:1646  */
    break;

  case 150:
#line 945 "parse.yy" /* yacc.c:1646  */
    {
	 (yyval.co) = (yyvsp[0].co);
      }
#line 2729 "parse.cc" /* yacc.c:1646  */
    break;

  case 151:
#line 950 "parse.yy" /* yacc.c:1646  */
    { (yyval.coe) = new cmd_options_expr((yyvsp[-1].co),(yyvsp[0].Expression_P)); }
#line 2735 "parse.cc" /* yacc.c:1646  */
    break;

  case 152:
#line 954 "parse.yy" /* yacc.c:1646  */
    { 

	        (yyval.con) = new cmd_options_num;
	        (yyval.con)->co = (yyvsp[-1].co);
	      }
#line 2745 "parse.cc" /* yacc.c:1646  */
    break;

  case 153:
#line 963 "parse.yy" /* yacc.c:1646  */
    { 
          (yyval.cos) = new cmd_options_str((yyvsp[0].String_P)->getVal());
          (yyval.cos)->co  = (yyvsp[-1].co);
          if(verbose&2)
            cout << " name " << (yyval.cos)->co->name << " value " << (yyval.cos)->str << " got a string option \n"; 
          delete (yyvsp[0].String_P);
        }
#line 2757 "parse.cc" /* yacc.c:1646  */
    break;

  case 154:
#line 971 "parse.yy" /* yacc.c:1646  */
    { 
          String *pValue = dynamic_cast<String*>((yyvsp[0].Symbol_P));
          if(pValue != NULL) {
            (yyval.cos) = new cmd_options_str(pValue->getVal());
            (yyval.cos)->co  = (yyvsp[-1].co);
            if(verbose&2)
              cout << " name " << (yyval.cos)->co->name << " value " << (yyval.cos)->str << " got a symbol option \n"; 
          }
          else {
            cout << " symbol option '"
                 << (yyvsp[0].Symbol_P)->name()
                 << "' is not a string"
                 << endl; 
	    (yyval.cos) = NULL;
          }
          //delete $2;
        }
#line 2779 "parse.cc" /* yacc.c:1646  */
    break;

  case 155:
#line 991 "parse.yy" /* yacc.c:1646  */
    {(yyval.StringList_P) = new StringList_t(); (yyval.StringList_P)->push_back((yyvsp[0].String_P)->getVal()); delete (yyvsp[0].String_P);}
#line 2785 "parse.cc" /* yacc.c:1646  */
    break;

  case 156:
#line 992 "parse.yy" /* yacc.c:1646  */
    {(yyvsp[-1].StringList_P)->push_back((yyvsp[0].String_P)->getVal()); delete (yyvsp[0].String_P);}
#line 2791 "parse.cc" /* yacc.c:1646  */
    break;

  case 157:
#line 998 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P)=(yyvsp[0].BinaryOperator_P);}
#line 2797 "parse.cc" /* yacc.c:1646  */
    break;

  case 158:
#line 999 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P)=(yyvsp[0].Expression_P);}
#line 2803 "parse.cc" /* yacc.c:1646  */
    break;

  case 159:
#line 1000 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P)=new RegisterExpression(toInt((yyvsp[-1].Expression_P)));
                                                         delete (yyvsp[-1].Expression_P); }
#line 2810 "parse.cc" /* yacc.c:1646  */
    break;

  case 160:
#line 1004 "parse.yy" /* yacc.c:1646  */
    {(yyval.ExprList_P)=(yyvsp[-1].ExprList_P);}
#line 2816 "parse.cc" /* yacc.c:1646  */
    break;

  case 161:
#line 1008 "parse.yy" /* yacc.c:1646  */
    {
            // Ex: pin(MyVariable)  -- where MyVariable is the name of a symbol 
            //  This allows one to programmatically select a particular pin number.

	    // If Symbol has an integer type, assume it is a CPU pin number
	    // otherwise assume it is a stimulus such as a pin name
	    if (typeid(*(yyvsp[-1].Symbol_P)) == typeid(Integer))
	    {
                (yyval.gpsimObject_P) = toStimulus((yyvsp[-1].Symbol_P));
   	    }
            else
	        (yyval.gpsimObject_P) = (yyvsp[-1].Symbol_P);

            //$$=new Pin_t(Pin_t::ePackageBased | Pin_t::eActiveProc, $3);
          }
#line 2836 "parse.cc" /* yacc.c:1646  */
    break;

  case 162:
#line 1024 "parse.yy" /* yacc.c:1646  */
    {
            // Ex: pin(8)  -- select a particular pin in the package
            (yyval.gpsimObject_P) = toStimulus((yyvsp[-1].Integer_P)->getVal());
            delete (yyvsp[-1].Integer_P);
          }
#line 2846 "parse.cc" /* yacc.c:1646  */
    break;

  case 163:
#line 1030 "parse.yy" /* yacc.c:1646  */
    {
            // The symbol should be a stimulus. This is for the attach command.
            // Ex:  attach Node1 portb0
            // The scanner will find portb0 and return it to us here as a SYMBOL_T
            (yyval.gpsimObject_P) = (yyvsp[0].Symbol_P); //dynamic_cast<stimulus *>($1);
          }
#line 2857 "parse.cc" /* yacc.c:1646  */
    break;

  case 164:
#line 1050 "parse.yy" /* yacc.c:1646  */
    {(yyval.gpsimObjectList_P) = new gpsimObjectList_t(); (yyval.gpsimObjectList_P)->push_back((yyvsp[0].gpsimObject_P));}
#line 2863 "parse.cc" /* yacc.c:1646  */
    break;

  case 165:
#line 1051 "parse.yy" /* yacc.c:1646  */
    {if ((yyvsp[0].gpsimObject_P)) (yyvsp[-1].gpsimObjectList_P)->push_back((yyvsp[0].gpsimObject_P));}
#line 2869 "parse.cc" /* yacc.c:1646  */
    break;

  case 166:
#line 1055 "parse.yy" /* yacc.c:1646  */
    {(yyval.ExprList_P) = new ExprList_t(); (yyval.ExprList_P)->push_back((yyvsp[0].Expression_P));}
#line 2875 "parse.cc" /* yacc.c:1646  */
    break;

  case 167:
#line 1056 "parse.yy" /* yacc.c:1646  */
    {(yyvsp[-2].ExprList_P)->push_back((yyvsp[0].Expression_P)); }
#line 2881 "parse.cc" /* yacc.c:1646  */
    break;

  case 168:
#line 1060 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpAdd((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2887 "parse.cc" /* yacc.c:1646  */
    break;

  case 169:
#line 1061 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpSub((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2893 "parse.cc" /* yacc.c:1646  */
    break;

  case 170:
#line 1062 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpMpy((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2899 "parse.cc" /* yacc.c:1646  */
    break;

  case 171:
#line 1063 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpDiv((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2905 "parse.cc" /* yacc.c:1646  */
    break;

  case 172:
#line 1064 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpAnd((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2911 "parse.cc" /* yacc.c:1646  */
    break;

  case 173:
#line 1065 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpOr((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2917 "parse.cc" /* yacc.c:1646  */
    break;

  case 174:
#line 1066 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpXor((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2923 "parse.cc" /* yacc.c:1646  */
    break;

  case 175:
#line 1067 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpShl((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2929 "parse.cc" /* yacc.c:1646  */
    break;

  case 176:
#line 1068 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpShr((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2935 "parse.cc" /* yacc.c:1646  */
    break;

  case 177:
#line 1069 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpEq((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2941 "parse.cc" /* yacc.c:1646  */
    break;

  case 178:
#line 1070 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpNe((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2947 "parse.cc" /* yacc.c:1646  */
    break;

  case 179:
#line 1071 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpLt((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2953 "parse.cc" /* yacc.c:1646  */
    break;

  case 180:
#line 1072 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpGt((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2959 "parse.cc" /* yacc.c:1646  */
    break;

  case 181:
#line 1073 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpLe((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2965 "parse.cc" /* yacc.c:1646  */
    break;

  case 182:
#line 1074 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpGe((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2971 "parse.cc" /* yacc.c:1646  */
    break;

  case 183:
#line 1075 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpLogicalAnd((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2977 "parse.cc" /* yacc.c:1646  */
    break;

  case 184:
#line 1076 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpLogicalOr((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2983 "parse.cc" /* yacc.c:1646  */
    break;

  case 185:
#line 1077 "parse.yy" /* yacc.c:1646  */
    {(yyval.BinaryOperator_P) = new OpAbstractRange((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
#line 2989 "parse.cc" /* yacc.c:1646  */
    break;

  case 186:
#line 1081 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P)=(yyvsp[0].Expression_P);}
#line 2995 "parse.cc" /* yacc.c:1646  */
    break;

  case 187:
#line 1082 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new OpPlus((yyvsp[0].Expression_P));}
#line 3001 "parse.cc" /* yacc.c:1646  */
    break;

  case 188:
#line 1083 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new OpNegate((yyvsp[0].Expression_P));}
#line 3007 "parse.cc" /* yacc.c:1646  */
    break;

  case 189:
#line 1084 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new OpOnescomp((yyvsp[0].Expression_P));}
#line 3013 "parse.cc" /* yacc.c:1646  */
    break;

  case 190:
#line 1085 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new OpLogicalNot((yyvsp[0].Expression_P));}
#line 3019 "parse.cc" /* yacc.c:1646  */
    break;

  case 191:
#line 1086 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new OpIndirect((yyvsp[0].Expression_P));}
#line 3025 "parse.cc" /* yacc.c:1646  */
    break;

  case 192:
#line 1087 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new OpAddressOf((yyvsp[0].Expression_P));}
#line 3031 "parse.cc" /* yacc.c:1646  */
    break;

  case 193:
#line 1088 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P)=(yyvsp[-1].Expression_P);}
#line 3037 "parse.cc" /* yacc.c:1646  */
    break;

  case 194:
#line 1091 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new LiteralInteger((yyvsp[0].Integer_P));}
#line 3043 "parse.cc" /* yacc.c:1646  */
    break;

  case 195:
#line 1092 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new LiteralBoolean((yyvsp[0].Boolean_P));}
#line 3049 "parse.cc" /* yacc.c:1646  */
    break;

  case 196:
#line 1093 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new LiteralString((yyvsp[0].String_P));}
#line 3055 "parse.cc" /* yacc.c:1646  */
    break;

  case 197:
#line 1094 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new LiteralFloat((yyvsp[0].Float_P));}
#line 3061 "parse.cc" /* yacc.c:1646  */
    break;

  case 198:
#line 1095 "parse.yy" /* yacc.c:1646  */
    {
					  try {
					  (yyval.Expression_P) = new LiteralSymbol((yyvsp[0].Symbol_P));
					  }
  					  catch (Error *err) {
    					    if(err)
					    {
					      yyerror(err->toString().c_str());
    					      delete err;
					     }
				    	     delete (yyvsp[0].Symbol_P);
					     YYERROR;
  					   }
					}
#line 3080 "parse.cc" /* yacc.c:1646  */
    break;

  case 199:
#line 1109 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new IndexedSymbol((yyvsp[-3].Symbol_P),(yyvsp[-1].ExprList_P));}
#line 3086 "parse.cc" /* yacc.c:1646  */
    break;

  case 200:
#line 1110 "parse.yy" /* yacc.c:1646  */
    {(yyval.Expression_P) = new LiteralArray((yyvsp[0].ExprList_P)); }
#line 3092 "parse.cc" /* yacc.c:1646  */
    break;


#line 3096 "parse.cc" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 1113 "parse.yy" /* yacc.c:1906  */


       // parsing is over 

//--------------------------
// This initialization could be done by the compiler. However
// it requires two passes through because the token values are
// defined by the parser output (eg. y.tab.h) while at the same
// time the parser depends on the .h files in which these classes
// are defined.

void initialize_commands(void)
{
  static bool initialized = 0;

  if(initialized)
    return;

  if(verbose)
    cout << __FUNCTION__ << "()\n";

  attach.token_value = ATTACH;
  c_break.token_value = BREAK;
  // c_bus.token_value = BUS;
  clear.token_value = CLEAR;
  disassemble.token_value = DISASSEMBLE;
  dump.token_value = DUMP;
  frequency.token_value = FREQUENCY;
  help.token_value = HELP;
  c_list.token_value = LIST;
  c_load.token_value = LOAD;
  c_log.token_value = LOG;
  c_macro.token_value = MACRO;
  c_module.token_value = MODULE;
  c_node.token_value = NODE;
  c_processor.token_value = PROCESSOR;
  quit.token_value = QUIT;
  reset.token_value = RESET;
  c_run.token_value = RUN;
  c_set.token_value = SET;
  step.token_value = STEP;
  c_stimulus.token_value = STIMULUS;
  c_symbol.token_value = SYMBOL;
  c_trace.token_value = TRACE;
  version.token_value = gpsim_VERSION;
  c_x.token_value = X;
  c_icd.token_value = ICD;
  c_shell.token_value = SHELL;

  initialized = 1;

  parser_spanning_lines = 0;
  parser_warnings = 1; // display parser warnings.
}
