/* vim:expandtab:ts=2 sw=2:
*/
/*  Grafx2 - The Ultimate 256-color bitmap paint program

    Copyright 2008 Yves Rizoud
    Copyright 2009 Franck Charlet
    Copyright 1996-2001 Sunset Design (Guillaume Dorme & Karl Maritaud)

    Grafx2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; version 2
    of the License.

    Grafx2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Grafx2; if not, see <http://www.gnu.org/licenses/>
*/

//////////////////////////////////////////////////////////////////////////////
///@file helpfile.h
/// This is all the text that appears in contextual help and credits.
///
/// Note: The source code is kept on a public website, so keep this in mind
/// if you're thinking of putting an e-mail address in there. At least, use
/// "\100" instead of @, to help against the most basic email address harvesters.
//////////////////////////////////////////////////////////////////////////////

#include "const.h" // Uses enumerations BUTTON_NUMBERS and SPECIAL_ACTIONS

// Some magic formulas:

#define HELP_TEXT(x) {'N', x, 0},
// Generates a 'N' line (Normal)

#define HELP_LINK(x,y) {'K', x, y},
// Generates a 'K' line (Key)

#define HELP_BOLD(x) {'S', x, 0},
// Generates a 'S' line (BOLD)

#define HELP_TITLE(x) {'T', x, 0}, {'-', x, 0},
// Generates a 'T' line (Title, upper half)
// and a second '-' line (Title, lower half),  with the same text.

static const T_Help_table helptable_about[] =
/*
  Do not exceed 44 characters for normal lines:
  HELP_TEXT ("--------------------------------------------")
  Do not exceed 22 characters for title lines:
  HELP_TITLE("======================")
*/
{
  HELP_TEXT ("") // Leave enough room for a hard-coded logo, eventually.
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("        GRAFX 2   ")
  HELP_BOLD ("         \"Dragon's Layers\" Edition")
  HELP_BOLD ("  THE ULTIMATE MULTI-RESOLUTION GFX EDITOR")
  HELP_TEXT ("       http://grafx2.googlecode.com")
#if defined(__MINT__)
  HELP_TEXT ("                atari build                ")
#else
  HELP_TEXT ("")
#endif
  HELP_TEXT ("Copyright 2007-2011, the Grafx2 project team")
  HELP_TEXT ("    Copyright 1996-2001, SUNSET DESIGN")
};
static const T_Help_table helptable_licence[] =
{
  HELP_TITLE("       LICENSE")
  HELP_TEXT ("")
  HELP_TEXT ("Grafx2 is FREE SOFTWARE, you can")
  HELP_TEXT ("redistribute it and/or modify it under the")
  HELP_TEXT ("terms of the GNU General Public License as")
  HELP_TEXT ("published by the Free Software Foundation;")
  HELP_TEXT ("version 2 of the License.")
  HELP_TEXT ("")
  HELP_TEXT ("Grafx2 is distributed in the hope that it")
  HELP_TEXT ("will be useful, but WITHOUT ANY WARRANTY;")
  HELP_TEXT ("without even the implied warranty of")
  HELP_TEXT ("MERCHANTABILITY or FITNESS FOR A PARTICULAR")
  HELP_TEXT ("PURPOSE.  See the GNU General Public License")
  HELP_TEXT ("for more details.")
  HELP_TEXT ("")
  HELP_TEXT ("You should have received a copy of the GNU")
  HELP_TEXT ("General Public License along with Grafx2;")
  HELP_TEXT ("if not, see http://www.gnu.org/licenses/ or")
  HELP_TEXT ("write to the Free Software Foundation, Inc.")
  HELP_TEXT (" 59 Temple Place - Suite 330, Boston,")
  HELP_TEXT (" MA  02111-1307, USA.")

};
static const T_Help_table helptable_help[] =
{
  HELP_TITLE("         HELP")
  HELP_TEXT ("")
  HELP_TEXT ("  Contextual help is available by pressing")
  HELP_LINK ("  the %s key",0x100+BUTTON_HELP)
  HELP_TEXT ("  You can do it while hovering a menu icon,")
  HELP_TEXT ("  or while a window is open.")
  HELP_TEXT ("  When a keyboard shortcut is displayed it's")
  HELP_TEXT ("  your current configuration and you can")
  HELP_TEXT ("  change it by clicking it.")
  HELP_TEXT ("")
  HELP_TITLE("  KEYBOARD SHORTCUTS")
  HELP_TEXT ("")
  HELP_TEXT ("Scroll visible area")
  HELP_LINK ("  up:                %s",   SPECIAL_SCROLL_UP)
  HELP_LINK ("  down:              %s",   SPECIAL_SCROLL_DOWN)
  HELP_LINK ("  left:              %s",   SPECIAL_SCROLL_LEFT)
  HELP_LINK ("  right:             %s",   SPECIAL_SCROLL_RIGHT)
  HELP_LINK ("  up faster:         %s",   SPECIAL_SCROLL_UP_FAST)
  HELP_LINK ("  down faster:       %s",   SPECIAL_SCROLL_DOWN_FAST)
  HELP_LINK ("  left faster:       %s",   SPECIAL_SCROLL_LEFT_FAST)
  HELP_LINK ("  right faster:      %s",   SPECIAL_SCROLL_RIGHT_FAST)
  HELP_LINK ("  up slower:         %s",   SPECIAL_SCROLL_UP_SLOW)
  HELP_LINK ("  down slower:       %s",   SPECIAL_SCROLL_DOWN_SLOW)
  HELP_LINK ("  left slower:       %s",   SPECIAL_SCROLL_LEFT_SLOW)
  HELP_LINK ("  right slower:      %s",   SPECIAL_SCROLL_RIGHT_SLOW)
  HELP_TEXT ("Emulate mouse")
  HELP_LINK ("  Up:                %s",   SPECIAL_MOUSE_UP)
  HELP_LINK ("  Down:              %s",   SPECIAL_MOUSE_DOWN)
  HELP_LINK ("  Left:              %s",   SPECIAL_MOUSE_LEFT)
  HELP_LINK ("  Right:             %s",   SPECIAL_MOUSE_RIGHT)
  HELP_LINK ("  Left click:        %s",   SPECIAL_CLICK_LEFT)
  HELP_LINK ("  Right click:       %s",   SPECIAL_CLICK_RIGHT)
  HELP_LINK ("Show / Hide menu:    %s",   0x100+BUTTON_HIDE)
  HELP_LINK ("Show / Hide cursor:  %s",   SPECIAL_SHOW_HIDE_CURSOR)
  HELP_LINK ("Paintbrush = \".\":    %s",   SPECIAL_DOT_PAINTBRUSH)
  HELP_LINK ("Paintbrush choice:   %s",   0x100+BUTTON_PAINTBRUSHES)
  HELP_LINK ("Monochrome brush:    %s",   0x200+BUTTON_PAINTBRUSHES)
  HELP_LINK ("Freehand drawing:    %s",   0x100+BUTTON_DRAW)
  HELP_TEXT ("Switch freehand")
  HELP_LINK ("  drawing mode:      %s",   0x200+BUTTON_DRAW)
  HELP_TEXT ("Continuous freehand")
  HELP_LINK ("  drawing:           %s",   SPECIAL_CONTINUOUS_DRAW)
  HELP_LINK ("Line:                %s",   0x100+BUTTON_LINES)
  HELP_LINK ("Knotted lines:       %s",   0x200+BUTTON_LINES)
  HELP_LINK ("Spray:               %s",   0x100+BUTTON_AIRBRUSH)
  HELP_LINK ("Spray menu:          %s",   0x200+BUTTON_AIRBRUSH)
  HELP_LINK ("Floodfill:           %s",   0x100+BUTTON_FLOODFILL)
  HELP_LINK ("Replace color:       %s",   0x200+BUTTON_FLOODFILL)
  HELP_LINK ("Bezier's curves:     %s",   0x100+BUTTON_CURVES)
  HELP_TEXT ("Bezier's curve with")
  HELP_LINK ("  3 or 4 points      %s",   0x200+BUTTON_CURVES)
  HELP_LINK ("Empty rectangle:     %s",   0x100+BUTTON_RECTANGLES)
  HELP_LINK ("Filled rectangle:    %s",   0x100+BUTTON_FILLRECT)
  HELP_LINK ("Empty circle:        %s",   0x100+BUTTON_CIRCLES)
  HELP_LINK ("Empty ellipse:       %s",   0x200+BUTTON_CIRCLES)
  HELP_LINK ("Filled circle:       %s",   0x100+BUTTON_FILLCIRC)
  HELP_LINK ("Filled ellipse:      %s",   0x200+BUTTON_FILLCIRC)
  HELP_LINK ("Empty polygon:       %s",   0x100+BUTTON_POLYGONS)
  HELP_LINK ("Empty polyform:      %s",   0x200+BUTTON_POLYGONS)
  HELP_LINK ("Polyfill:            %s",   0x100+BUTTON_POLYFILL)
  HELP_LINK ("Filled polyform:     %s",   0x200+BUTTON_POLYFILL)
  HELP_LINK ("Gradient rectangle:  %s",   0x100+BUTTON_GRADRECT)
  HELP_LINK ("Gradation menu:      %s",   0x200+BUTTON_GRADRECT)
  HELP_LINK ("Toggle color cycling:%s",   SPECIAL_CYCLE_MODE)
  HELP_LINK ("Spheres:             %s",   0x100+BUTTON_SPHERES)
  HELP_LINK ("Gradient ellipses:   %s",   0x200+BUTTON_SPHERES)
  HELP_LINK ("Adjust picture:      %s",   0x100+BUTTON_ADJUST)
  HELP_LINK ("Flip picture menu:   %s",   0x200+BUTTON_ADJUST)
  HELP_LINK ("Effects menu:        %s",   0x100+BUTTON_EFFECTS)
  HELP_LINK ("Effects all off      %s",   SPECIAL_EFFECTS_OFF)
  HELP_LINK ("Shade mode:          %s",   SPECIAL_SHADE_MODE)
  HELP_LINK ("Shade menu:          %s",   SPECIAL_SHADE_MENU)
  HELP_LINK ("Quick-shade mode:    %s",   SPECIAL_QUICK_SHADE_MODE)
  HELP_LINK ("Quick-shade menu:    %s",   SPECIAL_QUICK_SHADE_MENU)
  HELP_LINK ("Stencil mode:        %s",   SPECIAL_STENCIL_MODE)
  HELP_LINK ("Stencil menu:        %s",   SPECIAL_STENCIL_MENU)
  HELP_LINK ("Mask mode:           %s",   SPECIAL_MASK_MODE)
  HELP_LINK ("Mask menu:           %s",   SPECIAL_MASK_MENU)
  HELP_LINK ("Grid mode:           %s",   SPECIAL_GRID_MODE)
  HELP_LINK ("Grid menu:           %s",   SPECIAL_GRID_MENU)
  HELP_LINK ("Grid view:           %s",   SPECIAL_SHOW_GRID)
  HELP_LINK ("Sieve mode:          %s",   SPECIAL_SIEVE_MODE)
  HELP_LINK ("Sieve menu:          %s",   SPECIAL_SIEVE_MENU)
  HELP_LINK ("Invert Sieve:        %s",   SPECIAL_INVERT_SIEVE)
  HELP_LINK ("Colorize mode:       %s",   SPECIAL_COLORIZE_MODE)
  HELP_LINK ("  At opacity  10%%:  %s",   SPECIAL_TRANSPARENCY_1)
  HELP_LINK ("  At opacity  20%%:  %s",   SPECIAL_TRANSPARENCY_2)
  HELP_LINK ("  At opacity  30%%:  %s",   SPECIAL_TRANSPARENCY_3)
  HELP_LINK ("  At opacity  40%%:  %s",   SPECIAL_TRANSPARENCY_4)
  HELP_LINK ("  At opacity  50%%:  %s",   SPECIAL_TRANSPARENCY_5)
  HELP_LINK ("  At opacity  60%%:  %s",   SPECIAL_TRANSPARENCY_6)
  HELP_LINK ("  At opacity  70%%:  %s",   SPECIAL_TRANSPARENCY_7)
  HELP_LINK ("  At opacity  80%%:  %s",   SPECIAL_TRANSPARENCY_8)
  HELP_LINK ("  At opacity  90%%:  %s",   SPECIAL_TRANSPARENCY_9)
  HELP_LINK ("  At opacity 100%%:  %s",   SPECIAL_TRANSPARENCY_0)
  HELP_LINK ("Colorize menu:       %s",   SPECIAL_COLORIZE_MENU)
  HELP_LINK ("Smooth mode:         %s",   SPECIAL_SMOOTH_MODE)
  HELP_LINK ("Smooth menu:         %s",   SPECIAL_SMOOTH_MENU)
  HELP_LINK ("Smear mode:          %s",   SPECIAL_SMEAR_MODE)
  HELP_LINK ("Tiling mode:         %s",   SPECIAL_TILING_MODE)
  HELP_LINK ("Tiling menu:         %s",   SPECIAL_TILING_MENU)
  HELP_LINK ("Pick brush:          %s",   0x100+BUTTON_BRUSH)
  HELP_LINK ("Pick polyform brush: %s",   0x100+BUTTON_POLYBRUSH)
  HELP_LINK ("Restore brush:       %s",   0x200+BUTTON_BRUSH)
  HELP_LINK ("Flip brush X:        %s",   SPECIAL_FLIP_X)
  HELP_LINK ("Flip brush Y:        %s",   SPECIAL_FLIP_Y)
  HELP_LINK ("90 brush rotation:  %s",   SPECIAL_ROTATE_90)
  HELP_LINK ("180 brush rotation: %s",   SPECIAL_ROTATE_180)
  HELP_LINK ("Stretch brush:       %s",   SPECIAL_STRETCH)
  HELP_LINK ("Distort brush:       %s",   SPECIAL_DISTORT)
  HELP_LINK ("Outline brush:       %s",   SPECIAL_OUTLINE)
  HELP_LINK ("Nibble brush:        %s",   SPECIAL_NIBBLE)
  HELP_LINK ("Double brush size:   %s",   SPECIAL_BRUSH_DOUBLE)
  HELP_LINK ("Halve brush size:    %s",   SPECIAL_BRUSH_HALVE)
  HELP_LINK ("Double brush width:  %s",   SPECIAL_BRUSH_DOUBLE_WIDTH)
  HELP_LINK ("Double brush height: %s",   SPECIAL_BRUSH_DOUBLE_HEIGHT)
  HELP_LINK ("Get brush colors:    %s",   SPECIAL_GET_BRUSH_COLORS)
  HELP_LINK ("Recolorize brush:    %s",   SPECIAL_RECOLORIZE_BRUSH)
  HELP_LINK ("Rotate brush:        %s",   SPECIAL_ROTATE_ANY_ANGLE)
  HELP_LINK ("Pipette:             %s",   0x100+BUTTON_COLORPICKER)
  HELP_LINK ("Swap fore/back color:%s",   0x200+BUTTON_COLORPICKER)
  HELP_TEXT ("Magnifier mode")
  HELP_LINK ("  Toggle:            %s",   0x100+BUTTON_MAGNIFIER)
  HELP_LINK ("  Zoom factor menu:  %s",   0x200+BUTTON_MAGNIFIER)
  HELP_LINK ("  Zoom in:           %s",   SPECIAL_ZOOM_IN)
  HELP_LINK ("  Zoom out:          %s",   SPECIAL_ZOOM_OUT)
  HELP_LINK ("  1:1 (off)          %s",   SPECIAL_ZOOM_1)
  HELP_LINK ("  2:1                %s",   SPECIAL_ZOOM_2)
  HELP_LINK ("  3:1                %s",   SPECIAL_ZOOM_3)
  HELP_LINK ("  4:1                %s",   SPECIAL_ZOOM_4)
  HELP_LINK ("  5:1                %s",   SPECIAL_ZOOM_5)
  HELP_LINK ("  6:1                %s",   SPECIAL_ZOOM_6)
  HELP_LINK ("  8:1                %s",   SPECIAL_ZOOM_8)
  HELP_LINK ("  10:1               %s",   SPECIAL_ZOOM_10)
  HELP_LINK ("  12:1               %s",   SPECIAL_ZOOM_12)
  HELP_LINK ("  14:1               %s",   SPECIAL_ZOOM_14)
  HELP_LINK ("  16:1               %s",   SPECIAL_ZOOM_16)
  HELP_LINK ("  18:1               %s",   SPECIAL_ZOOM_18)
  HELP_LINK ("  20:1               %s",   SPECIAL_ZOOM_20)
  HELP_LINK ("Brush effects menu:  %s",   0x100+BUTTON_BRUSH_EFFECTS)
  HELP_LINK ("Brush factory:       %s",   0x200+BUTTON_BRUSH_EFFECTS)
  HELP_LINK ("Repeat last script:  %s",   SPECIAL_REPEAT_SCRIPT)
  HELP_LINK ("Run script #1:       %s",   SPECIAL_RUN_SCRIPT_1)
  HELP_LINK ("Run script #2:       %s",   SPECIAL_RUN_SCRIPT_2)
  HELP_LINK ("Run script #3:       %s",   SPECIAL_RUN_SCRIPT_3)
  HELP_LINK ("Run script #4:       %s",   SPECIAL_RUN_SCRIPT_4)
  HELP_LINK ("Run script #5:       %s",   SPECIAL_RUN_SCRIPT_5)
  HELP_LINK ("Run script #6:       %s",   SPECIAL_RUN_SCRIPT_6)
  HELP_LINK ("Run script #7:       %s",   SPECIAL_RUN_SCRIPT_7)
  HELP_LINK ("Run script #8:       %s",   SPECIAL_RUN_SCRIPT_8)
  HELP_LINK ("Run script #9:       %s",   SPECIAL_RUN_SCRIPT_9)
  HELP_LINK ("Run script #10:      %s",   SPECIAL_RUN_SCRIPT_10)
  HELP_LINK ("Text:                %s",   0x100+BUTTON_TEXT)
  HELP_LINK ("Resolution menu:     %s",   0x100+BUTTON_RESOL)
  HELP_LINK ("Safety resolution:   %s",   0x200+BUTTON_RESOL)
  HELP_LINK ("Help:                %s",   0x100+BUTTON_HELP)
  HELP_LINK ("Statistics:          %s",   0x200+BUTTON_HELP)
  HELP_LINK ("Go to spare page:    %s",   0x100+BUTTON_PAGE)
  HELP_LINK ("Copy to spare page:  %s",   0x200+BUTTON_PAGE)
  HELP_LINK ("Save as:             %s",   0x100+BUTTON_SAVE)
  HELP_LINK ("Save:                %s",   0x200+BUTTON_SAVE)
  HELP_LINK ("Load:                %s",   0x100+BUTTON_LOAD)
  HELP_LINK ("Re-load:             %s",   0x200+BUTTON_LOAD)
  HELP_LINK ("Save brush:          %s",   SPECIAL_SAVE_BRUSH)
  HELP_LINK ("Load brush:          %s",   SPECIAL_LOAD_BRUSH)
  HELP_LINK ("Larger brush size:   %s",   SPECIAL_BIGGER_PAINTBRUSH)
  HELP_LINK ("Smaller brush size:  %s",   SPECIAL_SMALLER_PAINTBRUSH)
  HELP_LINK ("Settings:            %s",   0x100+BUTTON_SETTINGS)
  HELP_LINK ("Undo:                %s",   0x100+BUTTON_UNDO)
  HELP_LINK ("Redo:                %s",   0x200+BUTTON_UNDO)
  HELP_LINK ("Kill page:           %s",   0x100+BUTTON_KILL)
  HELP_LINK ("Clear:               %s",   0x100+BUTTON_CLEAR)
  HELP_LINK ("Clear with BG color: %s",   0x200+BUTTON_CLEAR)
  HELP_LINK ("Quit:                %s",   0x100+BUTTON_QUIT)
  HELP_LINK ("Palette menu:        %s",   0x100+BUTTON_PALETTE)
  HELP_LINK ("2nd Palette menu:    %s",   0x200+BUTTON_PALETTE)
  HELP_LINK ("Exclude colors menu: %s",   SPECIAL_EXCLUDE_COLORS_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Scroll palette")
  HELP_LINK ("  Back:           %s",   0x100+BUTTON_PAL_LEFT)
  HELP_LINK ("  Forward:        %s",   0x100+BUTTON_PAL_RIGHT)
  HELP_LINK ("  Back faster:    %s",   0x200+BUTTON_PAL_LEFT)
  HELP_LINK ("  Forward faster: %s",   0x200+BUTTON_PAL_RIGHT)
  HELP_TEXT ("")
  HELP_TEXT ("Change brush attachement")
  HELP_LINK ("  Center      : %s",   SPECIAL_CENTER_ATTACHMENT)
  HELP_LINK ("  Top-left    : %s",   SPECIAL_TOP_LEFT_ATTACHMENT)
  HELP_LINK ("  Top-right   : %s",   SPECIAL_TOP_RIGHT_ATTACHMENT)
  HELP_LINK ("  Bottom-left : %s",   SPECIAL_BOTTOM_LEFT_ATTACHMENT)
  HELP_LINK ("  Bottom-right: %s",   SPECIAL_BOTTOM_RIGHT_ATTACHMENT)
  HELP_TEXT ("")
  HELP_TEXT ("Select foreground color")
  HELP_TEXT ("")
  HELP_LINK ("  Next    : %s",   SPECIAL_NEXT_FORECOLOR)
  HELP_LINK ("  Previous: %s",   SPECIAL_PREVIOUS_FORECOLOR)
  HELP_TEXT ("")
  HELP_TEXT ("Select background color")
  HELP_LINK ("  Next    : %s",   SPECIAL_NEXT_BACKCOLOR)
  HELP_LINK ("  Previous: %s",   SPECIAL_PREVIOUS_BACKCOLOR)
  HELP_TEXT ("")
  HELP_TEXT ("Select user-defined foreground color")
  HELP_TEXT ("")
  HELP_LINK ("  Next    : %s",   SPECIAL_NEXT_USER_FORECOLOR)
  HELP_LINK ("  Previous: %s",   SPECIAL_PREVIOUS_USER_FORECOLOR)
  HELP_TEXT ("")
  HELP_TEXT ("Select user-defined background color")
  HELP_LINK ("  Next    : %s",   SPECIAL_NEXT_USER_BACKCOLOR)
  HELP_LINK ("  Previous: %s",   SPECIAL_PREVIOUS_USER_BACKCOLOR)
  HELP_TEXT ("")
  HELP_TEXT ("LAYERS")
  HELP_TEXT ("")
  HELP_LINK ("  Menu      : %s",   0x100+BUTTON_LAYER_MENU)
  HELP_LINK ("  Add new   : %s",   0x100+BUTTON_LAYER_ADD)
  HELP_LINK ("  Delete    : %s",   0x100+BUTTON_LAYER_REMOVE)
  HELP_LINK ("  Merge     : %s",   0x100+BUTTON_LAYER_MERGE)
  HELP_LINK ("  Move up   : %s",   0x100+BUTTON_LAYER_UP)
  HELP_LINK ("  Move down : %s",   0x100+BUTTON_LAYER_DOWN)
  //HELP_LINK ("  Set transp: %s",   0x100+BUTTON_LAYER_COLOR)
  HELP_TEXT ("  Select :")
  HELP_LINK ("    1 : %s",   SPECIAL_LAYER1_SELECT)
  HELP_LINK ("    2 : %s",   SPECIAL_LAYER2_SELECT)
  HELP_LINK ("    3 : %s",   SPECIAL_LAYER3_SELECT)
  HELP_LINK ("    4 : %s",   SPECIAL_LAYER4_SELECT)
  HELP_LINK ("    5 : %s",   SPECIAL_LAYER5_SELECT)
  HELP_LINK ("    6 : %s",   SPECIAL_LAYER6_SELECT)
  HELP_LINK ("    7 : %s",   SPECIAL_LAYER7_SELECT)
  HELP_LINK ("    8 : %s",   SPECIAL_LAYER8_SELECT)
  HELP_TEXT ("  Toggle :")
  HELP_LINK ("    1 : %s",   SPECIAL_LAYER1_TOGGLE)
  HELP_LINK ("    2 : %s",   SPECIAL_LAYER2_TOGGLE)
  HELP_LINK ("    3 : %s",   SPECIAL_LAYER3_TOGGLE)
  HELP_LINK ("    4 : %s",   SPECIAL_LAYER4_TOGGLE)
  HELP_LINK ("    5 : %s",   SPECIAL_LAYER5_TOGGLE)
  HELP_LINK ("    6 : %s",   SPECIAL_LAYER6_TOGGLE)
  HELP_LINK ("    7 : %s",   SPECIAL_LAYER7_TOGGLE)
  HELP_LINK ("    8 : %s",   SPECIAL_LAYER8_TOGGLE)
};
static const T_Help_table helptable_credits[] =
{
//HELP_TEXT ("0----5----0----5----0----5----0----5----0--X")
  HELP_TITLE(" GRAFX2 IS CREATED BY")
  HELP_TEXT ("")
  HELP_BOLD ("          THE GRAFX2 PROJECT TEAM")
  HELP_TEXT ("")
  HELP_TEXT ("  Adrien Destugues (pulkomandy)")
  HELP_TEXT ("  Yves Rizoud (yrizoud)")
  HELP_TEXT ("")
  HELP_TEXT ("  Got the source back to life in 2006")
  HELP_TEXT ("")
  HELP_BOLD ("               SUNSET DESIGN")
  HELP_BOLD ("       AUTHORS OF GRAFX2.0 BETA 96.5%")
  HELP_TEXT ("")
  HELP_TEXT ("  Guillaume Dorme alias \"Robinson\" (code)")
  HELP_TEXT ("  Karl Maritaud   alias \"X-Man\" (code&gfx)")
//HELP_TEXT ("0----5----0----5----0----5----0----5----0--X")
  HELP_TEXT ("")
  HELP_TEXT ("  Re-licensed GrafX2 under the GPL in 2001")
  HELP_TEXT ("  Huge thanks to them for their work !")
  HELP_TEXT ("")
  HELP_BOLD ("         OTHER CODE CONTRIBUTORS")
  HELP_TEXT ("")
  HELP_TEXT ("  Karl Bartel")
  HELP_TEXT ("     SFont: bitmap fonts rendering")
  HELP_TEXT ("")
  HELP_TEXT ("  Petter Lindquist")
  HELP_TEXT ("     C64 file and image formats")
  HELP_TEXT ("")
  HELP_TEXT ("  Pasi Kallinen")
  HELP_TEXT ("     Better command-line handling")
  HELP_TEXT ("")
  HELP_TEXT ("  DawnBringer")
  HELP_TEXT ("     Lua scripts, image effects")
  HELP_TEXT ("")
  HELP_TEXT ("  Nitrofurano")
  HELP_TEXT ("     Lua scripts")
  HELP_TEXT ("")
  HELP_TITLE("         ART")
  HELP_TEXT ("")
  HELP_TEXT ("  Made (www.m4de.com)")
  HELP_TEXT ("     Logo (classic)")
  HELP_TEXT ("")
  HELP_TEXT ("  X-Man")
  HELP_TEXT ("     Buttons and fonts (classic)")
  HELP_TEXT ("")
  HELP_TEXT ("  iLKke (ilkke.blogspot.com)")
  HELP_TEXT ("     Buttons and logo (modern, scenish)")
  HELP_TEXT ("     Several fonts")
  HELP_TEXT ("")
  HELP_TEXT ("  Jamon")
  HELP_TEXT ("     Buttons, logo and font (DPaint tribute)")
  HELP_TEXT ("")
  HELP_TEXT ("  Hatch")
  HELP_TEXT ("     Vectorized icon")
  HELP_TEXT ("")
  HELP_TEXT ("               ...Pixelled all the graphics")
  HELP_TEXT ("")
  HELP_TITLE(" OTHER MACHINES PORTS")
  HELP_TEXT ("")
  HELP_BOLD ("              AMIGA OS 3 PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Artur Jarosik")
  HELP_TEXT ("")
  HELP_BOLD ("              AMIGA OS 4 PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Peter Gordon (www.petergordon.org.uk)")
  HELP_TEXT ("")
  HELP_BOLD ("                 AROS PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Fernando Mastandrea (masta.uy)")
  HELP_TEXT ("  Markus Weiss")
  HELP_TEXT ("")
  HELP_BOLD ("                FREEBSD PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Jean-Baptiste Berlioz (Tobe)")
  HELP_TEXT ("")
  HELP_BOLD ("           HAIKU OS AND BEOS PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Luc Schrijvers (Begasus)")
  HELP_TEXT ("")
  HELP_BOLD ("           LINUX BINARIES")
  HELP_TEXT ("")
  HELP_TEXT ("  Gentoo : Matteo 'Peach' Pescarin")
  HELP_TEXT ("  Debian : Grkan Sengn")
  HELP_TEXT ("")
  HELP_BOLD ("               MAC OS X PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Franck Charlet (hitchhikr)")
  HELP_TEXT ("  Per Olofsson (MagerValp)")
  HELP_TEXT ("")
  HELP_BOLD ("                MORPHOS PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Rusback")
  HELP_TEXT ("  OffseT")
  HELP_TEXT ("")
  HELP_BOLD ("                NETBSD PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Jeff Read")
  HELP_TEXT ("")
  HELP_BOLD ("                 SKYOS PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Luc Schrijvers (Begasus)")
  HELP_TEXT ("")
  HELP_BOLD ("              WIZ & CAANOO PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Alexander Filyanov (PheeL)")
  HELP_TEXT ("")
  HELP_BOLD ("                 ATARI PORT")
  HELP_TEXT ("")
  HELP_TEXT ("  Pawel Goralski (Saulot)")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("  ... made it work on your favourite toaster")
  HELP_TEXT ("")
  HELP_TITLE(" BUGFINDERS")
  HELP_TEXT ("")
//HELP_TEXT ("0----5----0----5----0----5----0----5----0--X")
  HELP_TEXT ("  anibiqme      blumunkee     BDCIron       ")
  HELP_TEXT ("  Ced           DarkDefende   DawnBringer   ")
  HELP_TEXT ("  El Topo       falenblood    fanickbux     ")
  HELP_TEXT ("  fano          fogbot121     Frost         ")
  HELP_TEXT ("  Grimmy        Grkan Sengn Hatch         ")
  HELP_TEXT ("  HoraK-FDF     iLKke         Iw2evk        ")
  HELP_TEXT ("  jackfrost128  Jamon         keito         ")
  HELP_TEXT ("  kusma         Lord Graga    Lorenzo Gatti ")
  HELP_TEXT ("  MagerValp     maymunbeyin   mind          ")
  HELP_TEXT ("  MooZ          Pasi Kallinen the Peach     ")
  HELP_TEXT ("  petter        PheeL         Ravey1138     ")
  HELP_TEXT ("  richienyhus   sm4tik        spratek       ")
  HELP_TEXT ("  Surt          tape.yrm      TeeEmCee      ")
  HELP_TEXT ("  tempest       Timo Kurrpa   titus^Rab     ")
  HELP_TEXT ("  Tob          yakumo2975    00ai99")
  HELP_TEXT ("")
  HELP_TEXT ("  ... posted the annoying bug reports.")
  HELP_TEXT ("")
  HELP_TITLE(" FILE FORMATS CREDITS")
  HELP_TEXT ("")
  HELP_TEXT ("  BMP : Microsoft")
  HELP_TEXT ("  CEL,KCF : K.O.S. (KISekae Set system)")
  HELP_TEXT ("  GIF : Compuserve")
  HELP_TEXT ("  IMG : Bivas (W. Wiedmann?)")
  HELP_TEXT ("  LBM : Electronic Arts")
  HELP_TEXT ("  PAL : ermmh... nobody (?)")
  HELP_TEXT ("  PCX : Z-Soft")
  HELP_TEXT ("  PI1,PC1 : Degas Elite")
  HELP_TEXT ("  PKM : Sunset Design")
  HELP_TEXT ("  PNG : W3C")
  HELP_TEXT ("  SCx : Colorix (?)")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE(" OUR HOMEPAGE")
  HELP_TEXT ("")
  HELP_BOLD ("  http://grafx2.googlecode.com")
  HELP_TEXT ("")
  HELP_TEXT ("  Please report any bug you may find there")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE(" GREETINGS")
  HELP_TEXT ("")
  HELP_BOLD ("Pulkomandy:")
  HELP_TEXT ("")
  HELP_TEXT ("  To the Pouet.net BBS posters, the #CPC")
  HELP_TEXT ("  trolls and the bitfellas")
  HELP_TEXT ("  To every people who makes the scene alive!")
  HELP_TEXT ("  To all guys making nice pixelled pictures")
  HELP_TEXT ("  (with or without GrafX2)")
  HELP_TEXT ("")
  HELP_BOLD ("Sunset Designs:")
  HELP_TEXT ("")
  HELP_TEXT ("  We send our best regards to...")
  HELP_TEXT ("")
  HELP_TEXT ("  Access        Filter        Pink")
  HELP_TEXT ("  Ace           Fiver         Pixel")
  HELP_TEXT ("  AcidJam       Flan          Profil")
  HELP_TEXT ("  Acryl         Fred          Prowler")
  HELP_TEXT ("  Alexel        FreddyV       Puznik")
  HELP_TEXT ("  Alias         Frost         Quick")
  HELP_TEXT ("  Amiral        Gal(GDC)     Ra")
  HELP_TEXT ("  Arrakis       GainX         Raster")
  HELP_TEXT ("  Avocado       Gandalf       Ravian")
  HELP_TEXT ("  Baloo         Goblin        RedBug")
  HELP_TEXT ("  Barti         Greenpix7     Rem")
  HELP_TEXT ("  Bat           Grid          Rez")
  HELP_TEXT ("  Biro          GrosQuick     Roudoudou")
  HELP_TEXT ("  Bisounours    HackerCroll   Sacrilege")
  HELP_TEXT ("  BlackAxe      Haplo         Sam")
  HELP_TEXT ("  Bonnie        Hof           SandMan")
  HELP_TEXT ("  Boo           Hornet        Scape")
  HELP_TEXT ("  Boz           Hulud         Sbastien")
  HELP_TEXT ("  Carine        Java          Shodan")
  HELP_TEXT ("  Chandra       JBT           Skal")
  HELP_TEXT ("  Cheetah       Jrme        Skyfire")
  HELP_TEXT ("  Chill         Julien(JCA)   Sphair")
  HELP_TEXT ("  Cougar        KalMinDo      Sprocket")
  HELP_TEXT ("  Cremax        KaneWood      Stef")
  HELP_TEXT ("  Cyclone       Karma         Stony")
  HELP_TEXT ("  Dake          Keith303      Sumaleth")
  HELP_TEXT ("  Danny         Lazur         Sunday")
  HELP_TEXT ("  Danube        LightShow     Suny")
  HELP_TEXT ("  Darjul        Lluvia        Sybaris")
  HELP_TEXT ("  Darwin        Louie         TBF")
  HELP_TEXT ("  DarkAngel     Luk           Tempest")
  HELP_TEXT ("  Das           Made          Thor")
  HELP_TEXT ("  Decker        Mamos         TMK")
  HELP_TEXT ("  DerPiipo      Mandrixx      TwoFace")
  HELP_TEXT ("  Destop        Mangue        Underking")
  HELP_TEXT ("  Diabolo       Mars          Unreal")
  HELP_TEXT ("  DineS         Mephisto      VaeVictis")
  HELP_TEXT ("  Drac          Mercure       Vastator")
  HELP_TEXT ("  DrYes         Mirec         Vatin")
  HELP_TEXT ("  Edyx          Moa           Veckman")
  HELP_TEXT ("  Eller         Moxica        Wain")
  HELP_TEXT ("  Ellyn         MRK           Wally")
  HELP_TEXT ("  EOF           Nitch         WillBe")
  HELP_TEXT ("  Fall          Noal          Xoomie")
  HELP_TEXT ("  Fame          Nytrik        Xtrm")
  HELP_TEXT ("  Fantom        Optic         YannSulu")
  HELP_TEXT ("  Fear          Orome         Z")
  HELP_TEXT ("  Feather       Pahladin      Zeb")
  HELP_TEXT ("  Fennec        Phar          Zebig")
  HELP_TEXT ("")
  HELP_TEXT ("  and all #pixel, #demofr and #coders.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("  Some information taken from several docs")
  HELP_TEXT ("  (PCGPE, Intervue, PC Interdit...)")
  HELP_TEXT ("  gave us an invaluable help.")
  HELP_TEXT ("")
  HELP_TEXT ("  Thanks to Shawn Hargreaves for his filled")
  HELP_TEXT ("  polygon routine from Allegro v2.2.")
  HELP_TEXT ("")
  HELP_TEXT ("  Thanks to Carlos \"Made\" Pardo for his")
  HELP_TEXT ("  great GrafX2 logo.")
  HELP_TEXT ("")
  HELP_TEXT ("  This is our very first program compiled")
  HELP_TEXT ("  with the Gnu C Compiler.")
  HELP_TEXT ("  A thousand thanks to the authors of")
  HELP_TEXT ("  this compiler.")
  HELP_TEXT ("")
  HELP_TEXT ("  We also would like to thank all the")
  HELP_TEXT ("  people who gave us ideas to improve")
  HELP_TEXT ("  GrafX2.")
  HELP_TEXT ("")
  HELP_TITLE (" SNAIL MAIL")
  HELP_TEXT ("")
//HELP_TEXT ("0----5----0----5----0----5----0----5----0--X")
  HELP_TEXT ("  ADRIEN DESTUGUES (PulkoMandy)")
  HELP_TEXT ("  3, rue Lapouble")
  HELP_TEXT ("  64000 PAU")
  HELP_TEXT ("  (Send emails! Welcome in 21th century!)")
  HELP_TEXT ("")
  HELP_TEXT ("  GUILLAUME DORME (Robinson)")
  HELP_TEXT ("  15, rue de l'observatoire")
  HELP_TEXT ("  87000 LIMOGES (FRANCE)")
  HELP_TEXT ("  (May take some years to get an answer)")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("  KARL MARITAUD (X-Man)")
  HELP_TEXT ("  10, rue de la Brasserie")
  HELP_TEXT ("  87000 LIMOGES (FRANCE)")
  HELP_TEXT ("  (From 2001, current status: unknown)")
  HELP_TEXT ("")
  HELP_TEXT ("")
};
static const T_Help_table helptable_paintbrush[] =
{
  HELP_TITLE("PAINTBRUSHES")
  HELP_TEXT ("")
  HELP_BOLD ("    LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_PAINTBRUSHES)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a menu where you can choose the")
  HELP_TEXT ("shape of your paintbrush.")
  HELP_TEXT ("")
  HELP_TEXT ("Paintbrushes are sorted by family. You can")
  HELP_TEXT ("see some paintbrushes of the same family but")
  HELP_TEXT ("with different sizes. There is at least one")
  HELP_TEXT ("paint-brush from each family displayed in")
  HELP_TEXT ("this menu.")
  HELP_TEXT ("Here is the list of all the different")
  HELP_TEXT ("paintbrush families:")
  HELP_TEXT ("")
  HELP_TEXT ("*******      ***      * * * *      * *   ")
  HELP_TEXT ("*******     *****      * * *      * * *  ")
  HELP_TEXT ("*******    *******    * * * *    * * * * ")
  HELP_TEXT ("*******    *******     * * *      * * *  ")
  HELP_TEXT ("*******    *******    * * * *    * * * * ")
  HELP_TEXT ("*******     *****      * * *      * * *  ")
  HELP_TEXT ("*******      ***      * * * *      * *   ")
  HELP_TEXT ("")
  HELP_TEXT ("Square      Disc       Sieve      Sieve  ")
  HELP_TEXT ("                      square      disc   ")
  HELP_TEXT ("                                         ")
  HELP_TEXT ("   *           *                    *    ")
  HELP_TEXT ("  ***       *    *                  *    ")
  HELP_TEXT (" *****        *                     *    ")
  HELP_TEXT ("*******               *******       *    ")
  HELP_TEXT (" *****     *  *  *                  *    ")
  HELP_TEXT ("  ***                               *    ")
  HELP_TEXT ("   *         *  *                   *    ")
  HELP_TEXT ("                                         ")
  HELP_TEXT ("Diamond    Random      Horiz.    Vertical")
  HELP_TEXT ("                        bar        bar   ")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("      *    *          *     *       *")
  HELP_TEXT ("     *      *          *   *        *")
  HELP_TEXT ("    *        *          * *         *")
  HELP_TEXT ("   *          *          *       *******")
  HELP_TEXT ("  *            *        * *         *")
  HELP_TEXT (" *              *      *   *        *")
  HELP_TEXT ("*                *    *     *       *")
  HELP_TEXT ("")
  HELP_TEXT (" Slash      Back-     Cross X    Cross +")
  HELP_TEXT ("            slash")
  HELP_TEXT ("")
  HELP_TEXT ("When using one of these, you can change the")
  HELP_TEXT ("brush size by using the keys:")
  HELP_LINK ("Reduce   : %s",   SPECIAL_SMALLER_PAINTBRUSH)
  HELP_LINK ("Increase : %s",   SPECIAL_BIGGER_PAINTBRUSH)
  HELP_TEXT ("")
  HELP_TEXT ("Other brushes are bitmaps, their size can't")
  HELP_TEXT ("be adjusted.")
  HELP_TEXT ("")
  HELP_TEXT ("Click with left mouse button to choose a ")
  HELP_TEXT ("paintbrush, and right mouse button to store")
  HELP_TEXT ("your current brush in the slot. If your")
  HELP_TEXT ("current brush is a grabbed brush, it will")
  HELP_TEXT ("store a monochrome version of it, maximum")
  HELP_TEXT ("15x15. (See below 'Brush container' to store")
  HELP_TEXT ("backups of a big brush)")
  HELP_TEXT ("The stored brushes are saved when you exit")
  HELP_TEXT ("the program.")
  HELP_TEXT ("")
  HELP_TEXT ("The 'Preset' button allows you to pick a")
  HELP_TEXT ("brush from any family. It's useful if you've")
  HELP_TEXT ("overwritten all normal slots with brushes")
  HELP_TEXT ("that you use more often.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("BRUSH CONTAINER")
  HELP_TEXT ("")
  HELP_TEXT ("The bottom row, initially showing empty")
  HELP_TEXT ("buttons, is the brush container. You can")
  HELP_TEXT ("right-click a button to store the current")
  HELP_TEXT ("brush in it, and then whenever you need the")
  HELP_TEXT ("brush back, open this menu again and")
  HELP_TEXT ("left-click the button.")
  HELP_TEXT ("The container can memorize resizable brushes")
  HELP_TEXT ("as well as brushes grabbed from the image.")
  HELP_TEXT ("Brushes are lost when you exit the program.")
  HELP_TEXT ("")
  HELP_BOLD ("    RIGHT CLICK     ")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_PAINTBRUSHES)
  HELP_TEXT ("")
  HELP_TEXT ("Transforms your current user-defined brush")
  HELP_TEXT ("into a paintbrush. This is actually a")
  HELP_TEXT ("\"monochromisation\" of your user-defined")
  HELP_TEXT ("brush. This means that every color of the")
  HELP_TEXT ("brush that aren't the Back-color will be")
  HELP_TEXT ("set to the Fore-color. But this option")
  HELP_TEXT ("doesn't alter the brush: you'll just have")
  HELP_TEXT ("to right-click on the \"Get brush\" buttons")
  HELP_TEXT ("to get your brush back.")
  HELP_TEXT ("")
  HELP_TEXT ("Note: When you press (not in the menu) the")
  HELP_LINK ("key %s, the current",SPECIAL_DOT_PAINTBRUSH)
  HELP_TEXT ("paintbrush becomes the smallest member of")
  HELP_TEXT ("the \"Disc\" family: i.e one pixel.")

};
static const T_Help_table helptable_adjust[] =
{
  HELP_TITLE("ADJUST OR TRANSFORM")
  HELP_TITLE("    PICTURE")
  HELP_TEXT ("")
  HELP_BOLD ("    LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_ADJUST)
  HELP_TEXT ("")
  HELP_TEXT ("Allows you to scroll the picture to")
  HELP_TEXT ("re-center your graph for example.")
  HELP_TEXT ("")
  HELP_TEXT ("Any part of the picture that goes out of")
  HELP_TEXT ("the image by a side comes back by the")
  HELP_TEXT ("opposite one.")
  HELP_TEXT ("")
  HELP_TEXT ("Left clicking the picture will scroll only")
  HELP_TEXT ("the active layer. Right-clicking will scroll")
  HELP_TEXT ("all of them.")
  HELP_TEXT ("")
  HELP_TEXT ("It is assimilated to the drawing tools")
  HELP_TEXT ("family.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("    RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_ADJUST)
  HELP_TEXT ("")
  HELP_TEXT ("Opens the Picture Transform menu.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("PICTURE TRANSFORM")
  HELP_TEXT ("")
  HELP_BOLD ("RESCALE")
  HELP_TEXT ("")
  HELP_TEXT ("Allows you to change the image's size,")
  HELP_TEXT ("rescaling it accordingly. Enter new size")
  HELP_TEXT ("and press RESIZE to confirm.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("When 'Lock proportions' is checked and you")
  HELP_TEXT ("change one dimension, the other one is")
  HELP_TEXT ("automatically adjusted to preserve the")
  HELP_TEXT ("proportions of the original image.")
  HELP_TEXT ("")
  HELP_TEXT ("You can use the dropdown button to choose")
  HELP_TEXT ("between three ways to enter the dimensions:")
  HELP_TEXT ("")
  HELP_TEXT ("In 'Pixels' mode, the column 'old' shows")
  HELP_TEXT ("the original dimensions, and you can set")
  HELP_TEXT ("the new size in pixels.")
  HELP_TEXT ("")
  HELP_TEXT ("In 'Percent' mode, you set a percentage")
  HELP_TEXT ("compared to the original image.")
  HELP_TEXT ("")
  HELP_TEXT ("In 'Ratio' mode, you can set 2 numbers for")
  HELP_TEXT ("each dimension, and the resizing factor will")
  HELP_TEXT ("be of 'new''old'. For example you can use")
  HELP_TEXT ("1:3 to divide the image by three, 2:1 to")
  HELP_TEXT ("double it, and any fraction like 15:16.")
  HELP_TEXT ("")
  HELP_TEXT ("Be careful that moving from one mode to the")
  HELP_TEXT ("next can lose precision, if the selected")
  HELP_TEXT ("dimensions cannot be represented exactly in")
  HELP_TEXT ("the new mode.")
  HELP_TEXT ("")
  HELP_BOLD ("MIRROR")
  HELP_TEXT ("")
  HELP_TEXT ("- X: Flip the picture horizontally.")
  HELP_TEXT ("")
  HELP_TEXT ("- Y: Flip the picture vertically.")
  HELP_TEXT ("")
  HELP_BOLD ("ROTATE")
  HELP_TEXT ("")
  HELP_TEXT ("-90: Rotates the image by 90")
  HELP_TEXT ("      clockwise.")
  HELP_TEXT ("")
  HELP_TEXT ("+90: Rotates the image by 90")
  HELP_TEXT ("      counter-clockwise.")
  HELP_TEXT ("180: Rotates the image by 180")
  HELP_TEXT ("")
  HELP_TEXT ("")
};
static const T_Help_table helptable_draw[] =
{
  HELP_TITLE("HAND-DRAWING")
  HELP_TEXT ("")
  HELP_BOLD ("    LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_DRAW)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the current hand-drawing mode as the")
  HELP_TEXT ("active drawing tool. There are 4")
  HELP_TEXT ("hand-drawing modes:")
  HELP_TEXT ("")
  HELP_TEXT ("Continuous hand-drawing: as you move the")
  HELP_TEXT ("mouse, the paintbrush is regularily pasted")
  HELP_TEXT ("on the picture. This drawing tool allows to")
  HELP_TEXT ("change the fore and back colors when being")
  HELP_TEXT ("in use.")
  HELP_TEXT ("")
  HELP_TEXT ("Discontinuous hand-drawing: as you move the")
  HELP_TEXT ("mouse, the paintbrush is pasted on the")
  HELP_TEXT ("picture every time a delay is passed")
  HELP_TEXT ("(actually, the delay is 1 VBL")
  HELP_TEXT ("(vertical blanking)). This drawing tool")
  HELP_TEXT ("allows to change the fore and back colors")
  HELP_TEXT ("when being in use.")
  HELP_TEXT ("")
  HELP_TEXT ("Dot by dot hand-drawing: the paintbrush is")
  HELP_TEXT ("only pasted at the position where you first")
  HELP_TEXT ("clicked.")
  HELP_TEXT ("")
  HELP_TEXT ("Contour fill: Draws pixels like continuous")
  HELP_TEXT ("mode, but when you release the button Grafx2")
  HELP_TEXT ("draws a line back to your starting position,")
  HELP_TEXT ("and fills the area. This tool doesn't use")
  HELP_TEXT ("the current brush, but single pixels.")
  HELP_TEXT ("")
  HELP_BOLD ("    RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_DRAW)
  HELP_TEXT ("")
  HELP_TEXT ("Toggles the different hand-drawing modes")
  HELP_TEXT ("and activates, at the same time, the")
  HELP_TEXT ("hand-drawing tool.")
};
static const T_Help_table helptable_curves[] =
{
  HELP_TITLE("SPLINES")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_CURVES)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the current curve-drawing mode as")
  HELP_TEXT ("the active drawing tool. There are 2")
  HELP_TEXT ("different curve-drawing modes:")
  HELP_TEXT ("")
  HELP_TEXT ("* 4 control points curves: define the basic")
  HELP_TEXT ("line like a classical line, then move, with")
  HELP_TEXT ("the left mouse button, the inner control")
  HELP_TEXT ("points to choose the shape of your curve.")
  HELP_TEXT ("When the curve has the shape you want, click")
  HELP_TEXT ("with the right mouse button to draw it")
  HELP_TEXT ("definitively.")
  HELP_TEXT ("")
  HELP_TEXT ("* 3 control points curves: the same as")
  HELP_TEXT ("above, but you'll have only one inner")
  HELP_TEXT ("control point to place. Moreover, the spline")
  HELP_TEXT ("will be traced just after placing this")
  HELP_TEXT ("point.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_CURVES)
  HELP_TEXT ("")
  HELP_TEXT ("Toggles the different curve-drawing modes")
  HELP_TEXT ("and activates, at the same time, the")
  HELP_TEXT ("curve-drawing tool.")
};
static const T_Help_table helptable_lines[] =
{
  HELP_TITLE("LINES")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_LINES)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the current line-drawing mode as the")
  HELP_TEXT ("active drawing tool. There are 3")
  HELP_TEXT ("line-drawing modes:")
  HELP_TEXT ("")
  HELP_TEXT ("* Classical lines: when first clicking on")
  HELP_TEXT ("the picture, you'll define the start of the")
  HELP_TEXT ("line. Maintain your click to choose the end")
  HELP_TEXT ("of the line and release the mouse button to")
  HELP_TEXT ("set it.")
  HELP_TEXT ("If you hold SHIFT when drawing, the line")
  HELP_TEXT ("will be constrained to horizonal, vertical")
  HELP_TEXT ("or diagonal.")
  HELP_TEXT ("")
  HELP_TEXT ("* Knotted lines: works like classical lines,")
  HELP_TEXT ("but the end of your line will automatically")
  HELP_TEXT ("become the start of the next one. When you")
  HELP_TEXT ("want to stop chaining lines, use the")
  HELP_TEXT ("opposite mouse button. \"The opposite button\"")
  HELP_TEXT ("means that if you started to draw lignes")
  HELP_TEXT ("with the left button (Fore-color), you'll")
  HELP_TEXT ("have to stop the procedure with the right")
  HELP_TEXT ("button; and conversely.")
  HELP_TEXT ("")
  HELP_TEXT ("* Concentric lines: when first clicking on")
  HELP_TEXT ("the picture, you'll define center of the")
  HELP_TEXT ("lines. In fact, the center is defined by the")
  HELP_TEXT ("the position of the mouse when you release")
  HELP_TEXT ("the mouse button. Then you can draw lines")
  HELP_TEXT ("from the center to the current mouse")
  HELP_TEXT ("position by clicking. To stop drawing")
  HELP_TEXT ("concentric lines, use the opposite mouse")
  HELP_TEXT ("button. This drawing tool allows to change")
  HELP_TEXT ("the fore and back colors when being in use.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_LINES)
  HELP_TEXT ("")
  HELP_TEXT ("Toggles the different line-drawing modes and")
  HELP_TEXT ("activates, at the same time, the")
  HELP_TEXT ("line-drawing tool.")

};
static const T_Help_table helptable_airbrush[] =
{
  HELP_TITLE("SPRAY")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_AIRBRUSH)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the spray as the active drawing")
  HELP_TEXT ("tool. This drawing tool allows to change the")
  HELP_TEXT ("fore and back colors when being in use.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_AIRBRUSH)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a menu where you can configure the")
  HELP_TEXT ("spray:")
  HELP_TEXT ("")
  HELP_TEXT ("- Size: Defines the diameter of the circle")
  HELP_TEXT ("in which will effectively fit the spray.")
  HELP_TEXT ("")
  HELP_TEXT ("- Delay: Defines the number of VBLs that")
  HELP_TEXT ("will be waited for between two flows of")
  HELP_TEXT ("spray.")
  HELP_TEXT ("")
  HELP_TEXT ("- Mode: Defines whether you want to use a")
  HELP_TEXT ("monochrome spray or a multi- colored one.")
  HELP_TEXT ("")
  HELP_TEXT ("- Mono-flow: Defines the number of")
  HELP_TEXT ("paintbrushes that will be pasted in the")
  HELP_TEXT ("circle of the spray at each cycle.")
  HELP_TEXT ("")
  HELP_TEXT ("- Palette: Left-click on a color of the")
  HELP_TEXT ("palette to see how much it will be used in")
  HELP_TEXT ("the multicolored flow, and modify it by")
  HELP_TEXT ("using the gauge on the right. If the flow of")
  HELP_TEXT ("this color was equal to 0, then the \"Init\"")
  HELP_TEXT ("value will be applied. Or set the flow of a")
  HELP_TEXT ("color to 0 by clicking on it with the right")
  HELP_TEXT ("mouse button.")
  HELP_TEXT ("")
  HELP_TEXT ("- Clear: Removes all the colors from the")
  HELP_TEXT ("multicolored flow. Actually, this puts a 0")
  HELP_TEXT ("value in the use of each color.")
  HELP_TEXT ("")
  HELP_TEXT ("- Init: Allows you to define a value that")
  HELP_TEXT ("will be set to the color you click on in the")
  HELP_TEXT ("palette if its value is equal to 0. This")
  HELP_TEXT ("permits to tag a set of colors more quickly.")
  HELP_TEXT ("")
  HELP_TEXT ("- +1,-1,x2,/2: Modify the values of all the")
  HELP_TEXT ("tagged colors (and only them).")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("Tip: If you often use the Shade mode, and")
  HELP_TEXT ("are bored to click many times on a color to")
  HELP_TEXT ("reach the color you want, you can define a")
  HELP_TEXT ("spray with \"Size\"=1, \"Mono-flow\"=1, and")
  HELP_TEXT ("\"Delay\"=2 (or more, according to your")
  HELP_TEXT ("reflexes). And then, you'll just have to")
  HELP_TEXT ("click a few hundredths of second to modify a")
  HELP_TEXT ("color.")
};
static const T_Help_table helptable_floodfill[] =
{
  HELP_TITLE("FLOODFILL")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_FLOODFILL)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the filler as the active drawing")
  HELP_TEXT ("tool. The filler, as any drawing tool, will")
  HELP_TEXT ("be affected by all the effects!")
  HELP_TEXT ("")
  HELP_TEXT ("Note that only the visible part of the")
  HELP_TEXT ("picture will be filled (as every other")
  HELP_TEXT ("drawing tools, the floodfill only alters the")
  HELP_TEXT ("visible part of the picture; this avoids")
  HELP_TEXT ("unwanted effects that wouldn't be controlled")
  HELP_TEXT ("by the user).")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_FLOODFILL)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the color replacement as the active")
  HELP_TEXT ("drawing tool.")
  HELP_TEXT ("")
  HELP_TEXT ("Any rule has its exceptions and this one")
  HELP_TEXT ("doesn't depart from that. Indeed, this tool")
  HELP_TEXT ("is the only one to be affected by no effect")
  HELP_TEXT ("(except Stencil) and to be able to modify")
  HELP_TEXT ("non visible parts of the picture.")
  HELP_TEXT ("The function of this tool being replacing")
  HELP_TEXT ("all the occurences of a color in the picture")
  HELP_TEXT ("by another, if would have been a shame to")
  HELP_TEXT ("limit modifications only to the visible part")
  HELP_TEXT ("of the picture.")
};
static const T_Help_table helptable_polygons[] =
{
  HELP_TITLE("POLYGONS")
  HELP_TITLE("POLYFORMS")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_POLYGONS)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the polygons as the active drawing")
  HELP_TEXT ("tool.")
  HELP_TEXT ("")
  HELP_TEXT ("This works just like knotted-lines but loops")
  HELP_TEXT ("the extremities when you're finished.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_POLYGONS)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the polyforms as the active drawing")
  HELP_TEXT ("tool.")
  HELP_TEXT ("")
  HELP_TEXT ("This works like a combination of free-hand")
  HELP_TEXT ("drawing and knotted-lines. If you keep the")
  HELP_TEXT ("mouse button pressed, you'll draw as if you")
  HELP_TEXT ("were in free-hand drawing mode. And, if you")
  HELP_TEXT ("release the mouse button, it will work like")
  HELP_TEXT ("knotted lines.")
  HELP_TEXT ("")
  HELP_TEXT ("Click on the opposite mouse button (i.e.:")
  HELP_TEXT ("click right if you started to draw with the")
  HELP_TEXT ("left mouse button, and vice versa) to")
  HELP_TEXT ("terminate the operation. The two extremities")
  HELP_TEXT ("will be linked automatically.")
};
static const T_Help_table helptable_polyfill[] =
{
  HELP_TITLE("FILLED POLY")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_POLYFILL)
  HELP_LINK ("(Key:%s)",0x200+BUTTON_POLYFILL)
  HELP_TEXT (" Work exactly the same way as the polygons")
  HELP_TEXT ("et polyforms above, but fill in the interior")
  HELP_TEXT ("of the drawn shapes.")
};
static const T_Help_table helptable_rectangles[] =
{
  HELP_TITLE("RECTANGLES")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_RECTANGLES)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the empty rectangles as the active")
  HELP_TEXT ("drawing tool.")
  HELP_TEXT ("")
  HELP_TEXT ("Set a corner of a rectangle. Maintain the")
  HELP_TEXT ("click to move the opposite corner and")
  HELP_TEXT ("release the mouse button to set it")
  HELP_TEXT ("definitively.")
};
static const T_Help_table helptable_filled_rectangles[] =
{
  HELP_TITLE("FILLED RECT")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_FILLRECT)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the filled rectangles as the active")
  HELP_TEXT ("drawing tool.")
  HELP_TEXT ("")
  HELP_TEXT ("Works like an empty rectangle.")
};
static const T_Help_table helptable_circles[] =
{
  HELP_TITLE("CIRCLES")
  HELP_TITLE("ELLIPSES")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_CIRCLES)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the empty circles as the active")
  HELP_TEXT ("drawing tool.")
  HELP_TEXT ("")
  HELP_TEXT ("Position the center of the cercle and")
  HELP_TEXT ("maintain the mouse button to select its")
  HELP_TEXT ("radius.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_CIRCLES)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the empty ellipses as the active")
  HELP_TEXT ("drawing tool.")
  HELP_TEXT ("")
  HELP_TEXT ("Position the center of the cercle and")
  HELP_TEXT ("maintain the mouse button to select its")
  HELP_TEXT ("dimensions.")
};
static const T_Help_table helptable_filled_circles[] =
{
  HELP_TITLE("FILLED CIRCLES")
  HELP_TITLE(" AND ELLIPSES")
  HELP_TEXT ("")
  HELP_BOLD ("FILLED CIRCLES")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_FILLCIRC)
  HELP_TEXT ("")
  HELP_TEXT ("Works like empty circles.")
  HELP_TEXT ("")
  HELP_BOLD ("FILLED ELLIPSES")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_FILLCIRC)
  HELP_TEXT ("")
  HELP_TEXT ("Works like empty ellipses.")
};
static const T_Help_table helptable_grad_rect[] =
{
  HELP_TITLE("GRAD RECTANGLE")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_GRADRECT)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the rectangle with gradations as")
  HELP_TEXT ("the active drawing tool.")
  HELP_TEXT ("")
  HELP_TEXT ("Set a corner of a rectangle. Maintain the")
  HELP_TEXT ("click to move the opposite corner and")
  HELP_TEXT ("release the mouse button to set it")
  HELP_TEXT ("definitively.")
  HELP_TEXT ("")
  HELP_TEXT ("If you don't like what you have done and")
  HELP_TEXT ("want to restart, you can use the right")
  HELP_TEXT ("click to cancel everything at this point.")
  HELP_TEXT (" If you think it's nice, then click and hold")
  HELP_TEXT ("the mouse in a point you want to have the")
  HELP_TEXT ("starting color, drag to a point where you")
  HELP_TEXT ("want the ending color, and release the")
  HELP_TEXT ("button. You can press SHIFT to enforce your")
  HELP_TEXT ("line to be vertical, horizontal, or")
  HELP_TEXT ("diagonal.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_GRADRECT)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a window where you can define the way")
  HELP_TEXT ("gradations are processed. The different")
  HELP_TEXT ("sections of this menu are:")
  HELP_TEXT ("")
  HELP_TEXT ("- Direction (arrow): Switches the direction")
  HELP_TEXT ("of the gradation.")
  HELP_TEXT ("")
  HELP_TEXT ("- Dithering method: Toggles the 3 following")
  HELP_TEXT ("methods:")
  HELP_TEXT ("  - No dithering")
  HELP_TEXT ("  - Basical dithering")
  HELP_TEXT ("  - Enhanced dithering")
  HELP_TEXT ("")
  HELP_TEXT ("- Mix: Mixes the gradation with a more or")
  HELP_TEXT ("less random factor.")
  HELP_TEXT ("")
  HELP_TEXT ("- Palette: Select a color range to build a")
  HELP_TEXT ("gradation.")
  HELP_TEXT ("")
  HELP_TEXT ("- Index scroller: Defines the current")
  HELP_TEXT ("gradation among a set of 16 that will be")
  HELP_TEXT ("memorised.")
  HELP_TEXT ("")
  HELP_BOLD ("COLOR CYCLING")
  HELP_TEXT ("")
  HELP_TEXT ("These options allow you to use animation of")
  HELP_TEXT ("colors: Grafx2 will shift palette entries")
  HELP_TEXT ("at real-time. Note that only the LBM file")
  HELP_TEXT ("format can record these settings, and very")
  HELP_TEXT ("few image viewers will play it back.")
  HELP_TEXT ("")
  HELP_TEXT ("- Cycling: Activates or desactivates the")
  HELP_TEXT ("cycling of colors when you're in the editor.")
  HELP_LINK ("Key: %s",   SPECIAL_CYCLE_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("- Speed: Sets the speed for the cycling of")
  HELP_TEXT ("this range. Zero means this range doesn't")
  HELP_TEXT ("cycle. With 1, the range shifts 0.2856 times")
  HELP_TEXT ("per second; at speed 64 it's 18.28 times")
  HELP_TEXT ("per second. The program activates cycling")
  HELP_TEXT ("while you hold the speed slider, so you can")
  HELP_TEXT ("preview the speed.")
  HELP_TEXT ("")
};
static const T_Help_table helptable_spheres[] =
{
  HELP_TITLE("GRAD SPHERE")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_SPHERES)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the spheres as the active drawing")
  HELP_TEXT ("tool.")
  HELP_TEXT ("")
  HELP_TEXT ("Position the center of the sphere and")
  HELP_TEXT ("maintain the mouse button to select its")
  HELP_TEXT ("radius. Then place the spot-light.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_SPHERES)
  HELP_TEXT ("")
  HELP_TEXT ("Selects the ellipses with gradation as the")
  HELP_TEXT ("active drawing tool.")
  HELP_TEXT ("")
  HELP_TEXT ("Draw the shape like a normal ellipse, and")
  HELP_TEXT ("then position the spot-light and click the")
  HELP_TEXT ("left mouse button to finish the shape.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("If you trace a sphere or an ellipse with")
  HELP_TEXT ("gradation with the right mouse button, the")
  HELP_TEXT ("result will be the same figure filled with")
  HELP_TEXT ("the Back-color.")
};
static const T_Help_table helptable_brush[] =
{
  HELP_TITLE("GRAB BRUSH")
  HELP_BOLD ("  OR RESTORE BRUSH")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_BRUSH)
  HELP_TEXT ("")
  HELP_TEXT ("Engages a brush grabbing.")
  HELP_TEXT ("")
  HELP_TEXT ("Click on a corner of the rectangle")
  HELP_TEXT ("containing the brush then maintain the click")
  HELP_TEXT ("to define the opposite corner of the")
  HELP_TEXT ("rectangle. Release the mouse button to grab")
  HELP_TEXT ("the brush. Performing this operation with")
  HELP_TEXT ("the right mouse button will erase the area")
  HELP_TEXT ("where the brush was grabbed with the")
  HELP_TEXT ("Back-color.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_BRUSH)
  HELP_TEXT ("")
  HELP_TEXT ("Restores the old brush.")
};
static const T_Help_table helptable_polybrush[] =
{
  HELP_TITLE("POLY GRAB")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_POLYBRUSH)
  HELP_TEXT ("")
  HELP_TEXT ("Grabs a brush of any shape by defining a")
  HELP_TEXT ("polyform (please refer to section 8 for more")
  HELP_TEXT ("explanations).")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_BRUSH)
  HELP_TEXT ("")
  HELP_TEXT ("Restores the old brush (same as above).")
};
static const T_Help_table helptable_brush_fx[] =
{
  HELP_TITLE("BRUSH FX")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_BRUSH_EFFECTS)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a menu where the following options")
  HELP_TEXT ("are available:")
  HELP_TEXT ("")
  HELP_LINK ("- X: (Key:%s)",SPECIAL_FLIP_X)
  HELP_TEXT ("Flip horizontally.")
  HELP_TEXT ("")
  HELP_LINK ("- Y: (Key:%s)",SPECIAL_FLIP_Y)
  HELP_TEXT ("Flip vertically.")
  HELP_TEXT ("")
  HELP_LINK ("- Rotate by 90: (Key:%s)",SPECIAL_ROTATE_90)
  HELP_TEXT ("Rotates the brush by an angle of 90 degrees.")
  HELP_TEXT ("")
  HELP_LINK ("- Rotate by 180: (Key:%s)",SPECIAL_ROTATE_180)
  HELP_TEXT ("Rotates the brush by an angle of 180")
  HELP_TEXT ("degrees.")
  HELP_TEXT ("")
  HELP_TEXT ("- Rotate by any angle:")
  HELP_LINK ("(Key:%s)",SPECIAL_ROTATE_ANY_ANGLE)
  HELP_TEXT ("Triggers an interactive operation that")
  HELP_TEXT ("allows you to rotate the brush. For this,")
  HELP_TEXT ("start by placing the center or rotation with")
  HELP_TEXT ("the left mouse button (if, at this moment,")
  HELP_TEXT ("you press the right button, the operation")
  HELP_TEXT ("with be cancelled). After that, you can")
  HELP_TEXT ("define the angle of rotation as many times")
  HELP_TEXT ("as you want by moving the mouse and")
  HELP_TEXT ("left-clicking. Then validate with the right")
  HELP_TEXT ("button when you are satisfied. Meanwhile,")
  HELP_TEXT ("you can press on the 8 outer digits of the")
  HELP_TEXT ("numeric pad for defining angles multiple of")
  HELP_TEXT ("45 degrees:")
  HELP_TEXT ("")
  HELP_TEXT ("             135     90      45")
  HELP_TEXT ("                \\     |     /")
  HELP_TEXT ("                 '7' '8' '9'")
  HELP_TEXT ("           180  -'4'     '6'- 0")
  HELP_TEXT ("                 '1' '2' '3'")
  HELP_TEXT ("                /     |     \\")
  HELP_TEXT ("             225     270    315")
  HELP_TEXT ("")
  HELP_LINK ("- Stretch: (Key:%s)",SPECIAL_STRETCH)
  HELP_TEXT ("Triggers an interactive operation")
  HELP_TEXT ("that enables you to stretch the brush. For")
  HELP_TEXT ("this, start by placing the upper-left")
  HELP_TEXT ("cornerof the brush with the left mouse")
  HELP_TEXT ("button (if, at this moment, you press the")
  HELP_TEXT ("right button, the operation will be")
  HELP_TEXT ("cancelled). after that, you can place the")
  HELP_TEXT ("opposite corner as many times as you need,")
  HELP_TEXT ("then validate with the right mouse button")
  HELP_TEXT ("when you are satisfied. If you place this")
  HELP_TEXT ("point at coordinates inferior to the ones of")
  HELP_TEXT ("the first point, the brush will be inverted.")
  HELP_TEXT ("Meanwhile, you can press the following keys")
  HELP_TEXT ("whose effects are:")
  HELP_TEXT ("  'D'      : Double the brush")
  HELP_TEXT ("  'H'      : Reduce the brush by half")
  HELP_TEXT ("  'X'      : Double the brush in X")
  HELP_TEXT ("  'Shift+X': Reduce the brush by half in X")
  HELP_TEXT ("  'Y'      : Double the brush in Y")
  HELP_TEXT ("  'Shift+Y': Reduce the brush by half in Y")
  HELP_TEXT ("  'N'      : Restore the normal size of the")
  HELP_TEXT ("             brush (can be useful because")
  HELP_TEXT ("             it's the only way for")
  HELP_TEXT ("             cancelling)")
  HELP_TEXT ("")
  HELP_LINK ("- Distort: (Key:%s)",SPECIAL_DISTORT)
  HELP_TEXT ("Triggers an interactive operation")
  HELP_TEXT ("that allows you to distort your brush.")
  HELP_TEXT ("Start by placing the brush somewhere on the")
  HELP_TEXT ("screen and left-click. The brush will")
  HELP_TEXT ("appear, with a little peg at each corner.")
  HELP_TEXT ("Use the left mouse button to displace the")
  HELP_TEXT ("corners, which will deform the brush.")
  HELP_TEXT ("When you're done, click the right mouse")
  HELP_TEXT ("button.")
  HELP_TEXT ("")
  HELP_LINK ("- Outline: (Key:%s)",SPECIAL_OUTLINE)
  HELP_TEXT ("This option permits to draw the")
  HELP_TEXT ("outlines of the brush with the Fore- color.")
  HELP_TEXT ("")
  HELP_LINK ("- Nibble: (Key:%s)",SPECIAL_NIBBLE)
  HELP_TEXT ("This option \"nibbles\" the outlines")
  HELP_TEXT ("of the brush. It's in some way the opposite")
  HELP_TEXT ("effect of the Outline option.")
  HELP_TEXT ("")
  HELP_LINK ("- Recolorize: (Key:%s)",SPECIAL_RECOLORIZE_BRUSH)
  HELP_TEXT ("Remaps the brush so that it")
  HELP_TEXT ("looks like it would in the spare page, using")
  HELP_TEXT ("the current palette.")
  HELP_TEXT ("")
  HELP_LINK ("- Get brush colors: (Key:%s)",SPECIAL_GET_BRUSH_COLORS)
  HELP_TEXT ("Transfers the spare")
  HELP_TEXT ("page's colors used by the brush to the")
  HELP_TEXT ("current palette.")
  HELP_TEXT ("")
  HELP_TEXT ("- Brush handle:")
  HELP_TEXT ("Allows you to choose where to place the")
  HELP_TEXT ("handle of the brush. Shortcuts are :")
  HELP_LINK ("  Center      : %s",   SPECIAL_CENTER_ATTACHMENT)
  HELP_LINK ("  Top-left    : %s",   SPECIAL_TOP_LEFT_ATTACHMENT)
  HELP_LINK ("  Top-right   : %s",   SPECIAL_TOP_RIGHT_ATTACHMENT)
  HELP_LINK ("  Bottom-left : %s",   SPECIAL_BOTTOM_LEFT_ATTACHMENT)
  HELP_LINK ("  Bottom-right: %s",   SPECIAL_BOTTOM_RIGHT_ATTACHMENT)
  HELP_TEXT ("")
  HELP_LINK ("- Load : (Key:%s)",SPECIAL_LOAD_BRUSH)
  HELP_TEXT ("Load a brush from disk.")
  HELP_TEXT ("")
  HELP_LINK ("- Save : (Key:%s)",SPECIAL_SAVE_BRUSH)
  HELP_TEXT ("Save a brush to disk.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("BRUSH FACTORY")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_BRUSH_EFFECTS)
  HELP_TEXT ("")
  HELP_TEXT ("This menu allows you to run scripts. Scripts")
  HELP_TEXT ("are written in the Lua language, and allow")
  HELP_TEXT ("you to modify the brush (hence the name")
  HELP_TEXT ("'Brush factory'), or even modify the image")
  HELP_TEXT ("or palette, like a Photoshop filter. See")
  HELP_TEXT ("the online documentation for more help")
  HELP_TEXT ("on scripting.")
  HELP_TEXT ("")
  HELP_TEXT ("You can select a script with the selector,")
  HELP_TEXT ("the bottom panel shows a short description")
  HELP_TEXT ("of what it does, and you can click Run to")
  HELP_TEXT ("launch it.")
  HELP_TEXT ("")
  HELP_TEXT ("The scripts are located in the application's")
  HELP_TEXT ("data folder, under the '/scripts'")
  HELP_TEXT ("subdirectory. The list is refreshed each")
  HELP_TEXT ("time you open the window. Scripts are loaded")
  HELP_TEXT ("from disk when you run them.")
  HELP_TEXT ("")
  HELP_LINK ("- Repeat last script: %s", SPECIAL_REPEAT_SCRIPT)
  HELP_TEXT ("")
};
static const T_Help_table helptable_effects[] =
{
  HELP_TITLE("DRAW MODES")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_EFFECTS)
  HELP_TEXT ("")
  HELP_TEXT (" This button opens a menu where you can")
  HELP_TEXT ("switch on or off the different   drawing")
  HELP_TEXT ("modes.")
  HELP_TEXT (" In this menu, the \"All off\" button switches")
  HELP_TEXT ("all the drawing modes off.   The [Del] key")
  HELP_TEXT ("is the keyboard shortcut for this button.")
  HELP_TEXT (" The \"Feedback\" button is only used in")
  HELP_TEXT ("\"Shade\", \"Quick-shade, \"Transparency\"")
  HELP_TEXT ("and \"Smooth\" modes. When it is set, it means")
  HELP_TEXT ("that the _current_   state of the picture")
  HELP_TEXT ("has to be taken into account for the effect")
  HELP_TEXT ("instead   of the state in which the image")
  HELP_TEXT ("was when you started to click for drawing.")
  HELP_TEXT ("The best, as often, is that you try by")
  HELP_TEXT ("yourself with and without Feedback   to see")
  HELP_TEXT ("the difference.")
  HELP_TEXT ("   The other buttons are the following:")
  HELP_TEXT ("")
  HELP_TITLE("SHADE")
  HELP_TEXT (" It consists in increasing or decreasing the")
  HELP_TEXT ("color number within a user-defined range.")
  HELP_TEXT ("This shows its real dimension when used with")
  HELP_TEXT ("a range of colors that shade off. Then,")
  HELP_TEXT ("you can work on a part of your picture where")
  HELP_TEXT ("colors belong to the same range without")
  HELP_TEXT ("having to change your brush color all the")
  HELP_TEXT ("time. You can choose the incrementation or")
  HELP_TEXT ("decrementation of the color by pressing")
  HELP_TEXT ("the left or right mouse button while")
  HELP_TEXT ("drawing. If you click on a color that does")
  HELP_TEXT ("not belong to the range, it will remain")
  HELP_TEXT ("unchanged.")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key : %s)",   SPECIAL_SHADE_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Shade mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_SHADE_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can define one table")
  HELP_TEXT ("of shades within a range of 8 memorised by")
  HELP_TEXT ("the program. The different sections of this")
  HELP_TEXT ("menu are:")
  HELP_TEXT ("")
  HELP_TEXT ("- Palette: You can define in it the color")
  HELP_TEXT ("blocks that will be inserted")
  HELP_TEXT ("into the table of shades.")
  HELP_TEXT ("")
  HELP_TEXT ("- Scroller: Used to change flick through the")
  HELP_TEXT ("tables of shades.")
  HELP_TEXT ("")
  HELP_TEXT ("- Table of shades definition area: The 512")
  HELP_TEXT ("squares should be widely")
  HELP_TEXT ("sufficient to define the different shades")
  HELP_TEXT ("since every 256 colors of")
  HELP_TEXT ("the palette cannot be present more than once")
  HELP_TEXT ("in each table.")
  HELP_TEXT ("")
  HELP_TEXT ("- A window (on the top-right side) permits")
  HELP_TEXT ("to visualize the different")
  HELP_TEXT ("shades defined in he current table.")
  HELP_TEXT ("")
  HELP_TEXT ("- Copy: Copy the contents of the table in a")
  HELP_TEXT ("buffer.")
  HELP_TEXT ("(Each time you open this menu, the current")
  HELP_TEXT ("table is automatically")
  HELP_TEXT ("transfered into this buffer).")
  HELP_TEXT ("")
  HELP_TEXT ("- Paste: Copy the contents of the buffer")
  HELP_TEXT ("above in the current table.")
  HELP_TEXT ("")
  HELP_TEXT ("- Clear: Reset the \"shades\" table.")
  HELP_TEXT ("")
  HELP_TEXT ("- Insert: Used to insert the block selected")
  HELP_TEXT ("in the palette at the")
  HELP_TEXT ("cursor's position in the table of shades.")
  HELP_TEXT ("IF you click with the left mouse button on")
  HELP_TEXT ("this button THEN IF a block of more than one")
  HELP_TEXT ("color is selected in the table THEN   It is")
  HELP_TEXT ("deleted and the block defined in the palette")
  HELP_TEXT ("is inserted. ELSE   The block defined in the")
  HELP_TEXT ("palette is inserted at the postion just")
  HELP_TEXT ("before the selected square. END IF")
  HELP_TEXT ("ELSE The block defined in the palette is")
  HELP_TEXT ("inserted by erasing the colors following the")
  HELP_TEXT ("beginning of the bloc selected in the table.")
  HELP_TEXT ("END IF")
  HELP_TEXT ("")
  HELP_TEXT ("- Delete: Delete the block selected in the")
  HELP_TEXT ("table.")
  HELP_TEXT ("")
  HELP_TEXT ("- Blank: Follows this algorithm:")
  HELP_TEXT ("IF you click with the left mouse button on")
  HELP_TEXT ("this button THEN Replace the block selected")
  HELP_TEXT ("in the table by blank squares.")
  HELP_TEXT ("ELSE IF a block of more than one color is")
  HELP_TEXT ("selected in the table THEN   Insert blank")
  HELP_TEXT ("squares to the left and to the right of the")
  HELP_TEXT ("block.   (this is useful for isolating a")
  HELP_TEXT ("shade quickly) ELSE   Insert blank squares")
  HELP_TEXT ("to the left of the selected square. END IF")
  HELP_TEXT ("END IF")
  HELP_TEXT ("")
  HELP_TEXT ("- Invert: Invert the order of the block")
  HELP_TEXT ("selected in the table.")
  HELP_TEXT ("")
  HELP_TEXT ("- Swap: Allows you you move a block (this")
  HELP_TEXT ("exchanges it with what is")
  HELP_TEXT ("where you want to move it).")
  HELP_TEXT ("")
  HELP_TEXT ("- Undo: Cancel the last modification of the")
  HELP_TEXT ("table.")
  HELP_TEXT ("")
  HELP_TEXT ("- The 2 numbers displayed on the right of")
  HELP_TEXT ("these buttons are: (above) - the number of")
  HELP_TEXT ("the color selected in the palette if only")
  HELP_TEXT ("one color is selected. (below) - the number")
  HELP_TEXT ("of the color contained in a square in the")
  HELP_TEXT ("shades table if this square is the only one")
  HELP_TEXT ("selected.")
  HELP_TEXT ("")
  HELP_TEXT ("- The \"mode\" button displays 3 different")
  HELP_TEXT ("modes:")
  HELP_TEXT ("\"Normal\": Shades in the range and saturates")
  HELP_TEXT ("to its boundaries.")
  HELP_TEXT ("\"Loop\": Shades in the range and loops if")
  HELP_TEXT ("boundaries are passed.")
  HELP_TEXT ("\"No saturation\": Shades in the range and")
  HELP_TEXT ("doesn't saturate if boundaries are passed.")
  HELP_TEXT ("If the Step (see below) is set to 1, this")
  HELP_TEXT ("option does exactly the same as the Normal")
  HELP_TEXT ("mode.")
  HELP_TEXT ("")
  HELP_TEXT ("- Set/Disable: If you want to define several")
  HELP_TEXT ("shades in the same table")
  HELP_TEXT ("but you'd like these shades not to be")
  HELP_TEXT ("effective at the same time, you")
  HELP_TEXT ("can mask (disable) some parts of the table")
  HELP_TEXT ("so that they will be")
  HELP_TEXT ("interpreted a blank squares.")
  HELP_TEXT ("To do that, select a block in the table of")
  HELP_TEXT ("shades and click on \"Set\".")
  HELP_TEXT ("The block will be underlined with a white")
  HELP_TEXT ("line; this means that it is")
  HELP_TEXT ("disabled.")
  HELP_TEXT ("")
  HELP_TEXT ("- Clear/Enable: This does exactly the")
  HELP_TEXT ("opposite as the button above.")
  HELP_TEXT ("")
  HELP_TEXT ("- Step: Defines the step of incrementation")
  HELP_TEXT ("of the shade. The bigger,")
  HELP_TEXT ("the faster you run through the colors of the")
  HELP_TEXT ("shade.")
  HELP_TEXT ("For example: if the step is 2 and that you")
  HELP_TEXT ("have defined a shade with")
  HELP_TEXT ("the colors 0,1,4,5,9 and that you click on a")
  HELP_TEXT ("pixel of color 1, it will")
  HELP_TEXT ("take the value 5 which is 2 positions next")
  HELP_TEXT ("in the la table.")
  HELP_TEXT ("")
  HELP_TEXT ("(We are sorry for these technical")
  HELP_TEXT ("considerations quite far from a purely")
  HELP_TEXT ("artistic point of view; but know that this")
  HELP_TEXT ("effect is really very useful and it is")
  HELP_TEXT ("preferable that you understand its whole")
  HELP_TEXT ("functionment if you want to fully take")
  HELP_TEXT ("advantage of it).")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("QUICK SHADE")
  HELP_TEXT (" This drawing mode has about the same effect")
  HELP_TEXT ("as Shade mode's except that   it is faster")
  HELP_TEXT ("to configurate but a little bit less")
  HELP_TEXT ("powerful. When you draw on a color of the")
  HELP_TEXT ("image which is between the fore- and the")
  HELP_TEXT ("back-color in the palette, the color tends")
  HELP_TEXT ("towards the fore-color   (according to the")
  HELP_TEXT ("step defined) if you draw with the left")
  HELP_TEXT ("mouse button, or   it tends towards the")
  HELP_TEXT ("back-color if you are using the right mouse")
  HELP_TEXT ("button.")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_QUICK_SHADE_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Quick-shade mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_QUICK_SHADE_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu with a few parameters that mean")
  HELP_TEXT ("exactly the same as in the menu of Shade")
  HELP_TEXT ("mode. These parameters are the step and the")
  HELP_TEXT ("loop/satu- ration mode (normal, loop, no")
  HELP_TEXT ("saturation).")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("STENCIL")
  HELP_TEXT (" It is used to prevent some colors from")
  HELP_TEXT ("being modified if you draw on   them. The")
  HELP_TEXT ("main application of the stencil is when you")
  HELP_TEXT ("want to change one   color or more into")
  HELP_TEXT ("another.")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_STENCIL_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Stencil mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_STENCIL_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can define a stencil.")
  HELP_TEXT ("The different sections of this menu are:")
  HELP_TEXT ("")
  HELP_TEXT ("- Clear: No color is protected.")
  HELP_TEXT ("")
  HELP_TEXT ("- Invert: Colors that were protected are")
  HELP_TEXT ("unprotected and vice versa.")
  HELP_TEXT ("")
  HELP_TEXT ("- Palette: Select colors that should be")
  HELP_TEXT ("protected with the left mouse button or")
  HELP_TEXT ("unprotect colors with the right mouse")
  HELP_TEXT ("button.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("MASK")
  HELP_TEXT (" This effect could have been called \"True")
  HELP_TEXT ("stencil\" because it protects   some parts of")
  HELP_TEXT ("the picture instead of some colors. The")
  HELP_TEXT ("colors you tag   represent the pixels in the")
  HELP_TEXT ("spare page, corresponding to the pixels in")
  HELP_TEXT ("the   current page, that you don't want to")
  HELP_TEXT ("alter. For example, draw a simple white")
  HELP_TEXT ("figure on a black background in the   spare")
  HELP_TEXT ("page. Then, tag the black color in the menu")
  HELP_TEXT ("of the Mask mode. When   you'll draw in the")
  HELP_TEXT ("current page, only the pixels corresponding")
  HELP_TEXT ("to the   white (non-black) ones in the spare")
  HELP_TEXT ("page will be modified.")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_MASK_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Mask mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_MASK_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can set the colors of")
  HELP_TEXT ("the Mask.")
  HELP_TEXT ("This menu works the same way as the one of")
  HELP_TEXT ("the Stencil, so please refer to the Stencil")
  HELP_TEXT ("paragraph to know how to use it.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("GRID")
  HELP_TEXT (" This is useful to snap the cursor to the")
  HELP_TEXT ("cross-points of a grid. It's   generally")
  HELP_TEXT ("used to draw a grid before drawing sprites")
  HELP_TEXT ("of the same size such   as a font or tiles,")
  HELP_TEXT ("or for drawing figures or grabbing brushes")
  HELP_TEXT ("with their   dimensions multiple of the step")
  HELP_TEXT ("of the grid.")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_GRID_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Snap-to-grid mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_GRID_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can define the grid")
  HELP_TEXT ("parameters. These parameters are:")
  HELP_TEXT ("")
  HELP_TEXT ("- X,Y: Steps of the grid.")
  HELP_TEXT ("")
  HELP_TEXT ("- dX,dY: Offsets of the grid.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("The following shortcut hides or shows the")
  HELP_TEXT ("grid in the magnified view:")
  HELP_LINK ("%s", SPECIAL_SHOW_GRID)
  HELP_TEXT ("The grid size will be according to your")
  HELP_TEXT ("snap-to-grid settings.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("SIEVE")
  HELP_TEXT (" This effect allows you, by defining a")
  HELP_TEXT ("pattern, to draw only on   particular points")
  HELP_TEXT ("of the picture. If you are a Manga drawer,")
  HELP_TEXT ("you might find this useful to make patterned")
  HELP_TEXT ("shades or color transitions.")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_SIEVE_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Sieve mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_SIEVE_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can define the Sieve")
  HELP_TEXT ("parameters. This menu consists in:")
  HELP_TEXT ("")
  HELP_TEXT ("- 16x16 drawing area: You can define a")
  HELP_TEXT ("pattern in it (left click => white pixel /")
  HELP_TEXT ("right click => black pixel). All the white")
  HELP_TEXT ("pixels indicate that, when you'll draw,")
  HELP_TEXT ("pixels will be applied on the picture at the")
  HELP_TEXT ("corresponding positions whereas black pixels")
  HELP_TEXT ("won't modify the picture: whites pixels are")
  HELP_TEXT ("the \"holes of the sieve\".")
  HELP_TEXT ("")
  HELP_TEXT ("- 12 default patterns: They can be copied to")
  HELP_TEXT ("the drawing area.")
  HELP_TEXT ("")
  HELP_TEXT ("- \"Transfer to brush\": Copies the pattern to")
  HELP_TEXT ("the brush (white pixels => Fore-color /")
  HELP_TEXT ("black pixels => Back-color).")
  HELP_TEXT ("")
  HELP_TEXT ("- \"Get from brush\": Puts the brush into the")
  HELP_TEXT ("drawing area (back-color => black pixels /")
  HELP_TEXT ("others => white pixels).")
  HELP_TEXT ("")
  HELP_TEXT ("- Scrolling 4-arrows pad: Scrolls the")
  HELP_TEXT ("pattern in the drawing area.")
  HELP_TEXT ("")
  HELP_TEXT ("- Resizing 4-arrows pad: Defines the")
  HELP_TEXT ("dimensions of the pattern.")
  HELP_TEXT ("")
  HELP_TEXT ("- Default-value (black or white square):")
  HELP_TEXT ("Indicates which value must be inserted when")
  HELP_TEXT ("you increase the dimensions of the pattern.")
  HELP_TEXT ("")
  HELP_TEXT ("- \"Clear\": Sets the whole pattern with the")
  HELP_TEXT ("default value (see above).")
  HELP_TEXT ("")
  HELP_TEXT ("- \"Invert\": It... inverts :) ... black and")
  HELP_TEXT ("white pixels.")
  HELP_LINK ("(Key: %s)",   SPECIAL_INVERT_SIEVE)
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("TRANSPARENCY")
  HELP_TEXT (" This allows to mix the color(s) of the")
  HELP_TEXT ("paintbrush with the colors of the   picture.")
  HELP_TEXT ("It's used to make transparency effects like")
  HELP_TEXT ("with watercolors.")
  HELP_TEXT ("")
  HELP_TEXT ("You can also use the following shortcuts to")
  HELP_TEXT ("activate transparency mode and assign an")
  HELP_TEXT ("amount of opacity:")
  HELP_LINK ("     10%% : %s", SPECIAL_TRANSPARENCY_1)
  HELP_LINK ("     20%% : %s", SPECIAL_TRANSPARENCY_2)
  HELP_LINK ("     30%% : %s", SPECIAL_TRANSPARENCY_3)
  HELP_LINK ("     40%% : %s", SPECIAL_TRANSPARENCY_4)
  HELP_LINK ("     50%% : %s", SPECIAL_TRANSPARENCY_5)
  HELP_LINK ("     60%% : %s", SPECIAL_TRANSPARENCY_6)
  HELP_LINK ("     70%% : %s", SPECIAL_TRANSPARENCY_7)
  HELP_LINK ("     80%% : %s", SPECIAL_TRANSPARENCY_8)
  HELP_LINK ("     90%% : %s", SPECIAL_TRANSPARENCY_9)
  HELP_LINK ("    100%% : %s", SPECIAL_TRANSPARENCY_0)
  HELP_TEXT ("If you use two of these shortcuts quickly,")
  HELP_TEXT ("the second will set the units for finer")
  HELP_TEXT ("control. Ie: 4 5 makes 45%, 0 9 makes 9%.")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_COLORIZE_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Transparency mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_COLORIZE_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can define the")
  HELP_TEXT ("Transparency parameters. These parameters")
  HELP_TEXT ("are:")
  HELP_TEXT ("")
  HELP_TEXT ("- Interpolation rate: Indicates the")
  HELP_TEXT ("percentage of the applied color that will be")
  HELP_TEXT ("considered upon the replaced color.")
  HELP_TEXT ("")
  HELP_TEXT ("- Interpolation method: Uses an")
  HELP_TEXT ("interpolation algorithm to compute the")
  HELP_TEXT ("color, according to the interpolation rate.")
  HELP_TEXT ("")
  HELP_TEXT ("- Additive method: Uses the lightest colors")
  HELP_TEXT ("to choose the color to apply. For example:")
  HELP_TEXT ("if you want to apply a color RGB:30,20,40 on")
  HELP_TEXT ("a color RGB:10,50,20, the color applied will")
  HELP_TEXT ("be the one, in the palette, that is the")
  HELP_TEXT ("closest to the theoretic color RGB:30,50,40.")
  HELP_TEXT ("")
  HELP_TEXT ("- Subtractive method: uses the darkest")
  HELP_TEXT ("colors to choose the color to apply. For")
  HELP_TEXT ("example: if you want to apply a color")
  HELP_TEXT ("RGB:30,20,40 on a color RGB:10,50,20, the")
  HELP_TEXT ("color applied will be the one, in the")
  HELP_TEXT ("palette, that is the closest to the")
  HELP_TEXT ("theoretic color RGB:10,20,20.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("SMOOTH")
  HELP_TEXT (" It provides an easy but not as efficient")
  HELP_TEXT ("anti-aliasing as any artist's   touch.")
  HELP_TEXT ("Anyway this effect finds a better use in")
  HELP_TEXT ("making a blurry aspect.")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_SMOOTH_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Smooth mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_SMOOTH_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can define the Smooth")
  HELP_TEXT ("matrix or choose one among the 4 ones")
  HELP_TEXT ("predefined.")
  HELP_TEXT ("The middle square represents the pixel on")
  HELP_TEXT ("which you draw and the 8 others represent")
  HELP_TEXT ("the neighbour pixels. Then, the point on")
  HELP_TEXT ("which one draw will be replaced by the")
  HELP_TEXT ("weighted average (according to values of")
  HELP_TEXT ("each squares) of the 9 defined points.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("SMEAR")
  HELP_TEXT (" It smears pixels in the direction you are")
  HELP_TEXT ("moving your paintbrush, just   as if you")
  HELP_TEXT ("wanted to spread fresh paint with your")
  HELP_TEXT ("fingers. You can combine   this effect with")
  HELP_TEXT ("the transparency effect.")
  HELP_TEXT ("")
  HELP_LINK ("(Key: %s)",   SPECIAL_SMEAR_MODE)
  HELP_TEXT ("Switches the Smear mode.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("TILING")
  HELP_TEXT (" It consists in displaying parts of the")
  HELP_TEXT ("brush that are adjusted on a   tiling when")
  HELP_TEXT ("you are drawing. It's mainly used for")
  HELP_TEXT ("quickly drawing a   background with a")
  HELP_TEXT ("pattern, but there is a great number of")
  HELP_TEXT ("other   possibilities.")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_TILING_MODE)
  HELP_TEXT ("")
  HELP_TEXT ("Switches the Tiling mode.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key: %s)",   SPECIAL_TILING_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can define the Tiling")
  HELP_TEXT ("parameters. These parameters are the offsets")
  HELP_TEXT ("of the tiling.")
};
static const T_Help_table helptable_text[] =
{
  HELP_TITLE("TEXT")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_TEXT)
  HELP_TEXT ("")
  HELP_TEXT ("The text menu allows you to enter some text")
  HELP_TEXT ("and render it as a brush.")
  HELP_TEXT ("The current background and foreground colors")
  HELP_TEXT ("are very important, they determine the text")
  HELP_TEXT ("color, the transparent color, and also the")
  HELP_TEXT ("color range to use for antialiasing.")
  HELP_TEXT ("GrafX2 can use 'bitmap' fonts as long as")
  HELP_TEXT ("they are in the special layout supported ")
  HELP_TEXT ("by SFont.")
  HELP_TEXT ("TrueType fonts can also be used if this")
  HELP_TEXT ("version of GrafX2 was compiled with")
  HELP_TEXT ("TrueType support.")
  HELP_TEXT ("")
  HELP_TEXT ("- Txt: Click and enter your text here, a")
  HELP_TEXT ("line of up to 250 characters.")
  HELP_TEXT ("")
  HELP_TEXT ("- Clear txt: Empties the current text.")
  HELP_TEXT ("When the text is empty, a standard string")
  HELP_TEXT ("is shown instead in the preview area.")
  HELP_TEXT ("")
  HELP_TEXT ("- Antialias: Click to enable or disable")
  HELP_TEXT ("Antialiasing. Only affects TrueType fonts.")
  HELP_TEXT ("")
  HELP_TEXT ("- Size: Determine the font height. Only")
  HELP_TEXT ("affects TrueType fonts.")
  HELP_TEXT ("")
  HELP_TEXT ("- Font selector: Choose a font. You can")
  HELP_TEXT ("use the arrow keys (up and down) to quickly")
  HELP_TEXT ("browse your fonts.")
  HELP_TEXT ("TrueType fonts are indicated by 'TT'.")
  HELP_TEXT ("")
  HELP_TEXT ("- Preview area: Shows what the brush will")
  HELP_TEXT ("look like.")
};
static const T_Help_table helptable_magnifier[] =
{
  HELP_TITLE("MAGNIFIER")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_MAGNIFIER)
  HELP_TEXT ("")
  HELP_TEXT ("Engages/Disengages the choice of the zoomed")
  HELP_TEXT ("window. If you're already in magnifier mode,")
  HELP_TEXT ("you'll return to normal mode.")
  HELP_LINK ("Zoom in : %s",SPECIAL_ZOOM_IN)
  HELP_LINK ("Zoom out: %s",SPECIAL_ZOOM_OUT)
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_MAGNIFIER)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a menu where you can choose the")
  HELP_TEXT ("magnifying factor.")
  HELP_TEXT ("")
  HELP_TEXT (" Note: When you are in Zoom mode, you can")
  HELP_TEXT ("move the \"split\" bar by   clicking on it and")
  HELP_TEXT ("moving your mouse left or right while")
  HELP_TEXT ("holding the mouse   button down.")
};
static const T_Help_table helptable_colorpicker[] =
{
  HELP_TITLE("PIPETTE")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_COLORPICKER)
  HELP_TEXT ("")
  HELP_TEXT ("Engages a color grabbing.")
  HELP_TEXT ("")
  HELP_TEXT ("Click on the picture to get the color of the")
  HELP_TEXT ("pixel you're on. You can either get a new")
  HELP_TEXT ("Fore-color or Back-color with respectively")
  HELP_TEXT ("left or right mouse button.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_COLORPICKER)
  HELP_TEXT ("")
  HELP_TEXT ("Swap Fore-color and Back-color.")
  HELP_TEXT ("")
  HELP_TEXT (" The color currently pointed will be")
  HELP_TEXT ("displayed in the tool-bar right   after the")
  HELP_TEXT ("coordinates. If you click outside the")
  HELP_TEXT ("picture, the color 0 will be returned.")
};
static const T_Help_table helptable_resolution[] =
{
  HELP_TITLE("RESOLUTION AND")
  HELP_TITLE(" IMAGE SIZE")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_RESOL)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a menu where you can define the")
  HELP_TEXT ("size of your picture and choose the")
  HELP_TEXT ("screen resolution.")
  HELP_TEXT ("")
  HELP_TEXT ("- Image size")
  HELP_TEXT ("Click in the boxes named \"Width\" and")
  HELP_TEXT ("\"Height\" to change the size of the image")
  HELP_TEXT ("you're editing, up to 9999x9999.")
  HELP_TEXT ("You can also right-click a video mode to")
  HELP_TEXT ("copy its dimensions to the image's.")
  HELP_TEXT ("")
  HELP_TEXT ("- Pixel size")
  HELP_TEXT ("If you choose any Pixel size other than")
  HELP_TEXT ("Normal, Grafx2 will emulate a lower")
  HELP_TEXT ("resolution by scaling up everything it")
  HELP_TEXT ("displays, including the menus and mouse")
  HELP_TEXT ("cursor. In Double, Triple and Quadruple")
  HELP_TEXT ("mode, the image will appear zoomed x2, x3 or")
  HELP_TEXT ("x4, keeping the original proportions. The")
  HELP_TEXT ("scaling is done in software, with no linear")
  HELP_TEXT ("interpolation, so it can't cause blur. This")
  HELP_TEXT ("setting is especially useful if your")
  HELP_TEXT ("hardware or drivers don't support the low")
  HELP_TEXT ("resolutions you need, but it also allows you")
  HELP_TEXT ("to draw in low-resolution while staying in")
  HELP_TEXT ("window mode.")
  HELP_TEXT ("If you choose one of the scalers called")
  HELP_TEXT ("Wide, Tall, Wide2 and Tall2, this will")
  HELP_TEXT ("emulate a video mode which has rectangular")
  HELP_TEXT ("pixels (longer horizontally or vertically),")
  HELP_TEXT ("like some video modes of the C64, Amstrad")
  HELP_TEXT ("CPC, and Commodore Amiga.")
  HELP_TEXT ("")
  HELP_TEXT ("- Video mode")
  HELP_TEXT ("Click on a video mode to select it.")
  HELP_TEXT ("Grafx2 only lists modes that are detected")
  HELP_TEXT ("as available on your computer. Depending on")
  HELP_TEXT ("your video card and drivers, there can be")
  HELP_TEXT ("a huge difference in the number of modes")
  HELP_TEXT ("it can propose.")
  HELP_TEXT ("The small buttons on the left-hand side of")
  HELP_TEXT ("the lines in the list of modes have been")
  HELP_TEXT ("designed to allow you to disable some modes")
  HELP_TEXT ("that are not supported by your card. So, the")
  HELP_TEXT ("modes that you will disable won't be used")
  HELP_TEXT ("when loading pictures with \"Auto-set")
  HELP_TEXT ("resolution\" ON.")
  HELP_TEXT ("")
  HELP_TEXT ("When you click on one of these buttons, its")
  HELP_TEXT ("color changes to one of the 4 following. The")
  HELP_TEXT ("signification for each color of these")
  HELP_TEXT ("buttons is:")
  HELP_TEXT ("")
  HELP_TEXT ("- Light gray: The video mode is OK. It can")
  HELP_TEXT ("be used by the auto-set resolution option")
  HELP_TEXT ("when you load picture, and you can select it")
  HELP_TEXT ("in the menu of resolutions.")
  HELP_TEXT ("")
  HELP_TEXT ("- White: It works exactly the same as above.")
  HELP_TEXT ("Moreover, it allows you to tag your")
  HELP_TEXT ("favourite modes. Indeed, the huge number of")
  HELP_TEXT ("video modes makes it more difficult to find")
  HELP_TEXT ("the mode your want in the list; so you can")
  HELP_TEXT ("tag your favoutite ones in white, so that it")
  HELP_TEXT ("will be easier to locate them. (Note: you")
  HELP_TEXT ("cannot disable the standard windowed mode)")
  HELP_TEXT ("")
  HELP_TEXT ("- Dark gray: It allows you to indicate which")
  HELP_TEXT ("modes are not really perfect (flickering,")
  HELP_TEXT ("not centered, etc...) but which can be used")
  HELP_TEXT ("even so. The difference with the light grey")
  HELP_TEXT ("button is that these modes won't be used by")
  HELP_TEXT ("the auto-set resolution option.")
  HELP_TEXT ("")
  HELP_TEXT ("- Black: Use it for totally unsupported")
  HELP_TEXT ("modes. Thus, these modes won't be selected")
  HELP_TEXT ("the \"auto-set res.\" and the program will")
  HELP_TEXT ("not let you select them from the list of")
  HELP_TEXT ("resolutions.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_RESOL)
  HELP_TEXT ("")
  HELP_TEXT (" Automatically switches to the 640x400 window")
  HELP_TEXT ("mode.")
};
static const T_Help_table helptable_page[] =
{
  HELP_TITLE("SPARE")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_PAGE)
  HELP_TEXT ("")
  HELP_TEXT ("Jumps to spare page. The current page is")
  HELP_TEXT ("then considered as the new spare page, and")
  HELP_TEXT ("the spare page considered as the new current")
  HELP_TEXT ("page.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_PAGE)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu where you can choose whether")
  HELP_TEXT ("you want to copy the whole picture (keyboard")
  HELP_TEXT ("short-cut in this menu is [Return]), only")
  HELP_TEXT ("the pixels, only the palette, or only some")
  HELP_TEXT ("colors.")
  HELP_TEXT ("In this last case, a second menu")
  HELP_TEXT ("(stencil-like) will propose you to tag the")
  HELP_TEXT ("colors you want to copy (they are all")
  HELP_TEXT ("selected by default).")
  HELP_TEXT ("Please refer to section \"Stencil\" to know")
  HELP_TEXT ("how to use this last menu.")
  HELP_TEXT ("The last option the menu (\"Copy palette and")
  HELP_TEXT ("remap\"), remaps the spare page with the")
  HELP_TEXT ("current palette and replicates this palette")
  HELP_TEXT ("to the spare page. This option is useful to")
  HELP_TEXT ("quickly remap a picture with the palette of")
  HELP_TEXT ("another.")
};
static const T_Help_table helptable_save[] =
{
  HELP_TITLE("SAVE")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_SAVE)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a fileselector where the following")
  HELP_TEXT ("options are available:")
  HELP_TEXT ("")
  HELP_TEXT ("- Select drive: Allow you to change the")
  HELP_TEXT ("current drive.or volume (depending on your")
  HELP_TEXT ("operating system")
  HELP_TEXT ("")
  HELP_TEXT ("- Format: Allows you to choose the file")
  HELP_TEXT ("format you want. (PAL and KCF file formats")
  HELP_TEXT ("are \"palette\" files).")
  HELP_TEXT ("")
  HELP_TEXT ("- Filename: Allows you to give a new name to")
  HELP_TEXT ("the picture. If no extension is given, the")
  HELP_TEXT ("default (according to the format) will be")
  HELP_TEXT ("used.")
  HELP_TEXT ("")
  HELP_TEXT ("- Bookmarks: The four dropdown buttons allow")
  HELP_TEXT ("you to bookmark frequently used directories.")
  HELP_TEXT ("Use right-click to open a contextual menu")
  HELP_TEXT ("to Set it (memorize current directory),")
  HELP_TEXT ("Rename it to change its label, and Clear it")
  HELP_TEXT ("if you no longer need it. Use left-click to")
  HELP_TEXT ("change to the memorized directory.")
  HELP_TEXT ("")
  HELP_TEXT ("- File-list: Allows you to flick through the")
  HELP_TEXT ("disk tree or to overwrite an existing file.")
  HELP_TEXT ("")
  HELP_TEXT ("- Delete: Allows you to delete the item")
  HELP_TEXT ("under the selection bar. If the item is a")
  HELP_TEXT ("directory, it must be empty to be removed.")
  HELP_TEXT ("")
  HELP_TEXT ("- Save: Saves the picture with the current")
  HELP_TEXT ("filename, with the chosen format. If the ")
  HELP_TEXT ("current filename represents a directory,")
  HELP_TEXT ("you'll enter it.")
  HELP_TEXT ("")
  HELP_TEXT ("- Comment (Txt): If you're using the PKM")
  HELP_TEXT ("or PNG format, you can type in a comment on")
  HELP_TEXT ("your picture. It will be memorized in the")
  HELP_TEXT ("image.")
  HELP_TEXT ("")
  HELP_TEXT ("Note: The Backspace key brings you directly")
  HELP_TEXT ("to the parent directory. You can also type")
  HELP_TEXT ("the first letters of a filename you are")
  HELP_TEXT ("looking for, to access it faster.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_SAVE)
  HELP_TEXT ("")
  HELP_TEXT ("Save the current picture with its current")
  HELP_TEXT ("filename, format and comment.")
  HELP_TEXT ("")
  HELP_TEXT ("If the file already exists, a confirmation")
  HELP_TEXT ("box will appear.")
};
static const T_Help_table helptable_load[] =
{

  HELP_TITLE("LOAD")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_LOAD)
  HELP_TEXT ("")
  HELP_TEXT ("This works the same way as Save.")
  HELP_TEXT ("")
  HELP_TEXT ("You'll have access in the format selector to")
  HELP_TEXT ("a \"*.*\" filter. And of course, you won't be")
  HELP_TEXT ("able to type in any comment.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_LOAD)
  HELP_TEXT ("")
  HELP_TEXT ("Reloads the picture.")
  HELP_TEXT ("")
  HELP_TEXT ("If you want to load a picture and that you")
  HELP_TEXT ("haven't saved the last modifications of the")
  HELP_TEXT ("current picture, a confirmation box will")
  HELP_TEXT ("appear.")
};
static const T_Help_table helptable_settings[] =
{
  HELP_TITLE("SETTINGS")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_SETTINGS)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a menu where you can configure some")
  HELP_TEXT ("miscellaneous elements of the program.")
  HELP_TEXT ("Detailed description of each setting is")
  HELP_TEXT ("available when this screen is open (Use the")
  HELP_LINK ("%s key.",0x100+BUTTON_HELP)
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("SKINS")
  HELP_TEXT ("")
  HELP_TEXT ("This window allow you to change the look and")
  HELP_TEXT ("feel of the program.")
  HELP_TEXT ("")
  HELP_TEXT ("- Font: determines whether you want to use")
  HELP_TEXT ("GrafX2 with a classical font, or another one")
  HELP_TEXT ("a bit funnier.")
  HELP_TEXT ("")
  HELP_TEXT ("- Cursor: Allows you to choose the graphic")
  HELP_TEXT ("mouse cursor: Solid and Thin are solid black")
  HELP_TEXT ("and white cursors defined by the skin file,")
  HELP_TEXT (" Transparent is a 1-pixel wide XOR cross.")
  HELP_TEXT ("")
  HELP_TEXT ("- Graphic file: you can change the whole")
  HELP_TEXT ("interface by selecting where the sprites for")
  HELP_TEXT ("all buttons are. Look at the files in the")
  HELP_TEXT ("\"skin\" directory if you want to create your")
  HELP_TEXT ("own. There are two skins available, the")
  HELP_TEXT ("default for 2.1 is called modern. Classic is")
  HELP_TEXT ("for nostalgics who wish to remember the old")
  HELP_TEXT ("days of Sunset Design. If you create a good")
  HELP_TEXT ("skin, feel free to share it with us! We may")
  HELP_TEXT ("include it in a future release...")
  HELP_TEXT ("")
  HELP_TEXT ("- Separate colors: Draws a squaring around")
  HELP_TEXT ("the colors of the tool-bar.")
  HELP_TEXT ("")
  HELP_TEXT ("- Show/Hide picture limits: Indicates if the")
  HELP_TEXT ("picture boundaries must be displayed when")
  HELP_TEXT ("you are in a resolution bigger than the")
  HELP_TEXT ("picture.")
  HELP_TEXT ("")
};

static const T_Help_table helptable_settings_details[] =
{
  HELP_TITLE("DETAILED SETTINGS")
  HELP_TEXT ("")
  HELP_TITLE("FILE SELECTOR")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("  Show hidden files")
  HELP_TEXT ("Hidden files appear.")
  HELP_TEXT ("")
  HELP_BOLD ("  Show hidden directories")
  HELP_TEXT ("Hidden directories appear.")
  HELP_TEXT ("")
  HELP_BOLD ("  Preview delay")
  HELP_TEXT ("Delay before displaying a preview in file-")
  HELP_TEXT ("selectors (in 18.2th of second). Possible")
  HELP_TEXT ("values range from 1 to 256.")
  HELP_TEXT ("")
  HELP_BOLD ("  Maximize preview")
  HELP_TEXT ("Maximize the preview of the pictures so that")
  HELP_TEXT ("it is as big as possible. If you're not in")
  HELP_TEXT ("the same resolution as the picture's one, it")
  HELP_TEXT ("can try to correct the aspect ratio, but if")
  HELP_TEXT ("the picture does not fill the whole screen,")
  HELP_TEXT ("it can be worse.")
  HELP_TEXT ("")
  HELP_BOLD ("  Find file fast")
  HELP_TEXT ("This option is used to place the selection")
  HELP_TEXT ("bar on a filename by typing its first")
  HELP_TEXT ("letters. For example, if you want to find")
  HELP_TEXT ("the 'PICTURE.PKM' in a directory that also")
  HELP_TEXT ("contains 'PALETTE.PAL', you'll just have to")
  HELP_TEXT ("type P and I. The different values of 'FFF'")
  HELP_TEXT ("indicate if you want to find the name in")
  HELP_TEXT ("both files and directories or just in only")
  HELP_TEXT ("one of these:")
  HELP_TEXT ("0: files and directories")
  HELP_TEXT ("1: files only")
  HELP_TEXT ("2: directories only")
  HELP_TEXT ("")
  HELP_BOLD ("  Auto set resolution")
  HELP_TEXT ("Automatically set the resolution when")
  HELP_TEXT ("loading a picture. You should set this value")
  HELP_TEXT ("to 'yes' after disabling the video modes")
  HELP_TEXT ("that are notsupported by your video card or")
  HELP_TEXT ("monitor.")
  HELP_TEXT ("")
  HELP_BOLD ("  Set resolution according to")
  HELP_TEXT ("If the variable above is set to 'yes', this")
  HELP_TEXT ("one tells if you want to set the resolution")
  HELP_TEXT ("according to:")
  HELP_TEXT ("1: the internal 'original screen' dimensions")
  HELP_TEXT ("   of the picture")
  HELP_TEXT ("2: the actual dimensions of the picture")
  HELP_TEXT (" ")
  HELP_BOLD ("  Backup")
  HELP_TEXT ("Create a backup file when saving.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("FILE FORMAT OPTIONS")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("  Save screen size in GIF")
  HELP_TEXT ("Save the screen dimensions in GIF files. If")
  HELP_TEXT ("you want to read these files with Photoshop")
  HELP_TEXT ("or Alchemy, and maybe some other programs,")
  HELP_TEXT ("you must set this option to 'no'.")
  HELP_TEXT ("")
  HELP_BOLD ("  Clear palette")
  HELP_TEXT ("If you load a picture with a palette of less")
  HELP_TEXT ("than 256 colors, this option defines if you")
  HELP_TEXT ("want to clear the palette or to keep the")
  HELP_TEXT ("colors of the previous picture that are over")
  HELP_TEXT ("the number of colors of the new picture.")
  HELP_TEXT ("For example, if you load a 32-color picture,")
  HELP_TEXT ("the colors 32 to 255 will be set to black if")
  HELP_TEXT ("this option is set to 'yes', or they will be")
  HELP_TEXT ("kept unchanged if this option is set to 'no'")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("GUI")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("  Opening message")
  HELP_TEXT ("Display a message at startup telling the")
  HELP_TEXT ("version number of the program.")
  HELP_TEXT ("")
  HELP_BOLD ("  Menu ratio")
  HELP_TEXT ("Aspect ratio and size of the menus and the")
  HELP_TEXT ("tool-bar.")
  HELP_TEXT ("Possible values:")
  HELP_TEXT ("0: Do not adapt (pixels are not stretched)")
  HELP_TEXT ("1: Adapt the menus and the tool-bar")
  HELP_TEXT ("   according to the resolution")
  HELP_TEXT ("2: Slightly adapt the ratio of the menus and")
  HELP_TEXT ("   tool-bar")
  HELP_TEXT ("-1:Do not adapt (like 0)")
  HELP_TEXT ("-2:Stretch by x2 maximum")
  HELP_TEXT ("-3:Stretch by x3 maximum")
  HELP_TEXT ("-4:Stretch by x4 maximum")
  HELP_TEXT ("")
  HELP_BOLD ("  Draw limits")
  HELP_TEXT ("Draw the limits of the picture.")
  HELP_TEXT ("")
  HELP_BOLD ("  Coordinates")
  HELP_TEXT ("Coordinates:")
  HELP_TEXT ("1: Relative")
  HELP_TEXT ("2: Absolute")
  HELP_TEXT ("")
  HELP_BOLD ("  Separate colors")
  HELP_TEXT ("Separate the colors in the tool-bar by a")
  HELP_TEXT ("black squaring.")
  HELP_TEXT ("")
  HELP_BOLD ("  Safety colors")
  HELP_TEXT ("When you reduce the palette or 'zap' some")
  HELP_TEXT ("colors out of it, it is possible that there")
  HELP_TEXT ("are not enough colors left to draw the")
  HELP_TEXT ("menus. Switching the following variable on")
  HELP_TEXT ("will bring back the colors of the menu if")
  HELP_TEXT ("there are less than 4 colors left after")
  HELP_TEXT ("'reducing' or 'zapping'.")
  HELP_TEXT ("")
  HELP_BOLD ("  Grid XOR color")
  HELP_TEXT ("This determines the color value for the")
  HELP_TEXT ("grid. Each pixel of the grid will be")
  HELP_TEXT ("displayed by XOR-ing the original color with")
  HELP_TEXT ("the value of this setting.")
  HELP_TEXT ("For example, if you always paint 16-color")
  HELP_TEXT ("images, you can set it to 16 so the color of")
  HELP_TEXT ("the grid are 16 for 0, 17 for 1, etc. Then")
  HELP_TEXT ("you can set colors 16-31 as lighter/darker")
  HELP_TEXT ("variants of your original palette, resulting")
  HELP_TEXT ("in a pretty grid !")
  HELP_TEXT ("")
  HELP_BOLD ("  Sync views")
  HELP_TEXT ("When this mode is active, scrolling the view")
  HELP_TEXT ("(and the magnifier view) affects both the")
  HELP_TEXT ("main image and the spare page - as long as")
  HELP_TEXT ("they have the same dimensions.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TITLE("INPUT")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("  Gauges scrolling speed Left")
  HELP_TEXT ("Speed of the scroll-bars (in VBLs waited)")
  HELP_TEXT ("while clicking with the left or right button")
  HELP_TEXT ("of the mouse.")
  HELP_TEXT ("Values can be between 1 and 255. The bigger")
  HELP_TEXT ("values, the slower.")
  HELP_TEXT ("")
  HELP_BOLD ("  Gauges scrolling speed Right")
  HELP_TEXT ("Speed of the scroll-bars (in VBLs waited)")
  HELP_TEXT ("while clicking with the left or right button")
  HELP_TEXT ("of the mouse.")
  HELP_TEXT ("Values can be between 1 and 255. The bigger")
  HELP_TEXT ("values, the slower.")
  HELP_TEXT ("")
  HELP_BOLD ("  Merge movement")
  HELP_TEXT ("This setting allows you merge successive")
  HELP_TEXT ("mouse movements into a single mouse")
  HELP_TEXT ("movement. You should only use it if you are")
  HELP_TEXT ("using a mouse which reports at 200Hz or")
  HELP_TEXT ("more, and you experience lag when using")
  HELP_TEXT ("discontinuous hand-drawing with large")
  HELP_TEXT ("brushes (this tool tries to paste the brush")
  HELP_TEXT ("and update the screen on each new mouse")
  HELP_TEXT ("position) In this case, set this to 2 or")
  HELP_TEXT ("more, to ignore some intermediate mouse")
  HELP_TEXT ("reports when a more recent one is present.")
  HELP_TEXT ("Note that with a value superior to 1, you")
  HELP_TEXT ("lose precision with continuous hand-drawing,")
  HELP_TEXT ("as intermediate mouse positions are skipped.")
  HELP_TEXT ("")
  HELP_BOLD ("  Double click speed")
  HELP_TEXT ("This is the time (in milliseconds) between")
  HELP_TEXT ("two clicks for Grafx2 to recognize a")
  HELP_TEXT ("double-click. Double-click is used mostly in")
  HELP_TEXT ("the palette area of the menu: double-click a")
  HELP_TEXT ("color to open the palette.")
  HELP_TEXT ("")
  HELP_BOLD ("  Double key speed")
  HELP_TEXT ("When you press two digit keys in rapid")
  HELP_TEXT ("succession (ex: 3 8), Grafx2 sets")
  HELP_TEXT ("transparency to 38% (instead of 30% then")
  HELP_TEXT ("80%). This setting allows you to set the")
  HELP_TEXT ("maximum delay between two keypresses for")
  HELP_TEXT ("GrafX2 to recognize them as a combo.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("  Swap buttons")
  HELP_TEXT ("This setting determines which key inverts")
  HELP_TEXT ("the mouse buttons when it's held : A left")
  HELP_TEXT ("click is then interpreted as a right-click.")
  HELP_TEXT ("It's especially useful for one-button")
  HELP_TEXT ("controllers, such as touchscreens and")
  HELP_TEXT ("tablets.")
  HELP_TEXT ("")
  HELP_TITLE("EDITING")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_BOLD ("  Adjust brush pick")
  HELP_TEXT ("Adjust the brush grabbing in 'grid' mode.")
  HELP_TEXT ("")
  HELP_BOLD ("  Undo pages")
  HELP_TEXT ("Number of pages stored in memory for")
  HELP_TEXT ("'undoing'.")
  HELP_TEXT ("Values are between 1 and 99.")
  HELP_TEXT ("")
  HELP_BOLD ("  Vertices per polygon")
  HELP_TEXT ("Maximum number of vertices used in filled")
  HELP_TEXT ("polygons and polyforms, and lasso. Possible")
  HELP_TEXT ("values range from 2 to 16384.")
  HELP_TEXT ("")
  HELP_BOLD ("  Fast zoom")
  HELP_TEXT ("Automatically zoom into the pointed area")
  HELP_TEXT ("when you press the short-key of the")
  HELP_TEXT ("Magnifier button while being above the")
  HELP_TEXT ("picture.")
  HELP_TEXT ("")
  HELP_BOLD ("  Clear with stencil")
  HELP_TEXT ("Take the Stencil into account when clearing")
  HELP_TEXT ("the image.")
  HELP_TEXT ("")
  HELP_BOLD ("  Auto discontinuous")
  HELP_TEXT ("Directly set the discontinuous freehand")
  HELP_TEXT ("drawing mode after brush grabbing.")
  HELP_TEXT ("")
  HELP_BOLD ("  Auto nb colors used")
  HELP_TEXT ("Automaticaly count the number of different")
  HELP_TEXT ("colors used when opening the palette editor")
  HELP_TEXT ("window. (Set it to 'no' if you have a slow")
  HELP_TEXT ("computer or if you edit huge pictures)")
  HELP_TEXT ("")
  HELP_BOLD ("  Right click colorpick")  
  HELP_TEXT ("This enables a mode where the right mouse")
  HELP_TEXT ("buttons acts as a color picker until")
  HELP_TEXT ("it's released, and selects Foreground color.")  
  HELP_TEXT ("This mode prevents you from painting with")  
  HELP_TEXT ("Background color.")
  HELP_TEXT ("This option is ignored when the Shade,")
  HELP_TEXT ("Quick-shade, or Tiling mode is used.")    
  HELP_TEXT ("")
  HELP_TEXT ("  Multi shortcuts")
  HELP_TEXT ("When this setting is disabled, and you")
  HELP_TEXT ("create a shortcut with a key that is already")
  HELP_TEXT ("associated to another shortcut, Grafx2 will")
  HELP_TEXT ("unset the latter. If you enable this mode,")
  HELP_TEXT ("Grafx2 will not make such check, so you can")
  HELP_TEXT ("design shortcuts that trigger several")
  HELP_TEXT ("actions at once.")
  HELP_TEXT ("")
};

static const T_Help_table helptable_clear[] =
{

  HELP_TITLE("CLEAR")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_CLEAR)
  HELP_TEXT ("")
  HELP_TEXT ("Clears the picture with the color number 0,")
  HELP_TEXT ("or the transparent color of the picture.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_CLEAR)
  HELP_TEXT ("")
  HELP_TEXT ("Clears the picture with the Back-color.")
};
static const T_Help_table helptable_general[] =
{

  HELP_TITLE("HELP STATS")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_HELP)
  HELP_TEXT ("")
  HELP_TEXT ("Displays an info window where you'll find")
  HELP_TEXT ("some credits, help about the credits,")
  HELP_TEXT ("different effects, greetings, registering...")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_HELP)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a window where you'll find")
  HELP_TEXT ("miscellaneous information about the system.")
  HELP_TEXT (" Note: you should take care to keep more")
  HELP_TEXT ("than 128 Kb in order to let the   program")
  HELP_TEXT ("run in a proper way.")
};
static const T_Help_table helptable_undo[] =
{

  HELP_TITLE("OOPS")
  HELP_TEXT ("(UNDO/REDO)")
  HELP_TEXT ("LEFT CLICK Allows you to undo the last")
  HELP_TEXT ("modification on the picture.")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_UNDO)
  HELP_TEXT ("")
  HELP_TEXT ("RIGHT CLICK Allows you to redo the last")
  HELP_TEXT ("modification undone on the         picture.")
  HELP_TEXT ("The maximum number of UNDO that you can")
  HELP_TEXT ("perform can be defined in the   settings")
  HELP_TEXT ("menu.")
  HELP_TEXT ("Undo/Redo aren't effective after page")
  HELP_TEXT ("switching, picture loading and   picture")
  HELP_TEXT ("size modifications.")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_UNDO)
};
static const T_Help_table helptable_kill[] =
{

  HELP_TITLE("KILL")
  HELP_TEXT ("KILL CURRENT PAGE")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_KILL)
  HELP_TEXT ("")
  HELP_TEXT ("Removes the current page from the list of")
  HELP_TEXT ("\"Undo\" pages. This allows you to free some")
  HELP_TEXT ("memory if you need it. For instance, this")
  HELP_TEXT ("will allow you to delete the start-up page")
  HELP_TEXT ("after having loaded an image. A message will")
  HELP_TEXT ("appear if you've already erased all the")
  HELP_TEXT ("pages except the last one.")
  HELP_TEXT (" Note: Another way to free some memory is to")
  HELP_TEXT ("decrease the number of   \"Undo\" pages. Or")
  HELP_TEXT ("else, if you have recentlt grabbed a very")
  HELP_TEXT ("big   brush that you don't use any more, you")
  HELP_TEXT ("can grab a new smaller one.   The memory")
  HELP_TEXT ("allocated by the big brush will be thus")
  HELP_TEXT ("freed.")
};
static const T_Help_table helptable_quit[] =
{

  HELP_TITLE("QUIT")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_QUIT)
  HELP_TEXT ("")
  HELP_TEXT ("Allows you to leave GrafX2. If there are")
  HELP_TEXT ("unsaved modifications in the current or")
  HELP_TEXT ("spare page, a confirmation box will ask you")
  HELP_TEXT ("if you really want to quit GrafX2, if you")
  HELP_TEXT ("want to save (Auto-save, no fileselector) or")
  HELP_TEXT ("if you want to stay in GrafX2.")
};
static const T_Help_table helptable_palette[] =
{

  HELP_TITLE("PAL MENU")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_PALETTE)
  HELP_TEXT ("")
  HELP_TEXT ("Displays a menu where the following options")
  HELP_TEXT ("are available:")
  HELP_TEXT ("")
  HELP_TEXT ("- Palette: Allows you to choose a")
  HELP_TEXT ("color-block to edit. If you click with the")
  HELP_TEXT ("right mouse button, you'll choose a new")
  HELP_TEXT ("Back-color.")
  HELP_TEXT ("")
  HELP_TEXT ("- Gauges: Allow you to modify the")
  HELP_TEXT ("current selection.")
  HELP_TEXT ("")
  HELP_TEXT ("- RGB or HSL above the gauges: Switches")
  HELP_TEXT ("between RGB and HSL color spaces. In HSL")
  HELP_TEXT ("mode, the three sliders allow you to set the")
  HELP_TEXT ("Hue (tint), Saturation (from grayscale to")
  HELP_TEXT ("pure color) and Lightness (from black to")
  HELP_TEXT ("white).")
  HELP_TEXT ("")
  HELP_TEXT ("- numbers below the gauges: Allows you to")
  HELP_TEXT ("type in a new color in hexadecimal RRGGBB")
  HELP_TEXT ("or RGB: ie. to get blue, you can type either")
  HELP_TEXT ("0000ff or 00f.")
  HELP_TEXT ("")
  HELP_TEXT ("- \"+\" and \"-\": Allow you to lighten or")
  HELP_TEXT ("darken the current selection.")
  HELP_TEXT ("")
  HELP_TEXT ("- Preset: Restores the predefined GrafX2")
  HELP_TEXT ("palette.")
  HELP_TEXT ("")
  HELP_TEXT ("- Gray: Transforms the current selection")
  HELP_TEXT ("into its gray-scaled equivalent.")
  HELP_TEXT ("")
  HELP_TEXT ("- Neg: Transforms the current selection")
  HELP_TEXT ("into its reverse video equivalent.")
  HELP_TEXT ("")
  HELP_TEXT ("- Invert: Swaps the colors of the current")
  HELP_TEXT ("selection so that the first colors become")
  HELP_TEXT ("the last ones.")
  HELP_TEXT ("")
  HELP_TEXT ("- X-Invert: Works as above but modifies the")
  HELP_TEXT ("picture so that it looks the same.")
  HELP_TEXT ("")
  HELP_TEXT ("- Swap: Swaps the current selection with")
  HELP_TEXT ("another color-block. Click on the beginning")
  HELP_TEXT ("of the new color-block.")
  HELP_TEXT ("")
  HELP_TEXT ("- X-Swap: Works as above but modifies the")
  HELP_TEXT ("picture so that it looks the same. This may")
  HELP_TEXT ("be useful if you want to sort your palette.")
  HELP_TEXT ("")
  HELP_TEXT ("- Copy: Copies the current selection to")
  HELP_TEXT ("another color-block. Click on the beginning")
  HELP_TEXT ("of the new color-block.")
  HELP_TEXT ("")
  HELP_TEXT ("- Spread: Computes a gradation between two")
  HELP_TEXT ("colors. If your selection is only made up of")
  HELP_TEXT ("one color, select the second color in the")
  HELP_TEXT ("palette. Otherwise, the two colors used will")
  HELP_TEXT ("be its extremities.")
  HELP_TEXT ("")
  HELP_TEXT ("- Sort: sorts the palette by color ranges.")
  HELP_TEXT ("If you click with the left mouse button, it")
  HELP_TEXT ("will sort by H S L; and if you click with")
  HELP_TEXT ("the right mouse button, it will sort by L")
  HELP_TEXT ("only. Note that you can choose a range of")
  HELP_TEXT ("colors before sorting, and instead of the")
  HELP_TEXT ("whole palette it will sort this range.")
  HELP_TEXT ("")
  HELP_TEXT ("- Used: Indicates the number of colors used")
  HELP_TEXT ("in the picture and opens a histogram screen.")
  HELP_TEXT ("")
  HELP_TEXT ("- Zap unused: Erases the unused colors with")
  HELP_TEXT ("copies of the current selection. (The")
  HELP_TEXT ("keyboard shortcut for this button is <Del>).")
  HELP_TEXT ("")
  HELP_TEXT ("- Reduce: Allows you to reduce the palette")
  HELP_TEXT ("to the number of colors you want (and")
  HELP_TEXT ("modifies the picture).")
  HELP_TEXT ("")
  HELP_TEXT ("- Undo: Allows you to recover the last")
  HELP_TEXT ("modifications made on the palette. Note that")
  HELP_TEXT ("it can't undo the changes that affect the")
  HELP_TEXT ("pixels (remapping), you'll need to Cancel")
  HELP_TEXT ("them.")
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("If you press <Backspace>, the program will")
  HELP_TEXT ("replace, as well as possible, some unused")
  HELP_TEXT ("colors by the four default colors of the")
  HELP_TEXT ("menu. The image won't look altered because")
  HELP_TEXT ("the modified colors (in the case they were")
  HELP_TEXT ("used on a few points) will be replaced by")
  HELP_TEXT ("the closest colors in the rest of the")
  HELP_TEXT ("palette. This option is really useful when")
  HELP_TEXT ("you modify the palette so that there are no")
  HELP_TEXT ("colors that fit for the menu (eg: \"Zap")
  HELP_TEXT ("unused\" while very little colors are used in")
  HELP_TEXT ("the picture; or \"Reduce\" with a very small")
  HELP_TEXT ("number of colors).")
  HELP_TEXT ("")
  HELP_TEXT ("If you press the key below <Escape> or <,>")
  HELP_TEXT ("(QWERTY), the menu will disappear and you")
  HELP_TEXT ("will be able to pick up a color from the")
  HELP_TEXT ("picture easily. Press <Escape> to cancel.")
  HELP_TEXT ("")
  HELP_TEXT ("If only one color is selected (not a block),")
  HELP_TEXT ("the <[> and <]> keys can be used to select")
  HELP_TEXT ("the previous or next Forecolor (Backcolor if")
  HELP_TEXT ("you press <Shift> at the same time).")
  HELP_TEXT ("")
  HELP_TEXT ("Warning! If you press Undo after an action")
  HELP_TEXT ("that modifies the picture (X-Swap, X-Invert")
  HELP_TEXT ("and Reduce colors), the picture won't be")
  HELP_TEXT ("remapped as it was just before this action.")
  HELP_TEXT ("Only Cancel will.")
  HELP_TEXT ("")
  HELP_TITLE("PALETTE OPTIONS")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_LINK ("(Key:%s)",0x200+BUTTON_PALETTE)
  HELP_TEXT ("")
  HELP_TEXT ("Opens a menu from where you have the")
  HELP_TEXT ("following options:")
  HELP_TEXT ("")
  HELP_TEXT ("- Colors for best match:")
  HELP_TEXT ("A menu in which you can select the colors")
  HELP_TEXT ("that have not to be used for smoothing, for")
  HELP_TEXT ("the transparency mode, and for remapping.")
  HELP_TEXT ("")
  HELP_TEXT ("- User's color series:")
  HELP_TEXT ("A menu in which you can define color series")
  HELP_TEXT ("for next/previous user color shortcuts.")
  HELP_TEXT ("It's the same settings than the shade mode.")
  HELP_TEXT ("After you have some color ranges defined in")
  HELP_TEXT ("this screen, you can use those shortcuts to")
  HELP_TEXT ("move to the next or previous color according")
  HELP_TEXT ("to your ranges:")
  HELP_TEXT ("")
  HELP_TEXT ("Foreground color")
  HELP_TEXT ("")
  HELP_LINK ("  Next    : %s",   SPECIAL_NEXT_USER_FORECOLOR)
  HELP_LINK ("  Previous: %s",   SPECIAL_PREVIOUS_USER_FORECOLOR)
  HELP_TEXT ("")
  HELP_TEXT ("Background color")
  HELP_LINK ("  Next    : %s",   SPECIAL_NEXT_USER_BACKCOLOR)
  HELP_LINK ("  Previous: %s",   SPECIAL_PREVIOUS_USER_BACKCOLOR)
  HELP_TEXT ("")
  HELP_TEXT ("")
  HELP_TEXT ("- Palette layout:")
  HELP_TEXT ("Lets you customize the palette that appears")
  HELP_TEXT ("on the right of the menu. You can choose the")
  HELP_TEXT ("number of lines and columns.")
  HELP_TEXT ("If you want the colors to run top to bottom,")
  HELP_TEXT ("check the 'Vertical' button, otherwise the")
  HELP_TEXT ("colors runs left to right.")
  HELP_TEXT ("")
  HELP_TEXT ("- RGB Scale:")
  HELP_TEXT ("Lets you set the scale of the R G B sliders")
  HELP_TEXT ("in the palette screen. You should normally")
  HELP_TEXT ("leave it at 256 to get the full 0-255 range,")
  HELP_TEXT ("but if you want to constrain the palette")
  HELP_TEXT ("to the capabilities of some specific")
  HELP_TEXT ("computers and consoles, you can choose eg:")
  HELP_TEXT ("   64 : VGA")
  HELP_TEXT ("   16 : Amiga")
  HELP_TEXT ("    4 : MSX2")
  HELP_TEXT ("    2 : Amstrad CPC")
  };
static const T_Help_table helptable_pal_scroll[] =
{

  HELP_TITLE("SCROLL PAL")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("Scrolls the palette window in the right of")
  HELP_TEXT ("the menu.")
  HELP_LINK ("Key for back:    %s",   0x100+BUTTON_PAL_LEFT)
  HELP_LINK ("Key for forward: %s",   0x100+BUTTON_PAL_RIGHT)
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("Same as above, but faster.")
  HELP_LINK ("Key for back:    %s",   0x200+BUTTON_PAL_LEFT)
  HELP_LINK ("Key for forward: %s",   0x200+BUTTON_PAL_RIGHT)
  HELP_TEXT ("")
};
static const T_Help_table helptable_color_select[] =
{

  HELP_TITLE("PALETTE")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("Defines the Fore-color.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("Defines the Back-color.")
};
static const T_Help_table helptable_hide[] =
{

  HELP_TITLE("HIDE MENU")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_HIDE)
  HELP_TEXT ("")
  HELP_TEXT ("Allows you to hide all toolbars, leaving")
  HELP_TEXT ("only the status bar.")
  HELP_TEXT ("Click again to show them again.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("Opens a drop-down menu where you can choose")
  HELP_TEXT ("Which toolbars are going to be visible in")
  HELP_TEXT ("the menu.")

};

static const T_Help_table helptable_layermenu[] =
{

  HELP_TITLE("LAYERS MENU")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_LAYER_MENU)
  HELP_TEXT ("")
  HELP_TEXT ("In this menu you can set the following")
  HELP_TEXT ("options:")
  HELP_TEXT ("")
  HELP_TEXT ("* Transparent color : This determines which")
  HELP_TEXT ("color index is considered transparent when")
  HELP_TEXT ("using layers. Click the button and then")
  HELP_TEXT ("click on the image to pick the right color,")
  HELP_TEXT ("or use ESC to cancel.")
  HELP_TEXT ("")
  HELP_TEXT ("* Transparent background : When this option")
  HELP_TEXT ("is checked, all pixels of the transparent")
  HELP_TEXT ("color on layer 1 (background layer) will")
  HELP_TEXT ("be tagged as transparent in the final image.")
  HELP_TEXT ("Check this option if you want to make a")
  HELP_TEXT ("transparent GIF or PNG. These are the only")
  HELP_TEXT ("file formats that support this option.")

};
static const T_Help_table helptable_layertrans[] =
{

  HELP_TITLE("LAYERS TRANSPARENCY")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("Sets the transparent color as background pen")
  HELP_TEXT ("color.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("The current Background color becomes the")
  HELP_TEXT ("color considered transparent for the layers.")
  
};
static const T_Help_table helptable_layermerge[] =
{

  HELP_TITLE("LAYERS MERGE")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_LAYER_MERGE)
  HELP_TEXT ("")
  HELP_TEXT ("Merges the current layer with the one below")
  HELP_TEXT ("it, and sets the resulting layer as current")
  HELP_TEXT ("one for editing.")
  HELP_TEXT ("This function has no effect if you're")
  HELP_TEXT ("editing the lowest layer.")
};
static const T_Help_table helptable_layeradd[] =
{

  HELP_TITLE("ADD LAYER")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_LAYER_ADD)
  HELP_TEXT ("")
  HELP_TEXT ("Add a new layer above the current one,")
  HELP_TEXT ("and selects this new (empty) layer for")
  HELP_TEXT ("editing.")

};
static const T_Help_table helptable_layerdel[] =
{

  HELP_TITLE("DROP LAYER")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_LAYER_REMOVE)
  HELP_TEXT ("")
  HELP_TEXT ("Deletes the current layer.")

};
static const T_Help_table helptable_layerup[] =
{

  HELP_TITLE("MOVE LAYER UP")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_LAYER_UP)
  HELP_TEXT ("")
  HELP_TEXT ("Swaps the current layer with the one")
  HELP_TEXT ("above it. This has no effect if this")
  HELP_TEXT ("layer is already on top.")

};
static const T_Help_table helptable_layerdown[] =
{

  HELP_TITLE("MOVE LAYER DOWN")
  HELP_TEXT ("")
  HELP_LINK ("(Key:%s)",0x100+BUTTON_LAYER_DOWN)
  HELP_TEXT ("")
  HELP_TEXT ("Swaps the current layer with the one")
  HELP_TEXT ("below it. This has no effect if this")
  HELP_TEXT ("layer is already on the bottom.")
};
static const T_Help_table helptable_layerselect[] =
{

  HELP_TITLE("LAYER SELECTION")
  HELP_TEXT ("")
  HELP_BOLD ("LEFT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("Choose a layer as the current one for")
  HELP_TEXT ("drawing.")
  HELP_TEXT ("")
  HELP_BOLD ("RIGHT CLICK")
  HELP_TEXT ("")
  HELP_TEXT ("Makes a layer visible or invisible.")
  HELP_TEXT ("If you click the current layer, this toggles")
  HELP_TEXT ("the visibility of all other layers instead.")
};
#define HELP_TABLE_DECLARATION(x) {x, sizeof(x)/sizeof(const T_Help_table)},

T_Help_section Help_section[] =
{
  HELP_TABLE_DECLARATION(helptable_about)
  HELP_TABLE_DECLARATION(helptable_licence)
  HELP_TABLE_DECLARATION(helptable_help)
  HELP_TABLE_DECLARATION(helptable_credits)

  // Attention, keep the same order as BUTTON_NUMBERS:
  HELP_TABLE_DECLARATION(helptable_hide)
  HELP_TABLE_DECLARATION(helptable_layermenu)
  HELP_TABLE_DECLARATION(helptable_layertrans)
  HELP_TABLE_DECLARATION(helptable_layermerge)
  HELP_TABLE_DECLARATION(helptable_layeradd)
  HELP_TABLE_DECLARATION(helptable_layerdel)
  HELP_TABLE_DECLARATION(helptable_layerup)
  HELP_TABLE_DECLARATION(helptable_layerdown)
  HELP_TABLE_DECLARATION(helptable_layerselect)
  HELP_TABLE_DECLARATION(helptable_paintbrush)
  HELP_TABLE_DECLARATION(helptable_adjust)
  HELP_TABLE_DECLARATION(helptable_draw)
  HELP_TABLE_DECLARATION(helptable_curves)
  HELP_TABLE_DECLARATION(helptable_lines)
  HELP_TABLE_DECLARATION(helptable_airbrush)
  HELP_TABLE_DECLARATION(helptable_floodfill)
  HELP_TABLE_DECLARATION(helptable_polygons)
  HELP_TABLE_DECLARATION(helptable_polyfill)
  HELP_TABLE_DECLARATION(helptable_rectangles)
  HELP_TABLE_DECLARATION(helptable_filled_rectangles)
  HELP_TABLE_DECLARATION(helptable_circles)
  HELP_TABLE_DECLARATION(helptable_filled_circles)
  HELP_TABLE_DECLARATION(helptable_grad_rect)
  HELP_TABLE_DECLARATION(helptable_spheres)
  HELP_TABLE_DECLARATION(helptable_brush)
  HELP_TABLE_DECLARATION(helptable_polybrush)
  HELP_TABLE_DECLARATION(helptable_brush_fx)
  HELP_TABLE_DECLARATION(helptable_effects)
  HELP_TABLE_DECLARATION(helptable_text)
  HELP_TABLE_DECLARATION(helptable_magnifier)
  HELP_TABLE_DECLARATION(helptable_colorpicker)
  HELP_TABLE_DECLARATION(helptable_resolution)
  HELP_TABLE_DECLARATION(helptable_page)
  HELP_TABLE_DECLARATION(helptable_save)
  HELP_TABLE_DECLARATION(helptable_load)
  HELP_TABLE_DECLARATION(helptable_settings)
  HELP_TABLE_DECLARATION(helptable_clear)
  HELP_TABLE_DECLARATION(helptable_general)
  HELP_TABLE_DECLARATION(helptable_undo)
  HELP_TABLE_DECLARATION(helptable_kill)
  HELP_TABLE_DECLARATION(helptable_quit)
  HELP_TABLE_DECLARATION(helptable_palette)
  HELP_TABLE_DECLARATION(helptable_pal_scroll)
  HELP_TABLE_DECLARATION(helptable_pal_scroll)
  HELP_TABLE_DECLARATION(helptable_color_select)
  // End of buttons list
  
  // NB_BUTTONS+0
  HELP_TABLE_DECLARATION(helptable_settings_details)
  // NB_BUTTONS+1
  // HELP_TABLE_DECLARATION()
  // NB_BUTTONS+2
  // HELP_TABLE_DECLARATION()
  // ...
  
};
