/* vim:expandtab:ts=2 sw=2:
*/
/*  Grafx2 - The Ultimate 256-color bitmap paint program

	Copyright owned by various GrafX2 authors, see COPYRIGHT.txt for details.

    Grafx2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; version 2
    of the License.

    Grafx2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Grafx2; if not, see <http://www.gnu.org/licenses/>
*/
#ifndef GFX2MEM_H_DEFINED
#define GFX2MEM_H_DEFINED

/// malloc() memory and log in case of error
void * GFX2_malloc_and_log(size_t size, const char * file, unsigned line);

/// malloc() memory and log in case of error
#define GFX2_malloc(size) GFX2_malloc_and_log((size), __FILE__, __LINE__)

/// checks if a memory zone is filled with the same byte value
int GFX2_is_mem_filled_with(const void * p, unsigned char b, size_t len);

#endif
