#
# This file is part of the GROMACS molecular simulation package.
#
# Copyright (c) 2019, by the GROMACS development team, led by
# Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
# and including many others, as listed in the AUTHORS file in the
# top-level source directory and at http://www.gromacs.org.
#
# GROMACS is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.
#
# GROMACS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with GROMACS; if not, see
# http://www.gnu.org/licenses, or write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
#
# If you want to redistribute modifications to GROMACS, please
# consider that scientific software is very special. Version
# control is crucial - bugs must be traceable. We will be happy to
# consider code for inclusion in the official distribution, but
# derived work must not be called official GROMACS. Details are found
# in the README & COPYING files - if they are missing, get the
# official version at http://www.gromacs.org.
#
# To help us fund GROMACS development, we humbly ask that you cite
# the research papers on the package. Check out http://www.gromacs.org.

def do_build(context):
    context.env.set_env_var('CLANG_FORMAT', context.env.get_clang_format_command('7'))
    clangformat_log = context.workspace.get_path_for_logfile('clang-format.log', category='clang-format')
    cmd = ['admin/clang-format.sh', 'update', '--rev=HEAD^', '--warnings=' + clangformat_log]
    ret = context.run_cmd(cmd, use_return_code=True)
    if ret == 1:
        with open(clangformat_log, 'r') as f:
            warnings = f.readlines()
        if len(warnings) <= 5:
            details = [x.rstrip() for x in warnings]
        else:
            format_count = 0
            for w in warnings:
                if 'clang-format performed' in w:
                    format_count += 1
            details = []
            if format_count > 0:
                details.append('fixed formatting issues in {0} files'.format(format_count))
    elif ret != 0:
        raise BuildError('clang-format.sh failed to run')

    context.workspace.upload_revision(project=Project.GROMACS, file_glob='*')
