//**************************************************************************************************
//                                          SimnBase.hpp                                           *
//                                         --------------                                          *
// Description : This class is the base class for all simulation classes.                          *
// Started     : 2008-05-01                                                                        *
// Last Update : 2015-04-09                                                                        *
// Copyright   : (C) 2008 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef SIMNBASE_HPP
#define SIMNBASE_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "CmdBase.hpp"
#include "netlist/NetList.hpp"
#include "utility/CnvtType.hpp"

//**************************************************************************************************

class SimnBase : public NetList
{
  protected :

    // Attribute to identify the simulation engine type
    eTypeSimEng    m_eSimEng;

    // Error message generated by bValidate( )
    wxString       m_osErrMsg;

    // Function to extract information from the circuit description
    virtual  bool  bLoadSimEng ( void ) = 0;
    virtual  bool  bLoadSimCmds( void ) = 0;
    virtual  bool  bLoadSigSrc ( void );

    // Functions to save the circuit description to file
             bool  bSaveSigSrc ( void );

  public :

    // The signal source component
    Component      m_oCpntSwpSrc;

                   SimnBase( void );
    virtual       ~SimnBase( );

    virtual  bool  bClear     ( void );
    virtual  bool  bClrCmds   ( void ) = 0;
    virtual  bool  bClrTstPts ( void ) = 0;

    virtual  bool  bValidate  ( void );
    virtual  bool  bIsValid   ( void )  { return( NetList::bIsValid( ) && m_osErrMsg.IsEmpty( ) ); }

    virtual  bool  bLoad      ( void );
    virtual  bool  bSave      ( void );

    virtual  bool  bSetAnaType( eTypeCmd eAnaType ) = 0;
             void   SetErrMsg ( const wxString & rosErrMsg ) { if(bIsValid()) m_osErrMsg=rosErrMsg;}

    virtual  bool  bAddTstNode( const wxString & rosNode ) = 0;
    virtual  bool  bAddTstCpnt( const wxString & rosCpnt ) = 0;

                   eTypeSimEng        eGetSimEng  ( void ) const { return( m_eSimEng ); }
    virtual        eTypeCmd           eGetAnaType ( void ) const = 0;
    virtual  const wxArrayString & rosaGetTstNodes( void ) const = 0;
    virtual  const wxArrayString & rosaGetTstCpnts( void ) const = 0;
             const wxString &       rosGetErrMsg  ( void ) const { return( m_osErrMsg ); }

    SimnBase & operator = ( const SimnBase & roSimn );

    virtual  void  Print( const wxString & rosPrefix=wxT("  ") );
};

//**************************************************************************************************

#endif // SIMNBASE_HPP
