/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ObjectArraysTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAppendOneElement() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testAppendOneElement();
}

public void testAppendTwoElements() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testAppendTwoElements();
}

public void testAppendZeroElements() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testAppendZeroElements();
}

public void testEmptyArrayToEmpty() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testEmptyArrayToEmpty();
}

public void testEmptyArrayToNonEmpty() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testEmptyArrayToNonEmpty();
}

public void testNewArray_fromArray_Empty() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testNewArray_fromArray_Empty();
}

public void testNewArray_fromArray_Nonempty() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testNewArray_fromArray_Nonempty();
}

public void testNewArray_fromArray_OfArray() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testNewArray_fromArray_OfArray();
}

public void testNonEmptyToLonger() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testNonEmptyToLonger();
}

public void testNonEmptyToSameLength() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testNonEmptyToSameLength();
}

public void testNonEmptyToShorter() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testNonEmptyToShorter();
}

public void testPrependOneElement() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testPrependOneElement();
}

public void testPrependTwoElements() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testPrependTwoElements();
}

public void testPrependZeroElements() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testPrependZeroElements();
}

public void testToArrayImpl1() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testToArrayImpl1();
}

public void testToArrayImpl2() throws Exception {
  com.google.common.collect.ObjectArraysTest testCase = new com.google.common.collect.ObjectArraysTest();
  testCase.testToArrayImpl2();
}
}
