/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.testing;
public class EqualsTesterTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.testing.testModule";
}
public void testAddEqualObjectWithOArgConstructor() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testAddEqualObjectWithOArgConstructor();
}

public void testAddNullEqualObject() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testAddNullEqualObject();
}

public void testAddNullReference() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testAddNullReference();
}

public void testAddTwoEqualObjectsAtOnceWithNull() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testAddTwoEqualObjectsAtOnceWithNull();
}

public void testEqualityGroups() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testEqualityGroups();
}

public void testInvalidEqualsIncompatibleClass() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testInvalidEqualsIncompatibleClass();
}

public void testInvalidEqualsNull() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testInvalidEqualsNull();
}

public void testInvalidHashCode() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testInvalidHashCode();
}

public void testInvalidNotEqualsEqualObject() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testInvalidNotEqualsEqualObject();
}

public void testNonreflexiveEquals() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testNonreflexiveEquals();
}

public void testNullEqualityGroup() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testNullEqualityGroup();
}

public void testNullObjectInEqualityGroup() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testNullObjectInEqualityGroup();
}

public void testSymmetryBroken() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testSymmetryBroken();
}

public void testTestEqualsEmptyLists() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testTestEqualsEmptyLists();
}

public void testTestEqualsEqualsObjects() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testTestEqualsEqualsObjects();
}

public void testTransitivityBrokenAcrossEqualityGroups() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testTransitivityBrokenAcrossEqualityGroups();
}

public void testTransitivityBrokenInEqualityGroup() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testTransitivityBrokenInEqualityGroup();
}

public void testUnequalObjectsInEqualityGroup() throws Exception {
  com.google.common.testing.EqualsTesterTest testCase = new com.google.common.testing.EqualsTesterTest();
  testCase.setUp();
  testCase.testUnequalObjectsInEqualityGroup();
}
}
