;; guile-gnome
;; Copyright (C) 2003,2004,2007 Andy Wingo <wingo at pobox dot com>

;; This program is free software; you can redistribute it and/or    
;; modify it under the terms of the GNU General Public License as   
;; published by the Free Software Foundation; either version 2 of   
;; the License, or (at your option) any later version.              
;;                                                                  
;; This program is distributed in the hope that it will be useful,  
;; but WITHOUT ANY WARRANTY; without even the implied warranty of   
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    
;; GNU General Public License for more details.                     
;;                                                                  
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, contact:
;;
;; Free Software Foundation           Voice:  +1-617-542-5942
;; 59 Temple Place - Suite 330        Fax:    +1-617-542-2652
;; Boston, MA  02111-1307,  USA       gnu@gnu.org

;;; Commentary:
;;
;;GdkEvent wrapper functions and keyvals.
;;
;;; Code:

(define-module (gnome gtk gdk-event)
  #:use-module (gnome gw gdk)
  #:use-module (gnome gobject)
  #:use-module (oop goops))

(define-public (gdk-event:type event)
  (let ((vector (gdk-event->vector event)))
    (if vector
        (genum->symbol
         (make <gdk-event-type>
           #:value (vector-ref vector 0)))
        #f))) ;; #f can happen if gdk-support.c needs some work...

(define-macro (define-gdk-event-accessor types kind name index code)
  (define (symbol-append . args)
    (string->symbol (apply string-append (map symbol->string args))))
  `(define-public (,(symbol-append 'gdk-event- kind (string->symbol ":") name) event)
     (let ((vector (gdk-event->vector event)))
       (case (gdk-event:type event)
         (,types (let ((val (vector-ref vector ,index)))
                   ,code))
         (else (gruntime-error "Event not of the proper type: ~A" event))))))

(define-gdk-event-accessor (key-press key-release) key modifiers 4
  (gflags->symbol-list
   ;; We have to do some hackery here, because there are bitmasks
   ;; used by XKB that we don't know about.
   (make <gdk-modifier-type> #:value (logand #x1fff val))))
(define-gdk-event-accessor (key-press key-release) key keyval 5
  val)

(define-gdk-event-accessor (selection-notify selection-clear selection-request)
  selection selection 3
  (string->symbol val))
   
(define-gdk-event-accessor (button-press button-release
                            2button-press 2button-release
                            3button-press 3button-release) button time 3
  val)
(define-gdk-event-accessor (button-press button-release
                            2button-press 2button-release
                            3button-press 3button-release) button x 4
  val)
(define-gdk-event-accessor (button-press button-release
                            2button-press 2button-release
                            3button-press 3button-release) button y 5
  val)
(define-gdk-event-accessor (button-press button-release
                            2button-press 2button-release
                            3button-press 3button-release) button modifiers 6
  (gflags->symbol-list (make <gdk-modifier-type> #:value val)))
(define-gdk-event-accessor (button-press button-release
                            2button-press 2button-release
                            3button-press 3button-release) button button 7
  val)
(define-gdk-event-accessor (button-press button-release
                            2button-press 2button-release
                            3button-press 3button-release) button x-root 9
  val)
(define-gdk-event-accessor (button-press button-release
                            2button-press 2button-release
                            3button-press 3button-release) button y-root 10
  val)

(define-gdk-event-accessor (motion-notify) motion modifiers 6
  (gflags->symbol-list (make <gdk-modifier-type> #:value val)))
(define-gdk-event-accessor (motion-notify) motion x 4
  val)
(define-gdk-event-accessor (motion-notify) motion y 5
  val)

(define-gdk-event-accessor (window-state) window-state changed-mask 3
  (gflags->symbol-list (make <gdk-window-state> #:value val)))
(define-gdk-event-accessor (window-state) window-state new-window-state 4
  (gflags->symbol-list (make <gdk-window-state> #:value val)))

(define-gdk-event-accessor (expose) expose area 3
  val)


;;
;; Update this list with the following bit of perl:
;; perl -p -e 's/#define GDK_/(define-public gdk:/; s/_/-/g; s/0x/#x/; s/$/)/;' \
;;  < /usr/include/gtk-2.0/gdk/gdkkeysyms.h
;;

(define-public gdk:VoidSymbol #xFFFFFF)
(define-public gdk:BackSpace #xFF08)
(define-public gdk:Tab #xFF09)
(define-public gdk:Linefeed #xFF0A)
(define-public gdk:Clear #xFF0B)
(define-public gdk:Return #xFF0D)
(define-public gdk:Pause #xFF13)
(define-public gdk:Scroll-Lock #xFF14)
(define-public gdk:Sys-Req #xFF15)
(define-public gdk:Escape #xFF1B)
(define-public gdk:Delete #xFFFF)
(define-public gdk:Multi-key #xFF20)
(define-public gdk:Codeinput #xFF37)
(define-public gdk:SingleCandidate #xFF3C)
(define-public gdk:MultipleCandidate #xFF3D)
(define-public gdk:PreviousCandidate #xFF3E)
(define-public gdk:Kanji #xFF21)
(define-public gdk:Muhenkan #xFF22)
(define-public gdk:Henkan-Mode #xFF23)
(define-public gdk:Henkan #xFF23)
(define-public gdk:Romaji #xFF24)
(define-public gdk:Hiragana #xFF25)
(define-public gdk:Katakana #xFF26)
(define-public gdk:Hiragana-Katakana #xFF27)
(define-public gdk:Zenkaku #xFF28)
(define-public gdk:Hankaku #xFF29)
(define-public gdk:Zenkaku-Hankaku #xFF2A)
(define-public gdk:Touroku #xFF2B)
(define-public gdk:Massyo #xFF2C)
(define-public gdk:Kana-Lock #xFF2D)
(define-public gdk:Kana-Shift #xFF2E)
(define-public gdk:Eisu-Shift #xFF2F)
(define-public gdk:Eisu-toggle #xFF30)
(define-public gdk:Kanji-Bangou #xFF37)
(define-public gdk:Zen-Koho #xFF3D)
(define-public gdk:Mae-Koho #xFF3E)
(define-public gdk:Home #xFF50)
(define-public gdk:Left #xFF51)
(define-public gdk:Up #xFF52)
(define-public gdk:Right #xFF53)
(define-public gdk:Down #xFF54)
(define-public gdk:Prior #xFF55)
(define-public gdk:Page-Up #xFF55)
(define-public gdk:Next #xFF56)
(define-public gdk:Page-Down #xFF56)
(define-public gdk:End #xFF57)
(define-public gdk:Begin #xFF58)
(define-public gdk:Select #xFF60)
(define-public gdk:Print #xFF61)
(define-public gdk:Execute #xFF62)
(define-public gdk:Insert #xFF63)
(define-public gdk:Undo #xFF65)
(define-public gdk:Redo #xFF66)
(define-public gdk:Menu #xFF67)
(define-public gdk:Find #xFF68)
(define-public gdk:Cancel #xFF69)
(define-public gdk:Help #xFF6A)
(define-public gdk:Break #xFF6B)
(define-public gdk:Mode-switch #xFF7E)
(define-public gdk:script-switch #xFF7E)
(define-public gdk:Num-Lock #xFF7F)
(define-public gdk:KP-Space #xFF80)
(define-public gdk:KP-Tab #xFF89)
(define-public gdk:KP-Enter #xFF8D)
(define-public gdk:KP-F1 #xFF91)
(define-public gdk:KP-F2 #xFF92)
(define-public gdk:KP-F3 #xFF93)
(define-public gdk:KP-F4 #xFF94)
(define-public gdk:KP-Home #xFF95)
(define-public gdk:KP-Left #xFF96)
(define-public gdk:KP-Up #xFF97)
(define-public gdk:KP-Right #xFF98)
(define-public gdk:KP-Down #xFF99)
(define-public gdk:KP-Prior #xFF9A)
(define-public gdk:KP-Page-Up #xFF9A)
(define-public gdk:KP-Next #xFF9B)
(define-public gdk:KP-Page-Down #xFF9B)
(define-public gdk:KP-End #xFF9C)
(define-public gdk:KP-Begin #xFF9D)
(define-public gdk:KP-Insert #xFF9E)
(define-public gdk:KP-Delete #xFF9F)
(define-public gdk:KP-Equal #xFFBD)
(define-public gdk:KP-Multiply #xFFAA)
(define-public gdk:KP-Add #xFFAB)
(define-public gdk:KP-Separator #xFFAC)
(define-public gdk:KP-Subtract #xFFAD)
(define-public gdk:KP-Decimal #xFFAE)
(define-public gdk:KP-Divide #xFFAF)
(define-public gdk:KP-0 #xFFB0)
(define-public gdk:KP-1 #xFFB1)
(define-public gdk:KP-2 #xFFB2)
(define-public gdk:KP-3 #xFFB3)
(define-public gdk:KP-4 #xFFB4)
(define-public gdk:KP-5 #xFFB5)
(define-public gdk:KP-6 #xFFB6)
(define-public gdk:KP-7 #xFFB7)
(define-public gdk:KP-8 #xFFB8)
(define-public gdk:KP-9 #xFFB9)
(define-public gdk:F1 #xFFBE)
(define-public gdk:F2 #xFFBF)
(define-public gdk:F3 #xFFC0)
(define-public gdk:F4 #xFFC1)
(define-public gdk:F5 #xFFC2)
(define-public gdk:F6 #xFFC3)
(define-public gdk:F7 #xFFC4)
(define-public gdk:F8 #xFFC5)
(define-public gdk:F9 #xFFC6)
(define-public gdk:F10 #xFFC7)
(define-public gdk:F11 #xFFC8)
(define-public gdk:L1 #xFFC8)
(define-public gdk:F12 #xFFC9)
(define-public gdk:L2 #xFFC9)
(define-public gdk:F13 #xFFCA)
(define-public gdk:L3 #xFFCA)
(define-public gdk:F14 #xFFCB)
(define-public gdk:L4 #xFFCB)
(define-public gdk:F15 #xFFCC)
(define-public gdk:L5 #xFFCC)
(define-public gdk:F16 #xFFCD)
(define-public gdk:L6 #xFFCD)
(define-public gdk:F17 #xFFCE)
(define-public gdk:L7 #xFFCE)
(define-public gdk:F18 #xFFCF)
(define-public gdk:L8 #xFFCF)
(define-public gdk:F19 #xFFD0)
(define-public gdk:L9 #xFFD0)
(define-public gdk:F20 #xFFD1)
(define-public gdk:L10 #xFFD1)
(define-public gdk:F21 #xFFD2)
(define-public gdk:R1 #xFFD2)
(define-public gdk:F22 #xFFD3)
(define-public gdk:R2 #xFFD3)
(define-public gdk:F23 #xFFD4)
(define-public gdk:R3 #xFFD4)
(define-public gdk:F24 #xFFD5)
(define-public gdk:R4 #xFFD5)
(define-public gdk:F25 #xFFD6)
(define-public gdk:R5 #xFFD6)
(define-public gdk:F26 #xFFD7)
(define-public gdk:R6 #xFFD7)
(define-public gdk:F27 #xFFD8)
(define-public gdk:R7 #xFFD8)
(define-public gdk:F28 #xFFD9)
(define-public gdk:R8 #xFFD9)
(define-public gdk:F29 #xFFDA)
(define-public gdk:R9 #xFFDA)
(define-public gdk:F30 #xFFDB)
(define-public gdk:R10 #xFFDB)
(define-public gdk:F31 #xFFDC)
(define-public gdk:R11 #xFFDC)
(define-public gdk:F32 #xFFDD)
(define-public gdk:R12 #xFFDD)
(define-public gdk:F33 #xFFDE)
(define-public gdk:R13 #xFFDE)
(define-public gdk:F34 #xFFDF)
(define-public gdk:R14 #xFFDF)
(define-public gdk:F35 #xFFE0)
(define-public gdk:R15 #xFFE0)
(define-public gdk:Shift-L #xFFE1)
(define-public gdk:Shift-R #xFFE2)
(define-public gdk:Control-L #xFFE3)
(define-public gdk:Control-R #xFFE4)
(define-public gdk:Caps-Lock #xFFE5)
(define-public gdk:Shift-Lock #xFFE6)
(define-public gdk:Meta-L #xFFE7)
(define-public gdk:Meta-R #xFFE8)
(define-public gdk:Alt-L #xFFE9)
(define-public gdk:Alt-R #xFFEA)
(define-public gdk:Super-L #xFFEB)
(define-public gdk:Super-R #xFFEC)
(define-public gdk:Hyper-L #xFFED)
(define-public gdk:Hyper-R #xFFEE)
(define-public gdk:ISO-Lock #xFE01)
(define-public gdk:ISO-Level2-Latch #xFE02)
(define-public gdk:ISO-Level3-Shift #xFE03)
(define-public gdk:ISO-Level3-Latch #xFE04)
(define-public gdk:ISO-Level3-Lock #xFE05)
(define-public gdk:ISO-Group-Shift #xFF7E)
(define-public gdk:ISO-Group-Latch #xFE06)
(define-public gdk:ISO-Group-Lock #xFE07)
(define-public gdk:ISO-Next-Group #xFE08)
(define-public gdk:ISO-Next-Group-Lock #xFE09)
(define-public gdk:ISO-Prev-Group #xFE0A)
(define-public gdk:ISO-Prev-Group-Lock #xFE0B)
(define-public gdk:ISO-First-Group #xFE0C)
(define-public gdk:ISO-First-Group-Lock #xFE0D)
(define-public gdk:ISO-Last-Group #xFE0E)
(define-public gdk:ISO-Last-Group-Lock #xFE0F)
(define-public gdk:ISO-Left-Tab #xFE20)
(define-public gdk:ISO-Move-Line-Up #xFE21)
(define-public gdk:ISO-Move-Line-Down #xFE22)
(define-public gdk:ISO-Partial-Line-Up #xFE23)
(define-public gdk:ISO-Partial-Line-Down #xFE24)
(define-public gdk:ISO-Partial-Space-Left #xFE25)
(define-public gdk:ISO-Partial-Space-Right #xFE26)
(define-public gdk:ISO-Set-Margin-Left #xFE27)
(define-public gdk:ISO-Set-Margin-Right #xFE28)
(define-public gdk:ISO-Release-Margin-Left #xFE29)
(define-public gdk:ISO-Release-Margin-Right #xFE2A)
(define-public gdk:ISO-Release-Both-Margins #xFE2B)
(define-public gdk:ISO-Fast-Cursor-Left #xFE2C)
(define-public gdk:ISO-Fast-Cursor-Right #xFE2D)
(define-public gdk:ISO-Fast-Cursor-Up #xFE2E)
(define-public gdk:ISO-Fast-Cursor-Down #xFE2F)
(define-public gdk:ISO-Continuous-Underline #xFE30)
(define-public gdk:ISO-Discontinuous-Underline #xFE31)
(define-public gdk:ISO-Emphasize #xFE32)
(define-public gdk:ISO-Center-Object #xFE33)
(define-public gdk:ISO-Enter #xFE34)
(define-public gdk:dead-grave #xFE50)
(define-public gdk:dead-acute #xFE51)
(define-public gdk:dead-circumflex #xFE52)
(define-public gdk:dead-tilde #xFE53)
(define-public gdk:dead-macron #xFE54)
(define-public gdk:dead-breve #xFE55)
(define-public gdk:dead-abovedot #xFE56)
(define-public gdk:dead-diaeresis #xFE57)
(define-public gdk:dead-abovering #xFE58)
(define-public gdk:dead-doubleacute #xFE59)
(define-public gdk:dead-caron #xFE5A)
(define-public gdk:dead-cedilla #xFE5B)
(define-public gdk:dead-ogonek #xFE5C)
(define-public gdk:dead-iota #xFE5D)
(define-public gdk:dead-voiced-sound #xFE5E)
(define-public gdk:dead-semivoiced-sound #xFE5F)
(define-public gdk:dead-belowdot #xFE60)
(define-public gdk:First-Virtual-Screen #xFED0)
(define-public gdk:Prev-Virtual-Screen #xFED1)
(define-public gdk:Next-Virtual-Screen #xFED2)
(define-public gdk:Last-Virtual-Screen #xFED4)
(define-public gdk:Terminate-Server #xFED5)
(define-public gdk:AccessX-Enable #xFE70)
(define-public gdk:AccessX-Feedback-Enable #xFE71)
(define-public gdk:RepeatKeys-Enable #xFE72)
(define-public gdk:SlowKeys-Enable #xFE73)
(define-public gdk:BounceKeys-Enable #xFE74)
(define-public gdk:StickyKeys-Enable #xFE75)
(define-public gdk:MouseKeys-Enable #xFE76)
(define-public gdk:MouseKeys-Accel-Enable #xFE77)
(define-public gdk:Overlay1-Enable #xFE78)
(define-public gdk:Overlay2-Enable #xFE79)
(define-public gdk:AudibleBell-Enable #xFE7A)
(define-public gdk:Pointer-Left #xFEE0)
(define-public gdk:Pointer-Right #xFEE1)
(define-public gdk:Pointer-Up #xFEE2)
(define-public gdk:Pointer-Down #xFEE3)
(define-public gdk:Pointer-UpLeft #xFEE4)
(define-public gdk:Pointer-UpRight #xFEE5)
(define-public gdk:Pointer-DownLeft #xFEE6)
(define-public gdk:Pointer-DownRight #xFEE7)
(define-public gdk:Pointer-Button-Dflt #xFEE8)
(define-public gdk:Pointer-Button1 #xFEE9)
(define-public gdk:Pointer-Button2 #xFEEA)
(define-public gdk:Pointer-Button3 #xFEEB)
(define-public gdk:Pointer-Button4 #xFEEC)
(define-public gdk:Pointer-Button5 #xFEED)
(define-public gdk:Pointer-DblClick-Dflt #xFEEE)
(define-public gdk:Pointer-DblClick1 #xFEEF)
(define-public gdk:Pointer-DblClick2 #xFEF0)
(define-public gdk:Pointer-DblClick3 #xFEF1)
(define-public gdk:Pointer-DblClick4 #xFEF2)
(define-public gdk:Pointer-DblClick5 #xFEF3)
(define-public gdk:Pointer-Drag-Dflt #xFEF4)
(define-public gdk:Pointer-Drag1 #xFEF5)
(define-public gdk:Pointer-Drag2 #xFEF6)
(define-public gdk:Pointer-Drag3 #xFEF7)
(define-public gdk:Pointer-Drag4 #xFEF8)
(define-public gdk:Pointer-Drag5 #xFEFD)
(define-public gdk:Pointer-EnableKeys #xFEF9)
(define-public gdk:Pointer-Accelerate #xFEFA)
(define-public gdk:Pointer-DfltBtnNext #xFEFB)
(define-public gdk:Pointer-DfltBtnPrev #xFEFC)
(define-public gdk:3270-Duplicate #xFD01)
(define-public gdk:3270-FieldMark #xFD02)
(define-public gdk:3270-Right2 #xFD03)
(define-public gdk:3270-Left2 #xFD04)
(define-public gdk:3270-BackTab #xFD05)
(define-public gdk:3270-EraseEOF #xFD06)
(define-public gdk:3270-EraseInput #xFD07)
(define-public gdk:3270-Reset #xFD08)
(define-public gdk:3270-Quit #xFD09)
(define-public gdk:3270-PA1 #xFD0A)
(define-public gdk:3270-PA2 #xFD0B)
(define-public gdk:3270-PA3 #xFD0C)
(define-public gdk:3270-Test #xFD0D)
(define-public gdk:3270-Attn #xFD0E)
(define-public gdk:3270-CursorBlink #xFD0F)
(define-public gdk:3270-AltCursor #xFD10)
(define-public gdk:3270-KeyClick #xFD11)
(define-public gdk:3270-Jump #xFD12)
(define-public gdk:3270-Ident #xFD13)
(define-public gdk:3270-Rule #xFD14)
(define-public gdk:3270-Copy #xFD15)
(define-public gdk:3270-Play #xFD16)
(define-public gdk:3270-Setup #xFD17)
(define-public gdk:3270-Record #xFD18)
(define-public gdk:3270-ChangeScreen #xFD19)
(define-public gdk:3270-DeleteWord #xFD1A)
(define-public gdk:3270-ExSelect #xFD1B)
(define-public gdk:3270-CursorSelect #xFD1C)
(define-public gdk:3270-PrintScreen #xFD1D)
(define-public gdk:3270-Enter #xFD1E)
(define-public gdk:space #x020)
(define-public gdk:exclam #x021)
(define-public gdk:quotedbl #x022)
(define-public gdk:numbersign #x023)
(define-public gdk:dollar #x024)
(define-public gdk:percent #x025)
(define-public gdk:ampersand #x026)
(define-public gdk:apostrophe #x027)
(define-public gdk:quoteright #x027)
(define-public gdk:parenleft #x028)
(define-public gdk:parenright #x029)
(define-public gdk:asterisk #x02a)
(define-public gdk:plus #x02b)
(define-public gdk:comma #x02c)
(define-public gdk:minus #x02d)
(define-public gdk:period #x02e)
(define-public gdk:slash #x02f)
(define-public gdk:0 #x030)
(define-public gdk:1 #x031)
(define-public gdk:2 #x032)
(define-public gdk:3 #x033)
(define-public gdk:4 #x034)
(define-public gdk:5 #x035)
(define-public gdk:6 #x036)
(define-public gdk:7 #x037)
(define-public gdk:8 #x038)
(define-public gdk:9 #x039)
(define-public gdk:colon #x03a)
(define-public gdk:semicolon #x03b)
(define-public gdk:less #x03c)
(define-public gdk:equal #x03d)
(define-public gdk:greater #x03e)
(define-public gdk:question #x03f)
(define-public gdk:at #x040)
(define-public gdk:A #x041)
(define-public gdk:B #x042)
(define-public gdk:C #x043)
(define-public gdk:D #x044)
(define-public gdk:E #x045)
(define-public gdk:F #x046)
(define-public gdk:G #x047)
(define-public gdk:H #x048)
(define-public gdk:I #x049)
(define-public gdk:J #x04a)
(define-public gdk:K #x04b)
(define-public gdk:L #x04c)
(define-public gdk:M #x04d)
(define-public gdk:N #x04e)
(define-public gdk:O #x04f)
(define-public gdk:P #x050)
(define-public gdk:Q #x051)
(define-public gdk:R #x052)
(define-public gdk:S #x053)
(define-public gdk:T #x054)
(define-public gdk:U #x055)
(define-public gdk:V #x056)
(define-public gdk:W #x057)
(define-public gdk:X #x058)
(define-public gdk:Y #x059)
(define-public gdk:Z #x05a)
(define-public gdk:bracketleft #x05b)
(define-public gdk:backslash #x05c)
(define-public gdk:bracketright #x05d)
(define-public gdk:asciicircum #x05e)
(define-public gdk:underscore #x05f)
(define-public gdk:grave #x060)
(define-public gdk:quoteleft #x060)
(define-public gdk:a #x061)
(define-public gdk:b #x062)
(define-public gdk:c #x063)
(define-public gdk:d #x064)
(define-public gdk:e #x065)
(define-public gdk:f #x066)
(define-public gdk:g #x067)
(define-public gdk:h #x068)
(define-public gdk:i #x069)
(define-public gdk:j #x06a)
(define-public gdk:k #x06b)
(define-public gdk:l #x06c)
(define-public gdk:m #x06d)
(define-public gdk:n #x06e)
(define-public gdk:o #x06f)
(define-public gdk:p #x070)
(define-public gdk:q #x071)
(define-public gdk:r #x072)
(define-public gdk:s #x073)
(define-public gdk:t #x074)
(define-public gdk:u #x075)
(define-public gdk:v #x076)
(define-public gdk:w #x077)
(define-public gdk:x #x078)
(define-public gdk:y #x079)
(define-public gdk:z #x07a)
(define-public gdk:braceleft #x07b)
(define-public gdk:bar #x07c)
(define-public gdk:braceright #x07d)
(define-public gdk:asciitilde #x07e)
(define-public gdk:nobreakspace #x0a0)
(define-public gdk:exclamdown #x0a1)
(define-public gdk:cent #x0a2)
(define-public gdk:sterling #x0a3)
(define-public gdk:currency #x0a4)
(define-public gdk:yen #x0a5)
(define-public gdk:brokenbar #x0a6)
(define-public gdk:section #x0a7)
(define-public gdk:diaeresis #x0a8)
(define-public gdk:copyright #x0a9)
(define-public gdk:ordfeminine #x0aa)
(define-public gdk:guillemotleft #x0ab)
(define-public gdk:notsign #x0ac)
(define-public gdk:hyphen #x0ad)
(define-public gdk:registered #x0ae)
(define-public gdk:macron #x0af)
(define-public gdk:degree #x0b0)
(define-public gdk:plusminus #x0b1)
(define-public gdk:twosuperior #x0b2)
(define-public gdk:threesuperior #x0b3)
(define-public gdk:acute #x0b4)
(define-public gdk:mu #x0b5)
(define-public gdk:paragraph #x0b6)
(define-public gdk:periodcentered #x0b7)
(define-public gdk:cedilla #x0b8)
(define-public gdk:onesuperior #x0b9)
(define-public gdk:masculine #x0ba)
(define-public gdk:guillemotright #x0bb)
(define-public gdk:onequarter #x0bc)
(define-public gdk:onehalf #x0bd)
(define-public gdk:threequarters #x0be)
(define-public gdk:questiondown #x0bf)
(define-public gdk:Agrave #x0c0)
(define-public gdk:Aacute #x0c1)
(define-public gdk:Acircumflex #x0c2)
(define-public gdk:Atilde #x0c3)
(define-public gdk:Adiaeresis #x0c4)
(define-public gdk:Aring #x0c5)
(define-public gdk:AE #x0c6)
(define-public gdk:Ccedilla #x0c7)
(define-public gdk:Egrave #x0c8)
(define-public gdk:Eacute #x0c9)
(define-public gdk:Ecircumflex #x0ca)
(define-public gdk:Ediaeresis #x0cb)
(define-public gdk:Igrave #x0cc)
(define-public gdk:Iacute #x0cd)
(define-public gdk:Icircumflex #x0ce)
(define-public gdk:Idiaeresis #x0cf)
(define-public gdk:ETH #x0d0)
(define-public gdk:Eth #x0d0)
(define-public gdk:Ntilde #x0d1)
(define-public gdk:Ograve #x0d2)
(define-public gdk:Oacute #x0d3)
(define-public gdk:Ocircumflex #x0d4)
(define-public gdk:Otilde #x0d5)
(define-public gdk:Odiaeresis #x0d6)
(define-public gdk:multiply #x0d7)
(define-public gdk:Ooblique #x0d8)
(define-public gdk:Ugrave #x0d9)
(define-public gdk:Uacute #x0da)
(define-public gdk:Ucircumflex #x0db)
(define-public gdk:Udiaeresis #x0dc)
(define-public gdk:Yacute #x0dd)
(define-public gdk:THORN #x0de)
(define-public gdk:Thorn #x0de)
(define-public gdk:ssharp #x0df)
(define-public gdk:agrave #x0e0)
(define-public gdk:aacute #x0e1)
(define-public gdk:acircumflex #x0e2)
(define-public gdk:atilde #x0e3)
(define-public gdk:adiaeresis #x0e4)
(define-public gdk:aring #x0e5)
(define-public gdk:ae #x0e6)
(define-public gdk:ccedilla #x0e7)
(define-public gdk:egrave #x0e8)
(define-public gdk:eacute #x0e9)
(define-public gdk:ecircumflex #x0ea)
(define-public gdk:ediaeresis #x0eb)
(define-public gdk:igrave #x0ec)
(define-public gdk:iacute #x0ed)
(define-public gdk:icircumflex #x0ee)
(define-public gdk:idiaeresis #x0ef)
(define-public gdk:eth #x0f0)
(define-public gdk:ntilde #x0f1)
(define-public gdk:ograve #x0f2)
(define-public gdk:oacute #x0f3)
(define-public gdk:ocircumflex #x0f4)
(define-public gdk:otilde #x0f5)
(define-public gdk:odiaeresis #x0f6)
(define-public gdk:division #x0f7)
(define-public gdk:oslash #x0f8)
(define-public gdk:ugrave #x0f9)
(define-public gdk:uacute #x0fa)
(define-public gdk:ucircumflex #x0fb)
(define-public gdk:udiaeresis #x0fc)
(define-public gdk:yacute #x0fd)
(define-public gdk:thorn #x0fe)
(define-public gdk:ydiaeresis #x0ff)
(define-public gdk:Aogonek #x1a1)
(define-public gdk:breve #x1a2)
(define-public gdk:Lstroke #x1a3)
(define-public gdk:Lcaron #x1a5)
(define-public gdk:Sacute #x1a6)
(define-public gdk:Scaron #x1a9)
(define-public gdk:Scedilla #x1aa)
(define-public gdk:Tcaron #x1ab)
(define-public gdk:Zacute #x1ac)
(define-public gdk:Zcaron #x1ae)
(define-public gdk:Zabovedot #x1af)
(define-public gdk:aogonek #x1b1)
(define-public gdk:ogonek #x1b2)
(define-public gdk:lstroke #x1b3)
(define-public gdk:lcaron #x1b5)
(define-public gdk:sacute #x1b6)
(define-public gdk:caron #x1b7)
(define-public gdk:scaron #x1b9)
(define-public gdk:scedilla #x1ba)
(define-public gdk:tcaron #x1bb)
(define-public gdk:zacute #x1bc)
(define-public gdk:doubleacute #x1bd)
(define-public gdk:zcaron #x1be)
(define-public gdk:zabovedot #x1bf)
(define-public gdk:Racute #x1c0)
(define-public gdk:Abreve #x1c3)
(define-public gdk:Lacute #x1c5)
(define-public gdk:Cacute #x1c6)
(define-public gdk:Ccaron #x1c8)
(define-public gdk:Eogonek #x1ca)
(define-public gdk:Ecaron #x1cc)
(define-public gdk:Dcaron #x1cf)
(define-public gdk:Dstroke #x1d0)
(define-public gdk:Nacute #x1d1)
(define-public gdk:Ncaron #x1d2)
(define-public gdk:Odoubleacute #x1d5)
(define-public gdk:Rcaron #x1d8)
(define-public gdk:Uring #x1d9)
(define-public gdk:Udoubleacute #x1db)
(define-public gdk:Tcedilla #x1de)
(define-public gdk:racute #x1e0)
(define-public gdk:abreve #x1e3)
(define-public gdk:lacute #x1e5)
(define-public gdk:cacute #x1e6)
(define-public gdk:ccaron #x1e8)
(define-public gdk:eogonek #x1ea)
(define-public gdk:ecaron #x1ec)
(define-public gdk:dcaron #x1ef)
(define-public gdk:dstroke #x1f0)
(define-public gdk:nacute #x1f1)
(define-public gdk:ncaron #x1f2)
(define-public gdk:odoubleacute #x1f5)
(define-public gdk:udoubleacute #x1fb)
(define-public gdk:rcaron #x1f8)
(define-public gdk:uring #x1f9)
(define-public gdk:tcedilla #x1fe)
(define-public gdk:abovedot #x1ff)
(define-public gdk:Hstroke #x2a1)
(define-public gdk:Hcircumflex #x2a6)
(define-public gdk:Iabovedot #x2a9)
(define-public gdk:Gbreve #x2ab)
(define-public gdk:Jcircumflex #x2ac)
(define-public gdk:hstroke #x2b1)
(define-public gdk:hcircumflex #x2b6)
(define-public gdk:idotless #x2b9)
(define-public gdk:gbreve #x2bb)
(define-public gdk:jcircumflex #x2bc)
(define-public gdk:Cabovedot #x2c5)
(define-public gdk:Ccircumflex #x2c6)
(define-public gdk:Gabovedot #x2d5)
(define-public gdk:Gcircumflex #x2d8)
(define-public gdk:Ubreve #x2dd)
(define-public gdk:Scircumflex #x2de)
(define-public gdk:cabovedot #x2e5)
(define-public gdk:ccircumflex #x2e6)
(define-public gdk:gabovedot #x2f5)
(define-public gdk:gcircumflex #x2f8)
(define-public gdk:ubreve #x2fd)
(define-public gdk:scircumflex #x2fe)
(define-public gdk:kra #x3a2)
(define-public gdk:kappa #x3a2)
(define-public gdk:Rcedilla #x3a3)
(define-public gdk:Itilde #x3a5)
(define-public gdk:Lcedilla #x3a6)
(define-public gdk:Emacron #x3aa)
(define-public gdk:Gcedilla #x3ab)
(define-public gdk:Tslash #x3ac)
(define-public gdk:rcedilla #x3b3)
(define-public gdk:itilde #x3b5)
(define-public gdk:lcedilla #x3b6)
(define-public gdk:emacron #x3ba)
(define-public gdk:gcedilla #x3bb)
(define-public gdk:tslash #x3bc)
(define-public gdk:ENG #x3bd)
(define-public gdk:eng #x3bf)
(define-public gdk:Amacron #x3c0)
(define-public gdk:Iogonek #x3c7)
(define-public gdk:Eabovedot #x3cc)
(define-public gdk:Imacron #x3cf)
(define-public gdk:Ncedilla #x3d1)
(define-public gdk:Omacron #x3d2)
(define-public gdk:Kcedilla #x3d3)
(define-public gdk:Uogonek #x3d9)
(define-public gdk:Utilde #x3dd)
(define-public gdk:Umacron #x3de)
(define-public gdk:amacron #x3e0)
(define-public gdk:iogonek #x3e7)
(define-public gdk:eabovedot #x3ec)
(define-public gdk:imacron #x3ef)
(define-public gdk:ncedilla #x3f1)
(define-public gdk:omacron #x3f2)
(define-public gdk:kcedilla #x3f3)
(define-public gdk:uogonek #x3f9)
(define-public gdk:utilde #x3fd)
(define-public gdk:umacron #x3fe)
(define-public gdk:OE #x13bc)
(define-public gdk:oe #x13bd)
(define-public gdk:Ydiaeresis #x13be)
(define-public gdk:overline #x47e)
(define-public gdk:kana-fullstop #x4a1)
(define-public gdk:kana-openingbracket #x4a2)
(define-public gdk:kana-closingbracket #x4a3)
(define-public gdk:kana-comma #x4a4)
(define-public gdk:kana-conjunctive #x4a5)
(define-public gdk:kana-middledot #x4a5)
(define-public gdk:kana-WO #x4a6)
(define-public gdk:kana-a #x4a7)
(define-public gdk:kana-i #x4a8)
(define-public gdk:kana-u #x4a9)
(define-public gdk:kana-e #x4aa)
(define-public gdk:kana-o #x4ab)
(define-public gdk:kana-ya #x4ac)
(define-public gdk:kana-yu #x4ad)
(define-public gdk:kana-yo #x4ae)
(define-public gdk:kana-tsu #x4af)
(define-public gdk:kana-tu #x4af)
(define-public gdk:prolongedsound #x4b0)
(define-public gdk:kana-A #x4b1)
(define-public gdk:kana-I #x4b2)
(define-public gdk:kana-U #x4b3)
(define-public gdk:kana-E #x4b4)
(define-public gdk:kana-O #x4b5)
(define-public gdk:kana-KA #x4b6)
(define-public gdk:kana-KI #x4b7)
(define-public gdk:kana-KU #x4b8)
(define-public gdk:kana-KE #x4b9)
(define-public gdk:kana-KO #x4ba)
(define-public gdk:kana-SA #x4bb)
(define-public gdk:kana-SHI #x4bc)
(define-public gdk:kana-SU #x4bd)
(define-public gdk:kana-SE #x4be)
(define-public gdk:kana-SO #x4bf)
(define-public gdk:kana-TA #x4c0)
(define-public gdk:kana-CHI #x4c1)
(define-public gdk:kana-TI #x4c1)
(define-public gdk:kana-TSU #x4c2)
(define-public gdk:kana-TU #x4c2)
(define-public gdk:kana-TE #x4c3)
(define-public gdk:kana-TO #x4c4)
(define-public gdk:kana-NA #x4c5)
(define-public gdk:kana-NI #x4c6)
(define-public gdk:kana-NU #x4c7)
(define-public gdk:kana-NE #x4c8)
(define-public gdk:kana-NO #x4c9)
(define-public gdk:kana-HA #x4ca)
(define-public gdk:kana-HI #x4cb)
(define-public gdk:kana-FU #x4cc)
(define-public gdk:kana-HU #x4cc)
(define-public gdk:kana-HE #x4cd)
(define-public gdk:kana-HO #x4ce)
(define-public gdk:kana-MA #x4cf)
(define-public gdk:kana-MI #x4d0)
(define-public gdk:kana-MU #x4d1)
(define-public gdk:kana-ME #x4d2)
(define-public gdk:kana-MO #x4d3)
(define-public gdk:kana-YA #x4d4)
(define-public gdk:kana-YU #x4d5)
(define-public gdk:kana-YO #x4d6)
(define-public gdk:kana-RA #x4d7)
(define-public gdk:kana-RI #x4d8)
(define-public gdk:kana-RU #x4d9)
(define-public gdk:kana-RE #x4da)
(define-public gdk:kana-RO #x4db)
(define-public gdk:kana-WA #x4dc)
(define-public gdk:kana-N #x4dd)
(define-public gdk:voicedsound #x4de)
(define-public gdk:semivoicedsound #x4df)
(define-public gdk:kana-switch #xFF7E)
(define-public gdk:Arabic-comma #x5ac)
(define-public gdk:Arabic-semicolon #x5bb)
(define-public gdk:Arabic-question-mark #x5bf)
(define-public gdk:Arabic-hamza #x5c1)
(define-public gdk:Arabic-maddaonalef #x5c2)
(define-public gdk:Arabic-hamzaonalef #x5c3)
(define-public gdk:Arabic-hamzaonwaw #x5c4)
(define-public gdk:Arabic-hamzaunderalef #x5c5)
(define-public gdk:Arabic-hamzaonyeh #x5c6)
(define-public gdk:Arabic-alef #x5c7)
(define-public gdk:Arabic-beh #x5c8)
(define-public gdk:Arabic-tehmarbuta #x5c9)
(define-public gdk:Arabic-teh #x5ca)
(define-public gdk:Arabic-theh #x5cb)
(define-public gdk:Arabic-jeem #x5cc)
(define-public gdk:Arabic-hah #x5cd)
(define-public gdk:Arabic-khah #x5ce)
(define-public gdk:Arabic-dal #x5cf)
(define-public gdk:Arabic-thal #x5d0)
(define-public gdk:Arabic-ra #x5d1)
(define-public gdk:Arabic-zain #x5d2)
(define-public gdk:Arabic-seen #x5d3)
(define-public gdk:Arabic-sheen #x5d4)
(define-public gdk:Arabic-sad #x5d5)
(define-public gdk:Arabic-dad #x5d6)
(define-public gdk:Arabic-tah #x5d7)
(define-public gdk:Arabic-zah #x5d8)
(define-public gdk:Arabic-ain #x5d9)
(define-public gdk:Arabic-ghain #x5da)
(define-public gdk:Arabic-tatweel #x5e0)
(define-public gdk:Arabic-feh #x5e1)
(define-public gdk:Arabic-qaf #x5e2)
(define-public gdk:Arabic-kaf #x5e3)
(define-public gdk:Arabic-lam #x5e4)
(define-public gdk:Arabic-meem #x5e5)
(define-public gdk:Arabic-noon #x5e6)
(define-public gdk:Arabic-ha #x5e7)
(define-public gdk:Arabic-heh #x5e7)
(define-public gdk:Arabic-waw #x5e8)
(define-public gdk:Arabic-alefmaksura #x5e9)
(define-public gdk:Arabic-yeh #x5ea)
(define-public gdk:Arabic-fathatan #x5eb)
(define-public gdk:Arabic-dammatan #x5ec)
(define-public gdk:Arabic-kasratan #x5ed)
(define-public gdk:Arabic-fatha #x5ee)
(define-public gdk:Arabic-damma #x5ef)
(define-public gdk:Arabic-kasra #x5f0)
(define-public gdk:Arabic-shadda #x5f1)
(define-public gdk:Arabic-sukun #x5f2)
(define-public gdk:Arabic-switch #xFF7E)
(define-public gdk:Serbian-dje #x6a1)
(define-public gdk:Macedonia-gje #x6a2)
(define-public gdk:Cyrillic-io #x6a3)
(define-public gdk:Ukrainian-ie #x6a4)
(define-public gdk:Ukranian-je #x6a4)
(define-public gdk:Macedonia-dse #x6a5)
(define-public gdk:Ukrainian-i #x6a6)
(define-public gdk:Ukranian-i #x6a6)
(define-public gdk:Ukrainian-yi #x6a7)
(define-public gdk:Ukranian-yi #x6a7)
(define-public gdk:Cyrillic-je #x6a8)
(define-public gdk:Serbian-je #x6a8)
(define-public gdk:Cyrillic-lje #x6a9)
(define-public gdk:Serbian-lje #x6a9)
(define-public gdk:Cyrillic-nje #x6aa)
(define-public gdk:Serbian-nje #x6aa)
(define-public gdk:Serbian-tshe #x6ab)
(define-public gdk:Macedonia-kje #x6ac)
(define-public gdk:Byelorussian-shortu #x6ae)
(define-public gdk:Cyrillic-dzhe #x6af)
(define-public gdk:Serbian-dze #x6af)
(define-public gdk:numerosign #x6b0)
(define-public gdk:Serbian-DJE #x6b1)
(define-public gdk:Macedonia-GJE #x6b2)
(define-public gdk:Cyrillic-IO #x6b3)
(define-public gdk:Ukrainian-IE #x6b4)
(define-public gdk:Ukranian-JE #x6b4)
(define-public gdk:Macedonia-DSE #x6b5)
(define-public gdk:Ukrainian-I #x6b6)
(define-public gdk:Ukranian-I #x6b6)
(define-public gdk:Ukrainian-YI #x6b7)
(define-public gdk:Ukranian-YI #x6b7)
(define-public gdk:Cyrillic-JE #x6b8)
(define-public gdk:Serbian-JE #x6b8)
(define-public gdk:Cyrillic-LJE #x6b9)
(define-public gdk:Serbian-LJE #x6b9)
(define-public gdk:Cyrillic-NJE #x6ba)
(define-public gdk:Serbian-NJE #x6ba)
(define-public gdk:Serbian-TSHE #x6bb)
(define-public gdk:Macedonia-KJE #x6bc)
(define-public gdk:Byelorussian-SHORTU #x6be)
(define-public gdk:Cyrillic-DZHE #x6bf)
(define-public gdk:Serbian-DZE #x6bf)
(define-public gdk:Cyrillic-yu #x6c0)
(define-public gdk:Cyrillic-a #x6c1)
(define-public gdk:Cyrillic-be #x6c2)
(define-public gdk:Cyrillic-tse #x6c3)
(define-public gdk:Cyrillic-de #x6c4)
(define-public gdk:Cyrillic-ie #x6c5)
(define-public gdk:Cyrillic-ef #x6c6)
(define-public gdk:Cyrillic-ghe #x6c7)
(define-public gdk:Cyrillic-ha #x6c8)
(define-public gdk:Cyrillic-i #x6c9)
(define-public gdk:Cyrillic-shorti #x6ca)
(define-public gdk:Cyrillic-ka #x6cb)
(define-public gdk:Cyrillic-el #x6cc)
(define-public gdk:Cyrillic-em #x6cd)
(define-public gdk:Cyrillic-en #x6ce)
(define-public gdk:Cyrillic-o #x6cf)
(define-public gdk:Cyrillic-pe #x6d0)
(define-public gdk:Cyrillic-ya #x6d1)
(define-public gdk:Cyrillic-er #x6d2)
(define-public gdk:Cyrillic-es #x6d3)
(define-public gdk:Cyrillic-te #x6d4)
(define-public gdk:Cyrillic-u #x6d5)
(define-public gdk:Cyrillic-zhe #x6d6)
(define-public gdk:Cyrillic-ve #x6d7)
(define-public gdk:Cyrillic-softsign #x6d8)
(define-public gdk:Cyrillic-yeru #x6d9)
(define-public gdk:Cyrillic-ze #x6da)
(define-public gdk:Cyrillic-sha #x6db)
(define-public gdk:Cyrillic-e #x6dc)
(define-public gdk:Cyrillic-shcha #x6dd)
(define-public gdk:Cyrillic-che #x6de)
(define-public gdk:Cyrillic-hardsign #x6df)
(define-public gdk:Cyrillic-YU #x6e0)
(define-public gdk:Cyrillic-A #x6e1)
(define-public gdk:Cyrillic-BE #x6e2)
(define-public gdk:Cyrillic-TSE #x6e3)
(define-public gdk:Cyrillic-DE #x6e4)
(define-public gdk:Cyrillic-IE #x6e5)
(define-public gdk:Cyrillic-EF #x6e6)
(define-public gdk:Cyrillic-GHE #x6e7)
(define-public gdk:Cyrillic-HA #x6e8)
(define-public gdk:Cyrillic-I #x6e9)
(define-public gdk:Cyrillic-SHORTI #x6ea)
(define-public gdk:Cyrillic-KA #x6eb)
(define-public gdk:Cyrillic-EL #x6ec)
(define-public gdk:Cyrillic-EM #x6ed)
(define-public gdk:Cyrillic-EN #x6ee)
(define-public gdk:Cyrillic-O #x6ef)
(define-public gdk:Cyrillic-PE #x6f0)
(define-public gdk:Cyrillic-YA #x6f1)
(define-public gdk:Cyrillic-ER #x6f2)
(define-public gdk:Cyrillic-ES #x6f3)
(define-public gdk:Cyrillic-TE #x6f4)
(define-public gdk:Cyrillic-U #x6f5)
(define-public gdk:Cyrillic-ZHE #x6f6)
(define-public gdk:Cyrillic-VE #x6f7)
(define-public gdk:Cyrillic-SOFTSIGN #x6f8)
(define-public gdk:Cyrillic-YERU #x6f9)
(define-public gdk:Cyrillic-ZE #x6fa)
(define-public gdk:Cyrillic-SHA #x6fb)
(define-public gdk:Cyrillic-E #x6fc)
(define-public gdk:Cyrillic-SHCHA #x6fd)
(define-public gdk:Cyrillic-CHE #x6fe)
(define-public gdk:Cyrillic-HARDSIGN #x6ff)
(define-public gdk:Greek-ALPHAaccent #x7a1)
(define-public gdk:Greek-EPSILONaccent #x7a2)
(define-public gdk:Greek-ETAaccent #x7a3)
(define-public gdk:Greek-IOTAaccent #x7a4)
(define-public gdk:Greek-IOTAdiaeresis #x7a5)
(define-public gdk:Greek-OMICRONaccent #x7a7)
(define-public gdk:Greek-UPSILONaccent #x7a8)
(define-public gdk:Greek-UPSILONdieresis #x7a9)
(define-public gdk:Greek-OMEGAaccent #x7ab)
(define-public gdk:Greek-accentdieresis #x7ae)
(define-public gdk:Greek-horizbar #x7af)
(define-public gdk:Greek-alphaaccent #x7b1)
(define-public gdk:Greek-epsilonaccent #x7b2)
(define-public gdk:Greek-etaaccent #x7b3)
(define-public gdk:Greek-iotaaccent #x7b4)
(define-public gdk:Greek-iotadieresis #x7b5)
(define-public gdk:Greek-iotaaccentdieresis #x7b6)
(define-public gdk:Greek-omicronaccent #x7b7)
(define-public gdk:Greek-upsilonaccent #x7b8)
(define-public gdk:Greek-upsilondieresis #x7b9)
(define-public gdk:Greek-upsilonaccentdieresis #x7ba)
(define-public gdk:Greek-omegaaccent #x7bb)
(define-public gdk:Greek-ALPHA #x7c1)
(define-public gdk:Greek-BETA #x7c2)
(define-public gdk:Greek-GAMMA #x7c3)
(define-public gdk:Greek-DELTA #x7c4)
(define-public gdk:Greek-EPSILON #x7c5)
(define-public gdk:Greek-ZETA #x7c6)
(define-public gdk:Greek-ETA #x7c7)
(define-public gdk:Greek-THETA #x7c8)
(define-public gdk:Greek-IOTA #x7c9)
(define-public gdk:Greek-KAPPA #x7ca)
(define-public gdk:Greek-LAMDA #x7cb)
(define-public gdk:Greek-LAMBDA #x7cb)
(define-public gdk:Greek-MU #x7cc)
(define-public gdk:Greek-NU #x7cd)
(define-public gdk:Greek-XI #x7ce)
(define-public gdk:Greek-OMICRON #x7cf)
(define-public gdk:Greek-PI #x7d0)
(define-public gdk:Greek-RHO #x7d1)
(define-public gdk:Greek-SIGMA #x7d2)
(define-public gdk:Greek-TAU #x7d4)
(define-public gdk:Greek-UPSILON #x7d5)
(define-public gdk:Greek-PHI #x7d6)
(define-public gdk:Greek-CHI #x7d7)
(define-public gdk:Greek-PSI #x7d8)
(define-public gdk:Greek-OMEGA #x7d9)
(define-public gdk:Greek-alpha #x7e1)
(define-public gdk:Greek-beta #x7e2)
(define-public gdk:Greek-gamma #x7e3)
(define-public gdk:Greek-delta #x7e4)
(define-public gdk:Greek-epsilon #x7e5)
(define-public gdk:Greek-zeta #x7e6)
(define-public gdk:Greek-eta #x7e7)
(define-public gdk:Greek-theta #x7e8)
(define-public gdk:Greek-iota #x7e9)
(define-public gdk:Greek-kappa #x7ea)
(define-public gdk:Greek-lamda #x7eb)
(define-public gdk:Greek-lambda #x7eb)
(define-public gdk:Greek-mu #x7ec)
(define-public gdk:Greek-nu #x7ed)
(define-public gdk:Greek-xi #x7ee)
(define-public gdk:Greek-omicron #x7ef)
(define-public gdk:Greek-pi #x7f0)
(define-public gdk:Greek-rho #x7f1)
(define-public gdk:Greek-sigma #x7f2)
(define-public gdk:Greek-finalsmallsigma #x7f3)
(define-public gdk:Greek-tau #x7f4)
(define-public gdk:Greek-upsilon #x7f5)
(define-public gdk:Greek-phi #x7f6)
(define-public gdk:Greek-chi #x7f7)
(define-public gdk:Greek-psi #x7f8)
(define-public gdk:Greek-omega #x7f9)
(define-public gdk:Greek-switch #xFF7E)
(define-public gdk:leftradical #x8a1)
(define-public gdk:topleftradical #x8a2)
(define-public gdk:horizconnector #x8a3)
(define-public gdk:topintegral #x8a4)
(define-public gdk:botintegral #x8a5)
(define-public gdk:vertconnector #x8a6)
(define-public gdk:topleftsqbracket #x8a7)
(define-public gdk:botleftsqbracket #x8a8)
(define-public gdk:toprightsqbracket #x8a9)
(define-public gdk:botrightsqbracket #x8aa)
(define-public gdk:topleftparens #x8ab)
(define-public gdk:botleftparens #x8ac)
(define-public gdk:toprightparens #x8ad)
(define-public gdk:botrightparens #x8ae)
(define-public gdk:leftmiddlecurlybrace #x8af)
(define-public gdk:rightmiddlecurlybrace #x8b0)
(define-public gdk:topleftsummation #x8b1)
(define-public gdk:botleftsummation #x8b2)
(define-public gdk:topvertsummationconnector #x8b3)
(define-public gdk:botvertsummationconnector #x8b4)
(define-public gdk:toprightsummation #x8b5)
(define-public gdk:botrightsummation #x8b6)
(define-public gdk:rightmiddlesummation #x8b7)
(define-public gdk:lessthanequal #x8bc)
(define-public gdk:notequal #x8bd)
(define-public gdk:greaterthanequal #x8be)
(define-public gdk:integral #x8bf)
(define-public gdk:therefore #x8c0)
(define-public gdk:variation #x8c1)
(define-public gdk:infinity #x8c2)
(define-public gdk:nabla #x8c5)
(define-public gdk:approximate #x8c8)
(define-public gdk:similarequal #x8c9)
(define-public gdk:ifonlyif #x8cd)
(define-public gdk:implies #x8ce)
(define-public gdk:identical #x8cf)
(define-public gdk:radical #x8d6)
(define-public gdk:includedin #x8da)
(define-public gdk:includes #x8db)
(define-public gdk:intersection #x8dc)
(define-public gdk:union #x8dd)
(define-public gdk:logicaland #x8de)
(define-public gdk:logicalor #x8df)
(define-public gdk:partialderivative #x8ef)
(define-public gdk:function #x8f6)
(define-public gdk:leftarrow #x8fb)
(define-public gdk:uparrow #x8fc)
(define-public gdk:rightarrow #x8fd)
(define-public gdk:downarrow #x8fe)
(define-public gdk:blank #x9df)
(define-public gdk:soliddiamond #x9e0)
(define-public gdk:checkerboard #x9e1)
(define-public gdk:ht #x9e2)
(define-public gdk:ff #x9e3)
(define-public gdk:cr #x9e4)
(define-public gdk:lf #x9e5)
(define-public gdk:nl #x9e8)
(define-public gdk:vt #x9e9)
(define-public gdk:lowrightcorner #x9ea)
(define-public gdk:uprightcorner #x9eb)
(define-public gdk:upleftcorner #x9ec)
(define-public gdk:lowleftcorner #x9ed)
(define-public gdk:crossinglines #x9ee)
(define-public gdk:horizlinescan1 #x9ef)
(define-public gdk:horizlinescan3 #x9f0)
(define-public gdk:horizlinescan5 #x9f1)
(define-public gdk:horizlinescan7 #x9f2)
(define-public gdk:horizlinescan9 #x9f3)
(define-public gdk:leftt #x9f4)
(define-public gdk:rightt #x9f5)
(define-public gdk:bott #x9f6)
(define-public gdk:topt #x9f7)
(define-public gdk:vertbar #x9f8)
(define-public gdk:emspace #xaa1)
(define-public gdk:enspace #xaa2)
(define-public gdk:em3space #xaa3)
(define-public gdk:em4space #xaa4)
(define-public gdk:digitspace #xaa5)
(define-public gdk:punctspace #xaa6)
(define-public gdk:thinspace #xaa7)
(define-public gdk:hairspace #xaa8)
(define-public gdk:emdash #xaa9)
(define-public gdk:endash #xaaa)
(define-public gdk:signifblank #xaac)
(define-public gdk:ellipsis #xaae)
(define-public gdk:doubbaselinedot #xaaf)
(define-public gdk:onethird #xab0)
(define-public gdk:twothirds #xab1)
(define-public gdk:onefifth #xab2)
(define-public gdk:twofifths #xab3)
(define-public gdk:threefifths #xab4)
(define-public gdk:fourfifths #xab5)
(define-public gdk:onesixth #xab6)
(define-public gdk:fivesixths #xab7)
(define-public gdk:careof #xab8)
(define-public gdk:figdash #xabb)
(define-public gdk:leftanglebracket #xabc)
(define-public gdk:decimalpoint #xabd)
(define-public gdk:rightanglebracket #xabe)
(define-public gdk:marker #xabf)
(define-public gdk:oneeighth #xac3)
(define-public gdk:threeeighths #xac4)
(define-public gdk:fiveeighths #xac5)
(define-public gdk:seveneighths #xac6)
(define-public gdk:trademark #xac9)
(define-public gdk:signaturemark #xaca)
(define-public gdk:trademarkincircle #xacb)
(define-public gdk:leftopentriangle #xacc)
(define-public gdk:rightopentriangle #xacd)
(define-public gdk:emopencircle #xace)
(define-public gdk:emopenrectangle #xacf)
(define-public gdk:leftsinglequotemark #xad0)
(define-public gdk:rightsinglequotemark #xad1)
(define-public gdk:leftdoublequotemark #xad2)
(define-public gdk:rightdoublequotemark #xad3)
(define-public gdk:prescription #xad4)
(define-public gdk:minutes #xad6)
(define-public gdk:seconds #xad7)
(define-public gdk:latincross #xad9)
(define-public gdk:hexagram #xada)
(define-public gdk:filledrectbullet #xadb)
(define-public gdk:filledlefttribullet #xadc)
(define-public gdk:filledrighttribullet #xadd)
(define-public gdk:emfilledcircle #xade)
(define-public gdk:emfilledrect #xadf)
(define-public gdk:enopencircbullet #xae0)
(define-public gdk:enopensquarebullet #xae1)
(define-public gdk:openrectbullet #xae2)
(define-public gdk:opentribulletup #xae3)
(define-public gdk:opentribulletdown #xae4)
(define-public gdk:openstar #xae5)
(define-public gdk:enfilledcircbullet #xae6)
(define-public gdk:enfilledsqbullet #xae7)
(define-public gdk:filledtribulletup #xae8)
(define-public gdk:filledtribulletdown #xae9)
(define-public gdk:leftpointer #xaea)
(define-public gdk:rightpointer #xaeb)
(define-public gdk:club #xaec)
(define-public gdk:diamond #xaed)
(define-public gdk:heart #xaee)
(define-public gdk:maltesecross #xaf0)
(define-public gdk:dagger #xaf1)
(define-public gdk:doubledagger #xaf2)
(define-public gdk:checkmark #xaf3)
(define-public gdk:ballotcross #xaf4)
(define-public gdk:musicalsharp #xaf5)
(define-public gdk:musicalflat #xaf6)
(define-public gdk:malesymbol #xaf7)
(define-public gdk:femalesymbol #xaf8)
(define-public gdk:telephone #xaf9)
(define-public gdk:telephonerecorder #xafa)
(define-public gdk:phonographcopyright #xafb)
(define-public gdk:caret #xafc)
(define-public gdk:singlelowquotemark #xafd)
(define-public gdk:doublelowquotemark #xafe)
(define-public gdk:cursor #xaff)
(define-public gdk:leftcaret #xba3)
(define-public gdk:rightcaret #xba6)
(define-public gdk:downcaret #xba8)
(define-public gdk:upcaret #xba9)
(define-public gdk:overbar #xbc0)
(define-public gdk:downtack #xbc2)
(define-public gdk:upshoe #xbc3)
(define-public gdk:downstile #xbc4)
(define-public gdk:underbar #xbc6)
(define-public gdk:jot #xbca)
(define-public gdk:quad #xbcc)
(define-public gdk:uptack #xbce)
(define-public gdk:circle #xbcf)
(define-public gdk:upstile #xbd3)
(define-public gdk:downshoe #xbd6)
(define-public gdk:rightshoe #xbd8)
(define-public gdk:leftshoe #xbda)
(define-public gdk:lefttack #xbdc)
(define-public gdk:righttack #xbfc)
(define-public gdk:hebrew-doublelowline #xcdf)
(define-public gdk:hebrew-aleph #xce0)
(define-public gdk:hebrew-bet #xce1)
(define-public gdk:hebrew-beth #xce1)
(define-public gdk:hebrew-gimel #xce2)
(define-public gdk:hebrew-gimmel #xce2)
(define-public gdk:hebrew-dalet #xce3)
(define-public gdk:hebrew-daleth #xce3)
(define-public gdk:hebrew-he #xce4)
(define-public gdk:hebrew-waw #xce5)
(define-public gdk:hebrew-zain #xce6)
(define-public gdk:hebrew-zayin #xce6)
(define-public gdk:hebrew-chet #xce7)
(define-public gdk:hebrew-het #xce7)
(define-public gdk:hebrew-tet #xce8)
(define-public gdk:hebrew-teth #xce8)
(define-public gdk:hebrew-yod #xce9)
(define-public gdk:hebrew-finalkaph #xcea)
(define-public gdk:hebrew-kaph #xceb)
(define-public gdk:hebrew-lamed #xcec)
(define-public gdk:hebrew-finalmem #xced)
(define-public gdk:hebrew-mem #xcee)
(define-public gdk:hebrew-finalnun #xcef)
(define-public gdk:hebrew-nun #xcf0)
(define-public gdk:hebrew-samech #xcf1)
(define-public gdk:hebrew-samekh #xcf1)
(define-public gdk:hebrew-ayin #xcf2)
(define-public gdk:hebrew-finalpe #xcf3)
(define-public gdk:hebrew-pe #xcf4)
(define-public gdk:hebrew-finalzade #xcf5)
(define-public gdk:hebrew-finalzadi #xcf5)
(define-public gdk:hebrew-zade #xcf6)
(define-public gdk:hebrew-zadi #xcf6)
(define-public gdk:hebrew-qoph #xcf7)
(define-public gdk:hebrew-kuf #xcf7)
(define-public gdk:hebrew-resh #xcf8)
(define-public gdk:hebrew-shin #xcf9)
(define-public gdk:hebrew-taw #xcfa)
(define-public gdk:hebrew-taf #xcfa)
(define-public gdk:Hebrew-switch #xFF7E)
(define-public gdk:Thai-kokai #xda1)
(define-public gdk:Thai-khokhai #xda2)
(define-public gdk:Thai-khokhuat #xda3)
(define-public gdk:Thai-khokhwai #xda4)
(define-public gdk:Thai-khokhon #xda5)
(define-public gdk:Thai-khorakhang #xda6)
(define-public gdk:Thai-ngongu #xda7)
(define-public gdk:Thai-chochan #xda8)
(define-public gdk:Thai-choching #xda9)
(define-public gdk:Thai-chochang #xdaa)
(define-public gdk:Thai-soso #xdab)
(define-public gdk:Thai-chochoe #xdac)
(define-public gdk:Thai-yoying #xdad)
(define-public gdk:Thai-dochada #xdae)
(define-public gdk:Thai-topatak #xdaf)
(define-public gdk:Thai-thothan #xdb0)
(define-public gdk:Thai-thonangmontho #xdb1)
(define-public gdk:Thai-thophuthao #xdb2)
(define-public gdk:Thai-nonen #xdb3)
(define-public gdk:Thai-dodek #xdb4)
(define-public gdk:Thai-totao #xdb5)
(define-public gdk:Thai-thothung #xdb6)
(define-public gdk:Thai-thothahan #xdb7)
(define-public gdk:Thai-thothong #xdb8)
(define-public gdk:Thai-nonu #xdb9)
(define-public gdk:Thai-bobaimai #xdba)
(define-public gdk:Thai-popla #xdbb)
(define-public gdk:Thai-phophung #xdbc)
(define-public gdk:Thai-fofa #xdbd)
(define-public gdk:Thai-phophan #xdbe)
(define-public gdk:Thai-fofan #xdbf)
(define-public gdk:Thai-phosamphao #xdc0)
(define-public gdk:Thai-moma #xdc1)
(define-public gdk:Thai-yoyak #xdc2)
(define-public gdk:Thai-rorua #xdc3)
(define-public gdk:Thai-ru #xdc4)
(define-public gdk:Thai-loling #xdc5)
(define-public gdk:Thai-lu #xdc6)
(define-public gdk:Thai-wowaen #xdc7)
(define-public gdk:Thai-sosala #xdc8)
(define-public gdk:Thai-sorusi #xdc9)
(define-public gdk:Thai-sosua #xdca)
(define-public gdk:Thai-hohip #xdcb)
(define-public gdk:Thai-lochula #xdcc)
(define-public gdk:Thai-oang #xdcd)
(define-public gdk:Thai-honokhuk #xdce)
(define-public gdk:Thai-paiyannoi #xdcf)
(define-public gdk:Thai-saraa #xdd0)
(define-public gdk:Thai-maihanakat #xdd1)
(define-public gdk:Thai-saraaa #xdd2)
(define-public gdk:Thai-saraam #xdd3)
(define-public gdk:Thai-sarai #xdd4)
(define-public gdk:Thai-saraii #xdd5)
(define-public gdk:Thai-saraue #xdd6)
(define-public gdk:Thai-sarauee #xdd7)
(define-public gdk:Thai-sarau #xdd8)
(define-public gdk:Thai-sarauu #xdd9)
(define-public gdk:Thai-phinthu #xdda)
(define-public gdk:Thai-maihanakat-maitho #xdde)
(define-public gdk:Thai-baht #xddf)
(define-public gdk:Thai-sarae #xde0)
(define-public gdk:Thai-saraae #xde1)
(define-public gdk:Thai-sarao #xde2)
(define-public gdk:Thai-saraaimaimuan #xde3)
(define-public gdk:Thai-saraaimaimalai #xde4)
(define-public gdk:Thai-lakkhangyao #xde5)
(define-public gdk:Thai-maiyamok #xde6)
(define-public gdk:Thai-maitaikhu #xde7)
(define-public gdk:Thai-maiek #xde8)
(define-public gdk:Thai-maitho #xde9)
(define-public gdk:Thai-maitri #xdea)
(define-public gdk:Thai-maichattawa #xdeb)
(define-public gdk:Thai-thanthakhat #xdec)
(define-public gdk:Thai-nikhahit #xded)
(define-public gdk:Thai-leksun #xdf0)
(define-public gdk:Thai-leknung #xdf1)
(define-public gdk:Thai-leksong #xdf2)
(define-public gdk:Thai-leksam #xdf3)
(define-public gdk:Thai-leksi #xdf4)
(define-public gdk:Thai-lekha #xdf5)
(define-public gdk:Thai-lekhok #xdf6)
(define-public gdk:Thai-lekchet #xdf7)
(define-public gdk:Thai-lekpaet #xdf8)
(define-public gdk:Thai-lekkao #xdf9)
(define-public gdk:Hangul #xff31)
(define-public gdk:Hangul-Start #xff32)
(define-public gdk:Hangul-End #xff33)
(define-public gdk:Hangul-Hanja #xff34)
(define-public gdk:Hangul-Jamo #xff35)
(define-public gdk:Hangul-Romaja #xff36)
(define-public gdk:Hangul-Codeinput #xff37)
(define-public gdk:Hangul-Jeonja #xff38)
(define-public gdk:Hangul-Banja #xff39)
(define-public gdk:Hangul-PreHanja #xff3a)
(define-public gdk:Hangul-PostHanja #xff3b)
(define-public gdk:Hangul-SingleCandidate #xff3c)
(define-public gdk:Hangul-MultipleCandidate #xff3d)
(define-public gdk:Hangul-PreviousCandidate #xff3e)
(define-public gdk:Hangul-Special #xff3f)
(define-public gdk:Hangul-switch #xFF7E)
(define-public gdk:Hangul-Kiyeog #xea1)
(define-public gdk:Hangul-SsangKiyeog #xea2)
(define-public gdk:Hangul-KiyeogSios #xea3)
(define-public gdk:Hangul-Nieun #xea4)
(define-public gdk:Hangul-NieunJieuj #xea5)
(define-public gdk:Hangul-NieunHieuh #xea6)
(define-public gdk:Hangul-Dikeud #xea7)
(define-public gdk:Hangul-SsangDikeud #xea8)
(define-public gdk:Hangul-Rieul #xea9)
(define-public gdk:Hangul-RieulKiyeog #xeaa)
(define-public gdk:Hangul-RieulMieum #xeab)
(define-public gdk:Hangul-RieulPieub #xeac)
(define-public gdk:Hangul-RieulSios #xead)
(define-public gdk:Hangul-RieulTieut #xeae)
(define-public gdk:Hangul-RieulPhieuf #xeaf)
(define-public gdk:Hangul-RieulHieuh #xeb0)
(define-public gdk:Hangul-Mieum #xeb1)
(define-public gdk:Hangul-Pieub #xeb2)
(define-public gdk:Hangul-SsangPieub #xeb3)
(define-public gdk:Hangul-PieubSios #xeb4)
(define-public gdk:Hangul-Sios #xeb5)
(define-public gdk:Hangul-SsangSios #xeb6)
(define-public gdk:Hangul-Ieung #xeb7)
(define-public gdk:Hangul-Jieuj #xeb8)
(define-public gdk:Hangul-SsangJieuj #xeb9)
(define-public gdk:Hangul-Cieuc #xeba)
(define-public gdk:Hangul-Khieuq #xebb)
(define-public gdk:Hangul-Tieut #xebc)
(define-public gdk:Hangul-Phieuf #xebd)
(define-public gdk:Hangul-Hieuh #xebe)
(define-public gdk:Hangul-A #xebf)
(define-public gdk:Hangul-AE #xec0)
(define-public gdk:Hangul-YA #xec1)
(define-public gdk:Hangul-YAE #xec2)
(define-public gdk:Hangul-EO #xec3)
(define-public gdk:Hangul-E #xec4)
(define-public gdk:Hangul-YEO #xec5)
(define-public gdk:Hangul-YE #xec6)
(define-public gdk:Hangul-O #xec7)
(define-public gdk:Hangul-WA #xec8)
(define-public gdk:Hangul-WAE #xec9)
(define-public gdk:Hangul-OE #xeca)
(define-public gdk:Hangul-YO #xecb)
(define-public gdk:Hangul-U #xecc)
(define-public gdk:Hangul-WEO #xecd)
(define-public gdk:Hangul-WE #xece)
(define-public gdk:Hangul-WI #xecf)
(define-public gdk:Hangul-YU #xed0)
(define-public gdk:Hangul-EU #xed1)
(define-public gdk:Hangul-YI #xed2)
(define-public gdk:Hangul-I #xed3)
(define-public gdk:Hangul-J-Kiyeog #xed4)
(define-public gdk:Hangul-J-SsangKiyeog #xed5)
(define-public gdk:Hangul-J-KiyeogSios #xed6)
(define-public gdk:Hangul-J-Nieun #xed7)
(define-public gdk:Hangul-J-NieunJieuj #xed8)
(define-public gdk:Hangul-J-NieunHieuh #xed9)
(define-public gdk:Hangul-J-Dikeud #xeda)
(define-public gdk:Hangul-J-Rieul #xedb)
(define-public gdk:Hangul-J-RieulKiyeog #xedc)
(define-public gdk:Hangul-J-RieulMieum #xedd)
(define-public gdk:Hangul-J-RieulPieub #xede)
(define-public gdk:Hangul-J-RieulSios #xedf)
(define-public gdk:Hangul-J-RieulTieut #xee0)
(define-public gdk:Hangul-J-RieulPhieuf #xee1)
(define-public gdk:Hangul-J-RieulHieuh #xee2)
(define-public gdk:Hangul-J-Mieum #xee3)
(define-public gdk:Hangul-J-Pieub #xee4)
(define-public gdk:Hangul-J-PieubSios #xee5)
(define-public gdk:Hangul-J-Sios #xee6)
(define-public gdk:Hangul-J-SsangSios #xee7)
(define-public gdk:Hangul-J-Ieung #xee8)
(define-public gdk:Hangul-J-Jieuj #xee9)
(define-public gdk:Hangul-J-Cieuc #xeea)
(define-public gdk:Hangul-J-Khieuq #xeeb)
(define-public gdk:Hangul-J-Tieut #xeec)
(define-public gdk:Hangul-J-Phieuf #xeed)
(define-public gdk:Hangul-J-Hieuh #xeee)
(define-public gdk:Hangul-RieulYeorinHieuh #xeef)
(define-public gdk:Hangul-SunkyeongeumMieum #xef0)
(define-public gdk:Hangul-SunkyeongeumPieub #xef1)
(define-public gdk:Hangul-PanSios #xef2)
(define-public gdk:Hangul-KkogjiDalrinIeung #xef3)
(define-public gdk:Hangul-SunkyeongeumPhieuf #xef4)
(define-public gdk:Hangul-YeorinHieuh #xef5)
(define-public gdk:Hangul-AraeA #xef6)
(define-public gdk:Hangul-AraeAE #xef7)
(define-public gdk:Hangul-J-PanSios #xef8)
(define-public gdk:Hangul-J-KkogjiDalrinIeung #xef9)
(define-public gdk:Hangul-J-YeorinHieuh #xefa)
(define-public gdk:Korean-Won #xeff)
(define-public gdk:EcuSign #x20a0)
(define-public gdk:ColonSign #x20a1)
(define-public gdk:CruzeiroSign #x20a2)
(define-public gdk:FFrancSign #x20a3)
(define-public gdk:LiraSign #x20a4)
(define-public gdk:MillSign #x20a5)
(define-public gdk:NairaSign #x20a6)
(define-public gdk:PesetaSign #x20a7)
(define-public gdk:RupeeSign #x20a8)
(define-public gdk:WonSign #x20a9)
(define-public gdk:NewSheqelSign #x20aa)
(define-public gdk:DongSign #x20ab)
(define-public gdk:EuroSign #x20ac)
