-----------------------------------------------------------------------
--               GtkAda - Ada95 binding for Gtk+/Gnome               --
--                                                                   --
--                    Copyright (C) 2010, AdaCore                    --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-----------------------------------------------------------------------

with Glib.Object; use Glib.Object;
with System; use System;

package body Gdk.Cairo is

   ------------
   -- Create --
   ------------

   function Create (Drawable : Gdk_Drawable) return Cairo_Context is
      function Internal (S : System.Address) return Cairo_Context;
      pragma Import (C, Internal, "gdk_cairo_create");

      Cr : Cairo_Context;
   begin
      Cr := Internal (To_Address (Drawable));
      return Cr;
   end Create;

   -----------------------
   -- Set_Source_Pixbuf --
   -----------------------

   procedure Set_Source_Pixbuf
     (Cr       : Cairo_Context;
      Pixbuf   : Gdk_Pixbuf;
      Pixbuf_X : Gdouble;
      Pixbuf_Y : Gdouble)
   is
      procedure Internal (Cr     : Cairo_Context;
                          Pixbuf : System.Address;
                          Pixbuf_X, Pixbuf_Y : Gdouble);
      pragma Import (C, Internal, "gdk_cairo_set_source_pixbuf");
   begin
      Internal (Cr, Get_Object (Pixbuf), Pixbuf_X, Pixbuf_Y);
   end Set_Source_Pixbuf;

end Gdk.Cairo;
