/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

public abstract class Interpolator {
    public static final int LINEAR = 1;
    public static final int STEP = 2;
    protected static final int DEFAULT_SIZE = 20;
    protected static final int ARRAY_INCREMENT = 5;
    protected int allocatedSize;
    protected int currentSize;
    protected float[] keys;
    protected final int interpolationType;

    protected Interpolator() {
        this(20, 1);
    }

    protected Interpolator(int n) {
        this(n, 1);
    }

    protected Interpolator(int n, int n2) {
        this.interpolationType = n2;
        this.keys = new float[n];
    }

    public void clear() {
        this.currentSize = 0;
    }

    protected int findKeyIndex(float f) {
        if (this.currentSize == 0 || f <= this.keys[0]) {
            return -1;
        }
        if (f == this.keys[this.currentSize - 1]) {
            return this.currentSize - 1;
        }
        if (f > this.keys[this.currentSize - 1]) {
            return this.currentSize;
        }
        int n = 0;
        int n2 = this.currentSize - 1;
        int n3 = this.currentSize >> 1;
        while (n < n2) {
            float f2 = this.keys[n3];
            if (f2 >= f) {
                n2 = n3 - 1;
            } else {
                n = n3;
            }
            n3 = n + n2 + 1 >> 1;
        }
        return n3;
    }
}

