/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <InteractorAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for InteractorAttributes::NavigationMode
//

static const char *NavigationMode_strings[] = {
"Trackball", "Dolly", "Flythrough"
};

std::string
InteractorAttributes::NavigationMode_ToString(InteractorAttributes::NavigationMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return NavigationMode_strings[index];
}

std::string
InteractorAttributes::NavigationMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return NavigationMode_strings[index];
}

bool
InteractorAttributes::NavigationMode_FromString(const std::string &s, InteractorAttributes::NavigationMode &val)
{
    val = InteractorAttributes::Trackball;
    for(int i = 0; i < 3; ++i)
    {
        if(s == NavigationMode_strings[i])
        {
            val = (NavigationMode)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for InteractorAttributes::BoundingBoxMode
//

static const char *BoundingBoxMode_strings[] = {
"Always", "Never", "Auto"
};

std::string
InteractorAttributes::BoundingBoxMode_ToString(InteractorAttributes::BoundingBoxMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return BoundingBoxMode_strings[index];
}

std::string
InteractorAttributes::BoundingBoxMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return BoundingBoxMode_strings[index];
}

bool
InteractorAttributes::BoundingBoxMode_FromString(const std::string &s, InteractorAttributes::BoundingBoxMode &val)
{
    val = InteractorAttributes::Always;
    for(int i = 0; i < 3; ++i)
    {
        if(s == BoundingBoxMode_strings[i])
        {
            val = (BoundingBoxMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: InteractorAttributes::InteractorAttributes
//
// Purpose: 
//   Init utility for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void InteractorAttributes::Init()
{
    showGuidelines = true;
    clampSquare = false;
    fillViewportOnZoom = true;
    navigationMode = Trackball;
    axisArraySnap = true;
    boundingBoxMode = Auto;

    InteractorAttributes::SelectAll();
}

// ****************************************************************************
// Method: InteractorAttributes::InteractorAttributes
//
// Purpose: 
//   Copy utility for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void InteractorAttributes::Copy(const InteractorAttributes &obj)
{
    showGuidelines = obj.showGuidelines;
    clampSquare = obj.clampSquare;
    fillViewportOnZoom = obj.fillViewportOnZoom;
    navigationMode = obj.navigationMode;
    axisArraySnap = obj.axisArraySnap;
    boundingBoxMode = obj.boundingBoxMode;

    InteractorAttributes::SelectAll();
}

// Type map format string
const char *InteractorAttributes::TypeMapFormatString = INTERACTORATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t InteractorAttributes::TmfsStruct = {INTERACTORATTRIBUTES_TMFS};


// ****************************************************************************
// Method: InteractorAttributes::InteractorAttributes
//
// Purpose: 
//   Default constructor for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes::InteractorAttributes() : 
    AttributeSubject(InteractorAttributes::TypeMapFormatString)
{
    InteractorAttributes::Init();
}

// ****************************************************************************
// Method: InteractorAttributes::InteractorAttributes
//
// Purpose: 
//   Constructor for the derived classes of InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes::InteractorAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    InteractorAttributes::Init();
}

// ****************************************************************************
// Method: InteractorAttributes::InteractorAttributes
//
// Purpose: 
//   Copy constructor for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes::InteractorAttributes(const InteractorAttributes &obj) : 
    AttributeSubject(InteractorAttributes::TypeMapFormatString)
{
    InteractorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: InteractorAttributes::InteractorAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes::InteractorAttributes(const InteractorAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    InteractorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: InteractorAttributes::~InteractorAttributes
//
// Purpose: 
//   Destructor for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes::~InteractorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: InteractorAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes& 
InteractorAttributes::operator = (const InteractorAttributes &obj)
{
    if (this == &obj) return *this;

    InteractorAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: InteractorAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::operator == (const InteractorAttributes &obj) const
{
    // Create the return value
    return ((showGuidelines == obj.showGuidelines) &&
            (clampSquare == obj.clampSquare) &&
            (fillViewportOnZoom == obj.fillViewportOnZoom) &&
            (navigationMode == obj.navigationMode) &&
            (axisArraySnap == obj.axisArraySnap) &&
            (boundingBoxMode == obj.boundingBoxMode));
}

// ****************************************************************************
// Method: InteractorAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::operator != (const InteractorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: InteractorAttributes::TypeName
//
// Purpose: 
//   Type name method for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
InteractorAttributes::TypeName() const
{
    return "InteractorAttributes";
}

// ****************************************************************************
// Method: InteractorAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const InteractorAttributes *tmp = (const InteractorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: InteractorAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
InteractorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new InteractorAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: InteractorAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
InteractorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new InteractorAttributes(*this);
    else
        retval = new InteractorAttributes;

    return retval;
}

// ****************************************************************************
// Method: InteractorAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
InteractorAttributes::SelectAll()
{
    Select(ID_showGuidelines,     (void *)&showGuidelines);
    Select(ID_clampSquare,        (void *)&clampSquare);
    Select(ID_fillViewportOnZoom, (void *)&fillViewportOnZoom);
    Select(ID_navigationMode,     (void *)&navigationMode);
    Select(ID_axisArraySnap,      (void *)&axisArraySnap);
    Select(ID_boundingBoxMode,    (void *)&boundingBoxMode);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: InteractorAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    InteractorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for InteractorAttributes.
    DataNode *node = new DataNode("InteractorAttributes");

    if(completeSave || !FieldsEqual(ID_showGuidelines, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showGuidelines", showGuidelines));
    }

    if(completeSave || !FieldsEqual(ID_clampSquare, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("clampSquare", clampSquare));
    }

    if(completeSave || !FieldsEqual(ID_fillViewportOnZoom, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fillViewportOnZoom", fillViewportOnZoom));
    }

    if(completeSave || !FieldsEqual(ID_navigationMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("navigationMode", NavigationMode_ToString(navigationMode)));
    }

    if(completeSave || !FieldsEqual(ID_axisArraySnap, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axisArraySnap", axisArraySnap));
    }

    if(completeSave || !FieldsEqual(ID_boundingBoxMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("boundingBoxMode", BoundingBoxMode_ToString(boundingBoxMode)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: InteractorAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
InteractorAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("InteractorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("showGuidelines")) != 0)
        SetShowGuidelines(node->AsBool());
    if((node = searchNode->GetNode("clampSquare")) != 0)
        SetClampSquare(node->AsBool());
    if((node = searchNode->GetNode("fillViewportOnZoom")) != 0)
        SetFillViewportOnZoom(node->AsBool());
    if((node = searchNode->GetNode("navigationMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetNavigationMode(NavigationMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            NavigationMode value;
            if(NavigationMode_FromString(node->AsString(), value))
                SetNavigationMode(value);
        }
    }
    if((node = searchNode->GetNode("axisArraySnap")) != 0)
        SetAxisArraySnap(node->AsBool());
    if((node = searchNode->GetNode("boundingBoxMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetBoundingBoxMode(BoundingBoxMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            BoundingBoxMode value;
            if(BoundingBoxMode_FromString(node->AsString(), value))
                SetBoundingBoxMode(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
InteractorAttributes::SetShowGuidelines(bool showGuidelines_)
{
    showGuidelines = showGuidelines_;
    Select(ID_showGuidelines, (void *)&showGuidelines);
}

void
InteractorAttributes::SetClampSquare(bool clampSquare_)
{
    clampSquare = clampSquare_;
    Select(ID_clampSquare, (void *)&clampSquare);
}

void
InteractorAttributes::SetFillViewportOnZoom(bool fillViewportOnZoom_)
{
    fillViewportOnZoom = fillViewportOnZoom_;
    Select(ID_fillViewportOnZoom, (void *)&fillViewportOnZoom);
}

void
InteractorAttributes::SetNavigationMode(InteractorAttributes::NavigationMode navigationMode_)
{
    navigationMode = navigationMode_;
    Select(ID_navigationMode, (void *)&navigationMode);
}

void
InteractorAttributes::SetAxisArraySnap(bool axisArraySnap_)
{
    axisArraySnap = axisArraySnap_;
    Select(ID_axisArraySnap, (void *)&axisArraySnap);
}

void
InteractorAttributes::SetBoundingBoxMode(InteractorAttributes::BoundingBoxMode boundingBoxMode_)
{
    boundingBoxMode = boundingBoxMode_;
    Select(ID_boundingBoxMode, (void *)&boundingBoxMode);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
InteractorAttributes::GetShowGuidelines() const
{
    return showGuidelines;
}

bool
InteractorAttributes::GetClampSquare() const
{
    return clampSquare;
}

bool
InteractorAttributes::GetFillViewportOnZoom() const
{
    return fillViewportOnZoom;
}

InteractorAttributes::NavigationMode
InteractorAttributes::GetNavigationMode() const
{
    return NavigationMode(navigationMode);
}

bool
InteractorAttributes::GetAxisArraySnap() const
{
    return axisArraySnap;
}

InteractorAttributes::BoundingBoxMode
InteractorAttributes::GetBoundingBoxMode() const
{
    return BoundingBoxMode(boundingBoxMode);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: InteractorAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
InteractorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_showGuidelines:     return "showGuidelines";
    case ID_clampSquare:        return "clampSquare";
    case ID_fillViewportOnZoom: return "fillViewportOnZoom";
    case ID_navigationMode:     return "navigationMode";
    case ID_axisArraySnap:      return "axisArraySnap";
    case ID_boundingBoxMode:    return "boundingBoxMode";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: InteractorAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
InteractorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_showGuidelines:     return FieldType_bool;
    case ID_clampSquare:        return FieldType_bool;
    case ID_fillViewportOnZoom: return FieldType_bool;
    case ID_navigationMode:     return FieldType_enum;
    case ID_axisArraySnap:      return FieldType_bool;
    case ID_boundingBoxMode:    return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: InteractorAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
InteractorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_showGuidelines:     return "bool";
    case ID_clampSquare:        return "bool";
    case ID_fillViewportOnZoom: return "bool";
    case ID_navigationMode:     return "enum";
    case ID_axisArraySnap:      return "bool";
    case ID_boundingBoxMode:    return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: InteractorAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const InteractorAttributes &obj = *((const InteractorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_showGuidelines:
        {  // new scope
        retval = (showGuidelines == obj.showGuidelines);
        }
        break;
    case ID_clampSquare:
        {  // new scope
        retval = (clampSquare == obj.clampSquare);
        }
        break;
    case ID_fillViewportOnZoom:
        {  // new scope
        retval = (fillViewportOnZoom == obj.fillViewportOnZoom);
        }
        break;
    case ID_navigationMode:
        {  // new scope
        retval = (navigationMode == obj.navigationMode);
        }
        break;
    case ID_axisArraySnap:
        {  // new scope
        retval = (axisArraySnap == obj.axisArraySnap);
        }
        break;
    case ID_boundingBoxMode:
        {  // new scope
        retval = (boundingBoxMode == obj.boundingBoxMode);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

