/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SILAttributes.h>
#include <DataNode.h>
#include <NamespaceAttributes.h>
#include <SILMatrixAttributes.h>
#include <SILArrayAttributes.h>

// ****************************************************************************
// Method: SILAttributes::SILAttributes
//
// Purpose: 
//   Init utility for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SILAttributes::Init()
{
    nSets = 0;
    nCollections = 0;

    SILAttributes::SelectAll();
}

// ****************************************************************************
// Method: SILAttributes::SILAttributes
//
// Purpose: 
//   Copy utility for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SILAttributes::Copy(const SILAttributes &obj)
{
    AttributeGroupVector::const_iterator pos;

    nSets = obj.nSets;
    setNames = obj.setNames;
    setIds = obj.setIds;
    wholeList = obj.wholeList;
    nCollections = obj.nCollections;
    category = obj.category;
    role = obj.role;
    superset = obj.superset;
    // *** Copy the nspace field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = nspace.begin(); pos != nspace.end(); ++pos)
        delete *pos;
    nspace.clear();
    if(obj.nspace.size() > 0)
        nspace.reserve(obj.nspace.size());
    // Duplicate the nspace from obj.
    for(pos = obj.nspace.begin(); pos != obj.nspace.end(); ++pos)
    {
        NamespaceAttributes *oldNamespaceAttributes = (NamespaceAttributes *)(*pos);
        NamespaceAttributes *newNamespaceAttributes = new NamespaceAttributes(*oldNamespaceAttributes);
        nspace.push_back(newNamespaceAttributes);
    }

    // *** Copy the matrices field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = matrices.begin(); pos != matrices.end(); ++pos)
        delete *pos;
    matrices.clear();
    if(obj.matrices.size() > 0)
        matrices.reserve(obj.matrices.size());
    // Duplicate the matrices from obj.
    for(pos = obj.matrices.begin(); pos != obj.matrices.end(); ++pos)
    {
        SILMatrixAttributes *oldSILMatrixAttributes = (SILMatrixAttributes *)(*pos);
        SILMatrixAttributes *newSILMatrixAttributes = new SILMatrixAttributes(*oldSILMatrixAttributes);
        matrices.push_back(newSILMatrixAttributes);
    }

    // *** Copy the arrays field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = arrays.begin(); pos != arrays.end(); ++pos)
        delete *pos;
    arrays.clear();
    if(obj.arrays.size() > 0)
        arrays.reserve(obj.arrays.size());
    // Duplicate the arrays from obj.
    for(pos = obj.arrays.begin(); pos != obj.arrays.end(); ++pos)
    {
        SILArrayAttributes *oldSILArrayAttributes = (SILArrayAttributes *)(*pos);
        SILArrayAttributes *newSILArrayAttributes = new SILArrayAttributes(*oldSILArrayAttributes);
        arrays.push_back(newSILArrayAttributes);
    }

    order = obj.order;

    SILAttributes::SelectAll();
}

// Type map format string
const char *SILAttributes::TypeMapFormatString = SILATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SILAttributes::TmfsStruct = {SILATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SILAttributes::SILAttributes
//
// Purpose: 
//   Default constructor for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILAttributes::SILAttributes() : 
    AttributeSubject(SILAttributes::TypeMapFormatString)
{
    SILAttributes::Init();
}

// ****************************************************************************
// Method: SILAttributes::SILAttributes
//
// Purpose: 
//   Constructor for the derived classes of SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILAttributes::SILAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SILAttributes::Init();
}

// ****************************************************************************
// Method: SILAttributes::SILAttributes
//
// Purpose: 
//   Copy constructor for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILAttributes::SILAttributes(const SILAttributes &obj) : 
    AttributeSubject(SILAttributes::TypeMapFormatString)
{
    SILAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SILAttributes::SILAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILAttributes::SILAttributes(const SILAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SILAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SILAttributes::~SILAttributes
//
// Purpose: 
//   Destructor for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILAttributes::~SILAttributes()
{
    AttributeGroupVector::iterator pos;

    // Destroy the nspace field.
    for(pos = nspace.begin(); pos != nspace.end(); ++pos)
        delete *pos;
    // Destroy the matrices field.
    for(pos = matrices.begin(); pos != matrices.end(); ++pos)
        delete *pos;
    // Destroy the arrays field.
    for(pos = arrays.begin(); pos != arrays.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: SILAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILAttributes& 
SILAttributes::operator = (const SILAttributes &obj)
{
    if (this == &obj) return *this;

    SILAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SILAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::operator == (const SILAttributes &obj) const
{
    bool nspace_equal = (obj.nspace.size() == nspace.size());
    for(size_t i = 0; (i < nspace.size()) && nspace_equal; ++i)
    {
        // Make references to NamespaceAttributes from AttributeGroup *.
        const NamespaceAttributes &nspace1 = *((const NamespaceAttributes *)(nspace[i]));
        const NamespaceAttributes &nspace2 = *((const NamespaceAttributes *)(obj.nspace[i]));
        nspace_equal = (nspace1 == nspace2);
    }

    bool matrices_equal = (obj.matrices.size() == matrices.size());
    for(size_t i = 0; (i < matrices.size()) && matrices_equal; ++i)
    {
        // Make references to SILMatrixAttributes from AttributeGroup *.
        const SILMatrixAttributes &matrices1 = *((const SILMatrixAttributes *)(matrices[i]));
        const SILMatrixAttributes &matrices2 = *((const SILMatrixAttributes *)(obj.matrices[i]));
        matrices_equal = (matrices1 == matrices2);
    }

    bool arrays_equal = (obj.arrays.size() == arrays.size());
    for(size_t i = 0; (i < arrays.size()) && arrays_equal; ++i)
    {
        // Make references to SILArrayAttributes from AttributeGroup *.
        const SILArrayAttributes &arrays1 = *((const SILArrayAttributes *)(arrays[i]));
        const SILArrayAttributes &arrays2 = *((const SILArrayAttributes *)(obj.arrays[i]));
        arrays_equal = (arrays1 == arrays2);
    }

    // Create the return value
    return ((nSets == obj.nSets) &&
            (setNames == obj.setNames) &&
            (setIds == obj.setIds) &&
            (wholeList == obj.wholeList) &&
            (nCollections == obj.nCollections) &&
            (category == obj.category) &&
            (role == obj.role) &&
            (superset == obj.superset) &&
            nspace_equal &&
            matrices_equal &&
            arrays_equal &&
            (order == obj.order));
}

// ****************************************************************************
// Method: SILAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::operator != (const SILAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SILAttributes::TypeName
//
// Purpose: 
//   Type name method for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SILAttributes::TypeName() const
{
    return "SILAttributes";
}

// ****************************************************************************
// Method: SILAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SILAttributes *tmp = (const SILAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SILAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SILAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SILAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SILAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SILAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SILAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SILAttributes(*this);
    else
        retval = new SILAttributes;

    return retval;
}

// ****************************************************************************
// Method: SILAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::SelectAll()
{
    Select(ID_nSets,        (void *)&nSets);
    Select(ID_setNames,     (void *)&setNames);
    Select(ID_setIds,       (void *)&setIds);
    Select(ID_wholeList,    (void *)&wholeList);
    Select(ID_nCollections, (void *)&nCollections);
    Select(ID_category,     (void *)&category);
    Select(ID_role,         (void *)&role);
    Select(ID_superset,     (void *)&superset);
    Select(ID_nspace,       (void *)&nspace);
    Select(ID_matrices,     (void *)&matrices);
    Select(ID_arrays,       (void *)&arrays);
    Select(ID_order,        (void *)&order);
}

// ****************************************************************************
// Method: SILAttributes::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
SILAttributes::CreateSubAttributeGroup(int attr_id)
{
    AttributeGroup *retval = 0;
    switch(attr_id)
    {
    case ID_nspace:
        retval = new NamespaceAttributes;
        break;
    case ID_matrices:
        retval = new SILMatrixAttributes;
        break;
    case ID_arrays:
        retval = new SILArrayAttributes;
        break;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SILAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SILAttributes.
    DataNode *node = new DataNode("SILAttributes");

    if(completeSave || !FieldsEqual(ID_nSets, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nSets", nSets));
    }

    if(completeSave || !FieldsEqual(ID_setNames, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("setNames", setNames));
    }

    if(completeSave || !FieldsEqual(ID_setIds, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("setIds", setIds));
    }

    if(completeSave || !FieldsEqual(ID_wholeList, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("wholeList", wholeList));
    }

    if(completeSave || !FieldsEqual(ID_nCollections, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nCollections", nCollections));
    }

    if(completeSave || !FieldsEqual(ID_category, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("category", category));
    }

    if(completeSave || !FieldsEqual(ID_role, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("role", role));
    }

    if(completeSave || !FieldsEqual(ID_superset, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("superset", superset));
    }

    if(completeSave || !FieldsEqual(ID_nspace, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < nspace.size(); ++i)
            nspace[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(ID_matrices, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < matrices.size(); ++i)
            matrices[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(ID_arrays, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < arrays.size(); ++i)
            arrays[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(ID_order, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("order", order));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SILAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SILAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    if((node = searchNode->GetNode("nSets")) != 0)
        SetNSets(node->AsInt());
    if((node = searchNode->GetNode("setNames")) != 0)
        SetSetNames(node->AsStringVector());
    if((node = searchNode->GetNode("setIds")) != 0)
        SetSetIds(node->AsIntVector());
    if((node = searchNode->GetNode("wholeList")) != 0)
        SetWholeList(node->AsIntVector());
    if((node = searchNode->GetNode("nCollections")) != 0)
        SetNCollections(node->AsInt());
    if((node = searchNode->GetNode("category")) != 0)
        SetCategory(node->AsStringVector());
    if((node = searchNode->GetNode("role")) != 0)
        SetRole(node->AsIntVector());
    if((node = searchNode->GetNode("superset")) != 0)
        SetSuperset(node->AsIntVector());

    // Clear all the NamespaceAttributess if we got any.
    bool clearedNspaces = false;
    // Go through all of the children and construct a new
    // NamespaceAttributes for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("NamespaceAttributes"))
            {
                if (!clearedNspaces)
                {
                    ClearNspaces();
                    clearedNspaces = true;
                }
                NamespaceAttributes temp;
                temp.SetFromNode(children[i]);
                AddNspace(temp);
            }
        }
    }


    // Clear all the SILMatrixAttributess if we got any.
    bool clearedMatrices = false;
    // Go through all of the children and construct a new
    // SILMatrixAttributes for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("SILMatrixAttributes"))
            {
                if (!clearedMatrices)
                {
                    ClearMatrices();
                    clearedMatrices = true;
                }
                SILMatrixAttributes temp;
                temp.SetFromNode(children[i]);
                AddMatrices(temp);
            }
        }
    }


    // Clear all the SILArrayAttributess if we got any.
    bool clearedArrays = false;
    // Go through all of the children and construct a new
    // SILArrayAttributes for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("SILArrayAttributes"))
            {
                if (!clearedArrays)
                {
                    ClearArrays();
                    clearedArrays = true;
                }
                SILArrayAttributes temp;
                temp.SetFromNode(children[i]);
                AddArrays(temp);
            }
        }
    }

    if((node = searchNode->GetNode("order")) != 0)
        SetOrder(node->AsIntVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SILAttributes::SetNSets(int nSets_)
{
    nSets = nSets_;
    Select(ID_nSets, (void *)&nSets);
}

void
SILAttributes::SetSetNames(const stringVector &setNames_)
{
    setNames = setNames_;
    Select(ID_setNames, (void *)&setNames);
}

void
SILAttributes::SetSetIds(const intVector &setIds_)
{
    setIds = setIds_;
    Select(ID_setIds, (void *)&setIds);
}

void
SILAttributes::SetWholeList(const intVector &wholeList_)
{
    wholeList = wholeList_;
    Select(ID_wholeList, (void *)&wholeList);
}

void
SILAttributes::SetNCollections(int nCollections_)
{
    nCollections = nCollections_;
    Select(ID_nCollections, (void *)&nCollections);
}

void
SILAttributes::SetCategory(const stringVector &category_)
{
    category = category_;
    Select(ID_category, (void *)&category);
}

void
SILAttributes::SetRole(const intVector &role_)
{
    role = role_;
    Select(ID_role, (void *)&role);
}

void
SILAttributes::SetSuperset(const intVector &superset_)
{
    superset = superset_;
    Select(ID_superset, (void *)&superset);
}

void
SILAttributes::SetOrder(const intVector &order_)
{
    order = order_;
    Select(ID_order, (void *)&order);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
SILAttributes::GetNSets() const
{
    return nSets;
}

const stringVector &
SILAttributes::GetSetNames() const
{
    return setNames;
}

stringVector &
SILAttributes::GetSetNames()
{
    return setNames;
}

const intVector &
SILAttributes::GetSetIds() const
{
    return setIds;
}

intVector &
SILAttributes::GetSetIds()
{
    return setIds;
}

const intVector &
SILAttributes::GetWholeList() const
{
    return wholeList;
}

intVector &
SILAttributes::GetWholeList()
{
    return wholeList;
}

int
SILAttributes::GetNCollections() const
{
    return nCollections;
}

const stringVector &
SILAttributes::GetCategory() const
{
    return category;
}

stringVector &
SILAttributes::GetCategory()
{
    return category;
}

const intVector &
SILAttributes::GetRole() const
{
    return role;
}

intVector &
SILAttributes::GetRole()
{
    return role;
}

const intVector &
SILAttributes::GetSuperset() const
{
    return superset;
}

intVector &
SILAttributes::GetSuperset()
{
    return superset;
}

const AttributeGroupVector &
SILAttributes::GetNspace() const
{
    return nspace;
}

AttributeGroupVector &
SILAttributes::GetNspace()
{
    return nspace;
}

const AttributeGroupVector &
SILAttributes::GetMatrices() const
{
    return matrices;
}

AttributeGroupVector &
SILAttributes::GetMatrices()
{
    return matrices;
}

const AttributeGroupVector &
SILAttributes::GetArrays() const
{
    return arrays;
}

AttributeGroupVector &
SILAttributes::GetArrays()
{
    return arrays;
}

const intVector &
SILAttributes::GetOrder() const
{
    return order;
}

intVector &
SILAttributes::GetOrder()
{
    return order;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SILAttributes::SelectSetNames()
{
    Select(ID_setNames, (void *)&setNames);
}

void
SILAttributes::SelectSetIds()
{
    Select(ID_setIds, (void *)&setIds);
}

void
SILAttributes::SelectWholeList()
{
    Select(ID_wholeList, (void *)&wholeList);
}

void
SILAttributes::SelectCategory()
{
    Select(ID_category, (void *)&category);
}

void
SILAttributes::SelectRole()
{
    Select(ID_role, (void *)&role);
}

void
SILAttributes::SelectSuperset()
{
    Select(ID_superset, (void *)&superset);
}

void
SILAttributes::SelectNspace()
{
    Select(ID_nspace, (void *)&nspace);
}

void
SILAttributes::SelectMatrices()
{
    Select(ID_matrices, (void *)&matrices);
}

void
SILAttributes::SelectArrays()
{
    Select(ID_arrays, (void *)&arrays);
}

void
SILAttributes::SelectOrder()
{
    Select(ID_order, (void *)&order);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILAttributes::AddNspace
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::AddNspace(const NamespaceAttributes &obj)
{
    NamespaceAttributes *newNamespaceAttributes = new NamespaceAttributes(obj);
    nspace.push_back(newNamespaceAttributes);

    // Indicate that things have changed by selecting it.
    Select(ID_nspace, (void *)&nspace);
}

// ****************************************************************************
// Method: SILAttributes::ClearNspaces
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::ClearNspaces()
{
    AttributeGroupVector::iterator pos;

    for(pos = nspace.begin(); pos != nspace.end(); ++pos)
        delete *pos;
    nspace.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_nspace, (void *)&nspace);
}

// ****************************************************************************
// Method: SILAttributes::RemoveNspace
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::RemoveNspace(int index)
{
    AttributeGroupVector::iterator pos = nspace.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != nspace.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != nspace.end())
    {
        delete *pos;
        nspace.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_nspace, (void *)&nspace);
}

// ****************************************************************************
// Method: SILAttributes::GetNumNspaces
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
SILAttributes::GetNumNspaces() const
{
    return (int)nspace.size();
}

// ****************************************************************************
// Method: SILAttributes::GetNspace
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

NamespaceAttributes &
SILAttributes::GetNspace(int i)
{
    return *((NamespaceAttributes *)nspace[i]);
}

// ****************************************************************************
// Method: SILAttributes::GetNspace
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const NamespaceAttributes &
SILAttributes::GetNspace(int i) const
{
    return *((NamespaceAttributes *)nspace[i]);
}

// ****************************************************************************
// Method: SILAttributes::AddMatrices
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::AddMatrices(const SILMatrixAttributes &obj)
{
    SILMatrixAttributes *newSILMatrixAttributes = new SILMatrixAttributes(obj);
    matrices.push_back(newSILMatrixAttributes);

    // Indicate that things have changed by selecting it.
    Select(ID_matrices, (void *)&matrices);
}

// ****************************************************************************
// Method: SILAttributes::ClearMatrices
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::ClearMatrices()
{
    AttributeGroupVector::iterator pos;

    for(pos = matrices.begin(); pos != matrices.end(); ++pos)
        delete *pos;
    matrices.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_matrices, (void *)&matrices);
}

// ****************************************************************************
// Method: SILAttributes::RemoveMatrices
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::RemoveMatrices(int index)
{
    AttributeGroupVector::iterator pos = matrices.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != matrices.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != matrices.end())
    {
        delete *pos;
        matrices.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_matrices, (void *)&matrices);
}

// ****************************************************************************
// Method: SILAttributes::GetNumMatrices
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
SILAttributes::GetNumMatrices() const
{
    return (int)matrices.size();
}

// ****************************************************************************
// Method: SILAttributes::GetMatrices
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILMatrixAttributes &
SILAttributes::GetMatrices(int i)
{
    return *((SILMatrixAttributes *)matrices[i]);
}

// ****************************************************************************
// Method: SILAttributes::GetMatrices
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const SILMatrixAttributes &
SILAttributes::GetMatrices(int i) const
{
    return *((SILMatrixAttributes *)matrices[i]);
}

// ****************************************************************************
// Method: SILAttributes::AddArrays
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::AddArrays(const SILArrayAttributes &obj)
{
    SILArrayAttributes *newSILArrayAttributes = new SILArrayAttributes(obj);
    arrays.push_back(newSILArrayAttributes);

    // Indicate that things have changed by selecting it.
    Select(ID_arrays, (void *)&arrays);
}

// ****************************************************************************
// Method: SILAttributes::ClearArrays
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::ClearArrays()
{
    AttributeGroupVector::iterator pos;

    for(pos = arrays.begin(); pos != arrays.end(); ++pos)
        delete *pos;
    arrays.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_arrays, (void *)&arrays);
}

// ****************************************************************************
// Method: SILAttributes::RemoveArrays
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SILAttributes::RemoveArrays(int index)
{
    AttributeGroupVector::iterator pos = arrays.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != arrays.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != arrays.end())
    {
        delete *pos;
        arrays.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_arrays, (void *)&arrays);
}

// ****************************************************************************
// Method: SILAttributes::GetNumArrays
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
SILAttributes::GetNumArrays() const
{
    return (int)arrays.size();
}

// ****************************************************************************
// Method: SILAttributes::GetArrays
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SILArrayAttributes &
SILAttributes::GetArrays(int i)
{
    return *((SILArrayAttributes *)arrays[i]);
}

// ****************************************************************************
// Method: SILAttributes::GetArrays
//
// Purpose: 
//   This class contains the information needed to represent a SIL.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const SILArrayAttributes &
SILAttributes::GetArrays(int i) const
{
    return *((SILArrayAttributes *)arrays[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SILAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SILAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_nSets:        return "nSets";
    case ID_setNames:     return "setNames";
    case ID_setIds:       return "setIds";
    case ID_wholeList:    return "wholeList";
    case ID_nCollections: return "nCollections";
    case ID_category:     return "category";
    case ID_role:         return "role";
    case ID_superset:     return "superset";
    case ID_nspace:       return "nspace";
    case ID_matrices:     return "matrices";
    case ID_arrays:       return "arrays";
    case ID_order:        return "order";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SILAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SILAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_nSets:        return FieldType_int;
    case ID_setNames:     return FieldType_stringVector;
    case ID_setIds:       return FieldType_intVector;
    case ID_wholeList:    return FieldType_intVector;
    case ID_nCollections: return FieldType_int;
    case ID_category:     return FieldType_stringVector;
    case ID_role:         return FieldType_intVector;
    case ID_superset:     return FieldType_intVector;
    case ID_nspace:       return FieldType_attVector;
    case ID_matrices:     return FieldType_attVector;
    case ID_arrays:       return FieldType_attVector;
    case ID_order:        return FieldType_intVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SILAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SILAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_nSets:        return "int";
    case ID_setNames:     return "stringVector";
    case ID_setIds:       return "intVector";
    case ID_wholeList:    return "intVector";
    case ID_nCollections: return "int";
    case ID_category:     return "stringVector";
    case ID_role:         return "intVector";
    case ID_superset:     return "intVector";
    case ID_nspace:       return "attVector";
    case ID_matrices:     return "attVector";
    case ID_arrays:       return "attVector";
    case ID_order:        return "intVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SILAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SILAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SILAttributes &obj = *((const SILAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_nSets:
        {  // new scope
        retval = (nSets == obj.nSets);
        }
        break;
    case ID_setNames:
        {  // new scope
        retval = (setNames == obj.setNames);
        }
        break;
    case ID_setIds:
        {  // new scope
        retval = (setIds == obj.setIds);
        }
        break;
    case ID_wholeList:
        {  // new scope
        retval = (wholeList == obj.wholeList);
        }
        break;
    case ID_nCollections:
        {  // new scope
        retval = (nCollections == obj.nCollections);
        }
        break;
    case ID_category:
        {  // new scope
        retval = (category == obj.category);
        }
        break;
    case ID_role:
        {  // new scope
        retval = (role == obj.role);
        }
        break;
    case ID_superset:
        {  // new scope
        retval = (superset == obj.superset);
        }
        break;
    case ID_nspace:
        {  // new scope
        bool nspace_equal = (obj.nspace.size() == nspace.size());
        for(size_t i = 0; (i < nspace.size()) && nspace_equal; ++i)
        {
            // Make references to NamespaceAttributes from AttributeGroup *.
            const NamespaceAttributes &nspace1 = *((const NamespaceAttributes *)(nspace[i]));
            const NamespaceAttributes &nspace2 = *((const NamespaceAttributes *)(obj.nspace[i]));
            nspace_equal = (nspace1 == nspace2);
        }

        retval = nspace_equal;
        }
        break;
    case ID_matrices:
        {  // new scope
        bool matrices_equal = (obj.matrices.size() == matrices.size());
        for(size_t i = 0; (i < matrices.size()) && matrices_equal; ++i)
        {
            // Make references to SILMatrixAttributes from AttributeGroup *.
            const SILMatrixAttributes &matrices1 = *((const SILMatrixAttributes *)(matrices[i]));
            const SILMatrixAttributes &matrices2 = *((const SILMatrixAttributes *)(obj.matrices[i]));
            matrices_equal = (matrices1 == matrices2);
        }

        retval = matrices_equal;
        }
        break;
    case ID_arrays:
        {  // new scope
        bool arrays_equal = (obj.arrays.size() == arrays.size());
        for(size_t i = 0; (i < arrays.size()) && arrays_equal; ++i)
        {
            // Make references to SILArrayAttributes from AttributeGroup *.
            const SILArrayAttributes &arrays1 = *((const SILArrayAttributes *)(arrays[i]));
            const SILArrayAttributes &arrays2 = *((const SILArrayAttributes *)(obj.arrays[i]));
            arrays_equal = (arrays1 == arrays2);
        }

        retval = arrays_equal;
        }
        break;
    case ID_order:
        {  // new scope
        retval = (order == obj.order);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

