<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<!-- 
     This file contains templates for upgrading PhotoML files from
     DTD version 0.08 to version 0.09.

     Copyright © 2005 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

<xsl:output method="xml" indent="yes"
	    doctype-public="-//BW//DTD PhotoML 0.09//EN"
            doctype-system="photo.dtd"/>


<!-- Default template -->
<xsl:template match="*|@*|text()|processing-instruction()|comment()">
  <xsl:copy>
    <xsl:apply-templates select="*|@*|text()|processing-instruction()|comment()"/>
  </xsl:copy>
</xsl:template>


<!-- Remove outermost collection elements -->
<xsl:template match="collection">
  <xsl:apply-templates/>
</xsl:template>


<!-- Insert inner collection elements -->
<xsl:template match="roll|sheet|digital">
  <xsl:copy>
    <xsl:apply-templates select="@id"/>
    <xsl:if test="ancestor::collection">
      <xsl:text>&#10;      </xsl:text>
      <collection id="{ancestor::collection/@id}" cgid="{@cid}"/>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>


<!-- Handle changes to defaults combine attribute -->
<xsl:template match="defaults">
  <defaults>
    <xsl:choose>
      <xsl:when test="@combine='set'">
        <xsl:attribute name="combine">
          <xsl:text>replace</xsl:text>
        </xsl:attribute>
      </xsl:when>
      <xsl:when test="@combine='graft'">
        <xsl:comment> Upgrade warning: The "graft" combine mode has been removed. Defaults need to be manually edited to make uses of new modes "replace", "merge", or "select". </xsl:comment>
        <xsl:message>
          <xsl:text>Warning: manual editing of output required</xsl:text>
        </xsl:message>
      </xsl:when>
    </xsl:choose>
    <xsl:apply-templates/>
  </defaults>
</xsl:template>



</xsl:stylesheet>
