package Filter;
our $VERSION = '2004-01-20';
our @ISA = 'BaseObject';

use Classes::Criteria;

sub new {
	my $proto = shift;
	my @Constructor_Parameters = @_;

	my $class = ref( $proto ) || $proto;

	my $self = bless $proto->SUPER::new( @Constructor_Parameters ), $class;

	#

	$self->{'Formula'}			= '';
	$self->{'comment'}			= '';
	$self->{'desc'}				= 1;
	$self->{'by_page'}			= $::conf{'nb_resbypage'};
	$self->{'FileName'}			= '';

	$self->{'CriteriaList'}		= [];
	$self->{'CriteriaNb'}		= 0;
	$self->{'SQL_EltNb'}		= '';
	$self->{'SQL_EltList'}		= '';

	$self->{'GroupCriteriaList'}= [];
	$self->{'GroupCriteriaNb'}	= 0;
	$self->{'SQL_GroupNb'}		= '';
	$self->{'SQL_GroupList'}	= '';

	#

	my %Hashage = @Constructor_Parameters;
	foreach my $Key ( keys %Hashage )
	{
		$self->set( $Key, $Hashage{ $Key } );
	}

	return $self;
}

#################################################################################################################

sub add_Criteria($$)
{
	my $self = shift;
	my $Criteria = shift;

	my @CritList = @{$self->{'CriteriaList'}};
	push @CritList, $Criteria;
	$self->{'CriteriaList'} = \@CritList;
	$self->{'CriteriaNb'} ++;
}

sub get_Criteria_by_num($$)
{
	my $self = shift;
	my $CritNum = int( shift );

	return $self->{'CriteriaList'}->[$CritNum];
}

sub del_Criteria_by_num($$)
{
	my $self = shift;
	my $CritNum = int( shift );

	my @CritList = @{$self->{'CriteriaList'}};
	my @Part1 = @CritList[0, $CritNum - 1];
	my @Part2 = @CritList[$CritNum + 1, $#CritList];

	$self->{'CriteriaList'} = \@CritList;
	$self->{'CriteriaNb'} --;
}

#################################################################################################################

sub add_GroupCriteria($$)
{
	my $self = shift;
	my $Criteria = shift;

	my @CritList = @{$self->{'GroupCriteriaList'}};
	push @CritList, $Criteria;
	$self->{'GroupCriteriaList'} = \@CritList;
	$self->{'GroupCriteriaNb'} ++;
}

sub get_GroupCriteria_by_num($$)
{
	my $self = shift;
	my $CritNum = int( shift );

	return $self->{'GroupCriteriaList'}->[$CritNum];
}

sub del_GroupCriteria_by_num($$)
{
	my $self = shift;
	my $CritNum = int( shift );

	my @CritList = @{$self->{'GroupCriteriaList'}};
	my @Part1 = @CritList[0, $CritNum - 1];
	my @Part2 = @CritList[$CritNum + 1, $#CritList];

	$self->{'GroupCriteriaList'} = \@CritList;
	$self->{'GroupCriteriaNb'} --;
}

#################################################################################################################

sub create_GroupCriteria($$)
{
	my $Filter = shift;
	my $Grouping = shift;

	if ( $Grouping =~ m/Cn/ )
	{
		my $Crit = Criteria->new();
		$Crit->Table( 'Classification' );
		$Crit->Field( 'name' );
		$Crit->Operator( '=' );
		$Filter->add_GroupCriteria( $Crit );
	}
	if ( $Grouping =~ m/([S|T])a/ )
	{
		my $Type = $1;
		my $Crit = Criteria->new();
		$Crit->Table( 'Address' );
		$Crit->Field( 'address' );
		$Crit->Operator( '=' );
		$Filter->add_GroupCriteria( $Crit );

		my $Crit2 = Criteria->new();
		$Crit2->Table( 'Address' );
		$Crit2->Field( 'parent_type' );
		$Crit2->Operator( '=' );
		$Crit2->Value( $Type );
		$Filter->add_Criteria( $Crit2 );
	}
	if ( $Grouping =~ m/([S|T])p/ )
	{
		my $Type = $1;
		my $Crit = Criteria->new();
		$Crit->Table( 'Service' );
		$Crit->Field( 'port' );
		$Crit->Operator( '=' );
		$Filter->add_GroupCriteria( $Crit );

		my $Crit2=Criteria->new();
		$Crit2->Table( 'Service' );
		$Crit2->Field( 'parent_type' );
		$Crit2->Operator( '=' );
		$Crit2->Value( $Type );
		$Filter->add_Criteria( $Crit2 );
	}
	if ( $Grouping =~ m/Is/ )
	{
		my $Crit = Criteria->new();
		$Crit->Table( 'Impact' );
		$Crit->Field( 'severity' );
		$Crit->Operator( '=' );
		$Filter->add_GroupCriteria( $Crit );
	}
	if ( $Grouping =~ m/Am/ )
	{
		my $Crit = Criteria->new();
		$Crit->Table( 'Analyzer' );
		$Crit->Field( 'model' );
		$Crit->Operator( '=' );
		$Filter->add_GroupCriteria( $Crit );
	}
	if ( $Grouping =~ m/Ai/ )
	{
		my $Crit = Criteria->new();
		$Crit->Table( 'Analyzer' );
		$Crit->Field( 'analyzerid' );
		$Crit->Operator( '=' );
		$Filter->add_GroupCriteria( $Crit );
	}
}

#################################################################################################################

sub concat($$)
{
	my $self = shift;
	my $FileName = shift;

	return $self->load( $FileName, 1 );
}

sub load($$$)
{
	my $self = shift;
	my $FileName = shift;
	my $Add = shift;

	my ( $FilterName ) = ( $FileName =~ m/^generated\/Filters\/(.*)\.flt/ );
	if ( ! defined( $FilterName ) ) {$FilterName = '';};
	if ( $FilterName =~ m/^defaults\// ) {$FilterName = '';};

	if ( -f $FileName )
	{
		my %Filter = $self->ParseFilterFile( $FileName );

		if ( $Add )
		{
			$Filter{'Formula'} = uc( $Filter{'Formula'} );
			$Filter{'Formula'} =~ s/AND/and/g;
			$Filter{'Formula'} =~ s/OR/or/g;
			$Filter{'Formula'} =~ s/([A-Z])/chr(ord($1)+$self->CriteriaNb())/eg;
		}

		foreach my $Key ( keys %Filter )
		{
			if ( length( $Key ) eq 1 )
			{
				my ( $Table, $Field, $Operator, $Value ) = split( /\|/, $Filter{$Key}, 4 );
				my $Crit = Criteria->new();
				$Crit->Table( $Table );
				$Crit->Field( $Field );
				$Crit->Operator( $Operator );

				if ( ! $Add )
				{
					$Value = $Value || $::cgi->param( 'val'.$Key );
				}
				$Crit->Value( $Value );
				$self->add_Criteria( $Crit );
			}
		}

		if ( $Add )
		{
			$self->Formula( ( $self->Formula() ).' AND '.$Filter{'Formula'} );
		}
		else
		{
			$self->Formula( $Filter{'Formula'} );
			$self->comment( $Filter{'comment'} );
			$self->desc( $Filter{'desc'} );
			$self->by_page( $Filter{'by_page'} );
			$self->FileName( $FilterName );
		}

		return 1;
	}
	else
	{
		return 0;
	}
}

sub save_temp($)
{
	my $self = shift;

	my $FileName = 'Temp/'.$::CurUser.'-'.$::ENV{'REMOTE_ADDR'};
	if ( $self->save( 'generated/Filters/'.$FileName.'.flt' ) )
	{
		return $FileName;
	}

	return 0;
}

sub save($$)
{
	my $self = shift;
	my $FileName = shift;

	  # Fall back to element filename if none provided :
	if ( !$FileName ) { $FileName = $self->FileName(); };

	local *FilterFile;
	undef $!;
	open( FilterFile, '>'.$FileName );
	if ( $! and ( $! !~ m/Inappropriate ioctl for device/i ) )
	{
		::error( "Impossible to save Filter to disk : $!" );
		return 0;
	}

	my $Comment = $self->comment();
	$Comment =~ s/\r//g;
	$Comment =~ s/\n+$//;
	$Comment =~ s/\n/<br>/g;

	print FilterFile 'comment='.$Comment."\r\n";
	print FilterFile 'desc='.( $self->desc() || 1 )."\r\n";
	print FilterFile 'by_page='.( $self->by_page() || 30 )."\r\n";

	print FilterFile 'Formula='.uc( $self->Formula() )."\r\n";

	foreach my $Line ( 0..$self->CriteriaNb()-1 )
	{
		my $Crit = $self->get_Criteria_by_num( $Line );
		  # Do not save temporary criteria generated by the GUI :
		if ( ! $Crit->IsTemporary() )
		{
			my $Id = chr( 65 + $Line );

			print FilterFile $Id;
			print FilterFile '='.( $Crit->Table() );
			print FilterFile '|'.( $Crit->Field() );
			print FilterFile '|'.( $Crit->Operator() );
			print FilterFile '|'.( $Crit->Value() );
			print FilterFile "\r\n";
		}
	}

	close( FilterFile );

	return 1;
}

sub get_SQL($)
{
	my $self = shift;

	my @Tables = ();
	my @Joins = ();
	my %Where = ();

	my $DefaultForm = '';

	foreach my $Line ( 0..$self->CriteriaNb()-1 )
	{
		my $Id = chr( 65 + $Line );

		my ( $Table, $Join, $Where ) = $self->get_Criteria_by_num( $Line )->get_SQL();
		if ( $Table )
		{
			push @Tables, $Table;
			push @Joins, $Join;
			$Where{$Id} = $Where;

			$DefaultForm .= "$Id AND ";
		}
	}

	my $GroupForm = '';
	foreach my $Line ( 0..$self->GroupCriteriaNb()-1 )
	{
		my $Id = chr( 65 + $Line + $self->CriteriaNb() );

		my ( $Table, $Join, $Where ) = $self->get_GroupCriteria_by_num( $Line )->get_SQL();
		if ( $Table )
		{
			push @Tables, $Table;
			push @Joins, $Join;
			$Where{$Id} = $Where;
			$GroupForm .= " AND $Id";

			$DefaultForm .= "$Id AND ";
		}
	}

	$DefaultForm =~ s/ AND $//;

	my $prev = 'nonesuch';
	@Tables = grep( $_ ne $prev && ( $prev = $_ ), sort @Tables );
	$prev = 'nonesuch';
	@Joins = grep( $_ ne $prev && ( $prev = $_ ), sort @Joins );

	my $Wheres = lc( '('.$self->Formula().')'.$GroupForm );
	if ( ! $Wheres )
	{
		if ( ! $DefaultForm ) {$DefaultForm = '1';};
		$Wheres = $DefaultForm;
	}

	$Wheres =~ s/&+/ and /g;
	$Wheres =~ s/\|+/ or /g;
	$Wheres =~ s/\!/ not /g;

	$Wheres =~ s/and/AND/g;
	$Wheres =~ s/or/OR/g;
	$Wheres =~ s/not/NOT/g;

	  # Criteria that are not in the Formula are added here with a AND :
	$Wheres = '('.$Wheres.')';
	foreach my $Line ( 0..$self->CriteriaNb()-1 )
	{
		my $Id = chr( 65 + 32 + $Line );
		if ( $Wheres !~ m/$Id/ )
		{
			$Wheres .= ' AND '.$Id;
		}
	}

	$Wheres =~ s/([a-z])/$Where{uc( $1 )}/g;

	my $Tables = join( ',', @Tables );
	my $Joins = join( ' AND ', @Joins );

	return ( $self->BuildStatements( $Tables, $Joins, $Wheres ) );
}

sub BuildStatements($$$$)
{
	my $self = shift;
	my $Table = shift;
	my $Join = shift;
	my $Where = shift;

	  # Find which Alert ident would be used for SELECT, GROUP BY AND ORDER BY :
	my ( $AlertIdent ) = ( $Join =~ m/^([A-Z\._]+)=/i );
	if ( ! $AlertIdent ) {$AlertIdent = 'Prelude_Alert.ident';};
	$Join =~ s/Prelude_Alert\.ident/$AlertIdent/g;
	$Join =~ s/^([A-Z\.\=_]+)\s+(AND\s+)?//i;

	my $Statement_NL = 'SELECT count(DISTINCT '.$AlertIdent.')';
	my $Statement_L = 'SELECT '.$AlertIdent;

	my $Statement_Common = " FROM $Table WHERE ";
	if ( $Join )
	{
		$Statement_Common .= $Join.' AND ';
	}

	$Statement_Common .= $Where;

	  # Remove "(1) AND " in WHERE clauses as it broke PostgreSQL (1 is an integer, not a boolean)
	$Statement_Common =~ s/\(\(1\) AND \(/((/g;

	$Statement_NL .= $Statement_Common.';';
	$Statement_L .= $Statement_Common.' GROUP BY '.$AlertIdent;

	$Statement_L .= ' ORDER BY '.$AlertIdent;
	if ( $self->desc ) {$Statement_L .= ' DESC';};
	$Statement_L .= ' '.::LIMIT_sql().';';

	$self->SQL_EltNb( $Statement_NL );
	$self->SQL_EltList( $Statement_L );
}

##############################################################################

sub get_GroupSQL($$)
{
	my $Filter = shift;
	my $Grouping = shift;

	$Filter->create_GroupCriteria( $Grouping );

	my @Tables = ( 'Prelude_Alert' );
	my @Joins = ();

	my @GroupingKeys = ();
	foreach my $Line ( 0..( $Filter->GroupCriteriaNb() - 1 ) )
	{
		my $Crit = $Filter->get_GroupCriteria_by_num( $Line );
		my ( $Table, $Join, $Where ) = $Crit->get_SQL();
		push @Tables, $Table;
		push @Joins, $Join;

		push @GroupingKeys, ($Table.'.'.$Crit->Field() );
	}

	my $GroupingKey = join( ',', @GroupingKeys );

	#

	my %Where = ();
	my $DefaultForm = '';

	foreach my $Line ( 0..( $Filter->CriteriaNb() - 1 ) )
	{
		my $Id = chr( 65 + $Line );

		my $Crit = $Filter->get_Criteria_by_num( $Line );
		my ( $Table, $Join, $Where ) = $Crit->get_SQL();
		push @Tables, $Table;
		push @Joins, $Join;
		$Where{$Id} = $Where;

		$DefaultForm .= "$Id AND ";
	}

	my $prev = 'nonesuch';
	@Tables = grep( $_ ne $prev && ( $prev = $_ ), sort @Tables );
	$prev = 'nonesuch';
	@Joins = grep( $_ ne $prev && ( $prev = $_ ), sort @Joins );

	my $Tables = join( ',', @Tables );
	my $Joins = join( ' AND ', @Joins );

	my $Wheres = '('.lc( $Filter->Formula() ).')';
	if ( ! $Wheres )
	{
		if ( ! $DefaultForm ) {$DefaultForm = '1';};
		$Wheres = $DefaultForm;
		$Filter->Formula( uc( $Wheres ) );
	}

	$Wheres =~ s/&+/ and /g;
	$Wheres =~ s/\|+/ or /g;
	$Wheres =~ s/\!/ not /g;

	$Wheres =~ s/and/AND/g;
	$Wheres =~ s/or/OR/g;
	$Wheres =~ s/not/NOT/g;

	  # Criteria that are not in the Formula are added here with a AND :
	$Wheres = '('.$Wheres.')';
	foreach my $Line ( 0..( $Filter->CriteriaNb() - 1 ) )
	{
		my $Id = chr( 65 + 32 + $Line );
		if ( $Wheres !~ m/$Id/ )
		{
			$Wheres .= ' AND '.$Id;
		}
	}

	$Wheres =~ s/([a-z])/$Where{uc( $1 )}/g;
	$Wheres =~ s/\(\(1\) AND \(/((/;

	$Filter->SQL_GroupList( "SELECT $GroupingKey FROM $Tables WHERE $Joins AND $Wheres GROUP BY $GroupingKey ORDER BY $GroupingKey ".::LIMIT_sql() );
	my $GroupingKeyCount = $GroupingKey;

	if ( $::conf{'dbtype'} =~ m/^mysql$/i )
	{
		if ( $GroupingKeyCount =~ m/,/ )
		{
			$GroupingKeyCount = 'CONCAT('.$GroupingKeyCount.')';
		}
	}
	if ( $::conf{'dbtype'} =~ m/^pg$/i )
	{
		$GroupingKeyCount =~ s/,/ \|\| /g;
	}

	$Filter->SQL_GroupNb( "SELECT count(DISTINCT $GroupingKeyCount) FROM $Tables WHERE $Joins AND $Wheres" );

=pod

MySQL Server understands the || and && operators to mean logical OR and AND, as in the C programming language.
In MySQL Server, || and OR are synonyms, as are && and AND.
Because of this nice syntax, MySQL Server doesn't support the standard SQL-99 || operator for string concatenation; use CONCAT() instead.
Because CONCAT() takes any number of arguments, it's easy to convert use of the || operator to MySQL Server.

=cut

}

sub load_data_for_cgi($)
{
	my $self = shift;

	$::cgi->param( 'name', $self->FileName() );
	$::cgi->param( 'comment', $self->comment() );
	$::cgi->param( 'by_page', $self->by_page() );
	$::cgi->param( 'desc', $self->desc() );

	$::cgi->param( 'Formula', $self->Formula() );
	$::cgi->param( 'LineNb', $self->CriteriaNb() - 1 );

	foreach my $CritNum ( 0..( $self->CriteriaNb() - 1 ) )
	{
		my $Crit = $self->get_Criteria_by_num( $CritNum );
		my $Letter = chr( 65 + $CritNum );
		$::cgi->param( 'Table_'.$Letter, $Crit->Table() );
		$::cgi->param( 'Field_'.$Letter, $Crit->Field() );
		$::cgi->param( 'Operator_'.$Letter, $Crit->Operator() );
		$::cgi->param( 'Value_'.$Letter, $Crit->Value() );
	}

	$::cgi->param( 'Formula', '('.$::cgi->param( 'Formula' ).')' );
	foreach my $CritNum ( 0..( $self->GroupCriteriaNb() - 1 ) )
	{
		my $Crit = $self->get_GroupCriteria_by_num( $CritNum );
		my $Letter = chr( 65 + $CritNum + $self->CriteriaNb() );
		$::cgi->param( 'Table_'.$Letter, $Crit->Table() );
		$::cgi->param( 'Field_'.$Letter, $Crit->Field() );
		$::cgi->param( 'Operator_'.$Letter, $Crit->Operator() );
		$::cgi->param( 'Value_'.$Letter, $Crit->Value() );
		$::cgi->param( 'Formula', $::cgi->param( 'Formula' ).' AND '.$Letter );
	}
}

sub get_data_from_cgi($)
{
	my $self = shift;

	if ( ! defined( $::cgi->param( 'comment' ) ) ) {$::cgi->param( 'comment', '' );};
	if ( ! defined( $::cgi->param( 'desc' ) ) ) {$::cgi->param( 'desc', 1 );};
	if ( ! defined( $::cgi->param( 'by_page' ) ) ) {$::cgi->param( 'by_page', 30 );};

	$self->FileName( $::cgi->param( 'name' ) );
	$self->comment( $::cgi->param( 'comment' ) );
	$self->desc( int( $::cgi->param( 'desc' ) ) );
	$self->by_page( int( $::cgi->param( 'by_page' ) ) || 30 ); # HARDCODED

	$self->Formula( $::cgi->param( 'Formula' ) );

	foreach my $Line ( 0..25 )
	{
		my $Id = chr( 65 + $Line );
		if ( $::cgi->param( 'Table_'.$Id ) and $::cgi->param( 'Field_'.$Id ) )
		{
			my $Crit = Criteria->new();
			$Crit->Table( $::cgi->param( 'Table_'.$Id ) );
			$Crit->Field( $::cgi->param( 'Field_'.$Id ) );
			$Crit->Operator( $::cgi->param( 'Operator_'.$Id ) );
			$Crit->Value( $::cgi->param( 'Value_'.$Id ) || $::cgi->param( 'val'.$Id ) );
			$self->add_Criteria( $Crit );
		}
	}
}

###############################################################################

sub Time_Statistic($$$)
{
	my $self = shift;
	my $StartMatch = shift;
	my $ValueList = shift;

	#

	my $Length = length( $ValueList->[0] );

	  # Create the Time criteria :
	my $Crit = Criteria->new();
	$Crit->UsePlaceHolder( 1 );
	$Crit->Table( 'CreateTime' );
	$Crit->Field( 'time' );
	$Crit->Operator( '=' );

	  # Add this criteria to current filter :
	$self->add_Criteria( $Crit );
	my $char = chr( 64 + $self->CriteriaNb() );
	my $FormulaOrig = $self->Formula();
	$self->Formula( $FormulaOrig.' AND '.$char );

	$self->get_SQL();
	my $Statement_NL = $self->SQL_EltNb();

	my $SUBSTR_Op = '';

	if ( $::conf{'dbtype'} =~ m/^mysql$/i )
	{
		$SUBSTR_Op = 'SUBSTRING';
	}

	if ( $::conf{'dbtype'} =~ m/^pg$/i )
	{
		$SUBSTR_Op = 'SUBSTR';
	}

	$Statement_NL =~ s/Prelude_CreateTime.time/$SUBSTR_Op(Prelude_CreateTime.time,$StartMatch,$Length)/;
	$Statement_NL =~ s/\(\s+AND\s+/(/;

	::debug($Statement_NL);

	my $sth = $::dbh->prepare( $Statement_NL );
	my @Results = ();
	foreach my $Value ( @{$ValueList} )
	{
		$sth->execute( $Value ) || ::debug( $::dbh->errstr );
		push @Results, $sth->fetchrow_array();
	}

	$sth->finish();

	  # Restore original Filter :
	$self->Formula( $FormulaOrig );
	$self->del_Criteria_by_num( $self->CriteriaNb() - 1 );

	return @Results;
}

###############################################################################

sub ParseFilterFile($$)
{
	my $self = shift;
	my $FilterFile = shift;

	my %Filter;

	local *FilterFile;
	undef $!;
	open( FilterFile, $FilterFile );
	if ( $! and ( $! !~ m/Inappropriate ioctl for device/i ) )
	{
		::error( "Impossible to read this filter : $!" );
		return ();
	}
	while( my $Line = <FilterFile> )
	{
		$Line =~ s/\r|\n//g;
		if ( $Line )
		{
			my ( $Key, $Value ) = split( /=/,$Line,2 );
			$Filter{$Key} = $Value;
		}
	}
	close( FilterFile );

	return %Filter;
}

sub DeleteAlerts($)
{
	my $self = shift;

	$self->get_SQL();
	my $SQL = $self->SQL_EltList();
	$SQL =~ s/( ORDER BY .*)$/;/;

	my $sth = $::dbh->prepare( $SQL );
	$sth->execute();
	while( my $Id = $sth->fetchrow_array() )
	{
		::DeleteAlert_by_Id( $Id );
	}

	my $Nb = $sth->rows();
	$sth->finish();

	return $Nb;
}

sub ProcessAlerts($$)
{
	my $self = shift;
	my $Process = shift;

	my @ExportList = ();

	$self->get_SQL();
	my $SQL = $self->SQL_EltList();
	$SQL =~ s/( ORDER BY .*)$/;/;

	my $sth = $::dbh->prepare( $SQL );
	$sth->execute();
	while( my $Id = $sth->fetchrow_array() )
	{
		push @ExportList, $Id;
	}

	my $Nb = $sth->rows();
	$sth->finish();

	my $result = $Process->ExecCommand( \@ExportList );
	if ( $result )
	{
		return $Nb;
	}
	else
	{
		return 0;
	}
}

sub count($)
{
	my $self = shift;

	$self->get_SQL();
	my $Statement_NL = $self->SQL_EltNb();

	my $SthNoLimit = $::dbh->prepare( $Statement_NL );
	$SthNoLimit->execute() || ::debug( "SQL error : ".$::dbh->errstr );
	my $TotalResultNb = $SthNoLimit->fetchrow_array();
	$SthNoLimit->finish();

	return $TotalResultNb;
}

1;
