package User;
our $VERSION = '2003-12-25';
our @ISA = 'BaseObject';

use Classes::BaseObject;

sub new {
	my $proto = shift;
	my @Constructor_Parameters = @_;

	my $class = ref( $proto ) || $proto;

	my $self = bless $proto->SUPER::new( @Constructor_Parameters ), $class;

	#

	$self->{'UserName'}		= 'guest';
	$self->{'FullName'}		= '-';
	$self->{'IPAccess'}		= ['127.0.0.1'];

	$self->{'priv_delete'}	= 'none'; # none,all
	$self->{'priv_user'}	= 'none'; # none,all
	$self->{'priv_process'}	= 'none'; # none,all
	$self->{'priv_ack'}		= 'none'; # none,all

	$self->{'priv_list'}	= [];

	#

	my %Hashage = @Constructor_Parameters;
	foreach my $Key ( keys %Hashage )
	{
		$self->set( $Key, $Hashage{$Key} );
	}

	return $self;
}

sub auth($)
{
	my $self = shift;

	my $UserName = $::ENV{'REMOTE_USER'} || 'guest';

	  # added processing of certificates (= conversion of DN to Username)
	if ( $UserName =~ /\/C=[^\/]*\/O=[^\/]*\/CN=[^\/]*\/Email=[^\/]*/ )
	{
		# writeDebug("rewriting $UserName");
		# print "rewriting $UserName";
		$UserName =~ s/\/C=[^\/]*\/O=[^\/]*\/CN=([^\/]*)\/Email=[^\/]*/SSL_$1/;
		$UserName =~ s/[ -]/_/g;
		$UserName =~ s/ /_/g;
		# writeDebug("to $UserName");
		# print "to $UserName";
	}

	if ( $self->load( $UserName ) )
	{
		# User $UserName granted access
	}
	else
	{
		if ( ( $UserName ne 'guest' ) and ( $self->load( 'guest' ) ) )
		{
		  # User guest granted access
		}
		else
		{
			print "Pragma: no-cache\n";
			print "Expires: -1\n";
			print "Cache-Control: no-cache\n";
			print "Content-Type: text/html\n\n";
			print "Auth phase 2 failed : $UserName IP address ($::ENV{'REMOTE_ADDR'}) do not match IPAccess (".($self->{'IPAccess'}).")\n";
			exit();
		}
	}

	$self->UserName( $UserName );
}

sub load($$)
{
	my $self = shift;
	my $UserName = shift;

	my $FileName = 'Profiles/'.$UserName.'.user';

	if ( -f $FileName )
	{
		local *PROFILE;
		undef $!;
		open( PROFILE, $FileName );
		if ( $! and ( $! !~ m/Inappropriate ioctl for device/ ) )
		{
			die("Can't open $FileName : $!\n");
		}
		else
		{
			my %Profile = ();
			while( my $Line = <PROFILE> )
			{
				$Line =~ s/\r|\n//g;
				$Line =~ s/^\s+//;
				if ( $Line and ( $Line !~ m/^#/ ) )
				{
					my ( $Key, $Value ) = split( /=/, $Line, 2 );
					$Profile{$Key} = $Value;
				}
			}

			$self->IPAccess( $Profile{'IPAccess'} );

			if ( $self->Verify_IPAccess( $Profile{'IPAccess'} ) )
			{
				$self->UserName( $UserName );
				$self->FullName( $Profile{'FullName'} );
				$self->IPAccess( $Profile{'IPAccess'} );

				$self->priv_delete( $Profile{'priv_delete'} );
				$self->priv_user( $Profile{'priv_user'} );
				$self->priv_process( $Profile{'priv_process'} );
				$self->priv_ack( $Profile{'priv_ack'} );

				my @priv_list = ();
				foreach my $key ( keys %Profile )
				{
					if ( $key =~ m/^priv_(.*)/ )
					{
						my $priv = $1;
						if ( $Profile{$key} eq 'all' )
						{
							push @priv_list, $priv;
						}
					}
				}
				$self->{'priv_list'} = \@priv_list;

				return 1;
			}
			else
			{
				return 0;
			}
		}
		close( PROFILE );
	}
	else
	{
		return 0;
	}
}

sub Verify_IPAccess($$)
{
	my $self = shift;
	my $IPAccess = shift;

	$IPAccess = sprintf( "%03d\\.%03d\\.%03d\\.%03d", split( /\./, $IPAccess ) );
	$IPAccess =~ s/255/\\d{3}/g;

	my $UserIP = sprintf( "%03d.%03d.%03d.%03d", split( /\./, $::ENV{'REMOTE_ADDR'} ) );

#	print STDERR "IPAccess : $IPAccess<br>\n";
#	print STDERR "UserIP : $UserIP<br>\n";
	if ( $UserIP =~ m/^$IPAccess$/ )
	{
#		print STDERR "IP address granted";
		return 1;
	}
	else
	{
#		print STDERR "Your IP address is not in auth list";
		return 0;
	}
}

1;
