/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef LISTWIDGET_HEADER
#define LISTWIDGET_HEADER

#include <QGraphicsWidget>
#include <QGraphicsLinearLayout>

class QGraphicsSceneDragDropEvent;
class ListWidgetItem;
class ListWidget : public QGraphicsWidget
{
    Q_OBJECT


    public:
        ListWidget(QGraphicsWidget *parent = 0);
        ~ListWidget();

        QList<ListWidgetItem*> items() const;
        ListWidgetItem *selectedItem() const;
        int indexOf(ListWidgetItem *item) const;


    public slots:
        void addItem(ListWidgetItem *item);
        void insertItem(const int &index, ListWidgetItem *item);
        void removeItem(ListWidgetItem *item);
        void deselectItem();


    protected:
        bool eventFilter(QObject *obj, QEvent *event);


    protected slots:
        void dragEnterEvent(QGraphicsSceneDragDropEvent *event);
        void dragMoveEvent(QGraphicsSceneDragDropEvent *event);
        void dragLeaveEvent(QGraphicsSceneDragDropEvent *event);
        void dropEvent(QGraphicsSceneDragDropEvent *event);

        
    private:
        QGraphicsLinearLayout *m_layout;
        QList<ListWidgetItem*> m_items;
        QPointF m_dragStartPos;
        bool m_dragStarted;
        
        int dropIndexFromPoint(const QPointF pos);
        
        
    signals:
        void droped(ListWidgetItem *item);
    
    
};


#endif
