/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef PLAYWOLF_H
#define PLAYWOLF_H
 
#include <Plasma/PopupApplet>

///Ui includes
#include "ui_generalPage.h"
#include "ui_horizontalPage.h"
#include "ui_verticalPage.h"

class QGraphicsGridLayout;

namespace Plasma {
    class ExtenderItem;
};

class WolfMeter;
class WolfLabel;
class WolfButtons;
class InfoWidget;
class PlayerController;
class FlowLayout;
class DialogWidget;
class InfoManager;

class PlayWolf : public Plasma::PopupApplet
{
    Q_OBJECT
    public:
        PlayWolf(QObject *parent, const QVariantList &args);
        ~PlayWolf();

        void init();
        void constraintsEvent(Plasma::Constraints constraints);

    protected:
        QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint) const;
        void hoverEnterEvent(QGraphicsSceneHoverEvent *event);
        void hoverLeaveEvent(QGraphicsSceneHoverEvent *event);
        void wheelEvent(QGraphicsSceneWheelEvent *event);
        void createConfigurationInterface(KConfigDialog *parent);
        void initExtenderItem(Plasma::ExtenderItem *item);

    protected slots:
        void configAccepted();

    private:
        void resetWidgets();
        void popupEvent(bool show);

        WolfButtons *m_buttons;
        InfoWidget *m_infos;
        WolfMeter *m_meter;
        QGraphicsGridLayout *m_layout;
        WolfLabel *m_cover;
        QPixmap coverImage;
        Ui::generalPage m_generalUi;
        Ui::verticalPage m_verticalUi;
        Ui::horizontalPage m_horizontalUi;
        QFont m_customFont;
        InfoManager* m_infoManager;

        int m_widthOnPanel;
        int m_heightOnPanel;
        bool m_showCover;
        bool m_wheelSeek;
        bool m_showInformationsOnHPanel;
};

K_EXPORT_PLASMA_APPLET(playwolf, PlayWolf)

#endif