/* 
 * wakebay.c - wakes a powerbook mediabay so the system doesnt crash on accessing
 * a disk mounted before sleeping.  great for CD drives. 
 *
 * Joseph Palani Garcia <jpgarcia@execpc.com>
 *
 * fairly simple.  IOCTL the mediabay to tell it the media changed.  (it only forgot
 * it in sleep.  we remind it.)
 *
 * 3 cases:
 *   nothing in drive      : does nothing, exits normally
 *   in drive, not mounted : acts, no effect (?)
 *   in drive, is mounted  : drive regains status, door locked, etc.
 *
 * this is useful for PMUD.  add it to the wakeup script to prevent crashes.
 *
 */
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/cdrom.h>

int
main(int argc, char **argv)
{
  int fd, arg=0;

  if(argc<2){
    fprintf(stderr,"Usage:\n\t%s <device>\n",argv[0]);
    return 1;
  }

  fd = open(argv[1], O_RDONLY);

  if (fd < 0) {
    fprintf(stderr,"%s cannot be opened.  exiting.\n",argv[1]);
    return 0;
  }

  if (ioctl(fd, CDROM_MEDIA_CHANGED, &arg) < 0)
    perror("CDROM_MEDIA_CHANGED ioctl");

  close(fd);
  return 0;
}
