//
//  PRImage.m
//  PRICE
//
//  Created by Riccardo Mottola on Wed Oct 12 2005.
//  Copyright (c) 2005-2010 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRImage.h"


@implementation PRImage

- (void)addRepresentation:(NSImageRep *)imageRep
{
    [super addRepresentation:imageRep];

    bitRep = [[self representations] objectAtIndex:0];
    if (![bitRep isKindOfClass:[NSBitmapImageRep class]])
    {
        NSLog(@"we got %@", [bitRep class]);
    }
    pixelH = [bitRep pixelsHigh];
    pixelW = [bitRep pixelsWide];
    bitsPerPixel = [bitRep bitsPerPixel];
}

- (id)initWithData:(NSData*)data
{
    self = [super initWithData:data];
    bitRep = [[self representations] objectAtIndex:0];
    if (![bitRep isKindOfClass:[NSBitmapImageRep class]])
    {
        NSLog(@"we got %@", [bitRep class]);
    }
    pixelH = [bitRep pixelsHigh];
    pixelW = [bitRep pixelsWide];
    bitsPerPixel = [bitRep bitsPerPixel];
    [self setSize: [self pixelSize]];
    return self;
}

- (id)initWithSize:(NSSize)aSize
{
    self = [super initWithSize:aSize];
    return self;
}

- (void)dealloc
{
    [super dealloc];
}

- (int)height
{
    return pixelH;
}

- (int)width
{
    return pixelW;
}

- (int)bitsPP
{
    return bitsPerPixel;
}

- (NSSize)pixelSize
{
    return NSMakeSize((float)pixelW,(float)pixelH);
}

- (NSBitmapImageRep *)bitmapRep
{
    NSBitmapImageRep *currBitRep;
    
    currBitRep = [[self representations] objectAtIndex:0];
    if (bitRep != currBitRep)
    {
        NSLog(@"old bitmap representation got invalidated.");
        if ([currBitRep isKindOfClass:[NSCachedImageRep class]])
        {
            NSLog(@"We got cached, we need to regenerate.");
            bitRep = [NSBitmapImageRep imageRepWithData: [self TIFFRepresentation]];
        }
    }
    
    return bitRep;
}

@end
