/*
 * bosskey.cpp
 * Copyright (C) 2010  Evgeny Khryukin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#include "bosskey.h"

#include "mainwin.h"
#include "psioptions.h"
#include "psitrayicon.h"

#include <QApplication>

BossKey::BossKey(QObject *p) :
    QObject(p), isHidden_(false), psiOptions(PsiOptions::instance()), win_(dynamic_cast<MainWin *>(p))
{
}

void BossKey::shortCutActivated()
{
    if (isHidden_) {
        doShow();
        isHidden_ = false;
    } else {
        doHide();
        isHidden_ = true;
    }
}

void BossKey::doHide()
{
    QWidgetList l = qApp->topLevelWidgets();
    for (QWidget *w : l) {
        w = w->window();
        if (!w->isHidden()) {
            hiddenWidgets_.push_back(QPointer<QWidget>(w));
            w->hide();
        }
    }
    if (win_) {
        PsiTrayIcon *ico = win_->psiTrayIcon();
        if (ico) {
            ico->hide();
        }
    }

    static const QString     soundOption    = "options.ui.notifications.sounds.enable";
    static const QString     popupOption    = "options.ui.notifications.passive-popups.enabled";
    static const QString     messageOption  = "options.ui.message.auto-popup";
    static const QString     headLineOption = "options.ui.message.auto-popup-headlines";
    static const QString     chatOption     = "options.ui.chat.auto-popup";
    static const QString     fileOption     = "options.ui.file-transfer.auto-popup";
    static const QStringList opt            = QStringList()
        << soundOption << popupOption << messageOption << headLineOption << chatOption << fileOption;
    for (const QString &option : opt) {
        tmpOptions_[option] = psiOptions->getOption(option);
        psiOptions->setOption(option, false);
    }
}

void BossKey::doShow()
{
    for (QPointer<QWidget> p : hiddenWidgets_) {
        if (p) {
            p->show();
        }
    }
    hiddenWidgets_.clear();
    if (win_) {
        PsiTrayIcon *ico = win_->psiTrayIcon();
        if (ico) {
            ico->show();
        }
    }
    for (const QString &key : tmpOptions_.keys()) {
        psiOptions->setOption(key, tmpOptions_.value(key));
    }
    tmpOptions_.clear();
}
