;-------------------------------------------------------------------------------
; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;-------------------------------------------------------------------------------
; pysycache-dblclick.scm : a script for make three thumbnails of the pictures to 
;                       search in the double-click activity
; Copyright (C) 2006 Vincent DEROO (vincent.pysycache@free.fr)
;-------------------------------------------------------------------------------
;
;
; This program is free software; you can redistribute it and/or 
; modify it under the terms of the GNU General Public License 
; as published by the Free Software Foundation; either version 2 
; of the License, or (at your option) any later version. 
; 
; This program is distributed in the hope that it will be useful, 
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details. 
; 
; You should have received a copy of the GNU General Public License 
; along with this program; if not, write to the Free Software 
; Foundation, Inc. : 
; 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
;-------------------------------------------------------------------------------



       
;-------------------------------------------------------------------------------
; 
;-------------------------------------------------------------------------------
(define (PutTheText
	ShadowColor
	TopText
	TopTextFont
	Left
	Top
	Size
	TypeOfPosition
	)
	(gimp-palette-set-foreground ShadowColor)
			(let* 
					(	
						(LayText
							(car
							   (gimp-text-fontname
								MyImg -1
								Left Top
								TopText
								-1
								TRUE
								Size PIXELS
								TopTextFont)
						   )
						)						
						(larg (car (gimp-drawable-width LayText)))
                        (haut (car (gimp-drawable-height LayText)))
					)
			
			
			(if (= TypeOfPosition 0)
				;top text
				(begin
				)
			)
			(if (= TypeOfPosition 1)
				;middle text
				(begin
					(gimp-layer-translate LayText (- (/ larg 2) ) (- (/ haut 2) ) )
				)
			)
			(if (= TypeOfPosition 2)
				;bottom text
				(begin					
					(gimp-layer-translate LayText (- larg) (- haut) )
				)
			)
			
			)
			
						
)
       
;-------------------------------------------------------------------------------
; 
;-------------------------------------------------------------------------------
(define (script-fu-pysycache-dblclick
	img
	draw
	dirtarget
	prefixfile
	)
	

	(let*	(	;fichier modeles
				(FichierOn (string-append "" gimp-data-dir "/scripts/images/yyyy-on.png") )
				(FichierOff (string-append "" gimp-data-dir "/scripts/images/yyyy-off.png") )
				(FichierSel (string-append "" gimp-data-dir "/scripts/images/yyyy-selected.png") )
				
				;taille de l'image que l'on doit coller
				(ImgWidth (car (gimp-image-width img)))
				(ImgHeight (car (gimp-image-height img)))
				
				(filesvgon  (string-append dirtarget "\\" prefixfile "-on.png"  )) 
				(filesvgoff  (string-append dirtarget "\\" prefixfile "-off.png"  )) 
				(filesvgsel  (string-append dirtarget "\\" prefixfile "-selected.png"  )) 
			)

			(if (= ImgWidth ImgHeight )
				(begin
					;------------ meme hauteur et largeur ----------------------
					;------ eventuellement mettre a la taille de 50 x 50 -------
					(if (= ImgWidth 50 )
						(begin
						)
						(begin
							(gimp-image-scale img 50 50)
						)
					)
					
					;------------------ ouvrir les fichiers --------------------
					(set! MyImgOn (car (gimp-file-load RUN-NONINTERACTIVE FichierOn FichierOn)))
					(set! MyImgOff (car (gimp-file-load RUN-NONINTERACTIVE FichierOff FichierOff)))
					(set! MyImgSel (car (gimp-file-load RUN-NONINTERACTIVE FichierSel FichierSel)))			
			
					;--------------------- image on ----------------------------
					(set! MyLayOn (car (gimp-layer-new-from-drawable draw MyImgOn)))
					(gimp-image-add-layer MyImgOn MyLayOn -1)
					(gimp-layer-translate MyLayOn 34 0)
					(gimp-image-merge-visible-layers MyImgOn 1)				
			
					;--------------------- image off ---------------------------
					(set! MyImgDbl (car (gimp-image-duplicate img)))
					;(MyDraw (car (gimp-image-get-active-drawable MyImg)))
					(gimp-image-convert-grayscale MyImgDbl)
					(set! MyDraw (car (gimp-image-get-active-drawable MyImgDbl)))
					(set! MyLayOff (car (gimp-layer-new-from-drawable MyDraw MyImgOff)))
					(gimp-image-add-layer MyImgOff MyLayOff -1)
					(gimp-layer-translate MyLayOff 34 0)
					(gimp-image-merge-visible-layers MyImgOff 1)	
			
					;----------------------- image Sel -------------------------
					(set! MyLaySel (car (gimp-layer-new-from-drawable MyDraw MyImgSel)))
					(gimp-image-add-layer MyImgSel MyLaySel -1)
					(gimp-layer-translate MyLaySel 34 0)
					(gimp-image-merge-visible-layers MyImgSel 1)	
					
					;----------------------- affichage -------------------------
					(set! MyDrawOn (car (gimp-image-get-active-drawable MyImgOn)))
					(set! MyDrawOff (car (gimp-image-get-active-drawable MyImgOff)))
					(set! MyDrawSel (car (gimp-image-get-active-drawable MyImgSel)))
					(gimp-file-save RUN-NONINTERACTIVE MyImgOn MyDrawOn filesvgon filesvgon)
					(gimp-image-delete MyImgOn)
					(gimp-file-save RUN-NONINTERACTIVE MyImgOff MyDrawOff filesvgoff filesvgoff)
					(gimp-image-delete MyImgOff)
					(gimp-file-save RUN-NONINTERACTIVE MyImgSel MyDrawSel filesvgsel filesvgsel)
					(gimp-image-delete MyImgSel)
					
					(gimp-image-delete MyImgDbl)
					
				)
				(begin
					(gimp-message "Picture must have the same width and height. Abort" )
				)
			)
	)
)


;-------------------------------------------------------------------------------
; Register in the Gimp menus
;-------------------------------------------------------------------------------
(script-fu-register "script-fu-pysycache-dblclick"
		    _"<Image>/Script-Fu/Pysycache/Theme doubleclick..."
		    "Make the two thumbnails for the pictures to double click on in the double click activity \
Pictures used for make thumbnail should have the same height and width"


		    "Vincent DEROO (contact.pysycache@free.fr)"
		    "Vincent DEROO"
		    "16/09/2006 - v 1.0"
		    "RGB GRAY RGBA GRAYA"
			
		    SF-IMAGE "Image" 0
			SF-DRAWABLE "Drawable" 0
		    SF-DIRNAME "Target directory" (string-append "" gimp-directory )
		    SF-STRING "File prefix" "image000"
			
)
