# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class BillingPeriod(Resource):
    """A billing period resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar billing_period_start_date: The start of the date range covered by
     the billing period.
    :vartype billing_period_start_date: date
    :ivar billing_period_end_date: The end of the date range covered by the
     billing period.
    :vartype billing_period_end_date: date
    :ivar invoice_ids: Array of invoice ids that associated with.
    :vartype invoice_ids: list of str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'billing_period_start_date': {'readonly': True},
        'billing_period_end_date': {'readonly': True},
        'invoice_ids': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'billing_period_start_date': {'key': 'properties.billingPeriodStartDate', 'type': 'date'},
        'billing_period_end_date': {'key': 'properties.billingPeriodEndDate', 'type': 'date'},
        'invoice_ids': {'key': 'properties.invoiceIds', 'type': '[str]'},
    }

    def __init__(self):
        super(BillingPeriod, self).__init__()
        self.billing_period_start_date = None
        self.billing_period_end_date = None
        self.invoice_ids = None
