# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResolvedServicePartition(Model):
    """Information about a service partition and its associated endpoints.

    :param name:
    :type name: str
    :param partition_information: A representation of the resolved partition.
    :type partition_information: :class:`PartitionInformation
     <azure.servicefabric.models.PartitionInformation>`
    :param endpoints:
    :type endpoints: list of :class:`ResolvedServiceEndpoint
     <azure.servicefabric.models.ResolvedServiceEndpoint>`
    :param version: The version of this resolved service partition result.
     This version should be passed in the next time the ResolveService call
     is made via the PreviousRspVersion query parameter.
    :type version: str
    """ 

    _validation = {
        'name': {'required': True},
        'partition_information': {'required': True},
        'endpoints': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'partition_information': {'key': 'PartitionInformation', 'type': 'PartitionInformation'},
        'endpoints': {'key': 'Endpoints', 'type': '[ResolvedServiceEndpoint]'},
        'version': {'key': 'Version', 'type': 'str'},
    }

    def __init__(self, name, partition_information, endpoints, version):
        self.name = name
        self.partition_information = partition_information
        self.endpoints = endpoints
        self.version = version
