# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdvancedFilter(Model):
    """This is the base type that represents an advanced filter. To configure an
    advanced filter, do not directly instantiate an object of this class.
    Instead, instantiate an object of a derived class such as
    BoolEqualsAdvancedFilter, NumberInAdvancedFilter,
    StringEqualsAdvancedFilter etc. depending on the type of the key based on
    which you want to filter.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NumberInAdvancedFilter, NumberNotInAdvancedFilter,
    NumberLessThanAdvancedFilter, NumberGreaterThanAdvancedFilter,
    NumberLessThanOrEqualsAdvancedFilter,
    NumberGreaterThanOrEqualsAdvancedFilter, BoolEqualsAdvancedFilter,
    StringInAdvancedFilter, StringNotInAdvancedFilter,
    StringBeginsWithAdvancedFilter, StringEndsWithAdvancedFilter,
    StringContainsAdvancedFilter

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
    }

    _subtype_map = {
        'operator_type': {'NumberIn': 'NumberInAdvancedFilter', 'NumberNotIn': 'NumberNotInAdvancedFilter', 'NumberLessThan': 'NumberLessThanAdvancedFilter', 'NumberGreaterThan': 'NumberGreaterThanAdvancedFilter', 'NumberLessThanOrEquals': 'NumberLessThanOrEqualsAdvancedFilter', 'NumberGreaterThanOrEquals': 'NumberGreaterThanOrEqualsAdvancedFilter', 'BoolEquals': 'BoolEqualsAdvancedFilter', 'StringIn': 'StringInAdvancedFilter', 'StringNotIn': 'StringNotInAdvancedFilter', 'StringBeginsWith': 'StringBeginsWithAdvancedFilter', 'StringEndsWith': 'StringEndsWithAdvancedFilter', 'StringContains': 'StringContainsAdvancedFilter'}
    }

    def __init__(self, **kwargs):
        super(AdvancedFilter, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.operator_type = None


class EventSubscriptionDestination(Model):
    """Information about the destination for an event subscription.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WebHookEventSubscriptionDestination,
    EventHubEventSubscriptionDestination,
    StorageQueueEventSubscriptionDestination,
    HybridConnectionEventSubscriptionDestination,
    ServiceBusQueueEventSubscriptionDestination,
    ServiceBusTopicEventSubscriptionDestination,
    AzureFunctionEventSubscriptionDestination

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'WebHook': 'WebHookEventSubscriptionDestination', 'EventHub': 'EventHubEventSubscriptionDestination', 'StorageQueue': 'StorageQueueEventSubscriptionDestination', 'HybridConnection': 'HybridConnectionEventSubscriptionDestination', 'ServiceBusQueue': 'ServiceBusQueueEventSubscriptionDestination', 'ServiceBusTopic': 'ServiceBusTopicEventSubscriptionDestination', 'AzureFunction': 'AzureFunctionEventSubscriptionDestination'}
    }

    def __init__(self, **kwargs):
        super(EventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = None


class AzureFunctionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the azure function destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource Id that represents the endpoint of
     the Azure Function destination of an event subscription.
    :type resource_id: str
    :param max_events_per_batch: Maximum number of events per batch.
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in
     Kilobytes.
    :type preferred_batch_size_in_kilobytes: int
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureFunctionEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.max_events_per_batch = kwargs.get('max_events_per_batch', None)
        self.preferred_batch_size_in_kilobytes = kwargs.get('preferred_batch_size_in_kilobytes', None)
        self.endpoint_type = 'AzureFunction'


class BoolEqualsAdvancedFilter(AdvancedFilter):
    """BoolEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The boolean filter value.
    :type value: bool
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(BoolEqualsAdvancedFilter, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.operator_type = 'BoolEquals'


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class DeadLetterDestination(Model):
    """Information about the dead letter destination for an event subscription. To
    configure a deadletter destination, do not directly instantiate an object
    of this class. Instead, instantiate an object of a derived class.
    Currently, StorageBlobDeadLetterDestination is the only class that derives
    from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StorageBlobDeadLetterDestination

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'StorageBlob': 'StorageBlobDeadLetterDestination'}
    }

    def __init__(self, **kwargs):
        super(DeadLetterDestination, self).__init__(**kwargs)
        self.endpoint_type = None


class Resource(Model):
    """Definition of a Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource
    :vartype name: str
    :ivar type: Type of the resource
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """Definition of a Tracked Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource
    :vartype name: str
    :ivar type: Type of the resource
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Domain(TrackedResource):
    """EventGrid Domain.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource
    :vartype name: str
    :ivar type: Type of the resource
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the domain. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.DomainProvisioningState
    :ivar endpoint: Endpoint for the domain.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should
     expect for incoming events published to the domain. Possible values
     include: 'EventGridSchema', 'CustomEventSchema', 'CloudEventSchemaV1_0'.
     Default value: "EventGridSchema" .
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: Information about the InputSchemaMapping
     which specified the info about mapping event payload.
    :type input_schema_mapping:
     ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the domain.
    :vartype metric_resource_id: str
    :param allow_traffic_from_all_ips: This determines if IP filtering rules
     ought to be evaluated or not. By default it will not evaluate and will
     allow traffic from all IPs.
    :type allow_traffic_from_all_ips: bool
    :param inbound_ip_rules: This determines the IP filtering rules that ought
     be applied when events are received on this domain.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'allow_traffic_from_all_ips': {'key': 'properties.allowTrafficFromAllIPs', 'type': 'bool'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(self, **kwargs):
        super(Domain, self).__init__(**kwargs)
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = kwargs.get('input_schema', "EventGridSchema")
        self.input_schema_mapping = kwargs.get('input_schema_mapping', None)
        self.metric_resource_id = None
        self.allow_traffic_from_all_ips = kwargs.get('allow_traffic_from_all_ips', None)
        self.inbound_ip_rules = kwargs.get('inbound_ip_rules', None)


class DomainRegenerateKeyRequest(Model):
    """Domain regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DomainRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = kwargs.get('key_name', None)


class DomainSharedAccessKeys(Model):
    """Shared access keys of the Domain.

    :param key1: Shared access key1 for the domain.
    :type key1: str
    :param key2: Shared access key2 for the domain.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DomainSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = kwargs.get('key1', None)
        self.key2 = kwargs.get('key2', None)


class DomainTopic(Resource):
    """Domain Topic.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource
    :vartype name: str
    :ivar type: Type of the resource
    :vartype type: str
    :param provisioning_state: Provisioning state of the domain topic.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.eventgrid.models.DomainTopicProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DomainTopic, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class DomainUpdateParameters(Model):
    """Properties of the Domain update.

    :param tags: Tags of the domains resource
    :type tags: dict[str, str]
    :param allow_traffic_from_all_ips: This determines if IP filtering rules
     ought to be evaluated or not. By default it will not evaluate and will
     allow traffic from all IPs.
    :type allow_traffic_from_all_ips: bool
    :param inbound_ip_rules: This determines the IP filtering rules that ought
     be applied when events are received on this domain.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'allow_traffic_from_all_ips': {'key': 'allowTrafficFromAllIPs', 'type': 'bool'},
        'inbound_ip_rules': {'key': 'inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(self, **kwargs):
        super(DomainUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.allow_traffic_from_all_ips = kwargs.get('allow_traffic_from_all_ips', None)
        self.inbound_ip_rules = kwargs.get('inbound_ip_rules', None)


class EventHubEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the event hub destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource Id that represents the endpoint of
     an Event Hub destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EventHubEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.endpoint_type = 'EventHub'


class EventSubscription(Resource):
    """Event Subscription.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource
    :vartype name: str
    :ivar type: Type of the resource
    :vartype type: str
    :ivar topic: Name of the topic of the event subscription.
    :vartype topic: str
    :ivar provisioning_state: Provisioning state of the event subscription.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed', 'AwaitingManualAction'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.EventSubscriptionProvisioningState
    :param destination: Information about the destination where events have to
     be delivered for the event subscription.
    :type destination:
     ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Expiration time of the event subscription.
    :type expiration_time_utc: datetime
    :param event_delivery_schema: The event delivery schema for the event
     subscription. Possible values include: 'EventGridSchema',
     'CustomInputSchema', 'CloudEventSchemaV1_0'
    :type event_delivery_schema: str or
     ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to
     configure maximum number of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The DeadLetter destination of the event
     subscription.
    :type dead_letter_destination:
     ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'topic': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'topic': {'key': 'properties.topic', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'destination': {'key': 'properties.destination', 'type': 'EventSubscriptionDestination'},
        'filter': {'key': 'properties.filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'properties.expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'properties.eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'properties.retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'properties.deadLetterDestination', 'type': 'DeadLetterDestination'},
    }

    def __init__(self, **kwargs):
        super(EventSubscription, self).__init__(**kwargs)
        self.topic = None
        self.provisioning_state = None
        self.destination = kwargs.get('destination', None)
        self.filter = kwargs.get('filter', None)
        self.labels = kwargs.get('labels', None)
        self.expiration_time_utc = kwargs.get('expiration_time_utc', None)
        self.event_delivery_schema = kwargs.get('event_delivery_schema', None)
        self.retry_policy = kwargs.get('retry_policy', None)
        self.dead_letter_destination = kwargs.get('dead_letter_destination', None)


class EventSubscriptionFilter(Model):
    """Filter for the Event Subscription.

    :param subject_begins_with: An optional string to filter events for an
     event subscription based on a resource path prefix.
     The format of this depends on the publisher of the events.
     Wildcard characters are not supported in this path.
    :type subject_begins_with: str
    :param subject_ends_with: An optional string to filter events for an event
     subscription based on a resource path suffix.
     Wildcard characters are not supported in this path.
    :type subject_ends_with: str
    :param included_event_types: A list of applicable event types that need to
     be part of the event subscription. If it is desired to subscribe to all
     default event types, set the IncludedEventTypes to null.
    :type included_event_types: list[str]
    :param is_subject_case_sensitive: Specifies if the SubjectBeginsWith and
     SubjectEndsWith properties of the filter
     should be compared in a case sensitive manner. Default value: False .
    :type is_subject_case_sensitive: bool
    :param advanced_filters: An array of advanced filters that are used for
     filtering event subscriptions.
    :type advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
    """

    _attribute_map = {
        'subject_begins_with': {'key': 'subjectBeginsWith', 'type': 'str'},
        'subject_ends_with': {'key': 'subjectEndsWith', 'type': 'str'},
        'included_event_types': {'key': 'includedEventTypes', 'type': '[str]'},
        'is_subject_case_sensitive': {'key': 'isSubjectCaseSensitive', 'type': 'bool'},
        'advanced_filters': {'key': 'advancedFilters', 'type': '[AdvancedFilter]'},
    }

    def __init__(self, **kwargs):
        super(EventSubscriptionFilter, self).__init__(**kwargs)
        self.subject_begins_with = kwargs.get('subject_begins_with', None)
        self.subject_ends_with = kwargs.get('subject_ends_with', None)
        self.included_event_types = kwargs.get('included_event_types', None)
        self.is_subject_case_sensitive = kwargs.get('is_subject_case_sensitive', False)
        self.advanced_filters = kwargs.get('advanced_filters', None)


class EventSubscriptionFullUrl(Model):
    """Full endpoint url of an event subscription.

    :param endpoint_url: The URL that represents the endpoint of the
     destination of an event subscription.
    :type endpoint_url: str
    """

    _attribute_map = {
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EventSubscriptionFullUrl, self).__init__(**kwargs)
        self.endpoint_url = kwargs.get('endpoint_url', None)


class EventSubscriptionUpdateParameters(Model):
    """Properties of the Event Subscription update.

    :param destination: Information about the destination where events have to
     be delivered for the event subscription.
    :type destination:
     ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Information about the expiration time for the
     event subscription.
    :type expiration_time_utc: datetime
    :param event_delivery_schema: The event delivery schema for the event
     subscription. Possible values include: 'EventGridSchema',
     'CustomInputSchema', 'CloudEventSchemaV1_0'
    :type event_delivery_schema: str or
     ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to
     configure maximum number of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The DeadLetter destination of the event
     subscription.
    :type dead_letter_destination:
     ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'EventSubscriptionDestination'},
        'filter': {'key': 'filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'deadLetterDestination', 'type': 'DeadLetterDestination'},
    }

    def __init__(self, **kwargs):
        super(EventSubscriptionUpdateParameters, self).__init__(**kwargs)
        self.destination = kwargs.get('destination', None)
        self.filter = kwargs.get('filter', None)
        self.labels = kwargs.get('labels', None)
        self.expiration_time_utc = kwargs.get('expiration_time_utc', None)
        self.event_delivery_schema = kwargs.get('event_delivery_schema', None)
        self.retry_policy = kwargs.get('retry_policy', None)
        self.dead_letter_destination = kwargs.get('dead_letter_destination', None)


class EventType(Resource):
    """Event Type for a subject under a topic.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource
    :vartype name: str
    :ivar type: Type of the resource
    :vartype type: str
    :param display_name: Display name of the event type.
    :type display_name: str
    :param description: Description of the event type.
    :type description: str
    :param schema_url: Url of the schema for this event type.
    :type schema_url: str
    :param is_in_default_set: IsInDefaultSet flag of the event type.
    :type is_in_default_set: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'schema_url': {'key': 'properties.schemaUrl', 'type': 'str'},
        'is_in_default_set': {'key': 'properties.isInDefaultSet', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(EventType, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.schema_url = kwargs.get('schema_url', None)
        self.is_in_default_set = kwargs.get('is_in_default_set', None)


class HybridConnectionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the HybridConnection destination for an event
    subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource ID of an hybrid connection that is
     the destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HybridConnectionEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.endpoint_type = 'HybridConnection'


class InboundIpRule(Model):
    """InboundIpRule.

    :param ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
    :type ip_mask: str
    :param action: Action to perform based on the match or no match of the
     IpMask. Possible values include: 'Allow'
    :type action: str or ~azure.mgmt.eventgrid.models.IpActionType
    """

    _attribute_map = {
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InboundIpRule, self).__init__(**kwargs)
        self.ip_mask = kwargs.get('ip_mask', None)
        self.action = kwargs.get('action', None)


class InputSchemaMapping(Model):
    """By default, Event Grid expects events to be in the Event Grid event schema.
    Specifying an input schema mapping enables publishing to Event Grid using a
    custom input schema. Currently, the only supported type of
    InputSchemaMapping is 'JsonInputSchemaMapping'.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JsonInputSchemaMapping

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Constant filled by server.
    :type input_schema_mapping_type: str
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
    }

    _subtype_map = {
        'input_schema_mapping_type': {'Json': 'JsonInputSchemaMapping'}
    }

    def __init__(self, **kwargs):
        super(InputSchemaMapping, self).__init__(**kwargs)
        self.input_schema_mapping_type = None


class JsonField(Model):
    """This is used to express the source of an input schema mapping for a single
    target field in the Event Grid Event schema. This is currently used in the
    mappings for the 'id', 'topic' and 'eventtime' properties. This represents
    a field in the input event schema.

    :param source_field: Name of a field in the input event schema that's to
     be used as the source of a mapping.
    :type source_field: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JsonField, self).__init__(**kwargs)
        self.source_field = kwargs.get('source_field', None)


class JsonFieldWithDefault(Model):
    """This is used to express the source of an input schema mapping for a single
    target field
    in the Event Grid Event schema. This is currently used in the mappings for
    the 'subject',
    'eventtype' and 'dataversion' properties. This represents a field in the
    input event schema
    along with a default value to be used, and at least one of these two
    properties should be provided.

    :param source_field: Name of a field in the input event schema that's to
     be used as the source of a mapping.
    :type source_field: str
    :param default_value: The default value to be used for mapping when a
     SourceField is not provided or if there's no property with the specified
     name in the published JSON event payload.
    :type default_value: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JsonFieldWithDefault, self).__init__(**kwargs)
        self.source_field = kwargs.get('source_field', None)
        self.default_value = kwargs.get('default_value', None)


class JsonInputSchemaMapping(InputSchemaMapping):
    """This enables publishing to Event Grid using a custom input schema. This can
    be used to map properties from a custom input JSON schema to the Event Grid
    event schema.

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Constant filled by server.
    :type input_schema_mapping_type: str
    :param id: The mapping information for the Id property of the Event Grid
     Event.
    :type id: ~azure.mgmt.eventgrid.models.JsonField
    :param topic: The mapping information for the Topic property of the Event
     Grid Event.
    :type topic: ~azure.mgmt.eventgrid.models.JsonField
    :param event_time: The mapping information for the EventTime property of
     the Event Grid Event.
    :type event_time: ~azure.mgmt.eventgrid.models.JsonField
    :param event_type: The mapping information for the EventType property of
     the Event Grid Event.
    :type event_type: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param subject: The mapping information for the Subject property of the
     Event Grid Event.
    :type subject: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param data_version: The mapping information for the DataVersion property
     of the Event Grid Event.
    :type data_version: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
        'id': {'key': 'properties.id', 'type': 'JsonField'},
        'topic': {'key': 'properties.topic', 'type': 'JsonField'},
        'event_time': {'key': 'properties.eventTime', 'type': 'JsonField'},
        'event_type': {'key': 'properties.eventType', 'type': 'JsonFieldWithDefault'},
        'subject': {'key': 'properties.subject', 'type': 'JsonFieldWithDefault'},
        'data_version': {'key': 'properties.dataVersion', 'type': 'JsonFieldWithDefault'},
    }

    def __init__(self, **kwargs):
        super(JsonInputSchemaMapping, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.topic = kwargs.get('topic', None)
        self.event_time = kwargs.get('event_time', None)
        self.event_type = kwargs.get('event_type', None)
        self.subject = kwargs.get('subject', None)
        self.data_version = kwargs.get('data_version', None)
        self.input_schema_mapping_type = 'Json'


class NumberGreaterThanAdvancedFilter(AdvancedFilter):
    """NumberGreaterThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(NumberGreaterThanAdvancedFilter, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.operator_type = 'NumberGreaterThan'


class NumberGreaterThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberGreaterThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(NumberGreaterThanOrEqualsAdvancedFilter, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.operator_type = 'NumberGreaterThanOrEquals'


class NumberInAdvancedFilter(AdvancedFilter):
    """NumberIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(self, **kwargs):
        super(NumberInAdvancedFilter, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)
        self.operator_type = 'NumberIn'


class NumberLessThanAdvancedFilter(AdvancedFilter):
    """NumberLessThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(NumberLessThanAdvancedFilter, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.operator_type = 'NumberLessThan'


class NumberLessThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberLessThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(NumberLessThanOrEqualsAdvancedFilter, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.operator_type = 'NumberLessThanOrEquals'


class NumberNotInAdvancedFilter(AdvancedFilter):
    """NumberNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(self, **kwargs):
        super(NumberNotInAdvancedFilter, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)
        self.operator_type = 'NumberNotIn'


class Operation(Model):
    """Represents an operation returned by the GetOperations request.

    :param name: Name of the operation
    :type name: str
    :param display: Display name of the operation
    :type display: ~azure.mgmt.eventgrid.models.OperationInfo
    :param origin: Origin of the operation
    :type origin: str
    :param properties: Properties of the operation
    :type properties: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationInfo(Model):
    """Information about an operation.

    :param provider: Name of the provider
    :type provider: str
    :param resource: Name of the resource type
    :type resource: str
    :param operation: Name of the operation
    :type operation: str
    :param description: Description of the operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationInfo, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class RetryPolicy(Model):
    """Information about the retry policy for an event subscription.

    :param max_delivery_attempts: Maximum number of delivery retry attempts
     for events.
    :type max_delivery_attempts: int
    :param event_time_to_live_in_minutes: Time To Live (in minutes) for
     events.
    :type event_time_to_live_in_minutes: int
    """

    _attribute_map = {
        'max_delivery_attempts': {'key': 'maxDeliveryAttempts', 'type': 'int'},
        'event_time_to_live_in_minutes': {'key': 'eventTimeToLiveInMinutes', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RetryPolicy, self).__init__(**kwargs)
        self.max_delivery_attempts = kwargs.get('max_delivery_attempts', None)
        self.event_time_to_live_in_minutes = kwargs.get('event_time_to_live_in_minutes', None)


class ServiceBusQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource Id that represents the endpoint of
     the Service Bus destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceBusQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.endpoint_type = 'ServiceBusQueue'


class ServiceBusTopicEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus topic destination for an event
    subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource Id that represents the endpoint of
     the Service Bus Topic destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceBusTopicEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.endpoint_type = 'ServiceBusTopic'


class StorageBlobDeadLetterDestination(DeadLetterDestination):
    """Information about the storage blob based dead letter destination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource ID of the storage account that is
     the destination of the deadletter events
    :type resource_id: str
    :param blob_container_name: The name of the Storage blob container that is
     the destination of the deadletter events
    :type blob_container_name: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'blob_container_name': {'key': 'properties.blobContainerName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StorageBlobDeadLetterDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.blob_container_name = kwargs.get('blob_container_name', None)
        self.endpoint_type = 'StorageBlob'


class StorageQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the storage queue destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource ID of the storage account that
     contains the queue that is the destination of an event subscription.
    :type resource_id: str
    :param queue_name: The name of the Storage queue under a storage account
     that is the destination of an event subscription.
    :type queue_name: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'queue_name': {'key': 'properties.queueName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StorageQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.queue_name = kwargs.get('queue_name', None)
        self.endpoint_type = 'StorageQueue'


class StringBeginsWithAdvancedFilter(AdvancedFilter):
    """StringBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(StringBeginsWithAdvancedFilter, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)
        self.operator_type = 'StringBeginsWith'


class StringContainsAdvancedFilter(AdvancedFilter):
    """StringContains Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(StringContainsAdvancedFilter, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)
        self.operator_type = 'StringContains'


class StringEndsWithAdvancedFilter(AdvancedFilter):
    """StringEndsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(StringEndsWithAdvancedFilter, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)
        self.operator_type = 'StringEndsWith'


class StringInAdvancedFilter(AdvancedFilter):
    """StringIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(StringInAdvancedFilter, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)
        self.operator_type = 'StringIn'


class StringNotInAdvancedFilter(AdvancedFilter):
    """StringNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(StringNotInAdvancedFilter, self).__init__(**kwargs)
        self.values = kwargs.get('values', None)
        self.operator_type = 'StringNotIn'


class Topic(TrackedResource):
    """EventGrid Topic.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource
    :vartype name: str
    :ivar type: Type of the resource
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the topic. Possible values
     include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Canceled',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.TopicProvisioningState
    :ivar endpoint: Endpoint for the topic.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should
     expect for incoming events published to the topic. Possible values
     include: 'EventGridSchema', 'CustomEventSchema', 'CloudEventSchemaV1_0'.
     Default value: "EventGridSchema" .
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: This enables publishing using custom event
     schemas. An InputSchemaMapping can be specified to map various properties
     of a source schema to various required properties of the EventGridEvent
     schema.
    :type input_schema_mapping:
     ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the topic.
    :vartype metric_resource_id: str
    :param allow_traffic_from_all_ips: This determines if IP filtering rules
     ought to be evaluated or not. By default it will not evaluate and will
     allow traffic from all IPs.
    :type allow_traffic_from_all_ips: bool
    :param inbound_ip_rules: This determines the IP filtering rules that ought
     to be applied when events are received on this topic.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'allow_traffic_from_all_ips': {'key': 'properties.allowTrafficFromAllIPs', 'type': 'bool'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(self, **kwargs):
        super(Topic, self).__init__(**kwargs)
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = kwargs.get('input_schema', "EventGridSchema")
        self.input_schema_mapping = kwargs.get('input_schema_mapping', None)
        self.metric_resource_id = None
        self.allow_traffic_from_all_ips = kwargs.get('allow_traffic_from_all_ips', None)
        self.inbound_ip_rules = kwargs.get('inbound_ip_rules', None)


class TopicRegenerateKeyRequest(Model):
    """Topic regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TopicRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = kwargs.get('key_name', None)


class TopicSharedAccessKeys(Model):
    """Shared access keys of the Topic.

    :param key1: Shared access key1 for the topic.
    :type key1: str
    :param key2: Shared access key2 for the topic.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TopicSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = kwargs.get('key1', None)
        self.key2 = kwargs.get('key2', None)


class TopicTypeInfo(Resource):
    """Properties of a topic type info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource
    :vartype name: str
    :ivar type: Type of the resource
    :vartype type: str
    :param provider: Namespace of the provider of the topic type.
    :type provider: str
    :param display_name: Display Name for the topic type.
    :type display_name: str
    :param description: Description of the topic type.
    :type description: str
    :param resource_region_type: Region type of the resource. Possible values
     include: 'RegionalResource', 'GlobalResource'
    :type resource_region_type: str or
     ~azure.mgmt.eventgrid.models.ResourceRegionType
    :param provisioning_state: Provisioning state of the topic type. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.eventgrid.models.TopicTypeProvisioningState
    :param supported_locations: List of locations supported by this topic
     type.
    :type supported_locations: list[str]
    :param source_resource_format: Source resource format.
    :type source_resource_format: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_region_type': {'key': 'properties.resourceRegionType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'supported_locations': {'key': 'properties.supportedLocations', 'type': '[str]'},
        'source_resource_format': {'key': 'properties.sourceResourceFormat', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TopicTypeInfo, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.resource_region_type = kwargs.get('resource_region_type', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.supported_locations = kwargs.get('supported_locations', None)
        self.source_resource_format = kwargs.get('source_resource_format', None)


class TopicUpdateParameters(Model):
    """Properties of the Topic update.

    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :param allow_traffic_from_all_ips: This determines if IP filtering rules
     ought to be evaluated or not. By default it will not evaluate and will
     allow traffic from all IPs.
    :type allow_traffic_from_all_ips: bool
    :param inbound_ip_rules: This determines the IP filtering rules that ought
     be applied when events are received on this domain.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'allow_traffic_from_all_ips': {'key': 'allowTrafficFromAllIPs', 'type': 'bool'},
        'inbound_ip_rules': {'key': 'inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(self, **kwargs):
        super(TopicUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.allow_traffic_from_all_ips = kwargs.get('allow_traffic_from_all_ips', None)
        self.inbound_ip_rules = kwargs.get('inbound_ip_rules', None)


class WebHookEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the webhook destination for an event subscription.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param endpoint_url: The URL that represents the endpoint of the
     destination of an event subscription.
    :type endpoint_url: str
    :ivar endpoint_base_url: The base URL that represents the endpoint of the
     destination of an event subscription.
    :vartype endpoint_base_url: str
    :param max_events_per_batch: Maximum number of events per batch.
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in
     Kilobytes.
    :type preferred_batch_size_in_kilobytes: int
    :param azure_active_directory_tenant_id: The Azure Active Directory Tenant
     ID to get the access token that will be included as the bearer token in
     delivery requests.
    :type azure_active_directory_tenant_id: str
    :param azure_active_directory_application_id_or_uri: The Azure Active
     Directory Application ID or URI to get the access token that will be
     included as the bearer token in delivery requests.
    :type azure_active_directory_application_id_or_uri: str
    """

    _validation = {
        'endpoint_type': {'required': True},
        'endpoint_base_url': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'endpoint_url': {'key': 'properties.endpointUrl', 'type': 'str'},
        'endpoint_base_url': {'key': 'properties.endpointBaseUrl', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
        'azure_active_directory_tenant_id': {'key': 'properties.azureActiveDirectoryTenantId', 'type': 'str'},
        'azure_active_directory_application_id_or_uri': {'key': 'properties.azureActiveDirectoryApplicationIdOrUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WebHookEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_url = kwargs.get('endpoint_url', None)
        self.endpoint_base_url = None
        self.max_events_per_batch = kwargs.get('max_events_per_batch', None)
        self.preferred_batch_size_in_kilobytes = kwargs.get('preferred_batch_size_in_kilobytes', None)
        self.azure_active_directory_tenant_id = kwargs.get('azure_active_directory_tenant_id', None)
        self.azure_active_directory_application_id_or_uri = kwargs.get('azure_active_directory_application_id_or_uri', None)
        self.endpoint_type = 'WebHook'
