# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.workflows_operations import WorkflowsOperations
from .operations.workflow_versions_operations import WorkflowVersionsOperations
from .operations.workflow_triggers_operations import WorkflowTriggersOperations
from .operations.workflow_version_triggers_operations import WorkflowVersionTriggersOperations
from .operations.workflow_trigger_histories_operations import WorkflowTriggerHistoriesOperations
from .operations.workflow_runs_operations import WorkflowRunsOperations
from .operations.workflow_run_actions_operations import WorkflowRunActionsOperations
from .operations.workflow_run_action_repetitions_operations import WorkflowRunActionRepetitionsOperations
from .operations.workflow_run_action_repetitions_request_histories_operations import WorkflowRunActionRepetitionsRequestHistoriesOperations
from .operations.workflow_run_action_request_histories_operations import WorkflowRunActionRequestHistoriesOperations
from .operations.workflow_run_action_scope_repetitions_operations import WorkflowRunActionScopeRepetitionsOperations
from .operations.workflow_run_operations import WorkflowRunOperations
from .operations.integration_accounts_operations import IntegrationAccountsOperations
from .operations.integration_account_assemblies_operations import IntegrationAccountAssembliesOperations
from .operations.integration_account_batch_configurations_operations import IntegrationAccountBatchConfigurationsOperations
from .operations.integration_account_schemas_operations import IntegrationAccountSchemasOperations
from .operations.integration_account_maps_operations import IntegrationAccountMapsOperations
from .operations.integration_account_partners_operations import IntegrationAccountPartnersOperations
from .operations.integration_account_agreements_operations import IntegrationAccountAgreementsOperations
from .operations.integration_account_certificates_operations import IntegrationAccountCertificatesOperations
from .operations.integration_account_sessions_operations import IntegrationAccountSessionsOperations
from .operations.operations import Operations
from . import models


class LogicManagementClientConfiguration(AzureConfiguration):
    """Configuration for LogicManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription id.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(LogicManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-logic/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class LogicManagementClient(SDKClient):
    """REST API for Azure Logic Apps.

    :ivar config: Configuration for client.
    :vartype config: LogicManagementClientConfiguration

    :ivar workflows: Workflows operations
    :vartype workflows: azure.mgmt.logic.operations.WorkflowsOperations
    :ivar workflow_versions: WorkflowVersions operations
    :vartype workflow_versions: azure.mgmt.logic.operations.WorkflowVersionsOperations
    :ivar workflow_triggers: WorkflowTriggers operations
    :vartype workflow_triggers: azure.mgmt.logic.operations.WorkflowTriggersOperations
    :ivar workflow_version_triggers: WorkflowVersionTriggers operations
    :vartype workflow_version_triggers: azure.mgmt.logic.operations.WorkflowVersionTriggersOperations
    :ivar workflow_trigger_histories: WorkflowTriggerHistories operations
    :vartype workflow_trigger_histories: azure.mgmt.logic.operations.WorkflowTriggerHistoriesOperations
    :ivar workflow_runs: WorkflowRuns operations
    :vartype workflow_runs: azure.mgmt.logic.operations.WorkflowRunsOperations
    :ivar workflow_run_actions: WorkflowRunActions operations
    :vartype workflow_run_actions: azure.mgmt.logic.operations.WorkflowRunActionsOperations
    :ivar workflow_run_action_repetitions: WorkflowRunActionRepetitions operations
    :vartype workflow_run_action_repetitions: azure.mgmt.logic.operations.WorkflowRunActionRepetitionsOperations
    :ivar workflow_run_action_repetitions_request_histories: WorkflowRunActionRepetitionsRequestHistories operations
    :vartype workflow_run_action_repetitions_request_histories: azure.mgmt.logic.operations.WorkflowRunActionRepetitionsRequestHistoriesOperations
    :ivar workflow_run_action_request_histories: WorkflowRunActionRequestHistories operations
    :vartype workflow_run_action_request_histories: azure.mgmt.logic.operations.WorkflowRunActionRequestHistoriesOperations
    :ivar workflow_run_action_scope_repetitions: WorkflowRunActionScopeRepetitions operations
    :vartype workflow_run_action_scope_repetitions: azure.mgmt.logic.operations.WorkflowRunActionScopeRepetitionsOperations
    :ivar workflow_run_operations: WorkflowRunOperations operations
    :vartype workflow_run_operations: azure.mgmt.logic.operations.WorkflowRunOperations
    :ivar integration_accounts: IntegrationAccounts operations
    :vartype integration_accounts: azure.mgmt.logic.operations.IntegrationAccountsOperations
    :ivar integration_account_assemblies: IntegrationAccountAssemblies operations
    :vartype integration_account_assemblies: azure.mgmt.logic.operations.IntegrationAccountAssembliesOperations
    :ivar integration_account_batch_configurations: IntegrationAccountBatchConfigurations operations
    :vartype integration_account_batch_configurations: azure.mgmt.logic.operations.IntegrationAccountBatchConfigurationsOperations
    :ivar integration_account_schemas: IntegrationAccountSchemas operations
    :vartype integration_account_schemas: azure.mgmt.logic.operations.IntegrationAccountSchemasOperations
    :ivar integration_account_maps: IntegrationAccountMaps operations
    :vartype integration_account_maps: azure.mgmt.logic.operations.IntegrationAccountMapsOperations
    :ivar integration_account_partners: IntegrationAccountPartners operations
    :vartype integration_account_partners: azure.mgmt.logic.operations.IntegrationAccountPartnersOperations
    :ivar integration_account_agreements: IntegrationAccountAgreements operations
    :vartype integration_account_agreements: azure.mgmt.logic.operations.IntegrationAccountAgreementsOperations
    :ivar integration_account_certificates: IntegrationAccountCertificates operations
    :vartype integration_account_certificates: azure.mgmt.logic.operations.IntegrationAccountCertificatesOperations
    :ivar integration_account_sessions: IntegrationAccountSessions operations
    :vartype integration_account_sessions: azure.mgmt.logic.operations.IntegrationAccountSessionsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.logic.operations.Operations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription id.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = LogicManagementClientConfiguration(credentials, subscription_id, base_url)
        super(LogicManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-07-01-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.workflows = WorkflowsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_versions = WorkflowVersionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_triggers = WorkflowTriggersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_version_triggers = WorkflowVersionTriggersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_trigger_histories = WorkflowTriggerHistoriesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_runs = WorkflowRunsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_actions = WorkflowRunActionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_action_repetitions = WorkflowRunActionRepetitionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_action_repetitions_request_histories = WorkflowRunActionRepetitionsRequestHistoriesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_action_request_histories = WorkflowRunActionRequestHistoriesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_action_scope_repetitions = WorkflowRunActionScopeRepetitionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.workflow_run_operations = WorkflowRunOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_accounts = IntegrationAccountsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_assemblies = IntegrationAccountAssembliesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_batch_configurations = IntegrationAccountBatchConfigurationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_schemas = IntegrationAccountSchemasOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_maps = IntegrationAccountMapsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_partners = IntegrationAccountPartnersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_agreements = IntegrationAccountAgreementsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_certificates = IntegrationAccountCertificatesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.integration_account_sessions = IntegrationAccountSessionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
