# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ApprovalSettings(msrest.serialization.Model):
    """The approval settings.

    :param is_approval_required: Determine whether approval is required or not.
    :type is_approval_required: bool
    :param is_approval_required_for_extension: Determine whether approval is required for
     assignment extension.
    :type is_approval_required_for_extension: bool
    :param is_requestor_justification_required: Determine whether requestor justification required.
    :type is_requestor_justification_required: bool
    :param approval_mode: The type of rule. Possible values include: "SingleStage", "Serial",
     "Parallel", "NoApproval".
    :type approval_mode: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.ApprovalMode
    :param approval_stages: The approval stages of the request.
    :type approval_stages: list[~azure.mgmt.authorization.v2020_10_01_preview.models.ApprovalStage]
    """

    _attribute_map = {
        'is_approval_required': {'key': 'isApprovalRequired', 'type': 'bool'},
        'is_approval_required_for_extension': {'key': 'isApprovalRequiredForExtension', 'type': 'bool'},
        'is_requestor_justification_required': {'key': 'isRequestorJustificationRequired', 'type': 'bool'},
        'approval_mode': {'key': 'approvalMode', 'type': 'str'},
        'approval_stages': {'key': 'approvalStages', 'type': '[ApprovalStage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApprovalSettings, self).__init__(**kwargs)
        self.is_approval_required = kwargs.get('is_approval_required', None)
        self.is_approval_required_for_extension = kwargs.get('is_approval_required_for_extension', None)
        self.is_requestor_justification_required = kwargs.get('is_requestor_justification_required', None)
        self.approval_mode = kwargs.get('approval_mode', None)
        self.approval_stages = kwargs.get('approval_stages', None)


class ApprovalStage(msrest.serialization.Model):
    """The approval stage.

    :param approval_stage_time_out_in_days: The time in days when approval request would be timed
     out.
    :type approval_stage_time_out_in_days: int
    :param is_approver_justification_required: Determine whether approver need to provide
     justification for his decision.
    :type is_approver_justification_required: bool
    :param escalation_time_in_minutes: The time in minutes when the approval request would be
     escalated if the primary approver does not approves.
    :type escalation_time_in_minutes: int
    :param primary_approvers: The primary approver of the request.
    :type primary_approvers: list[~azure.mgmt.authorization.v2020_10_01_preview.models.UserSet]
    :param is_escalation_enabled: The value determine whether escalation feature is enabled.
    :type is_escalation_enabled: bool
    :param escalation_approvers: The escalation approver of the request.
    :type escalation_approvers: list[~azure.mgmt.authorization.v2020_10_01_preview.models.UserSet]
    """

    _attribute_map = {
        'approval_stage_time_out_in_days': {'key': 'approvalStageTimeOutInDays', 'type': 'int'},
        'is_approver_justification_required': {'key': 'isApproverJustificationRequired', 'type': 'bool'},
        'escalation_time_in_minutes': {'key': 'escalationTimeInMinutes', 'type': 'int'},
        'primary_approvers': {'key': 'primaryApprovers', 'type': '[UserSet]'},
        'is_escalation_enabled': {'key': 'isEscalationEnabled', 'type': 'bool'},
        'escalation_approvers': {'key': 'escalationApprovers', 'type': '[UserSet]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApprovalStage, self).__init__(**kwargs)
        self.approval_stage_time_out_in_days = kwargs.get('approval_stage_time_out_in_days', None)
        self.is_approver_justification_required = kwargs.get('is_approver_justification_required', None)
        self.escalation_time_in_minutes = kwargs.get('escalation_time_in_minutes', None)
        self.primary_approvers = kwargs.get('primary_approvers', None)
        self.is_escalation_enabled = kwargs.get('is_escalation_enabled', None)
        self.escalation_approvers = kwargs.get('escalation_approvers', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class EligibleChildResource(msrest.serialization.Model):
    """Eligible child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource scope Id.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EligibleChildResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class EligibleChildResourcesListResult(msrest.serialization.Model):
    """Eligible child resources list operation result.

    :param value: Eligible child resource list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.EligibleChildResource]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EligibleChildResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EligibleChildResourcesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.authorization.v2020_10_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.authorization.v2020_10_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExpandedProperties(msrest.serialization.Model):
    """ExpandedProperties.

    :param scope: Details of the resource scope.
    :type scope: ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedPropertiesScope
    :param role_definition: Details of role definition.
    :type role_definition:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedPropertiesRoleDefinition
    :param principal: Details of the principal.
    :type principal:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedPropertiesPrincipal
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'ExpandedPropertiesScope'},
        'role_definition': {'key': 'roleDefinition', 'type': 'ExpandedPropertiesRoleDefinition'},
        'principal': {'key': 'principal', 'type': 'ExpandedPropertiesPrincipal'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpandedProperties, self).__init__(**kwargs)
        self.scope = kwargs.get('scope', None)
        self.role_definition = kwargs.get('role_definition', None)
        self.principal = kwargs.get('principal', None)


class ExpandedPropertiesPrincipal(msrest.serialization.Model):
    """Details of the principal.

    :param id: Id of the principal.
    :type id: str
    :param display_name: Display name of the principal.
    :type display_name: str
    :param email: Email id of the principal.
    :type email: str
    :param type: Type of the principal.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpandedPropertiesPrincipal, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.email = kwargs.get('email', None)
        self.type = kwargs.get('type', None)


class ExpandedPropertiesRoleDefinition(msrest.serialization.Model):
    """Details of role definition.

    :param id: Id of the role definition.
    :type id: str
    :param display_name: Display name of the role definition.
    :type display_name: str
    :param type: Type of the role definition.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpandedPropertiesRoleDefinition, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.type = kwargs.get('type', None)


class ExpandedPropertiesScope(msrest.serialization.Model):
    """Details of the resource scope.

    :param id: Scope id of the resource.
    :type id: str
    :param display_name: Display name of the resource.
    :type display_name: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpandedPropertiesScope, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.type = kwargs.get('type', None)


class Permission(msrest.serialization.Model):
    """Role definition permissions.

    :param actions: Allowed actions.
    :type actions: list[str]
    :param not_actions: Denied actions.
    :type not_actions: list[str]
    :param data_actions: Allowed Data actions.
    :type data_actions: list[str]
    :param not_data_actions: Denied Data actions.
    :type not_data_actions: list[str]
    """

    _attribute_map = {
        'actions': {'key': 'actions', 'type': '[str]'},
        'not_actions': {'key': 'notActions', 'type': '[str]'},
        'data_actions': {'key': 'dataActions', 'type': '[str]'},
        'not_data_actions': {'key': 'notDataActions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Permission, self).__init__(**kwargs)
        self.actions = kwargs.get('actions', None)
        self.not_actions = kwargs.get('not_actions', None)
        self.data_actions = kwargs.get('data_actions', None)
        self.not_data_actions = kwargs.get('not_data_actions', None)


class PolicyAssignmentProperties(msrest.serialization.Model):
    """PolicyAssignmentProperties.

    :param scope: Details of the resource scope.
    :type scope:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyAssignmentPropertiesScope
    :param role_definition: Details of role definition.
    :type role_definition:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyAssignmentPropertiesRoleDefinition
    :param policy: Details of the policy.
    :type policy:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyAssignmentPropertiesPolicy
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'PolicyAssignmentPropertiesScope'},
        'role_definition': {'key': 'roleDefinition', 'type': 'PolicyAssignmentPropertiesRoleDefinition'},
        'policy': {'key': 'policy', 'type': 'PolicyAssignmentPropertiesPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyAssignmentProperties, self).__init__(**kwargs)
        self.scope = kwargs.get('scope', None)
        self.role_definition = kwargs.get('role_definition', None)
        self.policy = kwargs.get('policy', None)


class PolicyAssignmentPropertiesPolicy(msrest.serialization.Model):
    """Details of the policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Id of the policy.
    :type id: str
    :ivar last_modified_by: The name of the entity last modified it.
    :vartype last_modified_by: ~azure.mgmt.authorization.v2020_10_01_preview.models.Principal
    :param last_modified_date_time: The last modified date time.
    :type last_modified_date_time: ~datetime.datetime
    """

    _validation = {
        'last_modified_by': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'Principal'},
        'last_modified_date_time': {'key': 'lastModifiedDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyAssignmentPropertiesPolicy, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.last_modified_by = None
        self.last_modified_date_time = kwargs.get('last_modified_date_time', None)


class PolicyAssignmentPropertiesRoleDefinition(msrest.serialization.Model):
    """Details of role definition.

    :param id: Id of the role definition.
    :type id: str
    :param display_name: Display name of the role definition.
    :type display_name: str
    :param type: Type of the role definition.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyAssignmentPropertiesRoleDefinition, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.type = kwargs.get('type', None)


class PolicyAssignmentPropertiesScope(msrest.serialization.Model):
    """Details of the resource scope.

    :param id: Scope id of the resource.
    :type id: str
    :param display_name: Display name of the resource.
    :type display_name: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyAssignmentPropertiesScope, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.type = kwargs.get('type', None)


class PolicyProperties(msrest.serialization.Model):
    """PolicyProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scope: Details of the resource scope.
    :vartype scope: ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyPropertiesScope
    """

    _validation = {
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'PolicyPropertiesScope'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyProperties, self).__init__(**kwargs)
        self.scope = None


class PolicyPropertiesScope(msrest.serialization.Model):
    """Details of the resource scope.

    :param id: Scope id of the resource.
    :type id: str
    :param display_name: Display name of the resource.
    :type display_name: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyPropertiesScope, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.type = kwargs.get('type', None)


class Principal(msrest.serialization.Model):
    """The name of the entity last modified it.

    :param id: The id of the principal made changes.
    :type id: str
    :param display_name: The name of the principal made changes.
    :type display_name: str
    :param type: Type of principal such as user , group etc.
    :type type: str
    :param email: Email of principal.
    :type email: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Principal, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.type = kwargs.get('type', None)
        self.email = kwargs.get('email', None)


class RoleAssignment(msrest.serialization.Model):
    """Role Assignments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment ID.
    :vartype id: str
    :ivar name: The role assignment name.
    :vartype name: str
    :ivar type: The role assignment type.
    :vartype type: str
    :ivar scope: The role assignment scope.
    :vartype scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param description: Description of role assignment.
    :type description: str
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :ivar created_on: Time it was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: Time it was updated.
    :vartype updated_on: ~datetime.datetime
    :ivar created_by: Id of the user who created the assignment.
    :vartype created_by: str
    :ivar updated_by: Id of the user who updated the assignment.
    :vartype updated_by: str
    :param delegated_managed_identity_resource_id: Id of the delegated managed identity resource.
    :type delegated_managed_identity_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scope': {'readonly': True},
        'created_on': {'readonly': True},
        'updated_on': {'readonly': True},
        'created_by': {'readonly': True},
        'updated_by': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'updated_on': {'key': 'properties.updatedOn', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'str'},
        'delegated_managed_identity_resource_id': {'key': 'properties.delegatedManagedIdentityResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignment, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = None
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.principal_type = kwargs.get('principal_type', None)
        self.description = kwargs.get('description', None)
        self.condition = kwargs.get('condition', None)
        self.condition_version = kwargs.get('condition_version', None)
        self.created_on = None
        self.updated_on = None
        self.created_by = None
        self.updated_by = None
        self.delegated_managed_identity_resource_id = kwargs.get('delegated_managed_identity_resource_id', None)


class RoleAssignmentCreateParameters(msrest.serialization.Model):
    """Role assignment create parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar scope: The role assignment scope.
    :vartype scope: str
    :param role_definition_id: Required. The role definition ID.
    :type role_definition_id: str
    :param principal_id: Required. The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param description: Description of role assignment.
    :type description: str
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :ivar created_on: Time it was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: Time it was updated.
    :vartype updated_on: ~datetime.datetime
    :ivar created_by: Id of the user who created the assignment.
    :vartype created_by: str
    :ivar updated_by: Id of the user who updated the assignment.
    :vartype updated_by: str
    :param delegated_managed_identity_resource_id: Id of the delegated managed identity resource.
    :type delegated_managed_identity_resource_id: str
    """

    _validation = {
        'scope': {'readonly': True},
        'role_definition_id': {'required': True},
        'principal_id': {'required': True},
        'created_on': {'readonly': True},
        'updated_on': {'readonly': True},
        'created_by': {'readonly': True},
        'updated_by': {'readonly': True},
    }

    _attribute_map = {
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'updated_on': {'key': 'properties.updatedOn', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'str'},
        'delegated_managed_identity_resource_id': {'key': 'properties.delegatedManagedIdentityResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentCreateParameters, self).__init__(**kwargs)
        self.scope = None
        self.role_definition_id = kwargs['role_definition_id']
        self.principal_id = kwargs['principal_id']
        self.principal_type = kwargs.get('principal_type', None)
        self.description = kwargs.get('description', None)
        self.condition = kwargs.get('condition', None)
        self.condition_version = kwargs.get('condition_version', None)
        self.created_on = None
        self.updated_on = None
        self.created_by = None
        self.updated_by = None
        self.delegated_managed_identity_resource_id = kwargs.get('delegated_managed_identity_resource_id', None)


class RoleAssignmentFilter(msrest.serialization.Model):
    """Role Assignments filter.

    :param principal_id: Returns role assignment of the specific principal.
    :type principal_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentFilter, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)


class RoleAssignmentListResult(msrest.serialization.Model):
    """Role assignment list operation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Role assignment list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleAssignment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class RoleAssignmentSchedule(msrest.serialization.Model):
    """Role Assignment schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule Id.
    :vartype id: str
    :ivar name: The role assignment schedule name.
    :vartype name: str
    :ivar type: The role assignment schedule type.
    :vartype type: str
    :param scope: The role assignment schedule scope.
    :type scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param role_assignment_schedule_request_id: The id of roleAssignmentScheduleRequest used to
     create this roleAssignmentSchedule.
    :type role_assignment_schedule_request_id: str
    :param linked_role_eligibility_schedule_id: The id of roleEligibilitySchedule used to activated
     this roleAssignmentSchedule.
    :type linked_role_eligibility_schedule_id: str
    :param assignment_type: Assignment type of the role assignment schedule. Possible values
     include: "Activated", "Assigned".
    :type assignment_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.AssignmentType
    :param member_type: Membership type of the role assignment schedule. Possible values include:
     "Inherited", "Direct", "Group".
    :type member_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.MemberType
    :param status: The status of the role assignment schedule. Possible values include: "Accepted",
     "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :type status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :param start_date_time: Start DateTime when role assignment schedule.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: End DateTime when role assignment schedule.
    :type end_date_time: ~datetime.datetime
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :param created_on: DateTime when role assignment schedule was created.
    :type created_on: ~datetime.datetime
    :param updated_on: DateTime when role assignment schedule was modified.
    :type updated_on: ~datetime.datetime
    :param expanded_properties: Additional properties of principal, scope and role definition.
    :type expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'role_assignment_schedule_request_id': {'key': 'properties.roleAssignmentScheduleRequestId', 'type': 'str'},
        'linked_role_eligibility_schedule_id': {'key': 'properties.linkedRoleEligibilityScheduleId', 'type': 'str'},
        'assignment_type': {'key': 'properties.assignmentType', 'type': 'str'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'updated_on': {'key': 'properties.updatedOn', 'type': 'iso-8601'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentSchedule, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = kwargs.get('scope', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.principal_type = kwargs.get('principal_type', None)
        self.role_assignment_schedule_request_id = kwargs.get('role_assignment_schedule_request_id', None)
        self.linked_role_eligibility_schedule_id = kwargs.get('linked_role_eligibility_schedule_id', None)
        self.assignment_type = kwargs.get('assignment_type', None)
        self.member_type = kwargs.get('member_type', None)
        self.status = kwargs.get('status', None)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.condition = kwargs.get('condition', None)
        self.condition_version = kwargs.get('condition_version', None)
        self.created_on = kwargs.get('created_on', None)
        self.updated_on = kwargs.get('updated_on', None)
        self.expanded_properties = kwargs.get('expanded_properties', None)


class RoleAssignmentScheduleFilter(msrest.serialization.Model):
    """Role assignment schedule filter.

    :param principal_id: Returns role assignment schedule of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role assignment schedule of the specific role definition.
    :type role_definition_id: str
    :param status: Returns role assignment schedule instances of the specific status.
    :type status: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleFilter, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.status = kwargs.get('status', None)


class RoleAssignmentScheduleInstance(msrest.serialization.Model):
    """Information about current or upcoming role assignment schedule instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule instance ID.
    :vartype id: str
    :ivar name: The role assignment schedule instance name.
    :vartype name: str
    :ivar type: The role assignment schedule instance type.
    :vartype type: str
    :param scope: The role assignment schedule scope.
    :type scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param role_assignment_schedule_id: Id of the master role assignment schedule.
    :type role_assignment_schedule_id: str
    :param origin_role_assignment_id: Role Assignment Id in external system.
    :type origin_role_assignment_id: str
    :param status: The status of the role assignment schedule instance. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :type status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :param start_date_time: The startDateTime of the role assignment schedule instance.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: The endDateTime of the role assignment schedule instance.
    :type end_date_time: ~datetime.datetime
    :param linked_role_eligibility_schedule_id: roleEligibilityScheduleId used to activate.
    :type linked_role_eligibility_schedule_id: str
    :param linked_role_eligibility_schedule_instance_id: roleEligibilityScheduleInstanceId linked
     to this roleAssignmentScheduleInstance.
    :type linked_role_eligibility_schedule_instance_id: str
    :param assignment_type: Assignment type of the role assignment schedule. Possible values
     include: "Activated", "Assigned".
    :type assignment_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.AssignmentType
    :param member_type: Membership type of the role assignment schedule. Possible values include:
     "Inherited", "Direct", "Group".
    :type member_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.MemberType
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :param created_on: DateTime when role assignment schedule was created.
    :type created_on: ~datetime.datetime
    :param expanded_properties: Additional properties of principal, scope and role definition.
    :type expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'role_assignment_schedule_id': {'key': 'properties.roleAssignmentScheduleId', 'type': 'str'},
        'origin_role_assignment_id': {'key': 'properties.originRoleAssignmentId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'linked_role_eligibility_schedule_id': {'key': 'properties.linkedRoleEligibilityScheduleId', 'type': 'str'},
        'linked_role_eligibility_schedule_instance_id': {'key': 'properties.linkedRoleEligibilityScheduleInstanceId', 'type': 'str'},
        'assignment_type': {'key': 'properties.assignmentType', 'type': 'str'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleInstance, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = kwargs.get('scope', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.principal_type = kwargs.get('principal_type', None)
        self.role_assignment_schedule_id = kwargs.get('role_assignment_schedule_id', None)
        self.origin_role_assignment_id = kwargs.get('origin_role_assignment_id', None)
        self.status = kwargs.get('status', None)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.linked_role_eligibility_schedule_id = kwargs.get('linked_role_eligibility_schedule_id', None)
        self.linked_role_eligibility_schedule_instance_id = kwargs.get('linked_role_eligibility_schedule_instance_id', None)
        self.assignment_type = kwargs.get('assignment_type', None)
        self.member_type = kwargs.get('member_type', None)
        self.condition = kwargs.get('condition', None)
        self.condition_version = kwargs.get('condition_version', None)
        self.created_on = kwargs.get('created_on', None)
        self.expanded_properties = kwargs.get('expanded_properties', None)


class RoleAssignmentScheduleInstanceFilter(msrest.serialization.Model):
    """Role assignment schedule instance filter.

    :param principal_id: Returns role assignment schedule instances of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role assignment schedule instances of the specific role
     definition.
    :type role_definition_id: str
    :param status: Returns role assignment schedule instances of the specific status.
    :type status: str
    :param role_assignment_schedule_id: Returns role assignment schedule instances belonging to a
     specific role assignment schedule.
    :type role_assignment_schedule_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'role_assignment_schedule_id': {'key': 'roleAssignmentScheduleId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleInstanceFilter, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.status = kwargs.get('status', None)
        self.role_assignment_schedule_id = kwargs.get('role_assignment_schedule_id', None)


class RoleAssignmentScheduleInstanceListResult(msrest.serialization.Model):
    """Role assignment schedule instance list operation result.

    :param value: Role assignment schedule instance list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleInstance]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleAssignmentScheduleInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleInstanceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RoleAssignmentScheduleListResult(msrest.serialization.Model):
    """Role assignment schedule list operation result.

    :param value: Role assignment schedule list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentSchedule]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleAssignmentSchedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RoleAssignmentScheduleRequest(msrest.serialization.Model):
    """Role Assignment schedule request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule request ID.
    :vartype id: str
    :ivar name: The role assignment schedule request name.
    :vartype name: str
    :ivar type: The role assignment schedule request type.
    :vartype type: str
    :ivar scope: The role assignment schedule request scope.
    :vartype scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Possible values include:
     "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :vartype principal_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param request_type: The type of the role assignment schedule request. Eg: SelfActivate,
     AdminAssign etc. Possible values include: "AdminAssign", "AdminRemove", "AdminUpdate",
     "AdminExtend", "AdminRenew", "SelfActivate", "SelfDeactivate", "SelfExtend", "SelfRenew".
    :type request_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.RequestType
    :ivar status: The status of the role assignment schedule request. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :ivar approval_id: The approvalId of the role assignment schedule request.
    :vartype approval_id: str
    :param target_role_assignment_schedule_id: The resultant role assignment schedule id or the
     role assignment schedule id being updated.
    :type target_role_assignment_schedule_id: str
    :param target_role_assignment_schedule_instance_id: The role assignment schedule instance id
     being updated.
    :type target_role_assignment_schedule_instance_id: str
    :param schedule_info: Schedule info of the role assignment schedule.
    :type schedule_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleRequestPropertiesScheduleInfo
    :param linked_role_eligibility_schedule_id: The linked role eligibility schedule id - to
     activate an eligibility.
    :type linked_role_eligibility_schedule_id: str
    :param justification: Justification for the role assignment.
    :type justification: str
    :param ticket_info: Ticket Info of the role assignment.
    :type ticket_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleRequestPropertiesTicketInfo
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :ivar created_on: DateTime when role assignment schedule request was created.
    :vartype created_on: ~datetime.datetime
    :ivar requestor_id: Id of the user who created this request.
    :vartype requestor_id: str
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scope': {'readonly': True},
        'principal_type': {'readonly': True},
        'status': {'readonly': True},
        'approval_id': {'readonly': True},
        'created_on': {'readonly': True},
        'requestor_id': {'readonly': True},
        'expanded_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'request_type': {'key': 'properties.requestType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'approval_id': {'key': 'properties.approvalId', 'type': 'str'},
        'target_role_assignment_schedule_id': {'key': 'properties.targetRoleAssignmentScheduleId', 'type': 'str'},
        'target_role_assignment_schedule_instance_id': {'key': 'properties.targetRoleAssignmentScheduleInstanceId', 'type': 'str'},
        'schedule_info': {'key': 'properties.scheduleInfo', 'type': 'RoleAssignmentScheduleRequestPropertiesScheduleInfo'},
        'linked_role_eligibility_schedule_id': {'key': 'properties.linkedRoleEligibilityScheduleId', 'type': 'str'},
        'justification': {'key': 'properties.justification', 'type': 'str'},
        'ticket_info': {'key': 'properties.ticketInfo', 'type': 'RoleAssignmentScheduleRequestPropertiesTicketInfo'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'requestor_id': {'key': 'properties.requestorId', 'type': 'str'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequest, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = None
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.principal_type = None
        self.request_type = kwargs.get('request_type', None)
        self.status = None
        self.approval_id = None
        self.target_role_assignment_schedule_id = kwargs.get('target_role_assignment_schedule_id', None)
        self.target_role_assignment_schedule_instance_id = kwargs.get('target_role_assignment_schedule_instance_id', None)
        self.schedule_info = kwargs.get('schedule_info', None)
        self.linked_role_eligibility_schedule_id = kwargs.get('linked_role_eligibility_schedule_id', None)
        self.justification = kwargs.get('justification', None)
        self.ticket_info = kwargs.get('ticket_info', None)
        self.condition = kwargs.get('condition', None)
        self.condition_version = kwargs.get('condition_version', None)
        self.created_on = None
        self.requestor_id = None
        self.expanded_properties = None


class RoleAssignmentScheduleRequestFilter(msrest.serialization.Model):
    """Role assignment schedule request filter.

    :param principal_id: Returns role assignment requests of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role assignment requests of the specific role definition.
    :type role_definition_id: str
    :param requestor_id: Returns role assignment requests created by specific principal.
    :type requestor_id: str
    :param status: Returns role assignment requests of specific status.
    :type status: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'requestor_id': {'key': 'requestorId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestFilter, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.requestor_id = kwargs.get('requestor_id', None)
        self.status = kwargs.get('status', None)


class RoleAssignmentScheduleRequestListResult(msrest.serialization.Model):
    """Role assignment schedule request list operation result.

    :param value: Role assignment schedule request list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleRequest]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleAssignmentScheduleRequest]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RoleAssignmentScheduleRequestPropertiesScheduleInfo(msrest.serialization.Model):
    """Schedule info of the role assignment schedule.

    :param start_date_time: Start DateTime of the role assignment schedule.
    :type start_date_time: ~datetime.datetime
    :param expiration: Expiration of the role assignment schedule.
    :type expiration:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration
    """

    _attribute_map = {
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'expiration': {'key': 'expiration', 'type': 'RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestPropertiesScheduleInfo, self).__init__(**kwargs)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.expiration = kwargs.get('expiration', None)


class RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration(msrest.serialization.Model):
    """Expiration of the role assignment schedule.

    :param type: Type of the role assignment schedule expiration. Possible values include:
     "AfterDuration", "AfterDateTime", "NoExpiration".
    :type type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Type
    :param end_date_time: End DateTime of the role assignment schedule.
    :type end_date_time: ~datetime.datetime
    :param duration: Duration of the role assignment schedule in TimeSpan.
    :type duration: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.duration = kwargs.get('duration', None)


class RoleAssignmentScheduleRequestPropertiesTicketInfo(msrest.serialization.Model):
    """Ticket Info of the role assignment.

    :param ticket_number: Ticket number for the role assignment.
    :type ticket_number: str
    :param ticket_system: Ticket system name for the role assignment.
    :type ticket_system: str
    """

    _attribute_map = {
        'ticket_number': {'key': 'ticketNumber', 'type': 'str'},
        'ticket_system': {'key': 'ticketSystem', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestPropertiesTicketInfo, self).__init__(**kwargs)
        self.ticket_number = kwargs.get('ticket_number', None)
        self.ticket_system = kwargs.get('ticket_system', None)


class RoleEligibilitySchedule(msrest.serialization.Model):
    """Role eligibility schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule Id.
    :vartype id: str
    :ivar name: The role eligibility schedule name.
    :vartype name: str
    :ivar type: The role eligibility schedule type.
    :vartype type: str
    :param scope: The role eligibility schedule scope.
    :type scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param role_eligibility_schedule_request_id: The id of roleEligibilityScheduleRequest used to
     create this roleAssignmentSchedule.
    :type role_eligibility_schedule_request_id: str
    :param member_type: Membership type of the role eligibility schedule. Possible values include:
     "Inherited", "Direct", "Group".
    :type member_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.MemberType
    :param status: The status of the role eligibility schedule. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :type status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :param start_date_time: Start DateTime when role eligibility schedule.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: End DateTime when role eligibility schedule.
    :type end_date_time: ~datetime.datetime
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :param created_on: DateTime when role eligibility schedule was created.
    :type created_on: ~datetime.datetime
    :param updated_on: DateTime when role eligibility schedule was modified.
    :type updated_on: ~datetime.datetime
    :param expanded_properties: Additional properties of principal, scope and role definition.
    :type expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'role_eligibility_schedule_request_id': {'key': 'properties.roleEligibilityScheduleRequestId', 'type': 'str'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'updated_on': {'key': 'properties.updatedOn', 'type': 'iso-8601'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilitySchedule, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = kwargs.get('scope', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.principal_type = kwargs.get('principal_type', None)
        self.role_eligibility_schedule_request_id = kwargs.get('role_eligibility_schedule_request_id', None)
        self.member_type = kwargs.get('member_type', None)
        self.status = kwargs.get('status', None)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.condition = kwargs.get('condition', None)
        self.condition_version = kwargs.get('condition_version', None)
        self.created_on = kwargs.get('created_on', None)
        self.updated_on = kwargs.get('updated_on', None)
        self.expanded_properties = kwargs.get('expanded_properties', None)


class RoleEligibilityScheduleFilter(msrest.serialization.Model):
    """Role eligibility schedule filter.

    :param principal_id: Returns role eligibility schedule of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role eligibility schedule of the specific role definition.
    :type role_definition_id: str
    :param status: Returns role eligibility schedule of the specific status.
    :type status: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleFilter, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.status = kwargs.get('status', None)


class RoleEligibilityScheduleInstance(msrest.serialization.Model):
    """Information about current or upcoming role eligibility schedule instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule instance ID.
    :vartype id: str
    :ivar name: The role eligibility schedule instance name.
    :vartype name: str
    :ivar type: The role eligibility schedule instance type.
    :vartype type: str
    :param scope: The role eligibility schedule scope.
    :type scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param role_eligibility_schedule_id: Id of the master role eligibility schedule.
    :type role_eligibility_schedule_id: str
    :param status: The status of the role eligibility schedule instance. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :type status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :param start_date_time: The startDateTime of the role eligibility schedule instance.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: The endDateTime of the role eligibility schedule instance.
    :type end_date_time: ~datetime.datetime
    :param member_type: Membership type of the role eligibility schedule. Possible values include:
     "Inherited", "Direct", "Group".
    :type member_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.MemberType
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :param created_on: DateTime when role eligibility schedule was created.
    :type created_on: ~datetime.datetime
    :param expanded_properties: Additional properties of principal, scope and role definition.
    :type expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'role_eligibility_schedule_id': {'key': 'properties.roleEligibilityScheduleId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleInstance, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = kwargs.get('scope', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.principal_type = kwargs.get('principal_type', None)
        self.role_eligibility_schedule_id = kwargs.get('role_eligibility_schedule_id', None)
        self.status = kwargs.get('status', None)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.member_type = kwargs.get('member_type', None)
        self.condition = kwargs.get('condition', None)
        self.condition_version = kwargs.get('condition_version', None)
        self.created_on = kwargs.get('created_on', None)
        self.expanded_properties = kwargs.get('expanded_properties', None)


class RoleEligibilityScheduleInstanceFilter(msrest.serialization.Model):
    """Role eligibility schedule instance filter.

    :param principal_id: Returns role eligibility schedule instances of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role eligibility schedule instances of the specific role
     definition.
    :type role_definition_id: str
    :param status: Returns role eligibility schedule instances of the specific status.
    :type status: str
    :param role_eligibility_schedule_id: Returns role eligibility schedule instances belonging to a
     specific role eligibility schedule.
    :type role_eligibility_schedule_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'role_eligibility_schedule_id': {'key': 'roleEligibilityScheduleId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleInstanceFilter, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.status = kwargs.get('status', None)
        self.role_eligibility_schedule_id = kwargs.get('role_eligibility_schedule_id', None)


class RoleEligibilityScheduleInstanceListResult(msrest.serialization.Model):
    """Role eligibility schedule instance list operation result.

    :param value: Role eligibility schedule instance list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleInstance]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleEligibilityScheduleInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleInstanceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RoleEligibilityScheduleListResult(msrest.serialization.Model):
    """role eligibility schedule list operation result.

    :param value: role eligibility schedule list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilitySchedule]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleEligibilitySchedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RoleEligibilityScheduleRequest(msrest.serialization.Model):
    """Role Eligibility schedule request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule request ID.
    :vartype id: str
    :ivar name: The role eligibility schedule request name.
    :vartype name: str
    :ivar type: The role eligibility schedule request type.
    :vartype type: str
    :ivar scope: The role eligibility schedule request scope.
    :vartype scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Possible values include:
     "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :vartype principal_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param request_type: The type of the role assignment schedule request. Eg: SelfActivate,
     AdminAssign etc. Possible values include: "AdminAssign", "AdminRemove", "AdminUpdate",
     "AdminExtend", "AdminRenew", "SelfActivate", "SelfDeactivate", "SelfExtend", "SelfRenew".
    :type request_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.RequestType
    :ivar status: The status of the role eligibility schedule request. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :ivar approval_id: The approvalId of the role eligibility schedule request.
    :vartype approval_id: str
    :param schedule_info: Schedule info of the role eligibility schedule.
    :type schedule_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleRequestPropertiesScheduleInfo
    :param target_role_eligibility_schedule_id: The resultant role eligibility schedule id or the
     role eligibility schedule id being updated.
    :type target_role_eligibility_schedule_id: str
    :param target_role_eligibility_schedule_instance_id: The role eligibility schedule instance id
     being updated.
    :type target_role_eligibility_schedule_instance_id: str
    :param justification: Justification for the role eligibility.
    :type justification: str
    :param ticket_info: Ticket Info of the role eligibility.
    :type ticket_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleRequestPropertiesTicketInfo
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :ivar created_on: DateTime when role eligibility schedule request was created.
    :vartype created_on: ~datetime.datetime
    :ivar requestor_id: Id of the user who created this request.
    :vartype requestor_id: str
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scope': {'readonly': True},
        'principal_type': {'readonly': True},
        'status': {'readonly': True},
        'approval_id': {'readonly': True},
        'created_on': {'readonly': True},
        'requestor_id': {'readonly': True},
        'expanded_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'request_type': {'key': 'properties.requestType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'approval_id': {'key': 'properties.approvalId', 'type': 'str'},
        'schedule_info': {'key': 'properties.scheduleInfo', 'type': 'RoleEligibilityScheduleRequestPropertiesScheduleInfo'},
        'target_role_eligibility_schedule_id': {'key': 'properties.targetRoleEligibilityScheduleId', 'type': 'str'},
        'target_role_eligibility_schedule_instance_id': {'key': 'properties.targetRoleEligibilityScheduleInstanceId', 'type': 'str'},
        'justification': {'key': 'properties.justification', 'type': 'str'},
        'ticket_info': {'key': 'properties.ticketInfo', 'type': 'RoleEligibilityScheduleRequestPropertiesTicketInfo'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'requestor_id': {'key': 'properties.requestorId', 'type': 'str'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequest, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = None
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.principal_type = None
        self.request_type = kwargs.get('request_type', None)
        self.status = None
        self.approval_id = None
        self.schedule_info = kwargs.get('schedule_info', None)
        self.target_role_eligibility_schedule_id = kwargs.get('target_role_eligibility_schedule_id', None)
        self.target_role_eligibility_schedule_instance_id = kwargs.get('target_role_eligibility_schedule_instance_id', None)
        self.justification = kwargs.get('justification', None)
        self.ticket_info = kwargs.get('ticket_info', None)
        self.condition = kwargs.get('condition', None)
        self.condition_version = kwargs.get('condition_version', None)
        self.created_on = None
        self.requestor_id = None
        self.expanded_properties = None


class RoleEligibilityScheduleRequestFilter(msrest.serialization.Model):
    """Role eligibility schedule request filter.

    :param principal_id: Returns role eligibility requests of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role eligibility requests of the specific role definition.
    :type role_definition_id: str
    :param requestor_id: Returns role eligibility requests created by specific principal.
    :type requestor_id: str
    :param status: Returns role eligibility requests of specific status.
    :type status: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'requestor_id': {'key': 'requestorId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestFilter, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.requestor_id = kwargs.get('requestor_id', None)
        self.status = kwargs.get('status', None)


class RoleEligibilityScheduleRequestListResult(msrest.serialization.Model):
    """Role eligibility schedule request list operation result.

    :param value: Role eligibility schedule request list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleRequest]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleEligibilityScheduleRequest]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RoleEligibilityScheduleRequestPropertiesScheduleInfo(msrest.serialization.Model):
    """Schedule info of the role eligibility schedule.

    :param start_date_time: Start DateTime of the role eligibility schedule.
    :type start_date_time: ~datetime.datetime
    :param expiration: Expiration of the role eligibility schedule.
    :type expiration:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration
    """

    _attribute_map = {
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'expiration': {'key': 'expiration', 'type': 'RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestPropertiesScheduleInfo, self).__init__(**kwargs)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.expiration = kwargs.get('expiration', None)


class RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration(msrest.serialization.Model):
    """Expiration of the role eligibility schedule.

    :param type: Type of the role eligibility schedule expiration. Possible values include:
     "AfterDuration", "AfterDateTime", "NoExpiration".
    :type type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Type
    :param end_date_time: End DateTime of the role eligibility schedule.
    :type end_date_time: ~datetime.datetime
    :param duration: Duration of the role eligibility schedule in TimeSpan.
    :type duration: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.duration = kwargs.get('duration', None)


class RoleEligibilityScheduleRequestPropertiesTicketInfo(msrest.serialization.Model):
    """Ticket Info of the role eligibility.

    :param ticket_number: Ticket number for the role eligibility.
    :type ticket_number: str
    :param ticket_system: Ticket system name for the role eligibility.
    :type ticket_system: str
    """

    _attribute_map = {
        'ticket_number': {'key': 'ticketNumber', 'type': 'str'},
        'ticket_system': {'key': 'ticketSystem', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestPropertiesTicketInfo, self).__init__(**kwargs)
        self.ticket_number = kwargs.get('ticket_number', None)
        self.ticket_system = kwargs.get('ticket_system', None)


class RoleManagementPolicy(msrest.serialization.Model):
    """Role management policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role management policy Id.
    :vartype id: str
    :ivar name: The role management policy name.
    :vartype name: str
    :ivar type: The role management policy type.
    :vartype type: str
    :param scope: The role management policy scope.
    :type scope: str
    :param display_name: The role management policy display name.
    :type display_name: str
    :param description: The role management policy description.
    :type description: str
    :param is_organization_default: The role management policy is default policy.
    :type is_organization_default: bool
    :ivar last_modified_by: The name of the entity last modified it.
    :vartype last_modified_by: ~azure.mgmt.authorization.v2020_10_01_preview.models.Principal
    :ivar last_modified_date_time: The last modified date time.
    :vartype last_modified_date_time: ~datetime.datetime
    :param rules: The rule applied to the policy.
    :type rules:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRule]
    :ivar effective_rules: The readonly computed rule applied to the policy.
    :vartype effective_rules:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRule]
    :ivar policy_properties: Additional properties of scope.
    :vartype policy_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'last_modified_date_time': {'readonly': True},
        'effective_rules': {'readonly': True},
        'policy_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_organization_default': {'key': 'properties.isOrganizationDefault', 'type': 'bool'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'Principal'},
        'last_modified_date_time': {'key': 'properties.lastModifiedDateTime', 'type': 'iso-8601'},
        'rules': {'key': 'properties.rules', 'type': '[RoleManagementPolicyRule]'},
        'effective_rules': {'key': 'properties.effectiveRules', 'type': '[RoleManagementPolicyRule]'},
        'policy_properties': {'key': 'properties.policyProperties', 'type': 'PolicyProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicy, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = kwargs.get('scope', None)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.is_organization_default = kwargs.get('is_organization_default', None)
        self.last_modified_by = None
        self.last_modified_date_time = None
        self.rules = kwargs.get('rules', None)
        self.effective_rules = None
        self.policy_properties = None


class RoleManagementPolicyRule(msrest.serialization.Model):
    """The role management policy rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RoleManagementPolicyApprovalRule, RoleManagementPolicyAuthenticationContextRule, RoleManagementPolicyEnablementRule, RoleManagementPolicyExpirationRule, RoleManagementPolicyNotificationRule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
    }

    _subtype_map = {
        'rule_type': {'RoleManagementPolicyApprovalRule': 'RoleManagementPolicyApprovalRule', 'RoleManagementPolicyAuthenticationContextRule': 'RoleManagementPolicyAuthenticationContextRule', 'RoleManagementPolicyEnablementRule': 'RoleManagementPolicyEnablementRule', 'RoleManagementPolicyExpirationRule': 'RoleManagementPolicyExpirationRule', 'RoleManagementPolicyNotificationRule': 'RoleManagementPolicyNotificationRule'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyRule, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.rule_type = None  # type: Optional[str]
        self.target = kwargs.get('target', None)


class RoleManagementPolicyApprovalRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param setting: The approval setting.
    :type setting: ~azure.mgmt.authorization.v2020_10_01_preview.models.ApprovalSettings
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'setting': {'key': 'setting', 'type': 'ApprovalSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyApprovalRule, self).__init__(**kwargs)
        self.rule_type = 'RoleManagementPolicyApprovalRule'  # type: str
        self.setting = kwargs.get('setting', None)


class RoleManagementPolicyAssignment(msrest.serialization.Model):
    """Role management policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role management policy Id.
    :vartype id: str
    :ivar name: The role management policy name.
    :vartype name: str
    :ivar type: The role management policy type.
    :vartype type: str
    :param scope: The role management policy scope.
    :type scope: str
    :param role_definition_id: The role definition of management policy assignment.
    :type role_definition_id: str
    :param policy_id: The policy id role management policy assignment.
    :type policy_id: str
    :ivar policy_assignment_properties: Additional properties of scope, role definition and policy.
    :vartype policy_assignment_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyAssignmentProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'policy_assignment_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'policy_id': {'key': 'properties.policyId', 'type': 'str'},
        'policy_assignment_properties': {'key': 'properties.policyAssignmentProperties', 'type': 'PolicyAssignmentProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyAssignment, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = kwargs.get('scope', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.policy_id = kwargs.get('policy_id', None)
        self.policy_assignment_properties = None


class RoleManagementPolicyAssignmentListResult(msrest.serialization.Model):
    """Role management policy assignment list operation result.

    :param value: Role management policy assignment list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyAssignment]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleManagementPolicyAssignment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyAssignmentListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RoleManagementPolicyAuthenticationContextRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param is_enabled: The value indicating if rule is enabled.
    :type is_enabled: bool
    :param claim_value: The claim value.
    :type claim_value: str
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'claim_value': {'key': 'claimValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyAuthenticationContextRule, self).__init__(**kwargs)
        self.rule_type = 'RoleManagementPolicyAuthenticationContextRule'  # type: str
        self.is_enabled = kwargs.get('is_enabled', None)
        self.claim_value = kwargs.get('claim_value', None)


class RoleManagementPolicyEnablementRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param enabled_rules: The list of enabled rules.
    :type enabled_rules: list[str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.EnablementRules]
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'enabled_rules': {'key': 'enabledRules', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyEnablementRule, self).__init__(**kwargs)
        self.rule_type = 'RoleManagementPolicyEnablementRule'  # type: str
        self.enabled_rules = kwargs.get('enabled_rules', None)


class RoleManagementPolicyExpirationRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param is_expiration_required: The value indicating whether expiration is required.
    :type is_expiration_required: bool
    :param maximum_duration: The maximum duration of expiration in timespan.
    :type maximum_duration: str
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'is_expiration_required': {'key': 'isExpirationRequired', 'type': 'bool'},
        'maximum_duration': {'key': 'maximumDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyExpirationRule, self).__init__(**kwargs)
        self.rule_type = 'RoleManagementPolicyExpirationRule'  # type: str
        self.is_expiration_required = kwargs.get('is_expiration_required', None)
        self.maximum_duration = kwargs.get('maximum_duration', None)


class RoleManagementPolicyListResult(msrest.serialization.Model):
    """Role management policy list operation result.

    :param value: Role management policy list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicy]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleManagementPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RoleManagementPolicyNotificationRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param notification_type: The type of notification. Possible values include: "Email".
    :type notification_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.NotificationDeliveryMechanism
    :param notification_level: The notification level. Possible values include: "None", "Critical",
     "All".
    :type notification_level: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.NotificationLevel
    :param recipient_type: The recipient type. Possible values include: "Requestor", "Approver",
     "Admin".
    :type recipient_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.RecipientType
    :param notification_recipients: The list notification recipients.
    :type notification_recipients: list[str]
    :param is_default_recipients_enabled: Its value determine if the notification need to be sent
     to the recipient type specified in policy rule.
    :type is_default_recipients_enabled: bool
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'notification_type': {'key': 'notificationType', 'type': 'str'},
        'notification_level': {'key': 'notificationLevel', 'type': 'str'},
        'recipient_type': {'key': 'recipientType', 'type': 'str'},
        'notification_recipients': {'key': 'notificationRecipients', 'type': '[str]'},
        'is_default_recipients_enabled': {'key': 'isDefaultRecipientsEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyNotificationRule, self).__init__(**kwargs)
        self.rule_type = 'RoleManagementPolicyNotificationRule'  # type: str
        self.notification_type = kwargs.get('notification_type', None)
        self.notification_level = kwargs.get('notification_level', None)
        self.recipient_type = kwargs.get('recipient_type', None)
        self.notification_recipients = kwargs.get('notification_recipients', None)
        self.is_default_recipients_enabled = kwargs.get('is_default_recipients_enabled', None)


class RoleManagementPolicyRuleTarget(msrest.serialization.Model):
    """The role management policy rule target.

    :param caller: The caller of the setting.
    :type caller: str
    :param operations: The type of operation.
    :type operations: list[str]
    :param level: The assignment level to which it is applied.
    :type level: str
    :param target_objects: The list of target objects.
    :type target_objects: list[str]
    :param inheritable_settings: The list of inheritable settings.
    :type inheritable_settings: list[str]
    :param enforced_settings: The list of enforced settings.
    :type enforced_settings: list[str]
    """

    _attribute_map = {
        'caller': {'key': 'caller', 'type': 'str'},
        'operations': {'key': 'operations', 'type': '[str]'},
        'level': {'key': 'level', 'type': 'str'},
        'target_objects': {'key': 'targetObjects', 'type': '[str]'},
        'inheritable_settings': {'key': 'inheritableSettings', 'type': '[str]'},
        'enforced_settings': {'key': 'enforcedSettings', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleManagementPolicyRuleTarget, self).__init__(**kwargs)
        self.caller = kwargs.get('caller', None)
        self.operations = kwargs.get('operations', None)
        self.level = kwargs.get('level', None)
        self.target_objects = kwargs.get('target_objects', None)
        self.inheritable_settings = kwargs.get('inheritable_settings', None)
        self.enforced_settings = kwargs.get('enforced_settings', None)


class UserSet(msrest.serialization.Model):
    """The detail of a user.

    :param user_type: The type of user. Possible values include: "User", "Group".
    :type user_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.UserType
    :param is_backup: The value indicating whether the user is a backup fallback approver.
    :type is_backup: bool
    :param id: The object id of the user.
    :type id: str
    :param description: The description of the user.
    :type description: str
    """

    _attribute_map = {
        'user_type': {'key': 'userType', 'type': 'str'},
        'is_backup': {'key': 'isBackup', 'type': 'bool'},
        'id': {'key': 'id', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserSet, self).__init__(**kwargs)
        self.user_type = kwargs.get('user_type', None)
        self.is_backup = kwargs.get('is_backup', None)
        self.id = kwargs.get('id', None)
        self.description = kwargs.get('description', None)


class ValidationResponse(msrest.serialization.Model):
    """Validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_valid: Whether or not validation succeeded.
    :vartype is_valid: bool
    :param error_info: Failed validation result details.
    :type error_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ValidationResponseErrorInfo
    """

    _validation = {
        'is_valid': {'readonly': True},
    }

    _attribute_map = {
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'error_info': {'key': 'errorInfo', 'type': 'ValidationResponseErrorInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationResponse, self).__init__(**kwargs)
        self.is_valid = None
        self.error_info = kwargs.get('error_info', None)


class ValidationResponseErrorInfo(msrest.serialization.Model):
    """Failed validation result details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code indicating why validation failed.
    :vartype code: str
    :ivar message: Message indicating why validation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationResponseErrorInfo, self).__init__(**kwargs)
        self.code = None
        self.message = None
