# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._stream_analytics_management_client_enums import *


class FunctionProperties(msrest.serialization.Model):
    """The properties that are associated with a function.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AggregateFunctionProperties, ScalarFunctionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of function.Constant filled by server.
    :type type: str
    :ivar etag: The current entity tag for the function. This is an opaque string. You can use it
     to detect whether the resource has changed between requests. You can also use it in the If-
     Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :param inputs:
    :type inputs: list[~stream_analytics_management_client.models.FunctionInput]
    :param output: Describes the output of a function.
    :type output: ~stream_analytics_management_client.models.FunctionOutput
    :param binding: The physical binding of the function. For example, in the Azure Machine
     Learning web service’s case, this describes the endpoint.
    :type binding: ~stream_analytics_management_client.models.FunctionBinding
    """

    _validation = {
        'type': {'required': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'inputs': {'key': 'properties.inputs', 'type': '[FunctionInput]'},
        'output': {'key': 'properties.output', 'type': 'FunctionOutput'},
        'binding': {'key': 'properties.binding', 'type': 'FunctionBinding'},
    }

    _subtype_map = {
        'type': {'Aggregate': 'AggregateFunctionProperties', 'Scalar': 'ScalarFunctionProperties'}
    }

    def __init__(
        self,
        *,
        inputs: Optional[List["FunctionInput"]] = None,
        output: Optional["FunctionOutput"] = None,
        binding: Optional["FunctionBinding"] = None,
        **kwargs
    ):
        super(FunctionProperties, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.etag = None
        self.inputs = inputs
        self.output = output
        self.binding = binding


class AggregateFunctionProperties(FunctionProperties):
    """The properties that are associated with an aggregate function.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of function.Constant filled by server.
    :type type: str
    :ivar etag: The current entity tag for the function. This is an opaque string. You can use it
     to detect whether the resource has changed between requests. You can also use it in the If-
     Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :param inputs:
    :type inputs: list[~stream_analytics_management_client.models.FunctionInput]
    :param output: Describes the output of a function.
    :type output: ~stream_analytics_management_client.models.FunctionOutput
    :param binding: The physical binding of the function. For example, in the Azure Machine
     Learning web service’s case, this describes the endpoint.
    :type binding: ~stream_analytics_management_client.models.FunctionBinding
    """

    _validation = {
        'type': {'required': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'inputs': {'key': 'properties.inputs', 'type': '[FunctionInput]'},
        'output': {'key': 'properties.output', 'type': 'FunctionOutput'},
        'binding': {'key': 'properties.binding', 'type': 'FunctionBinding'},
    }

    def __init__(
        self,
        *,
        inputs: Optional[List["FunctionInput"]] = None,
        output: Optional["FunctionOutput"] = None,
        binding: Optional["FunctionBinding"] = None,
        **kwargs
    ):
        super(AggregateFunctionProperties, self).__init__(inputs=inputs, output=output, binding=binding, **kwargs)
        self.type = 'Aggregate'  # type: str


class Serialization(msrest.serialization.Model):
    """Describes how data from an input is serialized or how data is serialized when written to an output.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroSerialization, CsvSerialization, CustomClrSerialization, JsonSerialization, ParquetSerialization.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of serialization that the input or output uses.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.  Possible values include:
     "Csv", "Avro", "Json", "CustomClr", "Parquet".
    :type type: str or ~stream_analytics_management_client.models.EventSerializationType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Avro': 'AvroSerialization', 'Csv': 'CsvSerialization', 'CustomClr': 'CustomClrSerialization', 'Json': 'JsonSerialization', 'Parquet': 'ParquetSerialization'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Serialization, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AvroSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in Avro format.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of serialization that the input or output uses.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.  Possible values include:
     "Csv", "Avro", "Json", "CustomClr", "Parquet".
    :type type: str or ~stream_analytics_management_client.models.EventSerializationType
    :param properties: The properties that are associated with the Avro serialization type.
     Required on PUT (CreateOrReplace) requests.
    :type properties: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(AvroSerialization, self).__init__(**kwargs)
        self.type = 'Avro'  # type: str
        self.properties = properties


class OutputDataSource(msrest.serialization.Model):
    """Describes the data source that output will be written to.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFunctionOutputDataSource, AzureDataLakeStoreOutputDataSource, EventHubV2OutputDataSource, EventHubOutputDataSource, ServiceBusQueueOutputDataSource, ServiceBusTopicOutputDataSource, AzureSynapseOutputDataSource, AzureSqlDatabaseOutputDataSource, BlobOutputDataSource, DocumentDbOutputDataSource, AzureTableOutputDataSource, PowerBIOutputDataSource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Microsoft.AzureFunction': 'AzureFunctionOutputDataSource', 'Microsoft.DataLake/Accounts': 'AzureDataLakeStoreOutputDataSource', 'Microsoft.EventHub/EventHub': 'EventHubV2OutputDataSource', 'Microsoft.ServiceBus/EventHub': 'EventHubOutputDataSource', 'Microsoft.ServiceBus/Queue': 'ServiceBusQueueOutputDataSource', 'Microsoft.ServiceBus/Topic': 'ServiceBusTopicOutputDataSource', 'Microsoft.Sql/Server/DataWarehouse': 'AzureSynapseOutputDataSource', 'Microsoft.Sql/Server/Database': 'AzureSqlDatabaseOutputDataSource', 'Microsoft.Storage/Blob': 'BlobOutputDataSource', 'Microsoft.Storage/DocumentDB': 'DocumentDbOutputDataSource', 'Microsoft.Storage/Table': 'AzureTableOutputDataSource', 'PowerBI': 'PowerBIOutputDataSource'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutputDataSource, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureDataLakeStoreOutputDataSource(OutputDataSource):
    """Describes an Azure Data Lake Store output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :type refresh_token: str
    :param token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :type token_user_principal_name: str
    :param token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :type token_user_display_name: str
    :param account_name: The name of the Azure Data Lake Store account. Required on PUT
     (CreateOrReplace) requests.
    :type account_name: str
    :param tenant_id: The tenant id of the user used to obtain the refresh token. Required on PUT
     (CreateOrReplace) requests.
    :type tenant_id: str
    :param file_path_prefix: The location of the file to which the output should be written to.
     Required on PUT (CreateOrReplace) requests.
    :type file_path_prefix: str
    :param date_format: The date format. Wherever {date} appears in filePathPrefix, the value of
     this property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in filePathPrefix, the value of
     this property is used as the time format instead.
    :type time_format: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'refresh_token': {'key': 'properties.refreshToken', 'type': 'str'},
        'token_user_principal_name': {'key': 'properties.tokenUserPrincipalName', 'type': 'str'},
        'token_user_display_name': {'key': 'properties.tokenUserDisplayName', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'file_path_prefix': {'key': 'properties.filePathPrefix', 'type': 'str'},
        'date_format': {'key': 'properties.dateFormat', 'type': 'str'},
        'time_format': {'key': 'properties.timeFormat', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        account_name: Optional[str] = None,
        tenant_id: Optional[str] = None,
        file_path_prefix: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.DataLake/Accounts'  # type: str
        self.refresh_token = refresh_token
        self.token_user_principal_name = token_user_principal_name
        self.token_user_display_name = token_user_display_name
        self.account_name = account_name
        self.tenant_id = tenant_id
        self.file_path_prefix = file_path_prefix
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode


class OAuthBasedDataSourceProperties(msrest.serialization.Model):
    """The properties that are associated with data sources that use OAuth as their authentication model.

    :param refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :type refresh_token: str
    :param token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :type token_user_principal_name: str
    :param token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :type token_user_display_name: str
    """

    _attribute_map = {
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'token_user_principal_name': {'key': 'tokenUserPrincipalName', 'type': 'str'},
        'token_user_display_name': {'key': 'tokenUserDisplayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        **kwargs
    ):
        super(OAuthBasedDataSourceProperties, self).__init__(**kwargs)
        self.refresh_token = refresh_token
        self.token_user_principal_name = token_user_principal_name
        self.token_user_display_name = token_user_display_name


class AzureDataLakeStoreOutputDataSourceProperties(OAuthBasedDataSourceProperties):
    """The properties that are associated with an Azure Data Lake Store.

    :param refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :type refresh_token: str
    :param token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :type token_user_principal_name: str
    :param token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :type token_user_display_name: str
    :param account_name: The name of the Azure Data Lake Store account. Required on PUT
     (CreateOrReplace) requests.
    :type account_name: str
    :param tenant_id: The tenant id of the user used to obtain the refresh token. Required on PUT
     (CreateOrReplace) requests.
    :type tenant_id: str
    :param file_path_prefix: The location of the file to which the output should be written to.
     Required on PUT (CreateOrReplace) requests.
    :type file_path_prefix: str
    :param date_format: The date format. Wherever {date} appears in filePathPrefix, the value of
     this property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in filePathPrefix, the value of
     this property is used as the time format instead.
    :type time_format: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _attribute_map = {
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'token_user_principal_name': {'key': 'tokenUserPrincipalName', 'type': 'str'},
        'token_user_display_name': {'key': 'tokenUserDisplayName', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'file_path_prefix': {'key': 'filePathPrefix', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'str'},
        'time_format': {'key': 'timeFormat', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        account_name: Optional[str] = None,
        tenant_id: Optional[str] = None,
        file_path_prefix: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(AzureDataLakeStoreOutputDataSourceProperties, self).__init__(refresh_token=refresh_token, token_user_principal_name=token_user_principal_name, token_user_display_name=token_user_display_name, **kwargs)
        self.account_name = account_name
        self.tenant_id = tenant_id
        self.file_path_prefix = file_path_prefix
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode


class AzureFunctionOutputDataSource(OutputDataSource):
    """Defines the metadata of AzureFunctionOutputDataSource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param function_app_name: The name of your Azure Functions app.
    :type function_app_name: str
    :param function_name: The name of the function in your Azure Functions app.
    :type function_name: str
    :param api_key: If you want to use an Azure Function from another subscription, you can do so
     by providing the key to access your function.
    :type api_key: str
    :param max_batch_size: A property that lets you set the maximum size for each output batch
     that's sent to your Azure function. The input unit is in bytes. By default, this value is
     262,144 bytes (256 KB).
    :type max_batch_size: float
    :param max_batch_count: A property that lets you specify the maximum number of events in each
     batch that's sent to Azure Functions. The default value is 100.
    :type max_batch_count: float
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'function_app_name': {'key': 'properties.functionAppName', 'type': 'str'},
        'function_name': {'key': 'properties.functionName', 'type': 'str'},
        'api_key': {'key': 'properties.apiKey', 'type': 'str'},
        'max_batch_size': {'key': 'properties.maxBatchSize', 'type': 'float'},
        'max_batch_count': {'key': 'properties.maxBatchCount', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        function_app_name: Optional[str] = None,
        function_name: Optional[str] = None,
        api_key: Optional[str] = None,
        max_batch_size: Optional[float] = None,
        max_batch_count: Optional[float] = None,
        **kwargs
    ):
        super(AzureFunctionOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.AzureFunction'  # type: str
        self.function_app_name = function_app_name
        self.function_name = function_name
        self.api_key = api_key
        self.max_batch_size = max_batch_size
        self.max_batch_count = max_batch_count


class FunctionBinding(msrest.serialization.Model):
    """The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureMachineLearningStudioFunctionBinding, AzureMachineLearningServiceFunctionBinding, CSharpFunctionBinding, JavaScriptFunctionBinding.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the function binding type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Microsoft.MachineLearning/WebService': 'AzureMachineLearningStudioFunctionBinding', 'Microsoft.MachineLearningServices': 'AzureMachineLearningServiceFunctionBinding', 'Microsoft.StreamAnalytics/CLRUdf': 'CSharpFunctionBinding', 'Microsoft.StreamAnalytics/JavascriptUdf': 'JavaScriptFunctionBinding'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionBinding, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureMachineLearningServiceFunctionBinding(FunctionBinding):
    """The binding to an Azure Machine Learning web service.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the function binding type.Constant filled by server.
    :type type: str
    :param endpoint: The Request-Response execute endpoint of the Azure Machine Learning web
     service.
    :type endpoint: str
    :param api_key: The API key used to authenticate with Request-Response endpoint.
    :type api_key: str
    :param inputs: The inputs for the Azure Machine Learning web service endpoint.
    :type inputs:
     list[~stream_analytics_management_client.models.AzureMachineLearningServiceInputColumn]
    :param outputs: A list of outputs from the Azure Machine Learning web service endpoint
     execution.
    :type outputs:
     list[~stream_analytics_management_client.models.AzureMachineLearningServiceOutputColumn]
    :param batch_size: Number between 1 and 10000 describing maximum number of rows for every Azure
     ML RRS execute request. Default is 1000.
    :type batch_size: int
    :param number_of_parallel_requests: The number of parallel requests that will be sent per
     partition of your job to the machine learning service. Default is 1.
    :type number_of_parallel_requests: int
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'api_key': {'key': 'properties.apiKey', 'type': 'str'},
        'inputs': {'key': 'properties.inputs', 'type': '[AzureMachineLearningServiceInputColumn]'},
        'outputs': {'key': 'properties.outputs', 'type': '[AzureMachineLearningServiceOutputColumn]'},
        'batch_size': {'key': 'properties.batchSize', 'type': 'int'},
        'number_of_parallel_requests': {'key': 'properties.numberOfParallelRequests', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        api_key: Optional[str] = None,
        inputs: Optional[List["AzureMachineLearningServiceInputColumn"]] = None,
        outputs: Optional[List["AzureMachineLearningServiceOutputColumn"]] = None,
        batch_size: Optional[int] = None,
        number_of_parallel_requests: Optional[int] = None,
        **kwargs
    ):
        super(AzureMachineLearningServiceFunctionBinding, self).__init__(**kwargs)
        self.type = 'Microsoft.MachineLearningServices'  # type: str
        self.endpoint = endpoint
        self.api_key = api_key
        self.inputs = inputs
        self.outputs = outputs
        self.batch_size = batch_size
        self.number_of_parallel_requests = number_of_parallel_requests


class FunctionRetrieveDefaultDefinitionParameters(msrest.serialization.Model):
    """Parameters used to specify the type of function to retrieve the default definition for.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters, AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters, CSharpFunctionRetrieveDefaultDefinitionParameters, JavaScriptFunctionRetrieveDefaultDefinitionParameters.

    All required parameters must be populated in order to send to Azure.

    :param binding_type: Required. Indicates the function binding type.Constant filled by server.
    :type binding_type: str
    """

    _validation = {
        'binding_type': {'required': True},
    }

    _attribute_map = {
        'binding_type': {'key': 'bindingType', 'type': 'str'},
    }

    _subtype_map = {
        'binding_type': {'Microsoft.MachineLearning/WebService': 'AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters', 'Microsoft.MachineLearningServices': 'AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters', 'Microsoft.StreamAnalytics/CLRUdf': 'CSharpFunctionRetrieveDefaultDefinitionParameters', 'Microsoft.StreamAnalytics/JavascriptUdf': 'JavaScriptFunctionRetrieveDefaultDefinitionParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionRetrieveDefaultDefinitionParameters, self).__init__(**kwargs)
        self.binding_type = None  # type: Optional[str]


class AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters(FunctionRetrieveDefaultDefinitionParameters):
    """The parameters needed to retrieve the default function definition for an Azure Machine Learning web service function.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param binding_type: Required. Indicates the function binding type.Constant filled by server.
    :type binding_type: str
    :param execute_endpoint: The Request-Response execute endpoint of the Azure Machine Learning
     web service.
    :type execute_endpoint: str
    :ivar udf_type: The function type. Default value: "Scalar".
    :vartype udf_type: str
    """

    _validation = {
        'binding_type': {'required': True},
        'udf_type': {'constant': True},
    }

    _attribute_map = {
        'binding_type': {'key': 'bindingType', 'type': 'str'},
        'execute_endpoint': {'key': 'bindingRetrievalProperties.executeEndpoint', 'type': 'str'},
        'udf_type': {'key': 'bindingRetrievalProperties.udfType', 'type': 'str'},
    }

    udf_type = "Scalar"

    def __init__(
        self,
        *,
        execute_endpoint: Optional[str] = None,
        **kwargs
    ):
        super(AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters, self).__init__(**kwargs)
        self.binding_type = 'Microsoft.MachineLearningServices'  # type: str
        self.execute_endpoint = execute_endpoint


class AzureMachineLearningServiceInputColumn(msrest.serialization.Model):
    """Describes an input column for the Azure Machine Learning web service endpoint.

    :param name: The name of the input column.
    :type name: str
    :param data_type: The (Azure Machine Learning supported) data type of the input column.
    :type data_type: str
    :param map_to: The zero based index of the function parameter this input maps to.
    :type map_to: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'map_to': {'key': 'mapTo', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        data_type: Optional[str] = None,
        map_to: Optional[int] = None,
        **kwargs
    ):
        super(AzureMachineLearningServiceInputColumn, self).__init__(**kwargs)
        self.name = name
        self.data_type = data_type
        self.map_to = map_to


class AzureMachineLearningServiceInputs(msrest.serialization.Model):
    """The inputs for the Azure Machine Learning web service endpoint.

    :param name: The name of the input. This is the name provided while authoring the endpoint.
    :type name: str
    :param column_names: A list of input columns for the Azure Machine Learning web service
     endpoint.
    :type column_names:
     list[~stream_analytics_management_client.models.AzureMachineLearningServiceInputColumn]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'column_names': {'key': 'columnNames', 'type': '[AzureMachineLearningServiceInputColumn]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        column_names: Optional[List["AzureMachineLearningServiceInputColumn"]] = None,
        **kwargs
    ):
        super(AzureMachineLearningServiceInputs, self).__init__(**kwargs)
        self.name = name
        self.column_names = column_names


class AzureMachineLearningServiceOutputColumn(msrest.serialization.Model):
    """Describes an output column for the Azure Machine Learning web service endpoint.

    :param name: The name of the output column.
    :type name: str
    :param data_type: The (Azure Machine Learning supported) data type of the output column.
    :type data_type: str
    :param map_to: The zero based index of the function parameter this input maps to.
    :type map_to: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'map_to': {'key': 'mapTo', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        data_type: Optional[str] = None,
        map_to: Optional[int] = None,
        **kwargs
    ):
        super(AzureMachineLearningServiceOutputColumn, self).__init__(**kwargs)
        self.name = name
        self.data_type = data_type
        self.map_to = map_to


class AzureMachineLearningStudioFunctionBinding(FunctionBinding):
    """The binding to an Azure Machine Learning Studio.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the function binding type.Constant filled by server.
    :type type: str
    :param endpoint: The Request-Response execute endpoint of the Azure Machine Learning Studio.
     Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-
     consume-web-services#request-response-service-rrs.
    :type endpoint: str
    :param api_key: The API key used to authenticate with Request-Response endpoint.
    :type api_key: str
    :param inputs: The inputs for the Azure Machine Learning Studio endpoint.
    :type inputs: ~stream_analytics_management_client.models.AzureMachineLearningStudioInputs
    :param outputs: A list of outputs from the Azure Machine Learning Studio endpoint execution.
    :type outputs:
     list[~stream_analytics_management_client.models.AzureMachineLearningStudioOutputColumn]
    :param batch_size: Number between 1 and 10000 describing maximum number of rows for every Azure
     ML RRS execute request. Default is 1000.
    :type batch_size: int
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'api_key': {'key': 'properties.apiKey', 'type': 'str'},
        'inputs': {'key': 'properties.inputs', 'type': 'AzureMachineLearningStudioInputs'},
        'outputs': {'key': 'properties.outputs', 'type': '[AzureMachineLearningStudioOutputColumn]'},
        'batch_size': {'key': 'properties.batchSize', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        api_key: Optional[str] = None,
        inputs: Optional["AzureMachineLearningStudioInputs"] = None,
        outputs: Optional[List["AzureMachineLearningStudioOutputColumn"]] = None,
        batch_size: Optional[int] = None,
        **kwargs
    ):
        super(AzureMachineLearningStudioFunctionBinding, self).__init__(**kwargs)
        self.type = 'Microsoft.MachineLearning/WebService'  # type: str
        self.endpoint = endpoint
        self.api_key = api_key
        self.inputs = inputs
        self.outputs = outputs
        self.batch_size = batch_size


class AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters(FunctionRetrieveDefaultDefinitionParameters):
    """The parameters needed to retrieve the default function definition for an Azure Machine Learning Studio function.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param binding_type: Required. Indicates the function binding type.Constant filled by server.
    :type binding_type: str
    :param execute_endpoint: The Request-Response execute endpoint of the Azure Machine Learning
     Studio. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-
     learning-consume-web-services#request-response-service-rrs.
    :type execute_endpoint: str
    :ivar udf_type: The function type. Default value: "Scalar".
    :vartype udf_type: str
    """

    _validation = {
        'binding_type': {'required': True},
        'udf_type': {'constant': True},
    }

    _attribute_map = {
        'binding_type': {'key': 'bindingType', 'type': 'str'},
        'execute_endpoint': {'key': 'bindingRetrievalProperties.executeEndpoint', 'type': 'str'},
        'udf_type': {'key': 'bindingRetrievalProperties.udfType', 'type': 'str'},
    }

    udf_type = "Scalar"

    def __init__(
        self,
        *,
        execute_endpoint: Optional[str] = None,
        **kwargs
    ):
        super(AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters, self).__init__(**kwargs)
        self.binding_type = 'Microsoft.MachineLearning/WebService'  # type: str
        self.execute_endpoint = execute_endpoint


class AzureMachineLearningStudioInputColumn(msrest.serialization.Model):
    """Describes an input column for the Azure Machine Learning Studio endpoint.

    :param name: The name of the input column.
    :type name: str
    :param data_type: The (Azure Machine Learning supported) data type of the input column. A list
     of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-
     us/library/azure/dn905923.aspx .
    :type data_type: str
    :param map_to: The zero based index of the function parameter this input maps to.
    :type map_to: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'map_to': {'key': 'mapTo', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        data_type: Optional[str] = None,
        map_to: Optional[int] = None,
        **kwargs
    ):
        super(AzureMachineLearningStudioInputColumn, self).__init__(**kwargs)
        self.name = name
        self.data_type = data_type
        self.map_to = map_to


class AzureMachineLearningStudioInputs(msrest.serialization.Model):
    """The inputs for the Azure Machine Learning Studio endpoint.

    :param name: The name of the input. This is the name provided while authoring the endpoint.
    :type name: str
    :param column_names: A list of input columns for the Azure Machine Learning Studio endpoint.
    :type column_names:
     list[~stream_analytics_management_client.models.AzureMachineLearningStudioInputColumn]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'column_names': {'key': 'columnNames', 'type': '[AzureMachineLearningStudioInputColumn]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        column_names: Optional[List["AzureMachineLearningStudioInputColumn"]] = None,
        **kwargs
    ):
        super(AzureMachineLearningStudioInputs, self).__init__(**kwargs)
        self.name = name
        self.column_names = column_names


class AzureMachineLearningStudioOutputColumn(msrest.serialization.Model):
    """Describes an output column for the Azure Machine Learning Studio endpoint.

    :param name: The name of the output column.
    :type name: str
    :param data_type: The (Azure Machine Learning supported) data type of the output column. A list
     of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-
     us/library/azure/dn905923.aspx .
    :type data_type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        data_type: Optional[str] = None,
        **kwargs
    ):
        super(AzureMachineLearningStudioOutputColumn, self).__init__(**kwargs)
        self.name = name
        self.data_type = data_type


class AzureSqlDatabaseDataSourceProperties(msrest.serialization.Model):
    """The properties that are associated with an Azure SQL database data source.

    :param server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type server: str
    :param database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :type database: str
    :param user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :type user: str
    :param password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :type password: str
    :param table: The name of the table in the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type table: str
    :param max_batch_count: Max Batch count for write to Sql database, the default value is 10,000.
     Optional on PUT requests.
    :type max_batch_count: float
    :param max_writer_count: Max Write r count, currently only 1(single writer) and 0(based on
     query partition) are available. Optional on PUT requests.
    :type max_writer_count: float
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _attribute_map = {
        'server': {'key': 'server', 'type': 'str'},
        'database': {'key': 'database', 'type': 'str'},
        'user': {'key': 'user', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'max_batch_count': {'key': 'maxBatchCount', 'type': 'float'},
        'max_writer_count': {'key': 'maxWriterCount', 'type': 'float'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        table: Optional[str] = None,
        max_batch_count: Optional[float] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(AzureSqlDatabaseDataSourceProperties, self).__init__(**kwargs)
        self.server = server
        self.database = database
        self.user = user
        self.password = password
        self.table = table
        self.max_batch_count = max_batch_count
        self.max_writer_count = max_writer_count
        self.authentication_mode = authentication_mode


class AzureSqlDatabaseOutputDataSource(OutputDataSource):
    """Describes an Azure SQL database output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type server: str
    :param database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :type database: str
    :param user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :type user: str
    :param password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :type password: str
    :param table: The name of the table in the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type table: str
    :param max_batch_count: Max Batch count for write to Sql database, the default value is 10,000.
     Optional on PUT requests.
    :type max_batch_count: float
    :param max_writer_count: Max Write r count, currently only 1(single writer) and 0(based on
     query partition) are available. Optional on PUT requests.
    :type max_writer_count: float
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'server': {'key': 'properties.server', 'type': 'str'},
        'database': {'key': 'properties.database', 'type': 'str'},
        'user': {'key': 'properties.user', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'table': {'key': 'properties.table', 'type': 'str'},
        'max_batch_count': {'key': 'properties.maxBatchCount', 'type': 'float'},
        'max_writer_count': {'key': 'properties.maxWriterCount', 'type': 'float'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        table: Optional[str] = None,
        max_batch_count: Optional[float] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(AzureSqlDatabaseOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Sql/Server/Database'  # type: str
        self.server = server
        self.database = database
        self.user = user
        self.password = password
        self.table = table
        self.max_batch_count = max_batch_count
        self.max_writer_count = max_writer_count
        self.authentication_mode = authentication_mode


class AzureSqlDatabaseOutputDataSourceProperties(AzureSqlDatabaseDataSourceProperties):
    """The properties that are associated with an Azure SQL database output.

    :param server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type server: str
    :param database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :type database: str
    :param user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :type user: str
    :param password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :type password: str
    :param table: The name of the table in the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type table: str
    :param max_batch_count: Max Batch count for write to Sql database, the default value is 10,000.
     Optional on PUT requests.
    :type max_batch_count: float
    :param max_writer_count: Max Write r count, currently only 1(single writer) and 0(based on
     query partition) are available. Optional on PUT requests.
    :type max_writer_count: float
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _attribute_map = {
        'server': {'key': 'server', 'type': 'str'},
        'database': {'key': 'database', 'type': 'str'},
        'user': {'key': 'user', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'max_batch_count': {'key': 'maxBatchCount', 'type': 'float'},
        'max_writer_count': {'key': 'maxWriterCount', 'type': 'float'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        table: Optional[str] = None,
        max_batch_count: Optional[float] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(AzureSqlDatabaseOutputDataSourceProperties, self).__init__(server=server, database=database, user=user, password=password, table=table, max_batch_count=max_batch_count, max_writer_count=max_writer_count, authentication_mode=authentication_mode, **kwargs)


class ReferenceInputDataSource(msrest.serialization.Model):
    """Describes an input data source that contains reference data.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureSqlReferenceInputDataSource, BlobReferenceInputDataSource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of input data source containing reference data.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Microsoft.Sql/Server/Database': 'AzureSqlReferenceInputDataSource', 'Microsoft.Storage/Blob': 'BlobReferenceInputDataSource'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReferenceInputDataSource, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureSqlReferenceInputDataSource(ReferenceInputDataSource):
    """Describes an Azure SQL database reference input data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of input data source containing reference data.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param properties:
    :type properties:
     ~stream_analytics_management_client.models.AzureSqlReferenceInputDataSourceProperties
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AzureSqlReferenceInputDataSourceProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AzureSqlReferenceInputDataSourceProperties"] = None,
        **kwargs
    ):
        super(AzureSqlReferenceInputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Sql/Server/Database'  # type: str
        self.properties = properties


class AzureSqlReferenceInputDataSourceProperties(msrest.serialization.Model):
    """AzureSqlReferenceInputDataSourceProperties.

    :param server: This element is associated with the datasource element. This is the name of the
     server that contains the database that will be written to.
    :type server: str
    :param database: This element is associated with the datasource element. This is the name of
     the database that output will be written to.
    :type database: str
    :param user: This element is associated with the datasource element. This is the user name that
     will be used to connect to the SQL Database instance.
    :type user: str
    :param password: This element is associated with the datasource element. This is the password
     that will be used to connect to the SQL Database instance.
    :type password: str
    :param table: This element is associated with the datasource element. The name of the table in
     the Azure SQL database..
    :type table: str
    :param refresh_type: This element is associated with the datasource element. This element is of
     enum type. It indicates what kind of data refresh option do we want to
     use:Static/RefreshPeriodicallyWithFull/RefreshPeriodicallyWithDelta.
    :type refresh_type: str
    :param refresh_rate: This element is associated with the datasource element. This indicates how
     frequently the data will be fetched from the database. It is of DateTime format.
    :type refresh_rate: str
    :param full_snapshot_query: This element is associated with the datasource element. This query
     is used to fetch data from the sql database.
    :type full_snapshot_query: str
    :param delta_snapshot_query: This element is associated with the datasource element. This query
     is used to fetch incremental changes from the SQL database. To use this option, we recommend
     using temporal tables in Azure SQL Database.
    :type delta_snapshot_query: str
    """

    _attribute_map = {
        'server': {'key': 'server', 'type': 'str'},
        'database': {'key': 'database', 'type': 'str'},
        'user': {'key': 'user', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'refresh_type': {'key': 'refreshType', 'type': 'str'},
        'refresh_rate': {'key': 'refreshRate', 'type': 'str'},
        'full_snapshot_query': {'key': 'fullSnapshotQuery', 'type': 'str'},
        'delta_snapshot_query': {'key': 'deltaSnapshotQuery', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        table: Optional[str] = None,
        refresh_type: Optional[str] = None,
        refresh_rate: Optional[str] = None,
        full_snapshot_query: Optional[str] = None,
        delta_snapshot_query: Optional[str] = None,
        **kwargs
    ):
        super(AzureSqlReferenceInputDataSourceProperties, self).__init__(**kwargs)
        self.server = server
        self.database = database
        self.user = user
        self.password = password
        self.table = table
        self.refresh_type = refresh_type
        self.refresh_rate = refresh_rate
        self.full_snapshot_query = full_snapshot_query
        self.delta_snapshot_query = delta_snapshot_query


class AzureSynapseDataSourceProperties(msrest.serialization.Model):
    """The properties that are associated with an Azure SQL database data source.

    :param server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type server: str
    :param database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :type database: str
    :param table: The name of the table in the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type table: str
    :param user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :type user: str
    :param password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :type password: str
    """

    _attribute_map = {
        'server': {'key': 'server', 'type': 'str'},
        'database': {'key': 'database', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'user': {'key': 'user', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(AzureSynapseDataSourceProperties, self).__init__(**kwargs)
        self.server = server
        self.database = database
        self.table = table
        self.user = user
        self.password = password


class AzureSynapseOutputDataSource(OutputDataSource):
    """Describes an Azure Synapse output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type server: str
    :param database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :type database: str
    :param table: The name of the table in the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type table: str
    :param user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :type user: str
    :param password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :type password: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'server': {'key': 'properties.server', 'type': 'str'},
        'database': {'key': 'properties.database', 'type': 'str'},
        'table': {'key': 'properties.table', 'type': 'str'},
        'user': {'key': 'properties.user', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(AzureSynapseOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Sql/Server/DataWarehouse'  # type: str
        self.server = server
        self.database = database
        self.table = table
        self.user = user
        self.password = password


class AzureSynapseOutputDataSourceProperties(AzureSynapseDataSourceProperties):
    """The properties that are associated with an Azure Synapse output.

    :param server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type server: str
    :param database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :type database: str
    :param table: The name of the table in the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :type table: str
    :param user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :type user: str
    :param password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :type password: str
    """

    _attribute_map = {
        'server': {'key': 'server', 'type': 'str'},
        'database': {'key': 'database', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'user': {'key': 'user', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(AzureSynapseOutputDataSourceProperties, self).__init__(server=server, database=database, table=table, user=user, password=password, **kwargs)


class AzureTableOutputDataSource(OutputDataSource):
    """Describes an Azure Table output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
     requests.
    :type account_name: str
    :param account_key: The account key for the Azure Storage account. Required on PUT
     (CreateOrReplace) requests.
    :type account_key: str
    :param table: The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
    :type table: str
    :param partition_key: This element indicates the name of a column from the SELECT statement in
     the query that will be used as the partition key for the Azure Table. Required on PUT
     (CreateOrReplace) requests.
    :type partition_key: str
    :param row_key: This element indicates the name of a column from the SELECT statement in the
     query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace)
     requests.
    :type row_key: str
    :param columns_to_remove: If specified, each item in the array is the name of a column to
     remove (if present) from output event entities.
    :type columns_to_remove: list[str]
    :param batch_size: The number of rows to write to the Azure Table at a time.
    :type batch_size: int
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'account_key': {'key': 'properties.accountKey', 'type': 'str'},
        'table': {'key': 'properties.table', 'type': 'str'},
        'partition_key': {'key': 'properties.partitionKey', 'type': 'str'},
        'row_key': {'key': 'properties.rowKey', 'type': 'str'},
        'columns_to_remove': {'key': 'properties.columnsToRemove', 'type': '[str]'},
        'batch_size': {'key': 'properties.batchSize', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        table: Optional[str] = None,
        partition_key: Optional[str] = None,
        row_key: Optional[str] = None,
        columns_to_remove: Optional[List[str]] = None,
        batch_size: Optional[int] = None,
        **kwargs
    ):
        super(AzureTableOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Storage/Table'  # type: str
        self.account_name = account_name
        self.account_key = account_key
        self.table = table
        self.partition_key = partition_key
        self.row_key = row_key
        self.columns_to_remove = columns_to_remove
        self.batch_size = batch_size


class BlobDataSourceProperties(msrest.serialization.Model):
    """The properties that are associated with a blob data source.

    :param storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :type storage_accounts: list[~stream_analytics_management_client.models.StorageAccount]
    :param container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :type container: str
    :param path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and
     example.
    :type path_pattern: str
    :param date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :type time_format: str
    """

    _attribute_map = {
        'storage_accounts': {'key': 'storageAccounts', 'type': '[StorageAccount]'},
        'container': {'key': 'container', 'type': 'str'},
        'path_pattern': {'key': 'pathPattern', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'str'},
        'time_format': {'key': 'timeFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        **kwargs
    ):
        super(BlobDataSourceProperties, self).__init__(**kwargs)
        self.storage_accounts = storage_accounts
        self.container = container
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format


class BlobOutputDataSource(OutputDataSource):
    """Describes a blob output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :type storage_accounts: list[~stream_analytics_management_client.models.StorageAccount]
    :param container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :type container: str
    :param path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and
     example.
    :type path_pattern: str
    :param date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :type time_format: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[StorageAccount]'},
        'container': {'key': 'properties.container', 'type': 'str'},
        'path_pattern': {'key': 'properties.pathPattern', 'type': 'str'},
        'date_format': {'key': 'properties.dateFormat', 'type': 'str'},
        'time_format': {'key': 'properties.timeFormat', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(BlobOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Storage/Blob'  # type: str
        self.storage_accounts = storage_accounts
        self.container = container
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode


class BlobOutputDataSourceProperties(BlobDataSourceProperties):
    """The properties that are associated with a blob output.

    :param storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :type storage_accounts: list[~stream_analytics_management_client.models.StorageAccount]
    :param container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :type container: str
    :param path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and
     example.
    :type path_pattern: str
    :param date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :type time_format: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _attribute_map = {
        'storage_accounts': {'key': 'storageAccounts', 'type': '[StorageAccount]'},
        'container': {'key': 'container', 'type': 'str'},
        'path_pattern': {'key': 'pathPattern', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'str'},
        'time_format': {'key': 'timeFormat', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(BlobOutputDataSourceProperties, self).__init__(storage_accounts=storage_accounts, container=container, path_pattern=path_pattern, date_format=date_format, time_format=time_format, **kwargs)
        self.authentication_mode = authentication_mode


class BlobReferenceInputDataSource(ReferenceInputDataSource):
    """Describes a blob input data source that contains reference data.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of input data source containing reference data.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :type storage_accounts: list[~stream_analytics_management_client.models.StorageAccount]
    :param container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :type container: str
    :param path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and
     example.
    :type path_pattern: str
    :param date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :type time_format: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[StorageAccount]'},
        'container': {'key': 'properties.container', 'type': 'str'},
        'path_pattern': {'key': 'properties.pathPattern', 'type': 'str'},
        'date_format': {'key': 'properties.dateFormat', 'type': 'str'},
        'time_format': {'key': 'properties.timeFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        **kwargs
    ):
        super(BlobReferenceInputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Storage/Blob'  # type: str
        self.storage_accounts = storage_accounts
        self.container = container
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format


class BlobReferenceInputDataSourceProperties(BlobDataSourceProperties):
    """The properties that are associated with a blob input containing reference data.

    :param storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :type storage_accounts: list[~stream_analytics_management_client.models.StorageAccount]
    :param container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :type container: str
    :param path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and
     example.
    :type path_pattern: str
    :param date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :type time_format: str
    """

    _attribute_map = {
        'storage_accounts': {'key': 'storageAccounts', 'type': '[StorageAccount]'},
        'container': {'key': 'container', 'type': 'str'},
        'path_pattern': {'key': 'pathPattern', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'str'},
        'time_format': {'key': 'timeFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        **kwargs
    ):
        super(BlobReferenceInputDataSourceProperties, self).__init__(storage_accounts=storage_accounts, container=container, path_pattern=path_pattern, date_format=date_format, time_format=time_format, **kwargs)


class StreamInputDataSource(msrest.serialization.Model):
    """Describes an input data source that contains stream data.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: IoTHubStreamInputDataSource, EventHubV2StreamInputDataSource, EventHubStreamInputDataSource, BlobStreamInputDataSource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of input data source containing stream data. Required
     on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Microsoft.Devices/IotHubs': 'IoTHubStreamInputDataSource', 'Microsoft.EventHub/EventHub': 'EventHubV2StreamInputDataSource', 'Microsoft.ServiceBus/EventHub': 'EventHubStreamInputDataSource', 'Microsoft.Storage/Blob': 'BlobStreamInputDataSource'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StreamInputDataSource, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class BlobStreamInputDataSource(StreamInputDataSource):
    """Describes a blob input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of input data source containing stream data. Required
     on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :type storage_accounts: list[~stream_analytics_management_client.models.StorageAccount]
    :param container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :type container: str
    :param path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and
     example.
    :type path_pattern: str
    :param date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :type time_format: str
    :param source_partition_count: The partition count of the blob input data source. Range 1 -
     256.
    :type source_partition_count: int
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[StorageAccount]'},
        'container': {'key': 'properties.container', 'type': 'str'},
        'path_pattern': {'key': 'properties.pathPattern', 'type': 'str'},
        'date_format': {'key': 'properties.dateFormat', 'type': 'str'},
        'time_format': {'key': 'properties.timeFormat', 'type': 'str'},
        'source_partition_count': {'key': 'properties.sourcePartitionCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        source_partition_count: Optional[int] = None,
        **kwargs
    ):
        super(BlobStreamInputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Storage/Blob'  # type: str
        self.storage_accounts = storage_accounts
        self.container = container
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format
        self.source_partition_count = source_partition_count


class BlobStreamInputDataSourceProperties(BlobDataSourceProperties):
    """The properties that are associated with a blob input containing stream data.

    :param storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :type storage_accounts: list[~stream_analytics_management_client.models.StorageAccount]
    :param container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :type container: str
    :param path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and
     example.
    :type path_pattern: str
    :param date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :type date_format: str
    :param time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :type time_format: str
    :param source_partition_count: The partition count of the blob input data source. Range 1 -
     256.
    :type source_partition_count: int
    """

    _attribute_map = {
        'storage_accounts': {'key': 'storageAccounts', 'type': '[StorageAccount]'},
        'container': {'key': 'container', 'type': 'str'},
        'path_pattern': {'key': 'pathPattern', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'str'},
        'time_format': {'key': 'timeFormat', 'type': 'str'},
        'source_partition_count': {'key': 'sourcePartitionCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        source_partition_count: Optional[int] = None,
        **kwargs
    ):
        super(BlobStreamInputDataSourceProperties, self).__init__(storage_accounts=storage_accounts, container=container, path_pattern=path_pattern, date_format=date_format, time_format=time_format, **kwargs)
        self.source_partition_count = source_partition_count


class Resource(msrest.serialization.Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Cluster(TrackedResource):
    """A Stream Analytics Cluster object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The geo-location where the resource lives.
    :type location: str
    :param sku: The SKU of the cluster. This determines the size/capacity of the cluster. Required
     on PUT (CreateOrUpdate) requests.
    :type sku: ~stream_analytics_management_client.models.ClusterSku
    :ivar etag: The current entity tag for the cluster. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :param properties: The properties associated with a Stream Analytics cluster.
    :type properties: ~stream_analytics_management_client.models.ClusterProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ClusterSku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ClusterProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        sku: Optional["ClusterSku"] = None,
        properties: Optional["ClusterProperties"] = None,
        **kwargs
    ):
        super(Cluster, self).__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.etag = None
        self.properties = properties


class ClusterInfo(msrest.serialization.Model):
    """The properties associated with a Stream Analytics cluster.

    :param id: The resource id of cluster.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ClusterInfo, self).__init__(**kwargs)
        self.id = id


class ClusterJob(msrest.serialization.Model):
    """A streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the streaming job.
    :vartype id: str
    :ivar streaming_units: The number of streaming units that are used by the streaming job.
    :vartype streaming_units: int
    :ivar job_state: The current execution state of the streaming job. Possible values include:
     "Created", "Starting", "Running", "Stopping", "Stopped", "Deleting", "Failed", "Degraded",
     "Restarting", "Scaling".
    :vartype job_state: str or ~stream_analytics_management_client.models.JobState
    """

    _validation = {
        'id': {'readonly': True},
        'streaming_units': {'readonly': True},
        'job_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'streaming_units': {'key': 'streamingUnits', 'type': 'int'},
        'job_state': {'key': 'jobState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterJob, self).__init__(**kwargs)
        self.id = None
        self.streaming_units = None
        self.job_state = None


class ClusterJobListResult(msrest.serialization.Model):
    """A list of streaming jobs. Populated by a List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of streaming jobs.
    :vartype value: list[~stream_analytics_management_client.models.ClusterJob]
    :ivar next_link: The URL to fetch the next set of streaming jobs.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ClusterJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterJobListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClusterListResult(msrest.serialization.Model):
    """A list of clusters populated by a 'list' operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of clusters.
    :vartype value: list[~stream_analytics_management_client.models.Cluster]
    :ivar next_link: The URL to fetch the next set of clusters.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Cluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClusterProperties(msrest.serialization.Model):
    """The properties associated with a Stream Analytics cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_date: The date this cluster was created.
    :vartype created_date: ~datetime.datetime
    :ivar cluster_id: Unique identifier for the cluster.
    :vartype cluster_id: str
    :ivar provisioning_state: The status of the cluster provisioning. The three terminal states
     are: Succeeded, Failed and Canceled. Possible values include: "Succeeded", "Failed",
     "Canceled", "InProgress".
    :vartype provisioning_state: str or
     ~stream_analytics_management_client.models.ClusterProvisioningState
    :ivar capacity_allocated: Represents the number of streaming units currently being used on the
     cluster.
    :vartype capacity_allocated: int
    :ivar capacity_assigned: Represents the sum of the SUs of all streaming jobs associated with
     the cluster. If all of the jobs were running, this would be the capacity allocated.
    :vartype capacity_assigned: int
    """

    _validation = {
        'created_date': {'readonly': True},
        'cluster_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'capacity_allocated': {'readonly': True},
        'capacity_assigned': {'readonly': True},
    }

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'cluster_id': {'key': 'clusterId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'capacity_allocated': {'key': 'capacityAllocated', 'type': 'int'},
        'capacity_assigned': {'key': 'capacityAssigned', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterProperties, self).__init__(**kwargs)
        self.created_date = None
        self.cluster_id = None
        self.provisioning_state = None
        self.capacity_allocated = None
        self.capacity_assigned = None


class ClusterSku(msrest.serialization.Model):
    """The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.

    :param name: Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
     Possible values include: "Default".
    :type name: str or ~stream_analytics_management_client.models.ClusterSkuName
    :param capacity: Denotes the number of streaming units the cluster can support. Valid values
     for this property are multiples of 36 with a minimum value of 36 and maximum value of 216.
     Required on PUT (CreateOrUpdate) requests.
    :type capacity: int
    """

    _validation = {
        'capacity': {'maximum': 216, 'minimum': 36},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "ClusterSkuName"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(ClusterSku, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class Compression(msrest.serialization.Model):
    """Describes how input data is compressed.

    All required parameters must be populated in order to send to Azure.

    :param type: Required.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: str,
        **kwargs
    ):
        super(Compression, self).__init__(**kwargs)
        self.type = type


class CSharpFunctionBinding(FunctionBinding):
    """The binding to a CSharp function.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the function binding type.Constant filled by server.
    :type type: str
    :param script: The Csharp code containing a single function definition.
    :type script: str
    :param dll_path: The Csharp code containing a single function definition.
    :type dll_path: str
    :param class_property: The Csharp code containing a single function definition.
    :type class_property: str
    :param method: The Csharp code containing a single function definition.
    :type method: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'script': {'key': 'properties.script', 'type': 'str'},
        'dll_path': {'key': 'properties.dllPath', 'type': 'str'},
        'class_property': {'key': 'properties.class', 'type': 'str'},
        'method': {'key': 'properties.method', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        script: Optional[str] = None,
        dll_path: Optional[str] = None,
        class_property: Optional[str] = None,
        method: Optional[str] = None,
        **kwargs
    ):
        super(CSharpFunctionBinding, self).__init__(**kwargs)
        self.type = 'Microsoft.StreamAnalytics/CLRUdf'  # type: str
        self.script = script
        self.dll_path = dll_path
        self.class_property = class_property
        self.method = method


class CSharpFunctionRetrieveDefaultDefinitionParameters(FunctionRetrieveDefaultDefinitionParameters):
    """The parameters needed to retrieve the default function definition for a CSharp function.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param binding_type: Required. Indicates the function binding type.Constant filled by server.
    :type binding_type: str
    :param script: The CSharp code containing a single function definition.
    :type script: str
    :ivar udf_type: The function type. Default value: "Scalar".
    :vartype udf_type: str
    """

    _validation = {
        'binding_type': {'required': True},
        'udf_type': {'constant': True},
    }

    _attribute_map = {
        'binding_type': {'key': 'bindingType', 'type': 'str'},
        'script': {'key': 'bindingRetrievalProperties.script', 'type': 'str'},
        'udf_type': {'key': 'bindingRetrievalProperties.udfType', 'type': 'str'},
    }

    udf_type = "Scalar"

    def __init__(
        self,
        *,
        script: Optional[str] = None,
        **kwargs
    ):
        super(CSharpFunctionRetrieveDefaultDefinitionParameters, self).__init__(**kwargs)
        self.binding_type = 'Microsoft.StreamAnalytics/CLRUdf'  # type: str
        self.script = script


class CsvSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in CSV format.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of serialization that the input or output uses.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.  Possible values include:
     "Csv", "Avro", "Json", "CustomClr", "Parquet".
    :type type: str or ~stream_analytics_management_client.models.EventSerializationType
    :param field_delimiter: Specifies the delimiter that will be used to separate comma-separated
     value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-
     analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-
     output for a list of supported values. Required on PUT (CreateOrReplace) requests.
    :type field_delimiter: str
    :param encoding: Specifies the encoding of the incoming data in the case of input and the
     encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     Possible values include: "UTF8".
    :type encoding: str or ~stream_analytics_management_client.models.Encoding
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_delimiter': {'key': 'properties.fieldDelimiter', 'type': 'str'},
        'encoding': {'key': 'properties.encoding', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        field_delimiter: Optional[str] = None,
        encoding: Optional[Union[str, "Encoding"]] = None,
        **kwargs
    ):
        super(CsvSerialization, self).__init__(**kwargs)
        self.type = 'Csv'  # type: str
        self.field_delimiter = field_delimiter
        self.encoding = encoding


class CustomClrSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in custom format.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of serialization that the input or output uses.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.  Possible values include:
     "Csv", "Avro", "Json", "CustomClr", "Parquet".
    :type type: str or ~stream_analytics_management_client.models.EventSerializationType
    :param serialization_dll_path: The serialization library path.
    :type serialization_dll_path: str
    :param serialization_class_name: The serialization class name.
    :type serialization_class_name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'serialization_dll_path': {'key': 'properties.serializationDllPath', 'type': 'str'},
        'serialization_class_name': {'key': 'properties.serializationClassName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        serialization_dll_path: Optional[str] = None,
        serialization_class_name: Optional[str] = None,
        **kwargs
    ):
        super(CustomClrSerialization, self).__init__(**kwargs)
        self.type = 'CustomClr'  # type: str
        self.serialization_dll_path = serialization_dll_path
        self.serialization_class_name = serialization_class_name


class DiagnosticCondition(msrest.serialization.Model):
    """Condition applicable to the resource, or to the job overall, that warrant customer attention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar since: The UTC timestamp of when the condition started. Customers should be able to find
     a corresponding event in the ops log around this time.
    :vartype since: str
    :ivar code: The opaque diagnostic code.
    :vartype code: str
    :ivar message: The human-readable message describing the condition in detail. Localized in the
     Accept-Language of the client request.
    :vartype message: str
    """

    _validation = {
        'since': {'readonly': True},
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'since': {'key': 'since', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticCondition, self).__init__(**kwargs)
        self.since = None
        self.code = None
        self.message = None


class Diagnostics(msrest.serialization.Model):
    """Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar conditions: A collection of zero or more conditions applicable to the resource, or to the
     job overall, that warrant customer attention.
    :vartype conditions: list[~stream_analytics_management_client.models.DiagnosticCondition]
    """

    _validation = {
        'conditions': {'readonly': True},
    }

    _attribute_map = {
        'conditions': {'key': 'conditions', 'type': '[DiagnosticCondition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Diagnostics, self).__init__(**kwargs)
        self.conditions = None


class DocumentDbOutputDataSource(OutputDataSource):
    """Describes a DocumentDB output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param account_id: The DocumentDB account name or ID. Required on PUT (CreateOrReplace)
     requests.
    :type account_id: str
    :param account_key: The account key for the DocumentDB account. Required on PUT
     (CreateOrReplace) requests.
    :type account_key: str
    :param database: The name of the DocumentDB database. Required on PUT (CreateOrReplace)
     requests.
    :type database: str
    :param collection_name_pattern: The collection name pattern for the collections to be used. The
     collection name format can be constructed using the optional {partition} token, where
     partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-
     us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT
     (CreateOrReplace) requests.
    :type collection_name_pattern: str
    :param partition_key: The name of the field in output events used to specify the key for
     partitioning output across collections. If 'collectionNamePattern' contains the {partition}
     token, this property is required to be specified.
    :type partition_key: str
    :param document_id: The name of the field in output events used to specify the primary key
     which insert or update operations are based on.
    :type document_id: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_id': {'key': 'properties.accountId', 'type': 'str'},
        'account_key': {'key': 'properties.accountKey', 'type': 'str'},
        'database': {'key': 'properties.database', 'type': 'str'},
        'collection_name_pattern': {'key': 'properties.collectionNamePattern', 'type': 'str'},
        'partition_key': {'key': 'properties.partitionKey', 'type': 'str'},
        'document_id': {'key': 'properties.documentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_id: Optional[str] = None,
        account_key: Optional[str] = None,
        database: Optional[str] = None,
        collection_name_pattern: Optional[str] = None,
        partition_key: Optional[str] = None,
        document_id: Optional[str] = None,
        **kwargs
    ):
        super(DocumentDbOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Storage/DocumentDB'  # type: str
        self.account_id = account_id
        self.account_key = account_key
        self.database = database
        self.collection_name_pattern = collection_name_pattern
        self.partition_key = partition_key
        self.document_id = document_id


class Error(msrest.serialization.Model):
    """Common error representation.

    :param error: Error definition properties.
    :type error: ~stream_analytics_management_client.models.ErrorAutoGenerated
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorAutoGenerated'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorAutoGenerated"] = None,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.error = error


class ErrorAutoGenerated(msrest.serialization.Model):
    """Error definition properties.

    :param code: Error code.
    :type code: str
    :param message: Error message.
    :type message: str
    :param target: Error target.
    :type target: str
    :param details: Error details.
    :type details: list[~stream_analytics_management_client.models.ErrorDetails]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["ErrorDetails"]] = None,
        **kwargs
    ):
        super(ErrorAutoGenerated, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ErrorDetails(msrest.serialization.Model):
    """Common error details representation.

    :param code: Error code.
    :type code: str
    :param target: Error target.
    :type target: str
    :param message: Error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ErrorResponse(msrest.serialization.Model):
    """Describes the error that occurred.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code associated with the error that occurred.
    :vartype code: str
    :ivar message: Describes the error in detail.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None


class ServiceBusDataSourceProperties(msrest.serialization.Model):
    """The common properties that are associated with Service Bus data sources (Queues, Topics, Event Hubs, etc.).

    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _attribute_map = {
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(ServiceBusDataSourceProperties, self).__init__(**kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode


class EventHubDataSourceProperties(ServiceBusDataSourceProperties):
    """The common properties that are associated with Event Hub data sources.

    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :type event_hub_name: str
    """

    _attribute_map = {
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'event_hub_name': {'key': 'eventHubName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        event_hub_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubDataSourceProperties, self).__init__(service_bus_namespace=service_bus_namespace, shared_access_policy_name=shared_access_policy_name, shared_access_policy_key=shared_access_policy_key, authentication_mode=authentication_mode, **kwargs)
        self.event_hub_name = event_hub_name


class EventHubOutputDataSource(OutputDataSource):
    """Describes an Event Hub output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :type event_hub_name: str
    :param partition_key: The key/column that is used to determine to which partition to send event
     data.
    :type partition_key: str
    :param property_columns:
    :type property_columns: list[str]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'properties.sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'partition_key': {'key': 'properties.partitionKey', 'type': 'str'},
        'property_columns': {'key': 'properties.propertyColumns', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        event_hub_name: Optional[str] = None,
        partition_key: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        **kwargs
    ):
        super(EventHubOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.ServiceBus/EventHub'  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.event_hub_name = event_hub_name
        self.partition_key = partition_key
        self.property_columns = property_columns


class EventHubOutputDataSourceProperties(EventHubDataSourceProperties):
    """The properties that are associated with an Event Hub output.

    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :type event_hub_name: str
    :param partition_key: The key/column that is used to determine to which partition to send event
     data.
    :type partition_key: str
    :param property_columns:
    :type property_columns: list[str]
    """

    _attribute_map = {
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'event_hub_name': {'key': 'eventHubName', 'type': 'str'},
        'partition_key': {'key': 'partitionKey', 'type': 'str'},
        'property_columns': {'key': 'propertyColumns', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        event_hub_name: Optional[str] = None,
        partition_key: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        **kwargs
    ):
        super(EventHubOutputDataSourceProperties, self).__init__(service_bus_namespace=service_bus_namespace, shared_access_policy_name=shared_access_policy_name, shared_access_policy_key=shared_access_policy_key, authentication_mode=authentication_mode, event_hub_name=event_hub_name, **kwargs)
        self.partition_key = partition_key
        self.property_columns = property_columns


class EventHubStreamInputDataSource(StreamInputDataSource):
    """Describes an Event Hub input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of input data source containing stream data. Required
     on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :type event_hub_name: str
    :param consumer_group_name: The name of an Event Hub Consumer Group that should be used to read
     events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows
     each of those inputs to receive the same events from the Event Hub. If not specified, the input
     uses the Event Hub’s default consumer group.
    :type consumer_group_name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'properties.sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'properties.consumerGroupName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        event_hub_name: Optional[str] = None,
        consumer_group_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubStreamInputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.ServiceBus/EventHub'  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.event_hub_name = event_hub_name
        self.consumer_group_name = consumer_group_name


class EventHubStreamInputDataSourceProperties(EventHubDataSourceProperties):
    """The properties that are associated with a Event Hub input containing stream data.

    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :type event_hub_name: str
    :param consumer_group_name: The name of an Event Hub Consumer Group that should be used to read
     events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows
     each of those inputs to receive the same events from the Event Hub. If not specified, the input
     uses the Event Hub’s default consumer group.
    :type consumer_group_name: str
    """

    _attribute_map = {
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'event_hub_name': {'key': 'eventHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'consumerGroupName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        event_hub_name: Optional[str] = None,
        consumer_group_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubStreamInputDataSourceProperties, self).__init__(service_bus_namespace=service_bus_namespace, shared_access_policy_name=shared_access_policy_name, shared_access_policy_key=shared_access_policy_key, authentication_mode=authentication_mode, event_hub_name=event_hub_name, **kwargs)
        self.consumer_group_name = consumer_group_name


class EventHubV2OutputDataSource(OutputDataSource):
    """Describes an Event Hub output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :type event_hub_name: str
    :param partition_key: The key/column that is used to determine to which partition to send event
     data.
    :type partition_key: str
    :param property_columns:
    :type property_columns: list[str]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'properties.sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'partition_key': {'key': 'properties.partitionKey', 'type': 'str'},
        'property_columns': {'key': 'properties.propertyColumns', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        event_hub_name: Optional[str] = None,
        partition_key: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        **kwargs
    ):
        super(EventHubV2OutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.EventHub/EventHub'  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.event_hub_name = event_hub_name
        self.partition_key = partition_key
        self.property_columns = property_columns


class EventHubV2StreamInputDataSource(StreamInputDataSource):
    """Describes an Event Hub input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of input data source containing stream data. Required
     on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :type event_hub_name: str
    :param consumer_group_name: The name of an Event Hub Consumer Group that should be used to read
     events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows
     each of those inputs to receive the same events from the Event Hub. If not specified, the input
     uses the Event Hub’s default consumer group.
    :type consumer_group_name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'properties.sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'consumer_group_name': {'key': 'properties.consumerGroupName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        event_hub_name: Optional[str] = None,
        consumer_group_name: Optional[str] = None,
        **kwargs
    ):
        super(EventHubV2StreamInputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.EventHub/EventHub'  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.event_hub_name = event_hub_name
        self.consumer_group_name = consumer_group_name


class External(msrest.serialization.Model):
    """The storage account where the custom code artifacts are located.

    :param storage_account: The properties that are associated with an Azure Storage account.
    :type storage_account: ~stream_analytics_management_client.models.StorageAccount
    :param container:
    :type container: str
    :param path:
    :type path: str
    """

    _attribute_map = {
        'storage_account': {'key': 'storageAccount', 'type': 'StorageAccount'},
        'container': {'key': 'container', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account: Optional["StorageAccount"] = None,
        container: Optional[str] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        super(External, self).__init__(**kwargs)
        self.storage_account = storage_account
        self.container = container
        self.path = path


class SubResource(msrest.serialization.Model):
    """The base sub-resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = None


class Function(SubResource):
    """A function object, containing all information associated with the named function. All functions are contained under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: The properties that are associated with a function.
    :type properties: ~stream_analytics_management_client.models.FunctionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'FunctionProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["FunctionProperties"] = None,
        **kwargs
    ):
        super(Function, self).__init__(name=name, **kwargs)
        self.properties = properties


class FunctionInput(msrest.serialization.Model):
    """Describes one input parameter of a function.

    :param data_type: The (Azure Stream Analytics supported) data type of the function input
     parameter. A list of valid Azure Stream Analytics data types are described at
     https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx.
    :type data_type: str
    :param is_configuration_parameter: A flag indicating if the parameter is a configuration
     parameter. True if this input parameter is expected to be a constant. Default is false.
    :type is_configuration_parameter: bool
    """

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
        'is_configuration_parameter': {'key': 'isConfigurationParameter', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        data_type: Optional[str] = None,
        is_configuration_parameter: Optional[bool] = None,
        **kwargs
    ):
        super(FunctionInput, self).__init__(**kwargs)
        self.data_type = data_type
        self.is_configuration_parameter = is_configuration_parameter


class FunctionListResult(msrest.serialization.Model):
    """Object containing a list of functions under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of functions under a streaming job. Populated by a 'List' operation.
    :vartype value: list[~stream_analytics_management_client.models.Function]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Function]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class FunctionOutput(msrest.serialization.Model):
    """Describes the output of a function.

    :param data_type: The (Azure Stream Analytics supported) data type of the function output. A
     list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-
     us/library/azure/dn835065.aspx.
    :type data_type: str
    """

    _attribute_map = {
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_type: Optional[str] = None,
        **kwargs
    ):
        super(FunctionOutput, self).__init__(**kwargs)
        self.data_type = data_type


class Identity(msrest.serialization.Model):
    """Describes how identity is verified.

    :param tenant_id:
    :type tenant_id: str
    :param principal_id:
    :type principal_id: str
    :param type:
    :type type: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.principal_id = principal_id
        self.type = type


class Input(SubResource):
    """An input object, containing all information associated with the named input. All inputs are contained under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: The properties that are associated with an input. Required on PUT
     (CreateOrReplace) requests.
    :type properties: ~stream_analytics_management_client.models.InputProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'InputProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["InputProperties"] = None,
        **kwargs
    ):
        super(Input, self).__init__(name=name, **kwargs)
        self.properties = properties


class InputListResult(msrest.serialization.Model):
    """Object containing a list of inputs under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of inputs under a streaming job. Populated by a 'List' operation.
    :vartype value: list[~stream_analytics_management_client.models.Input]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Input]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InputListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class InputProperties(msrest.serialization.Model):
    """The properties that are associated with an input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ReferenceInputProperties, StreamInputProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates whether the input is a source of reference data or stream
     data. Required on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param serialization: Describes how data from an input is serialized or how data is serialized
     when written to an output. Required on PUT (CreateOrReplace) requests.
    :type serialization: ~stream_analytics_management_client.models.Serialization
    :ivar diagnostics: Describes conditions applicable to the Input, Output, or the job overall,
     that warrant customer attention.
    :vartype diagnostics: ~stream_analytics_management_client.models.Diagnostics
    :ivar etag: The current entity tag for the input. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :param compression: Describes how input data is compressed.
    :type compression: ~stream_analytics_management_client.models.Compression
    :param partition_key: partitionKey Describes a key in the input data which is used for
     partitioning the input data.
    :type partition_key: str
    """

    _validation = {
        'type': {'required': True},
        'diagnostics': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'serialization': {'key': 'serialization', 'type': 'Serialization'},
        'diagnostics': {'key': 'diagnostics', 'type': 'Diagnostics'},
        'etag': {'key': 'etag', 'type': 'str'},
        'compression': {'key': 'compression', 'type': 'Compression'},
        'partition_key': {'key': 'partitionKey', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Reference': 'ReferenceInputProperties', 'Stream': 'StreamInputProperties'}
    }

    def __init__(
        self,
        *,
        serialization: Optional["Serialization"] = None,
        compression: Optional["Compression"] = None,
        partition_key: Optional[str] = None,
        **kwargs
    ):
        super(InputProperties, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.serialization = serialization
        self.diagnostics = None
        self.etag = None
        self.compression = compression
        self.partition_key = partition_key


class IoTHubStreamInputDataSource(StreamInputDataSource):
    """Describes an IoT Hub input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of input data source containing stream data. Required
     on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param iot_hub_namespace: The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace)
     requests.
    :type iot_hub_namespace: str
    :param shared_access_policy_name: The shared access policy name for the IoT Hub. This policy
     must contain at least the Service connect permission. Required on PUT (CreateOrReplace)
     requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param consumer_group_name: The name of an IoT Hub Consumer Group that should be used to read
     events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
    :type consumer_group_name: str
    :param endpoint: The IoT Hub endpoint to connect to (ie. messages/events,
     messages/operationsMonitoringEvents, etc.).
    :type endpoint: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'iot_hub_namespace': {'key': 'properties.iotHubNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'properties.sharedAccessPolicyKey', 'type': 'str'},
        'consumer_group_name': {'key': 'properties.consumerGroupName', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        iot_hub_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        consumer_group_name: Optional[str] = None,
        endpoint: Optional[str] = None,
        **kwargs
    ):
        super(IoTHubStreamInputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.Devices/IotHubs'  # type: str
        self.iot_hub_namespace = iot_hub_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.consumer_group_name = consumer_group_name
        self.endpoint = endpoint


class JavaScriptFunctionBinding(FunctionBinding):
    """The binding to a JavaScript function.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the function binding type.Constant filled by server.
    :type type: str
    :param script: The JavaScript code containing a single function definition. For example:
     'function (x, y) { return x + y; }'.
    :type script: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'script': {'key': 'properties.script', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        script: Optional[str] = None,
        **kwargs
    ):
        super(JavaScriptFunctionBinding, self).__init__(**kwargs)
        self.type = 'Microsoft.StreamAnalytics/JavascriptUdf'  # type: str
        self.script = script


class JavaScriptFunctionRetrieveDefaultDefinitionParameters(FunctionRetrieveDefaultDefinitionParameters):
    """The parameters needed to retrieve the default function definition for a JavaScript function.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param binding_type: Required. Indicates the function binding type.Constant filled by server.
    :type binding_type: str
    :param script: The JavaScript code containing a single function definition. For example:
     'function (x, y) { return x + y; }'.
    :type script: str
    :ivar udf_type: The function type. Default value: "Scalar".
    :vartype udf_type: str
    """

    _validation = {
        'binding_type': {'required': True},
        'udf_type': {'constant': True},
    }

    _attribute_map = {
        'binding_type': {'key': 'bindingType', 'type': 'str'},
        'script': {'key': 'bindingRetrievalProperties.script', 'type': 'str'},
        'udf_type': {'key': 'bindingRetrievalProperties.udfType', 'type': 'str'},
    }

    udf_type = "Scalar"

    def __init__(
        self,
        *,
        script: Optional[str] = None,
        **kwargs
    ):
        super(JavaScriptFunctionRetrieveDefaultDefinitionParameters, self).__init__(**kwargs)
        self.binding_type = 'Microsoft.StreamAnalytics/JavascriptUdf'  # type: str
        self.script = script


class StorageAccount(msrest.serialization.Model):
    """The properties that are associated with an Azure Storage account.

    :param account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
     requests.
    :type account_name: str
    :param account_key: The account key for the Azure Storage account. Required on PUT
     (CreateOrReplace) requests.
    :type account_key: str
    """

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        **kwargs
    ):
        super(StorageAccount, self).__init__(**kwargs)
        self.account_name = account_name
        self.account_key = account_key


class JobStorageAccount(StorageAccount):
    """The properties that are associated with an Azure Storage account with MSI.

    :param account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
     requests.
    :type account_name: str
    :param account_key: The account key for the Azure Storage account. Required on PUT
     (CreateOrReplace) requests.
    :type account_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(JobStorageAccount, self).__init__(account_name=account_name, account_key=account_key, **kwargs)
        self.authentication_mode = authentication_mode


class JsonSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in JSON format.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of serialization that the input or output uses.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.  Possible values include:
     "Csv", "Avro", "Json", "CustomClr", "Parquet".
    :type type: str or ~stream_analytics_management_client.models.EventSerializationType
    :param encoding: Specifies the encoding of the incoming data in the case of input and the
     encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     Possible values include: "UTF8".
    :type encoding: str or ~stream_analytics_management_client.models.Encoding
    :param format: This property only applies to JSON serialization of outputs only. It is not
     applicable to inputs. This property specifies the format of the JSON the output will be written
     in. The currently supported values are 'lineSeparated' indicating the output will be formatted
     by having each JSON object separated by a new line and 'array' indicating the output will be
     formatted as an array of JSON objects. Default value is 'lineSeparated' if left null. Possible
     values include: "LineSeparated", "Array".
    :type format: str or ~stream_analytics_management_client.models.JsonOutputSerializationFormat
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'encoding': {'key': 'properties.encoding', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        encoding: Optional[Union[str, "Encoding"]] = None,
        format: Optional[Union[str, "JsonOutputSerializationFormat"]] = None,
        **kwargs
    ):
        super(JsonSerialization, self).__init__(**kwargs)
        self.type = 'Json'  # type: str
        self.encoding = encoding
        self.format = format


class Operation(msrest.serialization.Model):
    """A Stream Analytics REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: Contains the localized display information for this particular operation /
     action.
    :vartype display: ~stream_analytics_management_client.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None


class OperationDisplay(msrest.serialization.Model):
    """Contains the localized display information for this particular operation / action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Stream Analytics operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Stream Analytics operations supported by the Microsoft.StreamAnalytics
     resource provider.
    :vartype value: list[~stream_analytics_management_client.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Output(SubResource):
    """An output object, containing all information associated with the named output. All outputs are contained under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param datasource: Describes the data source that output will be written to. Required on PUT
     (CreateOrReplace) requests.
    :type datasource: ~stream_analytics_management_client.models.OutputDataSource
    :param time_window:
    :type time_window: str
    :param size_window:
    :type size_window: float
    :param serialization: Describes how data from an input is serialized or how data is serialized
     when written to an output. Required on PUT (CreateOrReplace) requests.
    :type serialization: ~stream_analytics_management_client.models.Serialization
    :ivar diagnostics: Describes conditions applicable to the Input, Output, or the job overall,
     that warrant customer attention.
    :vartype diagnostics: ~stream_analytics_management_client.models.Diagnostics
    :ivar etag: The current entity tag for the output. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'diagnostics': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'datasource': {'key': 'properties.datasource', 'type': 'OutputDataSource'},
        'time_window': {'key': 'properties.timeWindow', 'type': 'str'},
        'size_window': {'key': 'properties.sizeWindow', 'type': 'float'},
        'serialization': {'key': 'properties.serialization', 'type': 'Serialization'},
        'diagnostics': {'key': 'properties.diagnostics', 'type': 'Diagnostics'},
        'etag': {'key': 'properties.etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        datasource: Optional["OutputDataSource"] = None,
        time_window: Optional[str] = None,
        size_window: Optional[float] = None,
        serialization: Optional["Serialization"] = None,
        **kwargs
    ):
        super(Output, self).__init__(name=name, **kwargs)
        self.datasource = datasource
        self.time_window = time_window
        self.size_window = size_window
        self.serialization = serialization
        self.diagnostics = None
        self.etag = None


class OutputListResult(msrest.serialization.Model):
    """Object containing a list of outputs under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of outputs under a streaming job. Populated by a 'List' operation.
    :vartype value: list[~stream_analytics_management_client.models.Output]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Output]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutputListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ParquetSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in Parquet format.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of serialization that the input or output uses.
     Required on PUT (CreateOrReplace) requests.Constant filled by server.  Possible values include:
     "Csv", "Avro", "Json", "CustomClr", "Parquet".
    :type type: str or ~stream_analytics_management_client.models.EventSerializationType
    :param properties: The properties that are associated with the Parquet serialization type.
     Required on PUT (CreateOrReplace) requests.
    :type properties: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(ParquetSerialization, self).__init__(**kwargs)
        self.type = 'Parquet'  # type: str
        self.properties = properties


class PowerBIOutputDataSource(OutputDataSource):
    """Describes a Power BI output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :type refresh_token: str
    :param token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :type token_user_principal_name: str
    :param token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :type token_user_display_name: str
    :param dataset: The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
    :type dataset: str
    :param table: The name of the Power BI table under the specified dataset. Required on PUT
     (CreateOrReplace) requests.
    :type table: str
    :param group_id: The ID of the Power BI group.
    :type group_id: str
    :param group_name: The name of the Power BI group. Use this property to help remember which
     specific Power BI group id was used.
    :type group_name: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'refresh_token': {'key': 'properties.refreshToken', 'type': 'str'},
        'token_user_principal_name': {'key': 'properties.tokenUserPrincipalName', 'type': 'str'},
        'token_user_display_name': {'key': 'properties.tokenUserDisplayName', 'type': 'str'},
        'dataset': {'key': 'properties.dataset', 'type': 'str'},
        'table': {'key': 'properties.table', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'group_name': {'key': 'properties.groupName', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        dataset: Optional[str] = None,
        table: Optional[str] = None,
        group_id: Optional[str] = None,
        group_name: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(PowerBIOutputDataSource, self).__init__(**kwargs)
        self.type = 'PowerBI'  # type: str
        self.refresh_token = refresh_token
        self.token_user_principal_name = token_user_principal_name
        self.token_user_display_name = token_user_display_name
        self.dataset = dataset
        self.table = table
        self.group_id = group_id
        self.group_name = group_name
        self.authentication_mode = authentication_mode


class PowerBIOutputDataSourceProperties(OAuthBasedDataSourceProperties):
    """The properties that are associated with a Power BI output.

    :param refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :type refresh_token: str
    :param token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :type token_user_principal_name: str
    :param token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :type token_user_display_name: str
    :param dataset: The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
    :type dataset: str
    :param table: The name of the Power BI table under the specified dataset. Required on PUT
     (CreateOrReplace) requests.
    :type table: str
    :param group_id: The ID of the Power BI group.
    :type group_id: str
    :param group_name: The name of the Power BI group. Use this property to help remember which
     specific Power BI group id was used.
    :type group_name: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    """

    _attribute_map = {
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'token_user_principal_name': {'key': 'tokenUserPrincipalName', 'type': 'str'},
        'token_user_display_name': {'key': 'tokenUserDisplayName', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'group_name': {'key': 'groupName', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        dataset: Optional[str] = None,
        table: Optional[str] = None,
        group_id: Optional[str] = None,
        group_name: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        **kwargs
    ):
        super(PowerBIOutputDataSourceProperties, self).__init__(refresh_token=refresh_token, token_user_principal_name=token_user_principal_name, token_user_display_name=token_user_display_name, **kwargs)
        self.dataset = dataset
        self.table = table
        self.group_id = group_id
        self.group_name = group_name
        self.authentication_mode = authentication_mode


class PrivateEndpoint(Resource):
    """Complete information about the private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param properties: The properties associated with a private endpoint.
    :type properties: ~stream_analytics_management_client.models.PrivateEndpointProperties
    :ivar etag: Unique opaque string (generally a GUID) that represents the metadata state of the
     resource (private endpoint) and changes whenever the resource is updated. Required on PUT
     (CreateOrUpdate) requests.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointProperties'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        properties: Optional["PrivateEndpointProperties"] = None,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.properties = properties
        self.etag = None


class PrivateEndpointListResult(msrest.serialization.Model):
    """A list of private endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of private endpoints.
    :vartype value: list[~stream_analytics_management_client.models.PrivateEndpoint]
    :ivar next_link: The URL to fetch the next set of private endpoints.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointProperties(msrest.serialization.Model):
    """The properties associated with a private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_date: The date when this private endpoint was created.
    :vartype created_date: str
    :param manual_private_link_service_connections: A list of connections to the remote resource.
     Immutable after it is set.
    :type manual_private_link_service_connections:
     list[~stream_analytics_management_client.models.PrivateLinkServiceConnection]
    """

    _validation = {
        'created_date': {'readonly': True},
    }

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'manual_private_link_service_connections': {'key': 'manualPrivateLinkServiceConnections', 'type': '[PrivateLinkServiceConnection]'},
    }

    def __init__(
        self,
        *,
        manual_private_link_service_connections: Optional[List["PrivateLinkServiceConnection"]] = None,
        **kwargs
    ):
        super(PrivateEndpointProperties, self).__init__(**kwargs)
        self.created_date = None
        self.manual_private_link_service_connections = manual_private_link_service_connections


class PrivateLinkConnectionState(msrest.serialization.Model):
    """A collection of read-only information about the state of the connection to the private remote resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the remote resource/service.
    :vartype status: str
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'readonly': True},
        'description': {'readonly': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkConnectionState, self).__init__(**kwargs)
        self.status = None
        self.description = None
        self.actions_required = None


class PrivateLinkServiceConnection(msrest.serialization.Model):
    """A grouping of information about the connection to the remote resource.

    :param private_link_service_id: The resource id of the private link service. Required on PUT
     (CreateOrUpdate) requests.
    :type private_link_service_id: str
    :param group_ids: The ID(s) of the group(s) obtained from the remote resource that this private
     endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
    :type group_ids: list[str]
    :param request_message: A message passed to the owner of the remote resource with this
     connection request. Restricted to 140 chars.
    :type request_message: str
    :param private_link_service_connection_state: A collection of read-only information about the
     state of the connection to the private remote resource.
    :type private_link_service_connection_state:
     ~stream_analytics_management_client.models.PrivateLinkConnectionState
    """

    _attribute_map = {
        'private_link_service_id': {'key': 'properties.privateLinkServiceId', 'type': 'str'},
        'group_ids': {'key': 'properties.groupIds', 'type': '[str]'},
        'request_message': {'key': 'properties.requestMessage', 'type': 'str'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
    }

    def __init__(
        self,
        *,
        private_link_service_id: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        request_message: Optional[str] = None,
        private_link_service_connection_state: Optional["PrivateLinkConnectionState"] = None,
        **kwargs
    ):
        super(PrivateLinkServiceConnection, self).__init__(**kwargs)
        self.private_link_service_id = private_link_service_id
        self.group_ids = group_ids
        self.request_message = request_message
        self.private_link_service_connection_state = private_link_service_connection_state


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class ReferenceInputProperties(InputProperties):
    """The properties that are associated with an input containing reference data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates whether the input is a source of reference data or stream
     data. Required on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param serialization: Describes how data from an input is serialized or how data is serialized
     when written to an output. Required on PUT (CreateOrReplace) requests.
    :type serialization: ~stream_analytics_management_client.models.Serialization
    :ivar diagnostics: Describes conditions applicable to the Input, Output, or the job overall,
     that warrant customer attention.
    :vartype diagnostics: ~stream_analytics_management_client.models.Diagnostics
    :ivar etag: The current entity tag for the input. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :param compression: Describes how input data is compressed.
    :type compression: ~stream_analytics_management_client.models.Compression
    :param partition_key: partitionKey Describes a key in the input data which is used for
     partitioning the input data.
    :type partition_key: str
    :param datasource: Describes an input data source that contains reference data. Required on PUT
     (CreateOrReplace) requests.
    :type datasource: ~stream_analytics_management_client.models.ReferenceInputDataSource
    """

    _validation = {
        'type': {'required': True},
        'diagnostics': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'serialization': {'key': 'serialization', 'type': 'Serialization'},
        'diagnostics': {'key': 'diagnostics', 'type': 'Diagnostics'},
        'etag': {'key': 'etag', 'type': 'str'},
        'compression': {'key': 'compression', 'type': 'Compression'},
        'partition_key': {'key': 'partitionKey', 'type': 'str'},
        'datasource': {'key': 'datasource', 'type': 'ReferenceInputDataSource'},
    }

    def __init__(
        self,
        *,
        serialization: Optional["Serialization"] = None,
        compression: Optional["Compression"] = None,
        partition_key: Optional[str] = None,
        datasource: Optional["ReferenceInputDataSource"] = None,
        **kwargs
    ):
        super(ReferenceInputProperties, self).__init__(serialization=serialization, compression=compression, partition_key=partition_key, **kwargs)
        self.type = 'Reference'  # type: str
        self.datasource = datasource


class ResourceTestStatus(msrest.serialization.Model):
    """Describes the status of the test operation along with error information, if applicable.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the test operation.
    :vartype status: str
    :ivar error: Describes the error that occurred.
    :vartype error: ~stream_analytics_management_client.models.ErrorResponse
    """

    _validation = {
        'status': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceTestStatus, self).__init__(**kwargs)
        self.status = None
        self.error = None


class ScalarFunctionProperties(FunctionProperties):
    """The properties that are associated with a scalar function.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of function.Constant filled by server.
    :type type: str
    :ivar etag: The current entity tag for the function. This is an opaque string. You can use it
     to detect whether the resource has changed between requests. You can also use it in the If-
     Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :param inputs:
    :type inputs: list[~stream_analytics_management_client.models.FunctionInput]
    :param output: Describes the output of a function.
    :type output: ~stream_analytics_management_client.models.FunctionOutput
    :param binding: The physical binding of the function. For example, in the Azure Machine
     Learning web service’s case, this describes the endpoint.
    :type binding: ~stream_analytics_management_client.models.FunctionBinding
    """

    _validation = {
        'type': {'required': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'inputs': {'key': 'properties.inputs', 'type': '[FunctionInput]'},
        'output': {'key': 'properties.output', 'type': 'FunctionOutput'},
        'binding': {'key': 'properties.binding', 'type': 'FunctionBinding'},
    }

    def __init__(
        self,
        *,
        inputs: Optional[List["FunctionInput"]] = None,
        output: Optional["FunctionOutput"] = None,
        binding: Optional["FunctionBinding"] = None,
        **kwargs
    ):
        super(ScalarFunctionProperties, self).__init__(inputs=inputs, output=output, binding=binding, **kwargs)
        self.type = 'Scalar'  # type: str


class ServiceBusQueueOutputDataSource(OutputDataSource):
    """Describes a Service Bus Queue output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param queue_name: The name of the Service Bus Queue. Required on PUT (CreateOrReplace)
     requests.
    :type queue_name: str
    :param property_columns: A string array of the names of output columns to be attached to
     Service Bus messages as custom properties.
    :type property_columns: list[str]
    :param system_property_columns: Dictionary of :code:`<string>`.
    :type system_property_columns: dict[str, str]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'properties.sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
        'queue_name': {'key': 'properties.queueName', 'type': 'str'},
        'property_columns': {'key': 'properties.propertyColumns', 'type': '[str]'},
        'system_property_columns': {'key': 'properties.systemPropertyColumns', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        queue_name: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        system_property_columns: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ServiceBusQueueOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.ServiceBus/Queue'  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.queue_name = queue_name
        self.property_columns = property_columns
        self.system_property_columns = system_property_columns


class ServiceBusQueueOutputDataSourceProperties(ServiceBusDataSourceProperties):
    """The properties that are associated with a Service Bus Queue output.

    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param queue_name: The name of the Service Bus Queue. Required on PUT (CreateOrReplace)
     requests.
    :type queue_name: str
    :param property_columns: A string array of the names of output columns to be attached to
     Service Bus messages as custom properties.
    :type property_columns: list[str]
    :param system_property_columns: Dictionary of :code:`<string>`.
    :type system_property_columns: dict[str, str]
    """

    _attribute_map = {
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'queue_name': {'key': 'queueName', 'type': 'str'},
        'property_columns': {'key': 'propertyColumns', 'type': '[str]'},
        'system_property_columns': {'key': 'systemPropertyColumns', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        queue_name: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        system_property_columns: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ServiceBusQueueOutputDataSourceProperties, self).__init__(service_bus_namespace=service_bus_namespace, shared_access_policy_name=shared_access_policy_name, shared_access_policy_key=shared_access_policy_key, authentication_mode=authentication_mode, **kwargs)
        self.queue_name = queue_name
        self.property_columns = property_columns
        self.system_property_columns = system_property_columns


class ServiceBusTopicOutputDataSource(OutputDataSource):
    """Describes a Service Bus Topic output data source.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates the type of data source output will be written to. Required on
     PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param topic_name: The name of the Service Bus Topic. Required on PUT (CreateOrReplace)
     requests.
    :type topic_name: str
    :param property_columns: A string array of the names of output columns to be attached to
     Service Bus messages as custom properties.
    :type property_columns: list[str]
    :param system_property_columns: Dictionary of :code:`<string>`.
    :type system_property_columns: dict[str, str]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'properties.sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'properties.authenticationMode', 'type': 'str'},
        'topic_name': {'key': 'properties.topicName', 'type': 'str'},
        'property_columns': {'key': 'properties.propertyColumns', 'type': '[str]'},
        'system_property_columns': {'key': 'properties.systemPropertyColumns', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        topic_name: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        system_property_columns: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ServiceBusTopicOutputDataSource, self).__init__(**kwargs)
        self.type = 'Microsoft.ServiceBus/Topic'  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.topic_name = topic_name
        self.property_columns = property_columns
        self.system_property_columns = system_property_columns


class ServiceBusTopicOutputDataSourceProperties(ServiceBusDataSourceProperties):
    """The properties that are associated with a Service Bus Topic output.

    :param service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type service_bus_namespace: str
    :param shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_name: str
    :param shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :type shared_access_policy_key: str
    :param authentication_mode: Authentication Mode. Possible values include: "Msi", "UserToken",
     "ConnectionString".
    :type authentication_mode: str or ~stream_analytics_management_client.models.AuthenticationMode
    :param topic_name: The name of the Service Bus Topic. Required on PUT (CreateOrReplace)
     requests.
    :type topic_name: str
    :param property_columns: A string array of the names of output columns to be attached to
     Service Bus messages as custom properties.
    :type property_columns: list[str]
    :param system_property_columns: Dictionary of :code:`<string>`.
    :type system_property_columns: dict[str, str]
    """

    _attribute_map = {
        'service_bus_namespace': {'key': 'serviceBusNamespace', 'type': 'str'},
        'shared_access_policy_name': {'key': 'sharedAccessPolicyName', 'type': 'str'},
        'shared_access_policy_key': {'key': 'sharedAccessPolicyKey', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'topic_name': {'key': 'topicName', 'type': 'str'},
        'property_columns': {'key': 'propertyColumns', 'type': '[str]'},
        'system_property_columns': {'key': 'systemPropertyColumns', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Optional[Union[str, "AuthenticationMode"]] = None,
        topic_name: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        system_property_columns: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ServiceBusTopicOutputDataSourceProperties, self).__init__(service_bus_namespace=service_bus_namespace, shared_access_policy_name=shared_access_policy_name, shared_access_policy_key=shared_access_policy_key, authentication_mode=authentication_mode, **kwargs)
        self.topic_name = topic_name
        self.property_columns = property_columns
        self.system_property_columns = system_property_columns


class StartStreamingJobParameters(msrest.serialization.Model):
    """Parameters supplied to the Start Streaming Job operation.

    :param output_start_mode: Value may be JobStartTime, CustomTime, or LastOutputEventTime to
     indicate whether the starting point of the output event stream should start whenever the job is
     started, start at a custom user time stamp specified via the outputStartTime property, or start
     from the last event output time. Possible values include: "JobStartTime", "CustomTime",
     "LastOutputEventTime".
    :type output_start_mode: str or ~stream_analytics_management_client.models.OutputStartMode
    :param output_start_time: Value is either an ISO-8601 formatted time stamp that indicates the
     starting point of the output event stream, or null to indicate that the output event stream
     will start whenever the streaming job is started. This property must have a value if
     outputStartMode is set to CustomTime.
    :type output_start_time: ~datetime.datetime
    """

    _attribute_map = {
        'output_start_mode': {'key': 'outputStartMode', 'type': 'str'},
        'output_start_time': {'key': 'outputStartTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        output_start_mode: Optional[Union[str, "OutputStartMode"]] = None,
        output_start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(StartStreamingJobParameters, self).__init__(**kwargs)
        self.output_start_mode = output_start_mode
        self.output_start_time = output_start_time


class StreamingJob(TrackedResource):
    """A streaming job object, containing all information associated with the named streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The geo-location where the resource lives.
    :type location: str
    :param identity: Describes the system-assigned managed identity assigned to this job that can
     be used to authenticate with inputs and outputs.
    :type identity: ~stream_analytics_management_client.models.Identity
    :param sku: Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
    :type sku: ~stream_analytics_management_client.models.StreamingJobSku
    :ivar job_id: A GUID uniquely identifying the streaming job. This GUID is generated upon
     creation of the streaming job.
    :vartype job_id: str
    :ivar provisioning_state: Describes the provisioning status of the streaming job.
    :vartype provisioning_state: str
    :ivar job_state: Describes the state of the streaming job.
    :vartype job_state: str
    :param job_type: Describes the type of the job. Valid modes are ``Cloud`` and 'Edge'. Possible
     values include: "Cloud", "Edge".
    :type job_type: str or ~stream_analytics_management_client.models.JobType
    :param output_start_mode: This property should only be utilized when it is desired that the job
     be started immediately upon creation. Value may be JobStartTime, CustomTime, or
     LastOutputEventTime to indicate whether the starting point of the output event stream should
     start whenever the job is started, start at a custom user time stamp specified via the
     outputStartTime property, or start from the last event output time. Possible values include:
     "JobStartTime", "CustomTime", "LastOutputEventTime".
    :type output_start_mode: str or ~stream_analytics_management_client.models.OutputStartMode
    :param output_start_time: Value is either an ISO-8601 formatted time stamp that indicates the
     starting point of the output event stream, or null to indicate that the output event stream
     will start whenever the streaming job is started. This property must have a value if
     outputStartMode is set to CustomTime.
    :type output_start_time: ~datetime.datetime
    :ivar last_output_event_time: Value is either an ISO-8601 formatted timestamp indicating the
     last output event time of the streaming job or null indicating that output has not yet been
     produced. In case of multiple outputs or multiple streams, this shows the latest value in that
     set.
    :vartype last_output_event_time: ~datetime.datetime
    :param events_out_of_order_policy: Indicates the policy to apply to events that arrive out of
     order in the input event stream. Possible values include: "Adjust", "Drop".
    :type events_out_of_order_policy: str or
     ~stream_analytics_management_client.models.EventsOutOfOrderPolicy
    :param output_error_policy: Indicates the policy to apply to events that arrive at the output
     and cannot be written to the external storage due to being malformed (missing column values,
     column values of wrong type or size). Possible values include: "Stop", "Drop".
    :type output_error_policy: str or ~stream_analytics_management_client.models.OutputErrorPolicy
    :param events_out_of_order_max_delay_in_seconds: The maximum tolerable delay in seconds where
     out-of-order events can be adjusted to be back in order.
    :type events_out_of_order_max_delay_in_seconds: int
    :param events_late_arrival_max_delay_in_seconds: The maximum tolerable delay in seconds where
     events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days)
     and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to
     have a value of -1.
    :type events_late_arrival_max_delay_in_seconds: int
    :param data_locale: The data locale of the stream analytics job. Value should be the name of a
     supported .NET Culture from the set https://msdn.microsoft.com/en-
     us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none
     specified.
    :type data_locale: str
    :param compatibility_level: Controls certain runtime behaviors of the streaming job. Possible
     values include: "1.0".
    :type compatibility_level: str or ~stream_analytics_management_client.models.CompatibilityLevel
    :ivar created_date: Value is an ISO-8601 formatted UTC timestamp indicating when the streaming
     job was created.
    :vartype created_date: ~datetime.datetime
    :param inputs: A list of one or more inputs to the streaming job. The name property for each
     input is required when specifying this property in a PUT request. This property cannot be
     modify via a PATCH operation. You must use the PATCH API available for the individual input.
    :type inputs: list[~stream_analytics_management_client.models.Input]
    :param transformation: Indicates the query and the number of streaming units to use for the
     streaming job. The name property of the transformation is required when specifying this
     property in a PUT request. This property cannot be modify via a PATCH operation. You must use
     the PATCH API available for the individual transformation.
    :type transformation: ~stream_analytics_management_client.models.Transformation
    :param outputs: A list of one or more outputs for the streaming job. The name property for each
     output is required when specifying this property in a PUT request. This property cannot be
     modify via a PATCH operation. You must use the PATCH API available for the individual output.
    :type outputs: list[~stream_analytics_management_client.models.Output]
    :param functions: A list of one or more functions for the streaming job. The name property for
     each function is required when specifying this property in a PUT request. This property cannot
     be modify via a PATCH operation. You must use the PATCH API available for the individual
     transformation.
    :type functions: list[~stream_analytics_management_client.models.Function]
    :ivar etag: The current entity tag for the streaming job. This is an opaque string. You can use
     it to detect whether the resource has changed between requests. You can also use it in the If-
     Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :param job_storage_account: The properties that are associated with an Azure Storage account
     with MSI.
    :type job_storage_account: ~stream_analytics_management_client.models.JobStorageAccount
    :ivar content_storage_policy: Valid values are JobStorageAccount and SystemAccount. If set to
     JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
     Possible values include: "SystemAccount", "JobStorageAccount".
    :vartype content_storage_policy: str or
     ~stream_analytics_management_client.models.ContentStoragePolicy
    :param externals: The storage account where the custom code artifacts are located.
    :type externals: ~stream_analytics_management_client.models.External
    :param cluster: The cluster which streaming jobs will run on.
    :type cluster: ~stream_analytics_management_client.models.ClusterInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'job_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'job_state': {'readonly': True},
        'last_output_event_time': {'readonly': True},
        'created_date': {'readonly': True},
        'etag': {'readonly': True},
        'content_storage_policy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'properties.sku', 'type': 'StreamingJobSku'},
        'job_id': {'key': 'properties.jobId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'job_state': {'key': 'properties.jobState', 'type': 'str'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'output_start_mode': {'key': 'properties.outputStartMode', 'type': 'str'},
        'output_start_time': {'key': 'properties.outputStartTime', 'type': 'iso-8601'},
        'last_output_event_time': {'key': 'properties.lastOutputEventTime', 'type': 'iso-8601'},
        'events_out_of_order_policy': {'key': 'properties.eventsOutOfOrderPolicy', 'type': 'str'},
        'output_error_policy': {'key': 'properties.outputErrorPolicy', 'type': 'str'},
        'events_out_of_order_max_delay_in_seconds': {'key': 'properties.eventsOutOfOrderMaxDelayInSeconds', 'type': 'int'},
        'events_late_arrival_max_delay_in_seconds': {'key': 'properties.eventsLateArrivalMaxDelayInSeconds', 'type': 'int'},
        'data_locale': {'key': 'properties.dataLocale', 'type': 'str'},
        'compatibility_level': {'key': 'properties.compatibilityLevel', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'inputs': {'key': 'properties.inputs', 'type': '[Input]'},
        'transformation': {'key': 'properties.transformation', 'type': 'Transformation'},
        'outputs': {'key': 'properties.outputs', 'type': '[Output]'},
        'functions': {'key': 'properties.functions', 'type': '[Function]'},
        'etag': {'key': 'properties.etag', 'type': 'str'},
        'job_storage_account': {'key': 'properties.jobStorageAccount', 'type': 'JobStorageAccount'},
        'content_storage_policy': {'key': 'properties.contentStoragePolicy', 'type': 'str'},
        'externals': {'key': 'properties.externals', 'type': 'External'},
        'cluster': {'key': 'properties.cluster', 'type': 'ClusterInfo'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        identity: Optional["Identity"] = None,
        sku: Optional["StreamingJobSku"] = None,
        job_type: Optional[Union[str, "JobType"]] = None,
        output_start_mode: Optional[Union[str, "OutputStartMode"]] = None,
        output_start_time: Optional[datetime.datetime] = None,
        events_out_of_order_policy: Optional[Union[str, "EventsOutOfOrderPolicy"]] = None,
        output_error_policy: Optional[Union[str, "OutputErrorPolicy"]] = None,
        events_out_of_order_max_delay_in_seconds: Optional[int] = None,
        events_late_arrival_max_delay_in_seconds: Optional[int] = None,
        data_locale: Optional[str] = None,
        compatibility_level: Optional[Union[str, "CompatibilityLevel"]] = None,
        inputs: Optional[List["Input"]] = None,
        transformation: Optional["Transformation"] = None,
        outputs: Optional[List["Output"]] = None,
        functions: Optional[List["Function"]] = None,
        job_storage_account: Optional["JobStorageAccount"] = None,
        externals: Optional["External"] = None,
        cluster: Optional["ClusterInfo"] = None,
        **kwargs
    ):
        super(StreamingJob, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.job_id = None
        self.provisioning_state = None
        self.job_state = None
        self.job_type = job_type
        self.output_start_mode = output_start_mode
        self.output_start_time = output_start_time
        self.last_output_event_time = None
        self.events_out_of_order_policy = events_out_of_order_policy
        self.output_error_policy = output_error_policy
        self.events_out_of_order_max_delay_in_seconds = events_out_of_order_max_delay_in_seconds
        self.events_late_arrival_max_delay_in_seconds = events_late_arrival_max_delay_in_seconds
        self.data_locale = data_locale
        self.compatibility_level = compatibility_level
        self.created_date = None
        self.inputs = inputs
        self.transformation = transformation
        self.outputs = outputs
        self.functions = functions
        self.etag = None
        self.job_storage_account = job_storage_account
        self.content_storage_policy = None
        self.externals = externals
        self.cluster = cluster


class StreamingJobListResult(msrest.serialization.Model):
    """Object containing a list of streaming jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of streaming jobs. Populated by a 'List' operation.
    :vartype value: list[~stream_analytics_management_client.models.StreamingJob]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StreamingJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StreamingJobListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class StreamingJobSku(msrest.serialization.Model):
    """The properties that are associated with a SKU.

    :param name: The name of the SKU. Required on PUT (CreateOrReplace) requests. Possible values
     include: "Standard".
    :type name: str or ~stream_analytics_management_client.models.StreamingJobSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "StreamingJobSkuName"]] = None,
        **kwargs
    ):
        super(StreamingJobSku, self).__init__(**kwargs)
        self.name = name


class StreamInputProperties(InputProperties):
    """The properties that are associated with an input containing stream data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Indicates whether the input is a source of reference data or stream
     data. Required on PUT (CreateOrReplace) requests.Constant filled by server.
    :type type: str
    :param serialization: Describes how data from an input is serialized or how data is serialized
     when written to an output. Required on PUT (CreateOrReplace) requests.
    :type serialization: ~stream_analytics_management_client.models.Serialization
    :ivar diagnostics: Describes conditions applicable to the Input, Output, or the job overall,
     that warrant customer attention.
    :vartype diagnostics: ~stream_analytics_management_client.models.Diagnostics
    :ivar etag: The current entity tag for the input. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :param compression: Describes how input data is compressed.
    :type compression: ~stream_analytics_management_client.models.Compression
    :param partition_key: partitionKey Describes a key in the input data which is used for
     partitioning the input data.
    :type partition_key: str
    :param datasource: Describes an input data source that contains stream data. Required on PUT
     (CreateOrReplace) requests.
    :type datasource: ~stream_analytics_management_client.models.StreamInputDataSource
    """

    _validation = {
        'type': {'required': True},
        'diagnostics': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'serialization': {'key': 'serialization', 'type': 'Serialization'},
        'diagnostics': {'key': 'diagnostics', 'type': 'Diagnostics'},
        'etag': {'key': 'etag', 'type': 'str'},
        'compression': {'key': 'compression', 'type': 'Compression'},
        'partition_key': {'key': 'partitionKey', 'type': 'str'},
        'datasource': {'key': 'datasource', 'type': 'StreamInputDataSource'},
    }

    def __init__(
        self,
        *,
        serialization: Optional["Serialization"] = None,
        compression: Optional["Compression"] = None,
        partition_key: Optional[str] = None,
        datasource: Optional["StreamInputDataSource"] = None,
        **kwargs
    ):
        super(StreamInputProperties, self).__init__(serialization=serialization, compression=compression, partition_key=partition_key, **kwargs)
        self.type = 'Stream'  # type: str
        self.datasource = datasource


class SubscriptionQuota(SubResource):
    """Describes the current quota for the subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar max_count: The max permitted usage of this resource.
    :vartype max_count: int
    :ivar current_count: The current usage of this resource.
    :vartype current_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'max_count': {'readonly': True},
        'current_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'max_count': {'key': 'properties.maxCount', 'type': 'int'},
        'current_count': {'key': 'properties.currentCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(SubscriptionQuota, self).__init__(name=name, **kwargs)
        self.max_count = None
        self.current_count = None


class SubscriptionQuotasListResult(msrest.serialization.Model):
    """Result of the GetQuotas operation. It contains a list of quotas for the subscription in a particular region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of quotas for the subscription in a particular region.
    :vartype value: list[~stream_analytics_management_client.models.SubscriptionQuota]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionQuota]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionQuotasListResult, self).__init__(**kwargs)
        self.value = None


class Transformation(SubResource):
    """A transformation object, containing all information associated with the named transformation. All transformations are contained under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param streaming_units: Specifies the number of streaming units that the streaming job uses.
    :type streaming_units: int
    :param query: Specifies the query that will be run in the streaming job. You can learn more
     about the Stream Analytics Query Language (SAQL) here:
     https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
    :type query: str
    :ivar etag: The current entity tag for the transformation. This is an opaque string. You can
     use it to detect whether the resource has changed between requests. You can also use it in the
     If-Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'streaming_units': {'key': 'properties.streamingUnits', 'type': 'int'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'etag': {'key': 'properties.etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        streaming_units: Optional[int] = None,
        query: Optional[str] = None,
        **kwargs
    ):
        super(Transformation, self).__init__(name=name, **kwargs)
        self.streaming_units = streaming_units
        self.query = query
        self.etag = None
