# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._scheduler_management_client_enums import *


class HttpAuthentication(msrest.serialization.Model):
    """HttpAuthentication.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: OAuthAuthentication, BasicAuthentication, ClientCertAuthentication.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Gets or sets the HTTP authentication type.Constant filled by server.
     Possible values include: "NotSpecified", "ClientCertificate", "ActiveDirectoryOAuth", "Basic".
    :type type: str or ~azure.mgmt.scheduler.models.HttpAuthenticationType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'ActiveDirectoryOAuth': 'OAuthAuthentication', 'Basic': 'BasicAuthentication', 'ClientCertificate': 'ClientCertAuthentication'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpAuthentication, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class BasicAuthentication(HttpAuthentication):
    """BasicAuthentication.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Gets or sets the HTTP authentication type.Constant filled by server.
     Possible values include: "NotSpecified", "ClientCertificate", "ActiveDirectoryOAuth", "Basic".
    :type type: str or ~azure.mgmt.scheduler.models.HttpAuthenticationType
    :param username: Gets or sets the username.
    :type username: str
    :param password: Gets or sets the password, return value will always be empty.
    :type password: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(BasicAuthentication, self).__init__(**kwargs)
        self.type = 'Basic'  # type: str
        self.username = username
        self.password = password


class ClientCertAuthentication(HttpAuthentication):
    """ClientCertAuthentication.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Gets or sets the HTTP authentication type.Constant filled by server.
     Possible values include: "NotSpecified", "ClientCertificate", "ActiveDirectoryOAuth", "Basic".
    :type type: str or ~azure.mgmt.scheduler.models.HttpAuthenticationType
    :param password: Gets or sets the certificate password, return value will always be empty.
    :type password: str
    :param pfx: Gets or sets the pfx certificate. Accepts certification in base64 encoding, return
     value will always be empty.
    :type pfx: str
    :param certificate_thumbprint: Gets or sets the certificate thumbprint.
    :type certificate_thumbprint: str
    :param certificate_expiration_date: Gets or sets the certificate expiration date.
    :type certificate_expiration_date: ~datetime.datetime
    :param certificate_subject_name: Gets or sets the certificate subject name.
    :type certificate_subject_name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'pfx': {'key': 'pfx', 'type': 'str'},
        'certificate_thumbprint': {'key': 'certificateThumbprint', 'type': 'str'},
        'certificate_expiration_date': {'key': 'certificateExpirationDate', 'type': 'iso-8601'},
        'certificate_subject_name': {'key': 'certificateSubjectName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        password: Optional[str] = None,
        pfx: Optional[str] = None,
        certificate_thumbprint: Optional[str] = None,
        certificate_expiration_date: Optional[datetime.datetime] = None,
        certificate_subject_name: Optional[str] = None,
        **kwargs
    ):
        super(ClientCertAuthentication, self).__init__(**kwargs)
        self.type = 'ClientCertificate'  # type: str
        self.password = password
        self.pfx = pfx
        self.certificate_thumbprint = certificate_thumbprint
        self.certificate_expiration_date = certificate_expiration_date
        self.certificate_subject_name = certificate_subject_name


class HttpRequest(msrest.serialization.Model):
    """HttpRequest.

    :param authentication: Gets or sets the authentication method of the request.
    :type authentication: ~azure.mgmt.scheduler.models.HttpAuthentication
    :param uri: Gets or sets the URI of the request.
    :type uri: str
    :param method: Gets or sets the method of the request.
    :type method: str
    :param body: Gets or sets the request body.
    :type body: str
    :param headers: Gets or sets the headers.
    :type headers: dict[str, str]
    """

    _attribute_map = {
        'authentication': {'key': 'authentication', 'type': 'HttpAuthentication'},
        'uri': {'key': 'uri', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'body': {'key': 'body', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        authentication: Optional["HttpAuthentication"] = None,
        uri: Optional[str] = None,
        method: Optional[str] = None,
        body: Optional[str] = None,
        headers: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(HttpRequest, self).__init__(**kwargs)
        self.authentication = authentication
        self.uri = uri
        self.method = method
        self.body = body
        self.headers = headers


class JobAction(msrest.serialization.Model):
    """JobAction.

    :param type: Gets or sets the job action type. Possible values include: "Http", "Https",
     "StorageQueue", "ServiceBusQueue", "ServiceBusTopic".
    :type type: str or ~azure.mgmt.scheduler.models.JobActionType
    :param request: Gets or sets the http requests.
    :type request: ~azure.mgmt.scheduler.models.HttpRequest
    :param queue_message: Gets or sets the storage queue message.
    :type queue_message: ~azure.mgmt.scheduler.models.StorageQueueMessage
    :param service_bus_queue_message: Gets or sets the service bus queue message.
    :type service_bus_queue_message: ~azure.mgmt.scheduler.models.ServiceBusQueueMessage
    :param service_bus_topic_message: Gets or sets the service bus topic message.
    :type service_bus_topic_message: ~azure.mgmt.scheduler.models.ServiceBusTopicMessage
    :param retry_policy: Gets or sets the retry policy.
    :type retry_policy: ~azure.mgmt.scheduler.models.RetryPolicy
    :param error_action: Gets or sets the error action.
    :type error_action: ~azure.mgmt.scheduler.models.JobErrorAction
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'request': {'key': 'request', 'type': 'HttpRequest'},
        'queue_message': {'key': 'queueMessage', 'type': 'StorageQueueMessage'},
        'service_bus_queue_message': {'key': 'serviceBusQueueMessage', 'type': 'ServiceBusQueueMessage'},
        'service_bus_topic_message': {'key': 'serviceBusTopicMessage', 'type': 'ServiceBusTopicMessage'},
        'retry_policy': {'key': 'retryPolicy', 'type': 'RetryPolicy'},
        'error_action': {'key': 'errorAction', 'type': 'JobErrorAction'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "JobActionType"]] = None,
        request: Optional["HttpRequest"] = None,
        queue_message: Optional["StorageQueueMessage"] = None,
        service_bus_queue_message: Optional["ServiceBusQueueMessage"] = None,
        service_bus_topic_message: Optional["ServiceBusTopicMessage"] = None,
        retry_policy: Optional["RetryPolicy"] = None,
        error_action: Optional["JobErrorAction"] = None,
        **kwargs
    ):
        super(JobAction, self).__init__(**kwargs)
        self.type = type
        self.request = request
        self.queue_message = queue_message
        self.service_bus_queue_message = service_bus_queue_message
        self.service_bus_topic_message = service_bus_topic_message
        self.retry_policy = retry_policy
        self.error_action = error_action


class JobCollectionDefinition(msrest.serialization.Model):
    """JobCollectionDefinition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets the job collection resource identifier.
    :vartype id: str
    :ivar type: Gets the job collection resource type.
    :vartype type: str
    :param name: Gets or sets the job collection resource name.
    :type name: str
    :param location: Gets or sets the storage account location.
    :type location: str
    :param tags: A set of tags. Gets or sets the tags.
    :type tags: dict[str, str]
    :param properties: Gets or sets the job collection properties.
    :type properties: ~azure.mgmt.scheduler.models.JobCollectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'JobCollectionProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["JobCollectionProperties"] = None,
        **kwargs
    ):
        super(JobCollectionDefinition, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = name
        self.location = location
        self.tags = tags
        self.properties = properties


class JobCollectionListResult(msrest.serialization.Model):
    """JobCollectionListResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the job collections.
    :vartype value: list[~azure.mgmt.scheduler.models.JobCollectionDefinition]
    :param next_link: Gets or sets the URL to get the next set of job collections.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobCollectionDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(JobCollectionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class JobCollectionProperties(msrest.serialization.Model):
    """JobCollectionProperties.

    :param sku: Gets or sets the SKU.
    :type sku: ~azure.mgmt.scheduler.models.Sku
    :param state: Gets or sets the state. Possible values include: "Enabled", "Disabled",
     "Suspended", "Deleted".
    :type state: str or ~azure.mgmt.scheduler.models.JobCollectionState
    :param quota: Gets or sets the job collection quota.
    :type quota: ~azure.mgmt.scheduler.models.JobCollectionQuota
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'state': {'key': 'state', 'type': 'str'},
        'quota': {'key': 'quota', 'type': 'JobCollectionQuota'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        state: Optional[Union[str, "JobCollectionState"]] = None,
        quota: Optional["JobCollectionQuota"] = None,
        **kwargs
    ):
        super(JobCollectionProperties, self).__init__(**kwargs)
        self.sku = sku
        self.state = state
        self.quota = quota


class JobCollectionQuota(msrest.serialization.Model):
    """JobCollectionQuota.

    :param max_job_count: Gets or set the maximum job count.
    :type max_job_count: int
    :param max_job_occurrence: Gets or sets the maximum job occurrence.
    :type max_job_occurrence: int
    :param max_recurrence: Gets or set the maximum recurrence.
    :type max_recurrence: ~azure.mgmt.scheduler.models.JobMaxRecurrence
    """

    _attribute_map = {
        'max_job_count': {'key': 'maxJobCount', 'type': 'int'},
        'max_job_occurrence': {'key': 'maxJobOccurrence', 'type': 'int'},
        'max_recurrence': {'key': 'maxRecurrence', 'type': 'JobMaxRecurrence'},
    }

    def __init__(
        self,
        *,
        max_job_count: Optional[int] = None,
        max_job_occurrence: Optional[int] = None,
        max_recurrence: Optional["JobMaxRecurrence"] = None,
        **kwargs
    ):
        super(JobCollectionQuota, self).__init__(**kwargs)
        self.max_job_count = max_job_count
        self.max_job_occurrence = max_job_occurrence
        self.max_recurrence = max_recurrence


class JobDefinition(msrest.serialization.Model):
    """JobDefinition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets the job resource identifier.
    :vartype id: str
    :ivar type: Gets the job resource type.
    :vartype type: str
    :ivar name: Gets the job resource name.
    :vartype name: str
    :param properties: Gets or sets the job properties.
    :type properties: ~azure.mgmt.scheduler.models.JobProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'JobProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["JobProperties"] = None,
        **kwargs
    ):
        super(JobDefinition, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.properties = properties


class JobErrorAction(msrest.serialization.Model):
    """JobErrorAction.

    :param type: Gets or sets the job error action type. Possible values include: "Http", "Https",
     "StorageQueue", "ServiceBusQueue", "ServiceBusTopic".
    :type type: str or ~azure.mgmt.scheduler.models.JobActionType
    :param request: Gets or sets the http requests.
    :type request: ~azure.mgmt.scheduler.models.HttpRequest
    :param queue_message: Gets or sets the storage queue message.
    :type queue_message: ~azure.mgmt.scheduler.models.StorageQueueMessage
    :param service_bus_queue_message: Gets or sets the service bus queue message.
    :type service_bus_queue_message: ~azure.mgmt.scheduler.models.ServiceBusQueueMessage
    :param service_bus_topic_message: Gets or sets the service bus topic message.
    :type service_bus_topic_message: ~azure.mgmt.scheduler.models.ServiceBusTopicMessage
    :param retry_policy: Gets or sets the retry policy.
    :type retry_policy: ~azure.mgmt.scheduler.models.RetryPolicy
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'request': {'key': 'request', 'type': 'HttpRequest'},
        'queue_message': {'key': 'queueMessage', 'type': 'StorageQueueMessage'},
        'service_bus_queue_message': {'key': 'serviceBusQueueMessage', 'type': 'ServiceBusQueueMessage'},
        'service_bus_topic_message': {'key': 'serviceBusTopicMessage', 'type': 'ServiceBusTopicMessage'},
        'retry_policy': {'key': 'retryPolicy', 'type': 'RetryPolicy'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "JobActionType"]] = None,
        request: Optional["HttpRequest"] = None,
        queue_message: Optional["StorageQueueMessage"] = None,
        service_bus_queue_message: Optional["ServiceBusQueueMessage"] = None,
        service_bus_topic_message: Optional["ServiceBusTopicMessage"] = None,
        retry_policy: Optional["RetryPolicy"] = None,
        **kwargs
    ):
        super(JobErrorAction, self).__init__(**kwargs)
        self.type = type
        self.request = request
        self.queue_message = queue_message
        self.service_bus_queue_message = service_bus_queue_message
        self.service_bus_topic_message = service_bus_topic_message
        self.retry_policy = retry_policy


class JobHistoryDefinition(msrest.serialization.Model):
    """JobHistoryDefinition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets the job history identifier.
    :vartype id: str
    :ivar type: Gets the job history resource type.
    :vartype type: str
    :ivar name: Gets the job history name.
    :vartype name: str
    :ivar properties: Gets or sets the job history properties.
    :vartype properties: ~azure.mgmt.scheduler.models.JobHistoryDefinitionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'JobHistoryDefinitionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobHistoryDefinition, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.properties = None


class JobHistoryDefinitionProperties(msrest.serialization.Model):
    """JobHistoryDefinitionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: Gets the start time for this job.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time for this job.
    :vartype end_time: ~datetime.datetime
    :ivar expected_execution_time: Gets the expected execution time for this job.
    :vartype expected_execution_time: ~datetime.datetime
    :ivar action_name: Gets the job history action name. Possible values include: "MainAction",
     "ErrorAction".
    :vartype action_name: str or ~azure.mgmt.scheduler.models.JobHistoryActionName
    :ivar status: Gets the job history status. Possible values include: "Completed", "Failed",
     "Postponed".
    :vartype status: str or ~azure.mgmt.scheduler.models.JobExecutionStatus
    :ivar message: Gets the message for the job history.
    :vartype message: str
    :ivar retry_count: Gets the retry count for job.
    :vartype retry_count: int
    :ivar repeat_count: Gets the repeat count for the job.
    :vartype repeat_count: int
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'expected_execution_time': {'readonly': True},
        'action_name': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
        'retry_count': {'readonly': True},
        'repeat_count': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'expected_execution_time': {'key': 'expectedExecutionTime', 'type': 'iso-8601'},
        'action_name': {'key': 'actionName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'repeat_count': {'key': 'repeatCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobHistoryDefinitionProperties, self).__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.expected_execution_time = None
        self.action_name = None
        self.status = None
        self.message = None
        self.retry_count = None
        self.repeat_count = None


class JobHistoryFilter(msrest.serialization.Model):
    """JobHistoryFilter.

    :param status: Gets or sets the job execution status. Possible values include: "Completed",
     "Failed", "Postponed".
    :type status: str or ~azure.mgmt.scheduler.models.JobExecutionStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "JobExecutionStatus"]] = None,
        **kwargs
    ):
        super(JobHistoryFilter, self).__init__(**kwargs)
        self.status = status


class JobHistoryListResult(msrest.serialization.Model):
    """JobHistoryListResult.

    :param value: Gets or sets the job histories under job.
    :type value: list[~azure.mgmt.scheduler.models.JobHistoryDefinition]
    :param next_link: Gets or sets the URL to get the next set of job histories.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobHistoryDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["JobHistoryDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(JobHistoryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JobListResult(msrest.serialization.Model):
    """JobListResult.

    :param value: Gets or sets all jobs under job collection.
    :type value: list[~azure.mgmt.scheduler.models.JobDefinition]
    :param next_link: Gets or sets the URL to get the next set of jobs.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["JobDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(JobListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JobMaxRecurrence(msrest.serialization.Model):
    """JobMaxRecurrence.

    :param frequency: Gets or sets the frequency of recurrence (second, minute, hour, day, week,
     month). Possible values include: "Minute", "Hour", "Day", "Week", "Month".
    :type frequency: str or ~azure.mgmt.scheduler.models.RecurrenceFrequency
    :param interval: Gets or sets the interval between retries.
    :type interval: int
    """

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        frequency: Optional[Union[str, "RecurrenceFrequency"]] = None,
        interval: Optional[int] = None,
        **kwargs
    ):
        super(JobMaxRecurrence, self).__init__(**kwargs)
        self.frequency = frequency
        self.interval = interval


class JobProperties(msrest.serialization.Model):
    """JobProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param start_time: Gets or sets the job start time.
    :type start_time: ~datetime.datetime
    :param action: Gets or sets the job action.
    :type action: ~azure.mgmt.scheduler.models.JobAction
    :param recurrence: Gets or sets the job recurrence.
    :type recurrence: ~azure.mgmt.scheduler.models.JobRecurrence
    :param state: Gets or set the job state. Possible values include: "Enabled", "Disabled",
     "Faulted", "Completed".
    :type state: str or ~azure.mgmt.scheduler.models.JobState
    :ivar status: Gets the job status.
    :vartype status: ~azure.mgmt.scheduler.models.JobStatus
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'JobAction'},
        'recurrence': {'key': 'recurrence', 'type': 'JobRecurrence'},
        'state': {'key': 'state', 'type': 'str'},
        'status': {'key': 'status', 'type': 'JobStatus'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        action: Optional["JobAction"] = None,
        recurrence: Optional["JobRecurrence"] = None,
        state: Optional[Union[str, "JobState"]] = None,
        **kwargs
    ):
        super(JobProperties, self).__init__(**kwargs)
        self.start_time = start_time
        self.action = action
        self.recurrence = recurrence
        self.state = state
        self.status = None


class JobRecurrence(msrest.serialization.Model):
    """JobRecurrence.

    :param frequency: Gets or sets the frequency of recurrence (second, minute, hour, day, week,
     month). Possible values include: "Minute", "Hour", "Day", "Week", "Month".
    :type frequency: str or ~azure.mgmt.scheduler.models.RecurrenceFrequency
    :param interval: Gets or sets the interval between retries.
    :type interval: int
    :param count: Gets or sets the maximum number of times that the job should run.
    :type count: int
    :param end_time: Gets or sets the time at which the job will complete.
    :type end_time: ~datetime.datetime
    :param schedule:
    :type schedule: ~azure.mgmt.scheduler.models.JobRecurrenceSchedule
    """

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'schedule': {'key': 'schedule', 'type': 'JobRecurrenceSchedule'},
    }

    def __init__(
        self,
        *,
        frequency: Optional[Union[str, "RecurrenceFrequency"]] = None,
        interval: Optional[int] = None,
        count: Optional[int] = None,
        end_time: Optional[datetime.datetime] = None,
        schedule: Optional["JobRecurrenceSchedule"] = None,
        **kwargs
    ):
        super(JobRecurrence, self).__init__(**kwargs)
        self.frequency = frequency
        self.interval = interval
        self.count = count
        self.end_time = end_time
        self.schedule = schedule


class JobRecurrenceSchedule(msrest.serialization.Model):
    """JobRecurrenceSchedule.

    :param week_days: Gets or sets the days of the week that the job should execute on.
    :type week_days: list[str or ~azure.mgmt.scheduler.models.DayOfWeek]
    :param hours: Gets or sets the hours of the day that the job should execute at.
    :type hours: list[int]
    :param minutes: Gets or sets the minutes of the hour that the job should execute at.
    :type minutes: list[int]
    :param month_days: Gets or sets the days of the month that the job should execute on. Must be
     between 1 and 31.
    :type month_days: list[int]
    :param monthly_occurrences: Gets or sets the occurrences of days within a month.
    :type monthly_occurrences:
     list[~azure.mgmt.scheduler.models.JobRecurrenceScheduleMonthlyOccurrence]
    """

    _attribute_map = {
        'week_days': {'key': 'weekDays', 'type': '[str]'},
        'hours': {'key': 'hours', 'type': '[int]'},
        'minutes': {'key': 'minutes', 'type': '[int]'},
        'month_days': {'key': 'monthDays', 'type': '[int]'},
        'monthly_occurrences': {'key': 'monthlyOccurrences', 'type': '[JobRecurrenceScheduleMonthlyOccurrence]'},
    }

    def __init__(
        self,
        *,
        week_days: Optional[List[Union[str, "DayOfWeek"]]] = None,
        hours: Optional[List[int]] = None,
        minutes: Optional[List[int]] = None,
        month_days: Optional[List[int]] = None,
        monthly_occurrences: Optional[List["JobRecurrenceScheduleMonthlyOccurrence"]] = None,
        **kwargs
    ):
        super(JobRecurrenceSchedule, self).__init__(**kwargs)
        self.week_days = week_days
        self.hours = hours
        self.minutes = minutes
        self.month_days = month_days
        self.monthly_occurrences = monthly_occurrences


class JobRecurrenceScheduleMonthlyOccurrence(msrest.serialization.Model):
    """JobRecurrenceScheduleMonthlyOccurrence.

    :param day: Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday,
     saturday, sunday. Possible values include: "Monday", "Tuesday", "Wednesday", "Thursday",
     "Friday", "Saturday", "Sunday".
    :type day: str or ~azure.mgmt.scheduler.models.JobScheduleDay
    :param occurrence: Gets or sets the occurrence. Must be between -5 and 5.
    :type occurrence: int
    """

    _attribute_map = {
        'day': {'key': 'day', 'type': 'str'},
        'occurrence': {'key': 'Occurrence', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        day: Optional[Union[str, "JobScheduleDay"]] = None,
        occurrence: Optional[int] = None,
        **kwargs
    ):
        super(JobRecurrenceScheduleMonthlyOccurrence, self).__init__(**kwargs)
        self.day = day
        self.occurrence = occurrence


class JobStateFilter(msrest.serialization.Model):
    """JobStateFilter.

    :param state: Gets or sets the job state. Possible values include: "Enabled", "Disabled",
     "Faulted", "Completed".
    :type state: str or ~azure.mgmt.scheduler.models.JobState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "JobState"]] = None,
        **kwargs
    ):
        super(JobStateFilter, self).__init__(**kwargs)
        self.state = state


class JobStatus(msrest.serialization.Model):
    """JobStatus.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar execution_count: Gets the number of times this job has executed.
    :vartype execution_count: int
    :ivar failure_count: Gets the number of times this job has failed.
    :vartype failure_count: int
    :ivar faulted_count: Gets the number of faulted occurrences (occurrences that were retried and
     failed as many times as the retry policy states).
    :vartype faulted_count: int
    :ivar last_execution_time: Gets the time the last occurrence executed in ISO-8601 format.
     Could be empty if job has not run yet.
    :vartype last_execution_time: ~datetime.datetime
    :ivar next_execution_time: Gets the time of the next occurrence in ISO-8601 format. Could be
     empty if the job is completed.
    :vartype next_execution_time: ~datetime.datetime
    """

    _validation = {
        'execution_count': {'readonly': True},
        'failure_count': {'readonly': True},
        'faulted_count': {'readonly': True},
        'last_execution_time': {'readonly': True},
        'next_execution_time': {'readonly': True},
    }

    _attribute_map = {
        'execution_count': {'key': 'executionCount', 'type': 'int'},
        'failure_count': {'key': 'failureCount', 'type': 'int'},
        'faulted_count': {'key': 'faultedCount', 'type': 'int'},
        'last_execution_time': {'key': 'lastExecutionTime', 'type': 'iso-8601'},
        'next_execution_time': {'key': 'nextExecutionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobStatus, self).__init__(**kwargs)
        self.execution_count = None
        self.failure_count = None
        self.faulted_count = None
        self.last_execution_time = None
        self.next_execution_time = None


class OAuthAuthentication(HttpAuthentication):
    """OAuthAuthentication.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Gets or sets the HTTP authentication type.Constant filled by server.
     Possible values include: "NotSpecified", "ClientCertificate", "ActiveDirectoryOAuth", "Basic".
    :type type: str or ~azure.mgmt.scheduler.models.HttpAuthenticationType
    :param secret: Gets or sets the secret, return value will always be empty.
    :type secret: str
    :param tenant: Gets or sets the tenant.
    :type tenant: str
    :param audience: Gets or sets the audience.
    :type audience: str
    :param client_id: Gets or sets the client identifier.
    :type client_id: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
        'tenant': {'key': 'tenant', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        secret: Optional[str] = None,
        tenant: Optional[str] = None,
        audience: Optional[str] = None,
        client_id: Optional[str] = None,
        **kwargs
    ):
        super(OAuthAuthentication, self).__init__(**kwargs)
        self.type = 'ActiveDirectoryOAuth'  # type: str
        self.secret = secret
        self.tenant = tenant
        self.audience = audience
        self.client_id = client_id


class RetryPolicy(msrest.serialization.Model):
    """RetryPolicy.

    :param retry_type: Gets or sets the retry strategy to be used. Possible values include: "None",
     "Fixed".
    :type retry_type: str or ~azure.mgmt.scheduler.models.RetryType
    :param retry_interval: Gets or sets the retry interval between retries, specify duration in ISO
     8601 format.
    :type retry_interval: ~datetime.timedelta
    :param retry_count: Gets or sets the number of times a retry should be attempted.
    :type retry_count: int
    """

    _attribute_map = {
        'retry_type': {'key': 'retryType', 'type': 'str'},
        'retry_interval': {'key': 'retryInterval', 'type': 'duration'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        retry_type: Optional[Union[str, "RetryType"]] = None,
        retry_interval: Optional[datetime.timedelta] = None,
        retry_count: Optional[int] = None,
        **kwargs
    ):
        super(RetryPolicy, self).__init__(**kwargs)
        self.retry_type = retry_type
        self.retry_interval = retry_interval
        self.retry_count = retry_count


class ServiceBusAuthentication(msrest.serialization.Model):
    """ServiceBusAuthentication.

    :param sas_key: Gets or sets the SAS key.
    :type sas_key: str
    :param sas_key_name: Gets or sets the SAS key name.
    :type sas_key_name: str
    :param type: Gets or sets the authentication type. Possible values include: "NotSpecified",
     "SharedAccessKey".
    :type type: str or ~azure.mgmt.scheduler.models.ServiceBusAuthenticationType
    """

    _attribute_map = {
        'sas_key': {'key': 'sasKey', 'type': 'str'},
        'sas_key_name': {'key': 'sasKeyName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sas_key: Optional[str] = None,
        sas_key_name: Optional[str] = None,
        type: Optional[Union[str, "ServiceBusAuthenticationType"]] = None,
        **kwargs
    ):
        super(ServiceBusAuthentication, self).__init__(**kwargs)
        self.sas_key = sas_key
        self.sas_key_name = sas_key_name
        self.type = type


class ServiceBusBrokeredMessageProperties(msrest.serialization.Model):
    """ServiceBusBrokeredMessageProperties.

    :param content_type: Gets or sets the content type.
    :type content_type: str
    :param correlation_id: Gets or sets the correlation ID.
    :type correlation_id: str
    :param force_persistence: Gets or sets the force persistence.
    :type force_persistence: bool
    :param label: Gets or sets the label.
    :type label: str
    :param message_id: Gets or sets the message ID.
    :type message_id: str
    :param partition_key: Gets or sets the partition key.
    :type partition_key: str
    :param reply_to: Gets or sets the reply to.
    :type reply_to: str
    :param reply_to_session_id: Gets or sets the reply to session ID.
    :type reply_to_session_id: str
    :param scheduled_enqueue_time_utc: Gets or sets the scheduled enqueue time UTC.
    :type scheduled_enqueue_time_utc: ~datetime.datetime
    :param session_id: Gets or sets the session ID.
    :type session_id: str
    :param time_to_live: Gets or sets the time to live.
    :type time_to_live: ~datetime.timedelta
    :param to: Gets or sets the to.
    :type to: str
    :param via_partition_key: Gets or sets the via partition key.
    :type via_partition_key: str
    """

    _attribute_map = {
        'content_type': {'key': 'contentType', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'force_persistence': {'key': 'forcePersistence', 'type': 'bool'},
        'label': {'key': 'label', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'partition_key': {'key': 'partitionKey', 'type': 'str'},
        'reply_to': {'key': 'replyTo', 'type': 'str'},
        'reply_to_session_id': {'key': 'replyToSessionId', 'type': 'str'},
        'scheduled_enqueue_time_utc': {'key': 'scheduledEnqueueTimeUtc', 'type': 'iso-8601'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'time_to_live': {'key': 'timeToLive', 'type': 'duration'},
        'to': {'key': 'to', 'type': 'str'},
        'via_partition_key': {'key': 'viaPartitionKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content_type: Optional[str] = None,
        correlation_id: Optional[str] = None,
        force_persistence: Optional[bool] = None,
        label: Optional[str] = None,
        message_id: Optional[str] = None,
        partition_key: Optional[str] = None,
        reply_to: Optional[str] = None,
        reply_to_session_id: Optional[str] = None,
        scheduled_enqueue_time_utc: Optional[datetime.datetime] = None,
        session_id: Optional[str] = None,
        time_to_live: Optional[datetime.timedelta] = None,
        to: Optional[str] = None,
        via_partition_key: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusBrokeredMessageProperties, self).__init__(**kwargs)
        self.content_type = content_type
        self.correlation_id = correlation_id
        self.force_persistence = force_persistence
        self.label = label
        self.message_id = message_id
        self.partition_key = partition_key
        self.reply_to = reply_to
        self.reply_to_session_id = reply_to_session_id
        self.scheduled_enqueue_time_utc = scheduled_enqueue_time_utc
        self.session_id = session_id
        self.time_to_live = time_to_live
        self.to = to
        self.via_partition_key = via_partition_key


class ServiceBusMessage(msrest.serialization.Model):
    """ServiceBusMessage.

    :param authentication: Gets or sets the Service Bus authentication.
    :type authentication: ~azure.mgmt.scheduler.models.ServiceBusAuthentication
    :param brokered_message_properties: Gets or sets the brokered message properties.
    :type brokered_message_properties:
     ~azure.mgmt.scheduler.models.ServiceBusBrokeredMessageProperties
    :param custom_message_properties: Gets or sets the custom message properties.
    :type custom_message_properties: dict[str, str]
    :param message: Gets or sets the message.
    :type message: str
    :param namespace: Gets or sets the namespace.
    :type namespace: str
    :param transport_type: Gets or sets the transport type. Possible values include:
     "NotSpecified", "NetMessaging", "AMQP".
    :type transport_type: str or ~azure.mgmt.scheduler.models.ServiceBusTransportType
    """

    _attribute_map = {
        'authentication': {'key': 'authentication', 'type': 'ServiceBusAuthentication'},
        'brokered_message_properties': {'key': 'brokeredMessageProperties', 'type': 'ServiceBusBrokeredMessageProperties'},
        'custom_message_properties': {'key': 'customMessageProperties', 'type': '{str}'},
        'message': {'key': 'message', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'transport_type': {'key': 'transportType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authentication: Optional["ServiceBusAuthentication"] = None,
        brokered_message_properties: Optional["ServiceBusBrokeredMessageProperties"] = None,
        custom_message_properties: Optional[Dict[str, str]] = None,
        message: Optional[str] = None,
        namespace: Optional[str] = None,
        transport_type: Optional[Union[str, "ServiceBusTransportType"]] = None,
        **kwargs
    ):
        super(ServiceBusMessage, self).__init__(**kwargs)
        self.authentication = authentication
        self.brokered_message_properties = brokered_message_properties
        self.custom_message_properties = custom_message_properties
        self.message = message
        self.namespace = namespace
        self.transport_type = transport_type


class ServiceBusQueueMessage(ServiceBusMessage):
    """ServiceBusQueueMessage.

    :param authentication: Gets or sets the Service Bus authentication.
    :type authentication: ~azure.mgmt.scheduler.models.ServiceBusAuthentication
    :param brokered_message_properties: Gets or sets the brokered message properties.
    :type brokered_message_properties:
     ~azure.mgmt.scheduler.models.ServiceBusBrokeredMessageProperties
    :param custom_message_properties: Gets or sets the custom message properties.
    :type custom_message_properties: dict[str, str]
    :param message: Gets or sets the message.
    :type message: str
    :param namespace: Gets or sets the namespace.
    :type namespace: str
    :param transport_type: Gets or sets the transport type. Possible values include:
     "NotSpecified", "NetMessaging", "AMQP".
    :type transport_type: str or ~azure.mgmt.scheduler.models.ServiceBusTransportType
    :param queue_name: Gets or sets the queue name.
    :type queue_name: str
    """

    _attribute_map = {
        'authentication': {'key': 'authentication', 'type': 'ServiceBusAuthentication'},
        'brokered_message_properties': {'key': 'brokeredMessageProperties', 'type': 'ServiceBusBrokeredMessageProperties'},
        'custom_message_properties': {'key': 'customMessageProperties', 'type': '{str}'},
        'message': {'key': 'message', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'transport_type': {'key': 'transportType', 'type': 'str'},
        'queue_name': {'key': 'queueName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authentication: Optional["ServiceBusAuthentication"] = None,
        brokered_message_properties: Optional["ServiceBusBrokeredMessageProperties"] = None,
        custom_message_properties: Optional[Dict[str, str]] = None,
        message: Optional[str] = None,
        namespace: Optional[str] = None,
        transport_type: Optional[Union[str, "ServiceBusTransportType"]] = None,
        queue_name: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusQueueMessage, self).__init__(authentication=authentication, brokered_message_properties=brokered_message_properties, custom_message_properties=custom_message_properties, message=message, namespace=namespace, transport_type=transport_type, **kwargs)
        self.queue_name = queue_name


class ServiceBusTopicMessage(ServiceBusMessage):
    """ServiceBusTopicMessage.

    :param authentication: Gets or sets the Service Bus authentication.
    :type authentication: ~azure.mgmt.scheduler.models.ServiceBusAuthentication
    :param brokered_message_properties: Gets or sets the brokered message properties.
    :type brokered_message_properties:
     ~azure.mgmt.scheduler.models.ServiceBusBrokeredMessageProperties
    :param custom_message_properties: Gets or sets the custom message properties.
    :type custom_message_properties: dict[str, str]
    :param message: Gets or sets the message.
    :type message: str
    :param namespace: Gets or sets the namespace.
    :type namespace: str
    :param transport_type: Gets or sets the transport type. Possible values include:
     "NotSpecified", "NetMessaging", "AMQP".
    :type transport_type: str or ~azure.mgmt.scheduler.models.ServiceBusTransportType
    :param topic_path: Gets or sets the topic path.
    :type topic_path: str
    """

    _attribute_map = {
        'authentication': {'key': 'authentication', 'type': 'ServiceBusAuthentication'},
        'brokered_message_properties': {'key': 'brokeredMessageProperties', 'type': 'ServiceBusBrokeredMessageProperties'},
        'custom_message_properties': {'key': 'customMessageProperties', 'type': '{str}'},
        'message': {'key': 'message', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'transport_type': {'key': 'transportType', 'type': 'str'},
        'topic_path': {'key': 'topicPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authentication: Optional["ServiceBusAuthentication"] = None,
        brokered_message_properties: Optional["ServiceBusBrokeredMessageProperties"] = None,
        custom_message_properties: Optional[Dict[str, str]] = None,
        message: Optional[str] = None,
        namespace: Optional[str] = None,
        transport_type: Optional[Union[str, "ServiceBusTransportType"]] = None,
        topic_path: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusTopicMessage, self).__init__(authentication=authentication, brokered_message_properties=brokered_message_properties, custom_message_properties=custom_message_properties, message=message, namespace=namespace, transport_type=transport_type, **kwargs)
        self.topic_path = topic_path


class Sku(msrest.serialization.Model):
    """Sku.

    :param name: Gets or set the SKU. Possible values include: "Standard", "Free", "P10Premium",
     "P20Premium".
    :type name: str or ~azure.mgmt.scheduler.models.SkuDefinition
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SkuDefinition"]] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name


class StorageQueueMessage(msrest.serialization.Model):
    """StorageQueueMessage.

    :param storage_account: Gets or sets the storage account name.
    :type storage_account: str
    :param queue_name: Gets or sets the queue name.
    :type queue_name: str
    :param sas_token: Gets or sets the SAS key.
    :type sas_token: str
    :param message: Gets or sets the message.
    :type message: str
    """

    _attribute_map = {
        'storage_account': {'key': 'storageAccount', 'type': 'str'},
        'queue_name': {'key': 'queueName', 'type': 'str'},
        'sas_token': {'key': 'sasToken', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account: Optional[str] = None,
        queue_name: Optional[str] = None,
        sas_token: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(StorageQueueMessage, self).__init__(**kwargs)
        self.storage_account = storage_account
        self.queue_name = queue_name
        self.sas_token = sas_token
        self.message = message
