# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementGalleryImageVersionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.gallery_image_versions.begin_create_or_update(
                resource_group_name=resource_group.name,
                gallery_name="str",
                gallery_image_name="str",
                gallery_image_version_name="str",
                gallery_image_version={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "publishingProfile": {
                        "source": {"managedImage": {"id": "str"}},
                        "endOfLifeDate": "2020-02-20 00:00:00",
                        "excludeFromLatest": bool,
                        "publishedDate": "2020-02-20 00:00:00",
                        "replicaCount": 0,
                        "targetRegions": [{"name": "str", "regionalReplicaCount": 0}],
                    },
                    "replicationStatus": {
                        "aggregatedState": "str",
                        "summary": [{"details": "str", "progress": 0, "region": "str", "state": "str"}],
                    },
                    "storageProfile": {
                        "dataDiskImages": [{"hostCaching": "str", "lun": 0, "sizeInGB": 0}],
                        "osDiskImage": {"hostCaching": "str", "sizeInGB": 0},
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2018-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.gallery_image_versions.get(
            resource_group_name=resource_group.name,
            gallery_name="str",
            gallery_image_name="str",
            gallery_image_version_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.gallery_image_versions.begin_delete(
                resource_group_name=resource_group.name,
                gallery_name="str",
                gallery_image_name="str",
                gallery_image_version_name="str",
                api_version="2018-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_gallery_image(self, resource_group):
        response = self.client.gallery_image_versions.list_by_gallery_image(
            resource_group_name=resource_group.name,
            gallery_name="str",
            gallery_image_name="str",
            api_version="2018-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
