/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2014 by The University of Queensland //
// Centre for Geoscience Computing                         //
// http://earth.uq.edu.au/centre-geoscience-computing      //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __LINESEGMENT2D_H
#define __LINESEGMENT2D_H

// --- Project includes ---
##include "Line.h"

/*!
  \brief class for a line in 2D
*/ 
class LineSegment2D : public Line2D
{
 public:
  LineSegment2D();
  LineSegment2D(const Vector3&,const Vector3&);
  virtual ~LineSegment2D();

  virtual double getDist(const Vector3&) const;
  
  friend ostream& operator<< (ostream&, const LineSegment2D&);
};

#endif // __LINESEGMENT2D_H 
