# Generated by Django 3.0.7 on 2020-08-31 14:20

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import netfields.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AggregateTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('network', netfields.fields.CidrAddressField(blank=True, default=None, max_length=43, null=True)),
                ('inet', netfields.fields.InetAddressField(blank=True, default=None, max_length=39, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='CidrArrayTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', django.contrib.postgres.fields.ArrayField(base_field=netfields.fields.CidrAddressField(max_length=43), blank=True, null=True, size=None)),
            ],
            options={
                'db_table': 'cidrarray',
            },
        ),
        migrations.CreateModel(
            name='CidrTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', netfields.fields.CidrAddressField(max_length=43)),
            ],
            options={
                'db_table': 'cidr',
            },
        ),
        migrations.CreateModel(
            name='InetArrayTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', django.contrib.postgres.fields.ArrayField(base_field=netfields.fields.InetAddressField(max_length=39), blank=True, null=True, size=None)),
            ],
            options={
                'db_table': 'inetarray',
            },
        ),
        migrations.CreateModel(
            name='InetTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', netfields.fields.InetAddressField(max_length=39)),
            ],
            options={
                'db_table': 'inet',
            },
        ),
        migrations.CreateModel(
            name='MACArrayTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', django.contrib.postgres.fields.ArrayField(base_field=netfields.fields.MACAddressField(), blank=True, null=True, size=None)),
            ],
            options={
                'db_table': 'macarray',
            },
        ),
        migrations.CreateModel(
            name='MACTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', netfields.fields.MACAddressField(null=True)),
            ],
            options={
                'db_table': 'mac',
            },
        ),
        migrations.CreateModel(
            name='NoPrefixInetTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', netfields.fields.InetAddressField(max_length=39)),
            ],
            options={
                'db_table': 'noprefixinet',
            },
        ),
        migrations.CreateModel(
            name='NullCidrTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', netfields.fields.CidrAddressField(max_length=43, null=True)),
            ],
            options={
                'db_table': 'nullcidr',
            },
        ),
        migrations.CreateModel(
            name='NullInetTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', netfields.fields.InetAddressField(max_length=39, null=True)),
            ],
            options={
                'db_table': 'nullinet',
            },
        ),
        migrations.CreateModel(
            name='UniqueCidrTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', netfields.fields.CidrAddressField(max_length=43, unique=True)),
            ],
            options={
                'db_table': 'uniquecidr',
            },
        ),
        migrations.CreateModel(
            name='UniqueInetTestModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', netfields.fields.InetAddressField(max_length=39, unique=True)),
            ],
            options={
                'db_table': 'uniqueinet',
            },
        ),
        migrations.CreateModel(
            name='AggregateTestChildModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('network', netfields.fields.CidrAddressField(max_length=43)),
                ('inet', netfields.fields.InetAddressField(max_length=39)),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='children', to='test.AggregateTestModel')),
            ],
        ),
    ]
